/* ==================================================== ======== ======= *
 *
 *  ufilebox.hh
 *  Ubit Project  [Elc][beta1][2001]
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ufilebox_hh
#define	_ufilebox_hh
//pragma ident	"@(#)ufilebox.hh	ubit:b1.11.0"


// shortcuts:
class UFilebox& ufilebox(UArgs = UArgs::none);

// OBSOLETE:
class UFileDialog& ufileDialog(UArgs = UArgs::none);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UFilebox : public UBox {
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  UFilebox(UArgs = UArgs::none);
  virtual ~UFilebox();

  const UStr* getDir() const;    // directory of the file (without name)
  const UStr* getName() const;   // name of the file (without directory)
  const UStr* getPath() const;   // full pathname:  directory/name
  const UStr* getFilter() const; // current extension filter

  //note that setDir and setFilter reload the directory
  UFilebox& setDir(const UStr&);
  void setDir(const UStr*);

  UFilebox& setName(const UStr&);
  void setName(const UStr*);

  UFilebox& setFilter(const UStr&);
  void setFilter(const UStr*);

  // sets the directory in a relative way:
  // -- goes to the parent directory if arg is ".."
  // -- goes to the sub-directory "xxx" if arg is "xxx"
  virtual void changeDir(UStr* dirpath);

  // rescans the directory and updates the display
  virtual void rescan();

  // The following functions implement the behavior of the FileDialog
  //   and may be freely redefined
  // OkBehavior() fires all 'UOn::action' callback functions or methods
  //   that are attached to the FileDialog:
  //   - method:    ufilebox(UOn::action / ucall(this, &MyClass::foo, arg))
  //   - function:  ufilebox(UOn::action / ucall(foo, arg))
  //
  virtual void OkBehavior(class UEvent*);
  virtual void CancelBehavior(class UEvent*);


protected:
  class UScrollPane *scrollpane;
  UBox *viewport;// la boite contenant les colonnes d'items
  UStr *fdir, *ffilter, *fname, *fpath;
  UButton *show_attributes, *show_dotfiles, *show_dirs_only;
};

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// OBSOLETE: use udialog(filebox())

class UFileDialog : public UDialog {
  UFilebox *filebox;
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  UFileDialog(UArgs = UArgs::none);

  // returns the included filebox
  UFilebox *getFilebox();

  // OBSOLETE
  char *getFileName();   // name of the file (without directory)
  char *getFileDir();    // directory of the file (without name)
  char *getFilePath();   // full pathname:  directory/name
  char *getFilterDir();  // current directoy in the filter

  // called by filebox::OkBehavior()
  void OkBehavior(UEvent* e);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

