/* ==================================================== ======== ======= *
 *
 *  uflow.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uflow_hh
#define	_uflow_hh
//pragma ident	"@(#)uflow.hh	ubit:b1.11.6"
#include <ubox.hh>


// UFlowbox = UBox with UFlowView renderer
//
class UFlowbox: public UBox {
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  UFlowbox(UArgs = UArgs::none);
};

UFlowbox& uflowbox(UArgs = UArgs::none);

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */

class UFlowCell {
public:
  u_dim width, height;
  u_bool truncated, newline;
  u_pos offset, len;
  UItemLink *ch;
};

class UFlowLine {
public:
  u_dim chw, chh;
  short cellix, hflexChildCount;
};


class UFlowView: public UView {
public:
  UFlowLine *lines;
  UFlowCell *cells;
  int alloc_linecount, alloc_cellcount;
  int used_linecount, used_cellcount;

public:
  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}
  
  // "static" constructor used by UViewStyle to make a new view
  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);
  UFlowView(UBoxLink*, UView* parview, UWinGraph*);
  virtual ~UFlowView();

  //package_private: ====[internal implementation]=======================

  virtual void getHints(UContext &parctx, class UViewLayout &vl);
  virtual u_bool doLayout(UContext&, class UViewLayout &vl);
  virtual void doUpdate(UContext&, URegion r, URegion clip, class UViewUpdate&);
  //NB: NOT virtual:
  u_bool locateItemPos(UContext&, ULink*, class UFlowCell*,
		       class UWinGraph&, const URegion&, 
		       class UViewUpdate &uc);
  u_bool locateItemPtr(UContext&, ULink*, class UFlowCell*,
		       class UWinGraph&, const URegion&, 
		       class UViewUpdate &uc);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:O1] ======= */

