/* ==================================================== ======== ======= *
 *
 *  ugadgets.hh
 *  Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _ugadgets_hh
#define	_ugadgets_hh
//pragma ident	"@(#)ugadgets.hh	ubit2000.15.3"


class ULabel: public UBox {
public:
  static const UClass  uclass;
  static UStyle *style;

  ULabel(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};

inline ULabel& ulabel(UArgs a = UArgs::none) {return *(new ULabel(a));}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UButton: public UBox {	// Opaque Button
public:
  static const UClass  uclass;
  // three contextual styles depending on the Button's parent
  static UStyle *style, *menuStyle, *barStyle;

  UButton(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};


class UTbutton: public UButton { //Transparent Button
public:
  static const UClass  uclass;
  // same menuStyle and barStyle as UButton
  static UStyle *style;

  UTbutton(UArgs a = UArgs::none) : UButton(a) {}
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};


inline UButton& ubutton(UArgs a = UArgs::none) {return *(new UButton(a));}
inline UTbutton& utbutton(UArgs a = UArgs::none) {return *(new UTbutton(a));}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UCheckbox: public UButton {	// Opaque UCheckbox
public:
  static const UClass  uclass;
  // three contextual styles depending on the Button's parent
  static UStyle *style, *menuStyle, *barStyle;

  UCheckbox(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};


class UTcheckbox: public UCheckbox {	// Transparent UCheckbox
public:
  static const UClass  uclass;
  // same menuStyle and barStyle as UButton
  static UStyle *style;

  UTcheckbox(UArgs a = UArgs::none) : UCheckbox(a) {}
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};


inline UCheckbox& ucheckbox(UArgs a = UArgs::none) {return *(new UCheckbox(a));};
inline UTcheckbox& utcheckbox(UArgs a = UArgs::none) {return *(new UTcheckbox(a));};

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

class UHref: public UButton {
public:
  static const UClass uclass;
  static UStyle *style;

  UHref(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};

inline UHref& uhref(UArgs a = UArgs::none) {return *(new UHref(a));}


class ULine: public UBox {
public:
  static const UClass  uclass;
  static UStyle *style;

  ULine(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};

inline ULine& uline(UArgs a = UArgs::none) {return *(new ULine(a));}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
//EX: UText remplace par UTextbox pour eviter ambiguites et collisions de noms

class UTextbox: public UBox {
public:
  static const UClass uclass;
  static UStyle *style;

  UTextbox(UArgs = UArgs::none);
  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);
};

inline UTextbox& utextbox(UArgs a = UArgs::none) {return *new UTextbox(a);}

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
