/* ==================================================== ======== ======= *
 *
 *  ustyle.hh
 *  Ubit Project [Elc::2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */

#ifndef _ustyle_hh
#define	_ustyle_hh
//pragma ident	"@(#)ustyle.hh	ubit:001.11.6"
#include <ucontext.hh>

class UStyle {
public:
  ULocalProps   local;
  const UFont   *font;
  const UCursor *cursor;
  const UBackground *background;
  const UColor  **fgcolors;
  const UColor  **bgcolors;
  const class UViewStyle *viewStyle;

  UStyle(const UStyle *model);
  void set(const UStyle *model);  //copies the model

  const UColor* getFG(const UCtrl *st) const;
  const UColor* getBG(const UCtrl *st) const;

  static const UColor** makeColors(UColor *off, UColor *on);
  void setFG(u_bool selected, int action, const UColor*);
  void setBG(u_bool selected, int action, const UColor*);
  // for both off and on modes
  void setFG(int action, const UColor*);
  void setBG(int action, const UColor*);

  static void setColor(const UColor**, int action, const UColor*);
  static void setColor(const UColor**, u_bool selected, 
		       int action, const UColor*);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
