/* ==================================================== ======== ======= *
 *
 *  uuflow.cc
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuflow.cc	ubit:b1.11.6"
#include <udefs.hh>
#include <ubrick.hh>
#include <ustr.hh>
#include <uctrl.hh>
#include <ucontext.hh>
#include <ubox.hh>
#include <ustyle.hh>
#include <uborder.hh>
#include <uview.hh>
#include <uviewImpl.hh>
#include <uflow.hh>
#include <utable.hh>
#include <ugraph.hh>
#include <ucolor.hh>
#include <uevent.hh>
#include <ucall.hh>
#include <uobs.hh>

#define WIDTH_HINT   200  //A_REVOIR
#define LINE_QUANTUM 20
#define CELL_QUANTUM 25

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

const UClass UFlowbox::uclass("UFlowbox");
UStyle *UFlowbox::style = null;

const UStyle* UFlowbox::getStyle(const UBox *parent) {
  if (!style) {
    style = new UStyle(null);
    style->viewStyle      = &UFlowView::style;
    style->local.orient   = UOrient::horizontal.get();
    style->local.halign   = UHalign::flex.get();
    style->local.valign   = UValign::flex.get();
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    style->local.padding.set(0, 0);
  }
  return style;
}

UFlowbox::UFlowbox(UArgs a): UBox(a) {}
UFlowbox& uflowbox(UArgs l) {return *(new UFlowbox(l));}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UViewStyle UFlowView::style(&UFlowView::makeView, UMode::UCONST);

UFlowView::UFlowView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) 
  : UView(box_link, par_view, wgraph) {
  lines = null;
  cells = null;
  alloc_linecount = alloc_cellcount = 0;
  used_linecount = used_cellcount = 0;
}

// "static" constructor used by UViewStyle to make a new view

UView* UFlowView::makeView(UBoxLink*bl, UView* parview, 
			      UWinGraph *wgraph){
  return new UFlowView(bl, parview, wgraph);
}

UFlowView::~UFlowView() {
  if (lines) {free(lines); lines = null;}
  if (cells) {free(cells); cells = null;}
  alloc_linecount = 0;
  alloc_cellcount = 0;
  used_linecount = 0;
  used_cellcount = 0;
  //printf("delete ~UFlowView()\n");
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

static void flowGetHints(UView *view, UContext &curp, 
			 UGroup *grp, UViewLayout &vl);


void UFlowView::getHints(UContext &parp, UViewLayout &vl) {
  UBox *box = getBox();
  box->flexCount = 0; // ne sert a rien ds ce cas

  vl.spec_w = vl.spec_h = -1;
  vl.cmin_w = vl.cmax_w = 0;
  vl.cmin_h = vl.cmax_h = 0;
  vl.line_h = vl.line_w = 0;

  UContext curp(box, this, parp);
  //getHints2(box, parp, this, vl);
  flowGetHints(this, curp, box, vl);
  
  // ce qui suit = utile ?

  // -- uwidth(int) with int >= 0   : size fixed by argument and won't change
  // -- uwidth(UWidth::keepSize) : will take initial size and won't change
  // value >=0 means: "fixed width"
  if (vl.spec_w >= UWidth::keepSize) { 

    // vl.wmode = UViewLayout::FIXED_BY_CHILD;

    if (/*!curp.boxIsHFlex ||*/ width <=0) {   // w <=0 : initialization
      // favorite doit etre le MAX de la taille desiree et de la taille
      // requise par les enfants (sinon le scroll ne marchera pas dans
      // le 1e cas et le 'flex' ne marchera pas dans le second)
      favoriteWidth = U_MAX(vl.spec_w, vl.cmax_w);
      //fixedSizes = FIXED_WIDTH;
      setVmodes(UView::FIXED_WIDTH, true);

      if (vl.spec_w == UWidth::keepSize)
	width = favoriteWidth; //init to favorite
      else
	width = vl.spec_w;//init to spec.
    }
  }
  else {
    favoriteWidth = vl.cmax_w;
    //obs: if (!vl.keepSize) width = favoriteWidth;
    width = favoriteWidth;
    //else if(keepSize) valeur precedente de width conservee
 }

  if (vl.spec_h >= UHeight::keepSize) { 
    // vl.hmode = UViewLayout::FIXED_BY_CHILD;

    if (/*!curp.boxIsVFlex ||*/ height <=0) {  // w <=0 : initialization
      // voir note pour favorite_w ci-dessus.
      favoriteHeight = U_MAX(vl.spec_h, vl.cmax_h);
      setVmodes(UView::FIXED_HEIGHT, true);

      if (vl.spec_h == UHeight::keepSize)
	height = favoriteHeight; //init to favorite
      else
	height = vl.spec_h;// init to spec.
    }
  }
  else {
    favoriteHeight = vl.cmax_h;
    //obs: if (!vl.keepSize) height = favoriteHeight;
    height = favoriteHeight;
  }
  
  //box->flexCount = vd.flexCount; // ??
  ///shown = false;
};


/* ==================================================== ======== ======= */

static void alaligne(UViewLayout &vl, UContext &curp) {
  // vl.wmax est le max de toutes les lignes
  vl.cmax_w = U_MAX(vl.cmax_w, vl.line_w);
  vl.cmax_h += vl.line_h += curp.local.vspacing; // moins 1 fois
  vl.line_w = 0;
  vl.line_h = 0;
  //printf("**alalaligne\n\n");
}

/* ==================================================== ======== ======= */

static void Insecables(UStr *str, UViewLayout &vl, UContext &curp) {
  UFlowCell cell;
  u_dim chww = 0;
  int startchar = 0;
  do {
    cell.offset = startchar;

    // decouper en tokens INSECABLEs
    str->getSize(&curp, 2,/*MAX = 2 pour s''arreter au 1er separ*/ 
		 chww/*%%*/, &cell);
  
    static char tmp[1000];
    {int k;
    for (k = 0; k < cell.len; k++)
      tmp[k] = str->chars()[startchar+k];
    tmp[k] = 0;
    }

    //printf("Insecables:str->getSize: '%s'\n     nbchars:%d, width:%d, trunc:%d chww:%d \n", 
    //   tmp, cell.len, cell.width, cell.truncated, chww);
    
    if (cell.width > 0) {
      // l'element devra avoir une taille au moins egale a celle de
      // son plus grand enfant INSECABLE
      vl.cmin_w = U_MAX(vl.cmin_w, cell.width);
      vl.cmin_h += cell.height;

      // pour une ligne
      vl.line_w += cell.width; // moins 1 fois a la fin
      vl.line_h = U_MAX(vl.line_h, cell.height);
      startchar += cell.len;
      //sauf q'on passe a la ligne a chaque mot

      if (str->chars()[startchar-1] == '\n') {
	// CR en fin de string ==> passer a la ligne
	//	printf("Insecables1:ligne\n");
	alaligne(vl, curp);
      }
    }
    else {
      // Apparemment on ne passe jamais par la....
      //      printf("Insecables2:ligne\n");
      alaligne(vl, curp);
      startchar += cell.len;
    }
  } while (startchar < str->length());
}

/* ==================================================== ======== ======= */

static void flowGetHints(UView *view, UContext &curp, 
			 UGroup *grp, UViewLayout &vl) {
  //ULink *ch = view->doPrelude(grp, curp);
  UMultiList mlist(curp, grp);

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...
  
  if (curp.local.content) {
    //getHints2(curp.local.content, curp, view, vl);
    // pas de curp, meme vd
    UGroup *content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    flowGetHints(view, curp, content, vl);
  }

  //for ( ; ch != null; ch = ch->next())
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
      
	UBrick *b = ch->brick();
	UView *chboxview = null;
	UViewLayout chvl;  //!att: reset by constr.
	UGroup *chgrp = null;

	if (b->propCast())  
	  b->propCast()->putProp(&curp, grp);
	
	else if (b->itemCast()) {
	  // HYPOTHESE: 
	  // tout a la suite quand c'est possible
	  // si <br> ou \n ou impose par type passer alaligne !!!

	  // cas particulier des UStr: trouver aussi la taille min, si un seul mot
	  // par ligne
	  UStr *str = b->strCast();
	  if (str)
	    Insecables(str, vl, curp);
	  else {
	    // pour tous les items: taille nominale des UPix et taille 'naturelle'
	    // (= si il n'y avait pas de contrainte) des UStr
	    b->itemCast()->getSize(&curp, &(chvl.spec_w), &(chvl.spec_h));
	    
	    // l'element devra avoir une taille au moins egale a celle de
	    // son plus grand enfant
	    vl.cmin_w = U_MAX(vl.cmin_w, chvl.spec_w);
	    vl.cmin_h += chvl.spec_h;

	    // pour une ligne
	    vl.line_w += chvl.spec_w + curp.local.hspacing; // moins 1 fois a la fin
	    vl.line_h = U_MAX(vl.line_h, chvl.spec_h);
	  }
	} //end(itemCast)

	
	else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {

	  if (b->boxCast()) {  // QUE boxCast
	    
	    //if (chgrp->isDef(0,UMode::INBOX)) {
	    if (chgrp->isDef(0,UMode::BOX)) {

	      //!att: UBoxLink ou WinLink!
	      if ((chboxview = ((UBoxLink*)ch)->getView(view))) {

		if (chgrp->isDef(0, UMode::FLOATING) 
		    || ch->floatingCast()) {
		  //vd.mustLayoutAgain |=
		  chboxview->doLayout(curp, chvl);
		}

		else {
		  //cas (tcell ou table)
		  if (chboxview->getViewStyle() == &UFlowView::style)
		    ((UFlowView*)chboxview)->getHints(curp, chvl);

		  //else if(chboxview->getViewStyle() == &UTableView::style) 
		  //((UTableView*)chboxview)->getHints(&curp, chvl);

		  // autres objets
		  else chboxview->doLayout(curp, chvl);

		  /////!!if (alaligne_debut) alaligne(vl, curp);!!!!!

		  // l'element devra avoir une taille au moins egale a celle
		  // de la taille min de son plus grand enfant insecable
		  vl.cmin_w = U_MAX(vl.cmin_w, chvl.cmin_w);
		  vl.cmin_h += chvl.cmin_h;
		  
		  // pour une ligne
		  vl.line_w += chvl.cmax_w + curp.local.hspacing;// moins 1 fois a la fin
		  vl.line_h = U_MAX(vl.line_h, chvl.cmax_h);
		  
		  ////!!!!!!if (alaligne_fin) alaligne(vl, curp);!!!!
		}
	      }
	    } //endif(UMode::INBOX)
	  }
	  else { //just an UGroup
	    //getHints2(chgrp, curp, view, vl);
	    // own curp, same vd
	    UContext chcurp(chgrp, view, curp);
	    flowGetHints(view, chcurp, chgrp, vl);
	  }
	}
    }

  // la suite ne concerne pas les UGroup
  if (grp->boxCast()) {

    // a la ligne final
    // Les UTcell COMMENCENT et se TERMINENT par un alaligne! A COMPTER!!
    alaligne(vl, curp);

    // NOTE That: value >=0 means: "fixed width"
    vl.spec_w = curp.local.width;
    vl.spec_h = curp.local.height;
    // whint et hhint seront negatifs si indefinis
    // ==> ne PAS y toucher, meme si definis et < valeurs min
 
    // retrancher le spacing compte en trop (si au moins un element)
    if (vl.cmax_w > 0) vl.cmax_w -= curp.local.hspacing; 
    if (vl.cmax_h > 0) vl.cmax_h -= curp.local.vspacing; 

    // rajouters  borders et marges
    UMargin margin(0, 0);
    if (curp.local.border)
      //curp.local.border->getSize(view,  &curp, &margin);
      curp.local.border->doLayout(view, curp, margin);

    int aux = margin.left + margin.right
      + curp.local.padding.left + curp.local.padding.right;
    vl.cmin_w += aux;
    vl.cmax_w += aux;

    aux = margin.top + margin.bottom 
      + curp.local.padding.top + curp.local.padding.bottom ;
    vl.cmin_h += aux;
    vl.cmax_h += aux;
  } 
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

UFlowCell *u_firstCell(UFlowView *view) {
  UFlowCell *pc;
  // peut avoir ete alloue lors d'un precedent appel de Layout()
  if (view->cells && view->alloc_cellcount > 0) {
    pc = view->cells;
  }
  else {
    view->alloc_cellcount = CELL_QUANTUM;
    pc = view->cells =
      (UFlowCell*) malloc(sizeof(UFlowCell) * view->alloc_cellcount);
  }
  pc->len = 0;			/*%%*/
  pc->newline = false;		// important!
  pc->truncated = false;
  return pc;
}


UFlowCell *u_nextCell(UFlowView *view, UFlowCell *pcell) {
  UFlowCell *pc;

  if (pcell < view->cells + view->alloc_cellcount-1)
    pc = pcell+1;
  else  {
    view->cells = (UFlowCell*) realloc(view->cells, sizeof(UFlowCell)
				 * (view->alloc_cellcount + CELL_QUANTUM));
    pc = view->cells + view->alloc_cellcount;
    view->alloc_cellcount += CELL_QUANTUM;
  }
  pc->newline = false;		// important!
  pc->truncated = false;
  return pc;
}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

UFlowLine *u_firstLine(UFlowView *view) {
  UFlowLine *pl;

  // peut avoir ete alloue lors d'un precedent appel de Layout()
  if (view->lines && view->alloc_linecount > 0) {
    pl = view->lines;
  }
  else {
    view->alloc_linecount = LINE_QUANTUM;
    view->lines = (UFlowLine*) malloc(sizeof(UFlowLine) * view->alloc_linecount);
    pl = view->lines;
  } 

  pl->cellix = -1; // points to nothing
  pl->chw = 0;
  pl->chh = 0;
  pl->hflexChildCount = 0;
  return pl;
}


UFlowLine *u_nextLine(UFlowView *view, UContext *curp, 
		      UFlowLine *pline, int &lines_maxw) {
  UFlowLine *pl;

  //calculer la MAX taille des la ligne a chaque chgt de ligne
  if (pline->chw > lines_maxw) lines_maxw = pline->chw;

  // add height of the last pline (and add interline)
  view->favoriteHeight += curp->local.vspacing + pline->chh;

  if (pline < view->lines + view->alloc_linecount-1)
    pl = pline+1;

  else  {
    view->lines = (UFlowLine*) realloc(view->lines, sizeof(UFlowLine)
				 * (view->alloc_linecount + LINE_QUANTUM));
    pl = view->lines + view->alloc_linecount;
    view->alloc_linecount += LINE_QUANTUM;
  }

  pl->cellix = -1; // points to nothing
  pl->chw = 0;
  pl->chh = 0;
  pl->hflexChildCount = 0;
  return pl;
}


static void addCellToLine(UFlowView *view, UContext *curp, 
			  UFlowLine *pline, UFlowCell *pcell) {

  // number of horizontally "flex"ible child objects
  if (curp->local.halign == UView::HFLEX) 
    pline->hflexChildCount++;

  // line height is the max of all cell heights
  if (pcell->height > pline->chh)   // max()
    pline->chh = pcell->height;

  // update line width
  pline->chw += pcell->width;

  // pline does not contain any cell
  if (pline->cellix < 0) {
    pline->cellix = pcell - view->cells; // noter l'index (because of realloc)
    pcell->newline = true;
  }
  // add horizontal spacing to separe this cell from previous cell
  else pline->chw += curp->local.hspacing;
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

struct UFlowLayoutData : public ULayoutData {
  int maxwidth, lines_maxw;
  class UFlowCell *pcell;
  class UFlowLine *pline;

  // vrai par construction
  UFlowView* fview() {return (UFlowView*)view;}

  UFlowLayoutData(UFlowView *v) : ULayoutData(v) {
    pcell = u_firstCell(v);
    pline = u_firstLine(v);
  }
};

/* ==================================================== ======== ======= */

static void flowDoLayout(UFlowLayoutData &vd, UContext &curp, 
			 UGroup *grp, UMultiList &mlist);


u_bool UFlowView::doLayout(UContext &parp, UViewLayout &vl) {
  //getHints(parp, vl);
  UFlowLayoutData vd(this);

  UBox *box = getBox();
  box->flexCount = 0; // ne sert a rien ds ce cas

  UContext curp(box, this, parp);

  //ULink *lastprelude = doPrelude(box, curp);
  UMultiList mlist(curp, box);

  // Border and Box size
  UMargin margin(0, 0);
  if (curp.local.border) 
    //curp.local.border->getSize(vd.view, &curp, &margin);
    curp.local.border->doLayout(vd.view, curp, margin);

  // value >=0 means: "fixed size hint" / should be >= 0 in this case

  if (vl.strategy == UViewLayout::IMPOSE_WSIZE) {
    //imposer la taille donnee par parent;
    //    printf("vl.spec_w=%d\n", vl.spec_w);
    curp.local.width = width = vl.spec_w;
  }
  else {
    // le pbm est qu'un flow n'a pas de taille intrinseque. on prend
    // donc une base de WIDTH_HINT mais en pratique il faudra
    // rendre le flow 'boxIsHFlex' pour qu'il s'adapte toujours
    // a la taille de son parent

    if (curp.local.width < 0) curp.local.width = WIDTH_HINT;
    if (!curp.boxIsHFlex || width <=0)  width = curp.local.width;
  }

  vd.maxwidth = width - margin.left - margin.right 
    - curp.local.padding.left - curp.local.padding.right;

  if (vd.maxwidth < 0) vd.maxwidth = 0; // securite 

  //calculer la MAX taille des la ligne : init a 0
  vd.lines_maxw = 0;

  // IMPORTANT:
  // Height depend de Width pour les UFlowView
  // ceci impose de refaire une seconde fois le layout du parent
  // (sauf dans le cas ou Width est fixe a priori auquel cas Height
  // (peut directement etre determine des la premier passe)
  //
  if (curp.boxIsHFlex) vd.mustLayoutAgain = true;
  favoriteWidth = vd.maxwidth;
  favoriteHeight = 0;

  flowDoLayout(vd, curp, box, mlist);

  // remove the last cell which is never used
  used_cellcount = vd.pcell - cells;

  // add the last line

  favoriteHeight  += vd.pline->chh;
  if (vd.pline->chw > vd.lines_maxw) {
    vd.lines_maxw = vd.pline->chw;
    //printf("--1 -lines_maxw: %d -- box: %d\n", vd.lines_maxw, box);
  }

  used_linecount = vd.pline - lines + 1; // il faut +1 !!

  /** if (vd.pline->chw <= 0 &&vd.lines_maxw <= 0 ){
      printf("vd.pline->chw %d  vd.lines_maxw %d  linecount= %d  prec->chw %d\n", 
      vd.pline->chw , vd.lines_maxw, used_linecount,
      (vd.pline-1)->chw);
      }
  **/

  vl.spec_w = curp.local.width;  // negatif si indefini

  // value >=0 means: "fixed size hint"
  if (curp.local.width >= 0)
    //@@vl.wmode = UViewLayout::FIXED_BY_CHILD;

  // Compute horizontal size to the max of vd.pline->chw
  // if (!curp.boxIsHFlex || width <=0) {  ??pourquoi c'est pas ca ???
  if (!curp.boxIsHFlex) {
    //printf("--fa -lines_maxw: %d -- box: %d\n", vd.lines_maxw, box);
    //printf("--fa -maxwidth: %d -- box: %d\n\n", vd.maxwidth, box);

    favoriteWidth = vd.lines_maxw + margin.left + margin.right 
      + curp.local.padding.left + curp.local.padding.right;

    // favorite doit etre le MAX de la taille desiree et de la taille
    // requise par les enfants (sinon le scroll ne marchera pas dans
    // le 1e cas et le 'flex' ne marchera pas dans le second)
    favoriteWidth = U_MAX(curp.local.width, favoriteWidth);
    width = curp.local.width;
  }
  else {
    //printf("--fb -lines_maxw: %d -- box: %d\n", vd.lines_maxw, box);
    //printf("--fb -maxwidth: %d -- box: %d\n", vd.maxwidth, box);

    favoriteWidth
      = vd.lines_maxw + margin.left + margin.right 
      + curp.local.padding.left + curp.local.padding.right;
    //obs: if (!vl.keepSize) width = favoriteWidth;
    width = favoriteWidth;
  }
  //printf("--final -width: %d -- box: %d\n\n", width, box);

  vl.spec_h = curp.local.height; //negatif si indefini

  // Compute vertical size (either fixed or content adjusted)
  if (curp.local.height >= 0) {

    //vl.hmode = UViewLayout::FIXED_BY_CHILD;

    if (!curp.boxIsVFlex || height <=0) {  // w <=0 : initialization
      //h = favorite_h = curp.local.height;
      favoriteHeight += margin.top + margin.bottom 
	+ curp.local.padding.top + curp.local.padding.bottom ;
      // voir note pour favorite_w ci-dessus.
      favoriteHeight = U_MAX(curp.local.height,  favoriteHeight);
      height = curp.local.height;
    }
  }
  else {
    favoriteHeight += margin.top + margin.bottom
      + curp.local.padding.top + curp.local.padding.bottom ;
    //obs:if (!vl.keepSize) height = favoriteHeight;
    height = favoriteHeight;
  }
  
  ///shown = false;
  vl.cmin_w = vl.cmax_w = width;
  vl.cmin_h = vl.cmax_h = height;
  return vd.mustLayoutAgain;  // true if must lay out again
}


/* ==================================================== ======== ======= */
//!! curp pas parp!

static void flowDoLayout(UFlowLayoutData &vd, UContext &curp, 
			 UGroup *grp, UMultiList &mlist) {

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...

  if (curp.local.content) {
    //groupFlowDoLayout(vd, curp.local.content, curp);
    // pas de curp, meme vd
    UGroup* content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    UMultiList mlist2(curp, content);
    flowDoLayout(vd, curp, content, mlist2);
  }

  // Process Item and Box children (Windows are ignored)
  //for ( ; ch != null; ch = ch->next()) 
  for (ULink *ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->brick();
      UView *chboxview = null;
      UItem *it = null;
      UViewLayout chvl;  //!att: reinit par contr.
      UGroup *chgrp = null; //!att reinit!
      
      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);
      
      //else if ((chgrp = b->groupNotBoxCast())
      else if ((chgrp = dynamic_cast<UGroup*>(b))
	       && chgrp->isDef(0,UMode::GROUP)
	       ) {
	if (chgrp->isShowable()) {
	  // own curp, same vd
	  UContext chcurp(chgrp, vd.view, curp);
	  UMultiList chmlist(chcurp, chgrp);
	  flowDoLayout(vd, chcurp, chgrp, chmlist);
	}
      }
      
      // UItems + UBoxes, UWins
      else if ((it = b->itemCast())
	       ||
	       (chgrp
		&& chgrp->isShowable()
		&& chgrp->isDef(0, UMode::BOX)
		&& (chboxview = ((UBoxLink*)ch)->getView(vd.view)))
	       ) {

	///!! PASSER A LA LIGNE COMME POUR HINTS;
	//!!! oubli des interlignes!

	UStr *str = (it ? it->strCast() : null);
	if (str) {
	  int startchar = 0;
	  do {
	  AGAIN:
	    vd.pcell->ch = (UItemLink*)ch;
	    vd.pcell->offset = startchar;
	    str->getSize(&curp, vd.maxwidth - vd.pline->chw, 
			 vd.pline->chw, vd.pcell);
	    
	    if (vd.pcell->width >= 0) {
	      
	      // ajouter cell a line si au moins un caractere
	      if (vd.pcell->len > 0) {
		
		// cas ou il y avait deja qq chose avant et ca ne tient pas: 
		// => passer a la ligne et recommencer 
		
		if (vd.pline->chw + vd.pcell->width > vd.maxwidth
		    && vd.pline->chw > 0) {
		  
		  /**if (vd.pline->chw > vd.lines_maxw) {
		     vd.lines_maxw = vd.pline->chw;
		     }
		  **/
		  vd.pline = u_nextLine(vd.fview(), &curp, vd.pline,
					vd.lines_maxw);
		  vd.pcell = u_nextCell(vd.fview(), vd.pcell-1); // reinitialize *vd.pcell
		  goto AGAIN;
		}
		addCellToLine(vd.fview(), &curp, vd.pline, vd.pcell);
	      }
	      
	      // si cell tronquee => passer a la ligne APRES
	      if (vd.pcell->truncated) {
		
		/** if (vd.pline->chw > vd.lines_maxw) {
		    vd.lines_maxw = vd.pline->chw;
		    }
		**/
		vd.pline = u_nextLine(vd.fview(), &curp, vd.pline,
				      vd.lines_maxw);
		startchar += vd.pcell->len;
	      }
	      else startchar = 0;
	      
	      // passer a cell suivante (la meme si count == 0)
	      if (vd.pcell->len > 0) vd.pcell = u_nextCell(vd.fview(), vd.pcell);
	      else vd.pcell = u_nextCell(vd.fview(), vd.pcell-1); // reinitialize *vd.pcell
	    }
	    
	    else {
	      // cas ou on a un retour a la ligne
	      vd.pcell->width = -vd.pcell->width-1;  /*%%*/ //-1 ajoute
	      addCellToLine(vd.fview(), &curp, vd.pline, vd.pcell);
	      
	      /*if (vd.pline->chw > vd.lines_maxw) {
		vd.lines_maxw = vd.pline->chw;
		}*/
	      vd.pline = u_nextLine(vd.fview(), &curp, vd.pline,
				    vd.lines_maxw);
	      startchar += vd.pcell->len; 
	      vd.pcell = u_nextCell(vd.fview(), vd.pcell); 
	    }
	    
	  }
	  // continuer si la ligne a ete tronquee
	  // (ne pas tester: vd.pcell->truncated puisque vd.pcell a chang!)
	  while (startchar > 0);
	  
	} // endif(str)
	
	
	// cas des enfants autre que UStr : sous-cas a)
	// -a- cas des floating
	
	else if ((chgrp && chgrp->isDef(0, UMode::FLOATING))
		 || ch->floatingCast()) {
	  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
	}
	
	// cas des enfants autre que UStr: sous-cas b)
	// -b- tout le reste excepte les floating
	
	else {
	  vd.pcell->ch = (UItemLink*)ch;
	  
	  if (it) it->getSize(&curp, &(vd.pcell->width), &(vd.pcell->height));
	  else {
	    chboxview->doLayout(curp, chvl);
	    vd.pcell->width = chboxview->getWidth();
	    vd.pcell->height = chboxview->getHeight();
	    
	    // pour les UFlowView, ils doivent prendre toute la place disponible 
	    // pour le parent, donc passage a la ligne avant si lines_maxw 
	    // et taille = maxwidth !

	    if (chboxview->getViewStyle() == &UFlowView::style) {
	      
	      //TEST QUI FAIT PASSER A LA LIGNE **AVANT** UFlow imbrique
	      if (vd.pline->chw >0) 
		vd.pline = u_nextLine(vd.fview(), &curp, vd.pline,
				      vd.lines_maxw);

	      // chboxview->w  modifie !!
	      chboxview->setWidth(vd.maxwidth);
	      vd.pcell->width = vd.maxwidth;
	    }
	
	    //recommencer
	    chboxview->doLayout(curp, chvl);

	    if (chboxview->getViewStyle() == &UFlowView::style)
	      vd.pcell->width = chboxview->getWidth();
	    
	    vd.pcell->height = chboxview->getHeight();   //#####???bizarre
	  }
	  
	  // passe a la ligne si pas assez de place 
	  // SAUF si la ligne est vide (auquel ca ca depassera: tant pis !)
	  if (vd.pline->chw + vd.pcell->width > vd.maxwidth
	      && vd.pline->chw > 0) {

	    /*if (vd.pline->chw > vd.lines_maxw) {
	      vd.lines_maxw = vd.pline->chw;
	      }*/
	    vd.pline = u_nextLine(vd.fview(), &curp, vd.pline, 
				  vd.lines_maxw);
	  }
	  
	  addCellToLine(vd.fview(), &curp, vd.pline, vd.pcell);
	  
	  //TEST QUI FAIT PASSER A LA LIGNE **APRES** UFlow imbrique
	  if (chboxview && chboxview->getViewStyle() == &UFlowView::style) {
	    vd.pline = u_nextLine(vd.fview(), &curp, vd.pline, 
				  vd.lines_maxw);
	  }
	  
	  vd.pcell = u_nextCell(vd.fview(), vd.pcell);
	}
      }
    } // endfor ( ; ch...)
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

struct UFlowUpdateImpl : public UUpdateImpl {
  int line_y;
  UFlowLine *first_line, *pline;
  UFlowCell *pcell;

  // vrai par construction
  UFlowView* fview() {return (UFlowView*)view;}

  UFlowUpdateImpl(UFlowView *v, const URegion &r, UViewUpdate &vup, 
		  UFlowLine *lines, UFlowCell *cells)
    : UUpdateImpl(v, r, vup) {
    first_line = lines;
    pline = lines - 1;
    pcell = cells - 1;
  }
};

/* ==================================================== ======== ======= */
//NB: mode SearchItem: juste recuperer l'item et sa position sans redessiner
//!ATT il faut IMPERATIVEMENT itemData != null dans le mode SearchItem !
//NB: clip est passe en valeur, pas r

static void flowDoUpdate(UFlowUpdateImpl&, UContext &curp, 
			 UGroup *grp, UMultiList &mlist, 
			 UWinGraph &g, const URegion &r, URegion &clip, 
			 UViewUpdate &vup);

void UFlowView::doUpdate(UContext &parp, URegion r, URegion clip, 
			 UViewUpdate &vup) {
  UBox *box = getBox();
  // item is not visible because of scrolling, etc...
  // l'intersection de clip et de r est affectee dans clip
  // (test pas valable pour les FLOATING car coords changees ensuite)
  if (!box->isDef(0, UMode::FLOATING)) {
    if (clip.setInter(r) == 0) return;
  }
  if (!lines || !cells || used_linecount <= 0 || used_cellcount <=0) 
    return;

  UFlowUpdateImpl vd(this, r, vup, lines, cells);
  UContext curp(box, this, parp);

  //ULink *lastprelude = doPrelude(box, curp);
  UMultiList mlist(curp, box);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  if (box->isDef(0, UMode::FLOATING)) {
    vd.setFloating(curp, box, r);
    if (clip.setInter(r) == 0) return;
  }

  {
    UWinGraph &g = curp.winview->wg();
    int gmode = 0;
    
    // setClip peut provoquer un seg fault si appele avec des donnees non
    // initialisee (et c'est le cas pour les operations LOCATE sans PAINT)
    if (vup.mode < UViewUpdate::LOCATE_ITEM_POS) {    // ou < UPDATE_DATA ??? !!! 
      //sub-hardwin incrustee X -> decaler les coords
      if (box->isDef(0, UMode::SUB_HARDWIN))
	gmode = g.beginShifted(clip,-r.x,-r.y); 
      //pas de blending (mais le background est peut etre none)
      else if (curp.local.alpha == 1.)
	gmode = g.begin(clip);
      //translucent --> NB: serait OK pour les groups ???
      else {
	gmode = g.beginBlended(clip, r);
	//!!!penser locate;
      }
      //NB: ne pas oublier de TOUJOURS faire g.end() !
    }

    vd.chclip.set(clip);
    // (nb: vd.margin init. by updateBackgroundAndBorder)
    vd.backgroundAndBorder(g, curp, r);

    vd.line_y = r.y + vd.margin.top; // !!!

    // clipping limits
    // (nb: vd.margin init. by updateBackgroundAndBorder)
    vd.chclip.set(r.x + vd.margin.left, r.y + vd.margin.top,
		  r.width - vd.margin.right, r.height - vd.margin.bottom);

    // pas la peine de chercher a afficher les enfants
    // s'ils sont hors zone de clip
    if (vd.chclip.setInter(clip) != 0)
      flowDoUpdate(vd, curp, box, mlist, g, r, clip, vup);
 
    g.endAll(gmode, r);
  }

  //NB: finalisation par destructeur de UFlowUpdateImpl vd
}

/* ==================================================== ======== ======= */

static void flowDoUpdate(UFlowUpdateImpl &vd, UContext &curp, 
			 UGroup *grp, UMultiList &mlist, UWinGraph &g, 
			 const URegion &r, URegion &clip, UViewUpdate &vup) {
  vd.flex_space = 0;

  // ce qui suit est errone: c'est au niveau des lignes que Valign
  // devrait intervenir et non au niveau des blocs de texte (car cette
  // fonctionnalite a peu de sens et produit un effet deconcertant dans
  // les scrollpanes (le texte serait alors centre au lieu de commencer
  // en haut de la zone d'affichage!)
  /*
  switch (curp.local.valign) {
  case TOP:
  case VFLEX:
    line_y = r.y + margin.top;
    break;
  case VCENTER: {
    vd.chr.height = 0; 
    for(int i=0; i<used_linecount; i++) vd.chr.height += (lines+i)->chh;
    line_y = (r.height - vd.chr.height) / 2;
    // box smaller than child ==> impose top margin
    if (line_y < margin.top)  line_y = margin.top;
    line_y += r.y;
    break;
  }
  case BOTTOM: {
    vd.chr.height = 0; 
    for(int i=0; i<used_linecount; i++) vd.chr.height += (lines+i)->chh;
    line_y = r.height - margin.bottom - vd.chr.height;
    // box smaller than child ==> impose top margin
    if (line_y < margin.top)  line_y = margin.top;
    line_y += r.y;
    break;
  }
  }
  */

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...
  
  if (curp.local.content) {
    // same curp, same vd
    UGroup* content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    UMultiList mlist2(curp, content);
    flowDoUpdate(vd, curp, content, mlist2, g, r, clip, vup);
  }

  //for ( ; ch != null; ch = ch->next())
  for (ULink* ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {

      UBrick *b = ch->brick();
      UView *chboxview = null;
      UItem *it = null; 
      UGroup *chgrp = null; //!att reinit!

      if (b->propCast())  
	b->propCast()->putProp(&curp, grp);

      else if ((chgrp = dynamic_cast<UGroup*>(b))
		 && chgrp->isDef(0, UMode::GROUP)
	       ) {
	if (chgrp->isShowable()) {
	  // own curp, same vd
	  UContext chcurp(chgrp, vd.view, curp);
	  UMultiList chmlist(chcurp, chgrp);
	  flowDoUpdate(vd, chcurp, chgrp, chmlist, g, r, clip, vup);
	}
      }

      // UItems + UBoxes, UWins
      else if ((it = b->itemCast())
	       ||
	       (chgrp
		&& chgrp->isShowable()
		&& chgrp->isDef(0, UMode::BOX)
		&& (chboxview = ((UBoxLink*)ch)->getView(vd.view)))
	       ) {

	// 1::cas des Floating
	if ((chgrp && chgrp->isDef(0, UMode::FLOATING))
	    || ch->floatingCast()) {

	  URegion fl_chr; //chr for floatings
	  chboxview->getSize(fl_chr.width, fl_chr.height);
	  
	  if (ch->floatingCast()) {
	    // transformer les coords relatives en coords absolues
	    // puis afficher l'objet a cet endroit precis
	    //chboxview->x = 
	    fl_chr.x = r.x + vd.margin.left + ch->floatingCast()->getX();
	    //chboxview->y = 
	    fl_chr.y = r.y + vd.margin.top + ch->floatingCast()->getY();
	  }
	  else {
	    //!att: on rajoute la MARGE: les coords sont locales 
	    // % a l'INTERIEUR du CADRE et non % a l'origine de la Box.
	    fl_chr.x = r.x + vd.margin.left;
	    fl_chr.y = r.y + vd.margin.top;
	    // coords relatives rajoutees ensuite dans doUpdate
	  }
	  
	  chboxview->doUpdate(curp, fl_chr, vd.chclip, vup);
	}

	// 2::tous les autres objets
	
	else while (true) {
	  
	  vd.pcell++;

	  if (vd.pcell->newline) {
	    vd.pline++;
	    
	    //HALIGN
	    vd.flex_space = 0;
	  
	    // there are flexible objects => use all space
	    /**** fait chier cette merde: tout en LEFT
	    if (vd.pline->hflexChildCount > 0)  {
	      vd.chr.x = r.x + vd.margin.left;
	      vd.flex_space = 
		(r.width - vd.pline->chw - vd.margin.left -vd.margin.right)
		/ vd.pline->hflexChildCount;
	      vd.pline->chw = r.width - vd.margin.left - vd.margin.right;
	    }
	    else 
	    ****/
	    switch (curp.local.halign) {
	    case UView::LEFT:
	      vd.chr.x = r.x + vd.margin.left;
	      break;
	    
	    case UView::HCENTER:
	      vd.chr.x = (r.width - vd.pline->chw) / 2;
	      // box smaller than child ==> impose left margin
	      if (vd.chr.x < vd.margin.left)  vd.chr.x = vd.margin.left;
	      vd.chr.x += r.x;
	      break;
	  
	    case UView::RIGHT: 
	      vd.chr.x = r.width - vd.pline->chw - vd.margin.right;
	      // box smaller than child ==> impose left margin
	      if (vd.chr.x < vd.margin.left)  vd.chr.x = vd.margin.left;
	      vd.chr.x += r.x;
	      break;

	    default:
	      // cas d'erreur divers et aussi les HFLEX que l'on a avire
	      vd.chr.x = r.x + vd.margin.left;
	      break;
	    }

	    if (vd.pline != vd.first_line) {
	      vd.line_y += (vd.pline-1)->chh + curp.local.vspacing;
	    }
	  } // endif(newline)


	  // VALIGN
	  /*
	  switch (curp.local.valign) {
	  case V_BOTTOM:
	  case V_CENTER:
	  case V_TOP:
	  case V_FLEX:
	  */

	  // !NOTE: pour les Items FLEX == CENTER
	  // Cas BOX et FLEX
	  if (!it && curp.local.valign == UView::VFLEX) {
	    // !!!elc25jun: A VOIR: different de uuview !!!
	    vd.chr.height = vd.pline->chh; // adapter sur max de tous les enfants
	    //vd.chr.y = r.y + vd.margin.top; 
	    vd.chr.y = vd.line_y;
	  }
	  else {
	    vd.chr.height = vd.pcell->height;
	    //vd.chr.y = r.y + vd.margin.top; 
	    vd.chr.y = vd.line_y;
	  }


	  // flexible horizontal object  ==>  add flexible width space
	  if (curp.local.halign == UView::HFLEX)
	    vd.chr.width = vd.pcell->width + vd.flex_space;
	  else vd.chr.width = vd.pcell->width;


	  if (vd.chr.width > 0 && vd.chr.height > 0) {

	    //pas un item => c'est forcement un Box
	    if (!it) chboxview->doUpdate(curp, vd.chr, vd.chclip, vup);
	    else {

	      //NB: ITEM_OPS => vd.can_paint == false mais pas l'inverse !
	      if (vd.can_paint
		  && vd.chr.y + vd.chr.height > vd.chclip.y
		  && vd.chr.y < vd.chclip.y + vd.chclip.height) {
		g.setClip(vd.chclip);
		UStr *str = (it ? it->strCast() : null);
		if (str) str->paint(g, &curp, vd.chr, vd.pcell);
		else it->paint(g, &curp, vd.chr);
	      }
	      
	      else if (vup.mode >= UViewUpdate::LOCATE_ITEM_POS) {
		// do not draw, just find Item

		if (vup.mode == UViewUpdate::LOCATE_ITEM_POS) {
		  if (vd.fview()->locateItemPos(curp, ch, vd.pcell, 
						g, vd.chr, vup))
		    return;
		}
		else if (vup.mode == UViewUpdate::LOCATE_ITEM_PTR) {
		  if (vd.fview()->locateItemPtr(curp, ch, vd.pcell, 
						g, vd.chr, vup))
		    return;
		}
	      }
	    }

	    // increment vd.chr.x in all cases
	    vd.chr.x += vd.chr.width + curp.local.hspacing;
	  
	  } // endif (vd.chr.width > 0 && vd.chr.height > 0)

	  if (!vd.pcell->truncated) break; // revenir au for()
	} // endwhile(true)
	
      } // endif
    } // endfor

  // call callbacks (desormais appeles en fin de traitement)
  if (vd.can_paint 
      && grp->isDef(UMode::VIEW_PAINT_CB|UMode::VIEW_CHANGE_CB,0)) 
    vd.callbacks(grp, curp.winview);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// retrieves item and info from x,y position
//!!ATT: 
// - suppose que itemData!= null !
// - return==true signifie: ne pas chercher davantage car:
//                trouve' OU pas trouve' mais plus la peine de chercher
// - return==false signifie: continuer a chercher car:
//                pas trouve' mais on peut encore trouver 
//

u_bool UFlowView::locateItemPos(UContext &props, 
				ULink *link, UFlowCell *cell,
				UWinGraph &g, 
				const URegion &r, UViewUpdate &vup) {
  if (r.y > vup.e->getYwin()) return true;  // plus rien a chercher (not found)
  UItem *item;
  UStr *str;

  if (vup.e->getYwin() >= r.y && vup.e->getYwin() <= r.y + r.height
      && ((item = link->brick()->itemCast()))
      ) {

    if (r.x <= vup.e->getXwin()) {
 
      int strpos = -1;
      //if ((str = dynamic_cast<UStr*>(item))) {
      if ((str = item->strCast())) {
	strpos = cell->offset          	// search the strpos
	  + g.getCharPos(&props.fontdesc, 
			 str->chars() + cell->offset, cell->len,
			 vup.e->getXwin() - r.x);
      }
      
      if (vup.e->getXwin() <= r.x + r.width) { 
	//exact match: item exactly found -> stop searching
	vup.itemData->set(props, item, link, r, strpos, true);
	return true;
      }
      else { // item approximatively found -> continue seraching
	vup.itemData->set(props, item, link, r, strpos, false);
      }
    }
  }
  return false;	// continuer a chercher (plusieurs cas)
}


u_bool UFlowView::locateItemPtr(UContext &props, 
				ULink *link, UFlowCell *cell,
				UWinGraph &g, 
				const URegion &r, UViewUpdate &vup) {
  UItem *item;
  //static int n = 0;
  if ((vup.itemData->itemLink == link || vup.itemData->item == link->brick())
       && ((item = link->brick()->itemCast()))
       ) {

    if (!item->strCast()) {
      // not an UStr: positions don't matter
      vup.itemData->set(props, item, link, r, vup.itemData->strpos, true);
      return true;
    }
    else {
      // inutile de continuer a chercher
      if (cell->offset > vup.itemData->strpos2) return true;

      if (cell->offset + cell->len >= vup.itemData->strpos) {
	/*
	printf("-- %d uuflow offset:%d len:%d pos1:%d pos2:%d :: region %d,%d %dx%d)\n",n++,
	       cell->offset, cell->len,  
	       vup.itemData->strpos, vup.itemData->strpos2,
	        r.x, r.y, r.width, r.height);
	*/
	vup.itemData->merge(props, item, link, r, true);
      }
      // pas de return true: continuer a chercher et a ajouter les regions:
      // il peut y avoir plusieurs cells concernes et on renverra la region globale
    }
  }

  //tous les cas pas trouve (PAS de else!)
  return false;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
