/* ==================================================== ======== ======= *
 *
 *  uustyle.cc
 *  Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uustyle.cc	ubit:001.11.6"
#include <udefs.hh>
#include <ubrick.hh>
#include <uprop.hh>
#include <uctrl.hh>
#include <ufont.hh>
#include <ucolor.hh>
#include <uborder.hh>
#include <ustyle.hh>
#include <uview.hh>


const UColor** UStyle::makeColors(UColor *off, UColor *on) {
  const UColor** colors =
    (const UColor**)malloc(2 * UOn::ACTION_COUNT * sizeof(UColor*));

  for (int k = 0; k < UOn::ACTION_COUNT; k++) {
    colors[k] = off;
    colors[UOn::ACTION_COUNT + k] = on;
  }
  return colors;
}

void UStyle::setFG(u_bool selected, int k , const UColor *c) {
  fgcolors[selected * UOn::ACTION_COUNT + k] = c;
}
void UStyle::setBG(u_bool selected, int k , const UColor *c) {
  bgcolors[selected * UOn::ACTION_COUNT + k] = c;
}

void UStyle::setFG(int k , const UColor *c) {
  fgcolors[k] = c;
  fgcolors[UOn::ACTION_COUNT + k] = c;
}
void UStyle::setBG(int k , const UColor *c) {
  bgcolors[k] = c;
  bgcolors[UOn::ACTION_COUNT + k] = c;
}

void UStyle::setColor(const UColor **colors, int action, const UColor*c) {
  colors[action] = c;
  colors[UOn::ACTION_COUNT + action] = c;
}

void UStyle::setColor(const UColor **colors, u_bool selected,
		     int action, const UColor*c) {
  colors[selected * UOn::ACTION_COUNT + action] = c;
}

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */

const UColor* UStyle::getFG(const UCtrl *st) const {
  return (fgcolors ? 
	  fgcolors[st->isSelected() * UOn::ACTION_COUNT + (int)st->getState()]
	  : &UColor::inherit);
}

const UColor* UStyle::getBG(const UCtrl *st) const {
  return (bgcolors ?
	  bgcolors[st->isSelected()*UOn::ACTION_COUNT + (int)st->getState()]
	  : &UBgcolor::inherit);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UStyle::UStyle(const UStyle *model) {
  viewStyle      = &UView::style;
  local.orient   = UOrient::horizontal.get();
  local.halign   = UHalign::left.get();
  local.valign   = UValign::top.get();
  local.hspacing = 0;
  local.vspacing = 0;
  local.padding.set(0, 0);

  // xpos,ypos DOIVENT etre = 0 sinon decalage systmatique
  // (sert pour effets speciaux et position controlee par UPos)
  local.xpos     = 0;
  local.ypos     = 0;
  // size will automatically adapt
  local.width    = UWidth::autoResize;
  local.height   = UHeight::autoResize;

  // alpha blending
  local.alpha    = 1.0;
  //local.layer  = 0;

  local.border   = null;
  local.edit     = null;
  local.content  = null;
  local.shape    = null;
  local.background = null;

  //NB: null devrait etre equivalent a inherit pour:
  // font, cursor, color, bgcolor
  font          = &UFont::inherit;
  cursor        = null;

  static const UColor **standard_bgcolors 
    = makeColors(&UBgcolor::inherit, &UBgcolor::black); 

  static const UColor **standard_fgcolors 
    = makeColors(&UColor::inherit, &UColor::white); 
  setColor(standard_fgcolors, UOn::DISABLED, &UColor::disabled);

  fgcolors = standard_fgcolors;
  bgcolors = standard_bgcolors;

  // recopier les champs du model
  if (model) *this = *model;
}

//copies the model
void UStyle::set(const UStyle *model) {
  *this = *model;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

