/* ==================================================== ======== ======= *
 *
 *  uwinImpl.hh
 *  Ubit Project  [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uwinImpl_hh
#define	_uwinImpl_hh
//pragma ident	"@(#)uwin.hh	ubit:b1.11.6"
#include <uprop.hh>

class USoftwinImpl {
public:
  class UPos pos;
  USoftwinImpl(UWin *win);
  ~USoftwinImpl();
  void update(UWin*, const class UUpdate &mode);
};

class UHardwinImpl {
public:
  class UWinGraph* wingraph; 
  class ULink* sub_softwins;
  UHardwinImpl(UWin *win);
  ~UHardwinImpl();
  void update(UWin*, const class UUpdate &mode);
  void updateLayout(UView* winview, u_bool impose_size, u_dim w, u_dim h);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */


