
#include <ubit/ubit.hpp>

struct MapElem {
  const char *name;
  const char *title;
  const char *details, *image;
  int x, y;
};

/* ==================================================== ======== ======= */

class Lensmap : public UBox { 
public:
  Lensmap();

  UBox scene,   scene_container;
  UScale        scene_scale;
  UScrollpane   scene_spane;
  UVbox         controls;

  class UGroup& makeElems(MapElem tab[], const UFlag& cond, const UArgs&);
  void addLens(int lenstype);
};

/* ==================================================== ======== ======= */

class Lens : public UVbox {
protected:
  Lensmap& map;
  UPos   pos;
  u_pos  last_x, last_y;
  ULabel lens_handle;
  UVbox  inbox;
  virtual void pressLens(UEvent&);
  virtual void dragLens(UEvent&);
  virtual void deleteLens(UEvent&);
public:
  Lens(Lensmap&, const char* title, u_pos x, u_pos y);
};


class Note : public Lens {
  UColor text_color;
public:
  Note(Lensmap&, const char* title, u_pos x, u_pos y);
};


class Portal : public Lens {
public:
  Portal(Lensmap&, const char* title, u_pos x, u_pos y);
};


class Magic : public Lens {
  UFlagdef show_topic, show_images, show_details;
  UPane* pane;
  virtual void dragLens(UEvent&);
public:
  Magic(Lensmap&, const char* title, u_pos x, u_pos y);
};

