#include <iostream>
#include <ubit/ubit.hpp>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// should be in header file

class Demo : public UFrame {
public:
	Demo();

private:
	UButton button;		                    // NB: variable 'button' is an OBJECT

	static  void foo1(const char*);
	virtual void foo2(UEvent&, const char*, int);
};

// end of header - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

int main(int argc, char* argv[]) {
	UAppli appli(&argc, argv);

	Demo frame;
	appli.add(frame);
	frame.show(true);
	
	return appli.mainLoop();
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

Demo::Demo() {	

	button.addlist
		(
			"Please Click Me !"
			+ UOn::mpress / ucall("test1", &Demo::foo1)
			+ UOn::action / ucall(this, "test2", 666, &Demo::foo2)
			+ ucall(this, "test3", 777, &Demo::foo2)
			);

	addlist( ulabel("Simple demo 2") + button);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void Demo::foo1(const char* s) {
	cout << "pressed: " << s << endl;
}

void Demo::foo2(UEvent& e, const char* s, int i) {
	cout << "action: " << s << " " << i << endl;
}

