/* ==================================================== ======== ======= *
*
*  uicon.hpp
*  Ubit Project [Elc][2003]
*  Author: Eric Lecolinet
*
*  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
*
*  (C) 1999-2003 Eric Lecolinet @ ENST Paris
*  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
*
* ***********************************************************************
* COPYRIGHT NOTICE :
* THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE
* IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
* YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU
* GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION;
* EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
* SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
* ***********************************************************************
*
* ==================================================== [Elc:03] ======= *
* ==================================================== ======== ======= */

#ifndef _uicon_hpp_
#define _uicon_hpp_
//pragma ident	"@(#)uicon.hpp	ubit:03.06.00"
#include <ubit/ubox.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

/** Title box 
*/
class UTitlebox : public UVbox {
public:
  static const UFlag BottomTitle, LeftTitle;

  //static UStyle *style;
  //virtual const UStyle& getStyle(UContext*) const;

  UTitlebox(const UStr& name, const UArgs& = UArgs::none);
  ~UTitlebox();
  
  virtual const UStr& getName() const;
  virtual void setName(const UStr&);

  virtual UScrollpane* getSpane() {return pspane;}
  virtual UScale* getScale()      {return pscale;}
  virtual void setScale(int);       ///< absolute zoom
  virtual void incrScale(int);      ///< relative zoom  

  virtual void iconify(bool);
  virtual bool isIconified() const;
  
  virtual void showTitleName(bool);
  virtual void showZoomButtons(bool);
  virtual void showIconifyButton(bool);
  virtual void showCloseButton(bool);
  virtual void showAltView(bool);

  UBox&   title() {return *ptitle;}
  UBox&   content() {return *pcontent;}
  UStr&   name()  {return *pname;}
  UScale& scale() {return *pscale;}

  UGroup& getZoomButtons() {return *zoom_grp;}
  //void moveTitleToTop();
  //void moveTitleToBottom();

protected:
  virtual void showAltViewImpl(bool);
  uptr<UBox>   ptitle, pcontent;
  uptr<UStr>   pname;
  uptr<UScale> pscale;
  uptr<UScrollpane> pspane;
  uptr<UButton>  alt_btn, iconify_btn, close_btn;
  uptr<UGroup> name_grp, zoom_grp;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/**
*/
class UIconbox : public UTitlebox {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UIconbox(const UStr& name, const UArgs& = UArgs::none);
  virtual ~UIconbox();

  virtual int readDir(const UStr& name, const UStr& pathname);

  virtual void addIcon(class UIcon&, bool update);
  virtual void removeAllIcons(bool delete_singles);

  virtual const UStr& getPath() const;
  virtual void setPath(const UStr&);

  virtual class UIcon* getIcon(int) const;
  virtual class UIcon* getIcon(UListPos&) const;
  virtual class UIcon* getSelectedIcon() const;
  virtual class UIcon* getPreviousIcon() const;
  virtual class UIcon* getNextIcon() const;

  virtual void selectIcon(class UIcon*, bool update = true);
  virtual void selectIcon(const UStr& name, bool update = true);
  virtual void selectPreviousIcon();
  virtual void selectNextIcon();

  virtual void showIconNames(bool);
  virtual void showIconContents(bool);
  virtual void showDirIcons(bool);
  virtual void showDocIcons(bool);

  UStr&     path()         {return *ppath;}
  UListbox& list()         {return *icons;}
  UChoice&  choice() const {return icons->choice();}

protected:
  virtual void showAltViewImpl(bool);
  static const UFlag DontShowDirs, DontShowDocs;
  uptr<UListbox> icons;
  UFlagdef show_dirs, show_docs, show_icon_names, show_icon_contents;
  uptr<UStr>    ppath;
  uptr<UWidth>  picon_width, picon_content_width;
  uptr<UHeight> picon_content_height;

  virtual void selectBehavior(UEvent&);
  virtual void okBehavior(UEvent&);
  virtual void cancelBehavior(UEvent&);
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/**
*/
class UIcon : public UItem {
public:
  static const UFlag DontShowContent, DontShowName;
  static UPix anydoc, textdoc, imadoc, folder, up, left, right;

  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UIcon(UWidth& content_width, UHeight& content_height, 
	const UArgs& = UArgs::none);

  virtual ~UIcon();

  virtual int  readContent(const UStr& name, const UStr& pathname);
  /**< reads content from a file.
   *  name is the string that is displayed in the icon.
   *   returned value: UFilestat or UXmlStat
   */

  virtual void setContent(const UStr& name, UGroup& content);
  virtual void setContent(const UStr& name, UElem&  content);
  virtual void setContent(const UStr& name, long mode);
  /**< sets name and content.
    * Note: content is not copied and should not be destroyed while 
    * the UIcon is used. It will be destroyed automatically when the 
    * UIcon is destroyed if its is not part of the instance graph
    * nor pointed by an uptr<>
    */

  class UIma* findIconImage(); 

  virtual void clearContent();

  virtual const UStr& getName() const;
  virtual void setName(const UStr&);
  UStr& name() {return *pname;}

  bool isDir()  const;
  bool isFile() const;
  bool isLink() const;
  bool isExec() const;

  void setMode(long);
  
  static class UIma* rescaleIma(class UIma*, 
				u_dim ima_max_width,
				u_dim ima_max_height);
  ///< returns ima or a copy.

protected:
  uptr<UWidth>  content_width;
  uptr<UHeight> content_height;
  uptr<UStr>    pname;
  UHbox         contentbox;
  UTextbox      namebox;
  long          mode;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */


