/* ==================================================== ======== ======= *
 *
 *  ucolorImpl.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucolorImpl_hpp_
#define	_ucolorImpl_hpp_
//pragma ident	"@(#)ucolorImpl.hpp	ubit:03.06.04"


class UColorImpl {
public:
  /* !!ATT: cette implementation suppose que les pixels ne sont utilises
   * que sur les 24 bits de droite !
   * de plus, il faut:  valid pixels < UNDEF < NONE < INHERIT <= ULONG_MAX
   */
  static const UX_Color UNDEF, NONE, INHERIT;

  UColorImpl(const char* colspec); // error if arg is null!
  UColorImpl(const char* colspec, UX_Color);
  ~UColorImpl();

  bool equals(const UColorImpl& ci2) const;

  void addRef() {refcount++;}
  void removeRef();
  u_count getRefCount() const {return refcount;}

private:
  friend class UColor;
  friend class UNatDisp;

  unsigned short refcount;
  char *natspec;          // native ascii color spec.
  std::vector<UX_Color> colors;
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

