/* ==================================================== ======== ======= *
 *
 *  textsel.hpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _utextsel_hpp_
#define	_utextsel_hpp_
//pragma ident	"@(#)utextsel.hpp	ubit:03.05.00"


class UTextsel {
public:
  UTextsel(const UColor* color, const UColor* bgcolor,const  UFont* font,
	   bool recursive_selection);

  virtual UStr copyText() const;
  virtual void copyText(UStr&) const;
  /**<
   *  collates and returns the text that is enclosed in the selection
   */

  virtual void reset(bool update);

protected:
  virtual void copyText(UStr&, bool recursive) const;
  virtual void start(class UEvent&);
  virtual void extend(class UEvent&);
  virtual bool complete(class UEvent&);
  
  bool beingSelected() const {return being_selected;}
  const UGroup* getObj() const {return inObj;}
  void setObj(UGroup*_obj) {inObj = _obj;}

private:
  friend class UStr;
  friend class UFlow;

  bool being_selected;  
  bool recursiveSelection;
  UGroup *inObj;
  // reordered in the left right order
  ULink *fromLink, *toLink, *pressLink, *oldLink;
  int   fromPos, toPos, pressPos, oldPos;
  const class UColor *color;
  const class UColor *bgcolor;
  const class UFont  *font;

  virtual void update(ULink *new_link2, int new_pos2);
  virtual void paint(int refreshFromPos, int refreshToPos, bool recursive);
  virtual void paintImpl(UGroup* obj, bool state,
		      int refreshFromPos, int refreshToPos, bool recursive);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
