/* ==================================================== ======== ======= *
 *
 *  uuedit.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuedit.cpp	ubit:03.05.05"
#include <ctype.h>
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <ustr.hpp>
#include <ucond.hpp>
#include <uctrl.hpp>
#include <ucursor.hpp>
#include <ubox.hpp>
#include <uwin.hpp>
#include <update.hpp>
#include <uview.hpp>
#include <ucontext.hpp>
#include <uevent.hpp>
#include <uappli.hpp>
#include <ucontext.hpp>
#include <ugraph.hpp>
#include <ustyle.hpp>
#include <umenuImpl.hpp>
#include <ucolor.hpp>
#include <ufont.hpp>
#include <uedit.hpp>
#include <unatdisp.hpp>
#include <X11/keysym.h>
using namespace std;


UEdit::UEdit(bool _is_editable) :
  caret_str(null),
  calls(ucall(this, &UEdit::callbacks)),
  caret_pos(0),
is_editable(_is_editable){
}

UEdit::~UEdit() {
  caret_str = null;
  destructs();
}

void UEdit::addingTo(ULink *selflink, UGroup *parent) {
  UProp::addingTo(selflink, parent);

  if (getParentCount() > 1)
    /* pourquoi pas ?
    UError::error("warning@UEdit::addingTo", 
		  "UEdit objects can not have several parents; last parent: ",
		  parent->cname());
    */
  if (parent->isCmode(UMode::CAN_EDIT_TEXT)) {
    UError::error("warning@UEdit::addingTo", 
		  "An object can not have several UEdit children; object: ",
		  parent->cname());
  }

  //parent->setBmodes(UMode::MOUSE_CB, true);
  parent->setCmodes(UMode::CAN_EDIT_TEXT | UMode::CAN_SELECT_TEXT, true);
  parent->setCmodes(UMode::HAS_CLOSE_MENU_MODE, true);
  parent->setCmodes(UMode::CLOSE_MENU_MODE, false);

  // ajouter handlers au box parent dans cache
  parent->addAttr(UOn::mpress   / *calls);
  parent->addAttr(UOn::mrelease / *calls);
  parent->addAttr(UOn::kpress   / *calls);
}

//NB: removingFrom() requires a destructor to be defined
//
void UEdit::removingFrom(ULink *selflink, UGroup *parent) {
  //parent->setBmodes(//UMode::MOUSE_CB??, false);
  parent->setCmodes(UMode::CAN_EDIT_TEXT | UMode::CAN_SELECT_TEXT, false);
  parent->setCmodes(UMode::HAS_CLOSE_MENU_MODE, false);
  parent->setCmodes(UMode::CLOSE_MENU_MODE, true);

  // enlever les callbacks: !att: y'a 3 occurences de calls dans cache
  parent->removeAttr(*calls, false);
  parent->removeAttr(*calls, false);
  parent->removeAttr(*calls, false);
  UProp::removingFrom(selflink, parent);
}

void UEdit::putProp(UContext *props, UCtrl *state) {
  props->local.edit = this;
}

// met a jour la string concernee laquelle mettra ainsi a jour ses parents
//  => ceci permet de synchroniser l'affichage de la UStr dans tous les parents
// Remarque:
// par contre les moveCaret sont locaux a chaque uedit (le caret peut avoir
// une position differente dans chaque parent)

void UEdit::update() {
  // !faux: parents.updateParents(UUpdate::paint);
  // nb: UStr::update() est desormais en doublebuffering
  if (caret_str) caret_str->update();
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UEdit::setEditable(bool _is_editable) {
  is_editable = _is_editable;
}

bool UEdit::isEditable() const {
  return is_editable;
}

const UStr* UEdit::getCaretStr(int& pos) const {
  pos = caret_pos;
  return caret_str;
}

const UStr* UEdit::getCaretStr() const {
  return caret_str;
}

void UEdit::setCaretStr(UStr* newstr, int newpos) {  
  setCaretStr(newstr, newpos, true, false);
}

// remarque: la Str peut eventuellement etre partagee a la fois 
// par des Box editables et non editables
// NOTE: strpos = pos in newstr / -1 means end of string

void UEdit::setCaretStr(UStr* newstr, int newpos,
                        bool update_views, bool no_scrolling) {  
  if (update_views && caret_str //&& newstr != str pas correct dans le cas
      // des flow car l'affichage via upd.paintSre(newstr, charpos)
      // se fait cellule par cellule
      ) {
    // faut d'abord effacer l'ancien caret
    UUpdate upd(UUpdate::PAINT);
    upd.paintStr(caret_str, caret_pos, caret_pos);
    caret_str = null;
    // update all parents (et pas seulement la Box cliquee)
    parents.updateParents(upd); 
  }

  caret_str = newstr;
  if (!caret_str) caret_pos = 0;
  else {
    if (newpos >= 0 && newpos < caret_str->length()) {
      caret_pos = newpos;
    }
    else {
      caret_pos = caret_str->length();       // set to end-of-str

      // si newpos == -2 on place le caret avant le dernier char
      if (newpos < 0 && caret_str->chars() && caret_pos > 0) {
	if (newpos == -2) caret_pos--;
	// att: exclusif: on est deja avant le dernier char si newpos = -2
	//else if (caret_str->chars()[caret_pos-1] == '\n') caret_pos--;
      }
    }
  }

  if (update_views && caret_str) {
    // NEW:12sep03: pour pouvoir scroller le texte
    // NB: no_scrolling = true pour UFlowView pour aller plus vite
    // (qui ne scrolle pas le texte de toute mnire)
    if (!no_scrolling) {
      UUpdate upd0(UUpdate::LAYOUT);
      parents.updateParents(upd0);
    }
    
    // afficher caret a la nvlle position
    // NEW:12sep03: l'offset du texte doit avoir ete calcule preced.
    UUpdate upd(UUpdate::PAINT);
    upd.paintStr(caret_str, caret_pos, caret_pos);
    // update all parents (et pas seulement la Box cliquee)
    parents.updateParents(upd); 
  }
}

/* ==================================================== ======== ======= */
// NB: on pourrait entrer dans les child UGroup ou Ubox

static
bool getPrevNextStr(UGroup *box, UStr *str, UStr **s_prev, UStr **s_next) {
  *s_prev = null;
  *s_next = null;
  if (!str) return false;
  
  bool str_was_found = false;
  UStr *s = null;

  // il faut parcourir la liste depuis le debut car les listes sont 
  // simplement chainees
  //
  for (ULink *ch = box->getChildLinks(); ch != null; ch = ch->getNext())
    if ((s = ch->getChild()->strCast())) {

      if (s == str) str_was_found = true;   // str is found

      // skip the empty strings
      else if (s->chars() != null && s->chars()[0] != '\0') {
	if (str_was_found) {
	  *s_next = s;		// this is the 'next' string
	  break; 		// nothing else to do => break the loop
	}
	else *s_prev = s;	// this is the 'previous' string
      }
    }

  return str_was_found;
}

UStr* UEdit::getPreviousStr(UGroup* par) const {
  UStr *s_prev, *s_next;
  if (par && getPrevNextStr(par, caret_str, &s_prev, &s_next))
    return s_prev;
  else return null;
}

UStr* UEdit::getNextStr(UGroup* par) const {
  UStr *s_prev, *s_next;
  if (par && getPrevNextStr(par, caret_str, &s_prev, &s_next))
    return s_next;
  else return null;
}
  
/* ==================================================== ======== ======= */
// verfier noms

void UEdit::deletePreviousChar(UGroup* par, bool update_views, bool is_flowview) {
  if (!caret_str) return;
  bool moved = previousChar(par, false, is_flowview);   // move to prev char
  if (moved) {
    // delete current char (nb: test = security)
    if (caret_pos >= 0 && caret_pos < caret_str->length())
      caret_str->replaceImpl(caret_pos, 1, null, false);
    if (update_views) update();
  }
}

void UEdit::deleteChar() {   // !! INCOMPLET !! ne passe pas a str suivante
  if (!caret_str) return;
  if (caret_pos >= 0 && caret_pos < caret_str->length()) {
    caret_str->replaceImpl(caret_pos, 1, null, false);
    // NB: le caret ne doit pas bouger dans ce cas
    update();
  }
}

bool UEdit::previousChar(UGroup* par, bool update_views, bool is_flowview) {
  if (!caret_str) return false;

  // caret set on end-of-str
  if (caret_pos == -1) caret_pos = caret_str->length();

  if (caret_pos > 0) {
    setCaretStr(caret_str, caret_pos-1, update_views, is_flowview);
    return true;
  }
  // move to previous str is possible (and skip \n if any)
  else {
    // we only consider the first parent !!!!
    //UGroup *par = getParent(0);
    UStr *s_prev, *s_next;

    // ici on pourrait entrer dans les child UGroup ou Ubox
    if (par && getPrevNextStr(par, caret_str, &s_prev, &s_next)) {
      if (s_prev) {
	// move to last-1 char (and skip final \n)
	setCaretStr(s_prev, -2, update_views, is_flowview);   // avant dernier char
	return true;
      }
    }
  }
  // no parent or could not be moved (first str)
  return false;
}

bool UEdit::nextChar(UGroup* par, bool update_views, bool is_flowview) {
  if (!caret_str) return false;
  bool newline = false;

  // caret set on end-of-str
  if (caret_pos == -1) caret_pos = caret_str->length();

  if (!caret_str->chars() || caret_str->length() == 0
      ||       // cas fin de str
      caret_pos+1 > caret_str->length()
      ||         // cas newline en fin de str
      (caret_pos+1 == caret_str->length()
       && caret_str->chars()[caret_str->length()-1] == '\n'
       && (newline = true)
       )
      ) {
    // move to next str is possible (and skip \n if any)
    
    // we only consider the first parent !!
    //UGroup *par = getParent(0);
    UStr *s_prev, *s_next;
 
    // ici on pourrait entrer dans les child UGroup ou Ubox
    if (par && getPrevNextStr(par, caret_str, &s_prev, &s_next)) {
      if (s_next) {
	if (newline) 
	  setCaretStr(s_next, 0, update_views, is_flowview); // avant premier char
	else
	  setCaretStr(s_next, 1, update_views, is_flowview); // apres premier char
	return true;
      }
      else if (is_flowview) {
	// cas particulier d'un multi-line on est a la fin 
	// de la derniere UStr : il faut pouvoir passer a la ligne
	// finale (bien qu'il n'ait rien sur cette line)
	setCaretStr(caret_str, caret_pos+1, update_views, is_flowview);
	return true;
      }
    }
  }

  else {
    setCaretStr(caret_str, caret_pos+1, update_views, is_flowview);
    return true;
  }

  // no parent or could not be moved (last str)
  return false;
}

/* ==================================================== ======== ======= */

int UEdit::getXpos(UWinGraph& g, UContext* props, const URegion& r,
		   int offset, int cellen) const {
  int xpos = r.x;
  if (!caret_str) return xpos;

  //!att: meme si !(str->s) penser a afficher le Caret
  const char* s = caret_str->chars();
  if (s) {
    xpos += g.getXPos(props->fontdesc, 
		      s + offset, cellen, 
		      caret_pos - offset);
  }
  
  // xpos-1 pour eviter que la barre s'affiche sur le char suivant 
  // sauf si on est deja au min (cad r.x)
  xpos = std::max(xpos-1, r.x);
  return xpos;
}

int UEdit::getXpos(UWinGraph& g, UContext* props, const URegion& r) const {
  return getXpos(g, props, r, 0,  (caret_str ? caret_str->length() : 0));
}

void UEdit::paint(UWinGraph& g, UContext* props, const URegion& r,
		  int offset, int cellen) const {
  //if (!caret_str) {
  //  UError::error("internal@UEdit::paint","no caret string");
  //  return;
  //}
  int xpos = getXpos(g, props, r, offset, cellen);
  g.setColor(props->color);
  g.drawLine(xpos, r.y, xpos, 
	     // -1 sinon ca deborde de la zone de background!
	     r.y + g.getTextHeight(props->fontdesc) -1);
}

void UEdit::paint(UWinGraph& g, UContext* props, const URegion& r) const {
  //if (!caret_str) {
  //  UError::error("internal@UEdit::paint","no caret string");
  //  return;
  //}
  paint(g, props, r, 0, (caret_str ? caret_str->length() : 0));
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */
// NB: press et non arm car arm provoque un reaffichage 
//     (on reafficherait donc 2 fois)

void UEdit::callbacks(UEvent& e) {
  switch(e.getID()) {
  case UEvent::mpress:
    mpressed(e);
    break;
  case UEvent::mrelease:
    mreleased(e);
    break;
  case UEvent::kpress:
    kpressed(e);
    break;
  }
}

/* ==================================================== ======== ======= */

void UEdit::mpressed(UEvent& e) {
  UElemProps itd;
  UStr* newstr = null;
  u_id btn_id = e.getButtons();

  if ((btn_id == UEvent::MButton1 || btn_id == UEvent::MButton2)  // PARAMETRER
      && (newstr = e.getStr(itd))) {

    setCaretStr(newstr, itd.strpos, true, false); // no_scrolling

    if (btn_id == UEvent::MButton2) {		// PARAMETRER
      // APRES setCaretPosition !

      // UView *winview = null;
      //if ((winview = e->getWinView()) && (appli = winview->getAppli())
      //  && caret_str != null) {

      UAppli *appli = null;
      if (caret_str && (appli = e.getAppli())) 
	// !ATT: pbm  si la USTr est detruite entre temps!
	appli->getNatDisp()->askSelectionContent(e, caret_str, caret_pos);
    }
  }
}

void UEdit::mreleased(UEvent& e) {
  UElemProps itd;
  UStr* newstr = null;

  // mrelease1 necessaire pour que le Drag selection fonctionne
  if (e.getButtons() == UEvent::MButton1                  // PARAMETRER
      && (newstr = e.getStr(itd))) {
    setCaretStr(newstr, itd.strpos, true, false);  // no_scrolling
  }
}

/* ==================================================== ======== ======= */

void UEdit::kpressed(UEvent& e) {
  if (!caret_str) return;
  UGroup* par = e.getSource();
  
  /// can the "Return" key break the line?
  bool is_flowview = false;
  if (e.getView() && dynamic_cast<UFlowView*>(e.getView())) is_flowview = true;
    
  KeySym keysym = e.getKeySym();
  int keychar   = e.getKeyChar();
  bool done  = false;  
  //cerr << "edit:: keysym "<< keysym  <<" keychar " <<keychar <<endl;

  switch (keysym) {
  case XK_BackSpace:
    if (is_editable) deletePreviousChar(par, true, is_flowview);
    break;

  case XK_Delete:
  case XK_KP_Delete:
    if (is_editable) deleteChar();
    break;

  case XK_Left:
  case XK_KP_Left:
    previousChar(par, true, is_flowview);
    break;
	
  case XK_Right:
  case XK_KP_Right:
    nextChar(par, true, is_flowview);
    break;
    
  case XK_Home:
  case XK_KP_Home:
  case XK_Begin:
  case XK_KP_Begin:
    setCaretStr(caret_str, 0, true, is_flowview);
    break;

  case XK_End:
  case XK_KP_End:
    setCaretStr(caret_str, -1, true, is_flowview);
    break;

  case XK_Return:
    if (is_editable && is_flowview) {
      keychar = '\n';
      done = caret_str->insertImpl(caret_pos, keychar, false);
      // ?? true necessaire pour maj du scroll du texte dans ce cas ??
      if (done) nextChar(par, false, is_flowview);
      update();
    }
    break;
    
  default:

    switch(keychar) {
    case '\004':  // ^D : delete
      if (is_editable) deleteChar();
      break;

    case '\002':  // ^B : backwards
      previousChar(par, true, is_flowview);
      break;

    case '\006':  // ^F : backwards
      nextChar(par, true, is_flowview);
      break;

    case '\001':  // ^A : begin
      setCaretStr(caret_str, 0, true, is_flowview);
      break;

    case '\005':  // ^E : end
      setCaretStr(caret_str, -1, true, is_flowview);
      break;

    default:
      // si le char est affichable
      //EX: if (isprint(kk))... for some reason isprint elime les chars 
      //accentues sauf avec certaines locales quand elles existent => pas sur!

      if (is_editable && keychar != '\0' && !iscntrl(keychar)) {
	done = caret_str->insertImpl(caret_pos, keychar, false);
	//if (done) nextChar(false, enable_return);
        // true necessaire pour maj du scroll du texte
        if (done) nextChar(par, true, is_flowview); 
	update();
      }
    }
    break;
  }
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

