/* ==================================================== ======== ======= *
 *
 *  umsocket.cpp : [UMS] Ubit Multiple Mouse Message Server
 *
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)umssocket.cpp	ubit:03.06.04"
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>   // NEW: A VERIFIER PARTOUT !!
#include <sys/socket.h>
#include "umserver.hpp"
#include <ubit/umsproto.hpp>
#include <ubit/config.h> // socklen_t required on Linux but doesn't exist on BSD
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int UMServer::openServerSocket(int server_port) {
  int serv_socket = ::socket(AF_INET, SOCK_STREAM, 0);
  if (serv_socket < 0) {
    //cerr << "can't open server socket" << endl;
    return -1;
  }

  sock_server.sin_family = AF_INET;
  sock_server.sin_addr.s_addr = INADDR_ANY;
  sock_server.sin_port = htons(server_port);

  // pour reutiliser plusieurs fois la meme adresse
  int tmp = 1;
  ::setsockopt(serv_socket,SOL_SOCKET,SO_REUSEADDR,(char*)&tmp,sizeof(tmp));

  if (::bind(serv_socket,(struct sockaddr*)&sock_server,sizeof(sock_server)) < 0) {  
    //cerr << "can't open connection on port" << endl;
    return -1;
  }

  // socklen_t required on Linux but doesn't exist on BSD
#ifdef HAVE_NO_SOCKLEN_T
  int taille = 0;
#else
  socklen_t taille = 0;
#endif

  // verifications sur le serveur
  if (::getsockname(serv_socket,(struct sockaddr *)&sock_server, &taille) < 0) {
    //cerr << "erreur sur getsocketname" << endl;
    return -1;
  }

  // Le serveur se met en attente sur le socket d'ecoute
  ::listen(serv_socket, 5);

  return serv_socket;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UMServer::readServerSocket() {
  int sock_com;

  // cf. man -s 3n accept, attention EINTR ou EWOULBLOCK ne sont pas geres!
  if ((sock_com = ::accept(ums_socket, NULL, NULL)) == -1) {
    cerr << "UMServer::readServerSocket: error on accept" << endl;
    return;
  }

  // turn off TCP coalescence for INET sockets  // NEW!!
  // NB: necessaire (au moins) pour MacOS, sinon delai de transmission
  int tmp = 1;
  ::setsockopt(sock_com, IPPROTO_TCP, TCP_NODELAY, (char*)&tmp, sizeof(int));
  
  // envoi d'un message de debut au client
  char header[] = "<UMS>";

  if (::write(sock_com, header, sizeof(header)) < 0) {
    cerr << "UMS::readServerSocket: can't write on socket" << endl;
    return;
  }

  int stat = readComSocket(sock_com, true);  // called by serv

  // envoi d'un message de fin au client
  char tailer[] = "</UMS KEEP_CNX=0>";
  // indiquer si la connection reste open
  if (stat == UMSrequest::KeepCnx) tailer[sizeof(tailer)-3] = '1';

  if (::write(sock_com, tailer, sizeof(tailer)) < 0) {
    cerr << "UMS::readServerSocket: can't write on socket" << endl;
  }

  // NB: some commands request the server to keep the connection open
  if (stat == UMSrequest::KeepCnx) {
    //cerr << "Server KEEPs connection" << endl;
  }
  else {
    cerr << "Server CLOSEs connection" << endl;
    ::shutdown(sock_com, 2);
    ::close(sock_com);
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// returns UMSrequest status

int UMServer::readComSocket(int sock_com, bool called_by_serv) {
  UMSrequest req;
  int received = 0;
  int stat = UMSrequest::Ok;

  // Reception des donnees envoyees via le socket
  // attention, plusieurs read() peuvent etre necessaires
  int n = ::read(sock_com, &req, 1);
  int request_size = req.data[0]*8;
  received += n;
  
  while (1) {
    int n = read(sock_com, ((char*)&req) + received, request_size - received);
    received += n;

    if (n < 0) {
      cerr << "UMS::readComSocket: can't read socket" << endl;
      stat = UMSrequest::CloseCnx;
      break; 
    } 
    else if (n == 0) {
      //cerr << "UMS::readComSocket: end of connection" << endl;
      stat = UMSrequest::CloseCnx;
      break;
    } 
    else if (received >= request_size) {
      //cerr << "UMS::readComSocket: data successfully received" << endl;
      stat = UMSrequest::Ok;
      break;
    }
  }

  // execute command (dont exec if error of if data uncomplete)
  if (stat == UMSrequest::Ok)       // can return Ok, CloseCnx or KeepCnx
    stat = processRequest(sock_com, req);

  // ca doit etre fait par serveur si c'est le caller
  if (!called_by_serv && stat == UMSrequest::CloseCnx) {
    //fait dans removeCnx ::shutdown(sock_com, 2); ::close(sock_com);
    removeCnx(sock_com);
  }
  //else cerr << "comm KEEPs connection" << endl;
  
  return stat;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
