/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_RENDERINGWINDOW_H
#define GTK_RENDERINGWINDOW_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "visu_data.h"
#include "visu_dump.h"
#include "extensions/marks.h"
#include "openGLFunctions/interactive.h"
#include "openGLFunctions/view.h"

G_BEGIN_DECLS
/**
 * RENDERING_WINDOW_TYPE:
 *
 * Return the associated #GType to the Renderingwindow objects.
 */
#define RENDERING_WINDOW_TYPE         (visu_rendering_window_get_type())
/**
 * RENDERING_WINDOW:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #VisuRenderingWindow object.
 */
#define RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_CAST((obj), RENDERING_WINDOW_TYPE, VisuRenderingWindow))
/**
 * RENDERING_WINDOW_CLASS:
 * @klass: the class to cast.
 *
 * Cast the given class to a #VisuRenderingWindowClass object.
 */
#define RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), RENDERING_WINDOW_TYPE, VisuRenderingWindowClass))
/**
 * IS_RENDERING_WINDOW:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #VisuRenderingWindow object.
 */
#define IS_RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), RENDERING_WINDOW_TYPE))
/**
 * IS_RENDERING_WINDOW_CLASS:
 * @klass: the class to test.
 *
 * Return if the given class is a valid #VisuRenderingWindowClass class.
 */
#define IS_RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), RENDERING_WINDOW_TYPE))
/**
 * RENDERING_WINDOW_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define RENDERING_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, RENDERING_WINDOW_TYPE, VisuRenderingWindowClass))

/**
 * VisuRenderingWindow:
 *
 * Short form for a #VisuRenderingWindow_struct structure.
 */
typedef struct _VisuRenderingWindow VisuRenderingWindow;
/**
 * VisuRenderingWindowClass:
 *
 * Short form for a #VisuRenderingWindowClass_struct structure.
 */
typedef struct _VisuRenderingWindowClass VisuRenderingWindowClass;

/**
 * visu_rendering_window_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #VisuRenderingWindow objects.
 */
GType          visu_rendering_window_get_type        (void);

/**
 * RENDERING_WINDOW_ID:
 *
 * The key to get the embedding #GtkWindow of a given #VisuRenderingWindow
 * widget, if any. See visu_rendering_window_newEmbedded().
 */
#define RENDERING_WINDOW_ID "ContainerWindow"

GtkWidget* visu_rendering_window_new(int width, int height,
				gboolean withFrame, gboolean withToolBar);
GtkWidget* visu_rendering_window_newEmbedded(int width, int height);
/**
 * renderingWindowPush_message:
 * @window: a valid #VisuRenderingWindow object ;
 * @message: an UTF8 string to print on the status bar.
 *
 * Use this method to add some informations on the status bar.
 */
void renderingWindowPush_message(VisuRenderingWindow *window, gchar *message);
/**
 * renderingWindowPop_message:
 * @window: a valid #VisuRenderingWindow object.
 *
 * Remove the last message.
 */
void renderingWindowPop_message(VisuRenderingWindow *window);
/**
 * renderingWindowGet_backgroundImage:
 * @window: a valid #VisuRenderingWindow object ;
 * @rowData: a pointer to be set on the data in memory ;
 * @hasAlphaChannel: a pointer to store if the loaded iage has an alpha channel ;
 * @width: store the width ;
 * @height: store the height.
 *
 * Use this method to load an image in memory (according to GdkPixbuf
 * specification) and retrieve the row data in memory. 
 *
 * Returns: a pointer to GdkPixbuf that is own by the @window object. his image
 *          stay in memory until a call to renderigWindowFree_backgroundImage()
 *          occurs.
 */
GdkPixbuf* renderingWindowGet_backgroundImage(VisuRenderingWindow *window,
					     guchar **rowData, gboolean *hasAlphaChannel,
					     int *width, int *height);
/**
 * renderingWindowFree_backgroundImage:
 * @window: a valid #VisuRenderingWindow object.
 *
 * Free loaded background image if exists.
 */
void renderingWindowFree_backgroundImage(VisuRenderingWindow *window);

/**
 * visu_rendering_window_setData:
 * @window: a valid #VisuRenderingWindow object ;
 * @data: a #VisuData to render in the given @window (can be NULL).
 *
 * This method is used to attach a #VisuData object to a given window.
 * When, @data is not NULL, this method emit the dataReadyForRendering signal,
 * and all modules that needs to draw something should catch this signal and
 * draw in the rendering window. If @data is NULL, the dataNotReadyForRendering
 * is emitted instead.
 */
void visu_rendering_window_setData(VisuRenderingWindow *window, VisuData* data);
VisuData* visu_rendering_window_getVisuData(VisuRenderingWindow *window);

void visu_rendering_window_loadFile(VisuRenderingWindow *window, VisuData *data, guint iSet);
/**
 * renderingWindowOpen_file:
 * @window: the window the file will by rendered on ;
 * @parent: the parent window for the filechooser dialog.
 *
 * Do as if the load button has been pushed, i.e. open a filechooser
 * dialog on the @parent window, and load the resulting file,
 * refreshing the view if necessary.
 */
void renderingWindowOpen_file(VisuRenderingWindow *window, GtkWindow *parent);

gboolean visu_rendering_window_dump(VisuRenderingWindow *window, VisuDump *format,
			     const char* fileName, gint width, gint height,
			     GError **error,
			     ToolVoidDataFunc functionWait, gpointer data);

/**
 * renderingWindowRedraw:
 * @window: a valid #VisuRenderingWindow object ;
 * @forceRedraw: a boolean.
 *
 * Update the OpenGL area of the rendering window if the opengl option
 * is set to immediate. If not, use @forceRedraw to redraw.
 */
void renderingWindowRedraw(VisuRenderingWindow *window, gboolean forceRedraw);

/**
 * renderingWindowSet_current:
 * @window: a valid #VisuRenderingWindow object ;
 * @force: a boolean.
 *
 * Set the OpenGL area as the current rendering area. If @force is TRUE
 * then the context is switched whatever buffered value.
 *
 * Since: 3.5
 */
void renderingWindowSet_current(VisuRenderingWindow *window, gboolean force);

void renderingWindowPush_interactive(VisuRenderingWindow *window,
				     VisuInteractive *inter);
void renderingWindowPop_interactive(VisuRenderingWindow *window,
				    VisuInteractive *inter);
VisuMarks* visu_rendering_window_getMarks(VisuRenderingWindow *window);

VisuInteractive* renderingWindowClassGet_interactive();
gboolean visu_rendering_window_setDisplayCoordinatesInReduce(gboolean status);
gboolean visu_rendering_window_getDisplayCoordinatesInReduce();
gboolean visu_rendering_window_setAutoAdjust(gboolean status);
gboolean visu_rendering_window_getAutoAdjust();

G_END_DECLS

#endif
