/***************************************************************************
                          dcmenuhandler.cpp  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpopupmenu.h>

#include <dciconloader.h>

#include "dcmenuhandler.h"

DCMenuHandler::DCMenuHandler()
{
}

DCMenuHandler::~DCMenuHandler()
{
}

/** */
QPopupMenu * DCMenuHandler::_InsertMenu( QPopupMenu * popupmenu, eMenuItems menuitems, bool enabled, QString text )
{
	QPopupMenu * menu = 0;

	if(!popupmenu)
	{
		return menu;
	}

	switch(menuitems)
	{
		case emiSEPARATOR:
				popupmenu->insertSeparator();
				break;
		case emiDOWNLOAD:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOWNLOAD_TO:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download To"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOWNLOAD_AS:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Download As"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOWNLOAD_REPAIR:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Repair File"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOWNLOAD_BIN_SECTORS:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiDOWNLOAD) ), QObject::tr("Repair BIN sectors"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOWNLOAD_IN:
				popupmenu->insertItem( QObject::tr("Add this extra source"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiBROWSE_USER_FILES:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ), QObject::tr("Browse User Files"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCHECK_CLIENT_VERSION:
				popupmenu->insertItem( QIconSet( QPixmap() ), QObject::tr("Check client version"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiPRIVATE_CHAT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiMESSAGE) ), QObject::tr("Private Chat"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiKICK:
				popupmenu->insertItem( QObject::tr("Kick"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiFORCE_MOVE:
				popupmenu->insertItem( QObject::tr("Force Move"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGET_USER_IP:
				popupmenu->insertItem( QObject::tr("Get user IP"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiUPDATE_USER:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update User"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCONNECT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDISCONNECT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_NO) ), QObject::tr("Disconnect"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiRELOAD_USERLIST:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Reload Userlist"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCONNECT_TO_HUB:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect To Hub"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCONNECT_TO_ALL_HUBS:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Connect To All Hubs"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiADD:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiADD_BOOKMARK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiBOOKMARK_ADD) ), QObject::tr("Add Bookmark"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiEDIT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiEDIT_BOOKMARK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit Bookmark"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREMOVE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCLOSE_TRANSFER:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_NO) ), QObject::tr("Close Transfer"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiINFO:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiINFO) ), QObject::tr("Info"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiTRY_CONNECT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiCONNECT_CREATING) ), QObject::tr("Try Connect"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiPAUSE_TRANSFER_QUEUE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiPLAYER_PAUSE) ), QObject::tr("Pause Queue"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiRESUME_TRANSFER_QUEUE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiPLAYER_PLAY) ), QObject::tr("Resume Queue"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREMOVE_TRANSFER_QUEUE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove from Queue"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREMOVE_TRANSFER_QUEUE_COMPLETE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove complete from Queue"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREMOVE_TRANSFER_QUEUE_DISK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Remove Transfer from Queue and Disk"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiADD_PERMANENT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add Permanent"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiSAVE_QUEUE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiSAVE) ), QObject::tr("Save Queue"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiUPDATE_SERVER:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update Server"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiUPDATE_ALL_SERVER:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Update all Server"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCHANGE_TRANSFER_RATE:
				popupmenu->insertItem( QObject::tr("Change Transfer-Rate"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCOPY_ROW_TO_CLIPBOARD:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy row to Clipboard"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCOPY_COLUMN_TO_CLIPBOARD:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy column to Clipboard"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiFILE_INFO:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiINFO) ), QObject::tr("File Info"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
				break;
		case emiSEARCH_FILE_CLONE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFILEFIND) ), QObject::tr("Search for clones"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiSEARCH_FILE_CLONE_TTH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFILEFIND) ), QObject::tr("Search for clones by TTH"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;				
		case emiUSER_CAPTION:
				popupmenu->insertItem( text, emiUSER_CAPTION );
				popupmenu->setItemEnabled( emiUSER_CAPTION, enabled );
				break;
		case emiLOAD:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiOPEN) ), QObject::tr("Load"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiSAVE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiSAVE) ), QObject::tr("Save"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiHUB_PROFILE_EDITOR:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Profile editor"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiEDIT_TRANSFER:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit transfer"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiEDIT_FILE_PRIORITY:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDIT) ), QObject::tr("Edit file priority"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiTRANSLATE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiTRANSLATE) ), QObject::tr("Translate"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiTRANSLATOR:
				popupmenu->insertItem( QObject::tr("Translator"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiINSERTSMILEY:
				popupmenu->insertItem( QObject::tr("Insert Smiley"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiADD_FRIEND:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITADD) ), QObject::tr("Add Friend"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREQUEST_SECURE_CHAT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiSSL_YES) ), QObject::tr("Request secure chat"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCLOSE_SECURE_CHAT:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiSSL_NO) ), QObject::tr("Close secure chat"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDISABLE_GROUP:
				popupmenu->insertItem( QObject::tr("Disable group"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_FILE:
				popupmenu->insertItem( QObject::tr("Group by File"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_SIZE:
				popupmenu->insertItem( QObject::tr("Group by Size"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_NICK:
				popupmenu->insertItem( QObject::tr("Group by Nick"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_HASH:
				popupmenu->insertItem( QObject::tr("Group by Hash"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_SLOTS_FREE:
				popupmenu->insertItem( QObject::tr("Group by free Slots"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_HUB:
				popupmenu->insertItem( QObject::tr("Group by Hub"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_PATH:
				popupmenu->insertItem( QObject::tr("Group by Path"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiGROUP_BY_HOST:
				popupmenu->insertItem( QObject::tr("Group by Host"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCOPY:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCOPYDCFILELINK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy Link"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCOPYMAGNETLINK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITCOPY) ), QObject::tr("Copy magnet link"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCLEAR:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiEDITDELETE) ), QObject::tr("Clear"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiSELECT_ALL:
				popupmenu->insertItem( QObject::tr("Select all"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiCLOSE:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFILECLOSE) ), QObject::tr("Close"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiHIDE:
				popupmenu->insertItem( QObject::tr("Hide"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiREFRESH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD) ), QObject::tr("Refresh Filelist"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiRESET:
				popupmenu->insertItem( QIconSet( QPixmap() ), QObject::tr("Reset"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiDOCK:
				popupmenu->insertItem( QIconSet( QPixmap() ), QObject::tr("Dock"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiUNDOCK:
				popupmenu->insertItem( QIconSet( QPixmap() ), QObject::tr("Undock"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiEXIT:
				popupmenu->insertItem( QIconSet( QPixmap() ), QObject::tr("Exit"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		// languages
		case emiLANGUAGE_BOSNIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_BOSNIAN) ), QObject::tr("Bosnian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_BRAZILIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_BRAZILIAN) ), QObject::tr("Brazilian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_CZECH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_CZECH) ), QObject::tr("Czech"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_DANISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_DENMARK) ), QObject::tr("Danish"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_DUTCH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_NETHERLAND) ), QObject::tr("Dutch"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_ENGLISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_ENGLISH) ), QObject::tr("English"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_FINNISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_FINLAND) ), QObject::tr("Finnish"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_FRENCH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_FRANCE) ), QObject::tr("French"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_GERMAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_GERMANY) ), QObject::tr("German"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_GREEK:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_GREEK) ), QObject::tr("Greek"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_HUNGARIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_HUNGARY) ), QObject::tr("Hungarian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_ICELANDIC:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_ICELAND) ), QObject::tr("Icelandic"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_ITALIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_ITALY) ), QObject::tr("Italian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_LATVIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_LATVIAN) ), QObject::tr("Latvian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_NORWEGIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_NORWAY) ), QObject::tr("Norwegian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_POLISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_POLAND) ), QObject::tr("Polish"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_ROMANIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_ROMANIA) ), QObject::tr("Romanian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_RUSSIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_RUSSIA) ), QObject::tr("Russian"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_SLOVAKIAN:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_SLOVAK) ), QObject::tr("Slovak"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_SPANISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_SPAIN) ), QObject::tr("Spanish"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		case emiLANGUAGE_SWEDISH:
				popupmenu->insertItem( QIconSet( g_pIconLoader->GetPixmap(eiFLAG_SWEDEN) ), QObject::tr("Swedish"), menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
		// submenus
		case emisGROUP:
				menu = new QPopupMenu(popupmenu);
				popupmenu->insertItem( QObject::tr("Group"), menu );
				break;
		case emisCHAT_RIGHTCLICK_USER:
				menu = new QPopupMenu(popupmenu);
				popupmenu->insertItem( QObject::tr("User: ") + text, menu );
				break;
		case emiCUSTOM:
				menu = new QPopupMenu(popupmenu);
				popupmenu->insertItem( QObject::tr("Custom"), menu );
				break;
		case emiUPLOAD_SLOT:
				menu = new QPopupMenu(popupmenu);
				popupmenu->insertItem( QObject::tr("Upload Slot"), menu );
				break;

		// custom user menu
		default:
				popupmenu->insertItem( text, menuitems );
				popupmenu->setItemEnabled( menuitems, enabled );
				break;
	}

	return menu;
}
