/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/notebook.h"
#include "vdk/forms.h"
#include "vdk/pixmaps.h"
#include "vdk/label.h"
#include "vdk/boxes.h"
#include "vdk/colors.h"

//================
// class  tab page
//================
VDKTabPage::VDKTabPage(VDKObject* book,
		       VDKObject* child,
		       char *lbl, 
		       char **closed_xpm,
		       char **open_xpm):
child(child),book(book)
{
  GtkWidget *pixwid;
  GdkColor *transparent = NULL;
  tab = gtk_hbox_new (FALSE, 0);
  //
  if(closed_xpm)
    closed = gdk_pixmap_create_from_xpm_d (book->Widget()->window,
		     &closed_mask,transparent, closed_xpm);
  else
    closed = NULL;
  //
  if(open_xpm)
    open = gdk_pixmap_create_from_xpm_d (book->Widget()->window,
		     &open_mask, transparent, open_xpm);
  else
    open = NULL;
  //
  if(closed)
    {
    pixwid = gtk_pixmap_new (closed, closed_mask);
    gtk_box_pack_start (GTK_BOX (tab), pixwid, FALSE, TRUE, 0);
    gtk_misc_set_padding (GTK_MISC (pixwid), 3, 1);
    }
  TabLabel = new VDKLabel(book->Owner(),lbl);
  gtk_box_pack_start (GTK_BOX (tab), 
		      TabLabel->Widget(), 
		      FALSE, TRUE, 0);
  gtk_widget_show(child->Widget());
  //  
  gtk_widget_show_all (tab);
  gtk_notebook_append_page(GTK_NOTEBOOK(book->Widget()), 
			   child->Widget(), 
			   tab);
  book->Owner()->Objects().add(TabLabel);
}
 
//================
// class page list
//================ 
/*
 */
VDKTabPage* PageList::operator[](int n) 
{   
  return PList::operator[](n); 
}
/*
 */
PageList::~PageList()
{
for(PListIterator li(*this);li;li++)
  delete li.current();
} 
/* 
 */
void PageList::AddPage(VDKObject* child,
		       char *label,
		       char **pixmap_open,
		       char **pixmap_closed)
{
  VDKTabPage *page = new VDKTabPage(book, 
				    child,
				    label,
				    pixmap_open,
				    pixmap_closed);
  add(page);
  child->Parent(book);
} 
//===============
// class notebook 
//===============
void VDKNotebook::PageSwitch(GtkWidget *widget, 
			     GtkNotebookPage *page,
			     int pagenum,
			     gpointer gp)
{
  GdkPixmap *open = NULL;
  GdkPixmap *closed = NULL;
  GdkBitmap *open_mask;
  GdkBitmap *closed_mask;
  int lastpage;
  g_return_if_fail(gp != NULL);
  VDKNotebook* obj = reinterpret_cast<VDKNotebook*>(gp);
  

  GtkNotebookPage *oldpage;
  GtkWidget *pixwid;
  oldpage = GTK_NOTEBOOK (widget)->cur_page;
  if ((page == oldpage) || 
      (!obj->Pages.size()) ||
      (pagenum < 0) ||
      (pagenum >= obj->Pages.size())
      )
    return;
  bool enabled = obj->Pages[pagenum]->TabLabel->Enabled;
  // does not proceed if page is disabled
  if(! enabled)
    {
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"switch_page");
    return;
    }
  //
  lastpage = gtk_notebook_current_page(GTK_NOTEBOOK(widget));
  open = obj->Pages[pagenum]->open;
  open_mask = obj->Pages[pagenum]->open_mask;
  if(open)
    {
      pixwid = ((GtkBoxChild*)
		(GTK_BOX (page->tab_label)->children->data))->widget;
      if(pixwid) 
	gtk_pixmap_set (GTK_PIXMAP (pixwid), open,  open_mask);
    }
  if ( (lastpage >= 0) 
       && (lastpage < obj->Pages.size())
       && (oldpage && closed))
    {
      closed = obj->Pages[lastpage]->closed;
      closed_mask = obj->Pages[lastpage]->closed_mask;
      pixwid = ((GtkBoxChild*) 
		(GTK_BOX(oldpage->tab_label)->children->data))->widget;
      if(pixwid)
	gtk_pixmap_set (GTK_PIXMAP (pixwid), closed, closed_mask);
    }
obj->ActivePage(pagenum);
obj->SignalEmit(switch_page_signal);
#ifdef USE_SIGCPLUSPLUS
obj->OnPageSwitch(obj,pagenum); 
#endif
}
/*
 */ 
VDKNotebook::VDKNotebook(VDKForm* owner):
  VDKObjectContainer(owner),
  ActivePage("ActivePage",this),
  TabPosition("TabPosition",this),
  Scrollable("Scrollable",this,false,&VDKNotebook::SetScrollable),
  PopUp("PopUp",this,false,&VDKNotebook::SetPopUp),
  PreviousActivePage("PreviousActivePage",this,-1,
		     &VDKNotebook::GetPreviousActivePage)
{ 
widget = gtk_notebook_new();  
gtk_notebook_set_tab_pos(GTK_NOTEBOOK(widget),GTK_POS_TOP);
Pages.book = this;
gtk_signal_connect (GTK_OBJECT (widget), "switch_page",
			  GTK_SIGNAL_FUNC (VDKNotebook::PageSwitch),this);
}
/* 
 */
VDKNotebook::~VDKNotebook()
{
}
/*
 */
void VDKNotebook::AddPage(VDKObject* obj,
			  char *label,
			  char **pixmap_open,
			  char **pixmap_closed)
{
Pages.AddPage(obj,label,pixmap_open,pixmap_closed);
Owner()->Objects().add(obj);
}
/*
 */
void VDKNotebook::RemovePage(int page, bool removechild)
{
if(page < 0 || page >= Pages.size())
  return;
VDKObject* child = Pages[page]->child;
gtk_notebook_remove_page(GTK_NOTEBOOK(widget),page);
VDKTabPage *tabpage = Pages[page];
if(Pages.remove(tabpage))
  { 
    if(removechild)
      Owner()->RemoveItem(child); 
    delete tabpage;
    // set active page
    ActivePage(gtk_notebook_get_current_page(GTK_NOTEBOOK(Widget())));
  }
}


/*
 */
ActivePageProperty::ActivePageProperty(){}
ActivePageProperty::ActivePageProperty(
		     char* name,
		     VDKNotebook* object,
		     void (VDKNotebook::*write)(int),
		     int (VDKNotebook::*read)(void)
		     )
    : NoteBookIntProp(name,object,0,write,read) {}
ActivePageProperty::~ActivePageProperty() {}

/*
 */
ActivePageProperty::operator int()
{
  //value = gtk_notebook_get_current_page(GTK_NOTEBOOK(object->Widget()));
return value;
}
/*
 */
void 
ActivePageProperty::operator=(int page)
{
value = page;
if(page >= 0 && page < object->Pages.size())
  gtk_notebook_set_page(GTK_NOTEBOOK(object->Widget()),page);
}
/*
 */ 
void 
ActivePageProperty::operator++()
{
  gtk_notebook_next_page(GTK_NOTEBOOK(object->Widget()));
}
/*
 */
void 
ActivePageProperty::operator--()
{
  gtk_notebook_prev_page(GTK_NOTEBOOK(object->Widget()));
}
/*
 */
void 
ActivePageProperty::operator++(int)
{
  gtk_notebook_next_page(GTK_NOTEBOOK(object->Widget()));
}
/*
 */
void 
ActivePageProperty::operator--(int)
{
  gtk_notebook_prev_page(GTK_NOTEBOOK(object->Widget()));
}

/* 
 */
NotebookTabPosProperty::NotebookTabPosProperty(){}
NotebookTabPosProperty::NotebookTabPosProperty(
			 char* name,
			 VDKNotebook* object,
			 void (VDKNotebook::*write)(int),
			 int (VDKNotebook::*read)(void)
			 ):
    NoteBookIntProp(name,object,GTK_POS_TOP,write,read) { }
NotebookTabPosProperty::~NotebookTabPosProperty() {}

void 
NotebookTabPosProperty::operator=(int pos)
{
  value = pos%GTK_POS_BOTTOM;
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(object->Widget()),
			   (GtkPositionType) value);
}




























