/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6.2
 * May 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkcustombutton.h>
#include <vdk/forms.h>
#include <vdk/colors.h>
#include <gdk/gdkkeysyms.h>
#define DEFAULT_PADDING 5
/*
  static char *pixbutton_xpm[] = {
  "    24    22        6            1",
  
  ". c #000000",
  "# c #828282",
  "a c #none",
  "b c #ffff00",
  "c c #0000ff",
  "d c #ffffff",
  
  "a......................a",
  ".ddddddddddddddddddddd#.",
  ".daaaaaaaaaaaaaaaaaaa##.",
  ".daaaaaadddddaaaaaaaa##.",
  ".daaadddaaadddaaaaaaa##.",
  ".daaaaaaaa.ddd.daaaaa##.",
  ".daa#aaadd..dd..ddaaa##.",
  ".daab#aa.d#.#dd.dcaaa##.",
  ".daab#a..dd..dd.#ddaa##.",
  ".daabb#..dd..dd..ddda##.",
  ".daabb#..dd..dd..ddda##.",
  ".daab#a..d#.#dd.#ddaa##.",
  ".daab#aa.d..ddd.ddaaa##.",
  ".daa#aaaad.ddd.ddaaaa##.",
  ".daaaaaaaa.ddd.daaaaa##.",
  ".daaaaaaaaaaa..aaaaaa##.",
  ".daaaaaaaaaa..a.aaaaa##.",
  ".daaaaaaaaa..aaa.aaaa##.",
  ".daaaaaaaaaaaaaaaaaaa##.",
  ".d#####################.",
  ".######################.",
  "a......................a"
  };
*/ 

void VDKCustomButton::ToggleEvent(GtkWidget *wid, gpointer gp)
{
    g_return_if_fail(wid != NULL);
    g_return_if_fail(gp != NULL);
    VDKCustomButton* obj = reinterpret_cast<VDKCustomButton*>(gp);
    obj->Checked(GTK_TOGGLE_BUTTON(wid)->active ? true : false);
    obj->SignalEmit(toggled_signal);
#ifdef USE_SIGCPLUSPLUS
    obj->OnButtonToggled(obj, GTK_TOGGLE_BUTTON(wid)->active ? true : false);
#endif /* USE_SIGCPLUSPLUS */
}

/*
 */
VDKCustomButton::VDKCustomButton(VDKForm* owner, 
				 char* label,
				 unsigned int type):
  VDKObject(owner),
  ButtonBox("ButtonBox",this,NULL),
  Label("Label", this, NULL),
  Pixmap("Pixmap", this, NULL),
  Caption ("Caption", this, label, 
	   &VDKCustomButton::SetCaption, 
	   &VDKCustomButton::GetCaption),
  CaptionWrap ("CaptionWrap", this, true, 
	       &VDKCustomButton::SetCaptionWrap, 
	       &VDKCustomButton::GetCaptionWrap),
  Checked ("Checked", this, false, 
	   &VDKCustomButton::SetChecked, 
	   &VDKCustomButton::GetChecked),
  Relief("Relief", this, GTK_RELIEF_NORMAL, 
	 &VDKCustomButton::SetRelief, 
	 &VDKCustomButton::GetRelief)
{
  VDKBox* buttonbox = NULL;
  bool isCombo = (type & VDK_CBUTTON_TYPEMASK) == VDK_CBUTTON_COMBO;
  bool isToggled = (type & VDK_CBUTTON_TOGGLEMASK) == VDK_CBUTTON_TOGGLED;

  if(isCombo)
    widget = gtk_combobutton_new(); 
  else
    widget = isToggled ? gtk_toggle_button_new (): gtk_button_new();

  ConnectButtonSignals();

  buttonbox = new VDKBox(owner,h_box);

  ButtonBox(buttonbox);

  buttonbox->BorderWidth(0);

  if(label)
    {
      Label(new VDKLabel(owner,label));
      GtkAccelGroup * accel_group = gtk_accel_group_new ();
      guint  accelerator_key;
      if(accel_group)
	gtk_window_add_accel_group(GTK_WINDOW(owner->Window()),
			       accel_group);
      VDKLabel* lbl = Label;
      accelerator_key = gtk_label_parse_uline (GTK_LABEL (lbl->Widget()), 
					      label);
      if (accelerator_key != GDK_VoidSymbol)
	gtk_widget_add_accelerator (widget,
				isToggled ? "toggled" : "clicked",
				accel_group,
				accelerator_key, 
				GDK_MOD1_MASK,
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
      
      // centered by default
      ((VDKLabel*) Label)->Justify = GTK_JUSTIFY_CENTER;
      buttonbox->Add((VDKLabel*) Label,l_justify,true,true,DEFAULT_PADDING);
    }
  gtk_container_add(GTK_CONTAINER(widget), buttonbox->Widget());
  // since buttonbox isn't added via vdk
  // explicitely add to object items.
  AddItem(buttonbox);
  buttonbox->Visible = true;
}

/*
 */
VDKCustomButton:: VDKCustomButton(VDKForm* owner, 
				  char* pixfile, 
				  char* label,
				  unsigned int type,
				  GtkPositionType position):
  VDKObject(owner),
  ButtonBox("ButtonBox",this,NULL),
  Label("Label", this, NULL),
  Pixmap("Pixmap", this, NULL),
  Caption ("Caption", this, label, 
	   &VDKCustomButton::SetCaption, 
	   &VDKCustomButton::GetCaption),
  CaptionWrap ("CaptionWrap", this, true, 
	       &VDKCustomButton::SetCaptionWrap, 
	       &VDKCustomButton::GetCaptionWrap),
  Checked ("Checked", this, false, 
	   &VDKCustomButton::SetChecked, 
	   &VDKCustomButton::GetChecked),
  Relief("Relief", this, GTK_RELIEF_NORMAL, 
	 &VDKCustomButton::SetRelief, &VDKCustomButton::GetRelief)
{
  VDKBox* buttonbox = NULL;
  bool isCombo = (type & VDK_CBUTTON_TYPEMASK) == VDK_CBUTTON_COMBO;
  bool isToggled = (type & VDK_CBUTTON_TOGGLEMASK) == VDK_CBUTTON_TOGGLED;
  if(isCombo)
    widget = gtk_combobutton_new(); 
  else
    widget = isToggled ? gtk_toggle_button_new (): gtk_button_new();


  ConnectButtonSignals();

  if (position == GTK_POS_RIGHT || position == GTK_POS_LEFT)
    buttonbox = new VDKBox(owner,h_box);
  else
    buttonbox = new VDKBox(owner,v_box);
  buttonbox->BorderWidth(0);
  ButtonBox(buttonbox);
  if(pixfile)
    Pixmap(new VDKPixmap(owner,pixfile));
  else
    Pixmap(NULL);

  if(label)
    {
      Label(new VDKLabel(owner,label));
      GtkAccelGroup * accel_group = gtk_accel_group_new ();
      guint  accelerator_key;
      if(accel_group)
	gtk_window_add_accel_group(GTK_WINDOW(owner->Window()),
			       accel_group);
      VDKLabel* lbl = Label;
      accelerator_key = gtk_label_parse_uline (GTK_LABEL (lbl->Widget()), 
					      label);
      if (accelerator_key != GDK_VoidSymbol)
	gtk_widget_add_accelerator (widget,
				isToggled ? "toggled" : "clicked",
				accel_group,
				accelerator_key, 
				GDK_MOD1_MASK,
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
      // centered by default
      ((VDKLabel*) Label)->Justify = GTK_JUSTIFY_CENTER;
    }
  switch (position) 
    {
    case GTK_POS_LEFT:
    case GTK_POS_TOP:
      if(label)
	buttonbox->Add((VDKLabel*) Label, l_justify, true,true,
		       DEFAULT_PADDING);
      if(Pixmap)
  	buttonbox->Add((VDKPixmap*) Pixmap,l_justify,false,false,
		       DEFAULT_PADDING);
      break;
    default:
      if(Pixmap)
	buttonbox->Add((VDKPixmap*) Pixmap,l_justify,false,false,
		       DEFAULT_PADDING);
      if(label)
	buttonbox->Add((VDKLabel*) Label,l_justify,true,true,
		       DEFAULT_PADDING);
      break;
    }
  gtk_container_add(GTK_CONTAINER(widget), buttonbox->Widget());
  // explicitely added to object items.
  AddItem(buttonbox);
  buttonbox->Visible = true;
}

/*
 */
VDKCustomButton:: VDKCustomButton(VDKForm* owner, 
				  char** pixdata, 
				  char* label,
				  unsigned int type,
				  GtkPositionType position):
  VDKObject(owner),
  ButtonBox("ButtonBox",this,NULL),
  Label("Label", this, NULL),
  Pixmap("Pixmap", this, NULL),
  Caption ("Caption", this, label, 
	   &VDKCustomButton::SetCaption, 
	   &VDKCustomButton::GetCaption),
  CaptionWrap ("CaptionWrap", this, true, 
	       &VDKCustomButton::SetCaptionWrap, 
	       &VDKCustomButton::GetCaptionWrap),
  Checked ("Checked", this, false, 
	   &VDKCustomButton::SetChecked, 
	   &VDKCustomButton::GetChecked),
  Relief("Relief", this, GTK_RELIEF_NORMAL, 
	 &VDKCustomButton::SetRelief, &VDKCustomButton::GetRelief)
{
  VDKBox* buttonbox = NULL;
  bool isCombo = (type & VDK_CBUTTON_TYPEMASK) == VDK_CBUTTON_COMBO;
  bool isToggled = (type & VDK_CBUTTON_TOGGLEMASK) == VDK_CBUTTON_TOGGLED;
  if(isCombo)
    widget = gtk_combobutton_new(); 
  else
    widget = isToggled ? gtk_toggle_button_new (): gtk_button_new();


  ConnectButtonSignals();

  if (position == GTK_POS_RIGHT || position == GTK_POS_LEFT)
    buttonbox = new VDKBox(owner,h_box);
  else
    buttonbox = new VDKBox(owner,v_box);
  buttonbox->BorderWidth(0);
  ButtonBox(buttonbox);
  if(pixdata)
    Pixmap(new VDKPixmap(owner,pixdata));
  else
    Pixmap(NULL);
  //    Pixmap(new VDKPixmap(owner,pixbutton_xpm));
  if(label)
    {
      Label(new VDKLabel(owner,label));
      GtkAccelGroup * accel_group = gtk_accel_group_new ();
      guint  accelerator_key;
      if(accel_group)
	gtk_window_add_accel_group(GTK_WINDOW(owner->Window()),
			       accel_group);
      VDKLabel* lbl = Label;
      accelerator_key = gtk_label_parse_uline (GTK_LABEL (lbl->Widget()), 
					      label);
      if (accelerator_key != GDK_VoidSymbol)
	gtk_widget_add_accelerator (widget,
				isToggled ? "toggled" : "clicked",
				accel_group,
				accelerator_key, 
				GDK_MOD1_MASK,
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
      // centered by default
      ((VDKLabel*) Label)->Justify = GTK_JUSTIFY_CENTER;
    }
  switch (position) 
    {
    case GTK_POS_LEFT:
    case GTK_POS_TOP:
      if(label)
	buttonbox->Add((VDKLabel*) Label, l_justify, true,true,
		       DEFAULT_PADDING);
      if(Pixmap)
	buttonbox->Add((VDKPixmap*) Pixmap,l_justify,false,false,
		     DEFAULT_PADDING);
      break;
    default:
      if(Pixmap)
	buttonbox->Add((VDKPixmap*) Pixmap,l_justify,false,false,
		       DEFAULT_PADDING);
      if(label)
	buttonbox->Add((VDKLabel*) Label,l_justify,true,true,
		       DEFAULT_PADDING);
      break;
    }
  gtk_container_add(GTK_CONTAINER(widget), buttonbox->Widget());
  // explicitely added to object items.
  AddItem(buttonbox);
  buttonbox->Visible = true;
}

/*
 */
void
VDKCustomButton::ConnectButtonSignals()
{
  s_clicked.obj = this;
  s_clicked.signal = clicked_signal;
  
  s_enter.obj = this;
  s_enter.signal = enter_signal;
  
  s_leave.obj = this;
  s_leave.signal = leave_signal;
  
  s_toggled.obj = this;
  s_toggled.signal = toggled_signal;

  gtk_signal_connect(GTK_OBJECT(widget),"clicked",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_clicked);
  gtk_signal_connect(GTK_OBJECT(widget),"enter",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_enter);
  gtk_signal_connect(GTK_OBJECT(widget),"leave",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_leave);
  if(GTK_IS_TOGGLE_BUTTON(widget))  
    gtk_signal_connect(GTK_OBJECT(widget),"toggled",
		       GTK_SIGNAL_FUNC(VDKCustomButton::ToggleEvent),
		       reinterpret_cast<gpointer>(this));

#ifdef USE_SIGCPLUSPLUS
  make_gtksigc_connection(this);
  gtk_signal_connect(GTK_OBJECT(widget), "clicked", 
		     GTK_SIGNAL_FUNC(VDKCustomButton::_handle_clicked),
		     reinterpret_cast<gpointer>(this));
  
  gtk_signal_connect(GTK_OBJECT(widget), "pressed", 
		     GTK_SIGNAL_FUNC(VDKCustomButton::_handle_pressed),
		     reinterpret_cast<gpointer>(this));

  gtk_signal_connect(GTK_OBJECT(widget), "leave", 
		     GTK_SIGNAL_FUNC(VDKCustomButton::_handle_leave),
		     reinterpret_cast<gpointer>(this));
#endif /* USE_SIGCPLUSPLUS */
  ConnectDefaultSignals();
}

/*
 */
VDKCustomButton:: ~VDKCustomButton()
{
}
/*
 */
void
VDKCustomButton::Enable(bool flag)
{
  VDKObject::Enable(flag);
  VDKPixmap* pix = Pixmap;
  if(pix)
    pix->Enabled = flag;
  VDKLabel* lbl = Label;
  if(lbl)
    lbl->Enabled = flag;
}


void 
VDKCustomButton::SetComboMenu(VDKMenu* menu)
{
  if(GTK_COMBOBUTTON(widget))
    {
      gtk_combobutton_set_menu (GTK_COMBOBUTTON(widget),menu->Widget());
      menu->Parent(this);
      menu->Owner()->AddItem(menu);
    }
}

#ifdef USE_SIGCPLUSPLUS
void
VDKCustomButton::_handle_clicked(GtkWidget* wid, gpointer gp)
{
     VDKCustomButton* obj=reinterpret_cast<VDKCustomButton*>(gp);
     obj->OnButtonClicked(obj);
}

void
VDKCustomButton::_handle_pressed(GtkWidget* wid, gpointer gp)
{
     VDKCustomButton* obj=reinterpret_cast<VDKCustomButton*>(gp);
     obj->OnButtonPressed(obj);
}

void
VDKCustomButton::_handle_leave(GtkWidget* wid, gpointer gp)
{
     VDKCustomButton* obj=reinterpret_cast<VDKCustomButton*>(gp);
     obj->OnButtonLeave(obj);
}
#endif /* USE_SIGCPLUSPLUS */
