/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * February 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include <vdk/image.h>
#include <vdk/forms.h>
#include <vdk/colors.h>
#include <vdk/tooltips.h>
#include <cstdio>
#include <string>
#include <unistd.h>
#include <vdk/rawpixbuf.h>

/*
 */
VDKImage::VDKImage(VDKForm* owner,
		   const char* pixfile,
		   char* tipString,
		   bool sensitive):
  VDKObject(owner)
{
  width = height = 0;
  if(sensitive)
    widget = gtk_event_box_new();
  else
    widget = gtk_vbox_new(true,0);
  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());
  if(pixfile)
    {
      pixmap = new VDKPixbuf(owner,pixfile);
      if(pixmap != NULL)
	{ 
	  pixmapWid =  sigwid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	  width = pixmap->Width();
	  height = pixmap->Height();
	  gtk_widget_set_size_request(widget,width,height);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	  gtk_widget_show(pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = NULL;
  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;
  ConnectDefaultSignals();
  
}
/*
 */
VDKImage::VDKImage(VDKForm* owner,
		   const char** pixdata,
		   char* tipString,
		   bool sensitive):
  VDKObject(owner)
{
  width = height = 0;
  if(sensitive)
    widget = gtk_event_box_new();
  else
    widget = gtk_vbox_new(true,0);
  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());
  if(pixdata)
    {
      pixmap = new VDKPixbuf(owner,pixdata);
      if(pixmap != NULL)
	{
	  pixmapWid =  sigwid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	  width = pixmap->Width();
	  height = pixmap->Height();
	  gtk_widget_set_size_request(widget,width+1,height+1);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	  gtk_widget_show(pixmapWid);
	  gtk_widget_queue_draw(pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = NULL;

  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;

  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event",
		      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this);
  ConnectDefaultSignals();
}

VDKImage::~VDKImage()
{
}
/*
 */
VDKPixbuf* VDKImage::SetImage(const char* file)
{
  return SetImage(new VDKPixbuf(this,file));
}
/*
 */
VDKPixbuf* VDKImage::SetImage(const char** pixdata)
{
  return SetImage(new VDKPixbuf(this,pixdata));
}


// static void clear_widget(GtkWidget * widget);
VDKPixbuf*
VDKImage::SetImage(VDKPixbuf* newpix)
{
  VDKPixbuf* oldpix;
  if(oldRawPix == newpix)
    return NULL;
  else
    {
      oldpix = oldRawPix;
      if(pixmap)
	{
	  pixmap = NULL;
	}
      if(pixmapWid)
	{
	    pixmap = newpix;
	    gtk_image_set_from_pixbuf(GTK_IMAGE(pixmapWid),
                                   pixmap->AsGdkPixbuf());
	    gtk_widget_queue_draw(pixmapWid);
	}	
      else
	{
	    pixmap = newpix;
	    pixmapWid = gtk_image_new_from_pixbuf(pixmap->AsGdkPixbuf());
	    gtk_widget_set_size_request(widget,newpix->Width(),newpix->Height());
	    gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	    gtk_widget_show(pixmapWid);
	}
      oldRawPix = newpix;
    }
  return oldpix;
}
