/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <config.h>
#include <vdkb/vdkb_ide_def.h>
#include <vdkb/vdkb_locale.h>
#include <stdlib.h>
extern char* 
ExtractWord(char* src,char* tgt,char* key1,char* key2);
extern char *
ExtractSection (char *buffer, char *section_begin, char* section_end); 
static char *avoid = "\"\r\n\t ";
static char buffer[256];
/*
 */
VDKBDefaults::VDKBDefaults(char* resFile):editor(),unit()
{
  rcFile = resFile ? resFile : DEFAULTS_FILE;
}
/* 
 */
void 
VDKBDefaults::LoadDefaults(char* home)
{
  char* buff,*p,*section;
  struct stat info;
  char* file;
  // look at user home
  sprintf(buffer,"%s/.vdkb/%s",home,(char*) rcFile);
  if (stat(buffer,&info) == -1)
    // look at share dir
    sprintf(buffer,"%s/%s",VDKB_DATADIR,(char*) rcFile);
  file = buffer;
  if(stat(file,&info) == -1)
    {
      printf("%s",_(user_messages[user_nodefaults]));
      fflush(stdout);
      exit(1);
    }
  
  FILE* fp = fopen(file,"r");
  if(fp)
    {
      int c;
      buff = p = new char[info.st_size+1];
      while( (c = fgetc(fp)) != EOF)
	{
	  if (!strchr (avoid, c))
	    *p++ = (char) c;
	}
      /*
       */
      *p = '\0';
      fclose(fp);
    }
  else 
    return;
  // load editor defaults
  if((section = ExtractSection(buff,EDITOR_SECTION,END_SECTION)))
    {
      editor.LoadDefaults(section);
      delete[] section;
    }
  // load unit defaults
  if((section = ExtractSection(buff,UNIT_SECTION,END_SECTION)))
    {
      unit.LoadDefaults(section);
      delete[] section;
    }
  // load project defaults
  if((section = ExtractSection(buff,PROJECT_SECTION,END_SECTION)))
    {
      project.LoadDefaults(section);
      delete[] section;
    }
  // finished
  delete[] buff;
}
/////////////////// Editor defaults class ///////////
void 
VDKBEditorDefaults::LoadDefaults(char* section)
{
  int hsize = 0;
  int vsize = 0;
  char *key = new char[128];
  if((key = ExtractWord(section,key,FONT_KEY,END_KEY)))
      font = key;
  if((key = ExtractWord(section,key,FG_KEY,END_KEY)))
      fg = key;
  if((key = ExtractWord(section,key,BG_KEY,END_KEY)))
      bg = key;
  if((key = ExtractWord(section,key,EDITOR_HSIZE_KEY,END_KEY)))
      hsize = atoi(key);
  else
    hsize = 0;
  if((key = ExtractWord(section,key,EDITOR_VSIZE_KEY,END_KEY)))
    vsize = atoi(key);
  else
    vsize = 0;
  if( (hsize > 0) & (vsize > 0) )
      size = VDKPoint(hsize,vsize);
  // syntax colors
  if((key = ExtractWord(section,key,EDITOR_COMMENT_COLOR_KEY,END_KEY)))
      comment_color = key;
  if((key = ExtractWord(section,key,EDITOR_CHARS_CONST_COLOR_KEY,END_KEY)))
      chars_const_color = key;
  if((key = ExtractWord(section,key,EDITOR_STRING_CONST_COLOR_KEY,END_KEY)))
      string_const_color = key;
  if((key = ExtractWord(section,key, EDITOR_KEY_COLOR_KEY,END_KEY)))
      key_color = key;
  if((key = ExtractWord(section,key, EDITOR_PREPROCESS_COLOR_KEY,END_KEY)))
      preprocess_color = key;
  // syntax fonts
  if((key = ExtractWord(section,key,EDITOR_COMMENT_FONT_KEY,END_KEY)))
      comment_font = key;
  if((key = ExtractWord(section,key,EDITOR_CHARS_CONST_FONT_KEY,END_KEY)))
      chars_const_font = key;
  if((key = ExtractWord(section,key,EDITOR_STRING_CONST_FONT_KEY,END_KEY)))
      string_const_font = key;
  if((key = ExtractWord(section,key, EDITOR_KEY_FONT_KEY,END_KEY)))
      key_font = key;
  // timed saving
  if((key = ExtractWord(section,key, EDITOR_KEY_TIMEDSAVE,END_KEY)))
      timedsave = key;
  // file backup
  if((key = ExtractWord(section,key, EDITOR_KEY_BACKUP,END_KEY)))
      backup = key;
  // editor tab
  if((key = ExtractWord(section,key, EDITOR_KEY_TAB,END_KEY)))
      tab = key;
  // finished
  delete[] key;
}
 
/////////////////// Unit defaults class ///////////
void 
VDKBUnitDefaults::LoadDefaults(char* section)
{
  char *key = new char[128];
  if((key = ExtractWord(section,key,UNIT_COUNT_KEY,END_KEY)))
    count = atoi(key);
  if((key = ExtractWord(section,key,UNIT_NAME_KEY,END_KEY)))
    def_name = key;
  if((key = ExtractWord(section,key,UNIT_CC_EXT_KEY,END_KEY)))
    cc_ext = key;
  if((key = ExtractWord(section,key,UNIT_H_EXT_KEY,END_KEY)))
    h_ext = key;
  // finished
  delete[] key;
}

/////////////////// Project defaults class ///////////
void 
VDKBProjectDefaults::LoadDefaults(char* section)
{
  char *key = new char[128];
  if((key = ExtractWord(section,key,PROJECT_COUNT_KEY,END_KEY)))
    count = atoi(key);
  if((key = ExtractWord(section,key,PROJECT_NAME_KEY,END_KEY)))
    def_name = key;
  if((key = ExtractWord(section,key,PROJECT_PRJ_EXT_KEY,END_KEY)))
    prj_ext = key;
  if((key = ExtractWord(section,key,PROJECT_HIDE_ON_RUN_KEY,END_KEY)))
    hide_on_run = key;
  if((key = ExtractWord(section,key,PROJECT_AUTOSAVE_KEY,END_KEY)))
    autosave = key;
  if((key = ExtractWord(section,key,PROJECT_STARTUPDIR_KEY,END_KEY)))
    startupdir = key;
  if((key = ExtractWord(section,key,PROJECT_WI_RESIZEABLE_KEY,END_KEY)))
    wi_resizeable = key;
  if((key = ExtractWord(section,key,PROJECT_VDK_REF_PATH_KEY,END_KEY)))
    vdk_ref_path = key;
  if((key = ExtractWord(section,key,PROJECT_SAVE_SESSION_KEY,END_KEY)))
    save_session = key;
  if((key = ExtractWord(section,key,PROJECT_CODE_INDENT_KEY,END_KEY)))
    code_indent = key;
  if((key = ExtractWord(section,key,PROJECT_RUN_MODAL_KEY,END_KEY)))
    run_modal = key;
  if((key = ExtractWord(section,key,PROJECT_EMACS_KEY,END_KEY)))
    emacs = key;
  if((key = ExtractWord(section,key,PROJECT_CODE_AUTOINDENT_KEY,END_KEY)))
    code_autoindent = key;
  if((key = ExtractWord(section,key,PROJECT_SHOWLN_KEY,END_KEY)))
    showln = key;
  if((key = ExtractWord(section,key,PROJECT_EXTASCII_KEY,END_KEY)))
    extascii = key;
  // finished
  delete[] key;
}




