#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "msglist.h"
#include "aboutdialog.h"
#include "vmacfg.h"
#include "vmacfglist.h"
#include "vmastyles.h"
#include "vma.h"
#include "vmautils.h"
#include "config.h"
#include "compiletimeinfo.h"
#include "messages.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif

#include "images/icon_ok_20x20.xpm"
#include "images/vertex_heading_400x200.xpm"
#include "vertex.xpm"


static void AboutDialogSwitchPageCB(
        GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
        gpointer data
);
static void AboutDialogOKCB(GtkWidget *widget, gpointer data);
static gint AboutDialogCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void AboutDialogDestroyCB(GtkObject *object, gpointer data);

about_dialog_struct *AboutDialogNew(gpointer core_ptr);
void AboutDialogMap(about_dialog_struct *ad);
void AboutDialogUnmap(about_dialog_struct *ad);
void AboutDialogDelete(about_dialog_struct *ad);


#define ABOUT_DIALOG_WIDTH	500
#define ABOUT_DIALOG_HEIGHT	420

#define ABOUT_DIALOG_BTN_WIDTH	(100 + (2 * 3))
#define ABOUT_DIALOG_BTN_HEIGHT	(30 + (2 * 3))


/*
 *      Notebook switch page callback.
 */
static void AboutDialogSwitchPageCB(
        GtkNotebook *notebook, GtkNotebookPage *page, guint page_num,
        gpointer data
)
{
        static gbool reenterant = FALSE;
        GtkWidget *w;
        about_dialog_struct *ad = (about_dialog_struct *)data;
        if((notebook == NULL) || (ad == NULL))
            return;

        if(reenterant)
            return;
        else
            reenterant = TRUE;

        if(!ad->initialized)
            return;

        /* Main notebook? */
        w = ad->notebook;
        if((gpointer)w == (gpointer)notebook)
        {



        }

        reenterant = FALSE;
}

/*
 *	Ok callback.
 */
static void AboutDialogOKCB(GtkWidget *widget, gpointer data)
{
	about_dialog_struct *ad = (about_dialog_struct *)data;
	if(ad == NULL)
	    return;

	AboutDialogUnmap(ad);
}

/*
 *	Close callback.
 */
static gint AboutDialogCloseCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	AboutDialogOKCB(widget, data);

	return(TRUE);
}

/*
 *	Destroy callback.
 */
static void AboutDialogDestroyCB(GtkObject *object, gpointer data)
{
	return;
}


/*
 *	Create a new about dialog.
 */
about_dialog_struct *AboutDialogNew(void *core_ptr)
{
	gint i, n;
	gint border_major = 5, border_minor = 2;
	GdkWindow *window, *root;
        GtkWidget *w, *parent, *parent2, *parent3, *parent4, *main_vbox;
	GtkAccelGroup *accelgrp;
	gpointer w_rtn1, w_rtn2;
	GtkEntry *entry;
	GtkStyle *style;
	GtkRcStyle *rcstyle;
        GtkCList *clist;
        gchar *heading[1];
	const gchar *cstrptr;
	const gchar *credits_lines[] = CREDITS_LINES;
	const gchar *msglist_std[] = VMA_MSGLIST_STD_MESSAGE_LIST;
	gint gl_version_major, gl_version_minor;
	const gchar *gl_renderer, *gl_vendor, *gl_extensions;
	gchar tmp_path[PATH_MAX + NAME_MAX];
	gchar version_string[512];
        about_dialog_struct *ad = (about_dialog_struct *)g_malloc0(
	    sizeof(about_dialog_struct)
        );
        if(ad == NULL)
            return(NULL);


        /* Reset values. */
        ad->initialized = TRUE;
        ad->map_state = FALSE;


	/* Keyboard accelerator group. */
	ad->accelgrp = accelgrp = gtk_accel_group_new();


        /* Toplevel. */
	ad->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_widget_set_usize(w, ABOUT_DIALOG_WIDTH, ABOUT_DIALOG_HEIGHT);
        gtk_widget_realize(w);
        window = w->window;
	root = GDK_ROOT_PARENT();
        if(window != NULL)
        {
            gdk_window_set_decorations(
                window,
                GDK_DECOR_TITLE | GDK_DECOR_MENU | GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
	    GUISetWMIcon(window, (u_int8_t **)vertex_xpm);
	    if(root != NULL)
	    {
                gint rx, ry, rw, rh, rd;

                gdk_window_get_geometry(
                    root, &rx, &ry, &rw, &rh, &rd
                );
                gtk_widget_set_uposition(
                    w,
                    (rw / 2) - (w->allocation.width / 2),
                    (rh / 2) - (w->allocation.height / 2)
                );
	    }
        }
	gtk_window_set_title(
	    GTK_WINDOW(w),
	    "About " PROG_NAME
	);
        gtk_signal_connect(
            GTK_OBJECT(w), "delete_event",
            GTK_SIGNAL_FUNC(AboutDialogCloseCB),
            (gpointer)ad
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "destroy",
            GTK_SIGNAL_FUNC(AboutDialogDestroyCB),
            (gpointer)ad
        );
        gtk_container_border_width(GTK_CONTAINER(w), 0);
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        parent = w;


        /* Main vbox. */
	ad->main_vbox = main_vbox = w = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);
        parent = w;

	/* Vbox to hold notebook. */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent = w;

	/* Notebook. */
        ad->notebook = w = gtk_notebook_new();
        gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
        gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
        gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
/*      gtk_notebook_set_page(GTK_NOTEBOOK(w), 0); */
        gtk_signal_connect(
            GTK_OBJECT(w), "switch_page",
            GTK_SIGNAL_FUNC(AboutDialogSwitchPageCB),
	    (gpointer)ad
        );
        gtk_widget_show(w);
        parent2 = w;


        /* Credits Page ********************************************* */

	/* Credits page vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_notebook_append_page(
            GTK_NOTEBOOK(parent2),
            w,
            gtk_label_new("Credits")
        );
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

	/* Heading image. */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent4 = w;

	w = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_OUT);
	gtk_widget_show(w);
	parent4 = w;

	w = (GtkWidget *)GUICreateMenuItemIcon(
	    (u_int8_t **)vertex_heading_400x200_xpm
	);
	gtk_widget_set_usize(w, 400, 200);
	gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_widget_show(w);

	/* Credits clist. */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
	    GTK_SCROLLED_WINDOW(w),
	    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;

	heading[0] = g_strdup("None");
	ad->credits_clist = w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	g_free(heading[0]);
	gtk_clist_column_titles_passive(clist);
        gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE);
/*
	gtk_clist_set_column_width(clist, 0, 320);
 */
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_show(w);

	/* Add credits to credits clist. */
	gtk_clist_freeze(clist);
	i = 0;
        style = styles_list.text_fine_print;
	while(credits_lines[i] != NULL)
	{
	    heading[0] = g_strdup(credits_lines[i]);
	    n = gtk_clist_append(clist, heading);
	    g_free(heading[0]);
	    if(style != NULL)
		gtk_clist_set_row_style(clist, n, style);
	    i++;
	}
	gtk_clist_thaw(clist);


	/* Copyright Page ***************************************** */

        /* Copyright page vbox. */   
        w = gtk_vbox_new(FALSE, border_major);
        gtk_notebook_append_page(    
            GTK_NOTEBOOK(parent2),
            w,
            gtk_label_new("Copyright")
        );
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Copyright label. */
	cstrptr = MsgListMatchCaseMessage(
	    msglist_std, VMA_MSGNAME_STD_COPYRIGHT
	);
	if(cstrptr != NULL)
	{
	    rcstyle = gtk_rc_style_new();

	    g_free(rcstyle->font_name);
	    rcstyle->font_name = g_strdup(VMA_GTK_FONT_NAME_TEXT_HEADING6);

	    w = gtk_label_new(cstrptr);
/*
	    gtk_widget_modify_style(w, rcstyle);
 */
	    gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	    gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	    gtk_widget_show(w);

	    GUIRCStyleDeallocUnref(rcstyle);
	}

	/* License. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

	heading[0] = g_strdup("None");
	w = gtk_clist_new_with_titles(1, heading);
	clist = GTK_CLIST(w);
	g_free(heading[0]);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_column_titles_hide(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_BROWSE);
	gtk_clist_set_column_width(clist, 0, 640);
	gtk_widget_set_usize(w, -1, 200);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_show(w);
	/* Load license file to clist. */
	cstrptr = (const gchar *)PrefixPaths(
	    VMACFGItemListGetValueS(option, VMA_CFG_PARM_DIR_GLOBAL),
	    VMA_DEF_FILE_LICENSE
	);
        style = styles_list.text_fine_print;
	if(cstrptr != NULL)
	{
	    strncpy(tmp_path, cstrptr, PATH_MAX + NAME_MAX);
	    tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

	    gtk_clist_freeze(clist);
	    VMATextFileToCList(clist, tmp_path, style);
	    gtk_clist_thaw(clist);
	}


	/* Version Page ********************************************** */

        /* Version page vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_notebook_append_page(
            GTK_NOTEBOOK(parent2),
            w,
            gtk_label_new("Version")
        );
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;


        /* Program version. */
	/* Frame. */
	w = gtk_frame_new("Vertex");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Vbox in frame. */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent4 = w;
        /* Version prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Version:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
        gtk_entry_set_text(entry, PROG_VERSION);
	/* Compiler prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Compiler:", &w_rtn1, &w_rtn2);
	entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
	/* Set initial value. */
        gtk_entry_set_text(entry, COMPILE_COMPILER);
        /* Location prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Location:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
        gtk_entry_set_text(entry, COMPILE_LOCATION);


        /* GTK+ version. */
        /* Frame. */
        w = gtk_frame_new("GTK+");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;
        /* Vbox in frame. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent4 = w;
        /* Version prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Version:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
	sprintf(version_string, "%i.%i.%i",
	    gtk_major_version, gtk_minor_version, gtk_micro_version
	);
        gtk_entry_set_text(entry, version_string);

        /* OpenGL version. */
        /* Frame. */
        w = gtk_frame_new("OpenGL");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);  
        gtk_widget_show(w);
        parent4 = w;
        /* Vbox in frame. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent4 = w;
        /* Version prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Version:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
	if(!VMAGetGLVersion(
	    core_ptr, &gl_version_major, &gl_version_minor,
	    &gl_renderer, &gl_vendor, &gl_extensions
	))
	{
	    sprintf(version_string, "%i.%i",
		gl_version_major, gl_version_minor
	    );
	    gtk_entry_set_text(entry, version_string);
	}
        /* Renderer prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Renderer:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
	if(gl_renderer != NULL)
	    gtk_entry_set_text(entry, gl_renderer);
        /* Vendor prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Vendor:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
        if(gl_vendor != NULL)
            gtk_entry_set_text(entry, gl_vendor);
        /* Extensions prompt. */
        w = (GtkWidget *)GUIPromptBar(NULL, "Extensions:", &w_rtn1, &w_rtn2);
        entry = (GtkEntry *)w_rtn2;
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_entry_set_editable(entry, FALSE);
        gtk_widget_set_usize(GTK_WIDGET(entry), 200, -1);
        gtk_widget_show(w);
        /* Set initial value. */
        if(gl_extensions != NULL) 
            gtk_entry_set_text(entry, gl_extensions);








        /* Hbox to hold buttons homogeniously. */
        w = gtk_hbox_new(TRUE, 0);   
        gtk_box_pack_start(GTK_BOX(main_vbox), w, FALSE, FALSE, border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Ok button. */
        w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_ok_20x20_xpm, "OK", NULL
        );
        ad->ok_btn = w;
        gtk_widget_set_usize(w,
	    ABOUT_DIALOG_BTN_WIDTH, ABOUT_DIALOG_BTN_HEIGHT
	);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(AboutDialogOKCB),
            (gpointer)ad
        );
        gtk_accel_group_add(
            accelgrp, GDK_space, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_Return, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_3270_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_KP_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_ISO_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);

	return(ad);
}


/*
 *	Map about dialog.
 */
void AboutDialogMap(about_dialog_struct *ad)
{
        GtkWidget *w;

        if(ad == NULL)
            return;
  
        if(!ad->initialized)
            return;
 
        if(!ad->map_state)
        {
            w = ad->notebook;
            if(w != NULL)
                gtk_notebook_set_page(GTK_NOTEBOOK(w), 0);

            w = ad->ok_btn;
            if(w != NULL)
	    {
		gtk_widget_grab_focus(w);
		gtk_widget_grab_default(w);
	    }

            ad->map_state = TRUE;
	    w = ad->toplevel;
	    if(w != NULL)
		gtk_widget_show(w);
        }
}

/*
 *	Unmap about dialog.
 */
void AboutDialogUnmap(about_dialog_struct *ad)
{
        GtkWidget *w;

        if(ad == NULL)
            return;

        if(!ad->initialized)
            return;

        w = ad->toplevel;
        if(w == NULL)
            return;

        if(ad->map_state)
        {
            ad->map_state = FALSE;
            gtk_widget_hide(w);
        }

        return;
}

/*
 *	Destroys about dialog widgets and deallocates resources including
 *	the structure itself.
 */
void AboutDialogDelete(about_dialog_struct *ad)
{
        GtkWidget **w;


        if(ad == NULL)
            return;

        if(ad->initialized)
        {
#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

	    w = &ad->ok_btn;
	    DO_DESTROY_WIDGET

	    w = &ad->toplevel;
	    DO_DESTROY_WIDGET

	    if(ad->accelgrp != NULL)
	    {
		gtk_accel_group_unref(ad->accelgrp);
		ad->accelgrp = NULL;
	    }

#undef DO_DESTROY_WIDGET
        }   

	/* Deallocate the structure itself. */
	g_free(ad);
}
