/*
               VMA Texture Browser (used with the Editor)
 */

#ifndef TEXBROWSER_H
#define TEXBROWSER_H

#include <gtk/gtk.h>
#include "v3dtex.h"

#ifndef gbool
# define gbool	guchar
#endif

/* Sort codes. */
#define TEXBROWSER_LIST_SORT_ADDED	0	/* `As is' (aka by index). */
#define TEXBROWSER_LIST_SORT_NAME	1	/* Sort by referance name. */
#define TEXBROWSER_LIST_SORT_PATH	2	/* Sort by file name. */
#define TEXBROWSER_LIST_SORT_PRIORITY	3	/* Short by priority (hi to lo). */

/* Flags. */
#define MA_TEXBROWSER_FLAG_BUTTON1		(1 << 1)
#define MA_TEXBROWSER_FLAG_BUTTON2		(1 << 2)
#define MA_TEXBROWSER_FLAG_BUTTON3		(1 << 3)
#define MA_TEXBROWSER_FLAG_KEY_TRANSLATE	(1 << 4)
#define MA_TEXBROWSER_FLAG_KEY_ZOOM		(1 << 5)
#define MA_TEXBROWSER_FLAG_KEY_ZOOM_RECT	(1 << 6)

/* Drag state codes. */
#define MA_TEXBROWSER_DRAG_NONE			0
#define MA_TEXBROWSER_DRAG_TRANSLATE		1
#define MA_TEXBROWSER_DRAG_ZOOM			2
#define MA_TEXBROWSER_DRAG_ZOOM_RECT		3


/*
 *	Texture browser preview window structure:
 */
typedef struct {

        gbool initialized;
	gbool realized;

	unsigned int flags;

        GtkWidget       *toplevel,	/* Table. */
			*preview,
			*preview_vsb,
			*preview_hsb,
			*zoom_in_btn, *zoom_out_btn,
			*zoom_to_fit_btn,
			*zoom_one_to_one_btn,
			*zoom_label;

	GtkAdjustment	*preview_vadj,
			*preview_hadj;

        /* Popup menu over preview glarea. */ 
        GtkWidget       *preview_menu,
                        *preview_zoom_to_fit_mi,
			*preview_zoom_one_to_one_mi,
			*preview_properties_mi;

	/* Window pixels to data pixels coeff. */
	double zoom_coeff_wtod;
	double zoom_min_wtod, zoom_max_wtod;
	int xw, yw;
	int ww, hw;

	/* Cursors. */
	GdkCursor	*translate_cur,
			*zoom_cur,
			*zoom_rect_cur;

	/* One of MA_TEXBROWSER_DRAG_* */
	int drag_state;
	int last_xw, last_yw;
        int zoom_rect_start_xw, zoom_rect_start_yw;

        /* Preview texture. */
	v3d_texture_ref_struct *tex;

	int tex_width, tex_height;

} ma_texbrowser_preview_struct;

/*
 *	Texture browser structure:
 */
typedef struct {

        gbool initialized;      /* TRUE if intiallied. */
        gbool map_state;        /* TRUE if shown (mapped). */
	gbool processing;

        GtkWidget	*toplevel,
			*menu_bar,
			*menu_bar_dock,
			*general_tool_ribbon,
			*general_tool_ribbon_dock,
			*add_btn, *remove_btn, *properties_btn,
			*reload_btn,
			*base_dir_ribbon,
			*base_dir_override_check,
			*base_dir_entry,
			*base_dir_browse_btn,
			*search_ribbon,
			*search_combo,
			*search_ribbon_dock,
			*preview_label_vbox,	/* Holds preview_label_table. */
			*preview_label_table,	/* Can be NULL. */
			*textures_list,
			*close_on_select_check,
			*texture_select_btn,
			*close_btn;

	/* Important menu items. */
	GtkWidget	*select_mi,
			*add_mi,
			*remove_mi,
			*select_all_mi,
			*unselect_all_mi,
			*close_on_select_micheck,
			*properties_mi,
			*sort_by_index_micheck,
			*sort_by_name_micheck,
			*sort_by_path_micheck,
			*sort_by_priority_micheck;

	/* Popup menu over textures list. */
	GtkWidget	*textures_list_menu,
			*texture_list_select_mi,
                        *texture_list_remove_mi,
                        *texture_list_properties_mi;

	gint list_sort_code;	/* One of TEXBROWSER_LIST_SORT_*. */

	/* Preview window structure. */
	ma_texbrowser_preview_struct preview;

        /* Cursors. */
	GdkCursor	*busy_cur;

	/* Textures base directory override? */
	gbool base_dir_override;

	/* Close when a texture has been selected? */
	gbool close_on_select;

	/* Note, client_data value in each list item (colum 0) in the
	 * textures_list indicates index value of corresponding
	 * texture on the editor structure.
	 */

	/* Selected texture on textures_list, not nessasary corresponds
	 * with editor's texture list.
	 */
	int *selected_texture;
	int total_selected_textures;

	/* Pointer back to editor structure. */
	void *editor_ptr;

} ma_texture_browser_struct;



extern void TexBrowserSetBusy(ma_texture_browser_struct *tb);
extern void TexBrowserSetReady(ma_texture_browser_struct *tb);

extern int TexBrowserCreate(
	ma_texture_browser_struct *tb,
	void *editor
);
extern int TexBrowserPreviewEnableContext(ma_texture_browser_struct *tb);
extern void TexBrowserUpdateMenus(ma_texture_browser_struct *tb);
extern void TexBrowserReset(ma_texture_browser_struct *tb, gbool unmap);
extern void TexBrowserDestroy(ma_texture_browser_struct *tb);

extern void TexBrowserMap(ma_texture_browser_struct *tb);
extern void TexBrowserUnmap(ma_texture_browser_struct *tb);



#endif	/* TEXBROWSER_H */
