/*
                          Tip Of The Day Window
 */

#ifndef TIPOFDAY_H
#define TIPOFDAY_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Tip of day window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget	*toplevel,
			*label,
			*show_tips_next_time_check,
			*ok_btn,
			*next_tip_btn;

	/* List of tips, an array of pointers to strings which are
	 * the tip messages. Each message comes as a pair of pointers
	 * where the first pointer is a parameter string for matching
	 * and the second is the actual message. The last two pointers in
	 * the array must both be NULL.
	 */
	const gchar **tips_list;

	/* Currently used tip index on the tips list. */
	gint tip_index;

	/* Total number of tips (if tips_list is not NULL). */
	gint total_tips;

	/* Show tip next time toggled callback. */
	gpointer client_data;
	void (*show_tip_next_time_cb)(GtkWidget *, gpointer);


} todwin_struct;


extern todwin_struct *TODWinNew(
        gpointer core_ptr,
        const gchar **tips_list,
	gbool show_tips_next_time,
        gpointer client_data,
        void (*show_tip_next_time_cb)(GtkWidget *, gpointer)
);
extern void TODWinMapTip(todwin_struct *tw, glong seed, gint i);
extern void TODWinMap(todwin_struct *tw);
extern void TODWinUnmap(todwin_struct *tw);
extern void TODWinDelete(todwin_struct *tw);

#endif	/* TIPOFDAY_H */
