/*
        Vertex 3D Model Assembler - Color Primitive selection dialog

	Not to be confused with the color selection dialog from csd.h.
 */

#ifndef CLRSEL_H
#define CLRSEL_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <gtk/gtk.h>

#include "v3dtex.h"
#include "v3dmp.h"


/*
 *	Color selection dialog:
 */
typedef struct {

	gbool initialized;
	gbool realized;			/* View glarea realized. */
	gbool map_state;

	gpointer editor_ptr;		/* Pointer back to editor. */

	GtkAccelGroup	*accelgrp;

        GtkWidget       *toplevel,

			*view,		/* View glarea */
			*color_da,	/* GtkDrawingArea */

			*red_scale, *red_entry,
			*green_scale, *green_entry,
			*blue_scale, *blue_entry,
			*alpha_scale, *alpha_entry,

			*ambient_scale, *ambient_entry,
			*diffuse_scale, *diffuse_entry,
			*specular_scale, *specular_entry,
			*shininess_scale, *shininess_entry,
			*emission_scale, *emission_entry,
			*update_view_check,
			*set_btn, *apply_btn, *close_btn;

	gint view_width, view_height;

	/* GLU quadrics object for drawing the view's scene. */
	GLUquadricObj *qobj;

	/* Texture for the background. */
	v3d_texture_ref_struct *bg_texture;

	/* Displayed 3d quadrics type:
	 *	0	Spehere
	 *	1	Cylender
	 *	2	Cone
	 *	3	Rectangle (slightly rotated)
	 */
	gint qobj_type;
	GtkWidget	*qobj_type_label,
			*qobj_type_prev_btn,
			*qobj_type_next_btn;

	/* Position of light about xy plane, from 0.0 * PI to 2.0 * PI,
	 * where 0.0 * PI is behind the object and 1.0 * PI is in front
	 * of object in clockwise rotation.
	 */
	gdouble light_origin;

	/* Light intensity scale. */
	GtkWidget *light_scale, *light_entry;

} vma_clrsel_struct;


extern void ClrSelDrawView(vma_clrsel_struct *cs);
extern void ClrSelDrawColorDA(vma_clrsel_struct *cs);

extern int ClrSelCreate(vma_clrsel_struct *cs, gpointer editor);
extern int ClrSelViewEnableContext(vma_clrsel_struct *cs);
extern void ClrSelFetchFromEditor(vma_clrsel_struct *cs);
extern void ClrSelUpdateMenus(vma_clrsel_struct *cs);
extern void ClrSelMap(vma_clrsel_struct *cs);
extern void ClrSelUnmap(vma_clrsel_struct *cs);  
extern void ClrSelReset(vma_clrsel_struct *cs, gbool need_unmap);
extern void ClrSelDestroy(vma_clrsel_struct *cs);


#endif	/* CLRSEL_H */
