" This file is autogenerated from the script 'generate_L2U_keymap.jl'
" The symbols are based on Julia version 1.1.0-DEV.695
" The full generating script can be found in the comments at the bottom of this file,
" and it can be extracted with:
"
"     $ grep '^">' latex2unicode_utf-8.vim | cut -c4- > generate_L2U_keymap.jl'
"
" To produce this keymap file you need to have Julia compilied from source, and
" to run `make UnicodeData.txt` inside Julia's `doc` directory.
" Then you can run:
"
"     $ julia generate_L2U_keymap.jl.jl
"

scriptencoding utf-8

let b:keymap_name = "L2U"
loadkeymap

" Tab completion sequence           Code point                   " Character  : Unicode name
" --------------------------------- ---------------------------- " ---------- : --------------------------------------------------------------------------------------------------------
\\0/3                               <char-0x02189>               " ↉          : VULGAR FRACTION ZERO THIRDS
\\1/                                <char-0x0215F>               " ⅟          : FRACTION NUMERATOR ONE
\\1/1                               \\1/1                        "            : (Incomplete sequence)
\\1/10                              <char-0x02152>               " ⅒          : VULGAR FRACTION ONE TENTH
\\1/2                               <char-0x000BD>               " ½          : VULGAR FRACTION ONE HALF / FRACTION ONE HALF
\\1/3                               <char-0x02153>               " ⅓          : VULGAR FRACTION ONE THIRD / FRACTION ONE THIRD
\\1/4                               <char-0x000BC>               " ¼          : VULGAR FRACTION ONE QUARTER / FRACTION ONE QUARTER
\\1/5                               <char-0x02155>               " ⅕          : VULGAR FRACTION ONE FIFTH / FRACTION ONE FIFTH
\\1/6                               <char-0x02159>               " ⅙          : VULGAR FRACTION ONE SIXTH / FRACTION ONE SIXTH
\\1/7                               <char-0x02150>               " ⅐          : VULGAR FRACTION ONE SEVENTH
\\1/8                               <char-0x0215B>               " ⅛          : VULGAR FRACTION ONE EIGHTH / FRACTION ONE EIGHTH
\\1/9                               <char-0x02151>               " ⅑          : VULGAR FRACTION ONE NINTH
\\1/<Tab>                           <char-0x0215F>               " ⅟          : FRACTION NUMERATOR ONE
\\2/3                               <char-0x02154>               " ⅔          : VULGAR FRACTION TWO THIRDS / FRACTION TWO THIRDS
\\2/5                               <char-0x02156>               " ⅖          : VULGAR FRACTION TWO FIFTHS / FRACTION TWO FIFTHS
\\3/4                               <char-0x000BE>               " ¾          : VULGAR FRACTION THREE QUARTERS / FRACTION THREE QUARTERS
\\3/5                               <char-0x02157>               " ⅗          : VULGAR FRACTION THREE FIFTHS / FRACTION THREE FIFTHS
\\3/8                               <char-0x0215C>               " ⅜          : VULGAR FRACTION THREE EIGHTHS / FRACTION THREE EIGHTHS
\\4/5                               <char-0x02158>               " ⅘          : VULGAR FRACTION FOUR FIFTHS / FRACTION FOUR FIFTHS
\\5/6                               <char-0x0215A>               " ⅚          : VULGAR FRACTION FIVE SIXTHS / FRACTION FIVE SIXTHS
\\5/8                               <char-0x0215D>               " ⅝          : VULGAR FRACTION FIVE EIGHTHS / FRACTION FIVE EIGHTHS
\\7/8                               <char-0x0215E>               " ⅞          : VULGAR FRACTION SEVEN EIGHTHS / FRACTION SEVEN EIGHTHS
\\:+1:                              <char-0x1F44D>               " 👍          : THUMBS UP SIGN
\\:-1:                              <char-0x1F44E>               " 👎          : THUMBS DOWN SIGN
\\:100:                             <char-0x1F4AF>               " 💯          : HUNDRED POINTS SYMBOL
\\:1234:                            <char-0x1F522>               " 🔢          : INPUT SYMBOL FOR NUMBERS
\\:8ball:                           <char-0x1F3B1>               " 🎱          : BILLIARDS
\\:a:                               <char-0x1F170>               " 🅰          : NEGATIVE SQUARED LATIN CAPITAL LETTER A
\\:ab:                              <char-0x1F18E>               " 🆎          : NEGATIVE SQUARED AB
\\:abc:                             <char-0x1F524>               " 🔤          : INPUT SYMBOL FOR LATIN LETTERS
\\:abcd:                            <char-0x1F521>               " 🔡          : INPUT SYMBOL FOR LATIN SMALL LETTERS
\\:accept:                          <char-0x1F251>               " 🉑          : CIRCLED IDEOGRAPH ACCEPT
\\:aerial_tramway:                  <char-0x1F6A1>               " 🚡          : AERIAL TRAMWAY
\\:airplane:                        <char-0x02708>               " ✈          : AIRPLANE
\\:alarm_clock:                     <char-0x023F0>               " ⏰          : ALARM CLOCK
\\:alien:                           <char-0x1F47D>               " 👽          : EXTRATERRESTRIAL ALIEN
\\:ambulance:                       <char-0x1F691>               " 🚑          : AMBULANCE
\\:anchor:                          <char-0x02693>               " ⚓          : ANCHOR
\\:angel:                           <char-0x1F47C>               " 👼          : BABY ANGEL
\\:anger:                           <char-0x1F4A2>               " 💢          : ANGER SYMBOL
\\:angry:                           <char-0x1F620>               " 😠          : ANGRY FACE
\\:anguished:                       <char-0x1F627>               " 😧          : ANGUISHED FACE
\\:ant:                             <char-0x1F41C>               " 🐜          : ANT
\\:apple:                           <char-0x1F34E>               " 🍎          : RED APPLE
\\:aquarius:                        <char-0x02652>               " ♒          : AQUARIUS
\\:aries:                           <char-0x02648>               " ♈          : ARIES
\\:arrow_backward:                  <char-0x025C0>               " ◀          : BLACK LEFT-POINTING TRIANGLE / BLACK LEFT POINTING TRIANGLE
\\:arrow_double_down:               <char-0x023EC>               " ⏬          : BLACK DOWN-POINTING DOUBLE TRIANGLE
\\:arrow_double_up:                 <char-0x023EB>               " ⏫          : BLACK UP-POINTING DOUBLE TRIANGLE
\\:arrow_down:                      <char-0x02B07>               " ⬇          : DOWNWARDS BLACK ARROW
\\:arrow_down_small:                <char-0x1F53D>               " 🔽          : DOWN-POINTING SMALL RED TRIANGLE
\\:arrow_forward:                   <char-0x025B6>               " ▶          : BLACK RIGHT-POINTING TRIANGLE / BLACK RIGHT POINTING TRIANGLE
\\:arrow_heading_down:              <char-0x02935>               " ⤵          : ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS
\\:arrow_heading_up:                <char-0x02934>               " ⤴          : ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS
\\:arrow_left:                      <char-0x02B05>               " ⬅          : LEFTWARDS BLACK ARROW
\\:arrow_lower_left:                <char-0x02199>               " ↙          : SOUTH WEST ARROW / LOWER LEFT ARROW
\\:arrow_lower_right:               <char-0x02198>               " ↘          : SOUTH EAST ARROW / LOWER RIGHT ARROW
\\:arrow_right:                     <char-0x027A1>               " ➡          : BLACK RIGHTWARDS ARROW / BLACK RIGHT ARROW
\\:arrow_right_hook:                <char-0x021AA>               " ↪          : RIGHTWARDS ARROW WITH HOOK / RIGHT ARROW WITH HOOK
\\:arrow_up:                        <char-0x02B06>               " ⬆          : UPWARDS BLACK ARROW
\\:arrow_up_down:                   <char-0x02195>               " ↕          : UP DOWN ARROW
\\:arrow_up_small:                  <char-0x1F53C>               " 🔼          : UP-POINTING SMALL RED TRIANGLE
\\:arrow_upper_left:                <char-0x02196>               " ↖          : NORTH WEST ARROW / UPPER LEFT ARROW
\\:arrow_upper_right:               <char-0x02197>               " ↗          : NORTH EAST ARROW / UPPER RIGHT ARROW
\\:arrows_clockwise:                <char-0x1F503>               " 🔃          : CLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS
\\:arrows_counterclockwise:         <char-0x1F504>               " 🔄          : ANTICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS
\\:art:                             <char-0x1F3A8>               " 🎨          : ARTIST PALETTE
\\:articulated_lorry:               <char-0x1F69B>               " 🚛          : ARTICULATED LORRY
\\:astonished:                      <char-0x1F632>               " 😲          : ASTONISHED FACE
\\:athletic_shoe:                   <char-0x1F45F>               " 👟          : ATHLETIC SHOE
\\:atm:                             <char-0x1F3E7>               " 🏧          : AUTOMATED TELLER MACHINE
\\:b:                               <char-0x1F171>               " 🅱          : NEGATIVE SQUARED LATIN CAPITAL LETTER B
\\:baby:                            <char-0x1F476>               " 👶          : BABY
\\:baby_bottle:                     <char-0x1F37C>               " 🍼          : BABY BOTTLE
\\:baby_chick:                      <char-0x1F424>               " 🐤          : BABY CHICK
\\:baby_symbol:                     <char-0x1F6BC>               " 🚼          : BABY SYMBOL
\\:back:                            <char-0x1F519>               " 🔙          : BACK WITH LEFTWARDS ARROW ABOVE
\\:baggage_claim:                   <char-0x1F6C4>               " 🛄          : BAGGAGE CLAIM
\\:balloon:                         <char-0x1F388>               " 🎈          : BALLOON
\\:ballot_box_with_check:           <char-0x02611>               " ☑          : BALLOT BOX WITH CHECK
\\:bamboo:                          <char-0x1F38D>               " 🎍          : PINE DECORATION
\\:banana:                          <char-0x1F34C>               " 🍌          : BANANA
\\:bangbang:                        <char-0x0203C>               " ‼          : DOUBLE EXCLAMATION MARK
\\:bank:                            <char-0x1F3E6>               " 🏦          : BANK
\\:bar_chart:                       <char-0x1F4CA>               " 📊          : BAR CHART
\\:barber:                          <char-0x1F488>               " 💈          : BARBER POLE
\\:baseball:                        <char-0x026BE>               " ⚾          : BASEBALL
\\:basketball:                      <char-0x1F3C0>               " 🏀          : BASKETBALL AND HOOP
\\:bath:                            <char-0x1F6C0>               " 🛀          : BATH
\\:bathtub:                         <char-0x1F6C1>               " 🛁          : BATHTUB
\\:battery:                         <char-0x1F50B>               " 🔋          : BATTERY
\\:bear:                            <char-0x1F43B>               " 🐻          : BEAR FACE
\\:bee:                             <char-0x1F41D>               " 🐝          : HONEYBEE
\\:beer:                            <char-0x1F37A>               " 🍺          : BEER MUG
\\:beers:                           <char-0x1F37B>               " 🍻          : CLINKING BEER MUGS
\\:beetle:                          <char-0x1F41E>               " 🐞          : LADY BEETLE
\\:beginner:                        <char-0x1F530>               " 🔰          : JAPANESE SYMBOL FOR BEGINNER
\\:bell:                            <char-0x1F514>               " 🔔          : BELL
\\:bento:                           <char-0x1F371>               " 🍱          : BENTO BOX
\\:bicyclist:                       <char-0x1F6B4>               " 🚴          : BICYCLIST
\\:bike:                            <char-0x1F6B2>               " 🚲          : BICYCLE
\\:bikini:                          <char-0x1F459>               " 👙          : BIKINI
\\:bird:                            <char-0x1F426>               " 🐦          : BIRD
\\:birthday:                        <char-0x1F382>               " 🎂          : BIRTHDAY CAKE
\\:black_circle:                    <char-0x026AB>               " ⚫          : MEDIUM BLACK CIRCLE
\\:black_joker:                     <char-0x1F0CF>               " 🃏          : PLAYING CARD BLACK JOKER
\\:black_large_square:              <char-0x02B1B>               " ⬛          : BLACK LARGE SQUARE
\\:black_medium_small_square:       <char-0x025FE>               " ◾          : BLACK MEDIUM SMALL SQUARE
\\:black_medium_square:             <char-0x025FC>               " ◼          : BLACK MEDIUM SQUARE
\\:black_nib:                       <char-0x02712>               " ✒          : BLACK NIB
\\:black_small_square:              <char-0x025AA>               " ▪          : BLACK SMALL SQUARE
\\:black_square_button:             <char-0x1F532>               " 🔲          : BLACK SQUARE BUTTON
\\:blossom:                         <char-0x1F33C>               " 🌼          : BLOSSOM
\\:blowfish:                        <char-0x1F421>               " 🐡          : BLOWFISH
\\:blue_book:                       <char-0x1F4D8>               " 📘          : BLUE BOOK
\\:blue_car:                        <char-0x1F699>               " 🚙          : RECREATIONAL VEHICLE
\\:blue_heart:                      <char-0x1F499>               " 💙          : BLUE HEART
\\:blush:                           <char-0x1F60A>               " 😊          : SMILING FACE WITH SMILING EYES
\\:boar:                            <char-0x1F417>               " 🐗          : BOAR
\\:boat:                            <char-0x026F5>               " ⛵          : SAILBOAT
\\:bomb:                            <char-0x1F4A3>               " 💣          : BOMB
\\:book:                            <char-0x1F4D6>               " 📖          : OPEN BOOK
\\:bookmark:                        <char-0x1F516>               " 🔖          : BOOKMARK
\\:bookmark_tabs:                   <char-0x1F4D1>               " 📑          : BOOKMARK TABS
\\:books:                           <char-0x1F4DA>               " 📚          : BOOKS
\\:boom:                            <char-0x1F4A5>               " 💥          : COLLISION SYMBOL
\\:boot:                            <char-0x1F462>               " 👢          : WOMANS BOOTS
\\:bouquet:                         <char-0x1F490>               " 💐          : BOUQUET
\\:bow:                             <char-0x1F647>               " 🙇          : PERSON BOWING DEEPLY
\\:bowling:                         <char-0x1F3B3>               " 🎳          : BOWLING
\\:boy:                             <char-0x1F466>               " 👦          : BOY
\\:bread:                           <char-0x1F35E>               " 🍞          : BREAD
\\:bride_with_veil:                 <char-0x1F470>               " 👰          : BRIDE WITH VEIL
\\:bridge_at_night:                 <char-0x1F309>               " 🌉          : BRIDGE AT NIGHT
\\:briefcase:                       <char-0x1F4BC>               " 💼          : BRIEFCASE
\\:broken_heart:                    <char-0x1F494>               " 💔          : BROKEN HEART
\\:bug:                             <char-0x1F41B>               " 🐛          : BUG
\\:bulb:                            <char-0x1F4A1>               " 💡          : ELECTRIC LIGHT BULB
\\:bullettrain_front:               <char-0x1F685>               " 🚅          : HIGH-SPEED TRAIN WITH BULLET NOSE
\\:bullettrain_side:                <char-0x1F684>               " 🚄          : HIGH-SPEED TRAIN
\\:bus:                             <char-0x1F68C>               " 🚌          : BUS
\\:busstop:                         <char-0x1F68F>               " 🚏          : BUS STOP
\\:bust_in_silhouette:              <char-0x1F464>               " 👤          : BUST IN SILHOUETTE
\\:busts_in_silhouette:             <char-0x1F465>               " 👥          : BUSTS IN SILHOUETTE
\\:cactus:                          <char-0x1F335>               " 🌵          : CACTUS
\\:cake:                            <char-0x1F370>               " 🍰          : SHORTCAKE
\\:calendar:                        <char-0x1F4C6>               " 📆          : TEAR-OFF CALENDAR
\\:calling:                         <char-0x1F4F2>               " 📲          : MOBILE PHONE WITH RIGHTWARDS ARROW AT LEFT
\\:camel:                           <char-0x1F42B>               " 🐫          : BACTRIAN CAMEL
\\:camera:                          <char-0x1F4F7>               " 📷          : CAMERA
\\:cancer:                          <char-0x0264B>               " ♋          : CANCER
\\:candy:                           <char-0x1F36C>               " 🍬          : CANDY
\\:capital_abcd:                    <char-0x1F520>               " 🔠          : INPUT SYMBOL FOR LATIN CAPITAL LETTERS
\\:capricorn:                       <char-0x02651>               " ♑          : CAPRICORN
\\:car:                             <char-0x1F697>               " 🚗          : AUTOMOBILE
\\:card_index:                      <char-0x1F4C7>               " 📇          : CARD INDEX
\\:carousel_horse:                  <char-0x1F3A0>               " 🎠          : CAROUSEL HORSE
\\:cat2:                            <char-0x1F408>               " 🐈          : CAT
\\:cat:                             <char-0x1F431>               " 🐱          : CAT FACE
\\:cd:                              <char-0x1F4BF>               " 💿          : OPTICAL DISC
\\:chart:                           <char-0x1F4B9>               " 💹          : CHART WITH UPWARDS TREND AND YEN SIGN
\\:chart_with_downwards_trend:      <char-0x1F4C9>               " 📉          : CHART WITH DOWNWARDS TREND
\\:chart_with_upwards_trend:        <char-0x1F4C8>               " 📈          : CHART WITH UPWARDS TREND
\\:checkered_flag:                  <char-0x1F3C1>               " 🏁          : CHEQUERED FLAG
\\:cherries:                        <char-0x1F352>               " 🍒          : CHERRIES
\\:cherry_blossom:                  <char-0x1F338>               " 🌸          : CHERRY BLOSSOM
\\:chestnut:                        <char-0x1F330>               " 🌰          : CHESTNUT
\\:chicken:                         <char-0x1F414>               " 🐔          : CHICKEN
\\:children_crossing:               <char-0x1F6B8>               " 🚸          : CHILDREN CROSSING
\\:chocolate_bar:                   <char-0x1F36B>               " 🍫          : CHOCOLATE BAR
\\:christmas_tree:                  <char-0x1F384>               " 🎄          : CHRISTMAS TREE
\\:church:                          <char-0x026EA>               " ⛪          : CHURCH
\\:cinema:                          <char-0x1F3A6>               " 🎦          : CINEMA
\\:circus_tent:                     <char-0x1F3AA>               " 🎪          : CIRCUS TENT
\\:city_sunrise:                    <char-0x1F307>               " 🌇          : SUNSET OVER BUILDINGS
\\:city_sunset:                     <char-0x1F306>               " 🌆          : CITYSCAPE AT DUSK
\\:cl:                              <char-0x1F191>               " 🆑          : SQUARED CL
\\:clap:                            <char-0x1F44F>               " 👏          : CLAPPING HANDS SIGN
\\:clapper:                         <char-0x1F3AC>               " 🎬          : CLAPPER BOARD
\\:clipboard:                       <char-0x1F4CB>               " 📋          : CLIPBOARD
\\:clock1030:                       <char-0x1F565>               " 🕥          : CLOCK FACE TEN-THIRTY
\\:clock10:                         <char-0x1F559>               " 🕙          : CLOCK FACE TEN OCLOCK
\\:clock1130:                       <char-0x1F566>               " 🕦          : CLOCK FACE ELEVEN-THIRTY
\\:clock11:                         <char-0x1F55A>               " 🕚          : CLOCK FACE ELEVEN OCLOCK
\\:clock1230:                       <char-0x1F567>               " 🕧          : CLOCK FACE TWELVE-THIRTY
\\:clock12:                         <char-0x1F55B>               " 🕛          : CLOCK FACE TWELVE OCLOCK
\\:clock130:                        <char-0x1F55C>               " 🕜          : CLOCK FACE ONE-THIRTY
\\:clock1:                          <char-0x1F550>               " 🕐          : CLOCK FACE ONE OCLOCK
\\:clock230:                        <char-0x1F55D>               " 🕝          : CLOCK FACE TWO-THIRTY
\\:clock2:                          <char-0x1F551>               " 🕑          : CLOCK FACE TWO OCLOCK
\\:clock330:                        <char-0x1F55E>               " 🕞          : CLOCK FACE THREE-THIRTY
\\:clock3:                          <char-0x1F552>               " 🕒          : CLOCK FACE THREE OCLOCK
\\:clock430:                        <char-0x1F55F>               " 🕟          : CLOCK FACE FOUR-THIRTY
\\:clock4:                          <char-0x1F553>               " 🕓          : CLOCK FACE FOUR OCLOCK
\\:clock530:                        <char-0x1F560>               " 🕠          : CLOCK FACE FIVE-THIRTY
\\:clock5:                          <char-0x1F554>               " 🕔          : CLOCK FACE FIVE OCLOCK
\\:clock630:                        <char-0x1F561>               " 🕡          : CLOCK FACE SIX-THIRTY
\\:clock6:                          <char-0x1F555>               " 🕕          : CLOCK FACE SIX OCLOCK
\\:clock730:                        <char-0x1F562>               " 🕢          : CLOCK FACE SEVEN-THIRTY
\\:clock7:                          <char-0x1F556>               " 🕖          : CLOCK FACE SEVEN OCLOCK
\\:clock830:                        <char-0x1F563>               " 🕣          : CLOCK FACE EIGHT-THIRTY
\\:clock8:                          <char-0x1F557>               " 🕗          : CLOCK FACE EIGHT OCLOCK
\\:clock930:                        <char-0x1F564>               " 🕤          : CLOCK FACE NINE-THIRTY
\\:clock9:                          <char-0x1F558>               " 🕘          : CLOCK FACE NINE OCLOCK
\\:closed_book:                     <char-0x1F4D5>               " 📕          : CLOSED BOOK
\\:closed_lock_with_key:            <char-0x1F510>               " 🔐          : CLOSED LOCK WITH KEY
\\:closed_umbrella:                 <char-0x1F302>               " 🌂          : CLOSED UMBRELLA
\\:cloud:                           <char-0x02601>               " ☁          : CLOUD
\\:clubs:                           <char-0x02663>               " ♣          : BLACK CLUB SUIT
\\:cocktail:                        <char-0x1F378>               " 🍸          : COCKTAIL GLASS
\\:coffee:                          <char-0x02615>               " ☕          : HOT BEVERAGE
\\:cold_sweat:                      <char-0x1F630>               " 😰          : FACE WITH OPEN MOUTH AND COLD SWEAT
\\:computer:                        <char-0x1F4BB>               " 💻          : PERSONAL COMPUTER
\\:confetti_ball:                   <char-0x1F38A>               " 🎊          : CONFETTI BALL
\\:confounded:                      <char-0x1F616>               " 😖          : CONFOUNDED FACE
\\:confused:                        <char-0x1F615>               " 😕          : CONFUSED FACE
\\:congratulations:                 <char-0x03297>               " ㊗          : CIRCLED IDEOGRAPH CONGRATULATION
\\:construction:                    <char-0x1F6A7>               " 🚧          : CONSTRUCTION SIGN
\\:construction_worker:             <char-0x1F477>               " 👷          : CONSTRUCTION WORKER
\\:convenience_store:               <char-0x1F3EA>               " 🏪          : CONVENIENCE STORE
\\:cookie:                          <char-0x1F36A>               " 🍪          : COOKIE
\\:cool:                            <char-0x1F192>               " 🆒          : SQUARED COOL
\\:cop:                             <char-0x1F46E>               " 👮          : POLICE OFFICER
\\:copyright:                       <char-0x000A9>               " ©          : COPYRIGHT SIGN
\\:corn:                            <char-0x1F33D>               " 🌽          : EAR OF MAIZE
\\:couple:                          <char-0x1F46B>               " 👫          : MAN AND WOMAN HOLDING HANDS
\\:couple_with_heart:               <char-0x1F491>               " 💑          : COUPLE WITH HEART
\\:couplekiss:                      <char-0x1F48F>               " 💏          : KISS
\\:cow2:                            <char-0x1F404>               " 🐄          : COW
\\:cow:                             <char-0x1F42E>               " 🐮          : COW FACE
\\:credit_card:                     <char-0x1F4B3>               " 💳          : CREDIT CARD
\\:crescent_moon:                   <char-0x1F319>               " 🌙          : CRESCENT MOON
\\:crocodile:                       <char-0x1F40A>               " 🐊          : CROCODILE
\\:crossed_flags:                   <char-0x1F38C>               " 🎌          : CROSSED FLAGS
\\:crown:                           <char-0x1F451>               " 👑          : CROWN
\\:cry:                             <char-0x1F622>               " 😢          : CRYING FACE
\\:crying_cat_face:                 <char-0x1F63F>               " 😿          : CRYING CAT FACE
\\:crystal_ball:                    <char-0x1F52E>               " 🔮          : CRYSTAL BALL
\\:cupid:                           <char-0x1F498>               " 💘          : HEART WITH ARROW
\\:curly_loop:                      <char-0x027B0>               " ➰          : CURLY LOOP
\\:currency_exchange:               <char-0x1F4B1>               " 💱          : CURRENCY EXCHANGE
\\:curry:                           <char-0x1F35B>               " 🍛          : CURRY AND RICE
\\:custard:                         <char-0x1F36E>               " 🍮          : CUSTARD
\\:customs:                         <char-0x1F6C3>               " 🛃          : CUSTOMS
\\:cyclone:                         <char-0x1F300>               " 🌀          : CYCLONE
\\:dancer:                          <char-0x1F483>               " 💃          : DANCER
\\:dancers:                         <char-0x1F46F>               " 👯          : WOMAN WITH BUNNY EARS
\\:dango:                           <char-0x1F361>               " 🍡          : DANGO
\\:dart:                            <char-0x1F3AF>               " 🎯          : DIRECT HIT
\\:dash:                            <char-0x1F4A8>               " 💨          : DASH SYMBOL
\\:date:                            <char-0x1F4C5>               " 📅          : CALENDAR
\\:deciduous_tree:                  <char-0x1F333>               " 🌳          : DECIDUOUS TREE
\\:department_store:                <char-0x1F3EC>               " 🏬          : DEPARTMENT STORE
\\:diamond_shape_with_a_dot_inside: <char-0x1F4A0>               " 💠          : DIAMOND SHAPE WITH A DOT INSIDE
\\:diamonds:                        <char-0x02666>               " ♦          : BLACK DIAMOND SUIT
\\:disappointed:                    <char-0x1F61E>               " 😞          : DISAPPOINTED FACE
\\:disappointed_relieved:           <char-0x1F625>               " 😥          : DISAPPOINTED BUT RELIEVED FACE
\\:dizzy:                           <char-0x1F4AB>               " 💫          : DIZZY SYMBOL
\\:dizzy_face:                      <char-0x1F635>               " 😵          : DIZZY FACE
\\:do_not_litter:                   <char-0x1F6AF>               " 🚯          : DO NOT LITTER SYMBOL
\\:dog2:                            <char-0x1F415>               " 🐕          : DOG
\\:dog:                             <char-0x1F436>               " 🐶          : DOG FACE
\\:dollar:                          <char-0x1F4B5>               " 💵          : BANKNOTE WITH DOLLAR SIGN
\\:dolls:                           <char-0x1F38E>               " 🎎          : JAPANESE DOLLS
\\:dolphin:                         <char-0x1F42C>               " 🐬          : DOLPHIN
\\:door:                            <char-0x1F6AA>               " 🚪          : DOOR
\\:doughnut:                        <char-0x1F369>               " 🍩          : DOUGHNUT
\\:dragon:                          <char-0x1F409>               " 🐉          : DRAGON
\\:dragon_face:                     <char-0x1F432>               " 🐲          : DRAGON FACE
\\:dress:                           <char-0x1F457>               " 👗          : DRESS
\\:dromedary_camel:                 <char-0x1F42A>               " 🐪          : DROMEDARY CAMEL
\\:droplet:                         <char-0x1F4A7>               " 💧          : DROPLET
\\:dvd:                             <char-0x1F4C0>               " 📀          : DVD
\\:e-mail:                          <char-0x1F4E7>               " 📧          : E-MAIL SYMBOL
\\:ear:                             <char-0x1F442>               " 👂          : EAR
\\:ear_of_rice:                     <char-0x1F33E>               " 🌾          : EAR OF RICE
\\:earth_africa:                    <char-0x1F30D>               " 🌍          : EARTH GLOBE EUROPE-AFRICA
\\:earth_americas:                  <char-0x1F30E>               " 🌎          : EARTH GLOBE AMERICAS
\\:earth_asia:                      <char-0x1F30F>               " 🌏          : EARTH GLOBE ASIA-AUSTRALIA
\\:egg:                             <char-0x1F373>               " 🍳          : COOKING
\\:eggplant:                        <char-0x1F346>               " 🍆          : AUBERGINE
\\:eight_pointed_black_star:        <char-0x02734>               " ✴          : EIGHT POINTED BLACK STAR
\\:eight_spoked_asterisk:           <char-0x02733>               " ✳          : EIGHT SPOKED ASTERISK
\\:electric_plug:                   <char-0x1F50C>               " 🔌          : ELECTRIC PLUG
\\:elephant:                        <char-0x1F418>               " 🐘          : ELEPHANT
\\:email:                           <char-0x02709>               " ✉          : ENVELOPE
\\:end:                             <char-0x1F51A>               " 🔚          : END WITH LEFTWARDS ARROW ABOVE
\\:envelope_with_arrow:             <char-0x1F4E9>               " 📩          : ENVELOPE WITH DOWNWARDS ARROW ABOVE
\\:euro:                            <char-0x1F4B6>               " 💶          : BANKNOTE WITH EURO SIGN
\\:european_castle:                 <char-0x1F3F0>               " 🏰          : EUROPEAN CASTLE
\\:european_post_office:            <char-0x1F3E4>               " 🏤          : EUROPEAN POST OFFICE
\\:evergreen_tree:                  <char-0x1F332>               " 🌲          : EVERGREEN TREE
\\:exclamation:                     <char-0x02757>               " ❗          : HEAVY EXCLAMATION MARK SYMBOL
\\:expressionless:                  <char-0x1F611>               " 😑          : EXPRESSIONLESS FACE
\\:eyeglasses:                      <char-0x1F453>               " 👓          : EYEGLASSES
\\:eyes:                            <char-0x1F440>               " 👀          : EYES
\\:facepunch:                       <char-0x1F44A>               " 👊          : FISTED HAND SIGN
\\:factory:                         <char-0x1F3ED>               " 🏭          : FACTORY
\\:fallen_leaf:                     <char-0x1F342>               " 🍂          : FALLEN LEAF
\\:family:                          <char-0x1F46A>               " 👪          : FAMILY
\\:fast_forward:                    <char-0x023E9>               " ⏩          : BLACK RIGHT-POINTING DOUBLE TRIANGLE
\\:fax:                             <char-0x1F4E0>               " 📠          : FAX MACHINE
\\:fearful:                         <char-0x1F628>               " 😨          : FEARFUL FACE
\\:feet:                            <char-0x1F43E>               " 🐾          : PAW PRINTS
\\:ferris_wheel:                    <char-0x1F3A1>               " 🎡          : FERRIS WHEEL
\\:file_folder:                     <char-0x1F4C1>               " 📁          : FILE FOLDER
\\:fire:                            <char-0x1F525>               " 🔥          : FIRE
\\:fire_engine:                     <char-0x1F692>               " 🚒          : FIRE ENGINE
\\:fireworks:                       <char-0x1F386>               " 🎆          : FIREWORKS
\\:first_quarter_moon:              <char-0x1F313>               " 🌓          : FIRST QUARTER MOON SYMBOL
\\:first_quarter_moon_with_face:    <char-0x1F31B>               " 🌛          : FIRST QUARTER MOON WITH FACE
\\:fish:                            <char-0x1F41F>               " 🐟          : FISH
\\:fish_cake:                       <char-0x1F365>               " 🍥          : FISH CAKE WITH SWIRL DESIGN
\\:fishing_pole_and_fish:           <char-0x1F3A3>               " 🎣          : FISHING POLE AND FISH
\\:fist:                            <char-0x0270A>               " ✊          : RAISED FIST
\\:flags:                           <char-0x1F38F>               " 🎏          : CARP STREAMER
\\:flashlight:                      <char-0x1F526>               " 🔦          : ELECTRIC TORCH
\\:floppy_disk:                     <char-0x1F4BE>               " 💾          : FLOPPY DISK
\\:flower_playing_cards:            <char-0x1F3B4>               " 🎴          : FLOWER PLAYING CARDS
\\:flushed:                         <char-0x1F633>               " 😳          : FLUSHED FACE
\\:foggy:                           <char-0x1F301>               " 🌁          : FOGGY
\\:football:                        <char-0x1F3C8>               " 🏈          : AMERICAN FOOTBALL
\\:footprints:                      <char-0x1F463>               " 👣          : FOOTPRINTS
\\:fork_and_knife:                  <char-0x1F374>               " 🍴          : FORK AND KNIFE
\\:fountain:                        <char-0x026F2>               " ⛲          : FOUNTAIN
\\:four_leaf_clover:                <char-0x1F340>               " 🍀          : FOUR LEAF CLOVER
\\:free:                            <char-0x1F193>               " 🆓          : SQUARED FREE
\\:fried_shrimp:                    <char-0x1F364>               " 🍤          : FRIED SHRIMP
\\:fries:                           <char-0x1F35F>               " 🍟          : FRENCH FRIES
\\:frog:                            <char-0x1F438>               " 🐸          : FROG FACE
\\:frowning:                        <char-0x1F626>               " 😦          : FROWNING FACE WITH OPEN MOUTH
\\:fuelpump:                        <char-0x026FD>               " ⛽          : FUEL PUMP
\\:full_moon:                       <char-0x1F315>               " 🌕          : FULL MOON SYMBOL
\\:full_moon_with_face:             <char-0x1F31D>               " 🌝          : FULL MOON WITH FACE
\\:game_die:                        <char-0x1F3B2>               " 🎲          : GAME DIE
\\:gem:                             <char-0x1F48E>               " 💎          : GEM STONE
\\:gemini:                          <char-0x0264A>               " ♊          : GEMINI
\\:ghost:                           <char-0x1F47B>               " 👻          : GHOST
\\:gift:                            <char-0x1F381>               " 🎁          : WRAPPED PRESENT
\\:gift_heart:                      <char-0x1F49D>               " 💝          : HEART WITH RIBBON
\\:girl:                            <char-0x1F467>               " 👧          : GIRL
\\:globe_with_meridians:            <char-0x1F310>               " 🌐          : GLOBE WITH MERIDIANS
\\:goat:                            <char-0x1F410>               " 🐐          : GOAT
\\:golf:                            <char-0x026F3>               " ⛳          : FLAG IN HOLE
\\:grapes:                          <char-0x1F347>               " 🍇          : GRAPES
\\:green_apple:                     <char-0x1F34F>               " 🍏          : GREEN APPLE
\\:green_book:                      <char-0x1F4D7>               " 📗          : GREEN BOOK
\\:green_heart:                     <char-0x1F49A>               " 💚          : GREEN HEART
\\:grey_exclamation:                <char-0x02755>               " ❕          : WHITE EXCLAMATION MARK ORNAMENT
\\:grey_question:                   <char-0x02754>               " ❔          : WHITE QUESTION MARK ORNAMENT
\\:grimacing:                       <char-0x1F62C>               " 😬          : GRIMACING FACE
\\:grin:                            <char-0x1F601>               " 😁          : GRINNING FACE WITH SMILING EYES
\\:grinning:                        <char-0x1F600>               " 😀          : GRINNING FACE
\\:guardsman:                       <char-0x1F482>               " 💂          : GUARDSMAN
\\:guitar:                          <char-0x1F3B8>               " 🎸          : GUITAR
\\:gun:                             <char-0x1F52B>               " 🔫          : PISTOL
\\:haircut:                         <char-0x1F487>               " 💇          : HAIRCUT
\\:hamburger:                       <char-0x1F354>               " 🍔          : HAMBURGER
\\:hammer:                          <char-0x1F528>               " 🔨          : HAMMER
\\:hamster:                         <char-0x1F439>               " 🐹          : HAMSTER FACE
\\:hand:                            <char-0x0270B>               " ✋          : RAISED HAND
\\:handbag:                         <char-0x1F45C>               " 👜          : HANDBAG
\\:hankey:                          <char-0x1F4A9>               " 💩          : PILE OF POO
\\:hatched_chick:                   <char-0x1F425>               " 🐥          : FRONT-FACING BABY CHICK
\\:hatching_chick:                  <char-0x1F423>               " 🐣          : HATCHING CHICK
\\:headphones:                      <char-0x1F3A7>               " 🎧          : HEADPHONE
\\:hear_no_evil:                    <char-0x1F649>               " 🙉          : HEAR-NO-EVIL MONKEY
\\:heart:                           <char-0x02764>               " ❤          : HEAVY BLACK HEART
\\:heart_decoration:                <char-0x1F49F>               " 💟          : HEART DECORATION
\\:heart_eyes:                      <char-0x1F60D>               " 😍          : SMILING FACE WITH HEART-SHAPED EYES
\\:heart_eyes_cat:                  <char-0x1F63B>               " 😻          : SMILING CAT FACE WITH HEART-SHAPED EYES
\\:heartbeat:                       <char-0x1F493>               " 💓          : BEATING HEART
\\:heartpulse:                      <char-0x1F497>               " 💗          : GROWING HEART
\\:hearts:                          <char-0x02665>               " ♥          : BLACK HEART SUIT
\\:heavy_check_mark:                <char-0x02714>               " ✔          : HEAVY CHECK MARK
\\:heavy_division_sign:             <char-0x02797>               " ➗          : HEAVY DIVISION SIGN
\\:heavy_dollar_sign:               <char-0x1F4B2>               " 💲          : HEAVY DOLLAR SIGN
\\:heavy_minus_sign:                <char-0x02796>               " ➖          : HEAVY MINUS SIGN
\\:heavy_multiplication_x:          <char-0x02716>               " ✖          : HEAVY MULTIPLICATION X
\\:heavy_plus_sign:                 <char-0x02795>               " ➕          : HEAVY PLUS SIGN
\\:helicopter:                      <char-0x1F681>               " 🚁          : HELICOPTER
\\:herb:                            <char-0x1F33F>               " 🌿          : HERB
\\:hibiscus:                        <char-0x1F33A>               " 🌺          : HIBISCUS
\\:high_brightness:                 <char-0x1F506>               " 🔆          : HIGH BRIGHTNESS SYMBOL
\\:high_heel:                       <char-0x1F460>               " 👠          : HIGH-HEELED SHOE
\\:hocho:                           <char-0x1F52A>               " 🔪          : HOCHO
\\:honey_pot:                       <char-0x1F36F>               " 🍯          : HONEY POT
\\:horse:                           <char-0x1F434>               " 🐴          : HORSE FACE
\\:horse_racing:                    <char-0x1F3C7>               " 🏇          : HORSE RACING
\\:hospital:                        <char-0x1F3E5>               " 🏥          : HOSPITAL
\\:hotel:                           <char-0x1F3E8>               " 🏨          : HOTEL
\\:hotsprings:                      <char-0x02668>               " ♨          : HOT SPRINGS
\\:hourglass:                       <char-0x0231B>               " ⌛          : HOURGLASS
\\:hourglass_flowing_sand:          <char-0x023F3>               " ⏳          : HOURGLASS WITH FLOWING SAND
\\:house:                           <char-0x1F3E0>               " 🏠          : HOUSE BUILDING
\\:house_with_garden:               <char-0x1F3E1>               " 🏡          : HOUSE WITH GARDEN
\\:hushed:                          <char-0x1F62F>               " 😯          : HUSHED FACE
\\:ice_cream:                       <char-0x1F368>               " 🍨          : ICE CREAM
\\:icecream:                        <char-0x1F366>               " 🍦          : SOFT ICE CREAM
\\:id:                              <char-0x1F194>               " 🆔          : SQUARED ID
\\:ideograph_advantage:             <char-0x1F250>               " 🉐          : CIRCLED IDEOGRAPH ADVANTAGE
\\:imp:                             <char-0x1F47F>               " 👿          : IMP
\\:inbox_tray:                      <char-0x1F4E5>               " 📥          : INBOX TRAY
\\:incoming_envelope:               <char-0x1F4E8>               " 📨          : INCOMING ENVELOPE
\\:information_desk_person:         <char-0x1F481>               " 💁          : INFORMATION DESK PERSON
\\:information_source:              <char-0x02139>               " ℹ          : INFORMATION SOURCE
\\:innocent:                        <char-0x1F607>               " 😇          : SMILING FACE WITH HALO
\\:interrobang:                     <char-0x02049>               " ⁉          : EXCLAMATION QUESTION MARK
\\:iphone:                          <char-0x1F4F1>               " 📱          : MOBILE PHONE
\\:izakaya_lantern:                 <char-0x1F3EE>               " 🏮          : IZAKAYA LANTERN
\\:jack_o_lantern:                  <char-0x1F383>               " 🎃          : JACK-O-LANTERN
\\:japan:                           <char-0x1F5FE>               " 🗾          : SILHOUETTE OF JAPAN
\\:japanese_castle:                 <char-0x1F3EF>               " 🏯          : JAPANESE CASTLE
\\:japanese_goblin:                 <char-0x1F47A>               " 👺          : JAPANESE GOBLIN
\\:japanese_ogre:                   <char-0x1F479>               " 👹          : JAPANESE OGRE
\\:jeans:                           <char-0x1F456>               " 👖          : JEANS
\\:joy:                             <char-0x1F602>               " 😂          : FACE WITH TEARS OF JOY
\\:joy_cat:                         <char-0x1F639>               " 😹          : CAT FACE WITH TEARS OF JOY
\\:key:                             <char-0x1F511>               " 🔑          : KEY
\\:keycap_ten:                      <char-0x1F51F>               " 🔟          : KEYCAP TEN
\\:kimono:                          <char-0x1F458>               " 👘          : KIMONO
\\:kiss:                            <char-0x1F48B>               " 💋          : KISS MARK
\\:kissing:                         <char-0x1F617>               " 😗          : KISSING FACE
\\:kissing_cat:                     <char-0x1F63D>               " 😽          : KISSING CAT FACE WITH CLOSED EYES
\\:kissing_closed_eyes:             <char-0x1F61A>               " 😚          : KISSING FACE WITH CLOSED EYES
\\:kissing_heart:                   <char-0x1F618>               " 😘          : FACE THROWING A KISS
\\:kissing_smiling_eyes:            <char-0x1F619>               " 😙          : KISSING FACE WITH SMILING EYES
\\:koala:                           <char-0x1F428>               " 🐨          : KOALA
\\:koko:                            <char-0x1F201>               " 🈁          : SQUARED KATAKANA KOKO
\\:large_blue_circle:               <char-0x1F535>               " 🔵          : LARGE BLUE CIRCLE
\\:large_blue_diamond:              <char-0x1F537>               " 🔷          : LARGE BLUE DIAMOND
\\:large_orange_diamond:            <char-0x1F536>               " 🔶          : LARGE ORANGE DIAMOND
\\:last_quarter_moon:               <char-0x1F317>               " 🌗          : LAST QUARTER MOON SYMBOL
\\:last_quarter_moon_with_face:     <char-0x1F31C>               " 🌜          : LAST QUARTER MOON WITH FACE
\\:laughing:                        <char-0x1F606>               " 😆          : SMILING FACE WITH OPEN MOUTH AND TIGHTLY-CLOSED EYES
\\:leaves:                          <char-0x1F343>               " 🍃          : LEAF FLUTTERING IN WIND
\\:ledger:                          <char-0x1F4D2>               " 📒          : LEDGER
\\:left_luggage:                    <char-0x1F6C5>               " 🛅          : LEFT LUGGAGE
\\:left_right_arrow:                <char-0x02194>               " ↔          : LEFT RIGHT ARROW
\\:leftwards_arrow_with_hook:       <char-0x021A9>               " ↩          : LEFTWARDS ARROW WITH HOOK / LEFT ARROW WITH HOOK
\\:lemon:                           <char-0x1F34B>               " 🍋          : LEMON
\\:leo:                             <char-0x0264C>               " ♌          : LEO
\\:leopard:                         <char-0x1F406>               " 🐆          : LEOPARD
\\:libra:                           <char-0x0264E>               " ♎          : LIBRA
\\:light_rail:                      <char-0x1F688>               " 🚈          : LIGHT RAIL
\\:link:                            <char-0x1F517>               " 🔗          : LINK SYMBOL
\\:lips:                            <char-0x1F444>               " 👄          : MOUTH
\\:lipstick:                        <char-0x1F484>               " 💄          : LIPSTICK
\\:lock:                            <char-0x1F512>               " 🔒          : LOCK
\\:lock_with_ink_pen:               <char-0x1F50F>               " 🔏          : LOCK WITH INK PEN
\\:lollipop:                        <char-0x1F36D>               " 🍭          : LOLLIPOP
\\:loop:                            <char-0x027BF>               " ➿          : DOUBLE CURLY LOOP
\\:loud_sound:                      <char-0x1F50A>               " 🔊          : SPEAKER WITH THREE SOUND WAVES
\\:loudspeaker:                     <char-0x1F4E2>               " 📢          : PUBLIC ADDRESS LOUDSPEAKER
\\:love_hotel:                      <char-0x1F3E9>               " 🏩          : LOVE HOTEL
\\:love_letter:                     <char-0x1F48C>               " 💌          : LOVE LETTER
\\:low_brightness:                  <char-0x1F505>               " 🔅          : LOW BRIGHTNESS SYMBOL
\\:m:                               <char-0x024C2>               " Ⓜ          : CIRCLED LATIN CAPITAL LETTER M
\\:mag:                             <char-0x1F50D>               " 🔍          : LEFT-POINTING MAGNIFYING GLASS
\\:mag_right:                       <char-0x1F50E>               " 🔎          : RIGHT-POINTING MAGNIFYING GLASS
\\:mahjong:                         <char-0x1F004>               " 🀄          : MAHJONG TILE RED DRAGON
\\:mailbox:                         <char-0x1F4EB>               " 📫          : CLOSED MAILBOX WITH RAISED FLAG
\\:mailbox_closed:                  <char-0x1F4EA>               " 📪          : CLOSED MAILBOX WITH LOWERED FLAG
\\:mailbox_with_mail:               <char-0x1F4EC>               " 📬          : OPEN MAILBOX WITH RAISED FLAG
\\:mailbox_with_no_mail:            <char-0x1F4ED>               " 📭          : OPEN MAILBOX WITH LOWERED FLAG
\\:man:                             <char-0x1F468>               " 👨          : MAN
\\:man_with_gua_pi_mao:             <char-0x1F472>               " 👲          : MAN WITH GUA PI MAO
\\:man_with_turban:                 <char-0x1F473>               " 👳          : MAN WITH TURBAN
\\:mans_shoe:                       <char-0x1F45E>               " 👞          : MANS SHOE
\\:maple_leaf:                      <char-0x1F341>               " 🍁          : MAPLE LEAF
\\:mask:                            <char-0x1F637>               " 😷          : FACE WITH MEDICAL MASK
\\:massage:                         <char-0x1F486>               " 💆          : FACE MASSAGE
\\:meat_on_bone:                    <char-0x1F356>               " 🍖          : MEAT ON BONE
\\:mega:                            <char-0x1F4E3>               " 📣          : CHEERING MEGAPHONE
\\:melon:                           <char-0x1F348>               " 🍈          : MELON
\\:memo:                            <char-0x1F4DD>               " 📝          : MEMO
\\:mens:                            <char-0x1F6B9>               " 🚹          : MENS SYMBOL
\\:metro:                           <char-0x1F687>               " 🚇          : METRO
\\:microphone:                      <char-0x1F3A4>               " 🎤          : MICROPHONE
\\:microscope:                      <char-0x1F52C>               " 🔬          : MICROSCOPE
\\:milky_way:                       <char-0x1F30C>               " 🌌          : MILKY WAY
\\:minibus:                         <char-0x1F690>               " 🚐          : MINIBUS
\\:minidisc:                        <char-0x1F4BD>               " 💽          : MINIDISC
\\:mobile_phone_off:                <char-0x1F4F4>               " 📴          : MOBILE PHONE OFF
\\:money_with_wings:                <char-0x1F4B8>               " 💸          : MONEY WITH WINGS
\\:moneybag:                        <char-0x1F4B0>               " 💰          : MONEY BAG
\\:monkey:                          <char-0x1F412>               " 🐒          : MONKEY
\\:monkey_face:                     <char-0x1F435>               " 🐵          : MONKEY FACE
\\:monorail:                        <char-0x1F69D>               " 🚝          : MONORAIL
\\:moon:                            <char-0x1F314>               " 🌔          : WAXING GIBBOUS MOON SYMBOL
\\:mortar_board:                    <char-0x1F393>               " 🎓          : GRADUATION CAP
\\:mount_fuji:                      <char-0x1F5FB>               " 🗻          : MOUNT FUJI
\\:mountain_bicyclist:              <char-0x1F6B5>               " 🚵          : MOUNTAIN BICYCLIST
\\:mountain_cableway:               <char-0x1F6A0>               " 🚠          : MOUNTAIN CABLEWAY
\\:mountain_railway:                <char-0x1F69E>               " 🚞          : MOUNTAIN RAILWAY
\\:mouse2:                          <char-0x1F401>               " 🐁          : MOUSE
\\:mouse:                           <char-0x1F42D>               " 🐭          : MOUSE FACE
\\:movie_camera:                    <char-0x1F3A5>               " 🎥          : MOVIE CAMERA
\\:moyai:                           <char-0x1F5FF>               " 🗿          : MOYAI
\\:muscle:                          <char-0x1F4AA>               " 💪          : FLEXED BICEPS
\\:mushroom:                        <char-0x1F344>               " 🍄          : MUSHROOM
\\:musical_keyboard:                <char-0x1F3B9>               " 🎹          : MUSICAL KEYBOARD
\\:musical_note:                    <char-0x1F3B5>               " 🎵          : MUSICAL NOTE
\\:musical_score:                   <char-0x1F3BC>               " 🎼          : MUSICAL SCORE
\\:mute:                            <char-0x1F507>               " 🔇          : SPEAKER WITH CANCELLATION STROKE
\\:nail_care:                       <char-0x1F485>               " 💅          : NAIL POLISH
\\:name_badge:                      <char-0x1F4DB>               " 📛          : NAME BADGE
\\:necktie:                         <char-0x1F454>               " 👔          : NECKTIE
\\:negative_squared_cross_mark:     <char-0x0274E>               " ❎          : NEGATIVE SQUARED CROSS MARK
\\:neutral_face:                    <char-0x1F610>               " 😐          : NEUTRAL FACE
\\:new:                             <char-0x1F195>               " 🆕          : SQUARED NEW
\\:new_moon:                        <char-0x1F311>               " 🌑          : NEW MOON SYMBOL
\\:new_moon_with_face:              <char-0x1F31A>               " 🌚          : NEW MOON WITH FACE
\\:newspaper:                       <char-0x1F4F0>               " 📰          : NEWSPAPER
\\:ng:                              <char-0x1F196>               " 🆖          : SQUARED NG
\\:night_with_stars:                <char-0x1F303>               " 🌃          : NIGHT WITH STARS
\\:no_bell:                         <char-0x1F515>               " 🔕          : BELL WITH CANCELLATION STROKE
\\:no_bicycles:                     <char-0x1F6B3>               " 🚳          : NO BICYCLES
\\:no_entry:                        <char-0x026D4>               " ⛔          : NO ENTRY
\\:no_entry_sign:                   <char-0x1F6AB>               " 🚫          : NO ENTRY SIGN
\\:no_good:                         <char-0x1F645>               " 🙅          : FACE WITH NO GOOD GESTURE
\\:no_mobile_phones:                <char-0x1F4F5>               " 📵          : NO MOBILE PHONES
\\:no_mouth:                        <char-0x1F636>               " 😶          : FACE WITHOUT MOUTH
\\:no_pedestrians:                  <char-0x1F6B7>               " 🚷          : NO PEDESTRIANS
\\:no_smoking:                      <char-0x1F6AD>               " 🚭          : NO SMOKING SYMBOL
\\:non-potable_water:               <char-0x1F6B1>               " 🚱          : NON-POTABLE WATER SYMBOL
\\:nose:                            <char-0x1F443>               " 👃          : NOSE
\\:notebook:                        <char-0x1F4D3>               " 📓          : NOTEBOOK
\\:notebook_with_decorative_cover:  <char-0x1F4D4>               " 📔          : NOTEBOOK WITH DECORATIVE COVER
\\:notes:                           <char-0x1F3B6>               " 🎶          : MULTIPLE MUSICAL NOTES
\\:nut_and_bolt:                    <char-0x1F529>               " 🔩          : NUT AND BOLT
\\:o2:                              <char-0x1F17E>               " 🅾          : NEGATIVE SQUARED LATIN CAPITAL LETTER O
\\:o:                               <char-0x02B55>               " ⭕          : HEAVY LARGE CIRCLE
\\:ocean:                           <char-0x1F30A>               " 🌊          : WATER WAVE
\\:octopus:                         <char-0x1F419>               " 🐙          : OCTOPUS
\\:oden:                            <char-0x1F362>               " 🍢          : ODEN
\\:office:                          <char-0x1F3E2>               " 🏢          : OFFICE BUILDING
\\:ok:                              <char-0x1F197>               " 🆗          : SQUARED OK
\\:ok_hand:                         <char-0x1F44C>               " 👌          : OK HAND SIGN
\\:ok_woman:                        <char-0x1F646>               " 🙆          : FACE WITH OK GESTURE
\\:older_man:                       <char-0x1F474>               " 👴          : OLDER MAN
\\:older_woman:                     <char-0x1F475>               " 👵          : OLDER WOMAN
\\:on:                              <char-0x1F51B>               " 🔛          : ON WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE
\\:oncoming_automobile:             <char-0x1F698>               " 🚘          : ONCOMING AUTOMOBILE
\\:oncoming_bus:                    <char-0x1F68D>               " 🚍          : ONCOMING BUS
\\:oncoming_police_car:             <char-0x1F694>               " 🚔          : ONCOMING POLICE CAR
\\:oncoming_taxi:                   <char-0x1F696>               " 🚖          : ONCOMING TAXI
\\:open_file_folder:                <char-0x1F4C2>               " 📂          : OPEN FILE FOLDER
\\:open_hands:                      <char-0x1F450>               " 👐          : OPEN HANDS SIGN
\\:open_mouth:                      <char-0x1F62E>               " 😮          : FACE WITH OPEN MOUTH
\\:ophiuchus:                       <char-0x026CE>               " ⛎          : OPHIUCHUS
\\:orange_book:                     <char-0x1F4D9>               " 📙          : ORANGE BOOK
\\:outbox_tray:                     <char-0x1F4E4>               " 📤          : OUTBOX TRAY
\\:ox:                              <char-0x1F402>               " 🐂          : OX
\\:package:                         <char-0x1F4E6>               " 📦          : PACKAGE
\\:page_facing_up:                  <char-0x1F4C4>               " 📄          : PAGE FACING UP
\\:page_with_curl:                  <char-0x1F4C3>               " 📃          : PAGE WITH CURL
\\:pager:                           <char-0x1F4DF>               " 📟          : PAGER
\\:palm_tree:                       <char-0x1F334>               " 🌴          : PALM TREE
\\:panda_face:                      <char-0x1F43C>               " 🐼          : PANDA FACE
\\:paperclip:                       <char-0x1F4CE>               " 📎          : PAPERCLIP
\\:parking:                         <char-0x1F17F>               " 🅿          : NEGATIVE SQUARED LATIN CAPITAL LETTER P
\\:part_alternation_mark:           <char-0x0303D>               " 〽          : PART ALTERNATION MARK
\\:partly_sunny:                    <char-0x026C5>               " ⛅          : SUN BEHIND CLOUD
\\:passport_control:                <char-0x1F6C2>               " 🛂          : PASSPORT CONTROL
\\:peach:                           <char-0x1F351>               " 🍑          : PEACH
\\:pear:                            <char-0x1F350>               " 🍐          : PEAR
\\:pencil2:                         <char-0x0270F>               " ✏          : PENCIL
\\:penguin:                         <char-0x1F427>               " 🐧          : PENGUIN
\\:pensive:                         <char-0x1F614>               " 😔          : PENSIVE FACE
\\:performing_arts:                 <char-0x1F3AD>               " 🎭          : PERFORMING ARTS
\\:persevere:                       <char-0x1F623>               " 😣          : PERSEVERING FACE
\\:person_frowning:                 <char-0x1F64D>               " 🙍          : PERSON FROWNING
\\:person_with_blond_hair:          <char-0x1F471>               " 👱          : PERSON WITH BLOND HAIR
\\:person_with_pouting_face:        <char-0x1F64E>               " 🙎          : PERSON WITH POUTING FACE
\\:phone:                           <char-0x0260E>               " ☎          : BLACK TELEPHONE
\\:pig2:                            <char-0x1F416>               " 🐖          : PIG
\\:pig:                             <char-0x1F437>               " 🐷          : PIG FACE
\\:pig_nose:                        <char-0x1F43D>               " 🐽          : PIG NOSE
\\:pill:                            <char-0x1F48A>               " 💊          : PILL
\\:pineapple:                       <char-0x1F34D>               " 🍍          : PINEAPPLE
\\:pisces:                          <char-0x02653>               " ♓          : PISCES
\\:pizza:                           <char-0x1F355>               " 🍕          : SLICE OF PIZZA
\\:point_down:                      <char-0x1F447>               " 👇          : WHITE DOWN POINTING BACKHAND INDEX
\\:point_left:                      <char-0x1F448>               " 👈          : WHITE LEFT POINTING BACKHAND INDEX
\\:point_right:                     <char-0x1F449>               " 👉          : WHITE RIGHT POINTING BACKHAND INDEX
\\:point_up:                        <char-0x0261D>               " ☝          : WHITE UP POINTING INDEX
\\:point_up_2:                      <char-0x1F446>               " 👆          : WHITE UP POINTING BACKHAND INDEX
\\:police_car:                      <char-0x1F693>               " 🚓          : POLICE CAR
\\:poodle:                          <char-0x1F429>               " 🐩          : POODLE
\\:post_office:                     <char-0x1F3E3>               " 🏣          : JAPANESE POST OFFICE
\\:postal_horn:                     <char-0x1F4EF>               " 📯          : POSTAL HORN
\\:postbox:                         <char-0x1F4EE>               " 📮          : POSTBOX
\\:potable_water:                   <char-0x1F6B0>               " 🚰          : POTABLE WATER SYMBOL
\\:pouch:                           <char-0x1F45D>               " 👝          : POUCH
\\:poultry_leg:                     <char-0x1F357>               " 🍗          : POULTRY LEG
\\:pound:                           <char-0x1F4B7>               " 💷          : BANKNOTE WITH POUND SIGN
\\:pouting_cat:                     <char-0x1F63E>               " 😾          : POUTING CAT FACE
\\:pray:                            <char-0x1F64F>               " 🙏          : PERSON WITH FOLDED HANDS
\\:princess:                        <char-0x1F478>               " 👸          : PRINCESS
\\:purple_heart:                    <char-0x1F49C>               " 💜          : PURPLE HEART
\\:purse:                           <char-0x1F45B>               " 👛          : PURSE
\\:pushpin:                         <char-0x1F4CC>               " 📌          : PUSHPIN
\\:put_litter_in_its_place:         <char-0x1F6AE>               " 🚮          : PUT LITTER IN ITS PLACE SYMBOL
\\:question:                        <char-0x02753>               " ❓          : BLACK QUESTION MARK ORNAMENT
\\:rabbit2:                         <char-0x1F407>               " 🐇          : RABBIT
\\:rabbit:                          <char-0x1F430>               " 🐰          : RABBIT FACE
\\:racehorse:                       <char-0x1F40E>               " 🐎          : HORSE
\\:radio:                           <char-0x1F4FB>               " 📻          : RADIO
\\:radio_button:                    <char-0x1F518>               " 🔘          : RADIO BUTTON
\\:rage:                            <char-0x1F621>               " 😡          : POUTING FACE
\\:railway_car:                     <char-0x1F683>               " 🚃          : RAILWAY CAR
\\:rainbow:                         <char-0x1F308>               " 🌈          : RAINBOW
\\:raised_hands:                    <char-0x1F64C>               " 🙌          : PERSON RAISING BOTH HANDS IN CELEBRATION
\\:raising_hand:                    <char-0x1F64B>               " 🙋          : HAPPY PERSON RAISING ONE HAND
\\:ram:                             <char-0x1F40F>               " 🐏          : RAM
\\:ramen:                           <char-0x1F35C>               " 🍜          : STEAMING BOWL
\\:rat:                             <char-0x1F400>               " 🐀          : RAT
\\:recycle:                         <char-0x0267B>               " ♻          : BLACK UNIVERSAL RECYCLING SYMBOL
\\:red_circle:                      <char-0x1F534>               " 🔴          : LARGE RED CIRCLE
\\:registered:                      <char-0x000AE>               " ®          : REGISTERED SIGN / REGISTERED TRADE MARK SIGN
\\:relaxed:                         <char-0x0263A>               " ☺          : WHITE SMILING FACE
\\:relieved:                        <char-0x1F60C>               " 😌          : RELIEVED FACE
\\:repeat:                          <char-0x1F501>               " 🔁          : CLOCKWISE RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS
\\:repeat_one:                      <char-0x1F502>               " 🔂          : CLOCKWISE RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS WITH CIRCLED ONE OVERLAY
\\:restroom:                        <char-0x1F6BB>               " 🚻          : RESTROOM
\\:revolving_hearts:                <char-0x1F49E>               " 💞          : REVOLVING HEARTS
\\:rewind:                          <char-0x023EA>               " ⏪          : BLACK LEFT-POINTING DOUBLE TRIANGLE
\\:ribbon:                          <char-0x1F380>               " 🎀          : RIBBON
\\:rice:                            <char-0x1F35A>               " 🍚          : COOKED RICE
\\:rice_ball:                       <char-0x1F359>               " 🍙          : RICE BALL
\\:rice_cracker:                    <char-0x1F358>               " 🍘          : RICE CRACKER
\\:rice_scene:                      <char-0x1F391>               " 🎑          : MOON VIEWING CEREMONY
\\:ring:                            <char-0x1F48D>               " 💍          : RING
\\:rocket:                          <char-0x1F680>               " 🚀          : ROCKET
\\:roller_coaster:                  <char-0x1F3A2>               " 🎢          : ROLLER COASTER
\\:rooster:                         <char-0x1F413>               " 🐓          : ROOSTER
\\:rose:                            <char-0x1F339>               " 🌹          : ROSE
\\:rotating_light:                  <char-0x1F6A8>               " 🚨          : POLICE CARS REVOLVING LIGHT
\\:round_pushpin:                   <char-0x1F4CD>               " 📍          : ROUND PUSHPIN
\\:rowboat:                         <char-0x1F6A3>               " 🚣          : ROWBOAT
\\:rugby_football:                  <char-0x1F3C9>               " 🏉          : RUGBY FOOTBALL
\\:runner:                          <char-0x1F3C3>               " 🏃          : RUNNER
\\:running_shirt_with_sash:         <char-0x1F3BD>               " 🎽          : RUNNING SHIRT WITH SASH
\\:sa:                              <char-0x1F202>               " 🈂          : SQUARED KATAKANA SA
\\:sagittarius:                     <char-0x02650>               " ♐          : SAGITTARIUS
\\:sake:                            <char-0x1F376>               " 🍶          : SAKE BOTTLE AND CUP
\\:sandal:                          <char-0x1F461>               " 👡          : WOMANS SANDAL
\\:santa:                           <char-0x1F385>               " 🎅          : FATHER CHRISTMAS
\\:satellite:                       <char-0x1F4E1>               " 📡          : SATELLITE ANTENNA
\\:saxophone:                       <char-0x1F3B7>               " 🎷          : SAXOPHONE
\\:school:                          <char-0x1F3EB>               " 🏫          : SCHOOL
\\:school_satchel:                  <char-0x1F392>               " 🎒          : SCHOOL SATCHEL
\\:scissors:                        <char-0x02702>               " ✂          : BLACK SCISSORS
\\:scorpius:                        <char-0x0264F>               " ♏          : SCORPIUS
\\:scream:                          <char-0x1F631>               " 😱          : FACE SCREAMING IN FEAR
\\:scream_cat:                      <char-0x1F640>               " 🙀          : WEARY CAT FACE
\\:scroll:                          <char-0x1F4DC>               " 📜          : SCROLL
\\:seat:                            <char-0x1F4BA>               " 💺          : SEAT
\\:secret:                          <char-0x03299>               " ㊙          : CIRCLED IDEOGRAPH SECRET
\\:see_no_evil:                     <char-0x1F648>               " 🙈          : SEE-NO-EVIL MONKEY
\\:seedling:                        <char-0x1F331>               " 🌱          : SEEDLING
\\:shaved_ice:                      <char-0x1F367>               " 🍧          : SHAVED ICE
\\:sheep:                           <char-0x1F411>               " 🐑          : SHEEP
\\:shell:                           <char-0x1F41A>               " 🐚          : SPIRAL SHELL
\\:ship:                            <char-0x1F6A2>               " 🚢          : SHIP
\\:shirt:                           <char-0x1F455>               " 👕          : T-SHIRT
\\:shower:                          <char-0x1F6BF>               " 🚿          : SHOWER
\\:signal_strength:                 <char-0x1F4F6>               " 📶          : ANTENNA WITH BARS
\\:six_pointed_star:                <char-0x1F52F>               " 🔯          : SIX POINTED STAR WITH MIDDLE DOT
\\:ski:                             <char-0x1F3BF>               " 🎿          : SKI AND SKI BOOT
\\:skin-tone-2:                     <char-0x1F3FB>               " 🏻          : EMOJI MODIFIER FITZPATRICK TYPE-1-2
\\:skin-tone-3:                     <char-0x1F3FC>               " 🏼          : EMOJI MODIFIER FITZPATRICK TYPE-3
\\:skin-tone-4:                     <char-0x1F3FD>               " 🏽          : EMOJI MODIFIER FITZPATRICK TYPE-4
\\:skin-tone-5:                     <char-0x1F3FE>               " 🏾          : EMOJI MODIFIER FITZPATRICK TYPE-5
\\:skin-tone-6:                     <char-0x1F3FF>               " 🏿          : EMOJI MODIFIER FITZPATRICK TYPE-6
\\:skull:                           <char-0x1F480>               " 💀          : SKULL
\\:sleeping:                        <char-0x1F634>               " 😴          : SLEEPING FACE
\\:sleepy:                          <char-0x1F62A>               " 😪          : SLEEPY FACE
\\:slot_machine:                    <char-0x1F3B0>               " 🎰          : SLOT MACHINE
\\:small_blue_diamond:              <char-0x1F539>               " 🔹          : SMALL BLUE DIAMOND
\\:small_orange_diamond:            <char-0x1F538>               " 🔸          : SMALL ORANGE DIAMOND
\\:small_red_triangle:              <char-0x1F53A>               " 🔺          : UP-POINTING RED TRIANGLE
\\:small_red_triangle_down:         <char-0x1F53B>               " 🔻          : DOWN-POINTING RED TRIANGLE
\\:smile:                           <char-0x1F604>               " 😄          : SMILING FACE WITH OPEN MOUTH AND SMILING EYES
\\:smile_cat:                       <char-0x1F638>               " 😸          : GRINNING CAT FACE WITH SMILING EYES
\\:smiley:                          <char-0x1F603>               " 😃          : SMILING FACE WITH OPEN MOUTH
\\:smiley_cat:                      <char-0x1F63A>               " 😺          : SMILING CAT FACE WITH OPEN MOUTH
\\:smiling_imp:                     <char-0x1F608>               " 😈          : SMILING FACE WITH HORNS
\\:smirk:                           <char-0x1F60F>               " 😏          : SMIRKING FACE
\\:smirk_cat:                       <char-0x1F63C>               " 😼          : CAT FACE WITH WRY SMILE
\\:smoking:                         <char-0x1F6AC>               " 🚬          : SMOKING SYMBOL
\\:snail:                           <char-0x1F40C>               " 🐌          : SNAIL
\\:snake:                           <char-0x1F40D>               " 🐍          : SNAKE
\\:snowboarder:                     <char-0x1F3C2>               " 🏂          : SNOWBOARDER
\\:snowflake:                       <char-0x02744>               " ❄          : SNOWFLAKE
\\:snowman:                         <char-0x026C4>               " ⛄          : SNOWMAN WITHOUT SNOW
\\:sob:                             <char-0x1F62D>               " 😭          : LOUDLY CRYING FACE
\\:soccer:                          <char-0x026BD>               " ⚽          : SOCCER BALL
\\:soon:                            <char-0x1F51C>               " 🔜          : SOON WITH RIGHTWARDS ARROW ABOVE
\\:sos:                             <char-0x1F198>               " 🆘          : SQUARED SOS
\\:sound:                           <char-0x1F509>               " 🔉          : SPEAKER WITH ONE SOUND WAVE
\\:space_invader:                   <char-0x1F47E>               " 👾          : ALIEN MONSTER
\\:spades:                          <char-0x02660>               " ♠          : BLACK SPADE SUIT
\\:spaghetti:                       <char-0x1F35D>               " 🍝          : SPAGHETTI
\\:sparkle:                         <char-0x02747>               " ❇          : SPARKLE
\\:sparkler:                        <char-0x1F387>               " 🎇          : FIREWORK SPARKLER
\\:sparkles:                        <char-0x02728>               " ✨          : SPARKLES
\\:sparkling_heart:                 <char-0x1F496>               " 💖          : SPARKLING HEART
\\:speak_no_evil:                   <char-0x1F64A>               " 🙊          : SPEAK-NO-EVIL MONKEY
\\:speaker:                         <char-0x1F508>               " 🔈          : SPEAKER
\\:speech_balloon:                  <char-0x1F4AC>               " 💬          : SPEECH BALLOON
\\:speedboat:                       <char-0x1F6A4>               " 🚤          : SPEEDBOAT
\\:star2:                           <char-0x1F31F>               " 🌟          : GLOWING STAR
\\:star:                            <char-0x02B50>               " ⭐          : WHITE MEDIUM STAR
\\:stars:                           <char-0x1F320>               " 🌠          : SHOOTING STAR
\\:station:                         <char-0x1F689>               " 🚉          : STATION
\\:statue_of_liberty:               <char-0x1F5FD>               " 🗽          : STATUE OF LIBERTY
\\:steam_locomotive:                <char-0x1F682>               " 🚂          : STEAM LOCOMOTIVE
\\:stew:                            <char-0x1F372>               " 🍲          : POT OF FOOD
\\:straight_ruler:                  <char-0x1F4CF>               " 📏          : STRAIGHT RULER
\\:strawberry:                      <char-0x1F353>               " 🍓          : STRAWBERRY
\\:stuck_out_tongue:                <char-0x1F61B>               " 😛          : FACE WITH STUCK-OUT TONGUE
\\:stuck_out_tongue_closed_eyes:    <char-0x1F61D>               " 😝          : FACE WITH STUCK-OUT TONGUE AND TIGHTLY-CLOSED EYES
\\:stuck_out_tongue_winking_eye:    <char-0x1F61C>               " 😜          : FACE WITH STUCK-OUT TONGUE AND WINKING EYE
\\:sun_with_face:                   <char-0x1F31E>               " 🌞          : SUN WITH FACE
\\:sunflower:                       <char-0x1F33B>               " 🌻          : SUNFLOWER
\\:sunglasses:                      <char-0x1F60E>               " 😎          : SMILING FACE WITH SUNGLASSES
\\:sunny:                           <char-0x02600>               " ☀          : BLACK SUN WITH RAYS
\\:sunrise:                         <char-0x1F305>               " 🌅          : SUNRISE
\\:sunrise_over_mountains:          <char-0x1F304>               " 🌄          : SUNRISE OVER MOUNTAINS
\\:surfer:                          <char-0x1F3C4>               " 🏄          : SURFER
\\:sushi:                           <char-0x1F363>               " 🍣          : SUSHI
\\:suspension_railway:              <char-0x1F69F>               " 🚟          : SUSPENSION RAILWAY
\\:sweat:                           <char-0x1F613>               " 😓          : FACE WITH COLD SWEAT
\\:sweat_drops:                     <char-0x1F4A6>               " 💦          : SPLASHING SWEAT SYMBOL
\\:sweat_smile:                     <char-0x1F605>               " 😅          : SMILING FACE WITH OPEN MOUTH AND COLD SWEAT
\\:sweet_potato:                    <char-0x1F360>               " 🍠          : ROASTED SWEET POTATO
\\:swimmer:                         <char-0x1F3CA>               " 🏊          : SWIMMER
\\:symbols:                         <char-0x1F523>               " 🔣          : INPUT SYMBOL FOR SYMBOLS
\\:syringe:                         <char-0x1F489>               " 💉          : SYRINGE
\\:tada:                            <char-0x1F389>               " 🎉          : PARTY POPPER
\\:tanabata_tree:                   <char-0x1F38B>               " 🎋          : TANABATA TREE
\\:tangerine:                       <char-0x1F34A>               " 🍊          : TANGERINE
\\:taurus:                          <char-0x02649>               " ♉          : TAURUS
\\:taxi:                            <char-0x1F695>               " 🚕          : TAXI
\\:tea:                             <char-0x1F375>               " 🍵          : TEACUP WITHOUT HANDLE
\\:telephone_receiver:              <char-0x1F4DE>               " 📞          : TELEPHONE RECEIVER
\\:telescope:                       <char-0x1F52D>               " 🔭          : TELESCOPE
\\:tennis:                          <char-0x1F3BE>               " 🎾          : TENNIS RACQUET AND BALL
\\:tent:                            <char-0x026FA>               " ⛺          : TENT
\\:thought_balloon:                 <char-0x1F4AD>               " 💭          : THOUGHT BALLOON
\\:ticket:                          <char-0x1F3AB>               " 🎫          : TICKET
\\:tiger2:                          <char-0x1F405>               " 🐅          : TIGER
\\:tiger:                           <char-0x1F42F>               " 🐯          : TIGER FACE
\\:tired_face:                      <char-0x1F62B>               " 😫          : TIRED FACE
\\:tm:                              <char-0x02122>               " ™          : TRADE MARK SIGN / TRADEMARK
\\:toilet:                          <char-0x1F6BD>               " 🚽          : TOILET
\\:tokyo_tower:                     <char-0x1F5FC>               " 🗼          : TOKYO TOWER
\\:tomato:                          <char-0x1F345>               " 🍅          : TOMATO
\\:tongue:                          <char-0x1F445>               " 👅          : TONGUE
\\:top:                             <char-0x1F51D>               " 🔝          : TOP WITH UPWARDS ARROW ABOVE
\\:tophat:                          <char-0x1F3A9>               " 🎩          : TOP HAT
\\:tractor:                         <char-0x1F69C>               " 🚜          : TRACTOR
\\:traffic_light:                   <char-0x1F6A5>               " 🚥          : HORIZONTAL TRAFFIC LIGHT
\\:train2:                          <char-0x1F686>               " 🚆          : TRAIN
\\:train:                           <char-0x1F68B>               " 🚋          : TRAM CAR
\\:tram:                            <char-0x1F68A>               " 🚊          : TRAM
\\:triangular_flag_on_post:         <char-0x1F6A9>               " 🚩          : TRIANGULAR FLAG ON POST
\\:triangular_ruler:                <char-0x1F4D0>               " 📐          : TRIANGULAR RULER
\\:trident:                         <char-0x1F531>               " 🔱          : TRIDENT EMBLEM
\\:triumph:                         <char-0x1F624>               " 😤          : FACE WITH LOOK OF TRIUMPH
\\:trolleybus:                      <char-0x1F68E>               " 🚎          : TROLLEYBUS
\\:trophy:                          <char-0x1F3C6>               " 🏆          : TROPHY
\\:tropical_drink:                  <char-0x1F379>               " 🍹          : TROPICAL DRINK
\\:tropical_fish:                   <char-0x1F420>               " 🐠          : TROPICAL FISH
\\:truck:                           <char-0x1F69A>               " 🚚          : DELIVERY TRUCK
\\:trumpet:                         <char-0x1F3BA>               " 🎺          : TRUMPET
\\:tulip:                           <char-0x1F337>               " 🌷          : TULIP
\\:turtle:                          <char-0x1F422>               " 🐢          : TURTLE
\\:tv:                              <char-0x1F4FA>               " 📺          : TELEVISION
\\:twisted_rightwards_arrows:       <char-0x1F500>               " 🔀          : TWISTED RIGHTWARDS ARROWS
\\:two_hearts:                      <char-0x1F495>               " 💕          : TWO HEARTS
\\:two_men_holding_hands:           <char-0x1F46C>               " 👬          : TWO MEN HOLDING HANDS
\\:two_women_holding_hands:         <char-0x1F46D>               " 👭          : TWO WOMEN HOLDING HANDS
\\:u5272:                           <char-0x1F239>               " 🈹          : SQUARED CJK UNIFIED IDEOGRAPH-5272
\\:u5408:                           <char-0x1F234>               " 🈴          : SQUARED CJK UNIFIED IDEOGRAPH-5408
\\:u55b6:                           <char-0x1F23A>               " 🈺          : SQUARED CJK UNIFIED IDEOGRAPH-55B6
\\:u6307:                           <char-0x1F22F>               " 🈯          : SQUARED CJK UNIFIED IDEOGRAPH-6307
\\:u6708:                           <char-0x1F237>               " 🈷          : SQUARED CJK UNIFIED IDEOGRAPH-6708
\\:u6709:                           <char-0x1F236>               " 🈶          : SQUARED CJK UNIFIED IDEOGRAPH-6709
\\:u6e80:                           <char-0x1F235>               " 🈵          : SQUARED CJK UNIFIED IDEOGRAPH-6E80
\\:u7121:                           <char-0x1F21A>               " 🈚          : SQUARED CJK UNIFIED IDEOGRAPH-7121
\\:u7533:                           <char-0x1F238>               " 🈸          : SQUARED CJK UNIFIED IDEOGRAPH-7533
\\:u7981:                           <char-0x1F232>               " 🈲          : SQUARED CJK UNIFIED IDEOGRAPH-7981
\\:u7a7a:                           <char-0x1F233>               " 🈳          : SQUARED CJK UNIFIED IDEOGRAPH-7A7A
\\:umbrella:                        <char-0x02614>               " ☔          : UMBRELLA WITH RAIN DROPS
\\:unamused:                        <char-0x1F612>               " 😒          : UNAMUSED FACE
\\:underage:                        <char-0x1F51E>               " 🔞          : NO ONE UNDER EIGHTEEN SYMBOL
\\:unlock:                          <char-0x1F513>               " 🔓          : OPEN LOCK
\\:up:                              <char-0x1F199>               " 🆙          : SQUARED UP WITH EXCLAMATION MARK
\\:v:                               <char-0x0270C>               " ✌          : VICTORY HAND
\\:vertical_traffic_light:          <char-0x1F6A6>               " 🚦          : VERTICAL TRAFFIC LIGHT
\\:vhs:                             <char-0x1F4FC>               " 📼          : VIDEOCASSETTE
\\:vibration_mode:                  <char-0x1F4F3>               " 📳          : VIBRATION MODE
\\:video_camera:                    <char-0x1F4F9>               " 📹          : VIDEO CAMERA
\\:video_game:                      <char-0x1F3AE>               " 🎮          : VIDEO GAME
\\:violin:                          <char-0x1F3BB>               " 🎻          : VIOLIN
\\:virgo:                           <char-0x0264D>               " ♍          : VIRGO
\\:volcano:                         <char-0x1F30B>               " 🌋          : VOLCANO
\\:vs:                              <char-0x1F19A>               " 🆚          : SQUARED VS
\\:walking:                         <char-0x1F6B6>               " 🚶          : PEDESTRIAN
\\:waning_crescent_moon:            <char-0x1F318>               " 🌘          : WANING CRESCENT MOON SYMBOL
\\:waning_gibbous_moon:             <char-0x1F316>               " 🌖          : WANING GIBBOUS MOON SYMBOL
\\:warning:                         <char-0x026A0>               " ⚠          : WARNING SIGN
\\:watch:                           <char-0x0231A>               " ⌚          : WATCH
\\:water_buffalo:                   <char-0x1F403>               " 🐃          : WATER BUFFALO
\\:watermelon:                      <char-0x1F349>               " 🍉          : WATERMELON
\\:wave:                            <char-0x1F44B>               " 👋          : WAVING HAND SIGN
\\:wavy_dash:                       <char-0x03030>               " 〰          : WAVY DASH
\\:waxing_crescent_moon:            <char-0x1F312>               " 🌒          : WAXING CRESCENT MOON SYMBOL
\\:wc:                              <char-0x1F6BE>               " 🚾          : WATER CLOSET
\\:weary:                           <char-0x1F629>               " 😩          : WEARY FACE
\\:wedding:                         <char-0x1F492>               " 💒          : WEDDING
\\:whale2:                          <char-0x1F40B>               " 🐋          : WHALE
\\:whale:                           <char-0x1F433>               " 🐳          : SPOUTING WHALE
\\:wheelchair:                      <char-0x0267F>               " ♿          : WHEELCHAIR SYMBOL
\\:white_check_mark:                <char-0x02705>               " ✅          : WHITE HEAVY CHECK MARK
\\:white_circle:                    <char-0x026AA>               " ⚪          : MEDIUM WHITE CIRCLE
\\:white_flower:                    <char-0x1F4AE>               " 💮          : WHITE FLOWER
\\:white_large_square:              <char-0x02B1C>               " ⬜          : WHITE LARGE SQUARE
\\:white_medium_small_square:       <char-0x025FD>               " ◽          : WHITE MEDIUM SMALL SQUARE
\\:white_medium_square:             <char-0x025FB>               " ◻          : WHITE MEDIUM SQUARE
\\:white_small_square:              <char-0x025AB>               " ▫          : WHITE SMALL SQUARE
\\:white_square_button:             <char-0x1F533>               " 🔳          : WHITE SQUARE BUTTON
\\:wind_chime:                      <char-0x1F390>               " 🎐          : WIND CHIME
\\:wine_glass:                      <char-0x1F377>               " 🍷          : WINE GLASS
\\:wink:                            <char-0x1F609>               " 😉          : WINKING FACE
\\:wolf:                            <char-0x1F43A>               " 🐺          : WOLF FACE
\\:woman:                           <char-0x1F469>               " 👩          : WOMAN
\\:womans_clothes:                  <char-0x1F45A>               " 👚          : WOMANS CLOTHES
\\:womans_hat:                      <char-0x1F452>               " 👒          : WOMANS HAT
\\:womens:                          <char-0x1F6BA>               " 🚺          : WOMENS SYMBOL
\\:worried:                         <char-0x1F61F>               " 😟          : WORRIED FACE
\\:wrench:                          <char-0x1F527>               " 🔧          : WRENCH
\\:x:                               <char-0x0274C>               " ❌          : CROSS MARK
\\:yellow_heart:                    <char-0x1F49B>               " 💛          : YELLOW HEART
\\:yen:                             <char-0x1F4B4>               " 💴          : BANKNOTE WITH YEN SIGN
\\:yum:                             <char-0x1F60B>               " 😋          : FACE SAVOURING DELICIOUS FOOD
\\:zap:                             <char-0x026A1>               " ⚡          : HIGH VOLTAGE SIGN
\\:zzz:                             <char-0x1F4A4>               " 💤          : SLEEPING SYMBOL
\\AA                                <char-0x000C5>               " Å          : LATIN CAPITAL LETTER A WITH RING ABOVE / LATIN CAPITAL LETTER A RING
\\AE                                <char-0x000C6>               " Æ          : LATIN CAPITAL LETTER AE / LATIN CAPITAL LETTER A E
\\Alpha                             <char-0x00391>               " Α          : GREEK CAPITAL LETTER ALPHA
\\And                               <char-0x02A53>               " ⩓          : DOUBLE LOGICAL AND
\\Angle                             <char-0x0299C>               " ⦜          : RIGHT ANGLE VARIANT WITH SQUARE
\\Angstrom                          <char-0x0212B>               " Å          : ANGSTROM SIGN / ANGSTROM UNIT
\\Beta                              <char-0x00392>               " Β          : GREEK CAPITAL LETTER BETA
\\Bumpeq                            <char-0x0224E>               " ≎          : GEOMETRICALLY EQUIVALENT TO
\\Cap                               <char-0x022D2>               " ⋒          : DOUBLE INTERSECTION
\\Chi                               <char-0x003A7>               " Χ          : GREEK CAPITAL LETTER CHI
\\Colon                             <char-0x02237>               " ∷          : PROPORTION
\\Colon<Tab>                        <char-0x02237>               " ∷          : PROPORTION
\\Colone                            \\Colone                     "            : (Incomplete sequence)
\\Coloneq                           <char-0x02A74>               " ⩴          : DOUBLE COLON EQUAL
\\Cup                               <char-0x022D3>               " ⋓          : DOUBLE UNION
\\DDownarrow                        <char-0x027F1>               " ⟱          : DOWNWARDS QUADRUPLE ARROW
\\DH                                <char-0x000D0>               " Ð          : LATIN CAPITAL LETTER ETH
\\DJ                                <char-0x00110>               " Đ          : LATIN CAPITAL LETTER D WITH STROKE / LATIN CAPITAL LETTER D BAR
\\Dashv                             <char-0x02AE4>               " ⫤          : VERTICAL BAR DOUBLE LEFT TURNSTILE
\\Ddownarrow                        <char-0x0290B>               " ⤋          : DOWNWARDS TRIPLE ARROW
\\Delta                             <char-0x00394>               " Δ          : GREEK CAPITAL LETTER DELTA
\\Digamma                           <char-0x003DC>               " Ϝ          : GREEK LETTER DIGAMMA / GREEK CAPITAL LETTER DIGAMMA
\\Doteq                             <char-0x02251>               " ≑          : GEOMETRICALLY EQUAL TO
\\DownArrowBar                      <char-0x02913>               " ⤓          : DOWNWARDS ARROW TO BAR
\\DownArrowUpArrow                  <char-0x021F5>               " ⇵          : DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
\\DownLeftRightVector               <char-0x02950>               " ⥐          : LEFT BARB DOWN RIGHT BARB DOWN HARPOON
\\DownLeftTeeVector                 <char-0x0295E>               " ⥞          : LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
\\DownLeftVectorBar                 <char-0x02956>               " ⥖          : LEFTWARDS HARPOON WITH BARB DOWN TO BAR
\\DownRightTeeVector                <char-0x0295F>               " ⥟          : RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
\\DownRightVectorBar                <char-0x02957>               " ⥗          : RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
\\Downarrow                         <char-0x021D3>               " ⇓          : DOWNWARDS DOUBLE ARROW / DOWN DOUBLE ARROW
\\ElOr                              <char-0x02A56>               " ⩖          : TWO INTERSECTING LOGICAL OR
\\Elroang                           <char-0x02986>               " ⦆          : RIGHT WHITE PARENTHESIS
\\Epsilon                           <char-0x00395>               " Ε          : GREEK CAPITAL LETTER EPSILON
\\Equal                             <char-0x02A75>               " ⩵          : TWO CONSECUTIVE EQUALS SIGNS
\\Equiv                             <char-0x02263>               " ≣          : STRICTLY EQUIVALENT TO
\\Eta                               <char-0x00397>               " Η          : GREEK CAPITAL LETTER ETA
\\Finv                              <char-0x02132>               " Ⅎ          : TURNED CAPITAL F / TURNED F
\\Game                              <char-0x02141>               " ⅁          : TURNED SANS-SERIF CAPITAL G
\\Gamma                             <char-0x00393>               " Γ          : GREEK CAPITAL LETTER GAMMA
\\H                                 <char-0x0030B>               " ◌̋         : COMBINING DOUBLE ACUTE ACCENT / NON-SPACING DOUBLE ACUTE
\\Im                                <char-0x02111>               " ℑ          : BLACK-LETTER CAPITAL I / BLACK-LETTER I
\\Iota                              <char-0x00399>               " Ι          : GREEK CAPITAL LETTER IOTA
\\Join                              <char-0x02A1D>               " ⨝          : JOIN
\\Kappa                             <char-0x0039A>               " Κ          : GREEK CAPITAL LETTER KAPPA
\\Koppa                             <char-0x003DE>               " Ϟ          : GREEK LETTER KOPPA / GREEK CAPITAL LETTER KOPPA
\\L                                 <char-0x00141>               " Ł          : LATIN CAPITAL LETTER L WITH STROKE / LATIN CAPITAL LETTER L SLASH
\\L<Tab>                            <char-0x00141>               " Ł          : LATIN CAPITAL LETTER L WITH STROKE / LATIN CAPITAL LETTER L SLASH
\\LL                                \\LL                         "            : (Incomplete sequence)
\\LLe                               \\LLe                        "            : (Incomplete sequence)
\\LLef                              \\LLef                       "            : (Incomplete sequence)
\\LLeft                             \\LLeft                      "            : (Incomplete sequence)
\\LLefta                            \\LLefta                     "            : (Incomplete sequence)
\\LLeftar                           \\LLeftar                    "            : (Incomplete sequence)
\\LLeftarr                          \\LLeftarr                   "            : (Incomplete sequence)
\\LLeftarro                         \\LLeftarro                  "            : (Incomplete sequence)
\\LLeftarrow                        <char-0x02B45>               " ⭅          : LEFTWARDS QUADRUPLE ARROW
\\La                                \\La                         "            : (Incomplete sequence)
\\Lam                               \\Lam                        "            : (Incomplete sequence)
\\Lamb                              \\Lamb                       "            : (Incomplete sequence)
\\Lambd                             \\Lambd                      "            : (Incomplete sequence)
\\Lambda                            <char-0x0039B>               " Λ          : GREEK CAPITAL LETTER LAMDA / GREEK CAPITAL LETTER LAMBDA
\\Lap                               <char-0x029CA>               " ⧊          : TRIANGLE WITH DOT ABOVE
\\Ld                                \\Ld                         "            : (Incomplete sequence)
\\Lds                               \\Lds                        "            : (Incomplete sequence)
\\Ldsh                              <char-0x021B2>               " ↲          : DOWNWARDS ARROW WITH TIP LEFTWARDS / DOWN ARROW WITH TIP LEFT
\\Le                                \\Le                         "            : (Incomplete sequence)
\\Lef                               \\Lef                        "            : (Incomplete sequence)
\\Left                              \\Left                       "            : (Incomplete sequence)
\\LeftD                             \\LeftD                      "            : (Incomplete sequence)
\\LeftDo                            \\LeftDo                     "            : (Incomplete sequence)
\\LeftDow                           \\LeftDow                    "            : (Incomplete sequence)
\\LeftDown                          \\LeftDown                   "            : (Incomplete sequence)
\\LeftDownT                         \\LeftDownT                  "            : (Incomplete sequence)
\\LeftDownTe                        \\LeftDownTe                 "            : (Incomplete sequence)
\\LeftDownTee                       \\LeftDownTee                "            : (Incomplete sequence)
\\LeftDownTeeV                      \\LeftDownTeeV               "            : (Incomplete sequence)
\\LeftDownTeeVe                     \\LeftDownTeeVe              "            : (Incomplete sequence)
\\LeftDownTeeVec                    \\LeftDownTeeVec             "            : (Incomplete sequence)
\\LeftDownTeeVect                   \\LeftDownTeeVect            "            : (Incomplete sequence)
\\LeftDownTeeVecto                  \\LeftDownTeeVecto           "            : (Incomplete sequence)
\\LeftDownTeeVector                 <char-0x02961>               " ⥡          : DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
\\LeftDownV                         \\LeftDownV                  "            : (Incomplete sequence)
\\LeftDownVe                        \\LeftDownVe                 "            : (Incomplete sequence)
\\LeftDownVec                       \\LeftDownVec                "            : (Incomplete sequence)
\\LeftDownVect                      \\LeftDownVect               "            : (Incomplete sequence)
\\LeftDownVecto                     \\LeftDownVecto              "            : (Incomplete sequence)
\\LeftDownVector                    \\LeftDownVector             "            : (Incomplete sequence)
\\LeftDownVectorB                   \\LeftDownVectorB            "            : (Incomplete sequence)
\\LeftDownVectorBa                  \\LeftDownVectorBa           "            : (Incomplete sequence)
\\LeftDownVectorBar                 <char-0x02959>               " ⥙          : DOWNWARDS HARPOON WITH BARB LEFT TO BAR
\\LeftR                             \\LeftR                      "            : (Incomplete sequence)
\\LeftRi                            \\LeftRi                     "            : (Incomplete sequence)
\\LeftRig                           \\LeftRig                    "            : (Incomplete sequence)
\\LeftRigh                          \\LeftRigh                   "            : (Incomplete sequence)
\\LeftRight                         \\LeftRight                  "            : (Incomplete sequence)
\\LeftRightV                        \\LeftRightV                 "            : (Incomplete sequence)
\\LeftRightVe                       \\LeftRightVe                "            : (Incomplete sequence)
\\LeftRightVec                      \\LeftRightVec               "            : (Incomplete sequence)
\\LeftRightVect                     \\LeftRightVect              "            : (Incomplete sequence)
\\LeftRightVecto                    \\LeftRightVecto             "            : (Incomplete sequence)
\\LeftRightVector                   <char-0x0294E>               " ⥎          : LEFT BARB UP RIGHT BARB UP HARPOON
\\LeftT                             \\LeftT                      "            : (Incomplete sequence)
\\LeftTe                            \\LeftTe                     "            : (Incomplete sequence)
\\LeftTee                           \\LeftTee                    "            : (Incomplete sequence)
\\LeftTeeV                          \\LeftTeeV                   "            : (Incomplete sequence)
\\LeftTeeVe                         \\LeftTeeVe                  "            : (Incomplete sequence)
\\LeftTeeVec                        \\LeftTeeVec                 "            : (Incomplete sequence)
\\LeftTeeVect                       \\LeftTeeVect                "            : (Incomplete sequence)
\\LeftTeeVecto                      \\LeftTeeVecto               "            : (Incomplete sequence)
\\LeftTeeVector                     <char-0x0295A>               " ⥚          : LEFTWARDS HARPOON WITH BARB UP FROM BAR
\\LeftTr                            \\LeftTr                     "            : (Incomplete sequence)
\\LeftTri                           \\LeftTri                    "            : (Incomplete sequence)
\\LeftTria                          \\LeftTria                   "            : (Incomplete sequence)
\\LeftTrian                         \\LeftTrian                  "            : (Incomplete sequence)
\\LeftTriang                        \\LeftTriang                 "            : (Incomplete sequence)
\\LeftTriangl                       \\LeftTriangl                "            : (Incomplete sequence)
\\LeftTriangle                      \\LeftTriangle               "            : (Incomplete sequence)
\\LeftTriangleB                     \\LeftTriangleB              "            : (Incomplete sequence)
\\LeftTriangleBa                    \\LeftTriangleBa             "            : (Incomplete sequence)
\\LeftTriangleBar                   <char-0x029CF>               " ⧏          : LEFT TRIANGLE BESIDE VERTICAL BAR
\\LeftU                             \\LeftU                      "            : (Incomplete sequence)
\\LeftUp                            \\LeftUp                     "            : (Incomplete sequence)
\\LeftUpD                           \\LeftUpD                    "            : (Incomplete sequence)
\\LeftUpDo                          \\LeftUpDo                   "            : (Incomplete sequence)
\\LeftUpDow                         \\LeftUpDow                  "            : (Incomplete sequence)
\\LeftUpDown                        \\LeftUpDown                 "            : (Incomplete sequence)
\\LeftUpDownV                       \\LeftUpDownV                "            : (Incomplete sequence)
\\LeftUpDownVe                      \\LeftUpDownVe               "            : (Incomplete sequence)
\\LeftUpDownVec                     \\LeftUpDownVec              "            : (Incomplete sequence)
\\LeftUpDownVect                    \\LeftUpDownVect             "            : (Incomplete sequence)
\\LeftUpDownVecto                   \\LeftUpDownVecto            "            : (Incomplete sequence)
\\LeftUpDownVector                  <char-0x02951>               " ⥑          : UP BARB LEFT DOWN BARB LEFT HARPOON
\\LeftUpT                           \\LeftUpT                    "            : (Incomplete sequence)
\\LeftUpTe                          \\LeftUpTe                   "            : (Incomplete sequence)
\\LeftUpTee                         \\LeftUpTee                  "            : (Incomplete sequence)
\\LeftUpTeeV                        \\LeftUpTeeV                 "            : (Incomplete sequence)
\\LeftUpTeeVe                       \\LeftUpTeeVe                "            : (Incomplete sequence)
\\LeftUpTeeVec                      \\LeftUpTeeVec               "            : (Incomplete sequence)
\\LeftUpTeeVect                     \\LeftUpTeeVect              "            : (Incomplete sequence)
\\LeftUpTeeVecto                    \\LeftUpTeeVecto             "            : (Incomplete sequence)
\\LeftUpTeeVector                   <char-0x02960>               " ⥠          : UPWARDS HARPOON WITH BARB LEFT FROM BAR
\\LeftUpV                           \\LeftUpV                    "            : (Incomplete sequence)
\\LeftUpVe                          \\LeftUpVe                   "            : (Incomplete sequence)
\\LeftUpVec                         \\LeftUpVec                  "            : (Incomplete sequence)
\\LeftUpVect                        \\LeftUpVect                 "            : (Incomplete sequence)
\\LeftUpVecto                       \\LeftUpVecto                "            : (Incomplete sequence)
\\LeftUpVector                      \\LeftUpVector               "            : (Incomplete sequence)
\\LeftUpVectorB                     \\LeftUpVectorB              "            : (Incomplete sequence)
\\LeftUpVectorBa                    \\LeftUpVectorBa             "            : (Incomplete sequence)
\\LeftUpVectorBar                   <char-0x02958>               " ⥘          : UPWARDS HARPOON WITH BARB LEFT TO BAR
\\LeftV                             \\LeftV                      "            : (Incomplete sequence)
\\LeftVe                            \\LeftVe                     "            : (Incomplete sequence)
\\LeftVec                           \\LeftVec                    "            : (Incomplete sequence)
\\LeftVect                          \\LeftVect                   "            : (Incomplete sequence)
\\LeftVecto                         \\LeftVecto                  "            : (Incomplete sequence)
\\LeftVector                        \\LeftVector                 "            : (Incomplete sequence)
\\LeftVectorB                       \\LeftVectorB                "            : (Incomplete sequence)
\\LeftVectorBa                      \\LeftVectorBa               "            : (Incomplete sequence)
\\LeftVectorBar                     <char-0x02952>               " ⥒          : LEFTWARDS HARPOON WITH BARB UP TO BAR
\\Lefta                             \\Lefta                      "            : (Incomplete sequence)
\\Leftar                            \\Leftar                     "            : (Incomplete sequence)
\\Leftarr                           \\Leftarr                    "            : (Incomplete sequence)
\\Leftarro                          \\Leftarro                   "            : (Incomplete sequence)
\\Leftarrow                         <char-0x021D0>               " ⇐          : LEFTWARDS DOUBLE ARROW / LEFT DOUBLE ARROW
\\Leftr                             \\Leftr                      "            : (Incomplete sequence)
\\Leftri                            \\Leftri                     "            : (Incomplete sequence)
\\Leftrig                           \\Leftrig                    "            : (Incomplete sequence)
\\Leftrigh                          \\Leftrigh                   "            : (Incomplete sequence)
\\Leftright                         \\Leftright                  "            : (Incomplete sequence)
\\Leftrighta                        \\Leftrighta                 "            : (Incomplete sequence)
\\Leftrightar                       \\Leftrightar                "            : (Incomplete sequence)
\\Leftrightarr                      \\Leftrightarr               "            : (Incomplete sequence)
\\Leftrightarro                     \\Leftrightarro              "            : (Incomplete sequence)
\\Leftrightarrow                    <char-0x021D4>               " ⇔          : LEFT RIGHT DOUBLE ARROW
\\Ll                                \\Ll                         "            : (Incomplete sequence)
\\Lle                               \\Lle                        "            : (Incomplete sequence)
\\Llef                              \\Llef                       "            : (Incomplete sequence)
\\Lleft                             \\Lleft                      "            : (Incomplete sequence)
\\Llefta                            \\Llefta                     "            : (Incomplete sequence)
\\Lleftar                           \\Lleftar                    "            : (Incomplete sequence)
\\Lleftarr                          \\Lleftarr                   "            : (Incomplete sequence)
\\Lleftarro                         \\Lleftarro                  "            : (Incomplete sequence)
\\Lleftarrow                        <char-0x021DA>               " ⇚          : LEFTWARDS TRIPLE ARROW / LEFT TRIPLE ARROW
\\Lo                                \\Lo                         "            : (Incomplete sequence)
\\Lon                               \\Lon                        "            : (Incomplete sequence)
\\Long                              \\Long                       "            : (Incomplete sequence)
\\Longl                             \\Longl                      "            : (Incomplete sequence)
\\Longle                            \\Longle                     "            : (Incomplete sequence)
\\Longlef                           \\Longlef                    "            : (Incomplete sequence)
\\Longleft                          \\Longleft                   "            : (Incomplete sequence)
\\Longlefta                         \\Longlefta                  "            : (Incomplete sequence)
\\Longleftar                        \\Longleftar                 "            : (Incomplete sequence)
\\Longleftarr                       \\Longleftarr                "            : (Incomplete sequence)
\\Longleftarro                      \\Longleftarro               "            : (Incomplete sequence)
\\Longleftarrow                     <char-0x027F8>               " ⟸          : LONG LEFTWARDS DOUBLE ARROW
\\Longleftr                         \\Longleftr                  "            : (Incomplete sequence)
\\Longleftri                        \\Longleftri                 "            : (Incomplete sequence)
\\Longleftrig                       \\Longleftrig                "            : (Incomplete sequence)
\\Longleftrigh                      \\Longleftrigh               "            : (Incomplete sequence)
\\Longleftright                     \\Longleftright              "            : (Incomplete sequence)
\\Longleftrighta                    \\Longleftrighta             "            : (Incomplete sequence)
\\Longleftrightar                   \\Longleftrightar            "            : (Incomplete sequence)
\\Longleftrightarr                  \\Longleftrightarr           "            : (Incomplete sequence)
\\Longleftrightarro                 \\Longleftrightarro          "            : (Incomplete sequence)
\\Longleftrightarrow                <char-0x027FA>               " ⟺          : LONG LEFT RIGHT DOUBLE ARROW
\\Longm                             \\Longm                      "            : (Incomplete sequence)
\\Longma                            \\Longma                     "            : (Incomplete sequence)
\\Longmap                           \\Longmap                    "            : (Incomplete sequence)
\\Longmaps                          \\Longmaps                   "            : (Incomplete sequence)
\\Longmapsf                         \\Longmapsf                  "            : (Incomplete sequence)
\\Longmapsfr                        \\Longmapsfr                 "            : (Incomplete sequence)
\\Longmapsfro                       \\Longmapsfro                "            : (Incomplete sequence)
\\Longmapsfrom                      <char-0x027FD>               " ⟽          : LONG LEFTWARDS DOUBLE ARROW FROM BAR
\\Longmapst                         \\Longmapst                  "            : (Incomplete sequence)
\\Longmapsto                        <char-0x027FE>               " ⟾          : LONG RIGHTWARDS DOUBLE ARROW FROM BAR
\\Longr                             \\Longr                      "            : (Incomplete sequence)
\\Longri                            \\Longri                     "            : (Incomplete sequence)
\\Longrig                           \\Longrig                    "            : (Incomplete sequence)
\\Longrigh                          \\Longrigh                   "            : (Incomplete sequence)
\\Longright                         \\Longright                  "            : (Incomplete sequence)
\\Longrighta                        \\Longrighta                 "            : (Incomplete sequence)
\\Longrightar                       \\Longrightar                "            : (Incomplete sequence)
\\Longrightarr                      \\Longrightarr               "            : (Incomplete sequence)
\\Longrightarro                     \\Longrightarro              "            : (Incomplete sequence)
\\Longrightarrow                    <char-0x027F9>               " ⟹          : LONG RIGHTWARDS DOUBLE ARROW
\\Ls                                \\Ls                         "            : (Incomplete sequence)
\\Lsh                               <char-0x021B0>               " ↰          : UPWARDS ARROW WITH TIP LEFTWARDS / UP ARROW WITH TIP LEFT
\\Mapsfrom                          <char-0x02906>               " ⤆          : LEFTWARDS DOUBLE ARROW FROM BAR
\\Mapsto                            <char-0x02907>               " ⤇          : RIGHTWARDS DOUBLE ARROW FROM BAR
\\NG                                <char-0x0014A>               " Ŋ          : LATIN CAPITAL LETTER ENG
\\Nearrow                           <char-0x021D7>               " ⇗          : NORTH EAST DOUBLE ARROW / UPPER RIGHT DOUBLE ARROW
\\NestedGreaterGreater              <char-0x02AA2>               " ⪢          : DOUBLE NESTED GREATER-THAN
\\NestedLessLess                    <char-0x02AA1>               " ⪡          : DOUBLE NESTED LESS-THAN
\\NotGreaterGreater                 <char-0x0226B><char-0x00338> " ≫̸         : MUCH GREATER-THAN / MUCH GREATER THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotLeftTriangleBar                <char-0x029CF><char-0x00338> " ⧏̸         : LEFT TRIANGLE BESIDE VERTICAL BAR + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotLessLess                       <char-0x0226A><char-0x00338> " ≪̸         : MUCH LESS-THAN / MUCH LESS THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotNestedGreaterGreater           <char-0x02AA2><char-0x00338> " ⪢̸         : DOUBLE NESTED GREATER-THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotNestedLessLess                 <char-0x02AA1><char-0x00338> " ⪡̸         : DOUBLE NESTED LESS-THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotRightTriangleBar               <char-0x029D0><char-0x00338> " ⧐̸         : VERTICAL BAR BESIDE RIGHT TRIANGLE + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotSquareSubset                   <char-0x0228F><char-0x00338> " ⊏̸         : SQUARE IMAGE OF + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotSquareSuperset                 <char-0x02290><char-0x00338> " ⊐̸         : SQUARE ORIGINAL OF + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\Nwarrow                           <char-0x021D6>               " ⇖          : NORTH WEST DOUBLE ARROW / UPPER LEFT DOUBLE ARROW
\\O                                 <char-0x000D8>               " Ø          : LATIN CAPITAL LETTER O WITH STROKE / LATIN CAPITAL LETTER O SLASH
\\O<Tab>                            <char-0x000D8>               " Ø          : LATIN CAPITAL LETTER O WITH STROKE / LATIN CAPITAL LETTER O SLASH
\\OE                                <char-0x00152>               " Œ          : LATIN CAPITAL LIGATURE OE / LATIN CAPITAL LETTER O E
\\Om                                \\Om                         "            : (Incomplete sequence)
\\Ome                               \\Ome                        "            : (Incomplete sequence)
\\Omeg                              \\Omeg                       "            : (Incomplete sequence)
\\Omega                             <char-0x003A9>               " Ω          : GREEK CAPITAL LETTER OMEGA
\\Or                                <char-0x02A54>               " ⩔          : DOUBLE LOGICAL OR
\\Ot                                \\Ot                         "            : (Incomplete sequence)
\\Oti                               \\Oti                        "            : (Incomplete sequence)
\\Otim                              \\Otim                       "            : (Incomplete sequence)
\\Otime                             \\Otime                      "            : (Incomplete sequence)
\\Otimes                            <char-0x02A37>               " ⨷          : MULTIPLICATION SIGN IN DOUBLE CIRCLE
\\P                                 <char-0x000B6>               " ¶          : PILCROW SIGN / PARAGRAPH SIGN
\\P<Tab>                            <char-0x000B6>               " ¶          : PILCROW SIGN / PARAGRAPH SIGN
\\Ph                                \\Ph                         "            : (Incomplete sequence)
\\Phi                               <char-0x003A6>               " Φ          : GREEK CAPITAL LETTER PHI
\\Pi                                <char-0x003A0>               " Π          : GREEK CAPITAL LETTER PI
\\Pr                                \\Pr                         "            : (Incomplete sequence)
\\Pre                               \\Pre                        "            : (Incomplete sequence)
\\Prec                              <char-0x02ABB>               " ⪻          : DOUBLE PRECEDES
\\Pro                               \\Pro                        "            : (Incomplete sequence)
\\Prop                              \\Prop                       "            : (Incomplete sequence)
\\Prope                             \\Prope                      "            : (Incomplete sequence)
\\Proper                            \\Proper                     "            : (Incomplete sequence)
\\Propert                           \\Propert                    "            : (Incomplete sequence)
\\Property                          \\Property                   "            : (Incomplete sequence)
\\PropertyL                         \\PropertyL                  "            : (Incomplete sequence)
\\PropertyLi                        \\PropertyLi                 "            : (Incomplete sequence)
\\PropertyLin                       \\PropertyLin                "            : (Incomplete sequence)
\\PropertyLine                      <char-0x0214A>               " ⅊          : PROPERTY LINE
\\Ps                                \\Ps                         "            : (Incomplete sequence)
\\Psi                               <char-0x003A8>               " Ψ          : GREEK CAPITAL LETTER PSI
\\QED                               <char-0x0220E>               " ∎          : END OF PROOF
\\RRightarrow                       <char-0x02B46>               " ⭆          : RIGHTWARDS QUADRUPLE ARROW
\\Rdsh                              <char-0x021B3>               " ↳          : DOWNWARDS ARROW WITH TIP RIGHTWARDS / DOWN ARROW WITH TIP RIGHT
\\Re                                <char-0x0211C>               " ℜ          : BLACK-LETTER CAPITAL R / BLACK-LETTER R
\\Re<Tab>                           <char-0x0211C>               " ℜ          : BLACK-LETTER CAPITAL R / BLACK-LETTER R
\\Rev                               \\Rev                        "            : (Incomplete sequence)
\\Reve                              \\Reve                       "            : (Incomplete sequence)
\\Rever                             \\Rever                      "            : (Incomplete sequence)
\\Revers                            \\Revers                     "            : (Incomplete sequence)
\\Reverse                           \\Reverse                    "            : (Incomplete sequence)
\\ReverseU                          \\ReverseU                   "            : (Incomplete sequence)
\\ReverseUp                         \\ReverseUp                  "            : (Incomplete sequence)
\\ReverseUpE                        \\ReverseUpE                 "            : (Incomplete sequence)
\\ReverseUpEq                       \\ReverseUpEq                "            : (Incomplete sequence)
\\ReverseUpEqu                      \\ReverseUpEqu               "            : (Incomplete sequence)
\\ReverseUpEqui                     \\ReverseUpEqui              "            : (Incomplete sequence)
\\ReverseUpEquil                    \\ReverseUpEquil             "            : (Incomplete sequence)
\\ReverseUpEquili                   \\ReverseUpEquili            "            : (Incomplete sequence)
\\ReverseUpEquilib                  \\ReverseUpEquilib           "            : (Incomplete sequence)
\\ReverseUpEquilibr                 \\ReverseUpEquilibr          "            : (Incomplete sequence)
\\ReverseUpEquilibri                \\ReverseUpEquilibri         "            : (Incomplete sequence)
\\ReverseUpEquilibriu               \\ReverseUpEquilibriu        "            : (Incomplete sequence)
\\ReverseUpEquilibrium              <char-0x0296F>               " ⥯          : DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
\\Rho                               <char-0x003A1>               " Ρ          : GREEK CAPITAL LETTER RHO
\\RightDownTeeVector                <char-0x0295D>               " ⥝          : DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
\\RightDownVectorBar                <char-0x02955>               " ⥕          : DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
\\RightTeeVector                    <char-0x0295B>               " ⥛          : RIGHTWARDS HARPOON WITH BARB UP FROM BAR
\\RightTriangleBar                  <char-0x029D0>               " ⧐          : VERTICAL BAR BESIDE RIGHT TRIANGLE
\\RightUpDownVector                 <char-0x0294F>               " ⥏          : UP BARB RIGHT DOWN BARB RIGHT HARPOON
\\RightUpTeeVector                  <char-0x0295C>               " ⥜          : UPWARDS HARPOON WITH BARB RIGHT FROM BAR
\\RightUpVectorBar                  <char-0x02954>               " ⥔          : UPWARDS HARPOON WITH BARB RIGHT TO BAR
\\RightVectorBar                    <char-0x02953>               " ⥓          : RIGHTWARDS HARPOON WITH BARB UP TO BAR
\\Rightarrow                        <char-0x021D2>               " ⇒          : RIGHTWARDS DOUBLE ARROW / RIGHT DOUBLE ARROW
\\Rlarr                             <char-0x02942>               " ⥂          : RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW
\\RoundImplies                      <char-0x02970>               " ⥰          : RIGHT DOUBLE ARROW WITH ROUNDED HEAD
\\Rrightarrow                       <char-0x021DB>               " ⇛          : RIGHTWARDS TRIPLE ARROW / RIGHT TRIPLE ARROW
\\Rsh                               <char-0x021B1>               " ↱          : UPWARDS ARROW WITH TIP RIGHTWARDS / UP ARROW WITH TIP RIGHT
\\RuleDelayed                       <char-0x029F4>               " ⧴          : RULE-DELAYED
\\S                                 <char-0x000A7>               " §          : SECTION SIGN
\\S<Tab>                            <char-0x000A7>               " §          : SECTION SIGN
\\Sa                                \\Sa                         "            : (Incomplete sequence)
\\Sam                               \\Sam                        "            : (Incomplete sequence)
\\Samp                              \\Samp                       "            : (Incomplete sequence)
\\Sampi                             <char-0x003E0>               " Ϡ          : GREEK LETTER SAMPI / GREEK CAPITAL LETTER SAMPI
\\Se                                \\Se                         "            : (Incomplete sequence)
\\Sea                               \\Sea                        "            : (Incomplete sequence)
\\Sear                              \\Sear                       "            : (Incomplete sequence)
\\Searr                             \\Searr                      "            : (Incomplete sequence)
\\Searro                            \\Searro                     "            : (Incomplete sequence)
\\Searrow                           <char-0x021D8>               " ⇘          : SOUTH EAST DOUBLE ARROW / LOWER RIGHT DOUBLE ARROW
\\Si                                \\Si                         "            : (Incomplete sequence)
\\Sig                               \\Sig                        "            : (Incomplete sequence)
\\Sigm                              \\Sigm                       "            : (Incomplete sequence)
\\Sigma                             <char-0x003A3>               " Σ          : GREEK CAPITAL LETTER SIGMA
\\Sq                                \\Sq                         "            : (Incomplete sequence)
\\Sqc                               \\Sqc                        "            : (Incomplete sequence)
\\Sqca                              \\Sqca                       "            : (Incomplete sequence)
\\Sqcap                             <char-0x02A4E>               " ⩎          : DOUBLE SQUARE INTERSECTION
\\Sqcu                              \\Sqcu                       "            : (Incomplete sequence)
\\Sqcup                             <char-0x02A4F>               " ⩏          : DOUBLE SQUARE UNION
\\St                                \\St                         "            : (Incomplete sequence)
\\Sti                               \\Sti                        "            : (Incomplete sequence)
\\Stig                              \\Stig                       "            : (Incomplete sequence)
\\Stigm                             \\Stigm                      "            : (Incomplete sequence)
\\Stigma                            <char-0x003DA>               " Ϛ          : GREEK LETTER STIGMA / GREEK CAPITAL LETTER STIGMA
\\Su                                \\Su                         "            : (Incomplete sequence)
\\Sub                               \\Sub                        "            : (Incomplete sequence)
\\Subs                              \\Subs                       "            : (Incomplete sequence)
\\Subse                             \\Subse                      "            : (Incomplete sequence)
\\Subset                            <char-0x022D0>               " ⋐          : DOUBLE SUBSET
\\Suc                               \\Suc                        "            : (Incomplete sequence)
\\Succ                              <char-0x02ABC>               " ⪼          : DOUBLE SUCCEEDS
\\Sup                               \\Sup                        "            : (Incomplete sequence)
\\Sups                              \\Sups                       "            : (Incomplete sequence)
\\Supse                             \\Supse                      "            : (Incomplete sequence)
\\Supset                            <char-0x022D1>               " ⋑          : DOUBLE SUPERSET
\\Sw                                \\Sw                         "            : (Incomplete sequence)
\\Swa                               \\Swa                        "            : (Incomplete sequence)
\\Swar                              \\Swar                       "            : (Incomplete sequence)
\\Swarr                             \\Swarr                      "            : (Incomplete sequence)
\\Swarro                            \\Swarro                     "            : (Incomplete sequence)
\\Swarrow                           <char-0x021D9>               " ⇙          : SOUTH WEST DOUBLE ARROW / LOWER LEFT DOUBLE ARROW
\\TH                                <char-0x000DE>               " Þ          : LATIN CAPITAL LETTER THORN
\\Tau                               <char-0x003A4>               " Τ          : GREEK CAPITAL LETTER TAU
\\Theta                             <char-0x00398>               " Θ          : GREEK CAPITAL LETTER THETA
\\Times                             <char-0x02A2F>               " ⨯          : VECTOR OR CROSS PRODUCT
\\UUparrow                          <char-0x027F0>               " ⟰          : UPWARDS QUADRUPLE ARROW
\\UpArrowBar                        <char-0x02912>               " ⤒          : UPWARDS ARROW TO BAR
\\UpEquilibrium                     <char-0x0296E>               " ⥮          : UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
\\Uparrow                           <char-0x021D1>               " ⇑          : UPWARDS DOUBLE ARROW / UP DOUBLE ARROW
\\Updownarrow                       <char-0x021D5>               " ⇕          : UP DOWN DOUBLE ARROW
\\Upsilon                           <char-0x003A5>               " Υ          : GREEK CAPITAL LETTER UPSILON
\\Uuparrow                          <char-0x0290A>               " ⤊          : UPWARDS TRIPLE ARROW
\\VDash                             <char-0x022AB>               " ⊫          : DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
\\Vdash                             <char-0x022A9>               " ⊩          : FORCES
\\Vert                              <char-0x02016>               " ‖          : DOUBLE VERTICAL LINE / DOUBLE VERTICAL BAR
\\Vvdash                            <char-0x022AA>               " ⊪          : TRIPLE VERTICAL BAR RIGHT TURNSTILE
\\Vvert                             <char-0x02980>               " ⦀          : TRIPLE VERTICAL BAR DELIMITER
\\Xi                                <char-0x0039E>               " Ξ          : GREEK CAPITAL LETTER XI
\\Yup                               <char-0x02144>               " ⅄          : TURNED SANS-SERIF CAPITAL Y
\\Zbar                              <char-0x001B5>               " Ƶ          : LATIN CAPITAL LETTER Z WITH STROKE / LATIN CAPITAL LETTER Z BAR
\\Zeta                              <char-0x00396>               " Ζ          : GREEK CAPITAL LETTER ZETA
\\^(                                <char-0x0207D>               " ⁽          : SUPERSCRIPT LEFT PARENTHESIS / SUPERSCRIPT OPENING PARENTHESIS
\\^)                                <char-0x0207E>               " ⁾          : SUPERSCRIPT RIGHT PARENTHESIS / SUPERSCRIPT CLOSING PARENTHESIS
\\^+                                <char-0x0207A>               " ⁺          : SUPERSCRIPT PLUS SIGN
\\^-                                <char-0x0207B>               " ⁻          : SUPERSCRIPT MINUS / SUPERSCRIPT HYPHEN-MINUS
\\^0                                <char-0x02070>               " ⁰          : SUPERSCRIPT ZERO / SUPERSCRIPT DIGIT ZERO
\\^1                                <char-0x000B9>               " ¹          : SUPERSCRIPT ONE / SUPERSCRIPT DIGIT ONE
\\^2                                <char-0x000B2>               " ²          : SUPERSCRIPT TWO / SUPERSCRIPT DIGIT TWO
\\^3                                <char-0x000B3>               " ³          : SUPERSCRIPT THREE / SUPERSCRIPT DIGIT THREE
\\^4                                <char-0x02074>               " ⁴          : SUPERSCRIPT FOUR / SUPERSCRIPT DIGIT FOUR
\\^5                                <char-0x02075>               " ⁵          : SUPERSCRIPT FIVE / SUPERSCRIPT DIGIT FIVE
\\^6                                <char-0x02076>               " ⁶          : SUPERSCRIPT SIX / SUPERSCRIPT DIGIT SIX
\\^7                                <char-0x02077>               " ⁷          : SUPERSCRIPT SEVEN / SUPERSCRIPT DIGIT SEVEN
\\^8                                <char-0x02078>               " ⁸          : SUPERSCRIPT EIGHT / SUPERSCRIPT DIGIT EIGHT
\\^9                                <char-0x02079>               " ⁹          : SUPERSCRIPT NINE / SUPERSCRIPT DIGIT NINE
\\^=                                <char-0x0207C>               " ⁼          : SUPERSCRIPT EQUALS SIGN
\\^A                                <char-0x01D2C>               " ᴬ          : MODIFIER LETTER CAPITAL A
\\^B                                <char-0x01D2E>               " ᴮ          : MODIFIER LETTER CAPITAL B
\\^D                                <char-0x01D30>               " ᴰ          : MODIFIER LETTER CAPITAL D
\\^E                                <char-0x01D31>               " ᴱ          : MODIFIER LETTER CAPITAL E
\\^G                                <char-0x01D33>               " ᴳ          : MODIFIER LETTER CAPITAL G
\\^H                                <char-0x01D34>               " ᴴ          : MODIFIER LETTER CAPITAL H
\\^I                                <char-0x01D35>               " ᴵ          : MODIFIER LETTER CAPITAL I
\\^J                                <char-0x01D36>               " ᴶ          : MODIFIER LETTER CAPITAL J
\\^K                                <char-0x01D37>               " ᴷ          : MODIFIER LETTER CAPITAL K
\\^L                                <char-0x01D38>               " ᴸ          : MODIFIER LETTER CAPITAL L
\\^M                                <char-0x01D39>               " ᴹ          : MODIFIER LETTER CAPITAL M
\\^N                                <char-0x01D3A>               " ᴺ          : MODIFIER LETTER CAPITAL N
\\^O                                <char-0x01D3C>               " ᴼ          : MODIFIER LETTER CAPITAL O
\\^P                                <char-0x01D3E>               " ᴾ          : MODIFIER LETTER CAPITAL P
\\^P<Tab>                           <char-0x01D3E>               " ᴾ          : MODIFIER LETTER CAPITAL P
\\^Ph                               \\^Ph                        "            : (Incomplete sequence)
\\^Phi                              <char-0x01DB2>               " ᶲ          : MODIFIER LETTER SMALL PHI
\\^R                                <char-0x01D3F>               " ᴿ          : MODIFIER LETTER CAPITAL R
\\^T                                <char-0x01D40>               " ᵀ          : MODIFIER LETTER CAPITAL T
\\^U                                <char-0x01D41>               " ᵁ          : MODIFIER LETTER CAPITAL U
\\^V                                <char-0x02C7D>               " ⱽ          : MODIFIER LETTER CAPITAL V
\\^W                                <char-0x01D42>               " ᵂ          : MODIFIER LETTER CAPITAL W
\\^a                                <char-0x01D43>               " ᵃ          : MODIFIER LETTER SMALL A
\\^a<Tab>                           <char-0x01D43>               " ᵃ          : MODIFIER LETTER SMALL A
\\^al                               \\^al                        "            : (Incomplete sequence)
\\^alp                              \\^alp                       "            : (Incomplete sequence)
\\^alph                             \\^alph                      "            : (Incomplete sequence)
\\^alpha                            <char-0x01D45>               " ᵅ          : MODIFIER LETTER SMALL ALPHA
\\^b                                <char-0x01D47>               " ᵇ          : MODIFIER LETTER SMALL B
\\^b<Tab>                           <char-0x01D47>               " ᵇ          : MODIFIER LETTER SMALL B
\\^be                               \\^be                        "            : (Incomplete sequence)
\\^bet                              \\^bet                       "            : (Incomplete sequence)
\\^beta                             <char-0x01D5D>               " ᵝ          : MODIFIER LETTER SMALL BETA
\\^c                                <char-0x01D9C>               " ᶜ          : MODIFIER LETTER SMALL C
\\^c<Tab>                           <char-0x01D9C>               " ᶜ          : MODIFIER LETTER SMALL C
\\^ch                               \\^ch                        "            : (Incomplete sequence)
\\^chi                              <char-0x01D61>               " ᵡ          : MODIFIER LETTER SMALL CHI
\\^d                                <char-0x01D48>               " ᵈ          : MODIFIER LETTER SMALL D
\\^d<Tab>                           <char-0x01D48>               " ᵈ          : MODIFIER LETTER SMALL D
\\^de                               \\^de                        "            : (Incomplete sequence)
\\^del                              \\^del                       "            : (Incomplete sequence)
\\^delt                             \\^delt                      "            : (Incomplete sequence)
\\^delta                            <char-0x01D5F>               " ᵟ          : MODIFIER LETTER SMALL DELTA
\\^e                                <char-0x01D49>               " ᵉ          : MODIFIER LETTER SMALL E
\\^e<Tab>                           <char-0x01D49>               " ᵉ          : MODIFIER LETTER SMALL E
\\^ep                               \\^ep                        "            : (Incomplete sequence)
\\^eps                              \\^eps                       "            : (Incomplete sequence)
\\^epsi                             \\^epsi                      "            : (Incomplete sequence)
\\^epsil                            \\^epsil                     "            : (Incomplete sequence)
\\^epsilo                           \\^epsilo                    "            : (Incomplete sequence)
\\^epsilon                          <char-0x01D4B>               " ᵋ          : MODIFIER LETTER SMALL OPEN E
\\^f                                <char-0x01DA0>               " ᶠ          : MODIFIER LETTER SMALL F
\\^g                                <char-0x01D4D>               " ᵍ          : MODIFIER LETTER SMALL G
\\^g<Tab>                           <char-0x01D4D>               " ᵍ          : MODIFIER LETTER SMALL G
\\^ga                               \\^ga                        "            : (Incomplete sequence)
\\^gam                              \\^gam                       "            : (Incomplete sequence)
\\^gamm                             \\^gamm                      "            : (Incomplete sequence)
\\^gamma                            <char-0x01D5E>               " ᵞ          : MODIFIER LETTER SMALL GREEK GAMMA
\\^h                                <char-0x002B0>               " ʰ          : MODIFIER LETTER SMALL H
\\^i                                <char-0x02071>               " ⁱ          : SUPERSCRIPT LATIN SMALL LETTER I
\\^i<Tab>                           <char-0x02071>               " ⁱ          : SUPERSCRIPT LATIN SMALL LETTER I
\\^io                               \\^io                        "            : (Incomplete sequence)
\\^iot                              \\^iot                       "            : (Incomplete sequence)
\\^iota                             <char-0x01DA5>               " ᶥ          : MODIFIER LETTER SMALL IOTA
\\^j                                <char-0x002B2>               " ʲ          : MODIFIER LETTER SMALL J
\\^k                                <char-0x01D4F>               " ᵏ          : MODIFIER LETTER SMALL K
\\^l                                <char-0x002E1>               " ˡ          : MODIFIER LETTER SMALL L
\\^m                                <char-0x01D50>               " ᵐ          : MODIFIER LETTER SMALL M
\\^n                                <char-0x0207F>               " ⁿ          : SUPERSCRIPT LATIN SMALL LETTER N
\\^o                                <char-0x01D52>               " ᵒ          : MODIFIER LETTER SMALL O
\\^p                                <char-0x01D56>               " ᵖ          : MODIFIER LETTER SMALL P
\\^p<Tab>                           <char-0x01D56>               " ᵖ          : MODIFIER LETTER SMALL P
\\^ph                               \\^ph                        "            : (Incomplete sequence)
\\^phi                              <char-0x01D60>               " ᵠ          : MODIFIER LETTER SMALL GREEK PHI
\\^r                                <char-0x002B3>               " ʳ          : MODIFIER LETTER SMALL R
\\^s                                <char-0x002E2>               " ˢ          : MODIFIER LETTER SMALL S
\\^t                                <char-0x01D57>               " ᵗ          : MODIFIER LETTER SMALL T
\\^t<Tab>                           <char-0x01D57>               " ᵗ          : MODIFIER LETTER SMALL T
\\^th                               \\^th                        "            : (Incomplete sequence)
\\^the                              \\^the                       "            : (Incomplete sequence)
\\^thet                             \\^thet                      "            : (Incomplete sequence)
\\^theta                            <char-0x01DBF>               " ᶿ          : MODIFIER LETTER SMALL THETA
\\^u                                <char-0x01D58>               " ᵘ          : MODIFIER LETTER SMALL U
\\^v                                <char-0x01D5B>               " ᵛ          : MODIFIER LETTER SMALL V
\\^w                                <char-0x002B7>               " ʷ          : MODIFIER LETTER SMALL W
\\^x                                <char-0x002E3>               " ˣ          : MODIFIER LETTER SMALL X
\\^y                                <char-0x002B8>               " ʸ          : MODIFIER LETTER SMALL Y
\\^z                                <char-0x01DBB>               " ᶻ          : MODIFIER LETTER SMALL Z
\\_(                                <char-0x0208D>               " ₍          : SUBSCRIPT LEFT PARENTHESIS / SUBSCRIPT OPENING PARENTHESIS
\\_)                                <char-0x0208E>               " ₎          : SUBSCRIPT RIGHT PARENTHESIS / SUBSCRIPT CLOSING PARENTHESIS
\\_+                                <char-0x0208A>               " ₊          : SUBSCRIPT PLUS SIGN
\\_-                                <char-0x0208B>               " ₋          : SUBSCRIPT MINUS / SUBSCRIPT HYPHEN-MINUS
\\_0                                <char-0x02080>               " ₀          : SUBSCRIPT ZERO / SUBSCRIPT DIGIT ZERO
\\_1                                <char-0x02081>               " ₁          : SUBSCRIPT ONE / SUBSCRIPT DIGIT ONE
\\_2                                <char-0x02082>               " ₂          : SUBSCRIPT TWO / SUBSCRIPT DIGIT TWO
\\_3                                <char-0x02083>               " ₃          : SUBSCRIPT THREE / SUBSCRIPT DIGIT THREE
\\_4                                <char-0x02084>               " ₄          : SUBSCRIPT FOUR / SUBSCRIPT DIGIT FOUR
\\_5                                <char-0x02085>               " ₅          : SUBSCRIPT FIVE / SUBSCRIPT DIGIT FIVE
\\_6                                <char-0x02086>               " ₆          : SUBSCRIPT SIX / SUBSCRIPT DIGIT SIX
\\_7                                <char-0x02087>               " ₇          : SUBSCRIPT SEVEN / SUBSCRIPT DIGIT SEVEN
\\_8                                <char-0x02088>               " ₈          : SUBSCRIPT EIGHT / SUBSCRIPT DIGIT EIGHT
\\_9                                <char-0x02089>               " ₉          : SUBSCRIPT NINE / SUBSCRIPT DIGIT NINE
\\_=                                <char-0x0208C>               " ₌          : SUBSCRIPT EQUALS SIGN
\\_a                                <char-0x02090>               " ₐ          : LATIN SUBSCRIPT SMALL LETTER A
\\_beta                             <char-0x01D66>               " ᵦ          : GREEK SUBSCRIPT SMALL LETTER BETA
\\_chi                              <char-0x01D6A>               " ᵪ          : GREEK SUBSCRIPT SMALL LETTER CHI
\\_e                                <char-0x02091>               " ₑ          : LATIN SUBSCRIPT SMALL LETTER E
\\_gamma                            <char-0x01D67>               " ᵧ          : GREEK SUBSCRIPT SMALL LETTER GAMMA
\\_h                                <char-0x02095>               " ₕ          : LATIN SUBSCRIPT SMALL LETTER H
\\_i                                <char-0x01D62>               " ᵢ          : LATIN SUBSCRIPT SMALL LETTER I
\\_j                                <char-0x02C7C>               " ⱼ          : LATIN SUBSCRIPT SMALL LETTER J
\\_k                                <char-0x02096>               " ₖ          : LATIN SUBSCRIPT SMALL LETTER K
\\_l                                <char-0x02097>               " ₗ          : LATIN SUBSCRIPT SMALL LETTER L
\\_m                                <char-0x02098>               " ₘ          : LATIN SUBSCRIPT SMALL LETTER M
\\_n                                <char-0x02099>               " ₙ          : LATIN SUBSCRIPT SMALL LETTER N
\\_o                                <char-0x02092>               " ₒ          : LATIN SUBSCRIPT SMALL LETTER O
\\_p                                <char-0x0209A>               " ₚ          : LATIN SUBSCRIPT SMALL LETTER P
\\_p<Tab>                           <char-0x0209A>               " ₚ          : LATIN SUBSCRIPT SMALL LETTER P
\\_ph                               \\_ph                        "            : (Incomplete sequence)
\\_phi                              <char-0x01D69>               " ᵩ          : GREEK SUBSCRIPT SMALL LETTER PHI
\\_r                                <char-0x01D63>               " ᵣ          : LATIN SUBSCRIPT SMALL LETTER R
\\_r<Tab>                           <char-0x01D63>               " ᵣ          : LATIN SUBSCRIPT SMALL LETTER R
\\_rh                               \\_rh                        "            : (Incomplete sequence)
\\_rho                              <char-0x01D68>               " ᵨ          : GREEK SUBSCRIPT SMALL LETTER RHO
\\_s                                <char-0x0209B>               " ₛ          : LATIN SUBSCRIPT SMALL LETTER S
\\_s<Tab>                           <char-0x0209B>               " ₛ          : LATIN SUBSCRIPT SMALL LETTER S
\\_sc                               \\_sc                        "            : (Incomplete sequence)
\\_sch                              \\_sch                       "            : (Incomplete sequence)
\\_schw                             \\_schw                      "            : (Incomplete sequence)
\\_schwa                            <char-0x02094>               " ₔ          : LATIN SUBSCRIPT SMALL LETTER SCHWA
\\_t                                <char-0x0209C>               " ₜ          : LATIN SUBSCRIPT SMALL LETTER T
\\_u                                <char-0x01D64>               " ᵤ          : LATIN SUBSCRIPT SMALL LETTER U
\\_v                                <char-0x01D65>               " ᵥ          : LATIN SUBSCRIPT SMALL LETTER V
\\_x                                <char-0x02093>               " ₓ          : LATIN SUBSCRIPT SMALL LETTER X
\\aa                                <char-0x000E5>               " å          : LATIN SMALL LETTER A WITH RING ABOVE / LATIN SMALL LETTER A RING
\\accurrent                         <char-0x023E6>               " ⏦          : AC CURRENT
\\acidfree                          <char-0x0267E>               " ♾          : PERMANENT PAPER SIGN
\\acute                             <char-0x00301>               " ◌́         : COMBINING ACUTE ACCENT / NON-SPACING ACUTE
\\adots                             <char-0x022F0>               " ⋰          : UP RIGHT DIAGONAL ELLIPSIS
\\ae                                <char-0x000E6>               " æ          : LATIN SMALL LETTER AE / LATIN SMALL LETTER A E
\\aleph                             <char-0x02135>               " ℵ          : ALEF SYMBOL / FIRST TRANSFINITE CARDINAL
\\allequal                          <char-0x0224C>               " ≌          : ALL EQUAL TO
\\alpha                             <char-0x003B1>               " α          : GREEK SMALL LETTER ALPHA
\\amalg                             <char-0x02A3F>               " ⨿          : AMALGAMATION OR COPRODUCT
\\angdnr                            <char-0x0299F>               " ⦟          : ACUTE ANGLE
\\angle                             <char-0x02220>               " ∠          : ANGLE
\\angle<Tab>                        <char-0x02220>               " ∠          : ANGLE
\\angles                            <char-0x0299E>               " ⦞          : ANGLE WITH S INSIDE
\\angleu                            \\angleu                     "            : (Incomplete sequence)
\\angleub                           \\angleub                    "            : (Incomplete sequence)
\\angleuba                          \\angleuba                   "            : (Incomplete sequence)
\\angleubar                         <char-0x029A4>               " ⦤          : ANGLE WITH UNDERBAR
\\annuity                           <char-0x020E7>               " ◌⃧         : COMBINING ANNUITY SYMBOL
\\approx                            <char-0x02248>               " ≈          : ALMOST EQUAL TO
\\approx<Tab>                       <char-0x02248>               " ≈          : ALMOST EQUAL TO
\\approxe                           \\approxe                    "            : (Incomplete sequence)
\\approxeq                          <char-0x0224A>               " ≊          : ALMOST EQUAL OR EQUAL TO
\\approxeq<Tab>                     <char-0x0224A>               " ≊          : ALMOST EQUAL OR EQUAL TO
\\approxeqq                         <char-0x02A70>               " ⩰          : APPROXIMATELY EQUAL OR EQUAL TO
\\approxn                           \\approxn                    "            : (Incomplete sequence)
\\approxno                          \\approxno                   "            : (Incomplete sequence)
\\approxnot                         \\approxnot                  "            : (Incomplete sequence)
\\approxnote                        \\approxnote                 "            : (Incomplete sequence)
\\approxnoteq                       \\approxnoteq                "            : (Incomplete sequence)
\\approxnotequ                      \\approxnotequ               "            : (Incomplete sequence)
\\approxnotequa                     \\approxnotequa              "            : (Incomplete sequence)
\\approxnotequal                    <char-0x02246>               " ≆          : APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
\\aquarius                          <char-0x02652>               " ♒          : AQUARIUS
\\arceq                             <char-0x02258>               " ≘          : CORRESPONDS TO
\\aries                             <char-0x02648>               " ♈          : ARIES
\\ast                               <char-0x02217>               " ∗          : ASTERISK OPERATOR
\\ast<Tab>                          <char-0x02217>               " ∗          : ASTERISK OPERATOR
\\aste                              \\aste                       "            : (Incomplete sequence)
\\asteq                             <char-0x02A6E>               " ⩮          : EQUALS WITH ASTERISK
\\aster                             \\aster                      "            : (Incomplete sequence)
\\astera                            \\astera                     "            : (Incomplete sequence)
\\asterac                           \\asterac                    "            : (Incomplete sequence)
\\asteracc                          \\asteracc                   "            : (Incomplete sequence)
\\asteracce                         \\asteracce                  "            : (Incomplete sequence)
\\asteraccen                        \\asteraccen                 "            : (Incomplete sequence)
\\asteraccent                       <char-0x020F0>               " ◌⃰         : COMBINING ASTERISK ABOVE
\\astr                              \\astr                       "            : (Incomplete sequence)
\\astro                             \\astro                      "            : (Incomplete sequence)
\\astros                            \\astros                     "            : (Incomplete sequence)
\\astrosu                           \\astrosu                    "            : (Incomplete sequence)
\\astrosun                          <char-0x02609>               " ☉          : SUN
\\asymp                             <char-0x0224D>               " ≍          : EQUIVALENT TO
\\awint                             <char-0x02A11>               " ⨑          : ANTICLOCKWISE INTEGRATION
\\backepsilon                       <char-0x003F6>               " ϶          : GREEK REVERSED LUNATE EPSILON SYMBOL
\\backppprime                       <char-0x02037>               " ‷          : REVERSED TRIPLE PRIME
\\backpprime                        <char-0x02036>               " ‶          : REVERSED DOUBLE PRIME
\\backprime                         <char-0x02035>               " ‵          : REVERSED PRIME
\\backsim                           <char-0x0223D>               " ∽          : REVERSED TILDE
\\backsim<Tab>                      <char-0x0223D>               " ∽          : REVERSED TILDE
\\backsime                          \\backsime                   "            : (Incomplete sequence)
\\backsimeq                         <char-0x022CD>               " ⋍          : REVERSED TILDE EQUALS
\\bagmember                         <char-0x022FF>               " ⋿          : Z NOTATION BAG MEMBERSHIP
\\bar                               <char-0x00304>               " ◌̄         : COMBINING MACRON / NON-SPACING MACRON
\\bar<Tab>                          <char-0x00304>               " ◌̄         : COMBINING MACRON / NON-SPACING MACRON
\\barc                              \\barc                       "            : (Incomplete sequence)
\\barca                             \\barca                      "            : (Incomplete sequence)
\\barcap                            <char-0x02A43>               " ⩃          : INTERSECTION WITH OVERBAR
\\barcu                             \\barcu                      "            : (Incomplete sequence)
\\barcup                            <char-0x02A42>               " ⩂          : UNION WITH OVERBAR
\\barl                              \\barl                       "            : (Incomplete sequence)
\\barle                             \\barle                      "            : (Incomplete sequence)
\\barlef                            \\barlef                     "            : (Incomplete sequence)
\\barleft                           \\barleft                    "            : (Incomplete sequence)
\\barlefta                          \\barlefta                   "            : (Incomplete sequence)
\\barleftar                         \\barleftar                  "            : (Incomplete sequence)
\\barleftarr                        \\barleftarr                 "            : (Incomplete sequence)
\\barleftarro                       \\barleftarro                "            : (Incomplete sequence)
\\barleftarrow                      <char-0x021E4>               " ⇤          : LEFTWARDS ARROW TO BAR / LEFT ARROW TO BAR
\\barleftarrow<Tab>                 <char-0x021E4>               " ⇤          : LEFTWARDS ARROW TO BAR / LEFT ARROW TO BAR
\\barleftarrowr                     \\barleftarrowr              "            : (Incomplete sequence)
\\barleftarrowri                    \\barleftarrowri             "            : (Incomplete sequence)
\\barleftarrowrig                   \\barleftarrowrig            "            : (Incomplete sequence)
\\barleftarrowrigh                  \\barleftarrowrigh           "            : (Incomplete sequence)
\\barleftarrowright                 \\barleftarrowright          "            : (Incomplete sequence)
\\barleftarrowrighta                \\barleftarrowrighta         "            : (Incomplete sequence)
\\barleftarrowrightar               \\barleftarrowrightar        "            : (Incomplete sequence)
\\barleftarrowrightarr              \\barleftarrowrightarr       "            : (Incomplete sequence)
\\barleftarrowrightarro             \\barleftarrowrightarro      "            : (Incomplete sequence)
\\barleftarrowrightarrow            \\barleftarrowrightarrow     "            : (Incomplete sequence)
\\barleftarrowrightarrowb           \\barleftarrowrightarrowb    "            : (Incomplete sequence)
\\barleftarrowrightarrowba          \\barleftarrowrightarrowba   "            : (Incomplete sequence)
\\barleftarrowrightarrowbar         <char-0x021B9>               " ↹          : LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR / LEFT ARROW TO BAR OVER RIGHT ARROW TO BAR
\\baro                              \\baro                       "            : (Incomplete sequence)
\\barov                             \\barov                      "            : (Incomplete sequence)
\\barove                            \\barove                     "            : (Incomplete sequence)
\\barover                           \\barover                    "            : (Incomplete sequence)
\\barovern                          \\barovern                   "            : (Incomplete sequence)
\\baroverno                         \\baroverno                  "            : (Incomplete sequence)
\\barovernor                        \\barovernor                 "            : (Incomplete sequence)
\\barovernort                       \\barovernort                "            : (Incomplete sequence)
\\barovernorth                      \\barovernorth               "            : (Incomplete sequence)
\\barovernorthw                     \\barovernorthw              "            : (Incomplete sequence)
\\barovernorthwe                    \\barovernorthwe             "            : (Incomplete sequence)
\\barovernorthwes                   \\barovernorthwes            "            : (Incomplete sequence)
\\barovernorthwest                  \\barovernorthwest           "            : (Incomplete sequence)
\\barovernorthwesta                 \\barovernorthwesta          "            : (Incomplete sequence)
\\barovernorthwestar                \\barovernorthwestar         "            : (Incomplete sequence)
\\barovernorthwestarr               \\barovernorthwestarr        "            : (Incomplete sequence)
\\barovernorthwestarro              \\barovernorthwestarro       "            : (Incomplete sequence)
\\barovernorthwestarrow             <char-0x021B8>               " ↸          : NORTH WEST ARROW TO LONG BAR / UPPER LEFT ARROW TO LONG BAR
\\barr                              \\barr                       "            : (Incomplete sequence)
\\barri                             \\barri                      "            : (Incomplete sequence)
\\barrig                            \\barrig                     "            : (Incomplete sequence)
\\barrigh                           \\barrigh                    "            : (Incomplete sequence)
\\barright                          \\barright                   "            : (Incomplete sequence)
\\barrighta                         \\barrighta                  "            : (Incomplete sequence)
\\barrightar                        \\barrightar                 "            : (Incomplete sequence)
\\barrightarr                       \\barrightarr                "            : (Incomplete sequence)
\\barrightarro                      \\barrightarro               "            : (Incomplete sequence)
\\barrightarrow                     \\barrightarrow              "            : (Incomplete sequence)
\\barrightarrowd                    \\barrightarrowd             "            : (Incomplete sequence)
\\barrightarrowdi                   \\barrightarrowdi            "            : (Incomplete sequence)
\\barrightarrowdia                  \\barrightarrowdia           "            : (Incomplete sequence)
\\barrightarrowdiam                 \\barrightarrowdiam          "            : (Incomplete sequence)
\\barrightarrowdiamo                \\barrightarrowdiamo         "            : (Incomplete sequence)
\\barrightarrowdiamon               \\barrightarrowdiamon        "            : (Incomplete sequence)
\\barrightarrowdiamond              <char-0x02920>               " ⤠          : RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
\\barv                              \\barv                       "            : (Incomplete sequence)
\\barve                             \\barve                      "            : (Incomplete sequence)
\\barvee                            <char-0x022BD>               " ⊽          : NOR
\\barw                              \\barw                       "            : (Incomplete sequence)
\\barwe                             \\barwe                      "            : (Incomplete sequence)
\\barwed                            \\barwed                     "            : (Incomplete sequence)
\\barwedg                           \\barwedg                    "            : (Incomplete sequence)
\\barwedge                          <char-0x022BC>               " ⊼          : NAND
\\bbA                               <char-0x1D538>               " 𝔸          : MATHEMATICAL DOUBLE-STRUCK CAPITAL A
\\bbB                               <char-0x1D539>               " 𝔹          : MATHEMATICAL DOUBLE-STRUCK CAPITAL B
\\bbC                               <char-0x02102>               " ℂ          : DOUBLE-STRUCK CAPITAL C / DOUBLE-STRUCK C
\\bbD                               <char-0x1D53B>               " 𝔻          : MATHEMATICAL DOUBLE-STRUCK CAPITAL D
\\bbE                               <char-0x1D53C>               " 𝔼          : MATHEMATICAL DOUBLE-STRUCK CAPITAL E
\\bbF                               <char-0x1D53D>               " 𝔽          : MATHEMATICAL DOUBLE-STRUCK CAPITAL F
\\bbG                               <char-0x1D53E>               " 𝔾          : MATHEMATICAL DOUBLE-STRUCK CAPITAL G
\\bbG<Tab>                          <char-0x1D53E>               " 𝔾          : MATHEMATICAL DOUBLE-STRUCK CAPITAL G
\\bbGa                              \\bbGa                       "            : (Incomplete sequence)
\\bbGam                             \\bbGam                      "            : (Incomplete sequence)
\\bbGamm                            \\bbGamm                     "            : (Incomplete sequence)
\\bbGamma                           <char-0x0213E>               " ℾ          : DOUBLE-STRUCK CAPITAL GAMMA
\\bbH                               <char-0x0210D>               " ℍ          : DOUBLE-STRUCK CAPITAL H / DOUBLE-STRUCK H
\\bbI                               <char-0x1D540>               " 𝕀          : MATHEMATICAL DOUBLE-STRUCK CAPITAL I
\\bbJ                               <char-0x1D541>               " 𝕁          : MATHEMATICAL DOUBLE-STRUCK CAPITAL J
\\bbK                               <char-0x1D542>               " 𝕂          : MATHEMATICAL DOUBLE-STRUCK CAPITAL K
\\bbL                               <char-0x1D543>               " 𝕃          : MATHEMATICAL DOUBLE-STRUCK CAPITAL L
\\bbM                               <char-0x1D544>               " 𝕄          : MATHEMATICAL DOUBLE-STRUCK CAPITAL M
\\bbN                               <char-0x02115>               " ℕ          : DOUBLE-STRUCK CAPITAL N / DOUBLE-STRUCK N
\\bbO                               <char-0x1D546>               " 𝕆          : MATHEMATICAL DOUBLE-STRUCK CAPITAL O
\\bbP                               <char-0x02119>               " ℙ          : DOUBLE-STRUCK CAPITAL P / DOUBLE-STRUCK P
\\bbP<Tab>                          <char-0x02119>               " ℙ          : DOUBLE-STRUCK CAPITAL P / DOUBLE-STRUCK P
\\bbPi                              <char-0x0213F>               " ℿ          : DOUBLE-STRUCK CAPITAL PI
\\bbQ                               <char-0x0211A>               " ℚ          : DOUBLE-STRUCK CAPITAL Q / DOUBLE-STRUCK Q
\\bbR                               <char-0x0211D>               " ℝ          : DOUBLE-STRUCK CAPITAL R / DOUBLE-STRUCK R
\\bbS                               <char-0x1D54A>               " 𝕊          : MATHEMATICAL DOUBLE-STRUCK CAPITAL S
\\bbT                               <char-0x1D54B>               " 𝕋          : MATHEMATICAL DOUBLE-STRUCK CAPITAL T
\\bbU                               <char-0x1D54C>               " 𝕌          : MATHEMATICAL DOUBLE-STRUCK CAPITAL U
\\bbV                               <char-0x1D54D>               " 𝕍          : MATHEMATICAL DOUBLE-STRUCK CAPITAL V
\\bbW                               <char-0x1D54E>               " 𝕎          : MATHEMATICAL DOUBLE-STRUCK CAPITAL W
\\bbX                               <char-0x1D54F>               " 𝕏          : MATHEMATICAL DOUBLE-STRUCK CAPITAL X
\\bbY                               <char-0x1D550>               " 𝕐          : MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
\\bbZ                               <char-0x02124>               " ℤ          : DOUBLE-STRUCK CAPITAL Z / DOUBLE-STRUCK Z
\\bba                               <char-0x1D552>               " 𝕒          : MATHEMATICAL DOUBLE-STRUCK SMALL A
\\bbb                               <char-0x1D553>               " 𝕓          : MATHEMATICAL DOUBLE-STRUCK SMALL B
\\bbc                               <char-0x1D554>               " 𝕔          : MATHEMATICAL DOUBLE-STRUCK SMALL C
\\bbd                               <char-0x1D555>               " 𝕕          : MATHEMATICAL DOUBLE-STRUCK SMALL D
\\bbe                               <char-0x1D556>               " 𝕖          : MATHEMATICAL DOUBLE-STRUCK SMALL E
\\bbe<Tab>                          <char-0x1D556>               " 𝕖          : MATHEMATICAL DOUBLE-STRUCK SMALL E
\\bbei                              \\bbei                       "            : (Incomplete sequence)
\\bbeig                             \\bbeig                      "            : (Incomplete sequence)
\\bbeigh                            \\bbeigh                     "            : (Incomplete sequence)
\\bbeight                           <char-0x1D7E0>               " 𝟠          : MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT
\\bbf                               <char-0x1D557>               " 𝕗          : MATHEMATICAL DOUBLE-STRUCK SMALL F
\\bbf<Tab>                          <char-0x1D557>               " 𝕗          : MATHEMATICAL DOUBLE-STRUCK SMALL F
\\bbfi                              \\bbfi                       "            : (Incomplete sequence)
\\bbfiv                             \\bbfiv                      "            : (Incomplete sequence)
\\bbfive                            <char-0x1D7DD>               " 𝟝          : MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE
\\bbfo                              \\bbfo                       "            : (Incomplete sequence)
\\bbfou                             \\bbfou                      "            : (Incomplete sequence)
\\bbfour                            <char-0x1D7DC>               " 𝟜          : MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR
\\bbg                               <char-0x1D558>               " 𝕘          : MATHEMATICAL DOUBLE-STRUCK SMALL G
\\bbg<Tab>                          <char-0x1D558>               " 𝕘          : MATHEMATICAL DOUBLE-STRUCK SMALL G
\\bbga                              \\bbga                       "            : (Incomplete sequence)
\\bbgam                             \\bbgam                      "            : (Incomplete sequence)
\\bbgamm                            \\bbgamm                     "            : (Incomplete sequence)
\\bbgamma                           <char-0x0213D>               " ℽ          : DOUBLE-STRUCK SMALL GAMMA
\\bbh                               <char-0x1D559>               " 𝕙          : MATHEMATICAL DOUBLE-STRUCK SMALL H
\\bbi                               <char-0x1D55A>               " 𝕚          : MATHEMATICAL DOUBLE-STRUCK SMALL I
\\bbi<Tab>                          <char-0x1D55A>               " 𝕚          : MATHEMATICAL DOUBLE-STRUCK SMALL I
\\bbiD                              <char-0x02145>               " ⅅ          : DOUBLE-STRUCK ITALIC CAPITAL D
\\bbid                              <char-0x02146>               " ⅆ          : DOUBLE-STRUCK ITALIC SMALL D
\\bbie                              <char-0x02147>               " ⅇ          : DOUBLE-STRUCK ITALIC SMALL E
\\bbii                              <char-0x02148>               " ⅈ          : DOUBLE-STRUCK ITALIC SMALL I
\\bbij                              <char-0x02149>               " ⅉ          : DOUBLE-STRUCK ITALIC SMALL J
\\bbj                               <char-0x1D55B>               " 𝕛          : MATHEMATICAL DOUBLE-STRUCK SMALL J
\\bbk                               <char-0x1D55C>               " 𝕜          : MATHEMATICAL DOUBLE-STRUCK SMALL K
\\bbl                               <char-0x1D55D>               " 𝕝          : MATHEMATICAL DOUBLE-STRUCK SMALL L
\\bbm                               <char-0x1D55E>               " 𝕞          : MATHEMATICAL DOUBLE-STRUCK SMALL M
\\bbn                               <char-0x1D55F>               " 𝕟          : MATHEMATICAL DOUBLE-STRUCK SMALL N
\\bbn<Tab>                          <char-0x1D55F>               " 𝕟          : MATHEMATICAL DOUBLE-STRUCK SMALL N
\\bbni                              \\bbni                       "            : (Incomplete sequence)
\\bbnin                             \\bbnin                      "            : (Incomplete sequence)
\\bbnine                            <char-0x1D7E1>               " 𝟡          : MATHEMATICAL DOUBLE-STRUCK DIGIT NINE
\\bbo                               <char-0x1D560>               " 𝕠          : MATHEMATICAL DOUBLE-STRUCK SMALL O
\\bbo<Tab>                          <char-0x1D560>               " 𝕠          : MATHEMATICAL DOUBLE-STRUCK SMALL O
\\bbon                              \\bbon                       "            : (Incomplete sequence)
\\bbone                             <char-0x1D7D9>               " 𝟙          : MATHEMATICAL DOUBLE-STRUCK DIGIT ONE
\\bbp                               <char-0x1D561>               " 𝕡          : MATHEMATICAL DOUBLE-STRUCK SMALL P
\\bbp<Tab>                          <char-0x1D561>               " 𝕡          : MATHEMATICAL DOUBLE-STRUCK SMALL P
\\bbpi                              <char-0x0213C>               " ℼ          : DOUBLE-STRUCK SMALL PI
\\bbq                               <char-0x1D562>               " 𝕢          : MATHEMATICAL DOUBLE-STRUCK SMALL Q
\\bbr                               <char-0x1D563>               " 𝕣          : MATHEMATICAL DOUBLE-STRUCK SMALL R
\\bbr<Tab>                          <char-0x1D563>               " 𝕣          : MATHEMATICAL DOUBLE-STRUCK SMALL R
\\bbrk                              \\bbrk                       "            : (Incomplete sequence)
\\bbrkt                             \\bbrkt                      "            : (Incomplete sequence)
\\bbrktb                            \\bbrktb                     "            : (Incomplete sequence)
\\bbrktbr                           \\bbrktbr                    "            : (Incomplete sequence)
\\bbrktbrk                          <char-0x023B6>               " ⎶          : BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
\\bbs                               <char-0x1D564>               " 𝕤          : MATHEMATICAL DOUBLE-STRUCK SMALL S
\\bbs<Tab>                          <char-0x1D564>               " 𝕤          : MATHEMATICAL DOUBLE-STRUCK SMALL S
\\bbse                              \\bbse                       "            : (Incomplete sequence)
\\bbsev                             \\bbsev                      "            : (Incomplete sequence)
\\bbseve                            \\bbseve                     "            : (Incomplete sequence)
\\bbseven                           <char-0x1D7DF>               " 𝟟          : MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN
\\bbsi                              \\bbsi                       "            : (Incomplete sequence)
\\bbsix                             <char-0x1D7DE>               " 𝟞          : MATHEMATICAL DOUBLE-STRUCK DIGIT SIX
\\bbsu                              \\bbsu                       "            : (Incomplete sequence)
\\bbsum                             <char-0x02140>               " ⅀          : DOUBLE-STRUCK N-ARY SUMMATION
\\bbt                               <char-0x1D565>               " 𝕥          : MATHEMATICAL DOUBLE-STRUCK SMALL T
\\bbt<Tab>                          <char-0x1D565>               " 𝕥          : MATHEMATICAL DOUBLE-STRUCK SMALL T
\\bbth                              \\bbth                       "            : (Incomplete sequence)
\\bbthr                             \\bbthr                      "            : (Incomplete sequence)
\\bbthre                            \\bbthre                     "            : (Incomplete sequence)
\\bbthree                           <char-0x1D7DB>               " 𝟛          : MATHEMATICAL DOUBLE-STRUCK DIGIT THREE
\\bbtw                              \\bbtw                       "            : (Incomplete sequence)
\\bbtwo                             <char-0x1D7DA>               " 𝟚          : MATHEMATICAL DOUBLE-STRUCK DIGIT TWO
\\bbu                               <char-0x1D566>               " 𝕦          : MATHEMATICAL DOUBLE-STRUCK SMALL U
\\bbv                               <char-0x1D567>               " 𝕧          : MATHEMATICAL DOUBLE-STRUCK SMALL V
\\bbw                               <char-0x1D568>               " 𝕨          : MATHEMATICAL DOUBLE-STRUCK SMALL W
\\bbx                               <char-0x1D569>               " 𝕩          : MATHEMATICAL DOUBLE-STRUCK SMALL X
\\bby                               <char-0x1D56A>               " 𝕪          : MATHEMATICAL DOUBLE-STRUCK SMALL Y
\\bbz                               <char-0x1D56B>               " 𝕫          : MATHEMATICAL DOUBLE-STRUCK SMALL Z
\\bbz<Tab>                          <char-0x1D56B>               " 𝕫          : MATHEMATICAL DOUBLE-STRUCK SMALL Z
\\bbze                              \\bbze                       "            : (Incomplete sequence)
\\bbzer                             \\bbzer                      "            : (Incomplete sequence)
\\bbzero                            <char-0x1D7D8>               " 𝟘          : MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO
\\because                           <char-0x02235>               " ∵          : BECAUSE
\\benzenr                           <char-0x023E3>               " ⏣          : BENZENE RING WITH CIRCLE
\\beta                              <char-0x003B2>               " β          : GREEK SMALL LETTER BETA
\\beth                              <char-0x02136>               " ℶ          : BET SYMBOL / SECOND TRANSFINITE CARDINAL
\\between                           <char-0x0226C>               " ≬          : BETWEEN
\\bfA                               <char-0x1D400>               " 𝐀          : MATHEMATICAL BOLD CAPITAL A
\\bfA<Tab>                          <char-0x1D400>               " 𝐀          : MATHEMATICAL BOLD CAPITAL A
\\bfAl                              \\bfAl                       "            : (Incomplete sequence)
\\bfAlp                             \\bfAlp                      "            : (Incomplete sequence)
\\bfAlph                            \\bfAlph                     "            : (Incomplete sequence)
\\bfAlpha                           <char-0x1D6A8>               " 𝚨          : MATHEMATICAL BOLD CAPITAL ALPHA
\\bfB                               <char-0x1D401>               " 𝐁          : MATHEMATICAL BOLD CAPITAL B
\\bfB<Tab>                          <char-0x1D401>               " 𝐁          : MATHEMATICAL BOLD CAPITAL B
\\bfBe                              \\bfBe                       "            : (Incomplete sequence)
\\bfBet                             \\bfBet                      "            : (Incomplete sequence)
\\bfBeta                            <char-0x1D6A9>               " 𝚩          : MATHEMATICAL BOLD CAPITAL BETA
\\bfC                               <char-0x1D402>               " 𝐂          : MATHEMATICAL BOLD CAPITAL C
\\bfC<Tab>                          <char-0x1D402>               " 𝐂          : MATHEMATICAL BOLD CAPITAL C
\\bfCh                              \\bfCh                       "            : (Incomplete sequence)
\\bfChi                             <char-0x1D6BE>               " 𝚾          : MATHEMATICAL BOLD CAPITAL CHI
\\bfD                               <char-0x1D403>               " 𝐃          : MATHEMATICAL BOLD CAPITAL D
\\bfD<Tab>                          <char-0x1D403>               " 𝐃          : MATHEMATICAL BOLD CAPITAL D
\\bfDe                              \\bfDe                       "            : (Incomplete sequence)
\\bfDel                             \\bfDel                      "            : (Incomplete sequence)
\\bfDelt                            \\bfDelt                     "            : (Incomplete sequence)
\\bfDelta                           <char-0x1D6AB>               " 𝚫          : MATHEMATICAL BOLD CAPITAL DELTA
\\bfDi                              \\bfDi                       "            : (Incomplete sequence)
\\bfDig                             \\bfDig                      "            : (Incomplete sequence)
\\bfDiga                            \\bfDiga                     "            : (Incomplete sequence)
\\bfDigam                           \\bfDigam                    "            : (Incomplete sequence)
\\bfDigamm                          \\bfDigamm                   "            : (Incomplete sequence)
\\bfDigamma                         <char-0x1D7CA>               " 𝟊          : MATHEMATICAL BOLD CAPITAL DIGAMMA
\\bfE                               <char-0x1D404>               " 𝐄          : MATHEMATICAL BOLD CAPITAL E
\\bfE<Tab>                          <char-0x1D404>               " 𝐄          : MATHEMATICAL BOLD CAPITAL E
\\bfEp                              \\bfEp                       "            : (Incomplete sequence)
\\bfEps                             \\bfEps                      "            : (Incomplete sequence)
\\bfEpsi                            \\bfEpsi                     "            : (Incomplete sequence)
\\bfEpsil                           \\bfEpsil                    "            : (Incomplete sequence)
\\bfEpsilo                          \\bfEpsilo                   "            : (Incomplete sequence)
\\bfEpsilon                         <char-0x1D6AC>               " 𝚬          : MATHEMATICAL BOLD CAPITAL EPSILON
\\bfEt                              \\bfEt                       "            : (Incomplete sequence)
\\bfEta                             <char-0x1D6AE>               " 𝚮          : MATHEMATICAL BOLD CAPITAL ETA
\\bfF                               <char-0x1D405>               " 𝐅          : MATHEMATICAL BOLD CAPITAL F
\\bfG                               <char-0x1D406>               " 𝐆          : MATHEMATICAL BOLD CAPITAL G
\\bfG<Tab>                          <char-0x1D406>               " 𝐆          : MATHEMATICAL BOLD CAPITAL G
\\bfGa                              \\bfGa                       "            : (Incomplete sequence)
\\bfGam                             \\bfGam                      "            : (Incomplete sequence)
\\bfGamm                            \\bfGamm                     "            : (Incomplete sequence)
\\bfGamma                           <char-0x1D6AA>               " 𝚪          : MATHEMATICAL BOLD CAPITAL GAMMA
\\bfH                               <char-0x1D407>               " 𝐇          : MATHEMATICAL BOLD CAPITAL H
\\bfI                               <char-0x1D408>               " 𝐈          : MATHEMATICAL BOLD CAPITAL I
\\bfI<Tab>                          <char-0x1D408>               " 𝐈          : MATHEMATICAL BOLD CAPITAL I
\\bfIo                              \\bfIo                       "            : (Incomplete sequence)
\\bfIot                             \\bfIot                      "            : (Incomplete sequence)
\\bfIota                            <char-0x1D6B0>               " 𝚰          : MATHEMATICAL BOLD CAPITAL IOTA
\\bfJ                               <char-0x1D409>               " 𝐉          : MATHEMATICAL BOLD CAPITAL J
\\bfK                               <char-0x1D40A>               " 𝐊          : MATHEMATICAL BOLD CAPITAL K
\\bfK<Tab>                          <char-0x1D40A>               " 𝐊          : MATHEMATICAL BOLD CAPITAL K
\\bfKa                              \\bfKa                       "            : (Incomplete sequence)
\\bfKap                             \\bfKap                      "            : (Incomplete sequence)
\\bfKapp                            \\bfKapp                     "            : (Incomplete sequence)
\\bfKappa                           <char-0x1D6B1>               " 𝚱          : MATHEMATICAL BOLD CAPITAL KAPPA
\\bfL                               <char-0x1D40B>               " 𝐋          : MATHEMATICAL BOLD CAPITAL L
\\bfL<Tab>                          <char-0x1D40B>               " 𝐋          : MATHEMATICAL BOLD CAPITAL L
\\bfLa                              \\bfLa                       "            : (Incomplete sequence)
\\bfLam                             \\bfLam                      "            : (Incomplete sequence)
\\bfLamb                            \\bfLamb                     "            : (Incomplete sequence)
\\bfLambd                           \\bfLambd                    "            : (Incomplete sequence)
\\bfLambda                          <char-0x1D6B2>               " 𝚲          : MATHEMATICAL BOLD CAPITAL LAMDA
\\bfM                               <char-0x1D40C>               " 𝐌          : MATHEMATICAL BOLD CAPITAL M
\\bfM<Tab>                          <char-0x1D40C>               " 𝐌          : MATHEMATICAL BOLD CAPITAL M
\\bfMu                              <char-0x1D6B3>               " 𝚳          : MATHEMATICAL BOLD CAPITAL MU
\\bfN                               <char-0x1D40D>               " 𝐍          : MATHEMATICAL BOLD CAPITAL N
\\bfN<Tab>                          <char-0x1D40D>               " 𝐍          : MATHEMATICAL BOLD CAPITAL N
\\bfNu                              <char-0x1D6B4>               " 𝚴          : MATHEMATICAL BOLD CAPITAL NU
\\bfO                               <char-0x1D40E>               " 𝐎          : MATHEMATICAL BOLD CAPITAL O
\\bfO<Tab>                          <char-0x1D40E>               " 𝐎          : MATHEMATICAL BOLD CAPITAL O
\\bfOm                              \\bfOm                       "            : (Incomplete sequence)
\\bfOme                             \\bfOme                      "            : (Incomplete sequence)
\\bfOmeg                            \\bfOmeg                     "            : (Incomplete sequence)
\\bfOmega                           <char-0x1D6C0>               " 𝛀          : MATHEMATICAL BOLD CAPITAL OMEGA
\\bfOmi                             \\bfOmi                      "            : (Incomplete sequence)
\\bfOmic                            \\bfOmic                     "            : (Incomplete sequence)
\\bfOmicr                           \\bfOmicr                    "            : (Incomplete sequence)
\\bfOmicro                          \\bfOmicro                   "            : (Incomplete sequence)
\\bfOmicron                         <char-0x1D6B6>               " 𝚶          : MATHEMATICAL BOLD CAPITAL OMICRON
\\bfP                               <char-0x1D40F>               " 𝐏          : MATHEMATICAL BOLD CAPITAL P
\\bfP<Tab>                          <char-0x1D40F>               " 𝐏          : MATHEMATICAL BOLD CAPITAL P
\\bfPh                              \\bfPh                       "            : (Incomplete sequence)
\\bfPhi                             <char-0x1D6BD>               " 𝚽          : MATHEMATICAL BOLD CAPITAL PHI
\\bfPi                              <char-0x1D6B7>               " 𝚷          : MATHEMATICAL BOLD CAPITAL PI
\\bfPs                              \\bfPs                       "            : (Incomplete sequence)
\\bfPsi                             <char-0x1D6BF>               " 𝚿          : MATHEMATICAL BOLD CAPITAL PSI
\\bfQ                               <char-0x1D410>               " 𝐐          : MATHEMATICAL BOLD CAPITAL Q
\\bfR                               <char-0x1D411>               " 𝐑          : MATHEMATICAL BOLD CAPITAL R
\\bfR<Tab>                          <char-0x1D411>               " 𝐑          : MATHEMATICAL BOLD CAPITAL R
\\bfRh                              \\bfRh                       "            : (Incomplete sequence)
\\bfRho                             <char-0x1D6B8>               " 𝚸          : MATHEMATICAL BOLD CAPITAL RHO
\\bfS                               <char-0x1D412>               " 𝐒          : MATHEMATICAL BOLD CAPITAL S
\\bfS<Tab>                          <char-0x1D412>               " 𝐒          : MATHEMATICAL BOLD CAPITAL S
\\bfSi                              \\bfSi                       "            : (Incomplete sequence)
\\bfSig                             \\bfSig                      "            : (Incomplete sequence)
\\bfSigm                            \\bfSigm                     "            : (Incomplete sequence)
\\bfSigma                           <char-0x1D6BA>               " 𝚺          : MATHEMATICAL BOLD CAPITAL SIGMA
\\bfT                               <char-0x1D413>               " 𝐓          : MATHEMATICAL BOLD CAPITAL T
\\bfT<Tab>                          <char-0x1D413>               " 𝐓          : MATHEMATICAL BOLD CAPITAL T
\\bfTa                              \\bfTa                       "            : (Incomplete sequence)
\\bfTau                             <char-0x1D6BB>               " 𝚻          : MATHEMATICAL BOLD CAPITAL TAU
\\bfTh                              \\bfTh                       "            : (Incomplete sequence)
\\bfThe                             \\bfThe                      "            : (Incomplete sequence)
\\bfThet                            \\bfThet                     "            : (Incomplete sequence)
\\bfTheta                           <char-0x1D6AF>               " 𝚯          : MATHEMATICAL BOLD CAPITAL THETA
\\bfU                               <char-0x1D414>               " 𝐔          : MATHEMATICAL BOLD CAPITAL U
\\bfU<Tab>                          <char-0x1D414>               " 𝐔          : MATHEMATICAL BOLD CAPITAL U
\\bfUp                              \\bfUp                       "            : (Incomplete sequence)
\\bfUps                             \\bfUps                      "            : (Incomplete sequence)
\\bfUpsi                            \\bfUpsi                     "            : (Incomplete sequence)
\\bfUpsil                           \\bfUpsil                    "            : (Incomplete sequence)
\\bfUpsilo                          \\bfUpsilo                   "            : (Incomplete sequence)
\\bfUpsilon                         <char-0x1D6BC>               " 𝚼          : MATHEMATICAL BOLD CAPITAL UPSILON
\\bfV                               <char-0x1D415>               " 𝐕          : MATHEMATICAL BOLD CAPITAL V
\\bfW                               <char-0x1D416>               " 𝐖          : MATHEMATICAL BOLD CAPITAL W
\\bfX                               <char-0x1D417>               " 𝐗          : MATHEMATICAL BOLD CAPITAL X
\\bfX<Tab>                          <char-0x1D417>               " 𝐗          : MATHEMATICAL BOLD CAPITAL X
\\bfXi                              <char-0x1D6B5>               " 𝚵          : MATHEMATICAL BOLD CAPITAL XI
\\bfY                               <char-0x1D418>               " 𝐘          : MATHEMATICAL BOLD CAPITAL Y
\\bfZ                               <char-0x1D419>               " 𝐙          : MATHEMATICAL BOLD CAPITAL Z
\\bfZ<Tab>                          <char-0x1D419>               " 𝐙          : MATHEMATICAL BOLD CAPITAL Z
\\bfZe                              \\bfZe                       "            : (Incomplete sequence)
\\bfZet                             \\bfZet                      "            : (Incomplete sequence)
\\bfZeta                            <char-0x1D6AD>               " 𝚭          : MATHEMATICAL BOLD CAPITAL ZETA
\\bfa                               <char-0x1D41A>               " 𝐚          : MATHEMATICAL BOLD SMALL A
\\bfa<Tab>                          <char-0x1D41A>               " 𝐚          : MATHEMATICAL BOLD SMALL A
\\bfal                              \\bfal                       "            : (Incomplete sequence)
\\bfalp                             \\bfalp                      "            : (Incomplete sequence)
\\bfalph                            \\bfalph                     "            : (Incomplete sequence)
\\bfalpha                           <char-0x1D6C2>               " 𝛂          : MATHEMATICAL BOLD SMALL ALPHA
\\bfb                               <char-0x1D41B>               " 𝐛          : MATHEMATICAL BOLD SMALL B
\\bfb<Tab>                          <char-0x1D41B>               " 𝐛          : MATHEMATICAL BOLD SMALL B
\\bfbe                              \\bfbe                       "            : (Incomplete sequence)
\\bfbet                             \\bfbet                      "            : (Incomplete sequence)
\\bfbeta                            <char-0x1D6C3>               " 𝛃          : MATHEMATICAL BOLD SMALL BETA
\\bfc                               <char-0x1D41C>               " 𝐜          : MATHEMATICAL BOLD SMALL C
\\bfc<Tab>                          <char-0x1D41C>               " 𝐜          : MATHEMATICAL BOLD SMALL C
\\bfch                              \\bfch                       "            : (Incomplete sequence)
\\bfchi                             <char-0x1D6D8>               " 𝛘          : MATHEMATICAL BOLD SMALL CHI
\\bfd                               <char-0x1D41D>               " 𝐝          : MATHEMATICAL BOLD SMALL D
\\bfd<Tab>                          <char-0x1D41D>               " 𝐝          : MATHEMATICAL BOLD SMALL D
\\bfde                              \\bfde                       "            : (Incomplete sequence)
\\bfdel                             \\bfdel                      "            : (Incomplete sequence)
\\bfdelt                            \\bfdelt                     "            : (Incomplete sequence)
\\bfdelta                           <char-0x1D6C5>               " 𝛅          : MATHEMATICAL BOLD SMALL DELTA
\\bfdi                              \\bfdi                       "            : (Incomplete sequence)
\\bfdig                             \\bfdig                      "            : (Incomplete sequence)
\\bfdiga                            \\bfdiga                     "            : (Incomplete sequence)
\\bfdigam                           \\bfdigam                    "            : (Incomplete sequence)
\\bfdigamm                          \\bfdigamm                   "            : (Incomplete sequence)
\\bfdigamma                         <char-0x1D7CB>               " 𝟋          : MATHEMATICAL BOLD SMALL DIGAMMA
\\bfe                               <char-0x1D41E>               " 𝐞          : MATHEMATICAL BOLD SMALL E
\\bfe<Tab>                          <char-0x1D41E>               " 𝐞          : MATHEMATICAL BOLD SMALL E
\\bfei                              \\bfei                       "            : (Incomplete sequence)
\\bfeig                             \\bfeig                      "            : (Incomplete sequence)
\\bfeigh                            \\bfeigh                     "            : (Incomplete sequence)
\\bfeight                           <char-0x1D7D6>               " 𝟖          : MATHEMATICAL BOLD DIGIT EIGHT
\\bfep                              \\bfep                       "            : (Incomplete sequence)
\\bfeps                             \\bfeps                      "            : (Incomplete sequence)
\\bfepsi                            \\bfepsi                     "            : (Incomplete sequence)
\\bfepsil                           \\bfepsil                    "            : (Incomplete sequence)
\\bfepsilo                          \\bfepsilo                   "            : (Incomplete sequence)
\\bfepsilon                         <char-0x1D6C6>               " 𝛆          : MATHEMATICAL BOLD SMALL EPSILON
\\bfet                              \\bfet                       "            : (Incomplete sequence)
\\bfeta                             <char-0x1D6C8>               " 𝛈          : MATHEMATICAL BOLD SMALL ETA
\\bff                               <char-0x1D41F>               " 𝐟          : MATHEMATICAL BOLD SMALL F
\\bff<Tab>                          <char-0x1D41F>               " 𝐟          : MATHEMATICAL BOLD SMALL F
\\bffi                              \\bffi                       "            : (Incomplete sequence)
\\bffiv                             \\bffiv                      "            : (Incomplete sequence)
\\bffive                            <char-0x1D7D3>               " 𝟓          : MATHEMATICAL BOLD DIGIT FIVE
\\bffo                              \\bffo                       "            : (Incomplete sequence)
\\bffou                             \\bffou                      "            : (Incomplete sequence)
\\bffour                            <char-0x1D7D2>               " 𝟒          : MATHEMATICAL BOLD DIGIT FOUR
\\bfg                               <char-0x1D420>               " 𝐠          : MATHEMATICAL BOLD SMALL G
\\bfg<Tab>                          <char-0x1D420>               " 𝐠          : MATHEMATICAL BOLD SMALL G
\\bfga                              \\bfga                       "            : (Incomplete sequence)
\\bfgam                             \\bfgam                      "            : (Incomplete sequence)
\\bfgamm                            \\bfgamm                     "            : (Incomplete sequence)
\\bfgamma                           <char-0x1D6C4>               " 𝛄          : MATHEMATICAL BOLD SMALL GAMMA
\\bfh                               <char-0x1D421>               " 𝐡          : MATHEMATICAL BOLD SMALL H
\\bfi                               <char-0x1D422>               " 𝐢          : MATHEMATICAL BOLD SMALL I
\\bfi<Tab>                          <char-0x1D422>               " 𝐢          : MATHEMATICAL BOLD SMALL I
\\bfio                              \\bfio                       "            : (Incomplete sequence)
\\bfiot                             \\bfiot                      "            : (Incomplete sequence)
\\bfiota                            <char-0x1D6CA>               " 𝛊          : MATHEMATICAL BOLD SMALL IOTA
\\bfj                               <char-0x1D423>               " 𝐣          : MATHEMATICAL BOLD SMALL J
\\bfk                               <char-0x1D424>               " 𝐤          : MATHEMATICAL BOLD SMALL K
\\bfk<Tab>                          <char-0x1D424>               " 𝐤          : MATHEMATICAL BOLD SMALL K
\\bfka                              \\bfka                       "            : (Incomplete sequence)
\\bfkap                             \\bfkap                      "            : (Incomplete sequence)
\\bfkapp                            \\bfkapp                     "            : (Incomplete sequence)
\\bfkappa                           <char-0x1D6CB>               " 𝛋          : MATHEMATICAL BOLD SMALL KAPPA
\\bfl                               <char-0x1D425>               " 𝐥          : MATHEMATICAL BOLD SMALL L
\\bfl<Tab>                          <char-0x1D425>               " 𝐥          : MATHEMATICAL BOLD SMALL L
\\bfla                              \\bfla                       "            : (Incomplete sequence)
\\bflam                             \\bflam                      "            : (Incomplete sequence)
\\bflamb                            \\bflamb                     "            : (Incomplete sequence)
\\bflambd                           \\bflambd                    "            : (Incomplete sequence)
\\bflambda                          <char-0x1D6CC>               " 𝛌          : MATHEMATICAL BOLD SMALL LAMDA
\\bfm                               <char-0x1D426>               " 𝐦          : MATHEMATICAL BOLD SMALL M
\\bfm<Tab>                          <char-0x1D426>               " 𝐦          : MATHEMATICAL BOLD SMALL M
\\bfmu                              <char-0x1D6CD>               " 𝛍          : MATHEMATICAL BOLD SMALL MU
\\bfn                               <char-0x1D427>               " 𝐧          : MATHEMATICAL BOLD SMALL N
\\bfn<Tab>                          <char-0x1D427>               " 𝐧          : MATHEMATICAL BOLD SMALL N
\\bfna                              \\bfna                       "            : (Incomplete sequence)
\\bfnab                             \\bfnab                      "            : (Incomplete sequence)
\\bfnabl                            \\bfnabl                     "            : (Incomplete sequence)
\\bfnabla                           <char-0x1D6C1>               " 𝛁          : MATHEMATICAL BOLD NABLA
\\bfni                              \\bfni                       "            : (Incomplete sequence)
\\bfnin                             \\bfnin                      "            : (Incomplete sequence)
\\bfnine                            <char-0x1D7D7>               " 𝟗          : MATHEMATICAL BOLD DIGIT NINE
\\bfnu                              <char-0x1D6CE>               " 𝛎          : MATHEMATICAL BOLD SMALL NU
\\bfo                               <char-0x1D428>               " 𝐨          : MATHEMATICAL BOLD SMALL O
\\bfo<Tab>                          <char-0x1D428>               " 𝐨          : MATHEMATICAL BOLD SMALL O
\\bfom                              \\bfom                       "            : (Incomplete sequence)
\\bfome                             \\bfome                      "            : (Incomplete sequence)
\\bfomeg                            \\bfomeg                     "            : (Incomplete sequence)
\\bfomega                           <char-0x1D6DA>               " 𝛚          : MATHEMATICAL BOLD SMALL OMEGA
\\bfomi                             \\bfomi                      "            : (Incomplete sequence)
\\bfomic                            \\bfomic                     "            : (Incomplete sequence)
\\bfomicr                           \\bfomicr                    "            : (Incomplete sequence)
\\bfomicro                          \\bfomicro                   "            : (Incomplete sequence)
\\bfomicron                         <char-0x1D6D0>               " 𝛐          : MATHEMATICAL BOLD SMALL OMICRON
\\bfon                              \\bfon                       "            : (Incomplete sequence)
\\bfone                             <char-0x1D7CF>               " 𝟏          : MATHEMATICAL BOLD DIGIT ONE
\\bfp                               <char-0x1D429>               " 𝐩          : MATHEMATICAL BOLD SMALL P
\\bfp<Tab>                          <char-0x1D429>               " 𝐩          : MATHEMATICAL BOLD SMALL P
\\bfpa                              \\bfpa                       "            : (Incomplete sequence)
\\bfpar                             \\bfpar                      "            : (Incomplete sequence)
\\bfpart                            \\bfpart                     "            : (Incomplete sequence)
\\bfparti                           \\bfparti                    "            : (Incomplete sequence)
\\bfpartia                          \\bfpartia                   "            : (Incomplete sequence)
\\bfpartial                         <char-0x1D6DB>               " 𝛛          : MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
\\bfph                              \\bfph                       "            : (Incomplete sequence)
\\bfphi                             <char-0x1D6DF>               " 𝛟          : MATHEMATICAL BOLD PHI SYMBOL
\\bfpi                              <char-0x1D6D1>               " 𝛑          : MATHEMATICAL BOLD SMALL PI
\\bfps                              \\bfps                       "            : (Incomplete sequence)
\\bfpsi                             <char-0x1D6D9>               " 𝛙          : MATHEMATICAL BOLD SMALL PSI
\\bfq                               <char-0x1D42A>               " 𝐪          : MATHEMATICAL BOLD SMALL Q
\\bfr                               <char-0x1D42B>               " 𝐫          : MATHEMATICAL BOLD SMALL R
\\bfr<Tab>                          <char-0x1D42B>               " 𝐫          : MATHEMATICAL BOLD SMALL R
\\bfra                              \\bfra                       "            : (Incomplete sequence)
\\bfrak                             \\bfrak                      "            : (Incomplete sequence)
\\bfrakA                            <char-0x1D56C>               " 𝕬          : MATHEMATICAL BOLD FRAKTUR CAPITAL A
\\bfrakB                            <char-0x1D56D>               " 𝕭          : MATHEMATICAL BOLD FRAKTUR CAPITAL B
\\bfrakC                            <char-0x1D56E>               " 𝕮          : MATHEMATICAL BOLD FRAKTUR CAPITAL C
\\bfrakD                            <char-0x1D56F>               " 𝕯          : MATHEMATICAL BOLD FRAKTUR CAPITAL D
\\bfrakE                            <char-0x1D570>               " 𝕰          : MATHEMATICAL BOLD FRAKTUR CAPITAL E
\\bfrakF                            <char-0x1D571>               " 𝕱          : MATHEMATICAL BOLD FRAKTUR CAPITAL F
\\bfrakG                            <char-0x1D572>               " 𝕲          : MATHEMATICAL BOLD FRAKTUR CAPITAL G
\\bfrakH                            <char-0x1D573>               " 𝕳          : MATHEMATICAL BOLD FRAKTUR CAPITAL H
\\bfrakI                            <char-0x1D574>               " 𝕴          : MATHEMATICAL BOLD FRAKTUR CAPITAL I
\\bfrakJ                            <char-0x1D575>               " 𝕵          : MATHEMATICAL BOLD FRAKTUR CAPITAL J
\\bfrakK                            <char-0x1D576>               " 𝕶          : MATHEMATICAL BOLD FRAKTUR CAPITAL K
\\bfrakL                            <char-0x1D577>               " 𝕷          : MATHEMATICAL BOLD FRAKTUR CAPITAL L
\\bfrakM                            <char-0x1D578>               " 𝕸          : MATHEMATICAL BOLD FRAKTUR CAPITAL M
\\bfrakN                            <char-0x1D579>               " 𝕹          : MATHEMATICAL BOLD FRAKTUR CAPITAL N
\\bfrakO                            <char-0x1D57A>               " 𝕺          : MATHEMATICAL BOLD FRAKTUR CAPITAL O
\\bfrakP                            <char-0x1D57B>               " 𝕻          : MATHEMATICAL BOLD FRAKTUR CAPITAL P
\\bfrakQ                            <char-0x1D57C>               " 𝕼          : MATHEMATICAL BOLD FRAKTUR CAPITAL Q
\\bfrakR                            <char-0x1D57D>               " 𝕽          : MATHEMATICAL BOLD FRAKTUR CAPITAL R
\\bfrakS                            <char-0x1D57E>               " 𝕾          : MATHEMATICAL BOLD FRAKTUR CAPITAL S
\\bfrakT                            <char-0x1D57F>               " 𝕿          : MATHEMATICAL BOLD FRAKTUR CAPITAL T
\\bfrakU                            <char-0x1D580>               " 𝖀          : MATHEMATICAL BOLD FRAKTUR CAPITAL U
\\bfrakV                            <char-0x1D581>               " 𝖁          : MATHEMATICAL BOLD FRAKTUR CAPITAL V
\\bfrakW                            <char-0x1D582>               " 𝖂          : MATHEMATICAL BOLD FRAKTUR CAPITAL W
\\bfrakX                            <char-0x1D583>               " 𝖃          : MATHEMATICAL BOLD FRAKTUR CAPITAL X
\\bfrakY                            <char-0x1D584>               " 𝖄          : MATHEMATICAL BOLD FRAKTUR CAPITAL Y
\\bfrakZ                            <char-0x1D585>               " 𝖅          : MATHEMATICAL BOLD FRAKTUR CAPITAL Z
\\bfraka                            <char-0x1D586>               " 𝖆          : MATHEMATICAL BOLD FRAKTUR SMALL A
\\bfrakb                            <char-0x1D587>               " 𝖇          : MATHEMATICAL BOLD FRAKTUR SMALL B
\\bfrakc                            <char-0x1D588>               " 𝖈          : MATHEMATICAL BOLD FRAKTUR SMALL C
\\bfrakd                            <char-0x1D589>               " 𝖉          : MATHEMATICAL BOLD FRAKTUR SMALL D
\\bfrake                            <char-0x1D58A>               " 𝖊          : MATHEMATICAL BOLD FRAKTUR SMALL E
\\bfrakf                            <char-0x1D58B>               " 𝖋          : MATHEMATICAL BOLD FRAKTUR SMALL F
\\bfrakg                            <char-0x1D58C>               " 𝖌          : MATHEMATICAL BOLD FRAKTUR SMALL G
\\bfrakh                            <char-0x1D58D>               " 𝖍          : MATHEMATICAL BOLD FRAKTUR SMALL H
\\bfraki                            <char-0x1D58E>               " 𝖎          : MATHEMATICAL BOLD FRAKTUR SMALL I
\\bfrakj                            <char-0x1D58F>               " 𝖏          : MATHEMATICAL BOLD FRAKTUR SMALL J
\\bfrakk                            <char-0x1D590>               " 𝖐          : MATHEMATICAL BOLD FRAKTUR SMALL K
\\bfrakl                            <char-0x1D591>               " 𝖑          : MATHEMATICAL BOLD FRAKTUR SMALL L
\\bfrakm                            <char-0x1D592>               " 𝖒          : MATHEMATICAL BOLD FRAKTUR SMALL M
\\bfrakn                            <char-0x1D593>               " 𝖓          : MATHEMATICAL BOLD FRAKTUR SMALL N
\\bfrako                            <char-0x1D594>               " 𝖔          : MATHEMATICAL BOLD FRAKTUR SMALL O
\\bfrakp                            <char-0x1D595>               " 𝖕          : MATHEMATICAL BOLD FRAKTUR SMALL P
\\bfrakq                            <char-0x1D596>               " 𝖖          : MATHEMATICAL BOLD FRAKTUR SMALL Q
\\bfrakr                            <char-0x1D597>               " 𝖗          : MATHEMATICAL BOLD FRAKTUR SMALL R
\\bfraks                            <char-0x1D598>               " 𝖘          : MATHEMATICAL BOLD FRAKTUR SMALL S
\\bfrakt                            <char-0x1D599>               " 𝖙          : MATHEMATICAL BOLD FRAKTUR SMALL T
\\bfraku                            <char-0x1D59A>               " 𝖚          : MATHEMATICAL BOLD FRAKTUR SMALL U
\\bfrakv                            <char-0x1D59B>               " 𝖛          : MATHEMATICAL BOLD FRAKTUR SMALL V
\\bfrakw                            <char-0x1D59C>               " 𝖜          : MATHEMATICAL BOLD FRAKTUR SMALL W
\\bfrakx                            <char-0x1D59D>               " 𝖝          : MATHEMATICAL BOLD FRAKTUR SMALL X
\\bfraky                            <char-0x1D59E>               " 𝖞          : MATHEMATICAL BOLD FRAKTUR SMALL Y
\\bfrakz                            <char-0x1D59F>               " 𝖟          : MATHEMATICAL BOLD FRAKTUR SMALL Z
\\bfrh                              \\bfrh                       "            : (Incomplete sequence)
\\bfrho                             <char-0x1D6D2>               " 𝛒          : MATHEMATICAL BOLD SMALL RHO
\\bfs                               <char-0x1D42C>               " 𝐬          : MATHEMATICAL BOLD SMALL S
\\bfs<Tab>                          <char-0x1D42C>               " 𝐬          : MATHEMATICAL BOLD SMALL S
\\bfse                              \\bfse                       "            : (Incomplete sequence)
\\bfsev                             \\bfsev                      "            : (Incomplete sequence)
\\bfseve                            \\bfseve                     "            : (Incomplete sequence)
\\bfseven                           <char-0x1D7D5>               " 𝟕          : MATHEMATICAL BOLD DIGIT SEVEN
\\bfsi                              \\bfsi                       "            : (Incomplete sequence)
\\bfsig                             \\bfsig                      "            : (Incomplete sequence)
\\bfsigm                            \\bfsigm                     "            : (Incomplete sequence)
\\bfsigma                           <char-0x1D6D4>               " 𝛔          : MATHEMATICAL BOLD SMALL SIGMA
\\bfsix                             <char-0x1D7D4>               " 𝟔          : MATHEMATICAL BOLD DIGIT SIX
\\bft                               <char-0x1D42D>               " 𝐭          : MATHEMATICAL BOLD SMALL T
\\bft<Tab>                          <char-0x1D42D>               " 𝐭          : MATHEMATICAL BOLD SMALL T
\\bfta                              \\bfta                       "            : (Incomplete sequence)
\\bftau                             <char-0x1D6D5>               " 𝛕          : MATHEMATICAL BOLD SMALL TAU
\\bfth                              \\bfth                       "            : (Incomplete sequence)
\\bfthe                             \\bfthe                      "            : (Incomplete sequence)
\\bfthet                            \\bfthet                     "            : (Incomplete sequence)
\\bftheta                           <char-0x1D6C9>               " 𝛉          : MATHEMATICAL BOLD SMALL THETA
\\bfthr                             \\bfthr                      "            : (Incomplete sequence)
\\bfthre                            \\bfthre                     "            : (Incomplete sequence)
\\bfthree                           <char-0x1D7D1>               " 𝟑          : MATHEMATICAL BOLD DIGIT THREE
\\bftw                              \\bftw                       "            : (Incomplete sequence)
\\bftwo                             <char-0x1D7D0>               " 𝟐          : MATHEMATICAL BOLD DIGIT TWO
\\bfu                               <char-0x1D42E>               " 𝐮          : MATHEMATICAL BOLD SMALL U
\\bfu<Tab>                          <char-0x1D42E>               " 𝐮          : MATHEMATICAL BOLD SMALL U
\\bfup                              \\bfup                       "            : (Incomplete sequence)
\\bfups                             \\bfups                      "            : (Incomplete sequence)
\\bfupsi                            \\bfupsi                     "            : (Incomplete sequence)
\\bfupsil                           \\bfupsil                    "            : (Incomplete sequence)
\\bfupsilo                          \\bfupsilo                   "            : (Incomplete sequence)
\\bfupsilon                         <char-0x1D6D6>               " 𝛖          : MATHEMATICAL BOLD SMALL UPSILON
\\bfv                               <char-0x1D42F>               " 𝐯          : MATHEMATICAL BOLD SMALL V
\\bfv<Tab>                          <char-0x1D42F>               " 𝐯          : MATHEMATICAL BOLD SMALL V
\\bfva                              \\bfva                       "            : (Incomplete sequence)
\\bfvar                             \\bfvar                      "            : (Incomplete sequence)
\\bfvarT                            \\bfvarT                     "            : (Incomplete sequence)
\\bfvarTh                           \\bfvarTh                    "            : (Incomplete sequence)
\\bfvarThe                          \\bfvarThe                   "            : (Incomplete sequence)
\\bfvarThet                         \\bfvarThet                  "            : (Incomplete sequence)
\\bfvarTheta                        <char-0x1D6B9>               " 𝚹          : MATHEMATICAL BOLD CAPITAL THETA SYMBOL
\\bfvare                            \\bfvare                     "            : (Incomplete sequence)
\\bfvarep                           \\bfvarep                    "            : (Incomplete sequence)
\\bfvareps                          \\bfvareps                   "            : (Incomplete sequence)
\\bfvarepsi                         \\bfvarepsi                  "            : (Incomplete sequence)
\\bfvarepsil                        \\bfvarepsil                 "            : (Incomplete sequence)
\\bfvarepsilo                       \\bfvarepsilo                "            : (Incomplete sequence)
\\bfvarepsilon                      <char-0x1D6DC>               " 𝛜          : MATHEMATICAL BOLD EPSILON SYMBOL
\\bfvark                            \\bfvark                     "            : (Incomplete sequence)
\\bfvarka                           \\bfvarka                    "            : (Incomplete sequence)
\\bfvarkap                          \\bfvarkap                   "            : (Incomplete sequence)
\\bfvarkapp                         \\bfvarkapp                  "            : (Incomplete sequence)
\\bfvarkappa                        <char-0x1D6DE>               " 𝛞          : MATHEMATICAL BOLD KAPPA SYMBOL
\\bfvarp                            \\bfvarp                     "            : (Incomplete sequence)
\\bfvarph                           \\bfvarph                    "            : (Incomplete sequence)
\\bfvarphi                          <char-0x1D6D7>               " 𝛗          : MATHEMATICAL BOLD SMALL PHI
\\bfvarpi                           <char-0x1D6E1>               " 𝛡          : MATHEMATICAL BOLD PI SYMBOL
\\bfvarr                            \\bfvarr                     "            : (Incomplete sequence)
\\bfvarrh                           \\bfvarrh                    "            : (Incomplete sequence)
\\bfvarrho                          <char-0x1D6E0>               " 𝛠          : MATHEMATICAL BOLD RHO SYMBOL
\\bfvars                            \\bfvars                     "            : (Incomplete sequence)
\\bfvarsi                           \\bfvarsi                    "            : (Incomplete sequence)
\\bfvarsig                          \\bfvarsig                   "            : (Incomplete sequence)
\\bfvarsigm                         \\bfvarsigm                  "            : (Incomplete sequence)
\\bfvarsigma                        <char-0x1D6D3>               " 𝛓          : MATHEMATICAL BOLD SMALL FINAL SIGMA
\\bfvart                            \\bfvart                     "            : (Incomplete sequence)
\\bfvarth                           \\bfvarth                    "            : (Incomplete sequence)
\\bfvarthe                          \\bfvarthe                   "            : (Incomplete sequence)
\\bfvarthet                         \\bfvarthet                  "            : (Incomplete sequence)
\\bfvartheta                        <char-0x1D6DD>               " 𝛝          : MATHEMATICAL BOLD THETA SYMBOL
\\bfw                               <char-0x1D430>               " 𝐰          : MATHEMATICAL BOLD SMALL W
\\bfx                               <char-0x1D431>               " 𝐱          : MATHEMATICAL BOLD SMALL X
\\bfx<Tab>                          <char-0x1D431>               " 𝐱          : MATHEMATICAL BOLD SMALL X
\\bfxi                              <char-0x1D6CF>               " 𝛏          : MATHEMATICAL BOLD SMALL XI
\\bfy                               <char-0x1D432>               " 𝐲          : MATHEMATICAL BOLD SMALL Y
\\bfz                               <char-0x1D433>               " 𝐳          : MATHEMATICAL BOLD SMALL Z
\\bfz<Tab>                          <char-0x1D433>               " 𝐳          : MATHEMATICAL BOLD SMALL Z
\\bfze                              \\bfze                       "            : (Incomplete sequence)
\\bfzer                             \\bfzer                      "            : (Incomplete sequence)
\\bfzero                            <char-0x1D7CE>               " 𝟎          : MATHEMATICAL BOLD DIGIT ZERO
\\bfzet                             \\bfzet                      "            : (Incomplete sequence)
\\bfzeta                            <char-0x1D6C7>               " 𝛇          : MATHEMATICAL BOLD SMALL ZETA
\\biA                               <char-0x1D468>               " 𝑨          : MATHEMATICAL BOLD ITALIC CAPITAL A
\\biA<Tab>                          <char-0x1D468>               " 𝑨          : MATHEMATICAL BOLD ITALIC CAPITAL A
\\biAl                              \\biAl                       "            : (Incomplete sequence)
\\biAlp                             \\biAlp                      "            : (Incomplete sequence)
\\biAlph                            \\biAlph                     "            : (Incomplete sequence)
\\biAlpha                           <char-0x1D71C>               " 𝜜          : MATHEMATICAL BOLD ITALIC CAPITAL ALPHA
\\biB                               <char-0x1D469>               " 𝑩          : MATHEMATICAL BOLD ITALIC CAPITAL B
\\biB<Tab>                          <char-0x1D469>               " 𝑩          : MATHEMATICAL BOLD ITALIC CAPITAL B
\\biBe                              \\biBe                       "            : (Incomplete sequence)
\\biBet                             \\biBet                      "            : (Incomplete sequence)
\\biBeta                            <char-0x1D71D>               " 𝜝          : MATHEMATICAL BOLD ITALIC CAPITAL BETA
\\biC                               <char-0x1D46A>               " 𝑪          : MATHEMATICAL BOLD ITALIC CAPITAL C
\\biC<Tab>                          <char-0x1D46A>               " 𝑪          : MATHEMATICAL BOLD ITALIC CAPITAL C
\\biCh                              \\biCh                       "            : (Incomplete sequence)
\\biChi                             <char-0x1D732>               " 𝜲          : MATHEMATICAL BOLD ITALIC CAPITAL CHI
\\biD                               <char-0x1D46B>               " 𝑫          : MATHEMATICAL BOLD ITALIC CAPITAL D
\\biD<Tab>                          <char-0x1D46B>               " 𝑫          : MATHEMATICAL BOLD ITALIC CAPITAL D
\\biDe                              \\biDe                       "            : (Incomplete sequence)
\\biDel                             \\biDel                      "            : (Incomplete sequence)
\\biDelt                            \\biDelt                     "            : (Incomplete sequence)
\\biDelta                           <char-0x1D71F>               " 𝜟          : MATHEMATICAL BOLD ITALIC CAPITAL DELTA
\\biE                               <char-0x1D46C>               " 𝑬          : MATHEMATICAL BOLD ITALIC CAPITAL E
\\biE<Tab>                          <char-0x1D46C>               " 𝑬          : MATHEMATICAL BOLD ITALIC CAPITAL E
\\biEp                              \\biEp                       "            : (Incomplete sequence)
\\biEps                             \\biEps                      "            : (Incomplete sequence)
\\biEpsi                            \\biEpsi                     "            : (Incomplete sequence)
\\biEpsil                           \\biEpsil                    "            : (Incomplete sequence)
\\biEpsilo                          \\biEpsilo                   "            : (Incomplete sequence)
\\biEpsilon                         <char-0x1D720>               " 𝜠          : MATHEMATICAL BOLD ITALIC CAPITAL EPSILON
\\biEt                              \\biEt                       "            : (Incomplete sequence)
\\biEta                             <char-0x1D722>               " 𝜢          : MATHEMATICAL BOLD ITALIC CAPITAL ETA
\\biF                               <char-0x1D46D>               " 𝑭          : MATHEMATICAL BOLD ITALIC CAPITAL F
\\biG                               <char-0x1D46E>               " 𝑮          : MATHEMATICAL BOLD ITALIC CAPITAL G
\\biG<Tab>                          <char-0x1D46E>               " 𝑮          : MATHEMATICAL BOLD ITALIC CAPITAL G
\\biGa                              \\biGa                       "            : (Incomplete sequence)
\\biGam                             \\biGam                      "            : (Incomplete sequence)
\\biGamm                            \\biGamm                     "            : (Incomplete sequence)
\\biGamma                           <char-0x1D71E>               " 𝜞          : MATHEMATICAL BOLD ITALIC CAPITAL GAMMA
\\biH                               <char-0x1D46F>               " 𝑯          : MATHEMATICAL BOLD ITALIC CAPITAL H
\\biI                               <char-0x1D470>               " 𝑰          : MATHEMATICAL BOLD ITALIC CAPITAL I
\\biI<Tab>                          <char-0x1D470>               " 𝑰          : MATHEMATICAL BOLD ITALIC CAPITAL I
\\biIo                              \\biIo                       "            : (Incomplete sequence)
\\biIot                             \\biIot                      "            : (Incomplete sequence)
\\biIota                            <char-0x1D724>               " 𝜤          : MATHEMATICAL BOLD ITALIC CAPITAL IOTA
\\biJ                               <char-0x1D471>               " 𝑱          : MATHEMATICAL BOLD ITALIC CAPITAL J
\\biK                               <char-0x1D472>               " 𝑲          : MATHEMATICAL BOLD ITALIC CAPITAL K
\\biK<Tab>                          <char-0x1D472>               " 𝑲          : MATHEMATICAL BOLD ITALIC CAPITAL K
\\biKa                              \\biKa                       "            : (Incomplete sequence)
\\biKap                             \\biKap                      "            : (Incomplete sequence)
\\biKapp                            \\biKapp                     "            : (Incomplete sequence)
\\biKappa                           <char-0x1D725>               " 𝜥          : MATHEMATICAL BOLD ITALIC CAPITAL KAPPA
\\biL                               <char-0x1D473>               " 𝑳          : MATHEMATICAL BOLD ITALIC CAPITAL L
\\biL<Tab>                          <char-0x1D473>               " 𝑳          : MATHEMATICAL BOLD ITALIC CAPITAL L
\\biLa                              \\biLa                       "            : (Incomplete sequence)
\\biLam                             \\biLam                      "            : (Incomplete sequence)
\\biLamb                            \\biLamb                     "            : (Incomplete sequence)
\\biLambd                           \\biLambd                    "            : (Incomplete sequence)
\\biLambda                          <char-0x1D726>               " 𝜦          : MATHEMATICAL BOLD ITALIC CAPITAL LAMDA
\\biM                               <char-0x1D474>               " 𝑴          : MATHEMATICAL BOLD ITALIC CAPITAL M
\\biM<Tab>                          <char-0x1D474>               " 𝑴          : MATHEMATICAL BOLD ITALIC CAPITAL M
\\biMu                              <char-0x1D727>               " 𝜧          : MATHEMATICAL BOLD ITALIC CAPITAL MU
\\biN                               <char-0x1D475>               " 𝑵          : MATHEMATICAL BOLD ITALIC CAPITAL N
\\biN<Tab>                          <char-0x1D475>               " 𝑵          : MATHEMATICAL BOLD ITALIC CAPITAL N
\\biNu                              <char-0x1D728>               " 𝜨          : MATHEMATICAL BOLD ITALIC CAPITAL NU
\\biO                               <char-0x1D476>               " 𝑶          : MATHEMATICAL BOLD ITALIC CAPITAL O
\\biO<Tab>                          <char-0x1D476>               " 𝑶          : MATHEMATICAL BOLD ITALIC CAPITAL O
\\biOm                              \\biOm                       "            : (Incomplete sequence)
\\biOme                             \\biOme                      "            : (Incomplete sequence)
\\biOmeg                            \\biOmeg                     "            : (Incomplete sequence)
\\biOmega                           <char-0x1D734>               " 𝜴          : MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
\\biOmi                             \\biOmi                      "            : (Incomplete sequence)
\\biOmic                            \\biOmic                     "            : (Incomplete sequence)
\\biOmicr                           \\biOmicr                    "            : (Incomplete sequence)
\\biOmicro                          \\biOmicro                   "            : (Incomplete sequence)
\\biOmicron                         <char-0x1D72A>               " 𝜪          : MATHEMATICAL BOLD ITALIC CAPITAL OMICRON
\\biP                               <char-0x1D477>               " 𝑷          : MATHEMATICAL BOLD ITALIC CAPITAL P
\\biP<Tab>                          <char-0x1D477>               " 𝑷          : MATHEMATICAL BOLD ITALIC CAPITAL P
\\biPh                              \\biPh                       "            : (Incomplete sequence)
\\biPhi                             <char-0x1D731>               " 𝜱          : MATHEMATICAL BOLD ITALIC CAPITAL PHI
\\biPi                              <char-0x1D72B>               " 𝜫          : MATHEMATICAL BOLD ITALIC CAPITAL PI
\\biPs                              \\biPs                       "            : (Incomplete sequence)
\\biPsi                             <char-0x1D733>               " 𝜳          : MATHEMATICAL BOLD ITALIC CAPITAL PSI
\\biQ                               <char-0x1D478>               " 𝑸          : MATHEMATICAL BOLD ITALIC CAPITAL Q
\\biR                               <char-0x1D479>               " 𝑹          : MATHEMATICAL BOLD ITALIC CAPITAL R
\\biR<Tab>                          <char-0x1D479>               " 𝑹          : MATHEMATICAL BOLD ITALIC CAPITAL R
\\biRh                              \\biRh                       "            : (Incomplete sequence)
\\biRho                             <char-0x1D72C>               " 𝜬          : MATHEMATICAL BOLD ITALIC CAPITAL RHO
\\biS                               <char-0x1D47A>               " 𝑺          : MATHEMATICAL BOLD ITALIC CAPITAL S
\\biS<Tab>                          <char-0x1D47A>               " 𝑺          : MATHEMATICAL BOLD ITALIC CAPITAL S
\\biSi                              \\biSi                       "            : (Incomplete sequence)
\\biSig                             \\biSig                      "            : (Incomplete sequence)
\\biSigm                            \\biSigm                     "            : (Incomplete sequence)
\\biSigma                           <char-0x1D72E>               " 𝜮          : MATHEMATICAL BOLD ITALIC CAPITAL SIGMA
\\biT                               <char-0x1D47B>               " 𝑻          : MATHEMATICAL BOLD ITALIC CAPITAL T
\\biT<Tab>                          <char-0x1D47B>               " 𝑻          : MATHEMATICAL BOLD ITALIC CAPITAL T
\\biTa                              \\biTa                       "            : (Incomplete sequence)
\\biTau                             <char-0x1D72F>               " 𝜯          : MATHEMATICAL BOLD ITALIC CAPITAL TAU
\\biTh                              \\biTh                       "            : (Incomplete sequence)
\\biThe                             \\biThe                      "            : (Incomplete sequence)
\\biThet                            \\biThet                     "            : (Incomplete sequence)
\\biTheta                           <char-0x1D723>               " 𝜣          : MATHEMATICAL BOLD ITALIC CAPITAL THETA
\\biU                               <char-0x1D47C>               " 𝑼          : MATHEMATICAL BOLD ITALIC CAPITAL U
\\biU<Tab>                          <char-0x1D47C>               " 𝑼          : MATHEMATICAL BOLD ITALIC CAPITAL U
\\biUp                              \\biUp                       "            : (Incomplete sequence)
\\biUps                             \\biUps                      "            : (Incomplete sequence)
\\biUpsi                            \\biUpsi                     "            : (Incomplete sequence)
\\biUpsil                           \\biUpsil                    "            : (Incomplete sequence)
\\biUpsilo                          \\biUpsilo                   "            : (Incomplete sequence)
\\biUpsilon                         <char-0x1D730>               " 𝜰          : MATHEMATICAL BOLD ITALIC CAPITAL UPSILON
\\biV                               <char-0x1D47D>               " 𝑽          : MATHEMATICAL BOLD ITALIC CAPITAL V
\\biW                               <char-0x1D47E>               " 𝑾          : MATHEMATICAL BOLD ITALIC CAPITAL W
\\biX                               <char-0x1D47F>               " 𝑿          : MATHEMATICAL BOLD ITALIC CAPITAL X
\\biX<Tab>                          <char-0x1D47F>               " 𝑿          : MATHEMATICAL BOLD ITALIC CAPITAL X
\\biXi                              <char-0x1D729>               " 𝜩          : MATHEMATICAL BOLD ITALIC CAPITAL XI
\\biY                               <char-0x1D480>               " 𝒀          : MATHEMATICAL BOLD ITALIC CAPITAL Y
\\biZ                               <char-0x1D481>               " 𝒁          : MATHEMATICAL BOLD ITALIC CAPITAL Z
\\biZ<Tab>                          <char-0x1D481>               " 𝒁          : MATHEMATICAL BOLD ITALIC CAPITAL Z
\\biZe                              \\biZe                       "            : (Incomplete sequence)
\\biZet                             \\biZet                      "            : (Incomplete sequence)
\\biZeta                            <char-0x1D721>               " 𝜡          : MATHEMATICAL BOLD ITALIC CAPITAL ZETA
\\bia                               <char-0x1D482>               " 𝒂          : MATHEMATICAL BOLD ITALIC SMALL A
\\bia<Tab>                          <char-0x1D482>               " 𝒂          : MATHEMATICAL BOLD ITALIC SMALL A
\\bial                              \\bial                       "            : (Incomplete sequence)
\\bialp                             \\bialp                      "            : (Incomplete sequence)
\\bialph                            \\bialph                     "            : (Incomplete sequence)
\\bialpha                           <char-0x1D736>               " 𝜶          : MATHEMATICAL BOLD ITALIC SMALL ALPHA
\\bib                               <char-0x1D483>               " 𝒃          : MATHEMATICAL BOLD ITALIC SMALL B
\\bib<Tab>                          <char-0x1D483>               " 𝒃          : MATHEMATICAL BOLD ITALIC SMALL B
\\bibe                              \\bibe                       "            : (Incomplete sequence)
\\bibet                             \\bibet                      "            : (Incomplete sequence)
\\bibeta                            <char-0x1D737>               " 𝜷          : MATHEMATICAL BOLD ITALIC SMALL BETA
\\bic                               <char-0x1D484>               " 𝒄          : MATHEMATICAL BOLD ITALIC SMALL C
\\bic<Tab>                          <char-0x1D484>               " 𝒄          : MATHEMATICAL BOLD ITALIC SMALL C
\\bich                              \\bich                       "            : (Incomplete sequence)
\\bichi                             <char-0x1D74C>               " 𝝌          : MATHEMATICAL BOLD ITALIC SMALL CHI
\\bid                               <char-0x1D485>               " 𝒅          : MATHEMATICAL BOLD ITALIC SMALL D
\\bid<Tab>                          <char-0x1D485>               " 𝒅          : MATHEMATICAL BOLD ITALIC SMALL D
\\bide                              \\bide                       "            : (Incomplete sequence)
\\bidel                             \\bidel                      "            : (Incomplete sequence)
\\bidelt                            \\bidelt                     "            : (Incomplete sequence)
\\bidelta                           <char-0x1D739>               " 𝜹          : MATHEMATICAL BOLD ITALIC SMALL DELTA
\\bie                               <char-0x1D486>               " 𝒆          : MATHEMATICAL BOLD ITALIC SMALL E
\\bie<Tab>                          <char-0x1D486>               " 𝒆          : MATHEMATICAL BOLD ITALIC SMALL E
\\biep                              \\biep                       "            : (Incomplete sequence)
\\bieps                             \\bieps                      "            : (Incomplete sequence)
\\biepsi                            \\biepsi                     "            : (Incomplete sequence)
\\biepsil                           \\biepsil                    "            : (Incomplete sequence)
\\biepsilo                          \\biepsilo                   "            : (Incomplete sequence)
\\biepsilon                         <char-0x1D73A>               " 𝜺          : MATHEMATICAL BOLD ITALIC SMALL EPSILON
\\biet                              \\biet                       "            : (Incomplete sequence)
\\bieta                             <char-0x1D73C>               " 𝜼          : MATHEMATICAL BOLD ITALIC SMALL ETA
\\bif                               <char-0x1D487>               " 𝒇          : MATHEMATICAL BOLD ITALIC SMALL F
\\big                               <char-0x1D488>               " 𝒈          : MATHEMATICAL BOLD ITALIC SMALL G
\\big<Tab>                          <char-0x1D488>               " 𝒈          : MATHEMATICAL BOLD ITALIC SMALL G
\\biga                              \\biga                       "            : (Incomplete sequence)
\\bigam                             \\bigam                      "            : (Incomplete sequence)
\\bigamm                            \\bigamm                     "            : (Incomplete sequence)
\\bigamma                           <char-0x1D738>               " 𝜸          : MATHEMATICAL BOLD ITALIC SMALL GAMMA
\\bigb                              \\bigb                       "            : (Incomplete sequence)
\\bigbl                             \\bigbl                      "            : (Incomplete sequence)
\\bigbla                            \\bigbla                     "            : (Incomplete sequence)
\\bigblac                           \\bigblac                    "            : (Incomplete sequence)
\\bigblack                          \\bigblack                   "            : (Incomplete sequence)
\\bigblackt                         \\bigblackt                  "            : (Incomplete sequence)
\\bigblacktr                        \\bigblacktr                 "            : (Incomplete sequence)
\\bigblacktri                       \\bigblacktri                "            : (Incomplete sequence)
\\bigblacktria                      \\bigblacktria               "            : (Incomplete sequence)
\\bigblacktrian                     \\bigblacktrian              "            : (Incomplete sequence)
\\bigblacktriang                    \\bigblacktriang             "            : (Incomplete sequence)
\\bigblacktriangl                   \\bigblacktriangl            "            : (Incomplete sequence)
\\bigblacktriangle                  \\bigblacktriangle           "            : (Incomplete sequence)
\\bigblacktriangled                 \\bigblacktriangled          "            : (Incomplete sequence)
\\bigblacktriangledo                \\bigblacktriangledo         "            : (Incomplete sequence)
\\bigblacktriangledow               \\bigblacktriangledow        "            : (Incomplete sequence)
\\bigblacktriangledown              <char-0x025BC>               " ▼          : BLACK DOWN-POINTING TRIANGLE / BLACK DOWN POINTING TRIANGLE
\\bigblacktriangleu                 \\bigblacktriangleu          "            : (Incomplete sequence)
\\bigblacktriangleup                <char-0x025B2>               " ▲          : BLACK UP-POINTING TRIANGLE / BLACK UP POINTING TRIANGLE
\\bigbo                             \\bigbo                      "            : (Incomplete sequence)
\\bigbot                            <char-0x027D8>               " ⟘          : LARGE UP TACK
\\bigc                              \\bigc                       "            : (Incomplete sequence)
\\bigca                             \\bigca                      "            : (Incomplete sequence)
\\bigcap                            <char-0x022C2>               " ⋂          : N-ARY INTERSECTION
\\bigci                             \\bigci                      "            : (Incomplete sequence)
\\bigcir                            \\bigcir                     "            : (Incomplete sequence)
\\bigcirc                           <char-0x025CB>               " ○          : WHITE CIRCLE
\\bigcu                             \\bigcu                      "            : (Incomplete sequence)
\\bigcup                            <char-0x022C3>               " ⋃          : N-ARY UNION
\\bigcup<Tab>                       <char-0x022C3>               " ⋃          : N-ARY UNION
\\bigcupd                           \\bigcupd                    "            : (Incomplete sequence)
\\bigcupdo                          \\bigcupdo                   "            : (Incomplete sequence)
\\bigcupdot                         <char-0x02A03>               " ⨃          : N-ARY UNION OPERATOR WITH DOT
\\bigo                              \\bigo                       "            : (Incomplete sequence)
\\bigod                             \\bigod                      "            : (Incomplete sequence)
\\bigodo                            \\bigodo                     "            : (Incomplete sequence)
\\bigodot                           <char-0x02A00>               " ⨀          : N-ARY CIRCLED DOT OPERATOR
\\bigop                             \\bigop                      "            : (Incomplete sequence)
\\bigopl                            \\bigopl                     "            : (Incomplete sequence)
\\bigoplu                           \\bigoplu                    "            : (Incomplete sequence)
\\bigoplus                          <char-0x02A01>               " ⨁          : N-ARY CIRCLED PLUS OPERATOR
\\bigot                             \\bigot                      "            : (Incomplete sequence)
\\bigoti                            \\bigoti                     "            : (Incomplete sequence)
\\bigotim                           \\bigotim                    "            : (Incomplete sequence)
\\bigotime                          \\bigotime                   "            : (Incomplete sequence)
\\bigotimes                         <char-0x02A02>               " ⨂          : N-ARY CIRCLED TIMES OPERATOR
\\bigs                              \\bigs                       "            : (Incomplete sequence)
\\bigsl                             \\bigsl                      "            : (Incomplete sequence)
\\bigslo                            \\bigslo                     "            : (Incomplete sequence)
\\bigslop                           \\bigslop                    "            : (Incomplete sequence)
\\bigslope                          \\bigslope                   "            : (Incomplete sequence)
\\bigsloped                         \\bigsloped                  "            : (Incomplete sequence)
\\bigslopedv                        \\bigslopedv                 "            : (Incomplete sequence)
\\bigslopedve                       \\bigslopedve                "            : (Incomplete sequence)
\\bigslopedvee                      <char-0x02A57>               " ⩗          : SLOPING LARGE OR
\\bigslopedw                        \\bigslopedw                 "            : (Incomplete sequence)
\\bigslopedwe                       \\bigslopedwe                "            : (Incomplete sequence)
\\bigslopedwed                      \\bigslopedwed               "            : (Incomplete sequence)
\\bigslopedwedg                     \\bigslopedwedg              "            : (Incomplete sequence)
\\bigslopedwedge                    <char-0x02A58>               " ⩘          : SLOPING LARGE AND
\\bigsq                             \\bigsq                      "            : (Incomplete sequence)
\\bigsqc                            \\bigsqc                     "            : (Incomplete sequence)
\\bigsqca                           \\bigsqca                    "            : (Incomplete sequence)
\\bigsqcap                          <char-0x02A05>               " ⨅          : N-ARY SQUARE INTERSECTION OPERATOR
\\bigsqcu                           \\bigsqcu                    "            : (Incomplete sequence)
\\bigsqcup                          <char-0x02A06>               " ⨆          : N-ARY SQUARE UNION OPERATOR
\\bigst                             \\bigst                      "            : (Incomplete sequence)
\\bigsta                            \\bigsta                     "            : (Incomplete sequence)
\\bigstar                           <char-0x02605>               " ★          : BLACK STAR
\\bigt                              \\bigt                       "            : (Incomplete sequence)
\\bigti                             \\bigti                      "            : (Incomplete sequence)
\\bigtim                            \\bigtim                     "            : (Incomplete sequence)
\\bigtime                           \\bigtime                    "            : (Incomplete sequence)
\\bigtimes                          <char-0x02A09>               " ⨉          : N-ARY TIMES OPERATOR
\\bigto                             \\bigto                      "            : (Incomplete sequence)
\\bigtop                            <char-0x027D9>               " ⟙          : LARGE DOWN TACK
\\bigtr                             \\bigtr                      "            : (Incomplete sequence)
\\bigtri                            \\bigtri                     "            : (Incomplete sequence)
\\bigtria                           \\bigtria                    "            : (Incomplete sequence)
\\bigtrian                          \\bigtrian                   "            : (Incomplete sequence)
\\bigtriang                         \\bigtriang                  "            : (Incomplete sequence)
\\bigtriangl                        \\bigtriangl                 "            : (Incomplete sequence)
\\bigtriangle                       \\bigtriangle                "            : (Incomplete sequence)
\\bigtriangled                      \\bigtriangled               "            : (Incomplete sequence)
\\bigtriangledo                     \\bigtriangledo              "            : (Incomplete sequence)
\\bigtriangledow                    \\bigtriangledow             "            : (Incomplete sequence)
\\bigtriangledown                   <char-0x025BD>               " ▽          : WHITE DOWN-POINTING TRIANGLE / WHITE DOWN POINTING TRIANGLE
\\bigtriangleu                      \\bigtriangleu               "            : (Incomplete sequence)
\\bigtriangleup                     <char-0x025B3>               " △          : WHITE UP-POINTING TRIANGLE / WHITE UP POINTING TRIANGLE
\\bigu                              \\bigu                       "            : (Incomplete sequence)
\\bigup                             \\bigup                      "            : (Incomplete sequence)
\\bigupl                            \\bigupl                     "            : (Incomplete sequence)
\\biguplu                           \\biguplu                    "            : (Incomplete sequence)
\\biguplus                          <char-0x02A04>               " ⨄          : N-ARY UNION OPERATOR WITH PLUS
\\bigv                              \\bigv                       "            : (Incomplete sequence)
\\bigve                             \\bigve                      "            : (Incomplete sequence)
\\bigvee                            <char-0x022C1>               " ⋁          : N-ARY LOGICAL OR
\\bigw                              \\bigw                       "            : (Incomplete sequence)
\\bigwe                             \\bigwe                      "            : (Incomplete sequence)
\\bigwed                            \\bigwed                     "            : (Incomplete sequence)
\\bigwedg                           \\bigwedg                    "            : (Incomplete sequence)
\\bigwedge                          <char-0x022C0>               " ⋀          : N-ARY LOGICAL AND
\\bigwh                             \\bigwh                      "            : (Incomplete sequence)
\\bigwhi                            \\bigwhi                     "            : (Incomplete sequence)
\\bigwhit                           \\bigwhit                    "            : (Incomplete sequence)
\\bigwhite                          \\bigwhite                   "            : (Incomplete sequence)
\\bigwhites                         \\bigwhites                  "            : (Incomplete sequence)
\\bigwhitest                        \\bigwhitest                 "            : (Incomplete sequence)
\\bigwhitesta                       \\bigwhitesta                "            : (Incomplete sequence)
\\bigwhitestar                      <char-0x02606>               " ☆          : WHITE STAR
\\bih                               <char-0x1D489>               " 𝒉          : MATHEMATICAL BOLD ITALIC SMALL H
\\bii                               <char-0x1D48A>               " 𝒊          : MATHEMATICAL BOLD ITALIC SMALL I
\\bii<Tab>                          <char-0x1D48A>               " 𝒊          : MATHEMATICAL BOLD ITALIC SMALL I
\\biio                              \\biio                       "            : (Incomplete sequence)
\\biiot                             \\biiot                      "            : (Incomplete sequence)
\\biiota                            <char-0x1D73E>               " 𝜾          : MATHEMATICAL BOLD ITALIC SMALL IOTA
\\bij                               <char-0x1D48B>               " 𝒋          : MATHEMATICAL BOLD ITALIC SMALL J
\\bik                               <char-0x1D48C>               " 𝒌          : MATHEMATICAL BOLD ITALIC SMALL K
\\bik<Tab>                          <char-0x1D48C>               " 𝒌          : MATHEMATICAL BOLD ITALIC SMALL K
\\bika                              \\bika                       "            : (Incomplete sequence)
\\bikap                             \\bikap                      "            : (Incomplete sequence)
\\bikapp                            \\bikapp                     "            : (Incomplete sequence)
\\bikappa                           <char-0x1D73F>               " 𝜿          : MATHEMATICAL BOLD ITALIC SMALL KAPPA
\\bil                               <char-0x1D48D>               " 𝒍          : MATHEMATICAL BOLD ITALIC SMALL L
\\bil<Tab>                          <char-0x1D48D>               " 𝒍          : MATHEMATICAL BOLD ITALIC SMALL L
\\bila                              \\bila                       "            : (Incomplete sequence)
\\bilam                             \\bilam                      "            : (Incomplete sequence)
\\bilamb                            \\bilamb                     "            : (Incomplete sequence)
\\bilambd                           \\bilambd                    "            : (Incomplete sequence)
\\bilambda                          <char-0x1D740>               " 𝝀          : MATHEMATICAL BOLD ITALIC SMALL LAMDA
\\bim                               <char-0x1D48E>               " 𝒎          : MATHEMATICAL BOLD ITALIC SMALL M
\\bim<Tab>                          <char-0x1D48E>               " 𝒎          : MATHEMATICAL BOLD ITALIC SMALL M
\\bimu                              <char-0x1D741>               " 𝝁          : MATHEMATICAL BOLD ITALIC SMALL MU
\\bin                               <char-0x1D48F>               " 𝒏          : MATHEMATICAL BOLD ITALIC SMALL N
\\bin<Tab>                          <char-0x1D48F>               " 𝒏          : MATHEMATICAL BOLD ITALIC SMALL N
\\bina                              \\bina                       "            : (Incomplete sequence)
\\binab                             \\binab                      "            : (Incomplete sequence)
\\binabl                            \\binabl                     "            : (Incomplete sequence)
\\binabla                           <char-0x1D735>               " 𝜵          : MATHEMATICAL BOLD ITALIC NABLA
\\binu                              <char-0x1D742>               " 𝝂          : MATHEMATICAL BOLD ITALIC SMALL NU
\\bio                               <char-0x1D490>               " 𝒐          : MATHEMATICAL BOLD ITALIC SMALL O
\\bio<Tab>                          <char-0x1D490>               " 𝒐          : MATHEMATICAL BOLD ITALIC SMALL O
\\biom                              \\biom                       "            : (Incomplete sequence)
\\biome                             \\biome                      "            : (Incomplete sequence)
\\biomeg                            \\biomeg                     "            : (Incomplete sequence)
\\biomega                           <char-0x1D74E>               " 𝝎          : MATHEMATICAL BOLD ITALIC SMALL OMEGA
\\biomi                             \\biomi                      "            : (Incomplete sequence)
\\biomic                            \\biomic                     "            : (Incomplete sequence)
\\biomicr                           \\biomicr                    "            : (Incomplete sequence)
\\biomicro                          \\biomicro                   "            : (Incomplete sequence)
\\biomicron                         <char-0x1D744>               " 𝝄          : MATHEMATICAL BOLD ITALIC SMALL OMICRON
\\bip                               <char-0x1D491>               " 𝒑          : MATHEMATICAL BOLD ITALIC SMALL P
\\bip<Tab>                          <char-0x1D491>               " 𝒑          : MATHEMATICAL BOLD ITALIC SMALL P
\\bipa                              \\bipa                       "            : (Incomplete sequence)
\\bipar                             \\bipar                      "            : (Incomplete sequence)
\\bipart                            \\bipart                     "            : (Incomplete sequence)
\\biparti                           \\biparti                    "            : (Incomplete sequence)
\\bipartia                          \\bipartia                   "            : (Incomplete sequence)
\\bipartial                         <char-0x1D74F>               " 𝝏          : MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
\\biph                              \\biph                       "            : (Incomplete sequence)
\\biphi                             <char-0x1D74B>               " 𝝋          : MATHEMATICAL BOLD ITALIC SMALL PHI
\\bipi                              <char-0x1D745>               " 𝝅          : MATHEMATICAL BOLD ITALIC SMALL PI
\\bips                              \\bips                       "            : (Incomplete sequence)
\\bipsi                             <char-0x1D74D>               " 𝝍          : MATHEMATICAL BOLD ITALIC SMALL PSI
\\biq                               <char-0x1D492>               " 𝒒          : MATHEMATICAL BOLD ITALIC SMALL Q
\\bir                               <char-0x1D493>               " 𝒓          : MATHEMATICAL BOLD ITALIC SMALL R
\\bir<Tab>                          <char-0x1D493>               " 𝒓          : MATHEMATICAL BOLD ITALIC SMALL R
\\birh                              \\birh                       "            : (Incomplete sequence)
\\birho                             <char-0x1D746>               " 𝝆          : MATHEMATICAL BOLD ITALIC SMALL RHO
\\bis                               <char-0x1D494>               " 𝒔          : MATHEMATICAL BOLD ITALIC SMALL S
\\bis<Tab>                          <char-0x1D494>               " 𝒔          : MATHEMATICAL BOLD ITALIC SMALL S
\\bisa                              \\bisa                       "            : (Incomplete sequence)
\\bisan                             \\bisan                      "            : (Incomplete sequence)
\\bisans                            \\bisans                     "            : (Incomplete sequence)
\\bisansA                           <char-0x1D63C>               " 𝘼          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
\\bisansA<Tab>                      <char-0x1D63C>               " 𝘼          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
\\bisansAl                          \\bisansAl                   "            : (Incomplete sequence)
\\bisansAlp                         \\bisansAlp                  "            : (Incomplete sequence)
\\bisansAlph                        \\bisansAlph                 "            : (Incomplete sequence)
\\bisansAlpha                       <char-0x1D790>               " 𝞐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA
\\bisansB                           <char-0x1D63D>               " 𝘽          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
\\bisansB<Tab>                      <char-0x1D63D>               " 𝘽          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
\\bisansBe                          \\bisansBe                   "            : (Incomplete sequence)
\\bisansBet                         \\bisansBet                  "            : (Incomplete sequence)
\\bisansBeta                        <char-0x1D791>               " 𝞑          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA
\\bisansC                           <char-0x1D63E>               " 𝘾          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
\\bisansC<Tab>                      <char-0x1D63E>               " 𝘾          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
\\bisansCh                          \\bisansCh                   "            : (Incomplete sequence)
\\bisansChi                         <char-0x1D7A6>               " 𝞦          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI
\\bisansD                           <char-0x1D63F>               " 𝘿          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
\\bisansD<Tab>                      <char-0x1D63F>               " 𝘿          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
\\bisansDe                          \\bisansDe                   "            : (Incomplete sequence)
\\bisansDel                         \\bisansDel                  "            : (Incomplete sequence)
\\bisansDelt                        \\bisansDelt                 "            : (Incomplete sequence)
\\bisansDelta                       <char-0x1D793>               " 𝞓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA
\\bisansE                           <char-0x1D640>               " 𝙀          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
\\bisansE<Tab>                      <char-0x1D640>               " 𝙀          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
\\bisansEp                          \\bisansEp                   "            : (Incomplete sequence)
\\bisansEps                         \\bisansEps                  "            : (Incomplete sequence)
\\bisansEpsi                        \\bisansEpsi                 "            : (Incomplete sequence)
\\bisansEpsil                       \\bisansEpsil                "            : (Incomplete sequence)
\\bisansEpsilo                      \\bisansEpsilo               "            : (Incomplete sequence)
\\bisansEpsilon                     <char-0x1D794>               " 𝞔          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON
\\bisansEt                          \\bisansEt                   "            : (Incomplete sequence)
\\bisansEta                         <char-0x1D796>               " 𝞖          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA
\\bisansF                           <char-0x1D641>               " 𝙁          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F
\\bisansG                           <char-0x1D642>               " 𝙂          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
\\bisansG<Tab>                      <char-0x1D642>               " 𝙂          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
\\bisansGa                          \\bisansGa                   "            : (Incomplete sequence)
\\bisansGam                         \\bisansGam                  "            : (Incomplete sequence)
\\bisansGamm                        \\bisansGamm                 "            : (Incomplete sequence)
\\bisansGamma                       <char-0x1D792>               " 𝞒          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA
\\bisansH                           <char-0x1D643>               " 𝙃          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H
\\bisansI                           <char-0x1D644>               " 𝙄          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
\\bisansI<Tab>                      <char-0x1D644>               " 𝙄          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
\\bisansIo                          \\bisansIo                   "            : (Incomplete sequence)
\\bisansIot                         \\bisansIot                  "            : (Incomplete sequence)
\\bisansIota                        <char-0x1D798>               " 𝞘          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA
\\bisansJ                           <char-0x1D645>               " 𝙅          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J
\\bisansK                           <char-0x1D646>               " 𝙆          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
\\bisansK<Tab>                      <char-0x1D646>               " 𝙆          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
\\bisansKa                          \\bisansKa                   "            : (Incomplete sequence)
\\bisansKap                         \\bisansKap                  "            : (Incomplete sequence)
\\bisansKapp                        \\bisansKapp                 "            : (Incomplete sequence)
\\bisansKappa                       <char-0x1D799>               " 𝞙          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA
\\bisansL                           <char-0x1D647>               " 𝙇          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
\\bisansL<Tab>                      <char-0x1D647>               " 𝙇          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
\\bisansLa                          \\bisansLa                   "            : (Incomplete sequence)
\\bisansLam                         \\bisansLam                  "            : (Incomplete sequence)
\\bisansLamb                        \\bisansLamb                 "            : (Incomplete sequence)
\\bisansLambd                       \\bisansLambd                "            : (Incomplete sequence)
\\bisansLambda                      <char-0x1D79A>               " 𝞚          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA
\\bisansM                           <char-0x1D648>               " 𝙈          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
\\bisansM<Tab>                      <char-0x1D648>               " 𝙈          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
\\bisansMu                          <char-0x1D79B>               " 𝞛          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU
\\bisansN                           <char-0x1D649>               " 𝙉          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
\\bisansN<Tab>                      <char-0x1D649>               " 𝙉          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
\\bisansNu                          <char-0x1D79C>               " 𝞜          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU
\\bisansO                           <char-0x1D64A>               " 𝙊          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
\\bisansO<Tab>                      <char-0x1D64A>               " 𝙊          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
\\bisansOm                          \\bisansOm                   "            : (Incomplete sequence)
\\bisansOme                         \\bisansOme                  "            : (Incomplete sequence)
\\bisansOmeg                        \\bisansOmeg                 "            : (Incomplete sequence)
\\bisansOmega                       <char-0x1D7A8>               " 𝞨          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
\\bisansOmi                         \\bisansOmi                  "            : (Incomplete sequence)
\\bisansOmic                        \\bisansOmic                 "            : (Incomplete sequence)
\\bisansOmicr                       \\bisansOmicr                "            : (Incomplete sequence)
\\bisansOmicro                      \\bisansOmicro               "            : (Incomplete sequence)
\\bisansOmicron                     <char-0x1D79E>               " 𝞞          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON
\\bisansP                           <char-0x1D64B>               " 𝙋          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
\\bisansP<Tab>                      <char-0x1D64B>               " 𝙋          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
\\bisansPh                          \\bisansPh                   "            : (Incomplete sequence)
\\bisansPhi                         <char-0x1D7A5>               " 𝞥          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI
\\bisansPi                          <char-0x1D79F>               " 𝞟          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI
\\bisansPs                          \\bisansPs                   "            : (Incomplete sequence)
\\bisansPsi                         <char-0x1D7A7>               " 𝞧          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI
\\bisansQ                           <char-0x1D64C>               " 𝙌          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q
\\bisansR                           <char-0x1D64D>               " 𝙍          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
\\bisansR<Tab>                      <char-0x1D64D>               " 𝙍          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
\\bisansRh                          \\bisansRh                   "            : (Incomplete sequence)
\\bisansRho                         <char-0x1D7A0>               " 𝞠          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO
\\bisansS                           <char-0x1D64E>               " 𝙎          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
\\bisansS<Tab>                      <char-0x1D64E>               " 𝙎          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
\\bisansSi                          \\bisansSi                   "            : (Incomplete sequence)
\\bisansSig                         \\bisansSig                  "            : (Incomplete sequence)
\\bisansSigm                        \\bisansSigm                 "            : (Incomplete sequence)
\\bisansSigma                       <char-0x1D7A2>               " 𝞢          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA
\\bisansT                           <char-0x1D64F>               " 𝙏          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
\\bisansT<Tab>                      <char-0x1D64F>               " 𝙏          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
\\bisansTa                          \\bisansTa                   "            : (Incomplete sequence)
\\bisansTau                         <char-0x1D7A3>               " 𝞣          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU
\\bisansTh                          \\bisansTh                   "            : (Incomplete sequence)
\\bisansThe                         \\bisansThe                  "            : (Incomplete sequence)
\\bisansThet                        \\bisansThet                 "            : (Incomplete sequence)
\\bisansTheta                       <char-0x1D797>               " 𝞗          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA
\\bisansU                           <char-0x1D650>               " 𝙐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
\\bisansU<Tab>                      <char-0x1D650>               " 𝙐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
\\bisansUp                          \\bisansUp                   "            : (Incomplete sequence)
\\bisansUps                         \\bisansUps                  "            : (Incomplete sequence)
\\bisansUpsi                        \\bisansUpsi                 "            : (Incomplete sequence)
\\bisansUpsil                       \\bisansUpsil                "            : (Incomplete sequence)
\\bisansUpsilo                      \\bisansUpsilo               "            : (Incomplete sequence)
\\bisansUpsilon                     <char-0x1D7A4>               " 𝞤          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON
\\bisansV                           <char-0x1D651>               " 𝙑          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V
\\bisansW                           <char-0x1D652>               " 𝙒          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W
\\bisansX                           <char-0x1D653>               " 𝙓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
\\bisansX<Tab>                      <char-0x1D653>               " 𝙓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
\\bisansXi                          <char-0x1D79D>               " 𝞝          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI
\\bisansY                           <char-0x1D654>               " 𝙔          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y
\\bisansZ                           <char-0x1D655>               " 𝙕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
\\bisansZ<Tab>                      <char-0x1D655>               " 𝙕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
\\bisansZe                          \\bisansZe                   "            : (Incomplete sequence)
\\bisansZet                         \\bisansZet                  "            : (Incomplete sequence)
\\bisansZeta                        <char-0x1D795>               " 𝞕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA
\\bisansa                           <char-0x1D656>               " 𝙖          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
\\bisansa<Tab>                      <char-0x1D656>               " 𝙖          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
\\bisansal                          \\bisansal                   "            : (Incomplete sequence)
\\bisansalp                         \\bisansalp                  "            : (Incomplete sequence)
\\bisansalph                        \\bisansalph                 "            : (Incomplete sequence)
\\bisansalpha                       <char-0x1D7AA>               " 𝞪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA
\\bisansb                           <char-0x1D657>               " 𝙗          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
\\bisansb<Tab>                      <char-0x1D657>               " 𝙗          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
\\bisansbe                          \\bisansbe                   "            : (Incomplete sequence)
\\bisansbet                         \\bisansbet                  "            : (Incomplete sequence)
\\bisansbeta                        <char-0x1D7AB>               " 𝞫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA
\\bisansc                           <char-0x1D658>               " 𝙘          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
\\bisansc<Tab>                      <char-0x1D658>               " 𝙘          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
\\bisansch                          \\bisansch                   "            : (Incomplete sequence)
\\bisanschi                         <char-0x1D7C0>               " 𝟀          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI
\\bisansd                           <char-0x1D659>               " 𝙙          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
\\bisansd<Tab>                      <char-0x1D659>               " 𝙙          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
\\bisansde                          \\bisansde                   "            : (Incomplete sequence)
\\bisansdel                         \\bisansdel                  "            : (Incomplete sequence)
\\bisansdelt                        \\bisansdelt                 "            : (Incomplete sequence)
\\bisansdelta                       <char-0x1D7AD>               " 𝞭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA
\\bisanse                           <char-0x1D65A>               " 𝙚          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
\\bisanse<Tab>                      <char-0x1D65A>               " 𝙚          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
\\bisansep                          \\bisansep                   "            : (Incomplete sequence)
\\bisanseps                         \\bisanseps                  "            : (Incomplete sequence)
\\bisansepsi                        \\bisansepsi                 "            : (Incomplete sequence)
\\bisansepsil                       \\bisansepsil                "            : (Incomplete sequence)
\\bisansepsilo                      \\bisansepsilo               "            : (Incomplete sequence)
\\bisansepsilon                     <char-0x1D7AE>               " 𝞮          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON
\\bisanset                          \\bisanset                   "            : (Incomplete sequence)
\\bisanseta                         <char-0x1D7B0>               " 𝞰          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA
\\bisansf                           <char-0x1D65B>               " 𝙛          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F
\\bisansg                           <char-0x1D65C>               " 𝙜          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
\\bisansg<Tab>                      <char-0x1D65C>               " 𝙜          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
\\bisansga                          \\bisansga                   "            : (Incomplete sequence)
\\bisansgam                         \\bisansgam                  "            : (Incomplete sequence)
\\bisansgamm                        \\bisansgamm                 "            : (Incomplete sequence)
\\bisansgamma                       <char-0x1D7AC>               " 𝞬          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA
\\bisansh                           <char-0x1D65D>               " 𝙝          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H
\\bisansi                           <char-0x1D65E>               " 𝙞          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
\\bisansi<Tab>                      <char-0x1D65E>               " 𝙞          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
\\bisansio                          \\bisansio                   "            : (Incomplete sequence)
\\bisansiot                         \\bisansiot                  "            : (Incomplete sequence)
\\bisansiota                        <char-0x1D7B2>               " 𝞲          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA
\\bisansj                           <char-0x1D65F>               " 𝙟          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J
\\bisansk                           <char-0x1D660>               " 𝙠          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
\\bisansk<Tab>                      <char-0x1D660>               " 𝙠          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
\\bisanska                          \\bisanska                   "            : (Incomplete sequence)
\\bisanskap                         \\bisanskap                  "            : (Incomplete sequence)
\\bisanskapp                        \\bisanskapp                 "            : (Incomplete sequence)
\\bisanskappa                       <char-0x1D7B3>               " 𝞳          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA
\\bisansl                           <char-0x1D661>               " 𝙡          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
\\bisansl<Tab>                      <char-0x1D661>               " 𝙡          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
\\bisansla                          \\bisansla                   "            : (Incomplete sequence)
\\bisanslam                         \\bisanslam                  "            : (Incomplete sequence)
\\bisanslamb                        \\bisanslamb                 "            : (Incomplete sequence)
\\bisanslambd                       \\bisanslambd                "            : (Incomplete sequence)
\\bisanslambda                      <char-0x1D7B4>               " 𝞴          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA
\\bisansm                           <char-0x1D662>               " 𝙢          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
\\bisansm<Tab>                      <char-0x1D662>               " 𝙢          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
\\bisansmu                          <char-0x1D7B5>               " 𝞵          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU
\\bisansn                           <char-0x1D663>               " 𝙣          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
\\bisansn<Tab>                      <char-0x1D663>               " 𝙣          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
\\bisansna                          \\bisansna                   "            : (Incomplete sequence)
\\bisansnab                         \\bisansnab                  "            : (Incomplete sequence)
\\bisansnabl                        \\bisansnabl                 "            : (Incomplete sequence)
\\bisansnabla                       <char-0x1D7A9>               " 𝞩          : MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
\\bisansnu                          <char-0x1D7B6>               " 𝞶          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU
\\bisanso                           <char-0x1D664>               " 𝙤          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
\\bisanso<Tab>                      <char-0x1D664>               " 𝙤          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
\\bisansom                          \\bisansom                   "            : (Incomplete sequence)
\\bisansome                         \\bisansome                  "            : (Incomplete sequence)
\\bisansomeg                        \\bisansomeg                 "            : (Incomplete sequence)
\\bisansomega                       <char-0x1D7C2>               " 𝟂          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
\\bisansomi                         \\bisansomi                  "            : (Incomplete sequence)
\\bisansomic                        \\bisansomic                 "            : (Incomplete sequence)
\\bisansomicr                       \\bisansomicr                "            : (Incomplete sequence)
\\bisansomicro                      \\bisansomicro               "            : (Incomplete sequence)
\\bisansomicron                     <char-0x1D7B8>               " 𝞸          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON
\\bisansp                           <char-0x1D665>               " 𝙥          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
\\bisansp<Tab>                      <char-0x1D665>               " 𝙥          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
\\bisanspa                          \\bisanspa                   "            : (Incomplete sequence)
\\bisanspar                         \\bisanspar                  "            : (Incomplete sequence)
\\bisanspart                        \\bisanspart                 "            : (Incomplete sequence)
\\bisansparti                       \\bisansparti                "            : (Incomplete sequence)
\\bisanspartia                      \\bisanspartia               "            : (Incomplete sequence)
\\bisanspartial                     <char-0x1D7C3>               " 𝟃          : MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
\\bisansph                          \\bisansph                   "            : (Incomplete sequence)
\\bisansphi                         <char-0x1D7BF>               " 𝞿          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI
\\bisanspi                          <char-0x1D7B9>               " 𝞹          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI
\\bisansps                          \\bisansps                   "            : (Incomplete sequence)
\\bisanspsi                         <char-0x1D7C1>               " 𝟁          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI
\\bisansq                           <char-0x1D666>               " 𝙦          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q
\\bisansr                           <char-0x1D667>               " 𝙧          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
\\bisansr<Tab>                      <char-0x1D667>               " 𝙧          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
\\bisansrh                          \\bisansrh                   "            : (Incomplete sequence)
\\bisansrho                         <char-0x1D7BA>               " 𝞺          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO
\\bisanss                           <char-0x1D668>               " 𝙨          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
\\bisanss<Tab>                      <char-0x1D668>               " 𝙨          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
\\bisanssi                          \\bisanssi                   "            : (Incomplete sequence)
\\bisanssig                         \\bisanssig                  "            : (Incomplete sequence)
\\bisanssigm                        \\bisanssigm                 "            : (Incomplete sequence)
\\bisanssigma                       <char-0x1D7BC>               " 𝞼          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA
\\bisanst                           <char-0x1D669>               " 𝙩          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
\\bisanst<Tab>                      <char-0x1D669>               " 𝙩          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
\\bisansta                          \\bisansta                   "            : (Incomplete sequence)
\\bisanstau                         <char-0x1D7BD>               " 𝞽          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU
\\bisansth                          \\bisansth                   "            : (Incomplete sequence)
\\bisansthe                         \\bisansthe                  "            : (Incomplete sequence)
\\bisansthet                        \\bisansthet                 "            : (Incomplete sequence)
\\bisanstheta                       <char-0x1D7B1>               " 𝞱          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA
\\bisansu                           <char-0x1D66A>               " 𝙪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
\\bisansu<Tab>                      <char-0x1D66A>               " 𝙪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
\\bisansup                          \\bisansup                   "            : (Incomplete sequence)
\\bisansups                         \\bisansups                  "            : (Incomplete sequence)
\\bisansupsi                        \\bisansupsi                 "            : (Incomplete sequence)
\\bisansupsil                       \\bisansupsil                "            : (Incomplete sequence)
\\bisansupsilo                      \\bisansupsilo               "            : (Incomplete sequence)
\\bisansupsilon                     <char-0x1D7BE>               " 𝞾          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON
\\bisansv                           <char-0x1D66B>               " 𝙫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
\\bisansv<Tab>                      <char-0x1D66B>               " 𝙫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
\\bisansva                          \\bisansva                   "            : (Incomplete sequence)
\\bisansvar                         \\bisansvar                  "            : (Incomplete sequence)
\\bisansvarT                        \\bisansvarT                 "            : (Incomplete sequence)
\\bisansvarTh                       \\bisansvarTh                "            : (Incomplete sequence)
\\bisansvarThe                      \\bisansvarThe               "            : (Incomplete sequence)
\\bisansvarThet                     \\bisansvarThet              "            : (Incomplete sequence)
\\bisansvarTheta                    <char-0x1D7A1>               " 𝞡          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL
\\bisansvare                        \\bisansvare                 "            : (Incomplete sequence)
\\bisansvarep                       \\bisansvarep                "            : (Incomplete sequence)
\\bisansvareps                      \\bisansvareps               "            : (Incomplete sequence)
\\bisansvarepsi                     \\bisansvarepsi              "            : (Incomplete sequence)
\\bisansvarepsil                    \\bisansvarepsil             "            : (Incomplete sequence)
\\bisansvarepsilo                   \\bisansvarepsilo            "            : (Incomplete sequence)
\\bisansvarepsilon                  <char-0x1D7C4>               " 𝟄          : MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL
\\bisansvark                        \\bisansvark                 "            : (Incomplete sequence)
\\bisansvarka                       \\bisansvarka                "            : (Incomplete sequence)
\\bisansvarkap                      \\bisansvarkap               "            : (Incomplete sequence)
\\bisansvarkapp                     \\bisansvarkapp              "            : (Incomplete sequence)
\\bisansvarkappa                    <char-0x1D7C6>               " 𝟆          : MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL
\\bisansvarp                        \\bisansvarp                 "            : (Incomplete sequence)
\\bisansvarph                       \\bisansvarph                "            : (Incomplete sequence)
\\bisansvarphi                      <char-0x1D7C7>               " 𝟇          : MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL
\\bisansvarpi                       <char-0x1D7C9>               " 𝟉          : MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
\\bisansvarr                        \\bisansvarr                 "            : (Incomplete sequence)
\\bisansvarrh                       \\bisansvarrh                "            : (Incomplete sequence)
\\bisansvarrho                      <char-0x1D7C8>               " 𝟈          : MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL
\\bisansvars                        \\bisansvars                 "            : (Incomplete sequence)
\\bisansvarsi                       \\bisansvarsi                "            : (Incomplete sequence)
\\bisansvarsig                      \\bisansvarsig               "            : (Incomplete sequence)
\\bisansvarsigm                     \\bisansvarsigm              "            : (Incomplete sequence)
\\bisansvarsigma                    <char-0x1D7BB>               " 𝞻          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA
\\bisansvart                        \\bisansvart                 "            : (Incomplete sequence)
\\bisansvarth                       \\bisansvarth                "            : (Incomplete sequence)
\\bisansvarthe                      \\bisansvarthe               "            : (Incomplete sequence)
\\bisansvarthet                     \\bisansvarthet              "            : (Incomplete sequence)
\\bisansvartheta                    <char-0x1D7C5>               " 𝟅          : MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL
\\bisansw                           <char-0x1D66C>               " 𝙬          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W
\\bisansx                           <char-0x1D66D>               " 𝙭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
\\bisansx<Tab>                      <char-0x1D66D>               " 𝙭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
\\bisansxi                          <char-0x1D7B7>               " 𝞷          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI
\\bisansy                           <char-0x1D66E>               " 𝙮          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y
\\bisansz                           <char-0x1D66F>               " 𝙯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
\\bisansz<Tab>                      <char-0x1D66F>               " 𝙯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
\\bisansze                          \\bisansze                   "            : (Incomplete sequence)
\\bisanszet                         \\bisanszet                  "            : (Incomplete sequence)
\\bisanszeta                        <char-0x1D7AF>               " 𝞯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA
\\bisi                              \\bisi                       "            : (Incomplete sequence)
\\bisig                             \\bisig                      "            : (Incomplete sequence)
\\bisigm                            \\bisigm                     "            : (Incomplete sequence)
\\bisigma                           <char-0x1D748>               " 𝝈          : MATHEMATICAL BOLD ITALIC SMALL SIGMA
\\bit                               <char-0x1D495>               " 𝒕          : MATHEMATICAL BOLD ITALIC SMALL T
\\bit<Tab>                          <char-0x1D495>               " 𝒕          : MATHEMATICAL BOLD ITALIC SMALL T
\\bita                              \\bita                       "            : (Incomplete sequence)
\\bitau                             <char-0x1D749>               " 𝝉          : MATHEMATICAL BOLD ITALIC SMALL TAU
\\bith                              \\bith                       "            : (Incomplete sequence)
\\bithe                             \\bithe                      "            : (Incomplete sequence)
\\bithet                            \\bithet                     "            : (Incomplete sequence)
\\bitheta                           <char-0x1D73D>               " 𝜽          : MATHEMATICAL BOLD ITALIC SMALL THETA
\\biu                               <char-0x1D496>               " 𝒖          : MATHEMATICAL BOLD ITALIC SMALL U
\\biu<Tab>                          <char-0x1D496>               " 𝒖          : MATHEMATICAL BOLD ITALIC SMALL U
\\biup                              \\biup                       "            : (Incomplete sequence)
\\biups                             \\biups                      "            : (Incomplete sequence)
\\biupsi                            \\biupsi                     "            : (Incomplete sequence)
\\biupsil                           \\biupsil                    "            : (Incomplete sequence)
\\biupsilo                          \\biupsilo                   "            : (Incomplete sequence)
\\biupsilon                         <char-0x1D74A>               " 𝝊          : MATHEMATICAL BOLD ITALIC SMALL UPSILON
\\biv                               <char-0x1D497>               " 𝒗          : MATHEMATICAL BOLD ITALIC SMALL V
\\biv<Tab>                          <char-0x1D497>               " 𝒗          : MATHEMATICAL BOLD ITALIC SMALL V
\\biva                              \\biva                       "            : (Incomplete sequence)
\\bivar                             \\bivar                      "            : (Incomplete sequence)
\\bivarT                            \\bivarT                     "            : (Incomplete sequence)
\\bivarTh                           \\bivarTh                    "            : (Incomplete sequence)
\\bivarThe                          \\bivarThe                   "            : (Incomplete sequence)
\\bivarThet                         \\bivarThet                  "            : (Incomplete sequence)
\\bivarTheta                        <char-0x1D72D>               " 𝜭          : MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL
\\bivare                            \\bivare                     "            : (Incomplete sequence)
\\bivarep                           \\bivarep                    "            : (Incomplete sequence)
\\bivareps                          \\bivareps                   "            : (Incomplete sequence)
\\bivarepsi                         \\bivarepsi                  "            : (Incomplete sequence)
\\bivarepsil                        \\bivarepsil                 "            : (Incomplete sequence)
\\bivarepsilo                       \\bivarepsilo                "            : (Incomplete sequence)
\\bivarepsilon                      <char-0x1D750>               " 𝝐          : MATHEMATICAL BOLD ITALIC EPSILON SYMBOL
\\bivark                            \\bivark                     "            : (Incomplete sequence)
\\bivarka                           \\bivarka                    "            : (Incomplete sequence)
\\bivarkap                          \\bivarkap                   "            : (Incomplete sequence)
\\bivarkapp                         \\bivarkapp                  "            : (Incomplete sequence)
\\bivarkappa                        <char-0x1D752>               " 𝝒          : MATHEMATICAL BOLD ITALIC KAPPA SYMBOL
\\bivarp                            \\bivarp                     "            : (Incomplete sequence)
\\bivarph                           \\bivarph                    "            : (Incomplete sequence)
\\bivarphi                          <char-0x1D753>               " 𝝓          : MATHEMATICAL BOLD ITALIC PHI SYMBOL
\\bivarpi                           <char-0x1D755>               " 𝝕          : MATHEMATICAL BOLD ITALIC PI SYMBOL
\\bivarr                            \\bivarr                     "            : (Incomplete sequence)
\\bivarrh                           \\bivarrh                    "            : (Incomplete sequence)
\\bivarrho                          <char-0x1D754>               " 𝝔          : MATHEMATICAL BOLD ITALIC RHO SYMBOL
\\bivars                            \\bivars                     "            : (Incomplete sequence)
\\bivarsi                           \\bivarsi                    "            : (Incomplete sequence)
\\bivarsig                          \\bivarsig                   "            : (Incomplete sequence)
\\bivarsigm                         \\bivarsigm                  "            : (Incomplete sequence)
\\bivarsigma                        <char-0x1D747>               " 𝝇          : MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA
\\bivart                            \\bivart                     "            : (Incomplete sequence)
\\bivarth                           \\bivarth                    "            : (Incomplete sequence)
\\bivarthe                          \\bivarthe                   "            : (Incomplete sequence)
\\bivarthet                         \\bivarthet                  "            : (Incomplete sequence)
\\bivartheta                        <char-0x1D751>               " 𝝑          : MATHEMATICAL BOLD ITALIC THETA SYMBOL
\\biw                               <char-0x1D498>               " 𝒘          : MATHEMATICAL BOLD ITALIC SMALL W
\\bix                               <char-0x1D499>               " 𝒙          : MATHEMATICAL BOLD ITALIC SMALL X
\\bix<Tab>                          <char-0x1D499>               " 𝒙          : MATHEMATICAL BOLD ITALIC SMALL X
\\bixi                              <char-0x1D743>               " 𝝃          : MATHEMATICAL BOLD ITALIC SMALL XI
\\biy                               <char-0x1D49A>               " 𝒚          : MATHEMATICAL BOLD ITALIC SMALL Y
\\biz                               <char-0x1D49B>               " 𝒛          : MATHEMATICAL BOLD ITALIC SMALL Z
\\biz<Tab>                          <char-0x1D49B>               " 𝒛          : MATHEMATICAL BOLD ITALIC SMALL Z
\\bize                              \\bize                       "            : (Incomplete sequence)
\\bizet                             \\bizet                      "            : (Incomplete sequence)
\\bizeta                            <char-0x1D73B>               " 𝜻          : MATHEMATICAL BOLD ITALIC SMALL ZETA
\\bkarow                            <char-0x0290D>               " ⤍          : RIGHTWARDS DOUBLE DASH ARROW
\\blackcircledrightdot              <char-0x02688>               " ⚈          : BLACK CIRCLE WITH WHITE DOT RIGHT
\\blackcircledtwodots               <char-0x02689>               " ⚉          : BLACK CIRCLE WITH TWO WHITE DOTS
\\blackcircleulquadwhite            <char-0x025D5>               " ◕          : CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK
\\blackinwhitediamond               <char-0x025C8>               " ◈          : WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
\\blackinwhitesquare                <char-0x025A3>               " ▣          : WHITE SQUARE CONTAINING BLACK SMALL SQUARE
\\blacklefthalfcircle               <char-0x025D6>               " ◖          : LEFT HALF BLACK CIRCLE
\\blacklozenge                      <char-0x029EB>               " ⧫          : BLACK LOZENGE
\\blackpointerleft                  <char-0x025C4>               " ◄          : BLACK LEFT-POINTING POINTER / BLACK LEFT POINTING POINTER
\\blackpointerright                 <char-0x025BA>               " ►          : BLACK RIGHT-POINTING POINTER / BLACK RIGHT POINTING POINTER
\\blackrighthalfcircle              <char-0x025D7>               " ◗          : RIGHT HALF BLACK CIRCLE
\\blacksmiley                       <char-0x0263B>               " ☻          : BLACK SMILING FACE
\\blacksquare                       <char-0x025A0>               " ■          : BLACK SQUARE
\\blacktriangle                     <char-0x025B4>               " ▴          : BLACK UP-POINTING SMALL TRIANGLE / BLACK UP POINTING SMALL TRIANGLE
\\blacktriangle<Tab>                <char-0x025B4>               " ▴          : BLACK UP-POINTING SMALL TRIANGLE / BLACK UP POINTING SMALL TRIANGLE
\\blacktriangled                    \\blacktriangled             "            : (Incomplete sequence)
\\blacktriangledo                   \\blacktriangledo            "            : (Incomplete sequence)
\\blacktriangledow                  \\blacktriangledow           "            : (Incomplete sequence)
\\blacktriangledown                 <char-0x025BE>               " ▾          : BLACK DOWN-POINTING SMALL TRIANGLE / BLACK DOWN POINTING SMALL TRIANGLE
\\blacktrianglel                    \\blacktrianglel             "            : (Incomplete sequence)
\\blacktrianglele                   \\blacktrianglele            "            : (Incomplete sequence)
\\blacktrianglelef                  \\blacktrianglelef           "            : (Incomplete sequence)
\\blacktriangleleft                 <char-0x025C0>               " ◀          : BLACK LEFT-POINTING TRIANGLE / BLACK LEFT POINTING TRIANGLE
\\blacktriangler                    \\blacktriangler             "            : (Incomplete sequence)
\\blacktriangleri                   \\blacktriangleri            "            : (Incomplete sequence)
\\blacktrianglerig                  \\blacktrianglerig           "            : (Incomplete sequence)
\\blacktrianglerigh                 \\blacktrianglerigh          "            : (Incomplete sequence)
\\blacktriangleright                <char-0x025B6>               " ▶          : BLACK RIGHT-POINTING TRIANGLE / BLACK RIGHT POINTING TRIANGLE
\\blanksymbol                       <char-0x02422>               " ␢          : BLANK SYMBOL / BLANK
\\blkhorzoval                       <char-0x02B2C>               " ⬬          : BLACK HORIZONTAL ELLIPSE
\\blkvertoval                       <char-0x02B2E>               " ⬮          : BLACK VERTICAL ELLIPSE
\\blockfull                         <char-0x02588>               " █          : FULL BLOCK
\\blockhalfshaded                   <char-0x02592>               " ▒          : MEDIUM SHADE
\\blocklefthalf                     <char-0x0258C>               " ▌          : LEFT HALF BLOCK
\\blocklowhalf                      <char-0x02584>               " ▄          : LOWER HALF BLOCK
\\blockqtrshaded                    <char-0x02591>               " ░          : LIGHT SHADE
\\blockrighthalf                    <char-0x02590>               " ▐          : RIGHT HALF BLOCK
\\blockthreeqtrshaded               <char-0x02593>               " ▓          : DARK SHADE
\\blockuphalf                       <char-0x02580>               " ▀          : UPPER HALF BLOCK
\\bot                               <char-0x022A5>               " ⊥          : UP TACK
\\bot<Tab>                          <char-0x022A5>               " ⊥          : UP TACK
\\bots                              \\bots                       "            : (Incomplete sequence)
\\botse                             \\botse                      "            : (Incomplete sequence)
\\botsem                            \\botsem                     "            : (Incomplete sequence)
\\botsemi                           \\botsemi                    "            : (Incomplete sequence)
\\botsemic                          \\botsemic                   "            : (Incomplete sequence)
\\botsemici                         \\botsemici                  "            : (Incomplete sequence)
\\botsemicir                        \\botsemicir                 "            : (Incomplete sequence)
\\botsemicirc                       \\botsemicirc                "            : (Incomplete sequence)
\\botsemicircl                      \\botsemicircl               "            : (Incomplete sequence)
\\botsemicircle                     <char-0x025E1>               " ◡          : LOWER HALF CIRCLE
\\bowtie                            <char-0x022C8>               " ⋈          : BOWTIE
\\boxast                            <char-0x029C6>               " ⧆          : SQUARED ASTERISK
\\boxbar                            <char-0x025EB>               " ◫          : WHITE SQUARE WITH VERTICAL BISECTING LINE
\\boxbslash                         <char-0x029C5>               " ⧅          : SQUARED FALLING DIAGONAL SLASH
\\boxcircle                         <char-0x029C7>               " ⧇          : SQUARED SMALL CIRCLE
\\boxdiag                           <char-0x029C4>               " ⧄          : SQUARED RISING DIAGONAL SLASH
\\boxdot                            <char-0x022A1>               " ⊡          : SQUARED DOT OPERATOR
\\boxminus                          <char-0x0229F>               " ⊟          : SQUARED MINUS
\\boxplus                           <char-0x0229E>               " ⊞          : SQUARED PLUS
\\boxquestion                       <char-0x02370>               " ⍰          : APL FUNCTIONAL SYMBOL QUAD QUESTION
\\boxtimes                          <char-0x022A0>               " ⊠          : SQUARED TIMES
\\boxupcaret                        <char-0x02353>               " ⍓          : APL FUNCTIONAL SYMBOL QUAD UP CARET
\\breve                             <char-0x00306>               " ◌̆         : COMBINING BREVE / NON-SPACING BREVE
\\brokenbar                         <char-0x000A6>               " ¦          : BROKEN BAR / BROKEN VERTICAL BAR
\\bsansA                            <char-0x1D5D4>               " 𝗔          : MATHEMATICAL SANS-SERIF BOLD CAPITAL A
\\bsansA<Tab>                       <char-0x1D5D4>               " 𝗔          : MATHEMATICAL SANS-SERIF BOLD CAPITAL A
\\bsansAl                           \\bsansAl                    "            : (Incomplete sequence)
\\bsansAlp                          \\bsansAlp                   "            : (Incomplete sequence)
\\bsansAlph                         \\bsansAlph                  "            : (Incomplete sequence)
\\bsansAlpha                        <char-0x1D756>               " 𝝖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA
\\bsansB                            <char-0x1D5D5>               " 𝗕          : MATHEMATICAL SANS-SERIF BOLD CAPITAL B
\\bsansB<Tab>                       <char-0x1D5D5>               " 𝗕          : MATHEMATICAL SANS-SERIF BOLD CAPITAL B
\\bsansBe                           \\bsansBe                    "            : (Incomplete sequence)
\\bsansBet                          \\bsansBet                   "            : (Incomplete sequence)
\\bsansBeta                         <char-0x1D757>               " 𝝗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA
\\bsansC                            <char-0x1D5D6>               " 𝗖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL C
\\bsansC<Tab>                       <char-0x1D5D6>               " 𝗖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL C
\\bsansCh                           \\bsansCh                    "            : (Incomplete sequence)
\\bsansChi                          <char-0x1D76C>               " 𝝬          : MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI
\\bsansD                            <char-0x1D5D7>               " 𝗗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL D
\\bsansD<Tab>                       <char-0x1D5D7>               " 𝗗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL D
\\bsansDe                           \\bsansDe                    "            : (Incomplete sequence)
\\bsansDel                          \\bsansDel                   "            : (Incomplete sequence)
\\bsansDelt                         \\bsansDelt                  "            : (Incomplete sequence)
\\bsansDelta                        <char-0x1D759>               " 𝝙          : MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA
\\bsansE                            <char-0x1D5D8>               " 𝗘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL E
\\bsansE<Tab>                       <char-0x1D5D8>               " 𝗘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL E
\\bsansEp                           \\bsansEp                    "            : (Incomplete sequence)
\\bsansEps                          \\bsansEps                   "            : (Incomplete sequence)
\\bsansEpsi                         \\bsansEpsi                  "            : (Incomplete sequence)
\\bsansEpsil                        \\bsansEpsil                 "            : (Incomplete sequence)
\\bsansEpsilo                       \\bsansEpsilo                "            : (Incomplete sequence)
\\bsansEpsilon                      <char-0x1D75A>               " 𝝚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON
\\bsansEt                           \\bsansEt                    "            : (Incomplete sequence)
\\bsansEta                          <char-0x1D75C>               " 𝝜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA
\\bsansF                            <char-0x1D5D9>               " 𝗙          : MATHEMATICAL SANS-SERIF BOLD CAPITAL F
\\bsansG                            <char-0x1D5DA>               " 𝗚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL G
\\bsansG<Tab>                       <char-0x1D5DA>               " 𝗚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL G
\\bsansGa                           \\bsansGa                    "            : (Incomplete sequence)
\\bsansGam                          \\bsansGam                   "            : (Incomplete sequence)
\\bsansGamm                         \\bsansGamm                  "            : (Incomplete sequence)
\\bsansGamma                        <char-0x1D758>               " 𝝘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA
\\bsansH                            <char-0x1D5DB>               " 𝗛          : MATHEMATICAL SANS-SERIF BOLD CAPITAL H
\\bsansI                            <char-0x1D5DC>               " 𝗜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL I
\\bsansI<Tab>                       <char-0x1D5DC>               " 𝗜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL I
\\bsansIo                           \\bsansIo                    "            : (Incomplete sequence)
\\bsansIot                          \\bsansIot                   "            : (Incomplete sequence)
\\bsansIota                         <char-0x1D75E>               " 𝝞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA
\\bsansJ                            <char-0x1D5DD>               " 𝗝          : MATHEMATICAL SANS-SERIF BOLD CAPITAL J
\\bsansK                            <char-0x1D5DE>               " 𝗞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL K
\\bsansK<Tab>                       <char-0x1D5DE>               " 𝗞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL K
\\bsansKa                           \\bsansKa                    "            : (Incomplete sequence)
\\bsansKap                          \\bsansKap                   "            : (Incomplete sequence)
\\bsansKapp                         \\bsansKapp                  "            : (Incomplete sequence)
\\bsansKappa                        <char-0x1D75F>               " 𝝟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA
\\bsansL                            <char-0x1D5DF>               " 𝗟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL L
\\bsansL<Tab>                       <char-0x1D5DF>               " 𝗟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL L
\\bsansLa                           \\bsansLa                    "            : (Incomplete sequence)
\\bsansLam                          \\bsansLam                   "            : (Incomplete sequence)
\\bsansLamb                         \\bsansLamb                  "            : (Incomplete sequence)
\\bsansLambd                        \\bsansLambd                 "            : (Incomplete sequence)
\\bsansLambda                       <char-0x1D760>               " 𝝠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA
\\bsansM                            <char-0x1D5E0>               " 𝗠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL M
\\bsansM<Tab>                       <char-0x1D5E0>               " 𝗠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL M
\\bsansMu                           <char-0x1D761>               " 𝝡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL MU
\\bsansN                            <char-0x1D5E1>               " 𝗡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL N
\\bsansN<Tab>                       <char-0x1D5E1>               " 𝗡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL N
\\bsansNu                           <char-0x1D762>               " 𝝢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL NU
\\bsansO                            <char-0x1D5E2>               " 𝗢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL O
\\bsansO<Tab>                       <char-0x1D5E2>               " 𝗢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL O
\\bsansOm                           \\bsansOm                    "            : (Incomplete sequence)
\\bsansOme                          \\bsansOme                   "            : (Incomplete sequence)
\\bsansOmeg                         \\bsansOmeg                  "            : (Incomplete sequence)
\\bsansOmega                        <char-0x1D76E>               " 𝝮          : MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
\\bsansOmi                          \\bsansOmi                   "            : (Incomplete sequence)
\\bsansOmic                         \\bsansOmic                  "            : (Incomplete sequence)
\\bsansOmicr                        \\bsansOmicr                 "            : (Incomplete sequence)
\\bsansOmicro                       \\bsansOmicro                "            : (Incomplete sequence)
\\bsansOmicron                      <char-0x1D764>               " 𝝤          : MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON
\\bsansP                            <char-0x1D5E3>               " 𝗣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL P
\\bsansP<Tab>                       <char-0x1D5E3>               " 𝗣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL P
\\bsansPh                           \\bsansPh                    "            : (Incomplete sequence)
\\bsansPhi                          <char-0x1D76B>               " 𝝫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI
\\bsansPi                           <char-0x1D765>               " 𝝥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PI
\\bsansPs                           \\bsansPs                    "            : (Incomplete sequence)
\\bsansPsi                          <char-0x1D76D>               " 𝝭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI
\\bsansQ                            <char-0x1D5E4>               " 𝗤          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Q
\\bsansR                            <char-0x1D5E5>               " 𝗥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL R
\\bsansR<Tab>                       <char-0x1D5E5>               " 𝗥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL R
\\bsansRh                           \\bsansRh                    "            : (Incomplete sequence)
\\bsansRho                          <char-0x1D766>               " 𝝦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO
\\bsansS                            <char-0x1D5E6>               " 𝗦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL S
\\bsansS<Tab>                       <char-0x1D5E6>               " 𝗦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL S
\\bsansSi                           \\bsansSi                    "            : (Incomplete sequence)
\\bsansSig                          \\bsansSig                   "            : (Incomplete sequence)
\\bsansSigm                         \\bsansSigm                  "            : (Incomplete sequence)
\\bsansSigma                        <char-0x1D768>               " 𝝨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA
\\bsansT                            <char-0x1D5E7>               " 𝗧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL T
\\bsansT<Tab>                       <char-0x1D5E7>               " 𝗧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL T
\\bsansTa                           \\bsansTa                    "            : (Incomplete sequence)
\\bsansTau                          <char-0x1D769>               " 𝝩          : MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU
\\bsansTh                           \\bsansTh                    "            : (Incomplete sequence)
\\bsansThe                          \\bsansThe                   "            : (Incomplete sequence)
\\bsansThet                         \\bsansThet                  "            : (Incomplete sequence)
\\bsansTheta                        <char-0x1D75D>               " 𝝝          : MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA
\\bsansU                            <char-0x1D5E8>               " 𝗨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL U
\\bsansU<Tab>                       <char-0x1D5E8>               " 𝗨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL U
\\bsansUp                           \\bsansUp                    "            : (Incomplete sequence)
\\bsansUps                          \\bsansUps                   "            : (Incomplete sequence)
\\bsansUpsi                         \\bsansUpsi                  "            : (Incomplete sequence)
\\bsansUpsil                        \\bsansUpsil                 "            : (Incomplete sequence)
\\bsansUpsilo                       \\bsansUpsilo                "            : (Incomplete sequence)
\\bsansUpsilon                      <char-0x1D76A>               " 𝝪          : MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON
\\bsansV                            <char-0x1D5E9>               " 𝗩          : MATHEMATICAL SANS-SERIF BOLD CAPITAL V
\\bsansW                            <char-0x1D5EA>               " 𝗪          : MATHEMATICAL SANS-SERIF BOLD CAPITAL W
\\bsansX                            <char-0x1D5EB>               " 𝗫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL X
\\bsansX<Tab>                       <char-0x1D5EB>               " 𝗫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL X
\\bsansXi                           <char-0x1D763>               " 𝝣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL XI
\\bsansY                            <char-0x1D5EC>               " 𝗬          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Y
\\bsansZ                            <char-0x1D5ED>               " 𝗭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
\\bsansZ<Tab>                       <char-0x1D5ED>               " 𝗭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
\\bsansZe                           \\bsansZe                    "            : (Incomplete sequence)
\\bsansZet                          \\bsansZet                   "            : (Incomplete sequence)
\\bsansZeta                         <char-0x1D75B>               " 𝝛          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA
\\bsansa                            <char-0x1D5EE>               " 𝗮          : MATHEMATICAL SANS-SERIF BOLD SMALL A
\\bsansa<Tab>                       <char-0x1D5EE>               " 𝗮          : MATHEMATICAL SANS-SERIF BOLD SMALL A
\\bsansal                           \\bsansal                    "            : (Incomplete sequence)
\\bsansalp                          \\bsansalp                   "            : (Incomplete sequence)
\\bsansalph                         \\bsansalph                  "            : (Incomplete sequence)
\\bsansalpha                        <char-0x1D770>               " 𝝰          : MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA
\\bsansb                            <char-0x1D5EF>               " 𝗯          : MATHEMATICAL SANS-SERIF BOLD SMALL B
\\bsansb<Tab>                       <char-0x1D5EF>               " 𝗯          : MATHEMATICAL SANS-SERIF BOLD SMALL B
\\bsansbe                           \\bsansbe                    "            : (Incomplete sequence)
\\bsansbet                          \\bsansbet                   "            : (Incomplete sequence)
\\bsansbeta                         <char-0x1D771>               " 𝝱          : MATHEMATICAL SANS-SERIF BOLD SMALL BETA
\\bsansc                            <char-0x1D5F0>               " 𝗰          : MATHEMATICAL SANS-SERIF BOLD SMALL C
\\bsansc<Tab>                       <char-0x1D5F0>               " 𝗰          : MATHEMATICAL SANS-SERIF BOLD SMALL C
\\bsansch                           \\bsansch                    "            : (Incomplete sequence)
\\bsanschi                          <char-0x1D786>               " 𝞆          : MATHEMATICAL SANS-SERIF BOLD SMALL CHI
\\bsansd                            <char-0x1D5F1>               " 𝗱          : MATHEMATICAL SANS-SERIF BOLD SMALL D
\\bsansd<Tab>                       <char-0x1D5F1>               " 𝗱          : MATHEMATICAL SANS-SERIF BOLD SMALL D
\\bsansde                           \\bsansde                    "            : (Incomplete sequence)
\\bsansdel                          \\bsansdel                   "            : (Incomplete sequence)
\\bsansdelt                         \\bsansdelt                  "            : (Incomplete sequence)
\\bsansdelta                        <char-0x1D773>               " 𝝳          : MATHEMATICAL SANS-SERIF BOLD SMALL DELTA
\\bsanse                            <char-0x1D5F2>               " 𝗲          : MATHEMATICAL SANS-SERIF BOLD SMALL E
\\bsanse<Tab>                       <char-0x1D5F2>               " 𝗲          : MATHEMATICAL SANS-SERIF BOLD SMALL E
\\bsansei                           \\bsansei                    "            : (Incomplete sequence)
\\bsanseig                          \\bsanseig                   "            : (Incomplete sequence)
\\bsanseigh                         \\bsanseigh                  "            : (Incomplete sequence)
\\bsanseight                        <char-0x1D7F4>               " 𝟴          : MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT
\\bsansep                           \\bsansep                    "            : (Incomplete sequence)
\\bsanseps                          \\bsanseps                   "            : (Incomplete sequence)
\\bsansepsi                         \\bsansepsi                  "            : (Incomplete sequence)
\\bsansepsil                        \\bsansepsil                 "            : (Incomplete sequence)
\\bsansepsilo                       \\bsansepsilo                "            : (Incomplete sequence)
\\bsansepsilon                      <char-0x1D774>               " 𝝴          : MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON
\\bsanset                           \\bsanset                    "            : (Incomplete sequence)
\\bsanseta                          <char-0x1D776>               " 𝝶          : MATHEMATICAL SANS-SERIF BOLD SMALL ETA
\\bsansf                            <char-0x1D5F3>               " 𝗳          : MATHEMATICAL SANS-SERIF BOLD SMALL F
\\bsansf<Tab>                       <char-0x1D5F3>               " 𝗳          : MATHEMATICAL SANS-SERIF BOLD SMALL F
\\bsansfi                           \\bsansfi                    "            : (Incomplete sequence)
\\bsansfiv                          \\bsansfiv                   "            : (Incomplete sequence)
\\bsansfive                         <char-0x1D7F1>               " 𝟱          : MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE
\\bsansfo                           \\bsansfo                    "            : (Incomplete sequence)
\\bsansfou                          \\bsansfou                   "            : (Incomplete sequence)
\\bsansfour                         <char-0x1D7F0>               " 𝟰          : MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR
\\bsansg                            <char-0x1D5F4>               " 𝗴          : MATHEMATICAL SANS-SERIF BOLD SMALL G
\\bsansg<Tab>                       <char-0x1D5F4>               " 𝗴          : MATHEMATICAL SANS-SERIF BOLD SMALL G
\\bsansga                           \\bsansga                    "            : (Incomplete sequence)
\\bsansgam                          \\bsansgam                   "            : (Incomplete sequence)
\\bsansgamm                         \\bsansgamm                  "            : (Incomplete sequence)
\\bsansgamma                        <char-0x1D772>               " 𝝲          : MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA
\\bsansh                            <char-0x1D5F5>               " 𝗵          : MATHEMATICAL SANS-SERIF BOLD SMALL H
\\bsansi                            <char-0x1D5F6>               " 𝗶          : MATHEMATICAL SANS-SERIF BOLD SMALL I
\\bsansi<Tab>                       <char-0x1D5F6>               " 𝗶          : MATHEMATICAL SANS-SERIF BOLD SMALL I
\\bsansio                           \\bsansio                    "            : (Incomplete sequence)
\\bsansiot                          \\bsansiot                   "            : (Incomplete sequence)
\\bsansiota                         <char-0x1D778>               " 𝝸          : MATHEMATICAL SANS-SERIF BOLD SMALL IOTA
\\bsansj                            <char-0x1D5F7>               " 𝗷          : MATHEMATICAL SANS-SERIF BOLD SMALL J
\\bsansk                            <char-0x1D5F8>               " 𝗸          : MATHEMATICAL SANS-SERIF BOLD SMALL K
\\bsansk<Tab>                       <char-0x1D5F8>               " 𝗸          : MATHEMATICAL SANS-SERIF BOLD SMALL K
\\bsanska                           \\bsanska                    "            : (Incomplete sequence)
\\bsanskap                          \\bsanskap                   "            : (Incomplete sequence)
\\bsanskapp                         \\bsanskapp                  "            : (Incomplete sequence)
\\bsanskappa                        <char-0x1D779>               " 𝝹          : MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA
\\bsansl                            <char-0x1D5F9>               " 𝗹          : MATHEMATICAL SANS-SERIF BOLD SMALL L
\\bsansl<Tab>                       <char-0x1D5F9>               " 𝗹          : MATHEMATICAL SANS-SERIF BOLD SMALL L
\\bsansla                           \\bsansla                    "            : (Incomplete sequence)
\\bsanslam                          \\bsanslam                   "            : (Incomplete sequence)
\\bsanslamb                         \\bsanslamb                  "            : (Incomplete sequence)
\\bsanslambd                        \\bsanslambd                 "            : (Incomplete sequence)
\\bsanslambda                       <char-0x1D77A>               " 𝝺          : MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA
\\bsansm                            <char-0x1D5FA>               " 𝗺          : MATHEMATICAL SANS-SERIF BOLD SMALL M
\\bsansm<Tab>                       <char-0x1D5FA>               " 𝗺          : MATHEMATICAL SANS-SERIF BOLD SMALL M
\\bsansmu                           <char-0x1D77B>               " 𝝻          : MATHEMATICAL SANS-SERIF BOLD SMALL MU
\\bsansn                            <char-0x1D5FB>               " 𝗻          : MATHEMATICAL SANS-SERIF BOLD SMALL N
\\bsansn<Tab>                       <char-0x1D5FB>               " 𝗻          : MATHEMATICAL SANS-SERIF BOLD SMALL N
\\bsansna                           \\bsansna                    "            : (Incomplete sequence)
\\bsansnab                          \\bsansnab                   "            : (Incomplete sequence)
\\bsansnabl                         \\bsansnabl                  "            : (Incomplete sequence)
\\bsansnabla                        <char-0x1D76F>               " 𝝯          : MATHEMATICAL SANS-SERIF BOLD NABLA
\\bsansni                           \\bsansni                    "            : (Incomplete sequence)
\\bsansnin                          \\bsansnin                   "            : (Incomplete sequence)
\\bsansnine                         <char-0x1D7F5>               " 𝟵          : MATHEMATICAL SANS-SERIF BOLD DIGIT NINE
\\bsansnu                           <char-0x1D77C>               " 𝝼          : MATHEMATICAL SANS-SERIF BOLD SMALL NU
\\bsanso                            <char-0x1D5FC>               " 𝗼          : MATHEMATICAL SANS-SERIF BOLD SMALL O
\\bsanso<Tab>                       <char-0x1D5FC>               " 𝗼          : MATHEMATICAL SANS-SERIF BOLD SMALL O
\\bsansom                           \\bsansom                    "            : (Incomplete sequence)
\\bsansome                          \\bsansome                   "            : (Incomplete sequence)
\\bsansomeg                         \\bsansomeg                  "            : (Incomplete sequence)
\\bsansomega                        <char-0x1D788>               " 𝞈          : MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
\\bsansomi                          \\bsansomi                   "            : (Incomplete sequence)
\\bsansomic                         \\bsansomic                  "            : (Incomplete sequence)
\\bsansomicr                        \\bsansomicr                 "            : (Incomplete sequence)
\\bsansomicro                       \\bsansomicro                "            : (Incomplete sequence)
\\bsansomicron                      <char-0x1D77E>               " 𝝾          : MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON
\\bsanson                           \\bsanson                    "            : (Incomplete sequence)
\\bsansone                          <char-0x1D7ED>               " 𝟭          : MATHEMATICAL SANS-SERIF BOLD DIGIT ONE
\\bsansp                            <char-0x1D5FD>               " 𝗽          : MATHEMATICAL SANS-SERIF BOLD SMALL P
\\bsansp<Tab>                       <char-0x1D5FD>               " 𝗽          : MATHEMATICAL SANS-SERIF BOLD SMALL P
\\bsanspa                           \\bsanspa                    "            : (Incomplete sequence)
\\bsanspar                          \\bsanspar                   "            : (Incomplete sequence)
\\bsanspart                         \\bsanspart                  "            : (Incomplete sequence)
\\bsansparti                        \\bsansparti                 "            : (Incomplete sequence)
\\bsanspartia                       \\bsanspartia                "            : (Incomplete sequence)
\\bsanspartial                      <char-0x1D789>               " 𝞉          : MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
\\bsansph                           \\bsansph                    "            : (Incomplete sequence)
\\bsansphi                          <char-0x1D785>               " 𝞅          : MATHEMATICAL SANS-SERIF BOLD SMALL PHI
\\bsanspi                           <char-0x1D77F>               " 𝝿          : MATHEMATICAL SANS-SERIF BOLD SMALL PI
\\bsansps                           \\bsansps                    "            : (Incomplete sequence)
\\bsanspsi                          <char-0x1D787>               " 𝞇          : MATHEMATICAL SANS-SERIF BOLD SMALL PSI
\\bsansq                            <char-0x1D5FE>               " 𝗾          : MATHEMATICAL SANS-SERIF BOLD SMALL Q
\\bsansr                            <char-0x1D5FF>               " 𝗿          : MATHEMATICAL SANS-SERIF BOLD SMALL R
\\bsansr<Tab>                       <char-0x1D5FF>               " 𝗿          : MATHEMATICAL SANS-SERIF BOLD SMALL R
\\bsansrh                           \\bsansrh                    "            : (Incomplete sequence)
\\bsansrho                          <char-0x1D780>               " 𝞀          : MATHEMATICAL SANS-SERIF BOLD SMALL RHO
\\bsanss                            <char-0x1D600>               " 𝘀          : MATHEMATICAL SANS-SERIF BOLD SMALL S
\\bsanss<Tab>                       <char-0x1D600>               " 𝘀          : MATHEMATICAL SANS-SERIF BOLD SMALL S
\\bsansse                           \\bsansse                    "            : (Incomplete sequence)
\\bsanssev                          \\bsanssev                   "            : (Incomplete sequence)
\\bsansseve                         \\bsansseve                  "            : (Incomplete sequence)
\\bsansseven                        <char-0x1D7F3>               " 𝟳          : MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN
\\bsanssi                           \\bsanssi                    "            : (Incomplete sequence)
\\bsanssig                          \\bsanssig                   "            : (Incomplete sequence)
\\bsanssigm                         \\bsanssigm                  "            : (Incomplete sequence)
\\bsanssigma                        <char-0x1D782>               " 𝞂          : MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA
\\bsanssix                          <char-0x1D7F2>               " 𝟲          : MATHEMATICAL SANS-SERIF BOLD DIGIT SIX
\\bsanst                            <char-0x1D601>               " 𝘁          : MATHEMATICAL SANS-SERIF BOLD SMALL T
\\bsanst<Tab>                       <char-0x1D601>               " 𝘁          : MATHEMATICAL SANS-SERIF BOLD SMALL T
\\bsansta                           \\bsansta                    "            : (Incomplete sequence)
\\bsanstau                          <char-0x1D783>               " 𝞃          : MATHEMATICAL SANS-SERIF BOLD SMALL TAU
\\bsansth                           \\bsansth                    "            : (Incomplete sequence)
\\bsansthe                          \\bsansthe                   "            : (Incomplete sequence)
\\bsansthet                         \\bsansthet                  "            : (Incomplete sequence)
\\bsanstheta                        <char-0x1D777>               " 𝝷          : MATHEMATICAL SANS-SERIF BOLD SMALL THETA
\\bsansthr                          \\bsansthr                   "            : (Incomplete sequence)
\\bsansthre                         \\bsansthre                  "            : (Incomplete sequence)
\\bsansthree                        <char-0x1D7EF>               " 𝟯          : MATHEMATICAL SANS-SERIF BOLD DIGIT THREE
\\bsanstw                           \\bsanstw                    "            : (Incomplete sequence)
\\bsanstwo                          <char-0x1D7EE>               " 𝟮          : MATHEMATICAL SANS-SERIF BOLD DIGIT TWO
\\bsansu                            <char-0x1D602>               " 𝘂          : MATHEMATICAL SANS-SERIF BOLD SMALL U
\\bsansu<Tab>                       <char-0x1D602>               " 𝘂          : MATHEMATICAL SANS-SERIF BOLD SMALL U
\\bsansup                           \\bsansup                    "            : (Incomplete sequence)
\\bsansups                          \\bsansups                   "            : (Incomplete sequence)
\\bsansupsi                         \\bsansupsi                  "            : (Incomplete sequence)
\\bsansupsil                        \\bsansupsil                 "            : (Incomplete sequence)
\\bsansupsilo                       \\bsansupsilo                "            : (Incomplete sequence)
\\bsansupsilon                      <char-0x1D784>               " 𝞄          : MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON
\\bsansv                            <char-0x1D603>               " 𝘃          : MATHEMATICAL SANS-SERIF BOLD SMALL V
\\bsansv<Tab>                       <char-0x1D603>               " 𝘃          : MATHEMATICAL SANS-SERIF BOLD SMALL V
\\bsansva                           \\bsansva                    "            : (Incomplete sequence)
\\bsansvar                          \\bsansvar                   "            : (Incomplete sequence)
\\bsansvarT                         \\bsansvarT                  "            : (Incomplete sequence)
\\bsansvarTh                        \\bsansvarTh                 "            : (Incomplete sequence)
\\bsansvarThe                       \\bsansvarThe                "            : (Incomplete sequence)
\\bsansvarThet                      \\bsansvarThet               "            : (Incomplete sequence)
\\bsansvarTheta                     <char-0x1D767>               " 𝝧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL
\\bsansvare                         \\bsansvare                  "            : (Incomplete sequence)
\\bsansvarep                        \\bsansvarep                 "            : (Incomplete sequence)
\\bsansvareps                       \\bsansvareps                "            : (Incomplete sequence)
\\bsansvarepsi                      \\bsansvarepsi               "            : (Incomplete sequence)
\\bsansvarepsil                     \\bsansvarepsil              "            : (Incomplete sequence)
\\bsansvarepsilo                    \\bsansvarepsilo             "            : (Incomplete sequence)
\\bsansvarepsilon                   <char-0x1D78A>               " 𝞊          : MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL
\\bsansvark                         \\bsansvark                  "            : (Incomplete sequence)
\\bsansvarka                        \\bsansvarka                 "            : (Incomplete sequence)
\\bsansvarkap                       \\bsansvarkap                "            : (Incomplete sequence)
\\bsansvarkapp                      \\bsansvarkapp               "            : (Incomplete sequence)
\\bsansvarkappa                     <char-0x1D78C>               " 𝞌          : MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL
\\bsansvarp                         \\bsansvarp                  "            : (Incomplete sequence)
\\bsansvarph                        \\bsansvarph                 "            : (Incomplete sequence)
\\bsansvarphi                       <char-0x1D78D>               " 𝞍          : MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL
\\bsansvarpi                        <char-0x1D78F>               " 𝞏          : MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
\\bsansvarr                         \\bsansvarr                  "            : (Incomplete sequence)
\\bsansvarrh                        \\bsansvarrh                 "            : (Incomplete sequence)
\\bsansvarrho                       <char-0x1D78E>               " 𝞎          : MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL
\\bsansvars                         \\bsansvars                  "            : (Incomplete sequence)
\\bsansvarsi                        \\bsansvarsi                 "            : (Incomplete sequence)
\\bsansvarsig                       \\bsansvarsig                "            : (Incomplete sequence)
\\bsansvarsigm                      \\bsansvarsigm               "            : (Incomplete sequence)
\\bsansvarsigma                     <char-0x1D781>               " 𝞁          : MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA
\\bsansvart                         \\bsansvart                  "            : (Incomplete sequence)
\\bsansvarth                        \\bsansvarth                 "            : (Incomplete sequence)
\\bsansvarthe                       \\bsansvarthe                "            : (Incomplete sequence)
\\bsansvarthet                      \\bsansvarthet               "            : (Incomplete sequence)
\\bsansvartheta                     <char-0x1D78B>               " 𝞋          : MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL
\\bsansw                            <char-0x1D604>               " 𝘄          : MATHEMATICAL SANS-SERIF BOLD SMALL W
\\bsansx                            <char-0x1D605>               " 𝘅          : MATHEMATICAL SANS-SERIF BOLD SMALL X
\\bsansx<Tab>                       <char-0x1D605>               " 𝘅          : MATHEMATICAL SANS-SERIF BOLD SMALL X
\\bsansxi                           <char-0x1D77D>               " 𝝽          : MATHEMATICAL SANS-SERIF BOLD SMALL XI
\\bsansy                            <char-0x1D606>               " 𝘆          : MATHEMATICAL SANS-SERIF BOLD SMALL Y
\\bsansz                            <char-0x1D607>               " 𝘇          : MATHEMATICAL SANS-SERIF BOLD SMALL Z
\\bsansz<Tab>                       <char-0x1D607>               " 𝘇          : MATHEMATICAL SANS-SERIF BOLD SMALL Z
\\bsansze                           \\bsansze                    "            : (Incomplete sequence)
\\bsanszer                          \\bsanszer                   "            : (Incomplete sequence)
\\bsanszero                         <char-0x1D7EC>               " 𝟬          : MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO
\\bsanszet                          \\bsanszet                   "            : (Incomplete sequence)
\\bsanszeta                         <char-0x1D775>               " 𝝵          : MATHEMATICAL SANS-SERIF BOLD SMALL ZETA
\\bscrA                             <char-0x1D4D0>               " 𝓐          : MATHEMATICAL BOLD SCRIPT CAPITAL A
\\bscrB                             <char-0x1D4D1>               " 𝓑          : MATHEMATICAL BOLD SCRIPT CAPITAL B
\\bscrC                             <char-0x1D4D2>               " 𝓒          : MATHEMATICAL BOLD SCRIPT CAPITAL C
\\bscrD                             <char-0x1D4D3>               " 𝓓          : MATHEMATICAL BOLD SCRIPT CAPITAL D
\\bscrE                             <char-0x1D4D4>               " 𝓔          : MATHEMATICAL BOLD SCRIPT CAPITAL E
\\bscrF                             <char-0x1D4D5>               " 𝓕          : MATHEMATICAL BOLD SCRIPT CAPITAL F
\\bscrG                             <char-0x1D4D6>               " 𝓖          : MATHEMATICAL BOLD SCRIPT CAPITAL G
\\bscrH                             <char-0x1D4D7>               " 𝓗          : MATHEMATICAL BOLD SCRIPT CAPITAL H
\\bscrI                             <char-0x1D4D8>               " 𝓘          : MATHEMATICAL BOLD SCRIPT CAPITAL I
\\bscrJ                             <char-0x1D4D9>               " 𝓙          : MATHEMATICAL BOLD SCRIPT CAPITAL J
\\bscrK                             <char-0x1D4DA>               " 𝓚          : MATHEMATICAL BOLD SCRIPT CAPITAL K
\\bscrL                             <char-0x1D4DB>               " 𝓛          : MATHEMATICAL BOLD SCRIPT CAPITAL L
\\bscrM                             <char-0x1D4DC>               " 𝓜          : MATHEMATICAL BOLD SCRIPT CAPITAL M
\\bscrN                             <char-0x1D4DD>               " 𝓝          : MATHEMATICAL BOLD SCRIPT CAPITAL N
\\bscrO                             <char-0x1D4DE>               " 𝓞          : MATHEMATICAL BOLD SCRIPT CAPITAL O
\\bscrP                             <char-0x1D4DF>               " 𝓟          : MATHEMATICAL BOLD SCRIPT CAPITAL P
\\bscrQ                             <char-0x1D4E0>               " 𝓠          : MATHEMATICAL BOLD SCRIPT CAPITAL Q
\\bscrR                             <char-0x1D4E1>               " 𝓡          : MATHEMATICAL BOLD SCRIPT CAPITAL R
\\bscrS                             <char-0x1D4E2>               " 𝓢          : MATHEMATICAL BOLD SCRIPT CAPITAL S
\\bscrT                             <char-0x1D4E3>               " 𝓣          : MATHEMATICAL BOLD SCRIPT CAPITAL T
\\bscrU                             <char-0x1D4E4>               " 𝓤          : MATHEMATICAL BOLD SCRIPT CAPITAL U
\\bscrV                             <char-0x1D4E5>               " 𝓥          : MATHEMATICAL BOLD SCRIPT CAPITAL V
\\bscrW                             <char-0x1D4E6>               " 𝓦          : MATHEMATICAL BOLD SCRIPT CAPITAL W
\\bscrX                             <char-0x1D4E7>               " 𝓧          : MATHEMATICAL BOLD SCRIPT CAPITAL X
\\bscrY                             <char-0x1D4E8>               " 𝓨          : MATHEMATICAL BOLD SCRIPT CAPITAL Y
\\bscrZ                             <char-0x1D4E9>               " 𝓩          : MATHEMATICAL BOLD SCRIPT CAPITAL Z
\\bscra                             <char-0x1D4EA>               " 𝓪          : MATHEMATICAL BOLD SCRIPT SMALL A
\\bscrb                             <char-0x1D4EB>               " 𝓫          : MATHEMATICAL BOLD SCRIPT SMALL B
\\bscrc                             <char-0x1D4EC>               " 𝓬          : MATHEMATICAL BOLD SCRIPT SMALL C
\\bscrd                             <char-0x1D4ED>               " 𝓭          : MATHEMATICAL BOLD SCRIPT SMALL D
\\bscre                             <char-0x1D4EE>               " 𝓮          : MATHEMATICAL BOLD SCRIPT SMALL E
\\bscrf                             <char-0x1D4EF>               " 𝓯          : MATHEMATICAL BOLD SCRIPT SMALL F
\\bscrg                             <char-0x1D4F0>               " 𝓰          : MATHEMATICAL BOLD SCRIPT SMALL G
\\bscrh                             <char-0x1D4F1>               " 𝓱          : MATHEMATICAL BOLD SCRIPT SMALL H
\\bscri                             <char-0x1D4F2>               " 𝓲          : MATHEMATICAL BOLD SCRIPT SMALL I
\\bscrj                             <char-0x1D4F3>               " 𝓳          : MATHEMATICAL BOLD SCRIPT SMALL J
\\bscrk                             <char-0x1D4F4>               " 𝓴          : MATHEMATICAL BOLD SCRIPT SMALL K
\\bscrl                             <char-0x1D4F5>               " 𝓵          : MATHEMATICAL BOLD SCRIPT SMALL L
\\bscrm                             <char-0x1D4F6>               " 𝓶          : MATHEMATICAL BOLD SCRIPT SMALL M
\\bscrn                             <char-0x1D4F7>               " 𝓷          : MATHEMATICAL BOLD SCRIPT SMALL N
\\bscro                             <char-0x1D4F8>               " 𝓸          : MATHEMATICAL BOLD SCRIPT SMALL O
\\bscrp                             <char-0x1D4F9>               " 𝓹          : MATHEMATICAL BOLD SCRIPT SMALL P
\\bscrq                             <char-0x1D4FA>               " 𝓺          : MATHEMATICAL BOLD SCRIPT SMALL Q
\\bscrr                             <char-0x1D4FB>               " 𝓻          : MATHEMATICAL BOLD SCRIPT SMALL R
\\bscrs                             <char-0x1D4FC>               " 𝓼          : MATHEMATICAL BOLD SCRIPT SMALL S
\\bscrt                             <char-0x1D4FD>               " 𝓽          : MATHEMATICAL BOLD SCRIPT SMALL T
\\bscru                             <char-0x1D4FE>               " 𝓾          : MATHEMATICAL BOLD SCRIPT SMALL U
\\bscrv                             <char-0x1D4FF>               " 𝓿          : MATHEMATICAL BOLD SCRIPT SMALL V
\\bscrw                             <char-0x1D500>               " 𝔀          : MATHEMATICAL BOLD SCRIPT SMALL W
\\bscrx                             <char-0x1D501>               " 𝔁          : MATHEMATICAL BOLD SCRIPT SMALL X
\\bscry                             <char-0x1D502>               " 𝔂          : MATHEMATICAL BOLD SCRIPT SMALL Y
\\bscrz                             <char-0x1D503>               " 𝔃          : MATHEMATICAL BOLD SCRIPT SMALL Z
\\bsimilarleftarrow                 <char-0x02B41>               " ⭁          : REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW
\\bsimilarrightarrow                <char-0x02B47>               " ⭇          : REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW
\\bsolhsub                          <char-0x027C8>               " ⟈          : REVERSE SOLIDUS PRECEDING SUBSET
\\btdl                              <char-0x0026C>               " ɬ          : LATIN SMALL LETTER L WITH BELT / LATIN SMALL LETTER L BELT
\\btimes                            <char-0x02A32>               " ⨲          : SEMIDIRECT PRODUCT WITH BOTTOM CLOSED
\\bullet                            <char-0x02022>               " •          : BULLET
\\bullseye                          <char-0x025CE>               " ◎          : BULLSEYE
\\bumpeq                            <char-0x0224F>               " ≏          : DIFFERENCE BETWEEN
\\bumpeq<Tab>                       <char-0x0224F>               " ≏          : DIFFERENCE BETWEEN
\\bumpeqq                           <char-0x02AAE>               " ⪮          : EQUALS SIGN WITH BUMPY ABOVE
\\c                                 <char-0x00327>               " ◌̧         : COMBINING CEDILLA / NON-SPACING CEDILLA
\\c<Tab>                            <char-0x00327>               " ◌̧         : COMBINING CEDILLA / NON-SPACING CEDILLA
\\ca                                \\ca                         "            : (Incomplete sequence)
\\can                               \\can                        "            : (Incomplete sequence)
\\canc                              \\canc                       "            : (Incomplete sequence)
\\cance                             \\cance                      "            : (Incomplete sequence)
\\cancer                            <char-0x0264B>               " ♋          : CANCER
\\cand                              \\cand                       "            : (Incomplete sequence)
\\candr                             \\candr                      "            : (Incomplete sequence)
\\candra                            <char-0x00310>               " ◌̐         : COMBINING CANDRABINDU / NON-SPACING CANDRABINDU
\\cap                               <char-0x02229>               " ∩          : INTERSECTION
\\cap<Tab>                          <char-0x02229>               " ∩          : INTERSECTION
\\capd                              \\capd                       "            : (Incomplete sequence)
\\capdo                             \\capdo                      "            : (Incomplete sequence)
\\capdot                            <char-0x02A40>               " ⩀          : INTERSECTION WITH DOT
\\capr                              \\capr                       "            : (Incomplete sequence)
\\capri                             \\capri                      "            : (Incomplete sequence)
\\capric                            \\capric                     "            : (Incomplete sequence)
\\caprico                           \\caprico                    "            : (Incomplete sequence)
\\capricor                          \\capricor                   "            : (Incomplete sequence)
\\capricorn                         \\capricorn                  "            : (Incomplete sequence)
\\capricornu                        \\capricornu                 "            : (Incomplete sequence)
\\capricornus                       <char-0x02651>               " ♑          : CAPRICORN
\\capw                              \\capw                       "            : (Incomplete sequence)
\\capwe                             \\capwe                      "            : (Incomplete sequence)
\\capwed                            \\capwed                     "            : (Incomplete sequence)
\\capwedg                           \\capwedg                    "            : (Incomplete sequence)
\\capwedge                          <char-0x02A44>               " ⩄          : INTERSECTION WITH LOGICAL AND
\\car                               \\car                        "            : (Incomplete sequence)
\\carr                              \\carr                       "            : (Incomplete sequence)
\\carri                             \\carri                      "            : (Incomplete sequence)
\\carria                            \\carria                     "            : (Incomplete sequence)
\\carriag                           \\carriag                    "            : (Incomplete sequence)
\\carriage                          \\carriage                   "            : (Incomplete sequence)
\\carriager                         \\carriager                  "            : (Incomplete sequence)
\\carriagere                        \\carriagere                 "            : (Incomplete sequence)
\\carriageret                       \\carriageret                "            : (Incomplete sequence)
\\carriageretu                      \\carriageretu               "            : (Incomplete sequence)
\\carriageretur                     \\carriageretur              "            : (Incomplete sequence)
\\carriagereturn                    <char-0x021B5>               " ↵          : DOWNWARDS ARROW WITH CORNER LEFTWARDS / DOWN ARROW WITH CORNER LEFT
\\cb                                \\cb                         "            : (Incomplete sequence)
\\cbr                               \\cbr                        "            : (Incomplete sequence)
\\cbrt                              <char-0x0221B>               " ∛          : CUBE ROOT
\\cd                                \\cd                         "            : (Incomplete sequence)
\\cdo                               \\cdo                        "            : (Incomplete sequence)
\\cdot                              <char-0x022C5>               " ⋅          : DOT OPERATOR
\\cdot<Tab>                         <char-0x022C5>               " ⋅          : DOT OPERATOR
\\cdotp                             <char-0x000B7>               " ·          : MIDDLE DOT
\\cdots                             <char-0x022EF>               " ⋯          : MIDLINE HORIZONTAL ELLIPSIS
\\ch                                \\ch                         "            : (Incomplete sequence)
\\che                               \\che                        "            : (Incomplete sequence)
\\chec                              \\chec                       "            : (Incomplete sequence)
\\check                             <char-0x0030C>               " ◌̌         : COMBINING CARON / NON-SPACING HACEK
\\check<Tab>                        <char-0x0030C>               " ◌̌         : COMBINING CARON / NON-SPACING HACEK
\\checkm                            \\checkm                     "            : (Incomplete sequence)
\\checkma                           \\checkma                    "            : (Incomplete sequence)
\\checkmar                          \\checkmar                   "            : (Incomplete sequence)
\\checkmark                         <char-0x02713>               " ✓          : CHECK MARK
\\chi                               <char-0x003C7>               " χ          : GREEK SMALL LETTER CHI
\\ci                                \\ci                         "            : (Incomplete sequence)
\\cir                               \\cir                        "            : (Incomplete sequence)
\\circ                              <char-0x02218>               " ∘          : RING OPERATOR
\\circ<Tab>                         <char-0x02218>               " ∘          : RING OPERATOR
\\circe                             \\circe                      "            : (Incomplete sequence)
\\circeq                            <char-0x02257>               " ≗          : RING EQUAL TO
\\circl                             \\circl                      "            : (Incomplete sequence)
\\circle                            \\circle                     "            : (Incomplete sequence)
\\circlea                           \\circlea                    "            : (Incomplete sequence)
\\circlear                          \\circlear                   "            : (Incomplete sequence)
\\circlearr                         \\circlearr                  "            : (Incomplete sequence)
\\circlearro                        \\circlearro                 "            : (Incomplete sequence)
\\circlearrow                       \\circlearrow                "            : (Incomplete sequence)
\\circlearrowl                      \\circlearrowl               "            : (Incomplete sequence)
\\circlearrowle                     \\circlearrowle              "            : (Incomplete sequence)
\\circlearrowlef                    \\circlearrowlef             "            : (Incomplete sequence)
\\circlearrowleft                   <char-0x021BA>               " ↺          : ANTICLOCKWISE OPEN CIRCLE ARROW
\\circlearrowr                      \\circlearrowr               "            : (Incomplete sequence)
\\circlearrowri                     \\circlearrowri              "            : (Incomplete sequence)
\\circlearrowrig                    \\circlearrowrig             "            : (Incomplete sequence)
\\circlearrowrigh                   \\circlearrowrigh            "            : (Incomplete sequence)
\\circlearrowright                  <char-0x021BB>               " ↻          : CLOCKWISE OPEN CIRCLE ARROW
\\circled                           \\circled                    "            : (Incomplete sequence)
\\circledR                          <char-0x000AE>               " ®          : REGISTERED SIGN / REGISTERED TRADE MARK SIGN
\\circledS                          <char-0x024C8>               " Ⓢ          : CIRCLED LATIN CAPITAL LETTER S
\\circleda                          \\circleda                   "            : (Incomplete sequence)
\\circledas                         \\circledas                  "            : (Incomplete sequence)
\\circledast                        <char-0x0229B>               " ⊛          : CIRCLED ASTERISK OPERATOR
\\circledb                          \\circledb                   "            : (Incomplete sequence)
\\circledbu                         \\circledbu                  "            : (Incomplete sequence)
\\circledbul                        \\circledbul                 "            : (Incomplete sequence)
\\circledbull                       \\circledbull                "            : (Incomplete sequence)
\\circledbulle                      \\circledbulle               "            : (Incomplete sequence)
\\circledbullet                     <char-0x029BF>               " ⦿          : CIRCLED BULLET
\\circledc                          \\circledc                   "            : (Incomplete sequence)
\\circledci                         \\circledci                  "            : (Incomplete sequence)
\\circledcir                        \\circledcir                 "            : (Incomplete sequence)
\\circledcirc                       <char-0x0229A>               " ⊚          : CIRCLED RING OPERATOR
\\circledd                          \\circledd                   "            : (Incomplete sequence)
\\circledda                         \\circledda                  "            : (Incomplete sequence)
\\circleddas                        \\circleddas                 "            : (Incomplete sequence)
\\circleddash                       <char-0x0229D>               " ⊝          : CIRCLED DASH
\\circlede                          \\circlede                   "            : (Incomplete sequence)
\\circledeq                         \\circledeq                  "            : (Incomplete sequence)
\\circledequ                        \\circledequ                 "            : (Incomplete sequence)
\\circledequa                       \\circledequa                "            : (Incomplete sequence)
\\circledequal                      <char-0x0229C>               " ⊜          : CIRCLED EQUALS
\\circledp                          \\circledp                   "            : (Incomplete sequence)
\\circledpa                         \\circledpa                  "            : (Incomplete sequence)
\\circledpar                        \\circledpar                 "            : (Incomplete sequence)
\\circledpara                       \\circledpara                "            : (Incomplete sequence)
\\circledparal                      \\circledparal               "            : (Incomplete sequence)
\\circledparall                     \\circledparall              "            : (Incomplete sequence)
\\circledparalle                    \\circledparalle             "            : (Incomplete sequence)
\\circledparallel                   <char-0x029B7>               " ⦷          : CIRCLED PARALLEL
\\circledr                          \\circledr                   "            : (Incomplete sequence)
\\circledri                         \\circledri                  "            : (Incomplete sequence)
\\circledrig                        \\circledrig                 "            : (Incomplete sequence)
\\circledrigh                       \\circledrigh                "            : (Incomplete sequence)
\\circledright                      \\circledright               "            : (Incomplete sequence)
\\circledrightd                     \\circledrightd              "            : (Incomplete sequence)
\\circledrightdo                    \\circledrightdo             "            : (Incomplete sequence)
\\circledrightdot                   <char-0x02686>               " ⚆          : WHITE CIRCLE WITH DOT RIGHT
\\circleds                          \\circleds                   "            : (Incomplete sequence)
\\circledst                         \\circledst                  "            : (Incomplete sequence)
\\circledsta                        \\circledsta                 "            : (Incomplete sequence)
\\circledstar                       <char-0x0272A>               " ✪          : CIRCLED WHITE STAR
\\circledt                          \\circledt                   "            : (Incomplete sequence)
\\circledtw                         \\circledtw                  "            : (Incomplete sequence)
\\circledtwo                        \\circledtwo                 "            : (Incomplete sequence)
\\circledtwod                       \\circledtwod                "            : (Incomplete sequence)
\\circledtwodo                      \\circledtwodo               "            : (Incomplete sequence)
\\circledtwodot                     \\circledtwodot              "            : (Incomplete sequence)
\\circledtwodots                    <char-0x02687>               " ⚇          : WHITE CIRCLE WITH TWO DOTS
\\circledw                          \\circledw                   "            : (Incomplete sequence)
\\circledwh                         \\circledwh                  "            : (Incomplete sequence)
\\circledwhi                        \\circledwhi                 "            : (Incomplete sequence)
\\circledwhit                       \\circledwhit                "            : (Incomplete sequence)
\\circledwhite                      \\circledwhite               "            : (Incomplete sequence)
\\circledwhiteb                     \\circledwhiteb              "            : (Incomplete sequence)
\\circledwhitebu                    \\circledwhitebu             "            : (Incomplete sequence)
\\circledwhitebul                   \\circledwhitebul            "            : (Incomplete sequence)
\\circledwhitebull                  \\circledwhitebull           "            : (Incomplete sequence)
\\circledwhitebulle                 \\circledwhitebulle          "            : (Incomplete sequence)
\\circledwhitebullet                <char-0x029BE>               " ⦾          : CIRCLED WHITE BULLET
\\circlel                           \\circlel                    "            : (Incomplete sequence)
\\circlell                          \\circlell                   "            : (Incomplete sequence)
\\circlellq                         \\circlellq                  "            : (Incomplete sequence)
\\circlellqu                        \\circlellqu                 "            : (Incomplete sequence)
\\circlellqua                       \\circlellqua                "            : (Incomplete sequence)
\\circlellquad                      <char-0x025F5>               " ◵          : WHITE CIRCLE WITH LOWER LEFT QUADRANT
\\circlelr                          \\circlelr                   "            : (Incomplete sequence)
\\circlelrq                         \\circlelrq                  "            : (Incomplete sequence)
\\circlelrqu                        \\circlelrqu                 "            : (Incomplete sequence)
\\circlelrqua                       \\circlelrqua                "            : (Incomplete sequence)
\\circlelrquad                      <char-0x025F6>               " ◶          : WHITE CIRCLE WITH LOWER RIGHT QUADRANT
\\circleo                           \\circleo                    "            : (Incomplete sequence)
\\circleon                          \\circleon                   "            : (Incomplete sequence)
\\circleonl                         \\circleonl                  "            : (Incomplete sequence)
\\circleonle                        \\circleonle                 "            : (Incomplete sequence)
\\circleonlef                       \\circleonlef                "            : (Incomplete sequence)
\\circleonleft                      \\circleonleft               "            : (Incomplete sequence)
\\circleonlefta                     \\circleonlefta              "            : (Incomplete sequence)
\\circleonleftar                    \\circleonleftar             "            : (Incomplete sequence)
\\circleonleftarr                   \\circleonleftarr            "            : (Incomplete sequence)
\\circleonleftarro                  \\circleonleftarro           "            : (Incomplete sequence)
\\circleonleftarrow                 <char-0x02B30>               " ⬰          : LEFT ARROW WITH SMALL CIRCLE
\\circleonr                         \\circleonr                  "            : (Incomplete sequence)
\\circleonri                        \\circleonri                 "            : (Incomplete sequence)
\\circleonrig                       \\circleonrig                "            : (Incomplete sequence)
\\circleonrigh                      \\circleonrigh               "            : (Incomplete sequence)
\\circleonright                     \\circleonright              "            : (Incomplete sequence)
\\circleonrighta                    \\circleonrighta             "            : (Incomplete sequence)
\\circleonrightar                   \\circleonrightar            "            : (Incomplete sequence)
\\circleonrightarr                  \\circleonrightarr           "            : (Incomplete sequence)
\\circleonrightarro                 \\circleonrightarro          "            : (Incomplete sequence)
\\circleonrightarrow                <char-0x021F4>               " ⇴          : RIGHT ARROW WITH SMALL CIRCLE
\\circlet                           \\circlet                    "            : (Incomplete sequence)
\\circleto                          \\circleto                   "            : (Incomplete sequence)
\\circletop                         \\circletop                  "            : (Incomplete sequence)
\\circletoph                        \\circletoph                 "            : (Incomplete sequence)
\\circletopha                       \\circletopha                "            : (Incomplete sequence)
\\circletophal                      \\circletophal               "            : (Incomplete sequence)
\\circletophalf                     \\circletophalf              "            : (Incomplete sequence)
\\circletophalfb                    \\circletophalfb             "            : (Incomplete sequence)
\\circletophalfbl                   \\circletophalfbl            "            : (Incomplete sequence)
\\circletophalfbla                  \\circletophalfbla           "            : (Incomplete sequence)
\\circletophalfblac                 \\circletophalfblac          "            : (Incomplete sequence)
\\circletophalfblack                <char-0x025D3>               " ◓          : CIRCLE WITH UPPER HALF BLACK
\\circleu                           \\circleu                    "            : (Incomplete sequence)
\\circleul                          \\circleul                   "            : (Incomplete sequence)
\\circleulq                         \\circleulq                  "            : (Incomplete sequence)
\\circleulqu                        \\circleulqu                 "            : (Incomplete sequence)
\\circleulqua                       \\circleulqua                "            : (Incomplete sequence)
\\circleulquad                      <char-0x025F4>               " ◴          : WHITE CIRCLE WITH UPPER LEFT QUADRANT
\\circleur                          \\circleur                   "            : (Incomplete sequence)
\\circleurq                         \\circleurq                  "            : (Incomplete sequence)
\\circleurqu                        \\circleurqu                 "            : (Incomplete sequence)
\\circleurqua                       \\circleurqua                "            : (Incomplete sequence)
\\circleurquad                      <char-0x025F7>               " ◷          : WHITE CIRCLE WITH UPPER RIGHT QUADRANT
\\circleurquad<Tab>                 <char-0x025F7>               " ◷          : WHITE CIRCLE WITH UPPER RIGHT QUADRANT
\\circleurquadb                     \\circleurquadb              "            : (Incomplete sequence)
\\circleurquadbl                    \\circleurquadbl             "            : (Incomplete sequence)
\\circleurquadbla                   \\circleurquadbla            "            : (Incomplete sequence)
\\circleurquadblac                  \\circleurquadblac           "            : (Incomplete sequence)
\\circleurquadblack                 <char-0x025D4>               " ◔          : CIRCLE WITH UPPER RIGHT QUADRANT BLACK
\\circlev                           \\circlev                    "            : (Incomplete sequence)
\\circleve                          \\circleve                   "            : (Incomplete sequence)
\\circlever                         \\circlever                  "            : (Incomplete sequence)
\\circlevert                        \\circlevert                 "            : (Incomplete sequence)
\\circlevertf                       \\circlevertf                "            : (Incomplete sequence)
\\circlevertfi                      \\circlevertfi               "            : (Incomplete sequence)
\\circlevertfil                     \\circlevertfil              "            : (Incomplete sequence)
\\circlevertfill                    <char-0x025CD>               " ◍          : CIRCLE WITH VERTICAL FILL
\\cirf                              \\cirf                       "            : (Incomplete sequence)
\\cirfb                             <char-0x025D2>               " ◒          : CIRCLE WITH LOWER HALF BLACK
\\cirfl                             <char-0x025D0>               " ◐          : CIRCLE WITH LEFT HALF BLACK
\\cirfn                             \\cirfn                      "            : (Incomplete sequence)
\\cirfni                            \\cirfni                     "            : (Incomplete sequence)
\\cirfnin                           \\cirfnin                    "            : (Incomplete sequence)
\\cirfnint                          <char-0x02A10>               " ⨐          : CIRCULATION FUNCTION
\\cirfr                             <char-0x025D1>               " ◑          : CIRCLE WITH RIGHT HALF BLACK
\\cl                                \\cl                         "            : (Incomplete sequence)
\\clo                               \\clo                        "            : (Incomplete sequence)
\\cloc                              \\cloc                       "            : (Incomplete sequence)
\\clock                             \\clock                      "            : (Incomplete sequence)
\\clocko                            \\clocko                     "            : (Incomplete sequence)
\\clockoi                           \\clockoi                    "            : (Incomplete sequence)
\\clockoin                          \\clockoin                   "            : (Incomplete sequence)
\\clockoint                         <char-0x02A0F>               " ⨏          : INTEGRAL AVERAGE WITH SLASH
\\clom                              \\clom                       "            : (Incomplete sequence)
\\clome                             \\clome                      "            : (Incomplete sequence)
\\clomeg                            <char-0x00277>               " ɷ          : LATIN SMALL LETTER CLOSED OMEGA
\\clos                              \\clos                       "            : (Incomplete sequence)
\\close                             \\close                      "            : (Incomplete sequence)
\\closed                            \\closed                     "            : (Incomplete sequence)
\\closedv                           \\closedv                    "            : (Incomplete sequence)
\\closedva                          \\closedva                   "            : (Incomplete sequence)
\\closedvar                         \\closedvar                  "            : (Incomplete sequence)
\\closedvarc                        \\closedvarc                 "            : (Incomplete sequence)
\\closedvarca                       \\closedvarca                "            : (Incomplete sequence)
\\closedvarcap                      <char-0x02A4D>               " ⩍          : CLOSED INTERSECTION WITH SERIFS
\\closedvarcu                       \\closedvarcu                "            : (Incomplete sequence)
\\closedvarcup                      <char-0x02A4C>               " ⩌          : CLOSED UNION WITH SERIFS
\\closedvarcup<Tab>                 <char-0x02A4C>               " ⩌          : CLOSED UNION WITH SERIFS
\\closedvarcups                     \\closedvarcups              "            : (Incomplete sequence)
\\closedvarcupsm                    \\closedvarcupsm             "            : (Incomplete sequence)
\\closedvarcupsma                   \\closedvarcupsma            "            : (Incomplete sequence)
\\closedvarcupsmas                  \\closedvarcupsmas           "            : (Incomplete sequence)
\\closedvarcupsmash                 \\closedvarcupsmash          "            : (Incomplete sequence)
\\closedvarcupsmashp                \\closedvarcupsmashp         "            : (Incomplete sequence)
\\closedvarcupsmashpr               \\closedvarcupsmashpr        "            : (Incomplete sequence)
\\closedvarcupsmashpro              \\closedvarcupsmashpro       "            : (Incomplete sequence)
\\closedvarcupsmashprod             <char-0x02A50>               " ⩐          : CLOSED UNION WITH SERIFS AND SMASH PRODUCT
\\clu                               \\clu                        "            : (Incomplete sequence)
\\club                              \\club                       "            : (Incomplete sequence)
\\clubs                             \\clubs                      "            : (Incomplete sequence)
\\clubsu                            \\clubsu                     "            : (Incomplete sequence)
\\clubsui                           \\clubsui                    "            : (Incomplete sequence)
\\clubsuit                          <char-0x02663>               " ♣          : BLACK CLUB SUIT
\\clw                               \\clw                        "            : (Incomplete sequence)
\\clwi                              \\clwi                       "            : (Incomplete sequence)
\\clwin                             \\clwin                      "            : (Incomplete sequence)
\\clwint                            \\clwint                     "            : (Incomplete sequence)
\\clwinte                           \\clwinte                    "            : (Incomplete sequence)
\\clwinteg                          \\clwinteg                   "            : (Incomplete sequence)
\\clwintegr                         \\clwintegr                  "            : (Incomplete sequence)
\\clwintegra                        \\clwintegra                 "            : (Incomplete sequence)
\\clwintegral                       <char-0x02231>               " ∱          : CLOCKWISE INTEGRAL
\\co                                \\co                         "            : (Incomplete sequence)
\\col                               \\col                        "            : (Incomplete sequence)
\\colo                              \\colo                       "            : (Incomplete sequence)
\\colon                             \\colon                      "            : (Incomplete sequence)
\\colone                            \\colone                     "            : (Incomplete sequence)
\\coloneq                           <char-0x02254>               " ≔          : COLON EQUALS / COLON EQUAL
\\com                               \\com                        "            : (Incomplete sequence)
\\comm                              \\comm                       "            : (Incomplete sequence)
\\comma                             \\comma                      "            : (Incomplete sequence)
\\commam                            \\commam                     "            : (Incomplete sequence)
\\commami                           \\commami                    "            : (Incomplete sequence)
\\commamin                          \\commamin                   "            : (Incomplete sequence)
\\commaminu                         \\commaminu                  "            : (Incomplete sequence)
\\commaminus                        <char-0x02A29>               " ⨩          : MINUS SIGN WITH COMMA ABOVE
\\comp                              \\comp                       "            : (Incomplete sequence)
\\compl                             \\compl                      "            : (Incomplete sequence)
\\comple                            \\comple                     "            : (Incomplete sequence)
\\complem                           \\complem                    "            : (Incomplete sequence)
\\compleme                          \\compleme                   "            : (Incomplete sequence)
\\complemen                         \\complemen                  "            : (Incomplete sequence)
\\complement                        <char-0x02201>               " ∁          : COMPLEMENT
\\con                               \\con                        "            : (Incomplete sequence)
\\cong                              <char-0x02245>               " ≅          : APPROXIMATELY EQUAL TO
\\cong<Tab>                         <char-0x02245>               " ≅          : APPROXIMATELY EQUAL TO
\\congd                             \\congd                      "            : (Incomplete sequence)
\\congdo                            \\congdo                     "            : (Incomplete sequence)
\\congdot                           <char-0x02A6D>               " ⩭          : CONGRUENT WITH DOT ABOVE
\\coni                              \\coni                       "            : (Incomplete sequence)
\\conic                             \\conic                      "            : (Incomplete sequence)
\\conict                            \\conict                     "            : (Incomplete sequence)
\\conicta                           \\conicta                    "            : (Incomplete sequence)
\\conictap                          \\conictap                   "            : (Incomplete sequence)
\\conictape                         \\conictape                  "            : (Incomplete sequence)
\\conictaper                        <char-0x02332>               " ⌲          : CONICAL TAPER
\\conj                              \\conj                       "            : (Incomplete sequence)
\\conjq                             \\conjq                      "            : (Incomplete sequence)
\\conjqu                            \\conjqu                     "            : (Incomplete sequence)
\\conjqua                           \\conjqua                    "            : (Incomplete sequence)
\\conjquan                          \\conjquan                   "            : (Incomplete sequence)
\\conjquant                         <char-0x02A07>               " ⨇          : TWO LOGICAL AND OPERATOR
\\cop                               \\cop                        "            : (Incomplete sequence)
\\copr                              \\copr                       "            : (Incomplete sequence)
\\copro                             \\copro                      "            : (Incomplete sequence)
\\coprod                            <char-0x02210>               " ∐          : N-ARY COPRODUCT
\\copy                              \\copy                       "            : (Incomplete sequence)
\\copyr                             \\copyr                      "            : (Incomplete sequence)
\\copyri                            \\copyri                     "            : (Incomplete sequence)
\\copyrig                           \\copyrig                    "            : (Incomplete sequence)
\\copyrigh                          \\copyrigh                   "            : (Incomplete sequence)
\\copyright                         <char-0x000A9>               " ©          : COPYRIGHT SIGN
\\cs                                \\cs                         "            : (Incomplete sequence)
\\csu                               \\csu                        "            : (Incomplete sequence)
\\csub                              <char-0x02ACF>               " ⫏          : CLOSED SUBSET
\\csub<Tab>                         <char-0x02ACF>               " ⫏          : CLOSED SUBSET
\\csube                             <char-0x02AD1>               " ⫑          : CLOSED SUBSET OR EQUAL TO
\\csup                              <char-0x02AD0>               " ⫐          : CLOSED SUPERSET
\\csup<Tab>                         <char-0x02AD0>               " ⫐          : CLOSED SUPERSET
\\csupe                             <char-0x02AD2>               " ⫒          : CLOSED SUPERSET OR EQUAL TO
\\cu                                \\cu                         "            : (Incomplete sequence)
\\cup                               <char-0x0222A>               " ∪          : UNION
\\cup<Tab>                          <char-0x0222A>               " ∪          : UNION
\\cupd                              \\cupd                       "            : (Incomplete sequence)
\\cupdo                             \\cupdo                      "            : (Incomplete sequence)
\\cupdot                            <char-0x0228D>               " ⊍          : MULTISET MULTIPLICATION
\\cupv                              \\cupv                       "            : (Incomplete sequence)
\\cupve                             \\cupve                      "            : (Incomplete sequence)
\\cupvee                            <char-0x02A45>               " ⩅          : UNION WITH LOGICAL OR
\\cur                               \\cur                        "            : (Incomplete sequence)
\\curl                              \\curl                       "            : (Incomplete sequence)
\\curly                             \\curly                      "            : (Incomplete sequence)
\\curlye                            \\curlye                     "            : (Incomplete sequence)
\\curlyeq                           \\curlyeq                    "            : (Incomplete sequence)
\\curlyeqp                          \\curlyeqp                   "            : (Incomplete sequence)
\\curlyeqpr                         \\curlyeqpr                  "            : (Incomplete sequence)
\\curlyeqpre                        \\curlyeqpre                 "            : (Incomplete sequence)
\\curlyeqprec                       <char-0x022DE>               " ⋞          : EQUAL TO OR PRECEDES
\\curlyeqs                          \\curlyeqs                   "            : (Incomplete sequence)
\\curlyeqsu                         \\curlyeqsu                  "            : (Incomplete sequence)
\\curlyeqsuc                        \\curlyeqsuc                 "            : (Incomplete sequence)
\\curlyeqsucc                       <char-0x022DF>               " ⋟          : EQUAL TO OR SUCCEEDS
\\curlyv                            \\curlyv                     "            : (Incomplete sequence)
\\curlyve                           \\curlyve                    "            : (Incomplete sequence)
\\curlyvee                          <char-0x022CE>               " ⋎          : CURLY LOGICAL OR
\\curlyw                            \\curlyw                     "            : (Incomplete sequence)
\\curlywe                           \\curlywe                    "            : (Incomplete sequence)
\\curlywed                          \\curlywed                   "            : (Incomplete sequence)
\\curlywedg                         \\curlywedg                  "            : (Incomplete sequence)
\\curlywedge                        <char-0x022CF>               " ⋏          : CURLY LOGICAL AND
\\curv                              \\curv                       "            : (Incomplete sequence)
\\curve                             \\curve                      "            : (Incomplete sequence)
\\curvea                            \\curvea                     "            : (Incomplete sequence)
\\curvear                           \\curvear                    "            : (Incomplete sequence)
\\curvearr                          \\curvearr                   "            : (Incomplete sequence)
\\curvearro                         \\curvearro                  "            : (Incomplete sequence)
\\curvearrow                        \\curvearrow                 "            : (Incomplete sequence)
\\curvearrowl                       \\curvearrowl                "            : (Incomplete sequence)
\\curvearrowle                      \\curvearrowle               "            : (Incomplete sequence)
\\curvearrowlef                     \\curvearrowlef              "            : (Incomplete sequence)
\\curvearrowleft                    <char-0x021B6>               " ↶          : ANTICLOCKWISE TOP SEMICIRCLE ARROW
\\curvearrowr                       \\curvearrowr                "            : (Incomplete sequence)
\\curvearrowri                      \\curvearrowri               "            : (Incomplete sequence)
\\curvearrowrig                     \\curvearrowrig              "            : (Incomplete sequence)
\\curvearrowrigh                    \\curvearrowrigh             "            : (Incomplete sequence)
\\curvearrowright                   <char-0x021B7>               " ↷          : CLOCKWISE TOP SEMICIRCLE ARROW
\\dagger                            <char-0x02020>               " †          : DAGGER
\\daleth                            <char-0x02138>               " ℸ          : DALET SYMBOL / FOURTH TRANSFINITE CARDINAL
\\danger                            <char-0x02621>               " ☡          : CAUTION SIGN
\\dashV                             <char-0x02AE3>               " ⫣          : DOUBLE VERTICAL BAR LEFT TURNSTILE
\\dashleftharpoondown               <char-0x0296B>               " ⥫          : LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
\\dashrightharpoondown              <char-0x0296D>               " ⥭          : RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
\\dashv                             <char-0x022A3>               " ⊣          : LEFT TACK
\\dbkarow                           <char-0x0290F>               " ⤏          : RIGHTWARDS TRIPLE DASH ARROW
\\dblarrowupdown                    <char-0x021C5>               " ⇅          : UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW / UP ARROW LEFT OF DOWN ARROW
\\ddagger                           <char-0x02021>               " ‡          : DOUBLE DAGGER
\\ddddot                            <char-0x020DC>               " ◌⃜         : COMBINING FOUR DOTS ABOVE / NON-SPACING FOUR DOTS ABOVE
\\dddot                             <char-0x020DB>               " ◌⃛         : COMBINING THREE DOTS ABOVE / NON-SPACING THREE DOTS ABOVE
\\ddfnc                             <char-0x02999>               " ⦙          : DOTTED FENCE
\\ddot                              <char-0x00308>               " ◌̈         : COMBINING DIAERESIS / NON-SPACING DIAERESIS
\\ddot<Tab>                         <char-0x00308>               " ◌̈         : COMBINING DIAERESIS / NON-SPACING DIAERESIS
\\ddots                             <char-0x022F1>               " ⋱          : DOWN RIGHT DIAGONAL ELLIPSIS
\\ddots<Tab>                        <char-0x022F1>               " ⋱          : DOWN RIGHT DIAGONAL ELLIPSIS
\\ddotse                            \\ddotse                     "            : (Incomplete sequence)
\\ddotseq                           <char-0x02A77>               " ⩷          : EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
\\defas                             <char-0x029CB>               " ⧋          : TRIANGLE WITH UNDERBAR
\\degree                            <char-0x000B0>               " °          : DEGREE SIGN
\\del                               <char-0x02207>               " ∇          : NABLA
\\del<Tab>                          <char-0x02207>               " ∇          : NABLA
\\delt                              \\delt                       "            : (Incomplete sequence)
\\delta                             <char-0x003B4>               " δ          : GREEK SMALL LETTER DELTA
\\dh                                <char-0x000F0>               " ð          : LATIN SMALL LETTER ETH
\\diagdown                          <char-0x02572>               " ╲          : BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT / FORMS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
\\diagup                            <char-0x02571>               " ╱          : BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT / FORMS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
\\diameter                          <char-0x02300>               " ⌀          : DIAMETER SIGN
\\diamond                           <char-0x022C4>               " ⋄          : DIAMOND OPERATOR
\\diamond<Tab>                      <char-0x022C4>               " ⋄          : DIAMOND OPERATOR
\\diamondb                          \\diamondb                   "            : (Incomplete sequence)
\\diamondbo                         \\diamondbo                  "            : (Incomplete sequence)
\\diamondbot                        \\diamondbot                 "            : (Incomplete sequence)
\\diamondbotb                       \\diamondbotb                "            : (Incomplete sequence)
\\diamondbotbl                      \\diamondbotbl               "            : (Incomplete sequence)
\\diamondbotbla                     \\diamondbotbla              "            : (Incomplete sequence)
\\diamondbotblac                    \\diamondbotblac             "            : (Incomplete sequence)
\\diamondbotblack                   <char-0x02B19>               " ⬙          : DIAMOND WITH BOTTOM HALF BLACK
\\diamondl                          \\diamondl                   "            : (Incomplete sequence)
\\diamondle                         \\diamondle                  "            : (Incomplete sequence)
\\diamondlef                        \\diamondlef                 "            : (Incomplete sequence)
\\diamondleft                       \\diamondleft                "            : (Incomplete sequence)
\\diamondlefta                      \\diamondlefta               "            : (Incomplete sequence)
\\diamondleftar                     \\diamondleftar              "            : (Incomplete sequence)
\\diamondleftarr                    \\diamondleftarr             "            : (Incomplete sequence)
\\diamondleftarro                   \\diamondleftarro            "            : (Incomplete sequence)
\\diamondleftarrow                  <char-0x0291D>               " ⤝          : LEFTWARDS ARROW TO BLACK DIAMOND
\\diamondleftarrow<Tab>             <char-0x0291D>               " ⤝          : LEFTWARDS ARROW TO BLACK DIAMOND
\\diamondleftarrowb                 \\diamondleftarrowb          "            : (Incomplete sequence)
\\diamondleftarrowba                \\diamondleftarrowba         "            : (Incomplete sequence)
\\diamondleftarrowbar               <char-0x0291F>               " ⤟          : LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
\\diamondleftb                      \\diamondleftb               "            : (Incomplete sequence)
\\diamondleftbl                     \\diamondleftbl              "            : (Incomplete sequence)
\\diamondleftbla                    \\diamondleftbla             "            : (Incomplete sequence)
\\diamondleftblac                   \\diamondleftblac            "            : (Incomplete sequence)
\\diamondleftblack                  <char-0x02B16>               " ⬖          : DIAMOND WITH LEFT HALF BLACK
\\diamondr                          \\diamondr                   "            : (Incomplete sequence)
\\diamondri                         \\diamondri                  "            : (Incomplete sequence)
\\diamondrig                        \\diamondrig                 "            : (Incomplete sequence)
\\diamondrigh                       \\diamondrigh                "            : (Incomplete sequence)
\\diamondright                      \\diamondright               "            : (Incomplete sequence)
\\diamondrightb                     \\diamondrightb              "            : (Incomplete sequence)
\\diamondrightbl                    \\diamondrightbl             "            : (Incomplete sequence)
\\diamondrightbla                   \\diamondrightbla            "            : (Incomplete sequence)
\\diamondrightblac                  \\diamondrightblac           "            : (Incomplete sequence)
\\diamondrightblack                 <char-0x02B17>               " ⬗          : DIAMOND WITH RIGHT HALF BLACK
\\diamonds                          \\diamonds                   "            : (Incomplete sequence)
\\diamondsu                         \\diamondsu                  "            : (Incomplete sequence)
\\diamondsui                        \\diamondsui                 "            : (Incomplete sequence)
\\diamondsuit                       <char-0x02662>               " ♢          : WHITE DIAMOND SUIT
\\diamondt                          \\diamondt                   "            : (Incomplete sequence)
\\diamondto                         \\diamondto                  "            : (Incomplete sequence)
\\diamondtop                        \\diamondtop                 "            : (Incomplete sequence)
\\diamondtopb                       \\diamondtopb                "            : (Incomplete sequence)
\\diamondtopbl                      \\diamondtopbl               "            : (Incomplete sequence)
\\diamondtopbla                     \\diamondtopbla              "            : (Incomplete sequence)
\\diamondtopblac                    \\diamondtopblac             "            : (Incomplete sequence)
\\diamondtopblack                   <char-0x02B18>               " ⬘          : DIAMOND WITH TOP HALF BLACK
\\dicei                             <char-0x02680>               " ⚀          : DIE FACE-1
\\dicei<Tab>                        <char-0x02680>               " ⚀          : DIE FACE-1
\\diceii                            <char-0x02681>               " ⚁          : DIE FACE-2
\\diceii<Tab>                       <char-0x02681>               " ⚁          : DIE FACE-2
\\diceiii                           <char-0x02682>               " ⚂          : DIE FACE-3
\\diceiv                            <char-0x02683>               " ⚃          : DIE FACE-4
\\dicev                             <char-0x02684>               " ⚄          : DIE FACE-5
\\dicev<Tab>                        <char-0x02684>               " ⚄          : DIE FACE-5
\\dicevi                            <char-0x02685>               " ⚅          : DIE FACE-6
\\digamma                           <char-0x003DD>               " ϝ          : GREEK SMALL LETTER DIGAMMA
\\dingasterisk                      <char-0x0273D>               " ✽          : HEAVY TEARDROP-SPOKED ASTERISK
\\disin                             <char-0x022F2>               " ⋲          : ELEMENT OF WITH LONG HORIZONTAL STROKE
\\disjquant                         <char-0x02A08>               " ⨈          : TWO LOGICAL OR OPERATOR
\\div                               <char-0x000F7>               " ÷          : DIVISION SIGN
\\div<Tab>                          <char-0x000F7>               " ÷          : DIVISION SIGN
\\divi                              \\divi                       "            : (Incomplete sequence)
\\divid                             \\divid                      "            : (Incomplete sequence)
\\divide                            \\divide                     "            : (Incomplete sequence)
\\divideo                           \\divideo                    "            : (Incomplete sequence)
\\divideon                          \\divideon                   "            : (Incomplete sequence)
\\divideont                         \\divideont                  "            : (Incomplete sequence)
\\divideonti                        \\divideonti                 "            : (Incomplete sequence)
\\divideontim                       \\divideontim                "            : (Incomplete sequence)
\\divideontime                      \\divideontime               "            : (Incomplete sequence)
\\divideontimes                     <char-0x022C7>               " ⋇          : DIVISION TIMES
\\dj                                <char-0x00111>               " đ          : LATIN SMALL LETTER D WITH STROKE / LATIN SMALL LETTER D BAR
\\dlcorn                            <char-0x023A3>               " ⎣          : LEFT SQUARE BRACKET LOWER CORNER
\\dot                               <char-0x00307>               " ◌̇         : COMBINING DOT ABOVE / NON-SPACING DOT ABOVE
\\dot<Tab>                          <char-0x00307>               " ◌̇         : COMBINING DOT ABOVE / NON-SPACING DOT ABOVE
\\dote                              \\dote                       "            : (Incomplete sequence)
\\doteq                             <char-0x02250>               " ≐          : APPROACHES THE LIMIT
\\doteq<Tab>                        <char-0x02250>               " ≐          : APPROACHES THE LIMIT
\\dotequ                            \\dotequ                     "            : (Incomplete sequence)
\\dotequi                           \\dotequi                    "            : (Incomplete sequence)
\\dotequiv                          <char-0x02A67>               " ⩧          : IDENTICAL WITH DOT ABOVE
\\dotm                              \\dotm                       "            : (Incomplete sequence)
\\dotmi                             \\dotmi                      "            : (Incomplete sequence)
\\dotmin                            \\dotmin                     "            : (Incomplete sequence)
\\dotminu                           \\dotminu                    "            : (Incomplete sequence)
\\dotminus                          <char-0x02238>               " ∸          : DOT MINUS
\\dotp                              \\dotp                       "            : (Incomplete sequence)
\\dotpl                             \\dotpl                      "            : (Incomplete sequence)
\\dotplu                            \\dotplu                     "            : (Incomplete sequence)
\\dotplus                           <char-0x02214>               " ∔          : DOT PLUS
\\dots                              <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\dots<Tab>                         <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\dotsi                             \\dotsi                      "            : (Incomplete sequence)
\\dotsim                            <char-0x02A6A>               " ⩪          : TILDE OPERATOR WITH DOT ABOVE
\\dotsm                             \\dotsm                      "            : (Incomplete sequence)
\\dotsmi                            \\dotsmi                     "            : (Incomplete sequence)
\\dotsmin                           \\dotsmin                    "            : (Incomplete sequence)
\\dotsminu                          \\dotsminu                   "            : (Incomplete sequence)
\\dotsminus                         \\dotsminus                  "            : (Incomplete sequence)
\\dotsminusd                        \\dotsminusd                 "            : (Incomplete sequence)
\\dotsminusdo                       \\dotsminusdo                "            : (Incomplete sequence)
\\dotsminusdot                      \\dotsminusdot               "            : (Incomplete sequence)
\\dotsminusdots                     <char-0x0223A>               " ∺          : GEOMETRIC PROPORTION
\\dott                              \\dott                       "            : (Incomplete sequence)
\\dotte                             \\dotte                      "            : (Incomplete sequence)
\\dotted                            \\dotted                     "            : (Incomplete sequence)
\\dottedc                           \\dottedc                    "            : (Incomplete sequence)
\\dottedci                          \\dottedci                   "            : (Incomplete sequence)
\\dottedcir                         \\dottedcir                  "            : (Incomplete sequence)
\\dottedcirc                        \\dottedcirc                 "            : (Incomplete sequence)
\\dottedcircl                       \\dottedcircl                "            : (Incomplete sequence)
\\dottedcircle                      <char-0x025CC>               " ◌          : DOTTED CIRCLE
\\dotteds                           \\dotteds                    "            : (Incomplete sequence)
\\dottedsq                          \\dottedsq                   "            : (Incomplete sequence)
\\dottedsqu                         \\dottedsqu                  "            : (Incomplete sequence)
\\dottedsqua                        \\dottedsqua                 "            : (Incomplete sequence)
\\dottedsquar                       \\dottedsquar                "            : (Incomplete sequence)
\\dottedsquare                      <char-0x02B1A>               " ⬚          : DOTTED SQUARE
\\dotti                             \\dotti                      "            : (Incomplete sequence)
\\dottim                            \\dottim                     "            : (Incomplete sequence)
\\dottime                           \\dottime                    "            : (Incomplete sequence)
\\dottimes                          <char-0x02A30>               " ⨰          : MULTIPLICATION SIGN WITH DOT ABOVE
\\doublebarvee                      <char-0x02A62>               " ⩢          : LOGICAL OR WITH DOUBLE OVERBAR
\\doublepipe                        <char-0x001C2>               " ǂ          : LATIN LETTER ALVEOLAR CLICK / LATIN LETTER PIPE DOUBLE BAR
\\doubleplus                        <char-0x029FA>               " ⧺          : DOUBLE PLUS
\\downarrow                         <char-0x02193>               " ↓          : DOWNWARDS ARROW / DOWN ARROW
\\downarrow<Tab>                    <char-0x02193>               " ↓          : DOWNWARDS ARROW / DOWN ARROW
\\downarrowb                        \\downarrowb                 "            : (Incomplete sequence)
\\downarrowba                       \\downarrowba                "            : (Incomplete sequence)
\\downarrowbar                      \\downarrowbar               "            : (Incomplete sequence)
\\downarrowbarr                     \\downarrowbarr              "            : (Incomplete sequence)
\\downarrowbarre                    \\downarrowbarre             "            : (Incomplete sequence)
\\downarrowbarred                   <char-0x02908>               " ⤈          : DOWNWARDS ARROW WITH HORIZONTAL STROKE
\\downdasharrow                     <char-0x021E3>               " ⇣          : DOWNWARDS DASHED ARROW / DOWN DASHED ARROW
\\downdownarrows                    <char-0x021CA>               " ⇊          : DOWNWARDS PAIRED ARROWS / DOWN PAIRED ARROWS
\\downharpoonleft                   <char-0x021C3>               " ⇃          : DOWNWARDS HARPOON WITH BARB LEFTWARDS / DOWN HARPOON WITH BARB LEFT
\\downharpoonright                  <char-0x021C2>               " ⇂          : DOWNWARDS HARPOON WITH BARB RIGHTWARDS / DOWN HARPOON WITH BARB RIGHT
\\downharpoonsleftright             <char-0x02965>               " ⥥          : DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
\\downwhitearrow                    <char-0x021E9>               " ⇩          : DOWNWARDS WHITE ARROW / WHITE DOWN ARROW
\\downzigzagarrow                   <char-0x021AF>               " ↯          : DOWNWARDS ZIGZAG ARROW / DOWN ZIGZAG ARROW
\\draftingarrow                     <char-0x0279B>               " ➛          : DRAFTING POINT RIGHTWARDS ARROW / DRAFTING POINT RIGHT ARROW
\\drbkarrow                         <char-0x02910>               " ⤐          : RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
\\droang                            <char-0x0031A>               " ◌̚         : COMBINING LEFT ANGLE ABOVE / NON-SPACING LEFT ANGLE ABOVE
\\dshfnc                            <char-0x02506>               " ┆          : BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL / FORMS LIGHT TRIPLE DASH VERTICAL
\\dsol                              <char-0x029F6>               " ⧶          : SOLIDUS WITH OVERBAR
\\dualmap                           <char-0x029DF>               " ⧟          : DOUBLE-ENDED MULTIMAP
\\dyogh                             <char-0x002A4>               " ʤ          : LATIN SMALL LETTER DEZH DIGRAPH / LATIN SMALL LETTER D YOGH
\\egsdot                            <char-0x02A98>               " ⪘          : SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
\\eighthnote                        <char-0x0266A>               " ♪          : EIGHTH NOTE
\\elinters                          <char-0x023E7>               " ⏧          : ELECTRICAL INTERSECTION
\\ell                               <char-0x02113>               " ℓ          : SCRIPT SMALL L
\\elsdot                            <char-0x02A97>               " ⪗          : SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
\\emdash                            <char-0x02014>               " —          : EM DASH
\\emptyset                          <char-0x02205>               " ∅          : EMPTY SET
\\emptyset<Tab>                     <char-0x02205>               " ∅          : EMPTY SET
\\emptyseto                         \\emptyseto                  "            : (Incomplete sequence)
\\emptysetoa                        \\emptysetoa                 "            : (Incomplete sequence)
\\emptysetoar                       \\emptysetoar                "            : (Incomplete sequence)
\\emptysetoarr                      <char-0x029B3>               " ⦳          : EMPTY SET WITH RIGHT ARROW ABOVE
\\emptysetoarr<Tab>                 <char-0x029B3>               " ⦳          : EMPTY SET WITH RIGHT ARROW ABOVE
\\emptysetoarrl                     <char-0x029B4>               " ⦴          : EMPTY SET WITH LEFT ARROW ABOVE
\\emptysetob                        \\emptysetob                 "            : (Incomplete sequence)
\\emptysetoba                       \\emptysetoba                "            : (Incomplete sequence)
\\emptysetobar                      <char-0x029B1>               " ⦱          : EMPTY SET WITH OVERBAR
\\emptysetoc                        \\emptysetoc                 "            : (Incomplete sequence)
\\emptysetoci                       \\emptysetoci                "            : (Incomplete sequence)
\\emptysetocir                      \\emptysetocir               "            : (Incomplete sequence)
\\emptysetocirc                     <char-0x029B2>               " ⦲          : EMPTY SET WITH SMALL CIRCLE ABOVE
\\enclosecircle                     <char-0x020DD>               " ◌⃝         : COMBINING ENCLOSING CIRCLE / ENCLOSING CIRCLE
\\enclosediamond                    <char-0x020DF>               " ◌⃟         : COMBINING ENCLOSING DIAMOND / ENCLOSING DIAMOND
\\enclosesquare                     <char-0x020DE>               " ◌⃞         : COMBINING ENCLOSING SQUARE / ENCLOSING SQUARE
\\enclosetriangle                   <char-0x020E4>               " ◌⃤         : COMBINING ENCLOSING UPWARD POINTING TRIANGLE
\\endash                            <char-0x02013>               " –          : EN DASH
\\enspace                           <char-0x02002>               "            : EN SPACE
\\eparsl                            <char-0x029E3>               " ⧣          : EQUALS SIGN AND SLANTED PARALLEL
\\epsilon                           <char-0x003F5>               " ϵ          : GREEK LUNATE EPSILON SYMBOL
\\eqcirc                            <char-0x02256>               " ≖          : RING IN EQUAL TO
\\eqcolon                           <char-0x02255>               " ≕          : EQUALS COLON / EQUAL COLON
\\eqdef                             <char-0x0225D>               " ≝          : EQUAL TO BY DEFINITION
\\eqdot                             <char-0x02A66>               " ⩦          : EQUALS SIGN WITH DOT BELOW
\\eqeqeq                            <char-0x02A76>               " ⩶          : THREE CONSECUTIVE EQUALS SIGNS
\\eqgtr                             <char-0x022DD>               " ⋝          : EQUAL TO OR GREATER-THAN / EQUAL TO OR GREATER THAN
\\eqless                            <char-0x022DC>               " ⋜          : EQUAL TO OR LESS-THAN / EQUAL TO OR LESS THAN
\\eqqgtr                            <char-0x02A9A>               " ⪚          : DOUBLE-LINE EQUAL TO OR GREATER-THAN
\\eqqless                           <char-0x02A99>               " ⪙          : DOUBLE-LINE EQUAL TO OR LESS-THAN
\\eqqplus                           <char-0x02A71>               " ⩱          : EQUALS SIGN ABOVE PLUS SIGN
\\eqqsim                            <char-0x02A73>               " ⩳          : EQUALS SIGN ABOVE TILDE OPERATOR
\\eqqslantgtr                       <char-0x02A9C>               " ⪜          : DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN
\\eqqslantless                      <char-0x02A9B>               " ⪛          : DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN
\\eqsim                             <char-0x02242>               " ≂          : MINUS TILDE
\\eqslantgtr                        <char-0x02A96>               " ⪖          : SLANTED EQUAL TO OR GREATER-THAN
\\eqslantless                       <char-0x02A95>               " ⪕          : SLANTED EQUAL TO OR LESS-THAN
\\equalleftarrow                    <char-0x02B40>               " ⭀          : EQUALS SIGN ABOVE LEFTWARDS ARROW
\\equalparallel                     <char-0x022D5>               " ⋕          : EQUAL AND PARALLEL TO
\\equiv                             <char-0x02261>               " ≡          : IDENTICAL TO
\\equiv<Tab>                        <char-0x02261>               " ≡          : IDENTICAL TO
\\equivD                            \\equivD                     "            : (Incomplete sequence)
\\equivDD                           <char-0x02A78>               " ⩸          : EQUIVALENT WITH FOUR DOTS ABOVE
\\eqvparsl                          <char-0x029E5>               " ⧥          : IDENTICAL TO AND SLANTED PARALLEL
\\esh                               <char-0x00283>               " ʃ          : LATIN SMALL LETTER ESH
\\eta                               <char-0x003B7>               " η          : GREEK SMALL LETTER ETA
\\eth                               <char-0x000F0>               " ð          : LATIN SMALL LETTER ETH
\\euler                             <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\euler<Tab>                        <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\eulerm                            \\eulerm                     "            : (Incomplete sequence)
\\eulerma                           \\eulerma                    "            : (Incomplete sequence)
\\eulermas                          \\eulermas                   "            : (Incomplete sequence)
\\eulermasc                         \\eulermasc                  "            : (Incomplete sequence)
\\eulermasch                        \\eulermasch                 "            : (Incomplete sequence)
\\eulermasche                       \\eulermasche                "            : (Incomplete sequence)
\\eulermascher                      \\eulermascher               "            : (Incomplete sequence)
\\eulermaschero                     \\eulermaschero              "            : (Incomplete sequence)
\\eulermascheron                    \\eulermascheron             "            : (Incomplete sequence)
\\eulermascheroni                   <char-0x02107>               " ℇ          : EULER CONSTANT / EULERS
\\euro                              <char-0x020AC>               " €          : EURO SIGN
\\exclamdown                        <char-0x000A1>               " ¡          : INVERTED EXCLAMATION MARK
\\exists                            <char-0x02203>               " ∃          : THERE EXISTS
\\fallingdotseq                     <char-0x02252>               " ≒          : APPROXIMATELY EQUAL TO OR THE IMAGE OF
\\fdiagovnearrow                    <char-0x0292F>               " ⤯          : FALLING DIAGONAL CROSSING NORTH EAST ARROW
\\fdiagovrdiag                      <char-0x0292C>               " ⤬          : FALLING DIAGONAL CROSSING RISING DIAGONAL
\\female                            <char-0x02640>               " ♀          : FEMALE SIGN
\\fhr                               <char-0x0027E>               " ɾ          : LATIN SMALL LETTER R WITH FISHHOOK / LATIN SMALL LETTER FISHHOOK R
\\fisheye                           <char-0x025C9>               " ◉          : FISHEYE
\\flat                              <char-0x0266D>               " ♭          : MUSIC FLAT SIGN / FLAT
\\fltns                             <char-0x023E5>               " ⏥          : FLATNESS
\\forall                            <char-0x02200>               " ∀          : FOR ALL
\\forks                             <char-0x02ADC>               " ⫝̸          : FORKING
\\forks<Tab>                        <char-0x02ADC>               " ⫝̸          : FORKING
\\forksn                            \\forksn                     "            : (Incomplete sequence)
\\forksno                           \\forksno                    "            : (Incomplete sequence)
\\forksnot                          <char-0x02ADD>               " ⫝          : NONFORKING
\\forkv                             <char-0x02AD9>               " ⫙          : ELEMENT OF OPENING DOWNWARDS
\\fourthroot                        <char-0x0221C>               " ∜          : FOURTH ROOT
\\frakA                             <char-0x1D504>               " 𝔄          : MATHEMATICAL FRAKTUR CAPITAL A
\\frakB                             <char-0x1D505>               " 𝔅          : MATHEMATICAL FRAKTUR CAPITAL B
\\frakC                             <char-0x0212D>               " ℭ          : BLACK-LETTER CAPITAL C / BLACK-LETTER C
\\frakD                             <char-0x1D507>               " 𝔇          : MATHEMATICAL FRAKTUR CAPITAL D
\\frakE                             <char-0x1D508>               " 𝔈          : MATHEMATICAL FRAKTUR CAPITAL E
\\frakF                             <char-0x1D509>               " 𝔉          : MATHEMATICAL FRAKTUR CAPITAL F
\\frakG                             <char-0x1D50A>               " 𝔊          : MATHEMATICAL FRAKTUR CAPITAL G
\\frakH                             <char-0x0210C>               " ℌ          : BLACK-LETTER CAPITAL H / BLACK-LETTER H
\\frakJ                             <char-0x1D50D>               " 𝔍          : MATHEMATICAL FRAKTUR CAPITAL J
\\frakK                             <char-0x1D50E>               " 𝔎          : MATHEMATICAL FRAKTUR CAPITAL K
\\frakL                             <char-0x1D50F>               " 𝔏          : MATHEMATICAL FRAKTUR CAPITAL L
\\frakM                             <char-0x1D510>               " 𝔐          : MATHEMATICAL FRAKTUR CAPITAL M
\\frakN                             <char-0x1D511>               " 𝔑          : MATHEMATICAL FRAKTUR CAPITAL N
\\frakO                             <char-0x1D512>               " 𝔒          : MATHEMATICAL FRAKTUR CAPITAL O
\\frakP                             <char-0x1D513>               " 𝔓          : MATHEMATICAL FRAKTUR CAPITAL P
\\frakQ                             <char-0x1D514>               " 𝔔          : MATHEMATICAL FRAKTUR CAPITAL Q
\\frakS                             <char-0x1D516>               " 𝔖          : MATHEMATICAL FRAKTUR CAPITAL S
\\frakT                             <char-0x1D517>               " 𝔗          : MATHEMATICAL FRAKTUR CAPITAL T
\\frakU                             <char-0x1D518>               " 𝔘          : MATHEMATICAL FRAKTUR CAPITAL U
\\frakV                             <char-0x1D519>               " 𝔙          : MATHEMATICAL FRAKTUR CAPITAL V
\\frakW                             <char-0x1D51A>               " 𝔚          : MATHEMATICAL FRAKTUR CAPITAL W
\\frakX                             <char-0x1D51B>               " 𝔛          : MATHEMATICAL FRAKTUR CAPITAL X
\\frakY                             <char-0x1D51C>               " 𝔜          : MATHEMATICAL FRAKTUR CAPITAL Y
\\frakZ                             <char-0x02128>               " ℨ          : BLACK-LETTER CAPITAL Z / BLACK-LETTER Z
\\fraka                             <char-0x1D51E>               " 𝔞          : MATHEMATICAL FRAKTUR SMALL A
\\frakb                             <char-0x1D51F>               " 𝔟          : MATHEMATICAL FRAKTUR SMALL B
\\frakc                             <char-0x1D520>               " 𝔠          : MATHEMATICAL FRAKTUR SMALL C
\\frakd                             <char-0x1D521>               " 𝔡          : MATHEMATICAL FRAKTUR SMALL D
\\frake                             <char-0x1D522>               " 𝔢          : MATHEMATICAL FRAKTUR SMALL E
\\frakf                             <char-0x1D523>               " 𝔣          : MATHEMATICAL FRAKTUR SMALL F
\\frakg                             <char-0x1D524>               " 𝔤          : MATHEMATICAL FRAKTUR SMALL G
\\frakh                             <char-0x1D525>               " 𝔥          : MATHEMATICAL FRAKTUR SMALL H
\\fraki                             <char-0x1D526>               " 𝔦          : MATHEMATICAL FRAKTUR SMALL I
\\frakj                             <char-0x1D527>               " 𝔧          : MATHEMATICAL FRAKTUR SMALL J
\\frakk                             <char-0x1D528>               " 𝔨          : MATHEMATICAL FRAKTUR SMALL K
\\frakl                             <char-0x1D529>               " 𝔩          : MATHEMATICAL FRAKTUR SMALL L
\\frakm                             <char-0x1D52A>               " 𝔪          : MATHEMATICAL FRAKTUR SMALL M
\\frakn                             <char-0x1D52B>               " 𝔫          : MATHEMATICAL FRAKTUR SMALL N
\\frako                             <char-0x1D52C>               " 𝔬          : MATHEMATICAL FRAKTUR SMALL O
\\frakp                             <char-0x1D52D>               " 𝔭          : MATHEMATICAL FRAKTUR SMALL P
\\frakq                             <char-0x1D52E>               " 𝔮          : MATHEMATICAL FRAKTUR SMALL Q
\\frakr                             <char-0x1D52F>               " 𝔯          : MATHEMATICAL FRAKTUR SMALL R
\\fraks                             <char-0x1D530>               " 𝔰          : MATHEMATICAL FRAKTUR SMALL S
\\frakt                             <char-0x1D531>               " 𝔱          : MATHEMATICAL FRAKTUR SMALL T
\\fraku                             <char-0x1D532>               " 𝔲          : MATHEMATICAL FRAKTUR SMALL U
\\frakv                             <char-0x1D533>               " 𝔳          : MATHEMATICAL FRAKTUR SMALL V
\\frakw                             <char-0x1D534>               " 𝔴          : MATHEMATICAL FRAKTUR SMALL W
\\frakx                             <char-0x1D535>               " 𝔵          : MATHEMATICAL FRAKTUR SMALL X
\\fraky                             <char-0x1D536>               " 𝔶          : MATHEMATICAL FRAKTUR SMALL Y
\\frakz                             <char-0x1D537>               " 𝔷          : MATHEMATICAL FRAKTUR SMALL Z
\\frown                             <char-0x02322>               " ⌢          : FROWN
\\fullouterjoin                     <char-0x027D7>               " ⟗          : FULL OUTER JOIN
\\gamma                             <char-0x003B3>               " γ          : GREEK SMALL LETTER GAMMA
\\ge                                <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\ge<Tab>                           <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\gem                               \\gem                        "            : (Incomplete sequence)
\\gemi                              \\gemi                       "            : (Incomplete sequence)
\\gemin                             \\gemin                      "            : (Incomplete sequence)
\\gemini                            <char-0x0264A>               " ♊          : GEMINI
\\geq                               \\geq                        "            : (Incomplete sequence)
\\geqq                              <char-0x02267>               " ≧          : GREATER-THAN OVER EQUAL TO / GREATER THAN OVER EQUAL TO
\\geqq<Tab>                         <char-0x02267>               " ≧          : GREATER-THAN OVER EQUAL TO / GREATER THAN OVER EQUAL TO
\\geqqs                             \\geqqs                      "            : (Incomplete sequence)
\\geqqsl                            \\geqqsl                     "            : (Incomplete sequence)
\\geqqsla                           \\geqqsla                    "            : (Incomplete sequence)
\\geqqslan                          \\geqqslan                   "            : (Incomplete sequence)
\\geqqslant                         <char-0x02AFA>               " ⫺          : DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO
\\geqs                              \\geqs                       "            : (Incomplete sequence)
\\geqsl                             \\geqsl                      "            : (Incomplete sequence)
\\geqsla                            \\geqsla                     "            : (Incomplete sequence)
\\geqslan                           \\geqslan                    "            : (Incomplete sequence)
\\geqslant                          <char-0x02A7E>               " ⩾          : GREATER-THAN OR SLANTED EQUAL TO
\\ges                               \\ges                        "            : (Incomplete sequence)
\\gesc                              \\gesc                       "            : (Incomplete sequence)
\\gescc                             <char-0x02AA9>               " ⪩          : GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
\\gesd                              \\gesd                       "            : (Incomplete sequence)
\\gesdo                             \\gesdo                      "            : (Incomplete sequence)
\\gesdot                            <char-0x02A80>               " ⪀          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\gesdot<Tab>                       <char-0x02A80>               " ⪀          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\gesdoto                           <char-0x02A82>               " ⪂          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\gesdoto<Tab>                      <char-0x02A82>               " ⪂          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\gesdotol                          <char-0x02A84>               " ⪄          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
\\gesl                              \\gesl                       "            : (Incomplete sequence)
\\gesle                             \\gesle                      "            : (Incomplete sequence)
\\gesles                            <char-0x02A94>               " ⪔          : GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
\\gg                                <char-0x0226B>               " ≫          : MUCH GREATER-THAN / MUCH GREATER THAN
\\gg<Tab>                           <char-0x0226B>               " ≫          : MUCH GREATER-THAN / MUCH GREATER THAN
\\ggg                               <char-0x022D9>               " ⋙          : VERY MUCH GREATER-THAN / VERY MUCH GREATER THAN
\\ggg<Tab>                          <char-0x022D9>               " ⋙          : VERY MUCH GREATER-THAN / VERY MUCH GREATER THAN
\\gggn                              \\gggn                       "            : (Incomplete sequence)
\\gggne                             \\gggne                      "            : (Incomplete sequence)
\\gggnes                            \\gggnes                     "            : (Incomplete sequence)
\\gggnest                           <char-0x02AF8>               " ⫸          : TRIPLE NESTED GREATER-THAN
\\gimel                             <char-0x02137>               " ℷ          : GIMEL SYMBOL / THIRD TRANSFINITE CARDINAL
\\glE                               <char-0x02A92>               " ⪒          : GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
\\gla                               <char-0x02AA5>               " ⪥          : GREATER-THAN BESIDE LESS-THAN
\\glj                               <char-0x02AA4>               " ⪤          : GREATER-THAN OVERLAPPING LESS-THAN
\\glst                              <char-0x00294>               " ʔ          : LATIN LETTER GLOTTAL STOP
\\gnapprox                          <char-0x02A8A>               " ⪊          : GREATER-THAN AND NOT APPROXIMATE
\\gneq                              <char-0x02A88>               " ⪈          : GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
\\gneq<Tab>                         <char-0x02A88>               " ⪈          : GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
\\gneqq                             <char-0x02269>               " ≩          : GREATER-THAN BUT NOT EQUAL TO / GREATER THAN BUT NOT EQUAL TO
\\gnsim                             <char-0x022E7>               " ⋧          : GREATER-THAN BUT NOT EQUIVALENT TO / GREATER THAN BUT NOT EQUIVALENT TO
\\grave                             <char-0x00300>               " ◌̀         : COMBINING GRAVE ACCENT / NON-SPACING GRAVE
\\gsime                             <char-0x02A8E>               " ⪎          : GREATER-THAN ABOVE SIMILAR OR EQUAL
\\gsiml                             <char-0x02A90>               " ⪐          : GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
\\gtcc                              <char-0x02AA7>               " ⪧          : GREATER-THAN CLOSED BY CURVE
\\gtcir                             <char-0x02A7A>               " ⩺          : GREATER-THAN WITH CIRCLE INSIDE
\\gtquest                           <char-0x02A7C>               " ⩼          : GREATER-THAN WITH QUESTION MARK ABOVE
\\gtrapprox                         <char-0x02A86>               " ⪆          : GREATER-THAN OR APPROXIMATE
\\gtrdot                            <char-0x022D7>               " ⋗          : GREATER-THAN WITH DOT / GREATER THAN WITH DOT
\\gtreqless                         <char-0x022DB>               " ⋛          : GREATER-THAN EQUAL TO OR LESS-THAN / GREATER THAN EQUAL TO OR LESS THAN
\\gtreqqless                        <char-0x02A8C>               " ⪌          : GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
\\gtrless                           <char-0x02277>               " ≷          : GREATER-THAN OR LESS-THAN / GREATER THAN OR LESS THAN
\\gtrsim                            <char-0x02273>               " ≳          : GREATER-THAN OR EQUIVALENT TO / GREATER THAN OR EQUIVALENT TO
\\guilsinglleft                     <char-0x02039>               " ‹          : SINGLE LEFT-POINTING ANGLE QUOTATION MARK / LEFT POINTING SINGLE GUILLEMET
\\guilsinglright                    <char-0x0203A>               " ›          : SINGLE RIGHT-POINTING ANGLE QUOTATION MARK / RIGHT POINTING SINGLE GUILLEMET
\\gvertneqq                         <char-0x02269><char-0x0FE00> " ≩︀         : GREATER-THAN BUT NOT EQUAL TO / GREATER THAN BUT NOT EQUAL TO + VARIATION SELECTOR-1
\\hat                               <char-0x00302>               " ◌̂         : COMBINING CIRCUMFLEX ACCENT / NON-SPACING CIRCUMFLEX
\\hat<Tab>                          <char-0x00302>               " ◌̂         : COMBINING CIRCUMFLEX ACCENT / NON-SPACING CIRCUMFLEX
\\hata                              \\hata                       "            : (Incomplete sequence)
\\hatap                             \\hatap                      "            : (Incomplete sequence)
\\hatapp                            \\hatapp                     "            : (Incomplete sequence)
\\hatappr                           \\hatappr                    "            : (Incomplete sequence)
\\hatappro                          \\hatappro                   "            : (Incomplete sequence)
\\hatapprox                         <char-0x02A6F>               " ⩯          : ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
\\hbar                              <char-0x00127>               " ħ          : LATIN SMALL LETTER H WITH STROKE / LATIN SMALL LETTER H BAR
\\heartsuit                         <char-0x02661>               " ♡          : WHITE HEART SUIT
\\hermaphrodite                     <char-0x026A5>               " ⚥          : MALE AND FEMALE SIGN
\\hermitconjmatrix                  <char-0x022B9>               " ⊹          : HERMITIAN CONJUGATE MATRIX
\\hexagon                           <char-0x02394>               " ⎔          : SOFTWARE-FUNCTION SYMBOL
\\hexagon<Tab>                      <char-0x02394>               " ⎔          : SOFTWARE-FUNCTION SYMBOL
\\hexagonb                          \\hexagonb                   "            : (Incomplete sequence)
\\hexagonbl                         \\hexagonbl                  "            : (Incomplete sequence)
\\hexagonbla                        \\hexagonbla                 "            : (Incomplete sequence)
\\hexagonblac                       \\hexagonblac                "            : (Incomplete sequence)
\\hexagonblack                      <char-0x02B23>               " ⬣          : HORIZONTAL BLACK HEXAGON
\\highminus                         <char-0x000AF>               " ¯          : MACRON / SPACING MACRON
\\hksearow                          <char-0x02925>               " ⤥          : SOUTH EAST ARROW WITH HOOK
\\hkswarow                          <char-0x02926>               " ⤦          : SOUTH WEST ARROW WITH HOOK
\\hlmrk                             <char-0x002D1>               " ˑ          : MODIFIER LETTER HALF TRIANGULAR COLON
\\hookleftarrow                     <char-0x021A9>               " ↩          : LEFTWARDS ARROW WITH HOOK / LEFT ARROW WITH HOOK
\\hookrightarrow                    <char-0x021AA>               " ↪          : RIGHTWARDS ARROW WITH HOOK / RIGHT ARROW WITH HOOK
\\house                             <char-0x02302>               " ⌂          : HOUSE
\\hrectangle                        <char-0x025AD>               " ▭          : WHITE RECTANGLE
\\hrectangle<Tab>                   <char-0x025AD>               " ▭          : WHITE RECTANGLE
\\hrectangleb                       \\hrectangleb                "            : (Incomplete sequence)
\\hrectanglebl                      \\hrectanglebl               "            : (Incomplete sequence)
\\hrectanglebla                     \\hrectanglebla              "            : (Incomplete sequence)
\\hrectangleblac                    \\hrectangleblac             "            : (Incomplete sequence)
\\hrectangleblack                   <char-0x025AC>               " ▬          : BLACK RECTANGLE
\\hslash                            <char-0x0210F>               " ℏ          : PLANCK CONSTANT OVER TWO PI / PLANCK CONSTANT OVER 2 PI
\\hspace                            <char-0x0200A>               "            : HAIR SPACE
\\hvlig                             <char-0x00195>               " ƕ          : LATIN SMALL LETTER HV / LATIN SMALL LETTER H V
\\iff                               <char-0x027FA>               " ⟺          : LONG LEFT RIGHT DOUBLE ARROW
\\iiiint                            <char-0x02A0C>               " ⨌          : QUADRUPLE INTEGRAL OPERATOR
\\iiint                             <char-0x0222D>               " ∭          : TRIPLE INTEGRAL
\\iint                              <char-0x0222C>               " ∬          : DOUBLE INTEGRAL
\\image                             <char-0x022B7>               " ⊷          : IMAGE OF
\\imath                             <char-0x00131>               " ı          : LATIN SMALL LETTER DOTLESS I
\\impliedby                         <char-0x027F8>               " ⟸          : LONG LEFTWARDS DOUBLE ARROW
\\implies                           <char-0x027F9>               " ⟹          : LONG RIGHTWARDS DOUBLE ARROW
\\in                                <char-0x02208>               " ∈          : ELEMENT OF
\\in<Tab>                           <char-0x02208>               " ∈          : ELEMENT OF
\\inc                               \\inc                        "            : (Incomplete sequence)
\\incr                              \\incr                       "            : (Incomplete sequence)
\\incre                             \\incre                      "            : (Incomplete sequence)
\\increm                            \\increm                     "            : (Incomplete sequence)
\\increme                           \\increme                    "            : (Incomplete sequence)
\\incremen                          \\incremen                   "            : (Incomplete sequence)
\\increment                         <char-0x02206>               " ∆          : INCREMENT
\\inf                               \\inf                        "            : (Incomplete sequence)
\\inft                              \\inft                       "            : (Incomplete sequence)
\\infty                             <char-0x0221E>               " ∞          : INFINITY
\\ing                               \\ing                        "            : (Incomplete sequence)
\\ingl                              \\ingl                       "            : (Incomplete sequence)
\\ingls                             \\ingls                      "            : (Incomplete sequence)
\\inglst                            <char-0x00296>               " ʖ          : LATIN LETTER INVERTED GLOTTAL STOP
\\int                               <char-0x0222B>               " ∫          : INTEGRAL
\\int<Tab>                          <char-0x0222B>               " ∫          : INTEGRAL
\\intB                              \\intB                       "            : (Incomplete sequence)
\\intBa                             \\intBa                      "            : (Incomplete sequence)
\\intBar                            <char-0x02A0E>               " ⨎          : INTEGRAL WITH DOUBLE STROKE
\\intb                              \\intb                       "            : (Incomplete sequence)
\\intba                             \\intba                      "            : (Incomplete sequence)
\\intbar                            <char-0x02A0D>               " ⨍          : FINITE PART INTEGRAL
\\intc                              \\intc                       "            : (Incomplete sequence)
\\intca                             \\intca                      "            : (Incomplete sequence)
\\intcap                            <char-0x02A19>               " ⨙          : INTEGRAL WITH INTERSECTION
\\intcu                             \\intcu                      "            : (Incomplete sequence)
\\intcup                            <char-0x02A1A>               " ⨚          : INTEGRAL WITH UNION
\\inte                              \\inte                       "            : (Incomplete sequence)
\\inter                             \\inter                      "            : (Incomplete sequence)
\\interc                            \\interc                     "            : (Incomplete sequence)
\\interca                           \\interca                    "            : (Incomplete sequence)
\\intercal                          <char-0x022BA>               " ⊺          : INTERCALATE
\\interl                            \\interl                     "            : (Incomplete sequence)
\\interle                           \\interle                    "            : (Incomplete sequence)
\\interlea                          \\interlea                   "            : (Incomplete sequence)
\\interleav                         \\interleav                  "            : (Incomplete sequence)
\\interleave                        <char-0x02AF4>               " ⫴          : TRIPLE VERTICAL BAR BINARY RELATION
\\intp                              \\intp                       "            : (Incomplete sequence)
\\intpr                             \\intpr                      "            : (Incomplete sequence)
\\intpro                            \\intpro                     "            : (Incomplete sequence)
\\intprod                           <char-0x02A3C>               " ⨼          : INTERIOR PRODUCT
\\intprod<Tab>                      <char-0x02A3C>               " ⨼          : INTERIOR PRODUCT
\\intprodr                          <char-0x02A3D>               " ⨽          : RIGHTHAND INTERIOR PRODUCT
\\intx                              <char-0x02A18>               " ⨘          : INTEGRAL WITH TIMES SIGN
\\inv                               \\inv                        "            : (Incomplete sequence)
\\inve                              \\inve                       "            : (Incomplete sequence)
\\inver                             \\inver                      "            : (Incomplete sequence)
\\invers                            \\invers                     "            : (Incomplete sequence)
\\inverse                           \\inverse                    "            : (Incomplete sequence)
\\inversew                          \\inversew                   "            : (Incomplete sequence)
\\inversewh                         \\inversewh                  "            : (Incomplete sequence)
\\inversewhi                        \\inversewhi                 "            : (Incomplete sequence)
\\inversewhit                       \\inversewhit                "            : (Incomplete sequence)
\\inversewhite                      \\inversewhite               "            : (Incomplete sequence)
\\inversewhitec                     \\inversewhitec              "            : (Incomplete sequence)
\\inversewhiteci                    \\inversewhiteci             "            : (Incomplete sequence)
\\inversewhitecir                   \\inversewhitecir            "            : (Incomplete sequence)
\\inversewhitecirc                  \\inversewhitecirc           "            : (Incomplete sequence)
\\inversewhitecircl                 \\inversewhitecircl          "            : (Incomplete sequence)
\\inversewhitecircle                <char-0x025D9>               " ◙          : INVERSE WHITE CIRCLE
\\invn                              \\invn                       "            : (Incomplete sequence)
\\invno                             \\invno                      "            : (Incomplete sequence)
\\invnot                            <char-0x02310>               " ⌐          : REVERSED NOT SIGN
\\invv                              <char-0x0028C>               " ʌ          : LATIN SMALL LETTER TURNED V
\\invw                              <char-0x0028D>               " ʍ          : LATIN SMALL LETTER TURNED W
\\invw<Tab>                         <char-0x0028D>               " ʍ          : LATIN SMALL LETTER TURNED W
\\invwh                             \\invwh                      "            : (Incomplete sequence)
\\invwhi                            \\invwhi                     "            : (Incomplete sequence)
\\invwhit                           \\invwhit                    "            : (Incomplete sequence)
\\invwhite                          \\invwhite                   "            : (Incomplete sequence)
\\invwhitel                         \\invwhitel                  "            : (Incomplete sequence)
\\invwhitelo                        \\invwhitelo                 "            : (Incomplete sequence)
\\invwhitelow                       \\invwhitelow                "            : (Incomplete sequence)
\\invwhitelowe                      \\invwhitelowe               "            : (Incomplete sequence)
\\invwhitelower                     \\invwhitelower              "            : (Incomplete sequence)
\\invwhitelowerh                    \\invwhitelowerh             "            : (Incomplete sequence)
\\invwhitelowerha                   \\invwhitelowerha            "            : (Incomplete sequence)
\\invwhitelowerhal                  \\invwhitelowerhal           "            : (Incomplete sequence)
\\invwhitelowerhalf                 \\invwhitelowerhalf          "            : (Incomplete sequence)
\\invwhitelowerhalfc                \\invwhitelowerhalfc         "            : (Incomplete sequence)
\\invwhitelowerhalfci               \\invwhitelowerhalfci        "            : (Incomplete sequence)
\\invwhitelowerhalfcir              \\invwhitelowerhalfcir       "            : (Incomplete sequence)
\\invwhitelowerhalfcirc             \\invwhitelowerhalfcirc      "            : (Incomplete sequence)
\\invwhitelowerhalfcircl            \\invwhitelowerhalfcircl     "            : (Incomplete sequence)
\\invwhitelowerhalfcircle           <char-0x025DB>               " ◛          : LOWER HALF INVERSE WHITE CIRCLE
\\invwhiteu                         \\invwhiteu                  "            : (Incomplete sequence)
\\invwhiteup                        \\invwhiteup                 "            : (Incomplete sequence)
\\invwhiteupp                       \\invwhiteupp                "            : (Incomplete sequence)
\\invwhiteuppe                      \\invwhiteuppe               "            : (Incomplete sequence)
\\invwhiteupper                     \\invwhiteupper              "            : (Incomplete sequence)
\\invwhiteupperh                    \\invwhiteupperh             "            : (Incomplete sequence)
\\invwhiteupperha                   \\invwhiteupperha            "            : (Incomplete sequence)
\\invwhiteupperhal                  \\invwhiteupperhal           "            : (Incomplete sequence)
\\invwhiteupperhalf                 \\invwhiteupperhalf          "            : (Incomplete sequence)
\\invwhiteupperhalfc                \\invwhiteupperhalfc         "            : (Incomplete sequence)
\\invwhiteupperhalfci               \\invwhiteupperhalfci        "            : (Incomplete sequence)
\\invwhiteupperhalfcir              \\invwhiteupperhalfcir       "            : (Incomplete sequence)
\\invwhiteupperhalfcirc             \\invwhiteupperhalfcirc      "            : (Incomplete sequence)
\\invwhiteupperhalfcircl            \\invwhiteupperhalfcircl     "            : (Incomplete sequence)
\\invwhiteupperhalfcircle           <char-0x025DA>               " ◚          : UPPER HALF INVERSE WHITE CIRCLE
\\iota                              <char-0x003B9>               " ι          : GREEK SMALL LETTER IOTA
\\isansA                            <char-0x1D608>               " 𝘈          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL A
\\isansB                            <char-0x1D609>               " 𝘉          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL B
\\isansC                            <char-0x1D60A>               " 𝘊          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL C
\\isansD                            <char-0x1D60B>               " 𝘋          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL D
\\isansE                            <char-0x1D60C>               " 𝘌          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL E
\\isansF                            <char-0x1D60D>               " 𝘍          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL F
\\isansG                            <char-0x1D60E>               " 𝘎          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL G
\\isansH                            <char-0x1D60F>               " 𝘏          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL H
\\isansI                            <char-0x1D610>               " 𝘐          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL I
\\isansJ                            <char-0x1D611>               " 𝘑          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL J
\\isansK                            <char-0x1D612>               " 𝘒          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL K
\\isansL                            <char-0x1D613>               " 𝘓          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL L
\\isansM                            <char-0x1D614>               " 𝘔          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL M
\\isansN                            <char-0x1D615>               " 𝘕          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL N
\\isansO                            <char-0x1D616>               " 𝘖          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL O
\\isansP                            <char-0x1D617>               " 𝘗          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL P
\\isansQ                            <char-0x1D618>               " 𝘘          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q
\\isansR                            <char-0x1D619>               " 𝘙          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL R
\\isansS                            <char-0x1D61A>               " 𝘚          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL S
\\isansT                            <char-0x1D61B>               " 𝘛          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL T
\\isansU                            <char-0x1D61C>               " 𝘜          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL U
\\isansV                            <char-0x1D61D>               " 𝘝          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL V
\\isansW                            <char-0x1D61E>               " 𝘞          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL W
\\isansX                            <char-0x1D61F>               " 𝘟          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL X
\\isansY                            <char-0x1D620>               " 𝘠          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y
\\isansZ                            <char-0x1D621>               " 𝘡          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
\\isansa                            <char-0x1D622>               " 𝘢          : MATHEMATICAL SANS-SERIF ITALIC SMALL A
\\isansb                            <char-0x1D623>               " 𝘣          : MATHEMATICAL SANS-SERIF ITALIC SMALL B
\\isansc                            <char-0x1D624>               " 𝘤          : MATHEMATICAL SANS-SERIF ITALIC SMALL C
\\isansd                            <char-0x1D625>               " 𝘥          : MATHEMATICAL SANS-SERIF ITALIC SMALL D
\\isanse                            <char-0x1D626>               " 𝘦          : MATHEMATICAL SANS-SERIF ITALIC SMALL E
\\isansf                            <char-0x1D627>               " 𝘧          : MATHEMATICAL SANS-SERIF ITALIC SMALL F
\\isansg                            <char-0x1D628>               " 𝘨          : MATHEMATICAL SANS-SERIF ITALIC SMALL G
\\isansh                            <char-0x1D629>               " 𝘩          : MATHEMATICAL SANS-SERIF ITALIC SMALL H
\\isansi                            <char-0x1D62A>               " 𝘪          : MATHEMATICAL SANS-SERIF ITALIC SMALL I
\\isansj                            <char-0x1D62B>               " 𝘫          : MATHEMATICAL SANS-SERIF ITALIC SMALL J
\\isansk                            <char-0x1D62C>               " 𝘬          : MATHEMATICAL SANS-SERIF ITALIC SMALL K
\\isansl                            <char-0x1D62D>               " 𝘭          : MATHEMATICAL SANS-SERIF ITALIC SMALL L
\\isansm                            <char-0x1D62E>               " 𝘮          : MATHEMATICAL SANS-SERIF ITALIC SMALL M
\\isansn                            <char-0x1D62F>               " 𝘯          : MATHEMATICAL SANS-SERIF ITALIC SMALL N
\\isanso                            <char-0x1D630>               " 𝘰          : MATHEMATICAL SANS-SERIF ITALIC SMALL O
\\isansp                            <char-0x1D631>               " 𝘱          : MATHEMATICAL SANS-SERIF ITALIC SMALL P
\\isansq                            <char-0x1D632>               " 𝘲          : MATHEMATICAL SANS-SERIF ITALIC SMALL Q
\\isansr                            <char-0x1D633>               " 𝘳          : MATHEMATICAL SANS-SERIF ITALIC SMALL R
\\isanss                            <char-0x1D634>               " 𝘴          : MATHEMATICAL SANS-SERIF ITALIC SMALL S
\\isanst                            <char-0x1D635>               " 𝘵          : MATHEMATICAL SANS-SERIF ITALIC SMALL T
\\isansu                            <char-0x1D636>               " 𝘶          : MATHEMATICAL SANS-SERIF ITALIC SMALL U
\\isansv                            <char-0x1D637>               " 𝘷          : MATHEMATICAL SANS-SERIF ITALIC SMALL V
\\isansw                            <char-0x1D638>               " 𝘸          : MATHEMATICAL SANS-SERIF ITALIC SMALL W
\\isansx                            <char-0x1D639>               " 𝘹          : MATHEMATICAL SANS-SERIF ITALIC SMALL X
\\isansy                            <char-0x1D63A>               " 𝘺          : MATHEMATICAL SANS-SERIF ITALIC SMALL Y
\\isansz                            <char-0x1D63B>               " 𝘻          : MATHEMATICAL SANS-SERIF ITALIC SMALL Z
\\isinE                             <char-0x022F9>               " ⋹          : ELEMENT OF WITH TWO HORIZONTAL STROKES
\\isindot                           <char-0x022F5>               " ⋵          : ELEMENT OF WITH DOT ABOVE
\\isinobar                          <char-0x022F7>               " ⋷          : SMALL ELEMENT OF WITH OVERBAR
\\isins                             <char-0x022F4>               " ⋴          : SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\isinvb                            <char-0x022F8>               " ⋸          : ELEMENT OF WITH UNDERBAR
\\itA                               <char-0x1D434>               " 𝐴          : MATHEMATICAL ITALIC CAPITAL A
\\itA<Tab>                          <char-0x1D434>               " 𝐴          : MATHEMATICAL ITALIC CAPITAL A
\\itAl                              \\itAl                       "            : (Incomplete sequence)
\\itAlp                             \\itAlp                      "            : (Incomplete sequence)
\\itAlph                            \\itAlph                     "            : (Incomplete sequence)
\\itAlpha                           <char-0x1D6E2>               " 𝛢          : MATHEMATICAL ITALIC CAPITAL ALPHA
\\itB                               <char-0x1D435>               " 𝐵          : MATHEMATICAL ITALIC CAPITAL B
\\itB<Tab>                          <char-0x1D435>               " 𝐵          : MATHEMATICAL ITALIC CAPITAL B
\\itBe                              \\itBe                       "            : (Incomplete sequence)
\\itBet                             \\itBet                      "            : (Incomplete sequence)
\\itBeta                            <char-0x1D6E3>               " 𝛣          : MATHEMATICAL ITALIC CAPITAL BETA
\\itC                               <char-0x1D436>               " 𝐶          : MATHEMATICAL ITALIC CAPITAL C
\\itC<Tab>                          <char-0x1D436>               " 𝐶          : MATHEMATICAL ITALIC CAPITAL C
\\itCh                              \\itCh                       "            : (Incomplete sequence)
\\itChi                             <char-0x1D6F8>               " 𝛸          : MATHEMATICAL ITALIC CAPITAL CHI
\\itD                               <char-0x1D437>               " 𝐷          : MATHEMATICAL ITALIC CAPITAL D
\\itD<Tab>                          <char-0x1D437>               " 𝐷          : MATHEMATICAL ITALIC CAPITAL D
\\itDe                              \\itDe                       "            : (Incomplete sequence)
\\itDel                             \\itDel                      "            : (Incomplete sequence)
\\itDelt                            \\itDelt                     "            : (Incomplete sequence)
\\itDelta                           <char-0x1D6E5>               " 𝛥          : MATHEMATICAL ITALIC CAPITAL DELTA
\\itE                               <char-0x1D438>               " 𝐸          : MATHEMATICAL ITALIC CAPITAL E
\\itE<Tab>                          <char-0x1D438>               " 𝐸          : MATHEMATICAL ITALIC CAPITAL E
\\itEp                              \\itEp                       "            : (Incomplete sequence)
\\itEps                             \\itEps                      "            : (Incomplete sequence)
\\itEpsi                            \\itEpsi                     "            : (Incomplete sequence)
\\itEpsil                           \\itEpsil                    "            : (Incomplete sequence)
\\itEpsilo                          \\itEpsilo                   "            : (Incomplete sequence)
\\itEpsilon                         <char-0x1D6E6>               " 𝛦          : MATHEMATICAL ITALIC CAPITAL EPSILON
\\itEt                              \\itEt                       "            : (Incomplete sequence)
\\itEta                             <char-0x1D6E8>               " 𝛨          : MATHEMATICAL ITALIC CAPITAL ETA
\\itF                               <char-0x1D439>               " 𝐹          : MATHEMATICAL ITALIC CAPITAL F
\\itG                               <char-0x1D43A>               " 𝐺          : MATHEMATICAL ITALIC CAPITAL G
\\itG<Tab>                          <char-0x1D43A>               " 𝐺          : MATHEMATICAL ITALIC CAPITAL G
\\itGa                              \\itGa                       "            : (Incomplete sequence)
\\itGam                             \\itGam                      "            : (Incomplete sequence)
\\itGamm                            \\itGamm                     "            : (Incomplete sequence)
\\itGamma                           <char-0x1D6E4>               " 𝛤          : MATHEMATICAL ITALIC CAPITAL GAMMA
\\itH                               <char-0x1D43B>               " 𝐻          : MATHEMATICAL ITALIC CAPITAL H
\\itI                               <char-0x1D43C>               " 𝐼          : MATHEMATICAL ITALIC CAPITAL I
\\itI<Tab>                          <char-0x1D43C>               " 𝐼          : MATHEMATICAL ITALIC CAPITAL I
\\itIo                              \\itIo                       "            : (Incomplete sequence)
\\itIot                             \\itIot                      "            : (Incomplete sequence)
\\itIota                            <char-0x1D6EA>               " 𝛪          : MATHEMATICAL ITALIC CAPITAL IOTA
\\itJ                               <char-0x1D43D>               " 𝐽          : MATHEMATICAL ITALIC CAPITAL J
\\itK                               <char-0x1D43E>               " 𝐾          : MATHEMATICAL ITALIC CAPITAL K
\\itK<Tab>                          <char-0x1D43E>               " 𝐾          : MATHEMATICAL ITALIC CAPITAL K
\\itKa                              \\itKa                       "            : (Incomplete sequence)
\\itKap                             \\itKap                      "            : (Incomplete sequence)
\\itKapp                            \\itKapp                     "            : (Incomplete sequence)
\\itKappa                           <char-0x1D6EB>               " 𝛫          : MATHEMATICAL ITALIC CAPITAL KAPPA
\\itL                               <char-0x1D43F>               " 𝐿          : MATHEMATICAL ITALIC CAPITAL L
\\itL<Tab>                          <char-0x1D43F>               " 𝐿          : MATHEMATICAL ITALIC CAPITAL L
\\itLa                              \\itLa                       "            : (Incomplete sequence)
\\itLam                             \\itLam                      "            : (Incomplete sequence)
\\itLamb                            \\itLamb                     "            : (Incomplete sequence)
\\itLambd                           \\itLambd                    "            : (Incomplete sequence)
\\itLambda                          <char-0x1D6EC>               " 𝛬          : MATHEMATICAL ITALIC CAPITAL LAMDA
\\itM                               <char-0x1D440>               " 𝑀          : MATHEMATICAL ITALIC CAPITAL M
\\itM<Tab>                          <char-0x1D440>               " 𝑀          : MATHEMATICAL ITALIC CAPITAL M
\\itMu                              <char-0x1D6ED>               " 𝛭          : MATHEMATICAL ITALIC CAPITAL MU
\\itN                               <char-0x1D441>               " 𝑁          : MATHEMATICAL ITALIC CAPITAL N
\\itN<Tab>                          <char-0x1D441>               " 𝑁          : MATHEMATICAL ITALIC CAPITAL N
\\itNu                              <char-0x1D6EE>               " 𝛮          : MATHEMATICAL ITALIC CAPITAL NU
\\itO                               <char-0x1D442>               " 𝑂          : MATHEMATICAL ITALIC CAPITAL O
\\itO<Tab>                          <char-0x1D442>               " 𝑂          : MATHEMATICAL ITALIC CAPITAL O
\\itOm                              \\itOm                       "            : (Incomplete sequence)
\\itOme                             \\itOme                      "            : (Incomplete sequence)
\\itOmeg                            \\itOmeg                     "            : (Incomplete sequence)
\\itOmega                           <char-0x1D6FA>               " 𝛺          : MATHEMATICAL ITALIC CAPITAL OMEGA
\\itOmi                             \\itOmi                      "            : (Incomplete sequence)
\\itOmic                            \\itOmic                     "            : (Incomplete sequence)
\\itOmicr                           \\itOmicr                    "            : (Incomplete sequence)
\\itOmicro                          \\itOmicro                   "            : (Incomplete sequence)
\\itOmicron                         <char-0x1D6F0>               " 𝛰          : MATHEMATICAL ITALIC CAPITAL OMICRON
\\itP                               <char-0x1D443>               " 𝑃          : MATHEMATICAL ITALIC CAPITAL P
\\itP<Tab>                          <char-0x1D443>               " 𝑃          : MATHEMATICAL ITALIC CAPITAL P
\\itPh                              \\itPh                       "            : (Incomplete sequence)
\\itPhi                             <char-0x1D6F7>               " 𝛷          : MATHEMATICAL ITALIC CAPITAL PHI
\\itPi                              <char-0x1D6F1>               " 𝛱          : MATHEMATICAL ITALIC CAPITAL PI
\\itPs                              \\itPs                       "            : (Incomplete sequence)
\\itPsi                             <char-0x1D6F9>               " 𝛹          : MATHEMATICAL ITALIC CAPITAL PSI
\\itQ                               <char-0x1D444>               " 𝑄          : MATHEMATICAL ITALIC CAPITAL Q
\\itR                               <char-0x1D445>               " 𝑅          : MATHEMATICAL ITALIC CAPITAL R
\\itR<Tab>                          <char-0x1D445>               " 𝑅          : MATHEMATICAL ITALIC CAPITAL R
\\itRh                              \\itRh                       "            : (Incomplete sequence)
\\itRho                             <char-0x1D6F2>               " 𝛲          : MATHEMATICAL ITALIC CAPITAL RHO
\\itS                               <char-0x1D446>               " 𝑆          : MATHEMATICAL ITALIC CAPITAL S
\\itS<Tab>                          <char-0x1D446>               " 𝑆          : MATHEMATICAL ITALIC CAPITAL S
\\itSi                              \\itSi                       "            : (Incomplete sequence)
\\itSig                             \\itSig                      "            : (Incomplete sequence)
\\itSigm                            \\itSigm                     "            : (Incomplete sequence)
\\itSigma                           <char-0x1D6F4>               " 𝛴          : MATHEMATICAL ITALIC CAPITAL SIGMA
\\itT                               <char-0x1D447>               " 𝑇          : MATHEMATICAL ITALIC CAPITAL T
\\itT<Tab>                          <char-0x1D447>               " 𝑇          : MATHEMATICAL ITALIC CAPITAL T
\\itTa                              \\itTa                       "            : (Incomplete sequence)
\\itTau                             <char-0x1D6F5>               " 𝛵          : MATHEMATICAL ITALIC CAPITAL TAU
\\itTh                              \\itTh                       "            : (Incomplete sequence)
\\itThe                             \\itThe                      "            : (Incomplete sequence)
\\itThet                            \\itThet                     "            : (Incomplete sequence)
\\itTheta                           <char-0x1D6E9>               " 𝛩          : MATHEMATICAL ITALIC CAPITAL THETA
\\itU                               <char-0x1D448>               " 𝑈          : MATHEMATICAL ITALIC CAPITAL U
\\itU<Tab>                          <char-0x1D448>               " 𝑈          : MATHEMATICAL ITALIC CAPITAL U
\\itUp                              \\itUp                       "            : (Incomplete sequence)
\\itUps                             \\itUps                      "            : (Incomplete sequence)
\\itUpsi                            \\itUpsi                     "            : (Incomplete sequence)
\\itUpsil                           \\itUpsil                    "            : (Incomplete sequence)
\\itUpsilo                          \\itUpsilo                   "            : (Incomplete sequence)
\\itUpsilon                         <char-0x1D6F6>               " 𝛶          : MATHEMATICAL ITALIC CAPITAL UPSILON
\\itV                               <char-0x1D449>               " 𝑉          : MATHEMATICAL ITALIC CAPITAL V
\\itW                               <char-0x1D44A>               " 𝑊          : MATHEMATICAL ITALIC CAPITAL W
\\itX                               <char-0x1D44B>               " 𝑋          : MATHEMATICAL ITALIC CAPITAL X
\\itX<Tab>                          <char-0x1D44B>               " 𝑋          : MATHEMATICAL ITALIC CAPITAL X
\\itXi                              <char-0x1D6EF>               " 𝛯          : MATHEMATICAL ITALIC CAPITAL XI
\\itY                               <char-0x1D44C>               " 𝑌          : MATHEMATICAL ITALIC CAPITAL Y
\\itZ                               <char-0x1D44D>               " 𝑍          : MATHEMATICAL ITALIC CAPITAL Z
\\itZ<Tab>                          <char-0x1D44D>               " 𝑍          : MATHEMATICAL ITALIC CAPITAL Z
\\itZe                              \\itZe                       "            : (Incomplete sequence)
\\itZet                             \\itZet                      "            : (Incomplete sequence)
\\itZeta                            <char-0x1D6E7>               " 𝛧          : MATHEMATICAL ITALIC CAPITAL ZETA
\\ita                               <char-0x1D44E>               " 𝑎          : MATHEMATICAL ITALIC SMALL A
\\ita<Tab>                          <char-0x1D44E>               " 𝑎          : MATHEMATICAL ITALIC SMALL A
\\ital                              \\ital                       "            : (Incomplete sequence)
\\italp                             \\italp                      "            : (Incomplete sequence)
\\italph                            \\italph                     "            : (Incomplete sequence)
\\italpha                           <char-0x1D6FC>               " 𝛼          : MATHEMATICAL ITALIC SMALL ALPHA
\\itb                               <char-0x1D44F>               " 𝑏          : MATHEMATICAL ITALIC SMALL B
\\itb<Tab>                          <char-0x1D44F>               " 𝑏          : MATHEMATICAL ITALIC SMALL B
\\itbe                              \\itbe                       "            : (Incomplete sequence)
\\itbet                             \\itbet                      "            : (Incomplete sequence)
\\itbeta                            <char-0x1D6FD>               " 𝛽          : MATHEMATICAL ITALIC SMALL BETA
\\itc                               <char-0x1D450>               " 𝑐          : MATHEMATICAL ITALIC SMALL C
\\itc<Tab>                          <char-0x1D450>               " 𝑐          : MATHEMATICAL ITALIC SMALL C
\\itch                              \\itch                       "            : (Incomplete sequence)
\\itchi                             <char-0x1D712>               " 𝜒          : MATHEMATICAL ITALIC SMALL CHI
\\itd                               <char-0x1D451>               " 𝑑          : MATHEMATICAL ITALIC SMALL D
\\itd<Tab>                          <char-0x1D451>               " 𝑑          : MATHEMATICAL ITALIC SMALL D
\\itde                              \\itde                       "            : (Incomplete sequence)
\\itdel                             \\itdel                      "            : (Incomplete sequence)
\\itdelt                            \\itdelt                     "            : (Incomplete sequence)
\\itdelta                           <char-0x1D6FF>               " 𝛿          : MATHEMATICAL ITALIC SMALL DELTA
\\ite                               <char-0x1D452>               " 𝑒          : MATHEMATICAL ITALIC SMALL E
\\ite<Tab>                          <char-0x1D452>               " 𝑒          : MATHEMATICAL ITALIC SMALL E
\\itep                              \\itep                       "            : (Incomplete sequence)
\\iteps                             \\iteps                      "            : (Incomplete sequence)
\\itepsi                            \\itepsi                     "            : (Incomplete sequence)
\\itepsil                           \\itepsil                    "            : (Incomplete sequence)
\\itepsilo                          \\itepsilo                   "            : (Incomplete sequence)
\\itepsilon                         <char-0x1D700>               " 𝜀          : MATHEMATICAL ITALIC SMALL EPSILON
\\itet                              \\itet                       "            : (Incomplete sequence)
\\iteta                             <char-0x1D702>               " 𝜂          : MATHEMATICAL ITALIC SMALL ETA
\\itf                               <char-0x1D453>               " 𝑓          : MATHEMATICAL ITALIC SMALL F
\\itg                               <char-0x1D454>               " 𝑔          : MATHEMATICAL ITALIC SMALL G
\\itg<Tab>                          <char-0x1D454>               " 𝑔          : MATHEMATICAL ITALIC SMALL G
\\itga                              \\itga                       "            : (Incomplete sequence)
\\itgam                             \\itgam                      "            : (Incomplete sequence)
\\itgamm                            \\itgamm                     "            : (Incomplete sequence)
\\itgamma                           <char-0x1D6FE>               " 𝛾          : MATHEMATICAL ITALIC SMALL GAMMA
\\iti                               <char-0x1D456>               " 𝑖          : MATHEMATICAL ITALIC SMALL I
\\iti<Tab>                          <char-0x1D456>               " 𝑖          : MATHEMATICAL ITALIC SMALL I
\\itim                              \\itim                       "            : (Incomplete sequence)
\\itima                             \\itima                      "            : (Incomplete sequence)
\\itimat                            \\itimat                     "            : (Incomplete sequence)
\\itimath                           <char-0x1D6A4>               " 𝚤          : MATHEMATICAL ITALIC SMALL DOTLESS I
\\itio                              \\itio                       "            : (Incomplete sequence)
\\itiot                             \\itiot                      "            : (Incomplete sequence)
\\itiota                            <char-0x1D704>               " 𝜄          : MATHEMATICAL ITALIC SMALL IOTA
\\itj                               <char-0x1D457>               " 𝑗          : MATHEMATICAL ITALIC SMALL J
\\itj<Tab>                          <char-0x1D457>               " 𝑗          : MATHEMATICAL ITALIC SMALL J
\\itjm                              \\itjm                       "            : (Incomplete sequence)
\\itjma                             \\itjma                      "            : (Incomplete sequence)
\\itjmat                            \\itjmat                     "            : (Incomplete sequence)
\\itjmath                           <char-0x1D6A5>               " 𝚥          : MATHEMATICAL ITALIC SMALL DOTLESS J
\\itk                               <char-0x1D458>               " 𝑘          : MATHEMATICAL ITALIC SMALL K
\\itk<Tab>                          <char-0x1D458>               " 𝑘          : MATHEMATICAL ITALIC SMALL K
\\itka                              \\itka                       "            : (Incomplete sequence)
\\itkap                             \\itkap                      "            : (Incomplete sequence)
\\itkapp                            \\itkapp                     "            : (Incomplete sequence)
\\itkappa                           <char-0x1D705>               " 𝜅          : MATHEMATICAL ITALIC SMALL KAPPA
\\itl                               <char-0x1D459>               " 𝑙          : MATHEMATICAL ITALIC SMALL L
\\itl<Tab>                          <char-0x1D459>               " 𝑙          : MATHEMATICAL ITALIC SMALL L
\\itla                              \\itla                       "            : (Incomplete sequence)
\\itlam                             \\itlam                      "            : (Incomplete sequence)
\\itlamb                            \\itlamb                     "            : (Incomplete sequence)
\\itlambd                           \\itlambd                    "            : (Incomplete sequence)
\\itlambda                          <char-0x1D706>               " 𝜆          : MATHEMATICAL ITALIC SMALL LAMDA
\\itm                               <char-0x1D45A>               " 𝑚          : MATHEMATICAL ITALIC SMALL M
\\itm<Tab>                          <char-0x1D45A>               " 𝑚          : MATHEMATICAL ITALIC SMALL M
\\itmu                              <char-0x1D707>               " 𝜇          : MATHEMATICAL ITALIC SMALL MU
\\itn                               <char-0x1D45B>               " 𝑛          : MATHEMATICAL ITALIC SMALL N
\\itn<Tab>                          <char-0x1D45B>               " 𝑛          : MATHEMATICAL ITALIC SMALL N
\\itna                              \\itna                       "            : (Incomplete sequence)
\\itnab                             \\itnab                      "            : (Incomplete sequence)
\\itnabl                            \\itnabl                     "            : (Incomplete sequence)
\\itnabla                           <char-0x1D6FB>               " 𝛻          : MATHEMATICAL ITALIC NABLA
\\itnu                              <char-0x1D708>               " 𝜈          : MATHEMATICAL ITALIC SMALL NU
\\ito                               <char-0x1D45C>               " 𝑜          : MATHEMATICAL ITALIC SMALL O
\\ito<Tab>                          <char-0x1D45C>               " 𝑜          : MATHEMATICAL ITALIC SMALL O
\\itom                              \\itom                       "            : (Incomplete sequence)
\\itome                             \\itome                      "            : (Incomplete sequence)
\\itomeg                            \\itomeg                     "            : (Incomplete sequence)
\\itomega                           <char-0x1D714>               " 𝜔          : MATHEMATICAL ITALIC SMALL OMEGA
\\itomi                             \\itomi                      "            : (Incomplete sequence)
\\itomic                            \\itomic                     "            : (Incomplete sequence)
\\itomicr                           \\itomicr                    "            : (Incomplete sequence)
\\itomicro                          \\itomicro                   "            : (Incomplete sequence)
\\itomicron                         <char-0x1D70A>               " 𝜊          : MATHEMATICAL ITALIC SMALL OMICRON
\\itp                               <char-0x1D45D>               " 𝑝          : MATHEMATICAL ITALIC SMALL P
\\itp<Tab>                          <char-0x1D45D>               " 𝑝          : MATHEMATICAL ITALIC SMALL P
\\itpa                              \\itpa                       "            : (Incomplete sequence)
\\itpar                             \\itpar                      "            : (Incomplete sequence)
\\itpart                            \\itpart                     "            : (Incomplete sequence)
\\itparti                           \\itparti                    "            : (Incomplete sequence)
\\itpartia                          \\itpartia                   "            : (Incomplete sequence)
\\itpartial                         <char-0x1D715>               " 𝜕          : MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
\\itph                              \\itph                       "            : (Incomplete sequence)
\\itphi                             <char-0x1D711>               " 𝜑          : MATHEMATICAL ITALIC SMALL PHI
\\itpi                              <char-0x1D70B>               " 𝜋          : MATHEMATICAL ITALIC SMALL PI
\\itps                              \\itps                       "            : (Incomplete sequence)
\\itpsi                             <char-0x1D713>               " 𝜓          : MATHEMATICAL ITALIC SMALL PSI
\\itq                               <char-0x1D45E>               " 𝑞          : MATHEMATICAL ITALIC SMALL Q
\\itr                               <char-0x1D45F>               " 𝑟          : MATHEMATICAL ITALIC SMALL R
\\itr<Tab>                          <char-0x1D45F>               " 𝑟          : MATHEMATICAL ITALIC SMALL R
\\itrh                              \\itrh                       "            : (Incomplete sequence)
\\itrho                             <char-0x1D70C>               " 𝜌          : MATHEMATICAL ITALIC SMALL RHO
\\its                               <char-0x1D460>               " 𝑠          : MATHEMATICAL ITALIC SMALL S
\\its<Tab>                          <char-0x1D460>               " 𝑠          : MATHEMATICAL ITALIC SMALL S
\\itsi                              \\itsi                       "            : (Incomplete sequence)
\\itsig                             \\itsig                      "            : (Incomplete sequence)
\\itsigm                            \\itsigm                     "            : (Incomplete sequence)
\\itsigma                           <char-0x1D70E>               " 𝜎          : MATHEMATICAL ITALIC SMALL SIGMA
\\itt                               <char-0x1D461>               " 𝑡          : MATHEMATICAL ITALIC SMALL T
\\itt<Tab>                          <char-0x1D461>               " 𝑡          : MATHEMATICAL ITALIC SMALL T
\\itta                              \\itta                       "            : (Incomplete sequence)
\\ittau                             <char-0x1D70F>               " 𝜏          : MATHEMATICAL ITALIC SMALL TAU
\\itth                              \\itth                       "            : (Incomplete sequence)
\\itthe                             \\itthe                      "            : (Incomplete sequence)
\\itthet                            \\itthet                     "            : (Incomplete sequence)
\\ittheta                           <char-0x1D703>               " 𝜃          : MATHEMATICAL ITALIC SMALL THETA
\\itu                               <char-0x1D462>               " 𝑢          : MATHEMATICAL ITALIC SMALL U
\\itu<Tab>                          <char-0x1D462>               " 𝑢          : MATHEMATICAL ITALIC SMALL U
\\itup                              \\itup                       "            : (Incomplete sequence)
\\itups                             \\itups                      "            : (Incomplete sequence)
\\itupsi                            \\itupsi                     "            : (Incomplete sequence)
\\itupsil                           \\itupsil                    "            : (Incomplete sequence)
\\itupsilo                          \\itupsilo                   "            : (Incomplete sequence)
\\itupsilon                         <char-0x1D710>               " 𝜐          : MATHEMATICAL ITALIC SMALL UPSILON
\\itv                               <char-0x1D463>               " 𝑣          : MATHEMATICAL ITALIC SMALL V
\\itv<Tab>                          <char-0x1D463>               " 𝑣          : MATHEMATICAL ITALIC SMALL V
\\itva                              \\itva                       "            : (Incomplete sequence)
\\itvar                             \\itvar                      "            : (Incomplete sequence)
\\itvarT                            \\itvarT                     "            : (Incomplete sequence)
\\itvarTh                           \\itvarTh                    "            : (Incomplete sequence)
\\itvarThe                          \\itvarThe                   "            : (Incomplete sequence)
\\itvarThet                         \\itvarThet                  "            : (Incomplete sequence)
\\itvarTheta                        <char-0x1D6F3>               " 𝛳          : MATHEMATICAL ITALIC CAPITAL THETA SYMBOL
\\itvare                            \\itvare                     "            : (Incomplete sequence)
\\itvarep                           \\itvarep                    "            : (Incomplete sequence)
\\itvareps                          \\itvareps                   "            : (Incomplete sequence)
\\itvarepsi                         \\itvarepsi                  "            : (Incomplete sequence)
\\itvarepsil                        \\itvarepsil                 "            : (Incomplete sequence)
\\itvarepsilo                       \\itvarepsilo                "            : (Incomplete sequence)
\\itvarepsilon                      <char-0x1D716>               " 𝜖          : MATHEMATICAL ITALIC EPSILON SYMBOL
\\itvark                            \\itvark                     "            : (Incomplete sequence)
\\itvarka                           \\itvarka                    "            : (Incomplete sequence)
\\itvarkap                          \\itvarkap                   "            : (Incomplete sequence)
\\itvarkapp                         \\itvarkapp                  "            : (Incomplete sequence)
\\itvarkappa                        <char-0x1D718>               " 𝜘          : MATHEMATICAL ITALIC KAPPA SYMBOL
\\itvarp                            \\itvarp                     "            : (Incomplete sequence)
\\itvarph                           \\itvarph                    "            : (Incomplete sequence)
\\itvarphi                          <char-0x1D719>               " 𝜙          : MATHEMATICAL ITALIC PHI SYMBOL
\\itvarpi                           <char-0x1D71B>               " 𝜛          : MATHEMATICAL ITALIC PI SYMBOL
\\itvarr                            \\itvarr                     "            : (Incomplete sequence)
\\itvarrh                           \\itvarrh                    "            : (Incomplete sequence)
\\itvarrho                          <char-0x1D71A>               " 𝜚          : MATHEMATICAL ITALIC RHO SYMBOL
\\itvars                            \\itvars                     "            : (Incomplete sequence)
\\itvarsi                           \\itvarsi                    "            : (Incomplete sequence)
\\itvarsig                          \\itvarsig                   "            : (Incomplete sequence)
\\itvarsigm                         \\itvarsigm                  "            : (Incomplete sequence)
\\itvarsigma                        <char-0x1D70D>               " 𝜍          : MATHEMATICAL ITALIC SMALL FINAL SIGMA
\\itvart                            \\itvart                     "            : (Incomplete sequence)
\\itvarth                           \\itvarth                    "            : (Incomplete sequence)
\\itvarthe                          \\itvarthe                   "            : (Incomplete sequence)
\\itvarthet                         \\itvarthet                  "            : (Incomplete sequence)
\\itvartheta                        <char-0x1D717>               " 𝜗          : MATHEMATICAL ITALIC THETA SYMBOL
\\itw                               <char-0x1D464>               " 𝑤          : MATHEMATICAL ITALIC SMALL W
\\itx                               <char-0x1D465>               " 𝑥          : MATHEMATICAL ITALIC SMALL X
\\itx<Tab>                          <char-0x1D465>               " 𝑥          : MATHEMATICAL ITALIC SMALL X
\\itxi                              <char-0x1D709>               " 𝜉          : MATHEMATICAL ITALIC SMALL XI
\\ity                               <char-0x1D466>               " 𝑦          : MATHEMATICAL ITALIC SMALL Y
\\itz                               <char-0x1D467>               " 𝑧          : MATHEMATICAL ITALIC SMALL Z
\\itz<Tab>                          <char-0x1D467>               " 𝑧          : MATHEMATICAL ITALIC SMALL Z
\\itze                              \\itze                       "            : (Incomplete sequence)
\\itzet                             \\itzet                      "            : (Incomplete sequence)
\\itzeta                            <char-0x1D701>               " 𝜁          : MATHEMATICAL ITALIC SMALL ZETA
\\jmath                             <char-0x00237>               " ȷ          : LATIN SMALL LETTER DOTLESS J
\\join                              <char-0x02A1D>               " ⨝          : JOIN
\\jupiter                           <char-0x02643>               " ♃          : JUPITER
\\k                                 <char-0x00328>               " ◌̨         : COMBINING OGONEK / NON-SPACING OGONEK
\\k<Tab>                            <char-0x00328>               " ◌̨         : COMBINING OGONEK / NON-SPACING OGONEK
\\ka                                \\ka                         "            : (Incomplete sequence)
\\kap                               \\kap                        "            : (Incomplete sequence)
\\kapp                              \\kapp                       "            : (Incomplete sequence)
\\kappa                             <char-0x003BA>               " κ          : GREEK SMALL LETTER KAPPA
\\ke                                \\ke                         "            : (Incomplete sequence)
\\ker                               \\ker                        "            : (Incomplete sequence)
\\kern                              \\kern                       "            : (Incomplete sequence)
\\kerne                             \\kerne                      "            : (Incomplete sequence)
\\kernel                            \\kernel                     "            : (Incomplete sequence)
\\kernelc                           \\kernelc                    "            : (Incomplete sequence)
\\kernelco                          \\kernelco                   "            : (Incomplete sequence)
\\kernelcon                         \\kernelcon                  "            : (Incomplete sequence)
\\kernelcont                        \\kernelcont                 "            : (Incomplete sequence)
\\kernelcontr                       \\kernelcontr                "            : (Incomplete sequence)
\\kernelcontra                      \\kernelcontra               "            : (Incomplete sequence)
\\kernelcontrac                     \\kernelcontrac              "            : (Incomplete sequence)
\\kernelcontract                    \\kernelcontract             "            : (Incomplete sequence)
\\kernelcontracti                   \\kernelcontracti            "            : (Incomplete sequence)
\\kernelcontractio                  \\kernelcontractio           "            : (Incomplete sequence)
\\kernelcontraction                 <char-0x0223B>               " ∻          : HOMOTHETIC
\\l                                 <char-0x00142>               " ł          : LATIN SMALL LETTER L WITH STROKE / LATIN SMALL LETTER L SLASH
\\l<Tab>                            <char-0x00142>               " ł          : LATIN SMALL LETTER L WITH STROKE / LATIN SMALL LETTER L SLASH
\\la                                \\la                         "            : (Incomplete sequence)
\\lam                               \\lam                        "            : (Incomplete sequence)
\\lamb                              \\lamb                       "            : (Incomplete sequence)
\\lambd                             \\lambd                      "            : (Incomplete sequence)
\\lambda                            <char-0x003BB>               " λ          : GREEK SMALL LETTER LAMDA / GREEK SMALL LETTER LAMBDA
\\lan                               \\lan                        "            : (Incomplete sequence)
\\lang                              \\lang                       "            : (Incomplete sequence)
\\langl                             \\langl                      "            : (Incomplete sequence)
\\langle                            <char-0x027E8>               " ⟨          : MATHEMATICAL LEFT ANGLE BRACKET
\\lat                               <char-0x02AAB>               " ⪫          : LARGER THAN
\\lat<Tab>                          <char-0x02AAB>               " ⪫          : LARGER THAN
\\late                              <char-0x02AAD>               " ⪭          : LARGER THAN OR EQUAL TO
\\laz                               \\laz                        "            : (Incomplete sequence)
\\lazy                              \\lazy                       "            : (Incomplete sequence)
\\lazys                             \\lazys                      "            : (Incomplete sequence)
\\lazysi                            \\lazysi                     "            : (Incomplete sequence)
\\lazysin                           \\lazysin                    "            : (Incomplete sequence)
\\lazysinv                          <char-0x0223E>               " ∾          : INVERTED LAZY S
\\lc                                \\lc                         "            : (Incomplete sequence)
\\lce                               \\lce                        "            : (Incomplete sequence)
\\lcei                              \\lcei                       "            : (Incomplete sequence)
\\lceil                             <char-0x02308>               " ⌈          : LEFT CEILING
\\ld                                \\ld                         "            : (Incomplete sequence)
\\ldo                               \\ldo                        "            : (Incomplete sequence)
\\ldot                              \\ldot                       "            : (Incomplete sequence)
\\ldots                             <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\le                                <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\le<Tab>                           <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\lef                               \\lef                        "            : (Incomplete sequence)
\\left                              \\left                       "            : (Incomplete sequence)
\\lefta                             \\lefta                      "            : (Incomplete sequence)
\\leftar                            \\leftar                     "            : (Incomplete sequence)
\\leftarr                           \\leftarr                    "            : (Incomplete sequence)
\\leftarro                          \\leftarro                   "            : (Incomplete sequence)
\\leftarrow                         <char-0x02190>               " ←          : LEFTWARDS ARROW / LEFT ARROW
\\leftarrow<Tab>                    <char-0x02190>               " ←          : LEFTWARDS ARROW / LEFT ARROW
\\leftarrowa                        \\leftarrowa                 "            : (Incomplete sequence)
\\leftarrowap                       \\leftarrowap                "            : (Incomplete sequence)
\\leftarrowapp                      \\leftarrowapp               "            : (Incomplete sequence)
\\leftarrowappr                     \\leftarrowappr              "            : (Incomplete sequence)
\\leftarrowappro                    \\leftarrowappro             "            : (Incomplete sequence)
\\leftarrowapprox                   <char-0x02B4A>               " ⭊          : LEFTWARDS ARROW ABOVE ALMOST EQUAL TO
\\leftarrowb                        \\leftarrowb                 "            : (Incomplete sequence)
\\leftarrowba                       \\leftarrowba                "            : (Incomplete sequence)
\\leftarrowbac                      \\leftarrowbac               "            : (Incomplete sequence)
\\leftarrowback                     \\leftarrowback              "            : (Incomplete sequence)
\\leftarrowbacka                    \\leftarrowbacka             "            : (Incomplete sequence)
\\leftarrowbackap                   \\leftarrowbackap            "            : (Incomplete sequence)
\\leftarrowbackapp                  \\leftarrowbackapp           "            : (Incomplete sequence)
\\leftarrowbackappr                 \\leftarrowbackappr          "            : (Incomplete sequence)
\\leftarrowbackappro                \\leftarrowbackappro         "            : (Incomplete sequence)
\\leftarrowbackapprox               <char-0x02B42>               " ⭂          : LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
\\leftarrowbs                       \\leftarrowbs                "            : (Incomplete sequence)
\\leftarrowbsi                      \\leftarrowbsi               "            : (Incomplete sequence)
\\leftarrowbsim                     \\leftarrowbsim              "            : (Incomplete sequence)
\\leftarrowbsimi                    \\leftarrowbsimi             "            : (Incomplete sequence)
\\leftarrowbsimil                   \\leftarrowbsimil            "            : (Incomplete sequence)
\\leftarrowbsimila                  \\leftarrowbsimila           "            : (Incomplete sequence)
\\leftarrowbsimilar                 <char-0x02B4B>               " ⭋          : LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
\\leftarrowo                        \\leftarrowo                 "            : (Incomplete sequence)
\\leftarrowon                       \\leftarrowon                "            : (Incomplete sequence)
\\leftarrowono                      \\leftarrowono               "            : (Incomplete sequence)
\\leftarrowonop                     \\leftarrowonop              "            : (Incomplete sequence)
\\leftarrowonopl                    \\leftarrowonopl             "            : (Incomplete sequence)
\\leftarrowonoplu                   \\leftarrowonoplu            "            : (Incomplete sequence)
\\leftarrowonoplus                  <char-0x02B32>               " ⬲          : LEFT ARROW WITH CIRCLED PLUS
\\leftarrowp                        \\leftarrowp                 "            : (Incomplete sequence)
\\leftarrowpl                       \\leftarrowpl                "            : (Incomplete sequence)
\\leftarrowplu                      \\leftarrowplu               "            : (Incomplete sequence)
\\leftarrowplus                     <char-0x02946>               " ⥆          : LEFTWARDS ARROW WITH PLUS BELOW
\\leftarrowt                        \\leftarrowt                 "            : (Incomplete sequence)
\\leftarrowta                       \\leftarrowta                "            : (Incomplete sequence)
\\leftarrowtai                      \\leftarrowtai               "            : (Incomplete sequence)
\\leftarrowtail                     <char-0x021A2>               " ↢          : LEFTWARDS ARROW WITH TAIL / LEFT ARROW WITH TAIL
\\leftarrowtr                       \\leftarrowtr                "            : (Incomplete sequence)
\\leftarrowtri                      \\leftarrowtri               "            : (Incomplete sequence)
\\leftarrowtria                     \\leftarrowtria              "            : (Incomplete sequence)
\\leftarrowtrian                    \\leftarrowtrian             "            : (Incomplete sequence)
\\leftarrowtriang                   \\leftarrowtriang            "            : (Incomplete sequence)
\\leftarrowtriangl                  \\leftarrowtriangl           "            : (Incomplete sequence)
\\leftarrowtriangle                 <char-0x021FD>               " ⇽          : LEFTWARDS OPEN-HEADED ARROW
\\leftarrowx                        <char-0x02B3E>               " ⬾          : LEFTWARDS ARROW THROUGH X
\\leftb                             \\leftb                      "            : (Incomplete sequence)
\\leftbk                            \\leftbk                     "            : (Incomplete sequence)
\\leftbka                           \\leftbka                    "            : (Incomplete sequence)
\\leftbkar                          \\leftbkar                   "            : (Incomplete sequence)
\\leftbkarr                         \\leftbkarr                  "            : (Incomplete sequence)
\\leftbkarro                        \\leftbkarro                 "            : (Incomplete sequence)
\\leftbkarrow                       <char-0x0290C>               " ⤌          : LEFTWARDS DOUBLE DASH ARROW
\\leftc                             \\leftc                      "            : (Incomplete sequence)
\\leftcu                            \\leftcu                     "            : (Incomplete sequence)
\\leftcur                           \\leftcur                    "            : (Incomplete sequence)
\\leftcurv                          \\leftcurv                   "            : (Incomplete sequence)
\\leftcurve                         \\leftcurve                  "            : (Incomplete sequence)
\\leftcurved                        \\leftcurved                 "            : (Incomplete sequence)
\\leftcurveda                       \\leftcurveda                "            : (Incomplete sequence)
\\leftcurvedar                      \\leftcurvedar               "            : (Incomplete sequence)
\\leftcurvedarr                     \\leftcurvedarr              "            : (Incomplete sequence)
\\leftcurvedarro                    \\leftcurvedarro             "            : (Incomplete sequence)
\\leftcurvedarrow                   <char-0x02B3F>               " ⬿          : WAVE ARROW POINTING DIRECTLY LEFT
\\leftd                             \\leftd                      "            : (Incomplete sequence)
\\leftda                            \\leftda                     "            : (Incomplete sequence)
\\leftdas                           \\leftdas                    "            : (Incomplete sequence)
\\leftdash                          \\leftdash                   "            : (Incomplete sequence)
\\leftdasha                         \\leftdasha                  "            : (Incomplete sequence)
\\leftdashar                        \\leftdashar                 "            : (Incomplete sequence)
\\leftdasharr                       \\leftdasharr                "            : (Incomplete sequence)
\\leftdasharro                      \\leftdasharro               "            : (Incomplete sequence)
\\leftdasharrow                     <char-0x021E0>               " ⇠          : LEFTWARDS DASHED ARROW / LEFT DASHED ARROW
\\leftdb                            \\leftdb                     "            : (Incomplete sequence)
\\leftdbk                           \\leftdbk                    "            : (Incomplete sequence)
\\leftdbka                          \\leftdbka                   "            : (Incomplete sequence)
\\leftdbkar                         \\leftdbkar                  "            : (Incomplete sequence)
\\leftdbkarr                        \\leftdbkarr                 "            : (Incomplete sequence)
\\leftdbkarro                       \\leftdbkarro                "            : (Incomplete sequence)
\\leftdbkarrow                      <char-0x0290E>               " ⤎          : LEFTWARDS TRIPLE DASH ARROW
\\leftdo                            \\leftdo                     "            : (Incomplete sequence)
\\leftdot                           \\leftdot                    "            : (Incomplete sequence)
\\leftdota                          \\leftdota                   "            : (Incomplete sequence)
\\leftdotar                         \\leftdotar                  "            : (Incomplete sequence)
\\leftdotarr                        \\leftdotarr                 "            : (Incomplete sequence)
\\leftdotarro                       \\leftdotarro                "            : (Incomplete sequence)
\\leftdotarrow                      <char-0x02B38>               " ⬸          : LEFTWARDS ARROW WITH DOTTED STEM
\\lefth                             \\lefth                      "            : (Incomplete sequence)
\\leftha                            \\leftha                     "            : (Incomplete sequence)
\\lefthar                           \\lefthar                    "            : (Incomplete sequence)
\\leftharp                          \\leftharp                   "            : (Incomplete sequence)
\\leftharpo                         \\leftharpo                  "            : (Incomplete sequence)
\\leftharpoo                        \\leftharpoo                 "            : (Incomplete sequence)
\\leftharpoon                       \\leftharpoon                "            : (Incomplete sequence)
\\leftharpoona                      \\leftharpoona               "            : (Incomplete sequence)
\\leftharpoonac                     \\leftharpoonac              "            : (Incomplete sequence)
\\leftharpoonacc                    \\leftharpoonacc             "            : (Incomplete sequence)
\\leftharpoonacce                   \\leftharpoonacce            "            : (Incomplete sequence)
\\leftharpoonaccen                  \\leftharpoonaccen           "            : (Incomplete sequence)
\\leftharpoonaccent                 <char-0x020D0>               " ◌⃐         : COMBINING LEFT HARPOON ABOVE / NON-SPACING LEFT HARPOON ABOVE
\\leftharpoond                      \\leftharpoond               "            : (Incomplete sequence)
\\leftharpoondo                     \\leftharpoondo              "            : (Incomplete sequence)
\\leftharpoondow                    \\leftharpoondow             "            : (Incomplete sequence)
\\leftharpoondown                   <char-0x021BD>               " ↽          : LEFTWARDS HARPOON WITH BARB DOWNWARDS / LEFT HARPOON WITH BARB DOWN
\\leftharpoons                      \\leftharpoons               "            : (Incomplete sequence)
\\leftharpoonsu                     \\leftharpoonsu              "            : (Incomplete sequence)
\\leftharpoonsup                    \\leftharpoonsup             "            : (Incomplete sequence)
\\leftharpoonsupd                   \\leftharpoonsupd            "            : (Incomplete sequence)
\\leftharpoonsupdo                  \\leftharpoonsupdo           "            : (Incomplete sequence)
\\leftharpoonsupdow                 \\leftharpoonsupdow          "            : (Incomplete sequence)
\\leftharpoonsupdown                <char-0x02962>               " ⥢          : LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
\\leftharpoonu                      \\leftharpoonu               "            : (Incomplete sequence)
\\leftharpoonup                     <char-0x021BC>               " ↼          : LEFTWARDS HARPOON WITH BARB UPWARDS / LEFT HARPOON WITH BARB UP
\\leftharpoonup<Tab>                <char-0x021BC>               " ↼          : LEFTWARDS HARPOON WITH BARB UPWARDS / LEFT HARPOON WITH BARB UP
\\leftharpoonupd                    \\leftharpoonupd             "            : (Incomplete sequence)
\\leftharpoonupda                   \\leftharpoonupda            "            : (Incomplete sequence)
\\leftharpoonupdas                  \\leftharpoonupdas           "            : (Incomplete sequence)
\\leftharpoonupdash                 <char-0x0296A>               " ⥪          : LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
\\leftl                             \\leftl                      "            : (Incomplete sequence)
\\leftle                            \\leftle                     "            : (Incomplete sequence)
\\leftlef                           \\leftlef                    "            : (Incomplete sequence)
\\leftleft                          \\leftleft                   "            : (Incomplete sequence)
\\leftlefta                         \\leftlefta                  "            : (Incomplete sequence)
\\leftleftar                        \\leftleftar                 "            : (Incomplete sequence)
\\leftleftarr                       \\leftleftarr                "            : (Incomplete sequence)
\\leftleftarro                      \\leftleftarro               "            : (Incomplete sequence)
\\leftleftarrow                     \\leftleftarrow              "            : (Incomplete sequence)
\\leftleftarrows                    <char-0x021C7>               " ⇇          : LEFTWARDS PAIRED ARROWS / LEFT PAIRED ARROWS
\\leftm                             \\leftm                      "            : (Incomplete sequence)
\\leftmo                            \\leftmo                     "            : (Incomplete sequence)
\\leftmoo                           \\leftmoo                    "            : (Incomplete sequence)
\\leftmoon                          <char-0x0263E>               " ☾          : LAST QUARTER MOON
\\lefto                             \\lefto                      "            : (Incomplete sequence)
\\leftou                            \\leftou                     "            : (Incomplete sequence)
\\leftout                           \\leftout                    "            : (Incomplete sequence)
\\leftoute                          \\leftoute                   "            : (Incomplete sequence)
\\leftouter                         \\leftouter                  "            : (Incomplete sequence)
\\leftouterj                        \\leftouterj                 "            : (Incomplete sequence)
\\leftouterjo                       \\leftouterjo                "            : (Incomplete sequence)
\\leftouterjoi                      \\leftouterjoi               "            : (Incomplete sequence)
\\leftouterjoin                     <char-0x027D5>               " ⟕          : LEFT OUTER JOIN
\\leftr                             \\leftr                      "            : (Incomplete sequence)
\\leftri                            \\leftri                     "            : (Incomplete sequence)
\\leftrig                           \\leftrig                    "            : (Incomplete sequence)
\\leftrigh                          \\leftrigh                   "            : (Incomplete sequence)
\\leftright                         \\leftright                  "            : (Incomplete sequence)
\\leftrighta                        \\leftrighta                 "            : (Incomplete sequence)
\\leftrightar                       \\leftrightar                "            : (Incomplete sequence)
\\leftrightarr                      \\leftrightarr               "            : (Incomplete sequence)
\\leftrightarro                     \\leftrightarro              "            : (Incomplete sequence)
\\leftrightarrow                    <char-0x02194>               " ↔          : LEFT RIGHT ARROW
\\leftrightarrow<Tab>               <char-0x02194>               " ↔          : LEFT RIGHT ARROW
\\leftrightarrowc                   \\leftrightarrowc            "            : (Incomplete sequence)
\\leftrightarrowci                  \\leftrightarrowci           "            : (Incomplete sequence)
\\leftrightarrowcir                 \\leftrightarrowcir          "            : (Incomplete sequence)
\\leftrightarrowcirc                \\leftrightarrowcirc         "            : (Incomplete sequence)
\\leftrightarrowcircl               \\leftrightarrowcircl        "            : (Incomplete sequence)
\\leftrightarrowcircle              <char-0x02948>               " ⥈          : LEFT RIGHT ARROW THROUGH SMALL CIRCLE
\\leftrightarrows                   <char-0x021C6>               " ⇆          : LEFTWARDS ARROW OVER RIGHTWARDS ARROW / LEFT ARROW OVER RIGHT ARROW
\\leftrightarrowt                   \\leftrightarrowt            "            : (Incomplete sequence)
\\leftrightarrowtr                  \\leftrightarrowtr           "            : (Incomplete sequence)
\\leftrightarrowtri                 \\leftrightarrowtri          "            : (Incomplete sequence)
\\leftrightarrowtria                \\leftrightarrowtria         "            : (Incomplete sequence)
\\leftrightarrowtrian               \\leftrightarrowtrian        "            : (Incomplete sequence)
\\leftrightarrowtriang              \\leftrightarrowtriang       "            : (Incomplete sequence)
\\leftrightarrowtriangl             \\leftrightarrowtriangl      "            : (Incomplete sequence)
\\leftrightarrowtriangle            <char-0x021FF>               " ⇿          : LEFT RIGHT OPEN-HEADED ARROW
\\leftrighth                        \\leftrighth                 "            : (Incomplete sequence)
\\leftrightha                       \\leftrightha                "            : (Incomplete sequence)
\\leftrighthar                      \\leftrighthar               "            : (Incomplete sequence)
\\leftrightharp                     \\leftrightharp              "            : (Incomplete sequence)
\\leftrightharpo                    \\leftrightharpo             "            : (Incomplete sequence)
\\leftrightharpoo                   \\leftrightharpoo            "            : (Incomplete sequence)
\\leftrightharpoon                  \\leftrightharpoon           "            : (Incomplete sequence)
\\leftrightharpoond                 \\leftrightharpoond          "            : (Incomplete sequence)
\\leftrightharpoondo                \\leftrightharpoondo         "            : (Incomplete sequence)
\\leftrightharpoondow               \\leftrightharpoondow        "            : (Incomplete sequence)
\\leftrightharpoondown              \\leftrightharpoondown       "            : (Incomplete sequence)
\\leftrightharpoondownu             \\leftrightharpoondownu      "            : (Incomplete sequence)
\\leftrightharpoondownup            <char-0x0294B>               " ⥋          : LEFT BARB DOWN RIGHT BARB UP HARPOON
\\leftrightharpoons                 <char-0x021CB>               " ⇋          : LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON / LEFT HARPOON OVER RIGHT HARPOON
\\leftrightharpoons<Tab>            <char-0x021CB>               " ⇋          : LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON / LEFT HARPOON OVER RIGHT HARPOON
\\leftrightharpoonsd                \\leftrightharpoonsd         "            : (Incomplete sequence)
\\leftrightharpoonsdo               \\leftrightharpoonsdo        "            : (Incomplete sequence)
\\leftrightharpoonsdow              \\leftrightharpoonsdow       "            : (Incomplete sequence)
\\leftrightharpoonsdown             <char-0x02967>               " ⥧          : LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
\\leftrightharpoonsu                \\leftrightharpoonsu         "            : (Incomplete sequence)
\\leftrightharpoonsup               <char-0x02966>               " ⥦          : LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
\\leftrightharpoonu                 \\leftrightharpoonu          "            : (Incomplete sequence)
\\leftrightharpoonup                \\leftrightharpoonup         "            : (Incomplete sequence)
\\leftrightharpoonupd               \\leftrightharpoonupd        "            : (Incomplete sequence)
\\leftrightharpoonupdo              \\leftrightharpoonupdo       "            : (Incomplete sequence)
\\leftrightharpoonupdow             \\leftrightharpoonupdow      "            : (Incomplete sequence)
\\leftrightharpoonupdown            <char-0x0294A>               " ⥊          : LEFT BARB UP RIGHT BARB DOWN HARPOON
\\leftrights                        \\leftrights                 "            : (Incomplete sequence)
\\leftrightsq                       \\leftrightsq                "            : (Incomplete sequence)
\\leftrightsqu                      \\leftrightsqu               "            : (Incomplete sequence)
\\leftrightsqui                     \\leftrightsqui              "            : (Incomplete sequence)
\\leftrightsquig                    \\leftrightsquig             "            : (Incomplete sequence)
\\leftrightsquiga                   \\leftrightsquiga            "            : (Incomplete sequence)
\\leftrightsquigar                  \\leftrightsquigar           "            : (Incomplete sequence)
\\leftrightsquigarr                 \\leftrightsquigarr          "            : (Incomplete sequence)
\\leftrightsquigarro                \\leftrightsquigarro         "            : (Incomplete sequence)
\\leftrightsquigarrow               <char-0x021AD>               " ↭          : LEFT RIGHT WAVE ARROW
\\lefts                             \\lefts                      "            : (Incomplete sequence)
\\leftsq                            \\leftsq                     "            : (Incomplete sequence)
\\leftsqu                           \\leftsqu                    "            : (Incomplete sequence)
\\leftsqui                          \\leftsqui                   "            : (Incomplete sequence)
\\leftsquig                         \\leftsquig                  "            : (Incomplete sequence)
\\leftsquiga                        \\leftsquiga                 "            : (Incomplete sequence)
\\leftsquigar                       \\leftsquigar                "            : (Incomplete sequence)
\\leftsquigarr                      \\leftsquigarr               "            : (Incomplete sequence)
\\leftsquigarro                     \\leftsquigarro              "            : (Incomplete sequence)
\\leftsquigarrow                    <char-0x021DC>               " ⇜          : LEFTWARDS SQUIGGLE ARROW / LEFT SQUIGGLE ARROW
\\leftt                             \\leftt                      "            : (Incomplete sequence)
\\leftth                            \\leftth                     "            : (Incomplete sequence)
\\leftthr                           \\leftthr                    "            : (Incomplete sequence)
\\leftthre                          \\leftthre                   "            : (Incomplete sequence)
\\leftthree                         \\leftthree                  "            : (Incomplete sequence)
\\leftthreea                        \\leftthreea                 "            : (Incomplete sequence)
\\leftthreear                       \\leftthreear                "            : (Incomplete sequence)
\\leftthreearr                      \\leftthreearr               "            : (Incomplete sequence)
\\leftthreearro                     \\leftthreearro              "            : (Incomplete sequence)
\\leftthreearrow                    \\leftthreearrow             "            : (Incomplete sequence)
\\leftthreearrows                   <char-0x02B31>               " ⬱          : THREE LEFTWARDS ARROWS
\\leftthreet                        \\leftthreet                 "            : (Incomplete sequence)
\\leftthreeti                       \\leftthreeti                "            : (Incomplete sequence)
\\leftthreetim                      \\leftthreetim               "            : (Incomplete sequence)
\\leftthreetime                     \\leftthreetime              "            : (Incomplete sequence)
\\leftthreetimes                    <char-0x022CB>               " ⋋          : LEFT SEMIDIRECT PRODUCT
\\leftw                             \\leftw                      "            : (Incomplete sequence)
\\leftwa                            \\leftwa                     "            : (Incomplete sequence)
\\leftwav                           \\leftwav                    "            : (Incomplete sequence)
\\leftwave                          \\leftwave                   "            : (Incomplete sequence)
\\leftwavea                         \\leftwavea                  "            : (Incomplete sequence)
\\leftwavear                        \\leftwavear                 "            : (Incomplete sequence)
\\leftwavearr                       \\leftwavearr                "            : (Incomplete sequence)
\\leftwavearro                      \\leftwavearro               "            : (Incomplete sequence)
\\leftwavearrow                     <char-0x0219C>               " ↜          : LEFTWARDS WAVE ARROW / LEFT WAVE ARROW
\\leftwh                            \\leftwh                     "            : (Incomplete sequence)
\\leftwhi                           \\leftwhi                    "            : (Incomplete sequence)
\\leftwhit                          \\leftwhit                   "            : (Incomplete sequence)
\\leftwhite                         \\leftwhite                  "            : (Incomplete sequence)
\\leftwhitea                        \\leftwhitea                 "            : (Incomplete sequence)
\\leftwhitear                       \\leftwhitear                "            : (Incomplete sequence)
\\leftwhitearr                      \\leftwhitearr               "            : (Incomplete sequence)
\\leftwhitearro                     \\leftwhitearro              "            : (Incomplete sequence)
\\leftwhitearrow                    <char-0x021E6>               " ⇦          : LEFTWARDS WHITE ARROW / WHITE LEFT ARROW
\\leo                               <char-0x0264C>               " ♌          : LEO
\\leq                               \\leq                        "            : (Incomplete sequence)
\\leqq                              <char-0x02266>               " ≦          : LESS-THAN OVER EQUAL TO / LESS THAN OVER EQUAL TO
\\leqq<Tab>                         <char-0x02266>               " ≦          : LESS-THAN OVER EQUAL TO / LESS THAN OVER EQUAL TO
\\leqqs                             \\leqqs                      "            : (Incomplete sequence)
\\leqqsl                            \\leqqsl                     "            : (Incomplete sequence)
\\leqqsla                           \\leqqsla                    "            : (Incomplete sequence)
\\leqqslan                          \\leqqslan                   "            : (Incomplete sequence)
\\leqqslant                         <char-0x02AF9>               " ⫹          : DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO
\\leqs                              \\leqs                       "            : (Incomplete sequence)
\\leqsl                             \\leqsl                      "            : (Incomplete sequence)
\\leqsla                            \\leqsla                     "            : (Incomplete sequence)
\\leqslan                           \\leqslan                    "            : (Incomplete sequence)
\\leqslant                          <char-0x02A7D>               " ⩽          : LESS-THAN OR SLANTED EQUAL TO
\\les                               \\les                        "            : (Incomplete sequence)
\\lesc                              \\lesc                       "            : (Incomplete sequence)
\\lescc                             <char-0x02AA8>               " ⪨          : LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
\\lesd                              \\lesd                       "            : (Incomplete sequence)
\\lesdo                             \\lesdo                      "            : (Incomplete sequence)
\\lesdot                            <char-0x02A7F>               " ⩿          : LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\lesdot<Tab>                       <char-0x02A7F>               " ⩿          : LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\lesdoto                           <char-0x02A81>               " ⪁          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\lesdoto<Tab>                      <char-0x02A81>               " ⪁          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\lesdotor                          <char-0x02A83>               " ⪃          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
\\lesg                              \\lesg                       "            : (Incomplete sequence)
\\lesge                             \\lesge                      "            : (Incomplete sequence)
\\lesges                            <char-0x02A93>               " ⪓          : LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
\\less                              \\less                       "            : (Incomplete sequence)
\\lessa                             \\lessa                      "            : (Incomplete sequence)
\\lessap                            \\lessap                     "            : (Incomplete sequence)
\\lessapp                           \\lessapp                    "            : (Incomplete sequence)
\\lessappr                          \\lessappr                   "            : (Incomplete sequence)
\\lessappro                         \\lessappro                  "            : (Incomplete sequence)
\\lessapprox                        <char-0x02A85>               " ⪅          : LESS-THAN OR APPROXIMATE
\\lessd                             \\lessd                      "            : (Incomplete sequence)
\\lessdo                            \\lessdo                     "            : (Incomplete sequence)
\\lessdot                           <char-0x022D6>               " ⋖          : LESS-THAN WITH DOT / LESS THAN WITH DOT
\\lesse                             \\lesse                      "            : (Incomplete sequence)
\\lesseq                            \\lesseq                     "            : (Incomplete sequence)
\\lesseqg                           \\lesseqg                    "            : (Incomplete sequence)
\\lesseqgt                          \\lesseqgt                   "            : (Incomplete sequence)
\\lesseqgtr                         <char-0x022DA>               " ⋚          : LESS-THAN EQUAL TO OR GREATER-THAN / LESS THAN EQUAL TO OR GREATER THAN
\\lesseqq                           \\lesseqq                    "            : (Incomplete sequence)
\\lesseqqg                          \\lesseqqg                   "            : (Incomplete sequence)
\\lesseqqgt                         \\lesseqqgt                  "            : (Incomplete sequence)
\\lesseqqgtr                        <char-0x02A8B>               " ⪋          : LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
\\lessg                             \\lessg                      "            : (Incomplete sequence)
\\lessgt                            \\lessgt                     "            : (Incomplete sequence)
\\lessgtr                           <char-0x02276>               " ≶          : LESS-THAN OR GREATER-THAN / LESS THAN OR GREATER THAN
\\lesss                             \\lesss                      "            : (Incomplete sequence)
\\lesssi                            \\lesssi                     "            : (Incomplete sequence)
\\lesssim                           <char-0x02272>               " ≲          : LESS-THAN OR EQUIVALENT TO / LESS THAN OR EQUIVALENT TO
\\lf                                \\lf                         "            : (Incomplete sequence)
\\lfl                               \\lfl                        "            : (Incomplete sequence)
\\lflo                              \\lflo                       "            : (Incomplete sequence)
\\lfloo                             \\lfloo                      "            : (Incomplete sequence)
\\lfloor                            <char-0x0230A>               " ⌊          : LEFT FLOOR
\\lg                                \\lg                         "            : (Incomplete sequence)
\\lgE                               <char-0x02A91>               " ⪑          : LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
\\lgb                               \\lgb                        "            : (Incomplete sequence)
\\lgbl                              \\lgbl                       "            : (Incomplete sequence)
\\lgblk                             \\lgblk                      "            : (Incomplete sequence)
\\lgblkc                            \\lgblkc                     "            : (Incomplete sequence)
\\lgblkci                           \\lgblkci                    "            : (Incomplete sequence)
\\lgblkcir                          \\lgblkcir                   "            : (Incomplete sequence)
\\lgblkcirc                         \\lgblkcirc                  "            : (Incomplete sequence)
\\lgblkcircl                        \\lgblkcircl                 "            : (Incomplete sequence)
\\lgblkcircle                       <char-0x02B24>               " ⬤          : BLACK LARGE CIRCLE
\\lgblks                            \\lgblks                     "            : (Incomplete sequence)
\\lgblksq                           \\lgblksq                    "            : (Incomplete sequence)
\\lgblksqu                          \\lgblksqu                   "            : (Incomplete sequence)
\\lgblksqua                         \\lgblksqua                  "            : (Incomplete sequence)
\\lgblksquar                        \\lgblksquar                 "            : (Incomplete sequence)
\\lgblksquare                       <char-0x02B1B>               " ⬛          : BLACK LARGE SQUARE
\\lgw                               \\lgw                        "            : (Incomplete sequence)
\\lgwh                              \\lgwh                       "            : (Incomplete sequence)
\\lgwht                             \\lgwht                      "            : (Incomplete sequence)
\\lgwhtc                            \\lgwhtc                     "            : (Incomplete sequence)
\\lgwhtci                           \\lgwhtci                    "            : (Incomplete sequence)
\\lgwhtcir                          \\lgwhtcir                   "            : (Incomplete sequence)
\\lgwhtcirc                         \\lgwhtcirc                  "            : (Incomplete sequence)
\\lgwhtcircl                        \\lgwhtcircl                 "            : (Incomplete sequence)
\\lgwhtcircle                       <char-0x025EF>               " ◯          : LARGE CIRCLE
\\lgwhts                            \\lgwhts                     "            : (Incomplete sequence)
\\lgwhtsq                           \\lgwhtsq                    "            : (Incomplete sequence)
\\lgwhtsqu                          \\lgwhtsqu                   "            : (Incomplete sequence)
\\lgwhtsqua                         \\lgwhtsqua                  "            : (Incomplete sequence)
\\lgwhtsquar                        \\lgwhtsquar                 "            : (Incomplete sequence)
\\lgwhtsquare                       <char-0x02B1C>               " ⬜          : WHITE LARGE SQUARE
\\li                                \\li                         "            : (Incomplete sequence)
\\lib                               \\lib                        "            : (Incomplete sequence)
\\libr                              \\libr                       "            : (Incomplete sequence)
\\libra                             <char-0x0264E>               " ♎          : LIBRA
\\lin                               \\lin                        "            : (Incomplete sequence)
\\line                              \\line                       "            : (Incomplete sequence)
\\linef                             \\linef                      "            : (Incomplete sequence)
\\linefe                            \\linefe                     "            : (Incomplete sequence)
\\linefee                           \\linefee                    "            : (Incomplete sequence)
\\linefeed                          <char-0x021B4>               " ↴          : RIGHTWARDS ARROW WITH CORNER DOWNWARDS / RIGHT ARROW WITH CORNER DOWN
\\ll                                <char-0x0226A>               " ≪          : MUCH LESS-THAN / MUCH LESS THAN
\\ll<Tab>                           <char-0x0226A>               " ≪          : MUCH LESS-THAN / MUCH LESS THAN
\\lla                               \\lla                        "            : (Incomplete sequence)
\\llar                              \\llar                       "            : (Incomplete sequence)
\\llarc                             <char-0x025DF>               " ◟          : LOWER LEFT QUADRANT CIRCULAR ARC
\\llb                               \\llb                        "            : (Incomplete sequence)
\\llbl                              \\llbl                       "            : (Incomplete sequence)
\\llbla                             \\llbla                      "            : (Incomplete sequence)
\\llblac                            \\llblac                     "            : (Incomplete sequence)
\\llblack                           \\llblack                    "            : (Incomplete sequence)
\\llblackt                          \\llblackt                   "            : (Incomplete sequence)
\\llblacktr                         \\llblacktr                  "            : (Incomplete sequence)
\\llblacktri                        \\llblacktri                 "            : (Incomplete sequence)
\\llblacktria                       \\llblacktria                "            : (Incomplete sequence)
\\llblacktrian                      \\llblacktrian               "            : (Incomplete sequence)
\\llblacktriang                     \\llblacktriang              "            : (Incomplete sequence)
\\llblacktriangl                    \\llblacktriangl             "            : (Incomplete sequence)
\\llblacktriangle                   <char-0x025E3>               " ◣          : BLACK LOWER LEFT TRIANGLE
\\llbr                              \\llbr                       "            : (Incomplete sequence)
\\llbra                             \\llbra                      "            : (Incomplete sequence)
\\llbrac                            \\llbrac                     "            : (Incomplete sequence)
\\llbrack                           \\llbrack                    "            : (Incomplete sequence)
\\llbracke                          \\llbracke                   "            : (Incomplete sequence)
\\llbracket                         <char-0x027E6>               " ⟦          : MATHEMATICAL LEFT WHITE SQUARE BRACKET
\\llc                               \\llc                        "            : (Incomplete sequence)
\\llco                              \\llco                       "            : (Incomplete sequence)
\\llcor                             \\llcor                      "            : (Incomplete sequence)
\\llcorn                            \\llcorn                     "            : (Incomplete sequence)
\\llcorne                           \\llcorne                    "            : (Incomplete sequence)
\\llcorner                          <char-0x0231E>               " ⌞          : BOTTOM LEFT CORNER
\\lll                               \\lll                        "            : (Incomplete sequence)
\\llln                              \\llln                       "            : (Incomplete sequence)
\\lllne                             \\lllne                      "            : (Incomplete sequence)
\\lllnes                            \\lllnes                     "            : (Incomplete sequence)
\\lllnest                           <char-0x02AF7>               " ⫷          : TRIPLE NESTED LESS-THAN
\\llt                               \\llt                        "            : (Incomplete sequence)
\\lltr                              \\lltr                       "            : (Incomplete sequence)
\\lltri                             \\lltri                      "            : (Incomplete sequence)
\\lltria                            \\lltria                     "            : (Incomplete sequence)
\\lltrian                           \\lltrian                    "            : (Incomplete sequence)
\\lltriang                          \\lltriang                   "            : (Incomplete sequence)
\\lltriangl                         \\lltriangl                  "            : (Incomplete sequence)
\\lltriangle                        <char-0x025FA>               " ◺          : LOWER LEFT TRIANGLE
\\lm                                \\lm                         "            : (Incomplete sequence)
\\lmo                               \\lmo                        "            : (Incomplete sequence)
\\lmou                              \\lmou                       "            : (Incomplete sequence)
\\lmous                             \\lmous                      "            : (Incomplete sequence)
\\lmoust                            \\lmoust                     "            : (Incomplete sequence)
\\lmousta                           \\lmousta                    "            : (Incomplete sequence)
\\lmoustac                          \\lmoustac                   "            : (Incomplete sequence)
\\lmoustach                         \\lmoustach                  "            : (Incomplete sequence)
\\lmoustache                        <char-0x023B0>               " ⎰          : UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
\\lmr                               \\lmr                        "            : (Incomplete sequence)
\\lmrk                              <char-0x002D0>               " ː          : MODIFIER LETTER TRIANGULAR COLON
\\ln                                \\ln                         "            : (Incomplete sequence)
\\lna                               \\lna                        "            : (Incomplete sequence)
\\lnap                              \\lnap                       "            : (Incomplete sequence)
\\lnapp                             \\lnapp                      "            : (Incomplete sequence)
\\lnappr                            \\lnappr                     "            : (Incomplete sequence)
\\lnappro                           \\lnappro                    "            : (Incomplete sequence)
\\lnapprox                          <char-0x02A89>               " ⪉          : LESS-THAN AND NOT APPROXIMATE
\\lne                               \\lne                        "            : (Incomplete sequence)
\\lneq                              <char-0x02A87>               " ⪇          : LESS-THAN AND SINGLE-LINE NOT EQUAL TO
\\lneq<Tab>                         <char-0x02A87>               " ⪇          : LESS-THAN AND SINGLE-LINE NOT EQUAL TO
\\lneqq                             <char-0x02268>               " ≨          : LESS-THAN BUT NOT EQUAL TO / LESS THAN BUT NOT EQUAL TO
\\lns                               \\lns                        "            : (Incomplete sequence)
\\lnsi                              \\lnsi                       "            : (Incomplete sequence)
\\lnsim                             <char-0x022E6>               " ⋦          : LESS-THAN BUT NOT EQUIVALENT TO / LESS THAN BUT NOT EQUIVALENT TO
\\lo                                \\lo                         "            : (Incomplete sequence)
\\lon                               \\lon                        "            : (Incomplete sequence)
\\long                              \\long                       "            : (Incomplete sequence)
\\longl                             \\longl                      "            : (Incomplete sequence)
\\longle                            \\longle                     "            : (Incomplete sequence)
\\longlef                           \\longlef                    "            : (Incomplete sequence)
\\longleft                          \\longleft                   "            : (Incomplete sequence)
\\longlefta                         \\longlefta                  "            : (Incomplete sequence)
\\longleftar                        \\longleftar                 "            : (Incomplete sequence)
\\longleftarr                       \\longleftarr                "            : (Incomplete sequence)
\\longleftarro                      \\longleftarro               "            : (Incomplete sequence)
\\longleftarrow                     <char-0x027F5>               " ⟵          : LONG LEFTWARDS ARROW
\\longleftr                         \\longleftr                  "            : (Incomplete sequence)
\\longleftri                        \\longleftri                 "            : (Incomplete sequence)
\\longleftrig                       \\longleftrig                "            : (Incomplete sequence)
\\longleftrigh                      \\longleftrigh               "            : (Incomplete sequence)
\\longleftright                     \\longleftright              "            : (Incomplete sequence)
\\longleftrighta                    \\longleftrighta             "            : (Incomplete sequence)
\\longleftrightar                   \\longleftrightar            "            : (Incomplete sequence)
\\longleftrightarr                  \\longleftrightarr           "            : (Incomplete sequence)
\\longleftrightarro                 \\longleftrightarro          "            : (Incomplete sequence)
\\longleftrightarrow                <char-0x027F7>               " ⟷          : LONG LEFT RIGHT ARROW
\\longlefts                         \\longlefts                  "            : (Incomplete sequence)
\\longleftsq                        \\longleftsq                 "            : (Incomplete sequence)
\\longleftsqu                       \\longleftsqu                "            : (Incomplete sequence)
\\longleftsqui                      \\longleftsqui               "            : (Incomplete sequence)
\\longleftsquig                     \\longleftsquig              "            : (Incomplete sequence)
\\longleftsquiga                    \\longleftsquiga             "            : (Incomplete sequence)
\\longleftsquigar                   \\longleftsquigar            "            : (Incomplete sequence)
\\longleftsquigarr                  \\longleftsquigarr           "            : (Incomplete sequence)
\\longleftsquigarro                 \\longleftsquigarro          "            : (Incomplete sequence)
\\longleftsquigarrow                <char-0x02B33>               " ⬳          : LONG LEFTWARDS SQUIGGLE ARROW
\\longm                             \\longm                      "            : (Incomplete sequence)
\\longma                            \\longma                     "            : (Incomplete sequence)
\\longmap                           \\longmap                    "            : (Incomplete sequence)
\\longmaps                          \\longmaps                   "            : (Incomplete sequence)
\\longmapsf                         \\longmapsf                  "            : (Incomplete sequence)
\\longmapsfr                        \\longmapsfr                 "            : (Incomplete sequence)
\\longmapsfro                       \\longmapsfro                "            : (Incomplete sequence)
\\longmapsfrom                      <char-0x027FB>               " ⟻          : LONG LEFTWARDS ARROW FROM BAR
\\longmapst                         \\longmapst                  "            : (Incomplete sequence)
\\longmapsto                        <char-0x027FC>               " ⟼          : LONG RIGHTWARDS ARROW FROM BAR
\\longr                             \\longr                      "            : (Incomplete sequence)
\\longri                            \\longri                     "            : (Incomplete sequence)
\\longrig                           \\longrig                    "            : (Incomplete sequence)
\\longrigh                          \\longrigh                   "            : (Incomplete sequence)
\\longright                         \\longright                  "            : (Incomplete sequence)
\\longrighta                        \\longrighta                 "            : (Incomplete sequence)
\\longrightar                       \\longrightar                "            : (Incomplete sequence)
\\longrightarr                      \\longrightarr               "            : (Incomplete sequence)
\\longrightarro                     \\longrightarro              "            : (Incomplete sequence)
\\longrightarrow                    <char-0x027F6>               " ⟶          : LONG RIGHTWARDS ARROW
\\longrights                        \\longrights                 "            : (Incomplete sequence)
\\longrightsq                       \\longrightsq                "            : (Incomplete sequence)
\\longrightsqu                      \\longrightsqu               "            : (Incomplete sequence)
\\longrightsqui                     \\longrightsqui              "            : (Incomplete sequence)
\\longrightsquig                    \\longrightsquig             "            : (Incomplete sequence)
\\longrightsquiga                   \\longrightsquiga            "            : (Incomplete sequence)
\\longrightsquigar                  \\longrightsquigar           "            : (Incomplete sequence)
\\longrightsquigarr                 \\longrightsquigarr          "            : (Incomplete sequence)
\\longrightsquigarro                \\longrightsquigarro         "            : (Incomplete sequence)
\\longrightsquigarrow               <char-0x027FF>               " ⟿          : LONG RIGHTWARDS SQUIGGLE ARROW
\\loo                               \\loo                        "            : (Incomplete sequence)
\\loop                              \\loop                       "            : (Incomplete sequence)
\\loopa                             \\loopa                      "            : (Incomplete sequence)
\\loopar                            \\loopar                     "            : (Incomplete sequence)
\\looparr                           \\looparr                    "            : (Incomplete sequence)
\\looparro                          \\looparro                   "            : (Incomplete sequence)
\\looparrow                         \\looparrow                  "            : (Incomplete sequence)
\\looparrowl                        \\looparrowl                 "            : (Incomplete sequence)
\\looparrowle                       \\looparrowle                "            : (Incomplete sequence)
\\looparrowlef                      \\looparrowlef               "            : (Incomplete sequence)
\\looparrowleft                     <char-0x021AB>               " ↫          : LEFTWARDS ARROW WITH LOOP / LEFT ARROW WITH LOOP
\\looparrowr                        \\looparrowr                 "            : (Incomplete sequence)
\\looparrowri                       \\looparrowri                "            : (Incomplete sequence)
\\looparrowrig                      \\looparrowrig               "            : (Incomplete sequence)
\\looparrowrigh                     \\looparrowrigh              "            : (Incomplete sequence)
\\looparrowright                    <char-0x021AC>               " ↬          : RIGHTWARDS ARROW WITH LOOP / RIGHT ARROW WITH LOOP
\\low                               <char-0x002D5>               " ˕          : MODIFIER LETTER DOWN TACK
\\low<Tab>                          <char-0x002D5>               " ˕          : MODIFIER LETTER DOWN TACK
\\lowi                              \\lowi                       "            : (Incomplete sequence)
\\lowin                             \\lowin                      "            : (Incomplete sequence)
\\lowint                            <char-0x02A1C>               " ⨜          : INTEGRAL WITH UNDERBAR
\\loz                               \\loz                        "            : (Incomplete sequence)
\\loze                              \\loze                       "            : (Incomplete sequence)
\\lozen                             \\lozen                      "            : (Incomplete sequence)
\\lozeng                            \\lozeng                     "            : (Incomplete sequence)
\\lozenge                           <char-0x025CA>               " ◊          : LOZENGE
\\lp                                \\lp                         "            : (Incomplete sequence)
\\lpa                               \\lpa                        "            : (Incomplete sequence)
\\lpar                              \\lpar                       "            : (Incomplete sequence)
\\lparg                             \\lparg                      "            : (Incomplete sequence)
\\lpargt                            <char-0x029A0>               " ⦠          : SPHERICAL ANGLE OPENING LEFT
\\lq                                <char-0x02018>               " ‘          : LEFT SINGLE QUOTATION MARK / SINGLE TURNED COMMA QUOTATION MARK
\\lr                                \\lr                         "            : (Incomplete sequence)
\\lra                               \\lra                        "            : (Incomplete sequence)
\\lrar                              \\lrar                       "            : (Incomplete sequence)
\\lrarc                             <char-0x025DE>               " ◞          : LOWER RIGHT QUADRANT CIRCULAR ARC
\\lrb                               \\lrb                        "            : (Incomplete sequence)
\\lrbl                              \\lrbl                       "            : (Incomplete sequence)
\\lrbla                             \\lrbla                      "            : (Incomplete sequence)
\\lrblac                            \\lrblac                     "            : (Incomplete sequence)
\\lrblack                           \\lrblack                    "            : (Incomplete sequence)
\\lrblackt                          \\lrblackt                   "            : (Incomplete sequence)
\\lrblacktr                         \\lrblacktr                  "            : (Incomplete sequence)
\\lrblacktri                        \\lrblacktri                 "            : (Incomplete sequence)
\\lrblacktria                       \\lrblacktria                "            : (Incomplete sequence)
\\lrblacktrian                      \\lrblacktrian               "            : (Incomplete sequence)
\\lrblacktriang                     \\lrblacktriang              "            : (Incomplete sequence)
\\lrblacktriangl                    \\lrblacktriangl             "            : (Incomplete sequence)
\\lrblacktriangle                   <char-0x025E2>               " ◢          : BLACK LOWER RIGHT TRIANGLE
\\lrc                               \\lrc                        "            : (Incomplete sequence)
\\lrco                              \\lrco                       "            : (Incomplete sequence)
\\lrcor                             \\lrcor                      "            : (Incomplete sequence)
\\lrcorn                            \\lrcorn                     "            : (Incomplete sequence)
\\lrcorne                           \\lrcorne                    "            : (Incomplete sequence)
\\lrcorner                          <char-0x0231F>               " ⌟          : BOTTOM RIGHT CORNER
\\lrt                               \\lrt                        "            : (Incomplete sequence)
\\lrtr                              \\lrtr                       "            : (Incomplete sequence)
\\lrtri                             \\lrtri                      "            : (Incomplete sequence)
\\lrtria                            \\lrtria                     "            : (Incomplete sequence)
\\lrtrian                           \\lrtrian                    "            : (Incomplete sequence)
\\lrtriang                          \\lrtriang                   "            : (Incomplete sequence)
\\lrtriangl                         \\lrtriangl                  "            : (Incomplete sequence)
\\lrtriangle                        <char-0x025FF>               " ◿          : LOWER RIGHT TRIANGLE
\\lrtriangle<Tab>                   <char-0x025FF>               " ◿          : LOWER RIGHT TRIANGLE
\\lrtrianglee                       \\lrtrianglee                "            : (Incomplete sequence)
\\lrtriangleeq                      <char-0x029E1>               " ⧡          : INCREASES AS
\\ls                                \\ls                         "            : (Incomplete sequence)
\\lsi                               \\lsi                        "            : (Incomplete sequence)
\\lsim                              \\lsim                       "            : (Incomplete sequence)
\\lsime                             <char-0x02A8D>               " ⪍          : LESS-THAN ABOVE SIMILAR OR EQUAL
\\lsimg                             <char-0x02A8F>               " ⪏          : LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
\\lsq                               \\lsq                        "            : (Incomplete sequence)
\\lsqh                              \\lsqh                       "            : (Incomplete sequence)
\\lsqho                             \\lsqho                      "            : (Incomplete sequence)
\\lsqhoo                            \\lsqhoo                     "            : (Incomplete sequence)
\\lsqhook                           <char-0x02ACD>               " ⫍          : SQUARE LEFT OPEN BOX OPERATOR
\\lt                                \\lt                         "            : (Incomplete sequence)
\\ltc                               \\ltc                        "            : (Incomplete sequence)
\\ltcc                              <char-0x02AA6>               " ⪦          : LESS-THAN CLOSED BY CURVE
\\ltci                              \\ltci                       "            : (Incomplete sequence)
\\ltcir                             <char-0x02A79>               " ⩹          : LESS-THAN WITH CIRCLE INSIDE
\\lti                               \\lti                        "            : (Incomplete sequence)
\\ltim                              \\ltim                       "            : (Incomplete sequence)
\\ltime                             \\ltime                      "            : (Incomplete sequence)
\\ltimes                            <char-0x022C9>               " ⋉          : LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
\\ltl                               \\ltl                        "            : (Incomplete sequence)
\\ltlm                              \\ltlm                       "            : (Incomplete sequence)
\\ltlmr                             <char-0x00271>               " ɱ          : LATIN SMALL LETTER M WITH HOOK / LATIN SMALL LETTER M HOOK
\\ltln                              <char-0x00272>               " ɲ          : LATIN SMALL LETTER N WITH LEFT HOOK / LATIN SMALL LETTER N HOOK
\\ltp                               \\ltp                        "            : (Incomplete sequence)
\\ltph                              \\ltph                       "            : (Incomplete sequence)
\\ltphi                             <char-0x00278>               " ɸ          : LATIN SMALL LETTER PHI
\\ltq                               \\ltq                        "            : (Incomplete sequence)
\\ltqu                              \\ltqu                       "            : (Incomplete sequence)
\\ltque                             \\ltque                      "            : (Incomplete sequence)
\\ltques                            \\ltques                     "            : (Incomplete sequence)
\\ltquest                           <char-0x02A7B>               " ⩻          : LESS-THAN WITH QUESTION MARK ABOVE
\\lv                                \\lv                         "            : (Incomplete sequence)
\\lvb                               \\lvb                        "            : (Incomplete sequence)
\\lvbo                              \\lvbo                       "            : (Incomplete sequence)
\\lvbox                             \\lvbox                      "            : (Incomplete sequence)
\\lvboxl                            \\lvboxl                     "            : (Incomplete sequence)
\\lvboxli                           \\lvboxli                    "            : (Incomplete sequence)
\\lvboxlin                          \\lvboxlin                   "            : (Incomplete sequence)
\\lvboxline                         <char-0x023B8>               " ⎸          : LEFT VERTICAL BOX LINE
\\lve                               \\lve                        "            : (Incomplete sequence)
\\lver                              \\lver                       "            : (Incomplete sequence)
\\lvert                             \\lvert                      "            : (Incomplete sequence)
\\lvertn                            \\lvertn                     "            : (Incomplete sequence)
\\lvertne                           \\lvertne                    "            : (Incomplete sequence)
\\lvertneq                          \\lvertneq                   "            : (Incomplete sequence)
\\lvertneqq                         <char-0x02268><char-0x0FE00> " ≨︀         : LESS-THAN BUT NOT EQUAL TO / LESS THAN BUT NOT EQUAL TO + VARIATION SELECTOR-1
\\male                              <char-0x02642>               " ♂          : MALE SIGN
\\maltese                           <char-0x02720>               " ✠          : MALTESE CROSS
\\mapsdown                          <char-0x021A7>               " ↧          : DOWNWARDS ARROW FROM BAR / DOWN ARROW FROM BAR
\\mapsfrom                          <char-0x021A4>               " ↤          : LEFTWARDS ARROW FROM BAR / LEFT ARROW FROM BAR
\\mapsto                            <char-0x021A6>               " ↦          : RIGHTWARDS ARROW FROM BAR / RIGHT ARROW FROM BAR
\\mapsup                            <char-0x021A5>               " ↥          : UPWARDS ARROW FROM BAR / UP ARROW FROM BAR
\\mars                              <char-0x02642>               " ♂          : MALE SIGN
\\mdblkcircle                       <char-0x026AB>               " ⚫          : MEDIUM BLACK CIRCLE
\\mdblkdiamond                      <char-0x02B25>               " ⬥          : BLACK MEDIUM DIAMOND
\\mdblklozenge                      <char-0x02B27>               " ⬧          : BLACK MEDIUM LOZENGE
\\mdblksquare                       <char-0x025FC>               " ◼          : BLACK MEDIUM SQUARE
\\mdlgblkcircle                     <char-0x025CF>               " ●          : BLACK CIRCLE
\\mdlgblkdiamond                    <char-0x025C6>               " ◆          : BLACK DIAMOND
\\mdlgwhtdiamond                    <char-0x025C7>               " ◇          : WHITE DIAMOND
\\mdsmblksquare                     <char-0x025FE>               " ◾          : BLACK MEDIUM SMALL SQUARE
\\mdsmwhtcircle                     <char-0x026AC>               " ⚬          : MEDIUM SMALL WHITE CIRCLE
\\mdsmwhtsquare                     <char-0x025FD>               " ◽          : WHITE MEDIUM SMALL SQUARE
\\mdwhtcircle                       <char-0x026AA>               " ⚪          : MEDIUM WHITE CIRCLE
\\mdwhtdiamond                      <char-0x02B26>               " ⬦          : WHITE MEDIUM DIAMOND
\\mdwhtlozenge                      <char-0x02B28>               " ⬨          : WHITE MEDIUM LOZENGE
\\mdwhtsquare                       <char-0x025FB>               " ◻          : WHITE MEDIUM SQUARE
\\measangledltosw                   <char-0x029AF>               " ⦯          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
\\measangledrtose                   <char-0x029AE>               " ⦮          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
\\measangleldtosw                   <char-0x029AB>               " ⦫          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
\\measanglelutonw                   <char-0x029A9>               " ⦩          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
\\measanglerdtose                   <char-0x029AA>               " ⦪          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
\\measanglerutone                   <char-0x029A8>               " ⦨          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
\\measangleultonw                   <char-0x029AD>               " ⦭          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
\\measangleurtone                   <char-0x029AC>               " ⦬          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
\\measeq                            <char-0x0225E>               " ≞          : MEASURED BY
\\measuredangle                     <char-0x02221>               " ∡          : MEASURED ANGLE
\\measuredangle<Tab>                <char-0x02221>               " ∡          : MEASURED ANGLE
\\measuredanglel                    \\measuredanglel             "            : (Incomplete sequence)
\\measuredanglele                   \\measuredanglele            "            : (Incomplete sequence)
\\measuredanglelef                  \\measuredanglelef           "            : (Incomplete sequence)
\\measuredangleleft                 <char-0x0299B>               " ⦛          : MEASURED ANGLE OPENING LEFT
\\medblackstar                      <char-0x02B51>               " ⭑          : BLACK SMALL STAR
\\medwhitestar                      <char-0x02B50>               " ⭐          : WHITE MEDIUM STAR
\\mercury                           <char-0x0263F>               " ☿          : MERCURY
\\mho                               <char-0x02127>               " ℧          : INVERTED OHM SIGN / MHO
\\mid                               <char-0x02223>               " ∣          : DIVIDES
\\mid<Tab>                          <char-0x02223>               " ∣          : DIVIDES
\\midb                              \\midb                       "            : (Incomplete sequence)
\\midba                             \\midba                      "            : (Incomplete sequence)
\\midbar                            \\midbar                     "            : (Incomplete sequence)
\\midbarv                           \\midbarv                    "            : (Incomplete sequence)
\\midbarve                          \\midbarve                   "            : (Incomplete sequence)
\\midbarvee                         <char-0x02A5D>               " ⩝          : LOGICAL OR WITH HORIZONTAL DASH
\\midbarw                           \\midbarw                    "            : (Incomplete sequence)
\\midbarwe                          \\midbarwe                   "            : (Incomplete sequence)
\\midbarwed                         \\midbarwed                  "            : (Incomplete sequence)
\\midbarwedg                        \\midbarwedg                 "            : (Incomplete sequence)
\\midbarwedge                       <char-0x02A5C>               " ⩜          : LOGICAL AND WITH HORIZONTAL DASH
\\minhat                            <char-0x02A5F>               " ⩟          : LOGICAL AND WITH UNDERBAR
\\minus                             <char-0x02212>               " −          : MINUS SIGN
\\minus<Tab>                        <char-0x02212>               " −          : MINUS SIGN
\\minusd                            \\minusd                     "            : (Incomplete sequence)
\\minusdo                           \\minusdo                    "            : (Incomplete sequence)
\\minusdot                          <char-0x02A2A>               " ⨪          : MINUS SIGN WITH DOT BELOW
\\minusf                            \\minusf                     "            : (Incomplete sequence)
\\minusfd                           \\minusfd                    "            : (Incomplete sequence)
\\minusfdo                          \\minusfdo                   "            : (Incomplete sequence)
\\minusfdot                         \\minusfdot                  "            : (Incomplete sequence)
\\minusfdots                        <char-0x02A2B>               " ⨫          : MINUS SIGN WITH FALLING DOTS
\\minusr                            \\minusr                     "            : (Incomplete sequence)
\\minusrd                           \\minusrd                    "            : (Incomplete sequence)
\\minusrdo                          \\minusrdo                   "            : (Incomplete sequence)
\\minusrdot                         \\minusrdot                  "            : (Incomplete sequence)
\\minusrdots                        <char-0x02A2C>               " ⨬          : MINUS SIGN WITH RISING DOTS
\\mlcp                              <char-0x02ADB>               " ⫛          : TRANSVERSAL INTERSECTION
\\models                            <char-0x022A7>               " ⊧          : MODELS
\\modtwosum                         <char-0x02A0A>               " ⨊          : MODULO TWO SUM
\\mp                                <char-0x02213>               " ∓          : MINUS-OR-PLUS SIGN
\\mu                                <char-0x003BC>               " μ          : GREEK SMALL LETTER MU
\\mu<Tab>                           <char-0x003BC>               " μ          : GREEK SMALL LETTER MU
\\mul                               \\mul                        "            : (Incomplete sequence)
\\mult                              \\mult                       "            : (Incomplete sequence)
\\multi                             \\multi                      "            : (Incomplete sequence)
\\multim                            \\multim                     "            : (Incomplete sequence)
\\multima                           \\multima                    "            : (Incomplete sequence)
\\multimap                          <char-0x022B8>               " ⊸          : MULTIMAP
\\nBumpeq                           <char-0x0224E><char-0x00338> " ≎̸         : GEOMETRICALLY EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nHdownarrow                       <char-0x021DF>               " ⇟          : DOWNWARDS ARROW WITH DOUBLE STROKE / DOWN ARROW WITH DOUBLE STROKE
\\nHuparrow                         <char-0x021DE>               " ⇞          : UPWARDS ARROW WITH DOUBLE STROKE / UP ARROW WITH DOUBLE STROKE
\\nLeftarrow                        <char-0x021CD>               " ⇍          : LEFTWARDS DOUBLE ARROW WITH STROKE / LEFT DOUBLE ARROW WITH STROKE
\\nLeftrightarrow                   <char-0x021CE>               " ⇎          : LEFT RIGHT DOUBLE ARROW WITH STROKE
\\nRightarrow                       <char-0x021CF>               " ⇏          : RIGHTWARDS DOUBLE ARROW WITH STROKE / RIGHT DOUBLE ARROW WITH STROKE
\\nVDash                            <char-0x022AF>               " ⊯          : NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
\\nVdash                            <char-0x022AE>               " ⊮          : DOES NOT FORCE
\\nVleftarrow                       <char-0x021FA>               " ⇺          : LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVleftarrow<Tab>                  <char-0x021FA>               " ⇺          : LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVleftarrowt                      \\nVleftarrowt               "            : (Incomplete sequence)
\\nVleftarrowta                     \\nVleftarrowta              "            : (Incomplete sequence)
\\nVleftarrowtai                    \\nVleftarrowtai             "            : (Incomplete sequence)
\\nVleftarrowtail                   <char-0x02B3A>               " ⬺          : LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVleftrightarrow                  <char-0x021FC>               " ⇼          : LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrow                      <char-0x021FB>               " ⇻          : RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrow<Tab>                 <char-0x021FB>               " ⇻          : RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrowt                     \\nVrightarrowt              "            : (Incomplete sequence)
\\nVrightarrowta                    \\nVrightarrowta             "            : (Incomplete sequence)
\\nVrightarrowtai                   \\nVrightarrowtai            "            : (Incomplete sequence)
\\nVrightarrowtail                  <char-0x02915>               " ⤕          : RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrow                <char-0x02B35>               " ⬵          : LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrow<Tab>           <char-0x02B35>               " ⬵          : LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrowt               \\nVtwoheadleftarrowt        "            : (Incomplete sequence)
\\nVtwoheadleftarrowta              \\nVtwoheadleftarrowta       "            : (Incomplete sequence)
\\nVtwoheadleftarrowtai             \\nVtwoheadleftarrowtai      "            : (Incomplete sequence)
\\nVtwoheadleftarrowtail            <char-0x02B3D>               " ⬽          : LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrow               <char-0x02901>               " ⤁          : RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrow<Tab>          <char-0x02901>               " ⤁          : RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrowt              \\nVtwoheadrightarrowt       "            : (Incomplete sequence)
\\nVtwoheadrightarrowta             \\nVtwoheadrightarrowta      "            : (Incomplete sequence)
\\nVtwoheadrightarrowtai            \\nVtwoheadrightarrowtai     "            : (Incomplete sequence)
\\nVtwoheadrightarrowtail           <char-0x02918>               " ⤘          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nabla                             <char-0x02207>               " ∇          : NABLA
\\napprox                           <char-0x02249>               " ≉          : NOT ALMOST EQUAL TO
\\nasymp                            <char-0x0226D>               " ≭          : NOT EQUIVALENT TO
\\natural                           <char-0x0266E>               " ♮          : MUSIC NATURAL SIGN / NATURAL
\\nbumpeq                           <char-0x0224F><char-0x00338> " ≏̸         : DIFFERENCE BETWEEN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ncong                             <char-0x02247>               " ≇          : NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
\\ne                                <char-0x02260>               " ≠          : NOT EQUAL TO
\\ne<Tab>                           <char-0x02260>               " ≠          : NOT EQUAL TO
\\nea                               \\nea                        "            : (Incomplete sequence)
\\near                              \\near                       "            : (Incomplete sequence)
\\nearr                             \\nearr                      "            : (Incomplete sequence)
\\nearro                            \\nearro                     "            : (Incomplete sequence)
\\nearrow                           <char-0x02197>               " ↗          : NORTH EAST ARROW / UPPER RIGHT ARROW
\\neg                               <char-0x000AC>               " ¬          : NOT SIGN
\\neo                               \\neo                        "            : (Incomplete sequence)
\\neov                              \\neov                       "            : (Incomplete sequence)
\\neovn                             \\neovn                      "            : (Incomplete sequence)
\\neovnw                            \\neovnw                     "            : (Incomplete sequence)
\\neovnwa                           \\neovnwa                    "            : (Incomplete sequence)
\\neovnwar                          \\neovnwar                   "            : (Incomplete sequence)
\\neovnwarr                         \\neovnwarr                  "            : (Incomplete sequence)
\\neovnwarro                        \\neovnwarro                 "            : (Incomplete sequence)
\\neovnwarrow                       <char-0x02931>               " ⤱          : NORTH EAST ARROW CROSSING NORTH WEST ARROW
\\neovs                             \\neovs                      "            : (Incomplete sequence)
\\neovse                            \\neovse                     "            : (Incomplete sequence)
\\neovsea                           \\neovsea                    "            : (Incomplete sequence)
\\neovsear                          \\neovsear                   "            : (Incomplete sequence)
\\neovsearr                         \\neovsearr                  "            : (Incomplete sequence)
\\neovsearro                        \\neovsearro                 "            : (Incomplete sequence)
\\neovsearrow                       <char-0x0292E>               " ⤮          : NORTH EAST ARROW CROSSING SOUTH EAST ARROW
\\nep                               \\nep                        "            : (Incomplete sequence)
\\nept                              \\nept                       "            : (Incomplete sequence)
\\neptu                             \\neptu                      "            : (Incomplete sequence)
\\neptun                            \\neptun                     "            : (Incomplete sequence)
\\neptune                           <char-0x02646>               " ♆          : NEPTUNE
\\neq                               \\neq                        "            : (Incomplete sequence)
\\neqs                              \\neqs                       "            : (Incomplete sequence)
\\neqsi                             \\neqsi                      "            : (Incomplete sequence)
\\neqsim                            <char-0x02242><char-0x00338> " ≂̸         : MINUS TILDE + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nequ                              \\nequ                       "            : (Incomplete sequence)
\\nequi                             \\nequi                      "            : (Incomplete sequence)
\\nequiv                            <char-0x02262>               " ≢          : NOT IDENTICAL TO
\\neu                               \\neu                        "            : (Incomplete sequence)
\\neut                              \\neut                       "            : (Incomplete sequence)
\\neute                             \\neute                      "            : (Incomplete sequence)
\\neuter                            <char-0x026B2>               " ⚲          : NEUTER
\\nex                               \\nex                        "            : (Incomplete sequence)
\\nexi                              \\nexi                       "            : (Incomplete sequence)
\\nexis                             \\nexis                      "            : (Incomplete sequence)
\\nexist                            \\nexist                     "            : (Incomplete sequence)
\\nexists                           <char-0x02204>               " ∄          : THERE DOES NOT EXIST
\\ng                                <char-0x0014B>               " ŋ          : LATIN SMALL LETTER ENG
\\ng<Tab>                           <char-0x0014B>               " ŋ          : LATIN SMALL LETTER ENG
\\nge                               \\nge                        "            : (Incomplete sequence)
\\ngeq                              <char-0x02271>               " ≱          : NEITHER GREATER-THAN NOR EQUAL TO / NEITHER GREATER THAN NOR EQUAL TO
\\ngeq<Tab>                         <char-0x02271>               " ≱          : NEITHER GREATER-THAN NOR EQUAL TO / NEITHER GREATER THAN NOR EQUAL TO
\\ngeqs                             \\ngeqs                      "            : (Incomplete sequence)
\\ngeqsl                            \\ngeqsl                     "            : (Incomplete sequence)
\\ngeqsla                           \\ngeqsla                    "            : (Incomplete sequence)
\\ngeqslan                          \\ngeqslan                   "            : (Incomplete sequence)
\\ngeqslant                         <char-0x02A7E><char-0x00338> " ⩾̸         : GREATER-THAN OR SLANTED EQUAL TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ngt                               \\ngt                        "            : (Incomplete sequence)
\\ngtr                              <char-0x0226F>               " ≯          : NOT GREATER-THAN / NOT GREATER THAN
\\ngtr<Tab>                         <char-0x0226F>               " ≯          : NOT GREATER-THAN / NOT GREATER THAN
\\ngtrs                             \\ngtrs                      "            : (Incomplete sequence)
\\ngtrsi                            \\ngtrsi                     "            : (Incomplete sequence)
\\ngtrsim                           <char-0x02275>               " ≵          : NEITHER GREATER-THAN NOR EQUIVALENT TO / NEITHER GREATER THAN NOR EQUIVALENT TO
\\ni                                <char-0x0220B>               " ∋          : CONTAINS AS MEMBER
\\ni<Tab>                           <char-0x0220B>               " ∋          : CONTAINS AS MEMBER
\\nio                               \\nio                        "            : (Incomplete sequence)
\\niob                              \\niob                       "            : (Incomplete sequence)
\\nioba                             \\nioba                      "            : (Incomplete sequence)
\\niobar                            <char-0x022FE>               " ⋾          : SMALL CONTAINS WITH OVERBAR
\\nis                               <char-0x022FC>               " ⋼          : SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\nis<Tab>                          <char-0x022FC>               " ⋼          : SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\nisd                              <char-0x022FA>               " ⋺          : CONTAINS WITH LONG HORIZONTAL STROKE
\\nleftarrow                        <char-0x0219A>               " ↚          : LEFTWARDS ARROW WITH STROKE / LEFT ARROW WITH STROKE
\\nleftrightarrow                   <char-0x021AE>               " ↮          : LEFT RIGHT ARROW WITH STROKE
\\nleq                              <char-0x02270>               " ≰          : NEITHER LESS-THAN NOR EQUAL TO / NEITHER LESS THAN NOR EQUAL TO
\\nleq<Tab>                         <char-0x02270>               " ≰          : NEITHER LESS-THAN NOR EQUAL TO / NEITHER LESS THAN NOR EQUAL TO
\\nleqs                             \\nleqs                      "            : (Incomplete sequence)
\\nleqsl                            \\nleqsl                     "            : (Incomplete sequence)
\\nleqsla                           \\nleqsla                    "            : (Incomplete sequence)
\\nleqslan                          \\nleqslan                   "            : (Incomplete sequence)
\\nleqslant                         <char-0x02A7D><char-0x00338> " ⩽̸         : LESS-THAN OR SLANTED EQUAL TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nless                             <char-0x0226E>               " ≮          : NOT LESS-THAN / NOT LESS THAN
\\nless<Tab>                        <char-0x0226E>               " ≮          : NOT LESS-THAN / NOT LESS THAN
\\nlesss                            \\nlesss                     "            : (Incomplete sequence)
\\nlesssi                           \\nlesssi                    "            : (Incomplete sequence)
\\nlesssim                          <char-0x02274>               " ≴          : NEITHER LESS-THAN NOR EQUIVALENT TO / NEITHER LESS THAN NOR EQUIVALENT TO
\\nmid                              <char-0x02224>               " ∤          : DOES NOT DIVIDE
\\nni                               <char-0x0220C>               " ∌          : DOES NOT CONTAIN AS MEMBER
\\nolinebreak                       <char-0x02060>               " ⁠          : WORD JOINER
\\not                               <char-0x00338>               " ◌̸         : COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\not<Tab>                          <char-0x00338>               " ◌̸         : COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\notb                              \\notb                       "            : (Incomplete sequence)
\\notba                             \\notba                      "            : (Incomplete sequence)
\\notbac                            \\notbac                     "            : (Incomplete sequence)
\\notback                           \\notback                    "            : (Incomplete sequence)
\\notbacks                          \\notbacks                   "            : (Incomplete sequence)
\\notbacksl                         \\notbacksl                  "            : (Incomplete sequence)
\\notbacksla                        \\notbacksla                 "            : (Incomplete sequence)
\\notbackslas                       \\notbackslas                "            : (Incomplete sequence)
\\notbackslash                      <char-0x02340>               " ⍀          : APL FUNCTIONAL SYMBOL BACKSLASH BAR
\\notg                              \\notg                       "            : (Incomplete sequence)
\\notgr                             \\notgr                      "            : (Incomplete sequence)
\\notgre                            \\notgre                     "            : (Incomplete sequence)
\\notgrea                           \\notgrea                    "            : (Incomplete sequence)
\\notgreat                          \\notgreat                   "            : (Incomplete sequence)
\\notgreate                         \\notgreate                  "            : (Incomplete sequence)
\\notgreater                        \\notgreater                 "            : (Incomplete sequence)
\\notgreaterl                       \\notgreaterl                "            : (Incomplete sequence)
\\notgreaterle                      \\notgreaterle               "            : (Incomplete sequence)
\\notgreaterles                     \\notgreaterles              "            : (Incomplete sequence)
\\notgreaterless                    <char-0x02279>               " ≹          : NEITHER GREATER-THAN NOR LESS-THAN / NEITHER GREATER THAN NOR LESS THAN
\\noti                              \\noti                       "            : (Incomplete sequence)
\\notin                             <char-0x02209>               " ∉          : NOT AN ELEMENT OF
\\notl                              \\notl                       "            : (Incomplete sequence)
\\notle                             \\notle                      "            : (Incomplete sequence)
\\notles                            \\notles                     "            : (Incomplete sequence)
\\notless                           \\notless                    "            : (Incomplete sequence)
\\notlessg                          \\notlessg                   "            : (Incomplete sequence)
\\notlessgr                         \\notlessgr                  "            : (Incomplete sequence)
\\notlessgre                        \\notlessgre                 "            : (Incomplete sequence)
\\notlessgrea                       \\notlessgrea                "            : (Incomplete sequence)
\\notlessgreat                      \\notlessgreat               "            : (Incomplete sequence)
\\notlessgreate                     \\notlessgreate              "            : (Incomplete sequence)
\\notlessgreater                    <char-0x02278>               " ≸          : NEITHER LESS-THAN NOR GREATER-THAN / NEITHER LESS THAN NOR GREATER THAN
\\nots                              \\nots                       "            : (Incomplete sequence)
\\notsl                             \\notsl                      "            : (Incomplete sequence)
\\notsla                            \\notsla                     "            : (Incomplete sequence)
\\notslas                           \\notslas                    "            : (Incomplete sequence)
\\notslash                          <char-0x0233F>               " ⌿          : APL FUNCTIONAL SYMBOL SLASH BAR
\\nparallel                         <char-0x02226>               " ∦          : NOT PARALLEL TO
\\npolint                           <char-0x02A14>               " ⨔          : LINE INTEGRATION NOT INCLUDING THE POLE
\\nprec                             <char-0x02280>               " ⊀          : DOES NOT PRECEDE
\\nprec<Tab>                        <char-0x02280>               " ⊀          : DOES NOT PRECEDE
\\nprecc                            \\nprecc                     "            : (Incomplete sequence)
\\npreccu                           \\npreccu                    "            : (Incomplete sequence)
\\npreccur                          \\npreccur                   "            : (Incomplete sequence)
\\npreccurl                         \\npreccurl                  "            : (Incomplete sequence)
\\npreccurly                        \\npreccurly                 "            : (Incomplete sequence)
\\npreccurlye                       \\npreccurlye                "            : (Incomplete sequence)
\\npreccurlyeq                      <char-0x022E0>               " ⋠          : DOES NOT PRECEDE OR EQUAL
\\nprece                            \\nprece                     "            : (Incomplete sequence)
\\npreceq                           <char-0x02AAF><char-0x00338> " ⪯̸         : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nprecs                            \\nprecs                     "            : (Incomplete sequence)
\\nprecsi                           \\nprecsi                    "            : (Incomplete sequence)
\\nprecsim                          <char-0x0227E><char-0x00338> " ≾̸         : PRECEDES OR EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nrightarrow                       <char-0x0219B>               " ↛          : RIGHTWARDS ARROW WITH STROKE / RIGHT ARROW WITH STROKE
\\nrleg                             <char-0x0019E>               " ƞ          : LATIN SMALL LETTER N WITH LONG RIGHT LEG
\\nsim                              <char-0x02241>               " ≁          : NOT TILDE
\\nsim<Tab>                         <char-0x02241>               " ≁          : NOT TILDE
\\nsime                             <char-0x02244>               " ≄          : NOT ASYMPTOTICALLY EQUAL TO
\\nsqsubseteq                       <char-0x022E2>               " ⋢          : NOT SQUARE IMAGE OF OR EQUAL TO
\\nsqsupseteq                       <char-0x022E3>               " ⋣          : NOT SQUARE ORIGINAL OF OR EQUAL TO
\\nsubset                           <char-0x02284>               " ⊄          : NOT A SUBSET OF
\\nsubset<Tab>                      <char-0x02284>               " ⊄          : NOT A SUBSET OF
\\nsubsete                          \\nsubsete                   "            : (Incomplete sequence)
\\nsubseteq                         <char-0x02288>               " ⊈          : NEITHER A SUBSET OF NOR EQUAL TO
\\nsubseteq<Tab>                    <char-0x02288>               " ⊈          : NEITHER A SUBSET OF NOR EQUAL TO
\\nsubseteqq                        <char-0x02AC5><char-0x00338> " ⫅̸         : SUBSET OF ABOVE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsucc                             <char-0x02281>               " ⊁          : DOES NOT SUCCEED
\\nsucc<Tab>                        <char-0x02281>               " ⊁          : DOES NOT SUCCEED
\\nsuccc                            \\nsuccc                     "            : (Incomplete sequence)
\\nsucccu                           \\nsucccu                    "            : (Incomplete sequence)
\\nsucccur                          \\nsucccur                   "            : (Incomplete sequence)
\\nsucccurl                         \\nsucccurl                  "            : (Incomplete sequence)
\\nsucccurly                        \\nsucccurly                 "            : (Incomplete sequence)
\\nsucccurlye                       \\nsucccurlye                "            : (Incomplete sequence)
\\nsucccurlyeq                      <char-0x022E1>               " ⋡          : DOES NOT SUCCEED OR EQUAL
\\nsucce                            \\nsucce                     "            : (Incomplete sequence)
\\nsucceq                           <char-0x02AB0><char-0x00338> " ⪰̸         : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsuccs                            \\nsuccs                     "            : (Incomplete sequence)
\\nsuccsi                           \\nsuccsi                    "            : (Incomplete sequence)
\\nsuccsim                          <char-0x0227F><char-0x00338> " ≿̸         : SUCCEEDS OR EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsupset                           <char-0x02285>               " ⊅          : NOT A SUPERSET OF
\\nsupset<Tab>                      <char-0x02285>               " ⊅          : NOT A SUPERSET OF
\\nsupsete                          \\nsupsete                   "            : (Incomplete sequence)
\\nsupseteq                         <char-0x02289>               " ⊉          : NEITHER A SUPERSET OF NOR EQUAL TO
\\nsupseteq<Tab>                    <char-0x02289>               " ⊉          : NEITHER A SUPERSET OF NOR EQUAL TO
\\nsupseteqq                        <char-0x02AC6><char-0x00338> " ⫆̸         : SUPERSET OF ABOVE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ntriangleleft                     <char-0x022EA>               " ⋪          : NOT NORMAL SUBGROUP OF
\\ntriangleleft<Tab>                <char-0x022EA>               " ⋪          : NOT NORMAL SUBGROUP OF
\\ntrianglelefte                    \\ntrianglelefte             "            : (Incomplete sequence)
\\ntrianglelefteq                   <char-0x022EC>               " ⋬          : NOT NORMAL SUBGROUP OF OR EQUAL TO
\\ntriangleright                    <char-0x022EB>               " ⋫          : DOES NOT CONTAIN AS NORMAL SUBGROUP
\\ntriangleright<Tab>               <char-0x022EB>               " ⋫          : DOES NOT CONTAIN AS NORMAL SUBGROUP
\\ntrianglerighte                   \\ntrianglerighte            "            : (Incomplete sequence)
\\ntrianglerighteq                  <char-0x022ED>               " ⋭          : DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
\\nu                                <char-0x003BD>               " ν          : GREEK SMALL LETTER NU
\\nu<Tab>                           <char-0x003BD>               " ν          : GREEK SMALL LETTER NU
\\num                               \\num                        "            : (Incomplete sequence)
\\nume                              \\nume                       "            : (Incomplete sequence)
\\numer                             \\numer                      "            : (Incomplete sequence)
\\numero                            <char-0x02116>               " №          : NUMERO SIGN / NUMERO
\\nvDash                            <char-0x022AD>               " ⊭          : NOT TRUE
\\nvLeftarrow                       <char-0x02902>               " ⤂          : LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
\\nvLeftrightarrow                  <char-0x02904>               " ⤄          : LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
\\nvRightarrow                      <char-0x02903>               " ⤃          : RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
\\nvdash                            <char-0x022AC>               " ⊬          : DOES NOT PROVE
\\nvleftarrow                       <char-0x021F7>               " ⇷          : LEFTWARDS ARROW WITH VERTICAL STROKE
\\nvleftarrow<Tab>                  <char-0x021F7>               " ⇷          : LEFTWARDS ARROW WITH VERTICAL STROKE
\\nvleftarrowt                      \\nvleftarrowt               "            : (Incomplete sequence)
\\nvleftarrowta                     \\nvleftarrowta              "            : (Incomplete sequence)
\\nvleftarrowtai                    \\nvleftarrowtai             "            : (Incomplete sequence)
\\nvleftarrowtail                   <char-0x02B39>               " ⬹          : LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
\\nvleftrightarrow                  <char-0x021F9>               " ⇹          : LEFT RIGHT ARROW WITH VERTICAL STROKE
\\nvrightarrow                      <char-0x021F8>               " ⇸          : RIGHTWARDS ARROW WITH VERTICAL STROKE
\\nvrightarrow<Tab>                 <char-0x021F8>               " ⇸          : RIGHTWARDS ARROW WITH VERTICAL STROKE
\\nvrightarrowt                     \\nvrightarrowt              "            : (Incomplete sequence)
\\nvrightarrowta                    \\nvrightarrowta             "            : (Incomplete sequence)
\\nvrightarrowtai                   \\nvrightarrowtai            "            : (Incomplete sequence)
\\nvrightarrowtail                  <char-0x02914>               " ⤔          : RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
\\nvtwoheadleftarrow                <char-0x02B34>               " ⬴          : LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadleftarrow<Tab>           <char-0x02B34>               " ⬴          : LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadleftarrowt               \\nvtwoheadleftarrowt        "            : (Incomplete sequence)
\\nvtwoheadleftarrowta              \\nvtwoheadleftarrowta       "            : (Incomplete sequence)
\\nvtwoheadleftarrowtai             \\nvtwoheadleftarrowtai      "            : (Incomplete sequence)
\\nvtwoheadleftarrowtail            <char-0x02B3C>               " ⬼          : LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
\\nvtwoheadrightarrow               <char-0x02900>               " ⤀          : RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadrightarrow<Tab>          <char-0x02900>               " ⤀          : RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadrightarrowt              \\nvtwoheadrightarrowt       "            : (Incomplete sequence)
\\nvtwoheadrightarrowta             \\nvtwoheadrightarrowta      "            : (Incomplete sequence)
\\nvtwoheadrightarrowtai            \\nvtwoheadrightarrowtai     "            : (Incomplete sequence)
\\nvtwoheadrightarrowtail           <char-0x02917>               " ⤗          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
\\nwarrow                           <char-0x02196>               " ↖          : NORTH WEST ARROW / UPPER LEFT ARROW
\\nwovnearrow                       <char-0x02932>               " ⤲          : NORTH WEST ARROW CROSSING NORTH EAST ARROW
\\o                                 <char-0x000F8>               " ø          : LATIN SMALL LETTER O WITH STROKE / LATIN SMALL LETTER O SLASH
\\o<Tab>                            <char-0x000F8>               " ø          : LATIN SMALL LETTER O WITH STROKE / LATIN SMALL LETTER O SLASH
\\ob                                \\ob                         "            : (Incomplete sequence)
\\oba                               \\oba                        "            : (Incomplete sequence)
\\obar                              <char-0x0233D>               " ⌽          : APL FUNCTIONAL SYMBOL CIRCLE STILE
\\obs                               \\obs                        "            : (Incomplete sequence)
\\obsl                              \\obsl                       "            : (Incomplete sequence)
\\obsla                             \\obsla                      "            : (Incomplete sequence)
\\obslas                            \\obslas                     "            : (Incomplete sequence)
\\obslash                           <char-0x029B8>               " ⦸          : CIRCLED REVERSE SOLIDUS
\\oc                                \\oc                         "            : (Incomplete sequence)
\\oci                               \\oci                        "            : (Incomplete sequence)
\\ocir                              \\ocir                       "            : (Incomplete sequence)
\\ocirc                             <char-0x0030A>               " ◌̊         : COMBINING RING ABOVE / NON-SPACING RING ABOVE
\\oco                               \\oco                        "            : (Incomplete sequence)
\\ocom                              \\ocom                       "            : (Incomplete sequence)
\\ocomm                             \\ocomm                      "            : (Incomplete sequence)
\\ocomma                            \\ocomma                     "            : (Incomplete sequence)
\\ocommat                           \\ocommat                    "            : (Incomplete sequence)
\\ocommato                          \\ocommato                   "            : (Incomplete sequence)
\\ocommatop                         \\ocommatop                  "            : (Incomplete sequence)
\\ocommatopr                        \\ocommatopr                 "            : (Incomplete sequence)
\\ocommatopri                       \\ocommatopri                "            : (Incomplete sequence)
\\ocommatoprig                      \\ocommatoprig               "            : (Incomplete sequence)
\\ocommatoprigh                     \\ocommatoprigh              "            : (Incomplete sequence)
\\ocommatopright                    <char-0x00315>               " ◌̕         : COMBINING COMMA ABOVE RIGHT / NON-SPACING COMMA ABOVE RIGHT
\\od                                \\od                         "            : (Incomplete sequence)
\\odi                               \\odi                        "            : (Incomplete sequence)
\\odiv                              <char-0x02A38>               " ⨸          : CIRCLED DIVISION SIGN
\\odo                               \\odo                        "            : (Incomplete sequence)
\\odot                              <char-0x02299>               " ⊙          : CIRCLED DOT OPERATOR
\\odot<Tab>                         <char-0x02299>               " ⊙          : CIRCLED DOT OPERATOR
\\odots                             \\odots                      "            : (Incomplete sequence)
\\odotsl                            \\odotsl                     "            : (Incomplete sequence)
\\odotsla                           \\odotsla                    "            : (Incomplete sequence)
\\odotslas                          \\odotslas                   "            : (Incomplete sequence)
\\odotslash                         \\odotslash                  "            : (Incomplete sequence)
\\odotslashd                        \\odotslashd                 "            : (Incomplete sequence)
\\odotslashdo                       \\odotslashdo                "            : (Incomplete sequence)
\\odotslashdot                      <char-0x029BC>               " ⦼          : CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
\\oe                                <char-0x00153>               " œ          : LATIN SMALL LIGATURE OE / LATIN SMALL LETTER O E
\\og                                \\og                         "            : (Incomplete sequence)
\\ogr                               \\ogr                        "            : (Incomplete sequence)
\\ogre                              \\ogre                       "            : (Incomplete sequence)
\\ogrea                             \\ogrea                      "            : (Incomplete sequence)
\\ogreat                            \\ogreat                     "            : (Incomplete sequence)
\\ogreate                           \\ogreate                    "            : (Incomplete sequence)
\\ogreater                          \\ogreater                   "            : (Incomplete sequence)
\\ogreatert                         \\ogreatert                  "            : (Incomplete sequence)
\\ogreaterth                        \\ogreaterth                 "            : (Incomplete sequence)
\\ogreatertha                       \\ogreatertha                "            : (Incomplete sequence)
\\ogreaterthan                      <char-0x029C1>               " ⧁          : CIRCLED GREATER-THAN
\\oi                                \\oi                         "            : (Incomplete sequence)
\\oii                               \\oii                        "            : (Incomplete sequence)
\\oiii                              \\oiii                       "            : (Incomplete sequence)
\\oiiin                             \\oiiin                      "            : (Incomplete sequence)
\\oiiint                            <char-0x02230>               " ∰          : VOLUME INTEGRAL
\\oiin                              \\oiin                       "            : (Incomplete sequence)
\\oiint                             <char-0x0222F>               " ∯          : SURFACE INTEGRAL
\\oin                               \\oin                        "            : (Incomplete sequence)
\\oint                              <char-0x0222E>               " ∮          : CONTOUR INTEGRAL
\\oint<Tab>                         <char-0x0222E>               " ∮          : CONTOUR INTEGRAL
\\ointc                             \\ointc                      "            : (Incomplete sequence)
\\ointct                            \\ointct                     "            : (Incomplete sequence)
\\ointctr                           \\ointctr                    "            : (Incomplete sequence)
\\ointctrc                          \\ointctrc                   "            : (Incomplete sequence)
\\ointctrcl                         \\ointctrcl                  "            : (Incomplete sequence)
\\ointctrclo                        \\ointctrclo                 "            : (Incomplete sequence)
\\ointctrcloc                       \\ointctrcloc                "            : (Incomplete sequence)
\\ointctrclock                      \\ointctrclock               "            : (Incomplete sequence)
\\ointctrclockw                     \\ointctrclockw              "            : (Incomplete sequence)
\\ointctrclockwi                    \\ointctrclockwi             "            : (Incomplete sequence)
\\ointctrclockwis                   \\ointctrclockwis            "            : (Incomplete sequence)
\\ointctrclockwise                  <char-0x02233>               " ∳          : ANTICLOCKWISE CONTOUR INTEGRAL
\\ol                                \\ol                         "            : (Incomplete sequence)
\\ole                               \\ole                        "            : (Incomplete sequence)
\\oles                              \\oles                       "            : (Incomplete sequence)
\\oless                             \\oless                      "            : (Incomplete sequence)
\\olesst                            \\olesst                     "            : (Incomplete sequence)
\\olessth                           \\olessth                    "            : (Incomplete sequence)
\\olesstha                          \\olesstha                   "            : (Incomplete sequence)
\\olessthan                         <char-0x029C0>               " ⧀          : CIRCLED LESS-THAN
\\om                                \\om                         "            : (Incomplete sequence)
\\ome                               \\ome                        "            : (Incomplete sequence)
\\omeg                              \\omeg                       "            : (Incomplete sequence)
\\omega                             <char-0x003C9>               " ω          : GREEK SMALL LETTER OMEGA
\\omi                               \\omi                        "            : (Incomplete sequence)
\\omin                              \\omin                       "            : (Incomplete sequence)
\\ominu                             \\ominu                      "            : (Incomplete sequence)
\\ominus                            <char-0x02296>               " ⊖          : CIRCLED MINUS
\\op                                \\op                         "            : (Incomplete sequence)
\\ope                               \\ope                        "            : (Incomplete sequence)
\\open                              \\open                       "            : (Incomplete sequence)
\\openb                             \\openb                      "            : (Incomplete sequence)
\\openbr                            \\openbr                     "            : (Incomplete sequence)
\\openbra                           \\openbra                    "            : (Incomplete sequence)
\\openbrac                          \\openbrac                   "            : (Incomplete sequence)
\\openbrack                         \\openbrack                  "            : (Incomplete sequence)
\\openbracke                        \\openbracke                 "            : (Incomplete sequence)
\\openbracket                       \\openbracket                "            : (Incomplete sequence)
\\openbracketl                      \\openbracketl               "            : (Incomplete sequence)
\\openbracketle                     \\openbracketle              "            : (Incomplete sequence)
\\openbracketlef                    \\openbracketlef             "            : (Incomplete sequence)
\\openbracketleft                   <char-0x027E6>               " ⟦          : MATHEMATICAL LEFT WHITE SQUARE BRACKET
\\openbracketr                      \\openbracketr               "            : (Incomplete sequence)
\\openbracketri                     \\openbracketri              "            : (Incomplete sequence)
\\openbracketrig                    \\openbracketrig             "            : (Incomplete sequence)
\\openbracketrigh                   \\openbracketrigh            "            : (Incomplete sequence)
\\openbracketright                  <char-0x027E7>               " ⟧          : MATHEMATICAL RIGHT WHITE SQUARE BRACKET
\\openo                             <char-0x00254>               " ɔ          : LATIN SMALL LETTER OPEN O
\\opl                               \\opl                        "            : (Incomplete sequence)
\\oplu                              \\oplu                       "            : (Incomplete sequence)
\\oplus                             <char-0x02295>               " ⊕          : CIRCLED PLUS
\\oplus<Tab>                        <char-0x02295>               " ⊕          : CIRCLED PLUS
\\oplusl                            \\oplusl                     "            : (Incomplete sequence)
\\opluslh                           \\opluslh                    "            : (Incomplete sequence)
\\opluslhr                          \\opluslhr                   "            : (Incomplete sequence)
\\opluslhri                         \\opluslhri                  "            : (Incomplete sequence)
\\opluslhrim                        <char-0x02A2D>               " ⨭          : PLUS SIGN IN LEFT HALF CIRCLE
\\oplusr                            \\oplusr                     "            : (Incomplete sequence)
\\oplusrh                           \\oplusrh                    "            : (Incomplete sequence)
\\oplusrhr                          \\oplusrhr                   "            : (Incomplete sequence)
\\oplusrhri                         \\oplusrhri                  "            : (Incomplete sequence)
\\oplusrhrim                        <char-0x02A2E>               " ⨮          : PLUS SIGN IN RIGHT HALF CIRCLE
\\or                                \\or                         "            : (Incomplete sequence)
\\ord                               \\ord                        "            : (Incomplete sequence)
\\ordf                              \\ordf                       "            : (Incomplete sequence)
\\ordfe                             \\ordfe                      "            : (Incomplete sequence)
\\ordfem                            \\ordfem                     "            : (Incomplete sequence)
\\ordfemi                           \\ordfemi                    "            : (Incomplete sequence)
\\ordfemin                          \\ordfemin                   "            : (Incomplete sequence)
\\ordfemini                         \\ordfemini                  "            : (Incomplete sequence)
\\ordfeminin                        \\ordfeminin                 "            : (Incomplete sequence)
\\ordfeminine                       <char-0x000AA>               " ª          : FEMININE ORDINAL INDICATOR
\\ordm                              \\ordm                       "            : (Incomplete sequence)
\\ordma                             \\ordma                      "            : (Incomplete sequence)
\\ordmas                            \\ordmas                     "            : (Incomplete sequence)
\\ordmasc                           \\ordmasc                    "            : (Incomplete sequence)
\\ordmascu                          \\ordmascu                   "            : (Incomplete sequence)
\\ordmascul                         \\ordmascul                  "            : (Incomplete sequence)
\\ordmasculi                        \\ordmasculi                 "            : (Incomplete sequence)
\\ordmasculin                       \\ordmasculin                "            : (Incomplete sequence)
\\ordmasculine                      <char-0x000BA>               " º          : MASCULINE ORDINAL INDICATOR
\\ori                               \\ori                        "            : (Incomplete sequence)
\\orig                              \\orig                       "            : (Incomplete sequence)
\\origi                             \\origi                      "            : (Incomplete sequence)
\\origin                            \\origin                     "            : (Incomplete sequence)
\\origina                           \\origina                    "            : (Incomplete sequence)
\\original                          <char-0x022B6>               " ⊶          : ORIGINAL OF
\\os                                \\os                         "            : (Incomplete sequence)
\\osl                               \\osl                        "            : (Incomplete sequence)
\\osla                              \\osla                       "            : (Incomplete sequence)
\\oslas                             \\oslas                      "            : (Incomplete sequence)
\\oslash                            <char-0x02298>               " ⊘          : CIRCLED DIVISION SLASH
\\ot                                \\ot                         "            : (Incomplete sequence)
\\oti                               \\oti                        "            : (Incomplete sequence)
\\otim                              \\otim                       "            : (Incomplete sequence)
\\otime                             \\otime                      "            : (Incomplete sequence)
\\otimes                            <char-0x02297>               " ⊗          : CIRCLED TIMES
\\otimes<Tab>                       <char-0x02297>               " ⊗          : CIRCLED TIMES
\\otimesh                           \\otimesh                    "            : (Incomplete sequence)
\\otimesha                          \\otimesha                   "            : (Incomplete sequence)
\\otimeshat                         <char-0x02A36>               " ⨶          : CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
\\otimesl                           \\otimesl                    "            : (Incomplete sequence)
\\otimeslh                          \\otimeslh                   "            : (Incomplete sequence)
\\otimeslhr                         \\otimeslhr                  "            : (Incomplete sequence)
\\otimeslhri                        \\otimeslhri                 "            : (Incomplete sequence)
\\otimeslhrim                       <char-0x02A34>               " ⨴          : MULTIPLICATION SIGN IN LEFT HALF CIRCLE
\\otimesr                           \\otimesr                    "            : (Incomplete sequence)
\\otimesrh                          \\otimesrh                   "            : (Incomplete sequence)
\\otimesrhr                         \\otimesrhr                  "            : (Incomplete sequence)
\\otimesrhri                        \\otimesrhri                 "            : (Incomplete sequence)
\\otimesrhrim                       <char-0x02A35>               " ⨵          : MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
\\otu                               \\otu                        "            : (Incomplete sequence)
\\otur                              \\otur                       "            : (Incomplete sequence)
\\oturn                             \\oturn                      "            : (Incomplete sequence)
\\oturne                            \\oturne                     "            : (Incomplete sequence)
\\oturned                           \\oturned                    "            : (Incomplete sequence)
\\oturnedc                          \\oturnedc                   "            : (Incomplete sequence)
\\oturnedco                         \\oturnedco                  "            : (Incomplete sequence)
\\oturnedcom                        \\oturnedcom                 "            : (Incomplete sequence)
\\oturnedcomm                       \\oturnedcomm                "            : (Incomplete sequence)
\\oturnedcomma                      <char-0x00312>               " ◌̒         : COMBINING TURNED COMMA ABOVE / NON-SPACING TURNED COMMA ABOVE
\\ov                                \\ov                         "            : (Incomplete sequence)
\\ove                               \\ove                        "            : (Incomplete sequence)
\\over                              \\over                       "            : (Incomplete sequence)
\\overb                             \\overb                      "            : (Incomplete sequence)
\\overba                            \\overba                     "            : (Incomplete sequence)
\\overbar                           <char-0x00305>               " ◌̅         : COMBINING OVERLINE / NON-SPACING OVERSCORE
\\overbr                            \\overbr                     "            : (Incomplete sequence)
\\overbra                           \\overbra                    "            : (Incomplete sequence)
\\overbrac                          \\overbrac                   "            : (Incomplete sequence)
\\overbrace                         <char-0x023DE>               " ⏞          : TOP CURLY BRACKET
\\overbrack                         \\overbrack                  "            : (Incomplete sequence)
\\overbracke                        \\overbracke                 "            : (Incomplete sequence)
\\overbracket                       <char-0x023B4>               " ⎴          : TOP SQUARE BRACKET
\\overl                             \\overl                      "            : (Incomplete sequence)
\\overle                            \\overle                     "            : (Incomplete sequence)
\\overlef                           \\overlef                    "            : (Incomplete sequence)
\\overleft                          \\overleft                   "            : (Incomplete sequence)
\\overlefta                         \\overlefta                  "            : (Incomplete sequence)
\\overleftar                        \\overleftar                 "            : (Incomplete sequence)
\\overleftarr                       \\overleftarr                "            : (Incomplete sequence)
\\overleftarro                      \\overleftarro               "            : (Incomplete sequence)
\\overleftarrow                     <char-0x020D6>               " ◌⃖         : COMBINING LEFT ARROW ABOVE / NON-SPACING LEFT ARROW ABOVE
\\overleftr                         \\overleftr                  "            : (Incomplete sequence)
\\overleftri                        \\overleftri                 "            : (Incomplete sequence)
\\overleftrig                       \\overleftrig                "            : (Incomplete sequence)
\\overleftrigh                      \\overleftrigh               "            : (Incomplete sequence)
\\overleftright                     \\overleftright              "            : (Incomplete sequence)
\\overleftrighta                    \\overleftrighta             "            : (Incomplete sequence)
\\overleftrightar                   \\overleftrightar            "            : (Incomplete sequence)
\\overleftrightarr                  \\overleftrightarr           "            : (Incomplete sequence)
\\overleftrightarro                 \\overleftrightarro          "            : (Incomplete sequence)
\\overleftrightarrow                <char-0x020E1>               " ◌⃡         : COMBINING LEFT RIGHT ARROW ABOVE / NON-SPACING LEFT RIGHT ARROW ABOVE
\\ovh                               \\ovh                        "            : (Incomplete sequence)
\\ovho                              \\ovho                       "            : (Incomplete sequence)
\\ovhoo                             \\ovhoo                      "            : (Incomplete sequence)
\\ovhook                            <char-0x00309>               " ◌̉         : COMBINING HOOK ABOVE / NON-SPACING HOOK ABOVE
\\palh                              <char-0x00321>               " ◌̡         : COMBINING PALATALIZED HOOK BELOW / NON-SPACING PALATALIZED HOOK BELOW
\\parallel                          <char-0x02225>               " ∥          : PARALLEL TO
\\parallel<Tab>                     <char-0x02225>               " ∥          : PARALLEL TO
\\parallelo                         \\parallelo                  "            : (Incomplete sequence)
\\parallelog                        \\parallelog                 "            : (Incomplete sequence)
\\parallelogr                       \\parallelogr                "            : (Incomplete sequence)
\\parallelogra                      \\parallelogra               "            : (Incomplete sequence)
\\parallelogram                     <char-0x025B1>               " ▱          : WHITE PARALLELOGRAM
\\parallelogram<Tab>                <char-0x025B1>               " ▱          : WHITE PARALLELOGRAM
\\parallelogramb                    \\parallelogramb             "            : (Incomplete sequence)
\\parallelogrambl                   \\parallelogrambl            "            : (Incomplete sequence)
\\parallelogrambla                  \\parallelogrambla           "            : (Incomplete sequence)
\\parallelogramblac                 \\parallelogramblac          "            : (Incomplete sequence)
\\parallelogramblack                <char-0x025B0>               " ▰          : BLACK PARALLELOGRAM
\\partial                           <char-0x02202>               " ∂          : PARTIAL DIFFERENTIAL
\\partial<Tab>                      <char-0x02202>               " ∂          : PARTIAL DIFFERENTIAL
\\partialm                          \\partialm                   "            : (Incomplete sequence)
\\partialme                         \\partialme                  "            : (Incomplete sequence)
\\partialmee                        \\partialmee                 "            : (Incomplete sequence)
\\partialmeet                       \\partialmeet                "            : (Incomplete sequence)
\\partialmeetc                      \\partialmeetc               "            : (Incomplete sequence)
\\partialmeetco                     \\partialmeetco              "            : (Incomplete sequence)
\\partialmeetcon                    \\partialmeetcon             "            : (Incomplete sequence)
\\partialmeetcont                   \\partialmeetcont            "            : (Incomplete sequence)
\\partialmeetcontr                  \\partialmeetcontr           "            : (Incomplete sequence)
\\partialmeetcontra                 \\partialmeetcontra          "            : (Incomplete sequence)
\\partialmeetcontrac                \\partialmeetcontrac         "            : (Incomplete sequence)
\\partialmeetcontract               \\partialmeetcontract        "            : (Incomplete sequence)
\\partialmeetcontracti              \\partialmeetcontracti       "            : (Incomplete sequence)
\\partialmeetcontractio             \\partialmeetcontractio      "            : (Incomplete sequence)
\\partialmeetcontraction            <char-0x02AA3>               " ⪣          : DOUBLE NESTED LESS-THAN WITH UNDERBAR
\\pbgam                             <char-0x00264>               " ɤ          : LATIN SMALL LETTER RAMS HORN / LATIN SMALL LETTER BABY GAMMA
\\pentagon                          <char-0x02B20>               " ⬠          : WHITE PENTAGON
\\pentagon<Tab>                     <char-0x02B20>               " ⬠          : WHITE PENTAGON
\\pentagonb                         \\pentagonb                  "            : (Incomplete sequence)
\\pentagonbl                        \\pentagonbl                 "            : (Incomplete sequence)
\\pentagonbla                       \\pentagonbla                "            : (Incomplete sequence)
\\pentagonblac                      \\pentagonblac               "            : (Incomplete sequence)
\\pentagonblack                     <char-0x02B1F>               " ⬟          : BLACK PENTAGON
\\perp                              <char-0x027C2>               " ⟂          : PERPENDICULAR
\\perspcorrespond                   <char-0x02A5E>               " ⩞          : LOGICAL AND WITH DOUBLE OVERBAR
\\pertenthousand                    <char-0x02031>               " ‱          : PER TEN THOUSAND SIGN
\\perthousand                       <char-0x02030>               " ‰          : PER MILLE SIGN
\\pes                               <char-0x020A7>               " ₧          : PESETA SIGN
\\pgamma                            <char-0x00263>               " ɣ          : LATIN SMALL LETTER GAMMA
\\phi                               <char-0x003D5>               " ϕ          : GREEK PHI SYMBOL / GREEK SMALL LETTER SCRIPT PHI
\\pi                                <char-0x003C0>               " π          : GREEK SMALL LETTER PI
\\pi<Tab>                           <char-0x003C0>               " π          : GREEK SMALL LETTER PI
\\pis                               \\pis                        "            : (Incomplete sequence)
\\pisc                              \\pisc                       "            : (Incomplete sequence)
\\pisce                             \\pisce                      "            : (Incomplete sequence)
\\pisces                            <char-0x02653>               " ♓          : PISCES
\\pit                               \\pit                        "            : (Incomplete sequence)
\\pitc                              \\pitc                       "            : (Incomplete sequence)
\\pitch                             \\pitch                      "            : (Incomplete sequence)
\\pitchf                            \\pitchf                     "            : (Incomplete sequence)
\\pitchfo                           \\pitchfo                    "            : (Incomplete sequence)
\\pitchfor                          \\pitchfor                   "            : (Incomplete sequence)
\\pitchfork                         <char-0x022D4>               " ⋔          : PITCHFORK
\\planck                            <char-0x0210E>               " ℎ          : PLANCK CONSTANT
\\plusdot                           <char-0x02A25>               " ⨥          : PLUS SIGN WITH DOT BELOW
\\pluseqq                           <char-0x02A72>               " ⩲          : PLUS SIGN ABOVE EQUALS SIGN
\\plushat                           <char-0x02A23>               " ⨣          : PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
\\plussim                           <char-0x02A26>               " ⨦          : PLUS SIGN WITH TILDE BELOW
\\plussubtwo                        <char-0x02A27>               " ⨧          : PLUS SIGN WITH SUBSCRIPT TWO
\\plustrif                          <char-0x02A28>               " ⨨          : PLUS SIGN WITH BLACK TRIANGLE
\\pluto                             <char-0x02647>               " ♇          : PLUTO
\\pm                                <char-0x000B1>               " ±          : PLUS-MINUS SIGN / PLUS-OR-MINUS SIGN
\\pointint                          <char-0x02A15>               " ⨕          : INTEGRAL AROUND A POINT OPERATOR
\\postalmark                        <char-0x03012>               " 〒          : POSTAL MARK
\\pppprime                          <char-0x02057>               " ⁗          : QUADRUPLE PRIME
\\ppprime                           <char-0x02034>               " ‴          : TRIPLE PRIME
\\pprime                            <char-0x02033>               " ″          : DOUBLE PRIME
\\prec                              <char-0x0227A>               " ≺          : PRECEDES
\\prec<Tab>                         <char-0x0227A>               " ≺          : PRECEDES
\\preca                             \\preca                      "            : (Incomplete sequence)
\\precap                            \\precap                     "            : (Incomplete sequence)
\\precapp                           \\precapp                    "            : (Incomplete sequence)
\\precappr                          \\precappr                   "            : (Incomplete sequence)
\\precappro                         \\precappro                  "            : (Incomplete sequence)
\\precapprox                        <char-0x02AB7>               " ⪷          : PRECEDES ABOVE ALMOST EQUAL TO
\\precc                             \\precc                      "            : (Incomplete sequence)
\\preccu                            \\preccu                     "            : (Incomplete sequence)
\\preccur                           \\preccur                    "            : (Incomplete sequence)
\\preccurl                          \\preccurl                   "            : (Incomplete sequence)
\\preccurly                         \\preccurly                  "            : (Incomplete sequence)
\\preccurlye                        \\preccurlye                 "            : (Incomplete sequence)
\\preccurlyeq                       <char-0x0227C>               " ≼          : PRECEDES OR EQUAL TO
\\prece                             \\prece                      "            : (Incomplete sequence)
\\preceq                            <char-0x02AAF>               " ⪯          : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
\\preceq<Tab>                       <char-0x02AAF>               " ⪯          : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
\\preceqq                           <char-0x02AB3>               " ⪳          : PRECEDES ABOVE EQUALS SIGN
\\precn                             \\precn                      "            : (Incomplete sequence)
\\precna                            \\precna                     "            : (Incomplete sequence)
\\precnap                           \\precnap                    "            : (Incomplete sequence)
\\precnapp                          \\precnapp                   "            : (Incomplete sequence)
\\precnappr                         \\precnappr                  "            : (Incomplete sequence)
\\precnappro                        \\precnappro                 "            : (Incomplete sequence)
\\precnapprox                       <char-0x02AB9>               " ⪹          : PRECEDES ABOVE NOT ALMOST EQUAL TO
\\precne                            \\precne                     "            : (Incomplete sequence)
\\precneq                           <char-0x02AB1>               " ⪱          : PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
\\precneq<Tab>                      <char-0x02AB1>               " ⪱          : PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
\\precneqq                          <char-0x02AB5>               " ⪵          : PRECEDES ABOVE NOT EQUAL TO
\\precns                            \\precns                     "            : (Incomplete sequence)
\\precnsi                           \\precnsi                    "            : (Incomplete sequence)
\\precnsim                          <char-0x022E8>               " ⋨          : PRECEDES BUT NOT EQUIVALENT TO
\\precs                             \\precs                      "            : (Incomplete sequence)
\\precsi                            \\precsi                     "            : (Incomplete sequence)
\\precsim                           <char-0x0227E>               " ≾          : PRECEDES OR EQUIVALENT TO
\\prime                             <char-0x02032>               " ′          : PRIME
\\prod                              <char-0x0220F>               " ∏          : N-ARY PRODUCT
\\profline                          <char-0x02312>               " ⌒          : ARC
\\profsurf                          <char-0x02313>               " ⌓          : SEGMENT
\\propto                            <char-0x0221D>               " ∝          : PROPORTIONAL TO
\\prurel                            <char-0x022B0>               " ⊰          : PRECEDES UNDER RELATION
\\pscrv                             <char-0x0028B>               " ʋ          : LATIN SMALL LETTER V WITH HOOK / LATIN SMALL LETTER SCRIPT V
\\psi                               <char-0x003C8>               " ψ          : GREEK SMALL LETTER PSI
\\pupsil                            <char-0x0028A>               " ʊ          : LATIN SMALL LETTER UPSILON
\\quad                              <char-0x02003>               "            : EM SPACE
\\quarternote                       <char-0x02669>               " ♩          : QUARTER NOTE
\\questeq                           <char-0x0225F>               " ≟          : QUESTIONED EQUAL TO
\\questiondown                      <char-0x000BF>               " ¿          : INVERTED QUESTION MARK
\\quotedblleft                      <char-0x0201C>               " “          : LEFT DOUBLE QUOTATION MARK / DOUBLE TURNED COMMA QUOTATION MARK
\\quotedblright                     <char-0x0201D>               " ”          : RIGHT DOUBLE QUOTATION MARK / DOUBLE COMMA QUOTATION MARK
\\rLarr                             <char-0x02944>               " ⥄          : SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW
\\rais                              <char-0x002D4>               " ˔          : MODIFIER LETTER UP TACK
\\rangle                            <char-0x027E9>               " ⟩          : MATHEMATICAL RIGHT ANGLE BRACKET
\\rarrx                             <char-0x02947>               " ⥇          : RIGHTWARDS ARROW THROUGH X
\\rasp                              <char-0x002BC>               " ʼ          : MODIFIER LETTER APOSTROPHE
\\rceil                             <char-0x02309>               " ⌉          : RIGHT CEILING
\\rdiagovfdiag                      <char-0x0292B>               " ⤫          : RISING DIAGONAL CROSSING FALLING DIAGONAL
\\rdiagovsearrow                    <char-0x02930>               " ⤰          : RISING DIAGONAL CROSSING SOUTH EAST ARROW
\\reapos                            <char-0x0201B>               " ‛          : SINGLE HIGH-REVERSED-9 QUOTATION MARK / SINGLE REVERSED COMMA QUOTATION MARK
\\recorder                          <char-0x02315>               " ⌕          : TELEPHONE RECORDER
\\reglst                            <char-0x00295>               " ʕ          : LATIN LETTER PHARYNGEAL VOICED FRICATIVE / LATIN LETTER REVERSED GLOTTAL STOP
\\revangle                          <char-0x029A3>               " ⦣          : REVERSED ANGLE
\\revangle<Tab>                     <char-0x029A3>               " ⦣          : REVERSED ANGLE
\\revangleu                         \\revangleu                  "            : (Incomplete sequence)
\\revangleub                        \\revangleub                 "            : (Incomplete sequence)
\\revangleuba                       \\revangleuba                "            : (Incomplete sequence)
\\revangleubar                      <char-0x029A5>               " ⦥          : REVERSED ANGLE WITH UNDERBAR
\\revemptyset                       <char-0x029B0>               " ⦰          : REVERSED EMPTY SET
\\rfloor                            <char-0x0230B>               " ⌋          : RIGHT FLOOR
\\rh                                <char-0x00322>               " ◌̢         : COMBINING RETROFLEX HOOK BELOW / NON-SPACING RETROFLEX HOOK BELOW
\\rh<Tab>                           <char-0x00322>               " ◌̢         : COMBINING RETROFLEX HOOK BELOW / NON-SPACING RETROFLEX HOOK BELOW
\\rho                               <char-0x003C1>               " ρ          : GREEK SMALL LETTER RHO
\\rightangle                        <char-0x0221F>               " ∟          : RIGHT ANGLE
\\rightangle<Tab>                   <char-0x0221F>               " ∟          : RIGHT ANGLE
\\rightanglea                       \\rightanglea                "            : (Incomplete sequence)
\\rightanglear                      \\rightanglear               "            : (Incomplete sequence)
\\rightanglearc                     <char-0x022BE>               " ⊾          : RIGHT ANGLE WITH ARC
\\rightanglem                       \\rightanglem                "            : (Incomplete sequence)
\\rightanglemd                      \\rightanglemd               "            : (Incomplete sequence)
\\rightanglemdo                     \\rightanglemdo              "            : (Incomplete sequence)
\\rightanglemdot                    <char-0x0299D>               " ⦝          : MEASURED RIGHT ANGLE WITH DOT
\\rightarrow                        <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\rightarrow<Tab>                   <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\rightarrowb                       \\rightarrowb                "            : (Incomplete sequence)
\\rightarrowba                      \\rightarrowba               "            : (Incomplete sequence)
\\rightarrowbac                     \\rightarrowbac              "            : (Incomplete sequence)
\\rightarrowback                    \\rightarrowback             "            : (Incomplete sequence)
\\rightarrowbacka                   \\rightarrowbacka            "            : (Incomplete sequence)
\\rightarrowbackap                  \\rightarrowbackap           "            : (Incomplete sequence)
\\rightarrowbackapp                 \\rightarrowbackapp          "            : (Incomplete sequence)
\\rightarrowbackappr                \\rightarrowbackappr         "            : (Incomplete sequence)
\\rightarrowbackappro               \\rightarrowbackappro        "            : (Incomplete sequence)
\\rightarrowbackapprox              <char-0x02B48>               " ⭈          : RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
\\rightarrowbar                     <char-0x021E5>               " ⇥          : RIGHTWARDS ARROW TO BAR / RIGHT ARROW TO BAR
\\rightarrowbs                      \\rightarrowbs               "            : (Incomplete sequence)
\\rightarrowbsi                     \\rightarrowbsi              "            : (Incomplete sequence)
\\rightarrowbsim                    \\rightarrowbsim             "            : (Incomplete sequence)
\\rightarrowbsimi                   \\rightarrowbsimi            "            : (Incomplete sequence)
\\rightarrowbsimil                  \\rightarrowbsimil           "            : (Incomplete sequence)
\\rightarrowbsimila                 \\rightarrowbsimila          "            : (Incomplete sequence)
\\rightarrowbsimilar                <char-0x02B4C>               " ⭌          : RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
\\rightarrowd                       \\rightarrowd                "            : (Incomplete sequence)
\\rightarrowdi                      \\rightarrowdi               "            : (Incomplete sequence)
\\rightarrowdia                     \\rightarrowdia              "            : (Incomplete sequence)
\\rightarrowdiam                    \\rightarrowdiam             "            : (Incomplete sequence)
\\rightarrowdiamo                   \\rightarrowdiamo            "            : (Incomplete sequence)
\\rightarrowdiamon                  \\rightarrowdiamon           "            : (Incomplete sequence)
\\rightarrowdiamond                 <char-0x0291E>               " ⤞          : RIGHTWARDS ARROW TO BLACK DIAMOND
\\rightarrowg                       \\rightarrowg                "            : (Incomplete sequence)
\\rightarrowgt                      \\rightarrowgt               "            : (Incomplete sequence)
\\rightarrowgtr                     <char-0x02B43>               " ⭃          : RIGHTWARDS ARROW THROUGH GREATER-THAN
\\rightarrowp                       \\rightarrowp                "            : (Incomplete sequence)
\\rightarrowpl                      \\rightarrowpl               "            : (Incomplete sequence)
\\rightarrowplu                     \\rightarrowplu              "            : (Incomplete sequence)
\\rightarrowplus                    <char-0x02945>               " ⥅          : RIGHTWARDS ARROW WITH PLUS BELOW
\\rightarrows                       \\rightarrows                "            : (Incomplete sequence)
\\rightarrowsu                      \\rightarrowsu               "            : (Incomplete sequence)
\\rightarrowsup                     \\rightarrowsup              "            : (Incomplete sequence)
\\rightarrowsups                    \\rightarrowsups             "            : (Incomplete sequence)
\\rightarrowsupse                   \\rightarrowsupse            "            : (Incomplete sequence)
\\rightarrowsupset                  <char-0x02B44>               " ⭄          : RIGHTWARDS ARROW THROUGH SUPERSET
\\rightarrowt                       \\rightarrowt                "            : (Incomplete sequence)
\\rightarrowta                      \\rightarrowta               "            : (Incomplete sequence)
\\rightarrowtai                     \\rightarrowtai              "            : (Incomplete sequence)
\\rightarrowtail                    <char-0x021A3>               " ↣          : RIGHTWARDS ARROW WITH TAIL / RIGHT ARROW WITH TAIL
\\rightarrowtr                      \\rightarrowtr               "            : (Incomplete sequence)
\\rightarrowtri                     \\rightarrowtri              "            : (Incomplete sequence)
\\rightarrowtria                    \\rightarrowtria             "            : (Incomplete sequence)
\\rightarrowtrian                   \\rightarrowtrian            "            : (Incomplete sequence)
\\rightarrowtriang                  \\rightarrowtriang           "            : (Incomplete sequence)
\\rightarrowtriangl                 \\rightarrowtriangl          "            : (Incomplete sequence)
\\rightarrowtriangle                <char-0x021FE>               " ⇾          : RIGHTWARDS OPEN-HEADED ARROW
\\rightdasharrow                    <char-0x021E2>               " ⇢          : RIGHTWARDS DASHED ARROW / RIGHT DASHED ARROW
\\rightdotarrow                     <char-0x02911>               " ⤑          : RIGHTWARDS ARROW WITH DOTTED STEM
\\rightharpoonaccent                <char-0x020D1>               " ◌⃑         : COMBINING RIGHT HARPOON ABOVE / NON-SPACING RIGHT HARPOON ABOVE
\\rightharpoondown                  <char-0x021C1>               " ⇁          : RIGHTWARDS HARPOON WITH BARB DOWNWARDS / RIGHT HARPOON WITH BARB DOWN
\\rightharpoonsupdown               <char-0x02964>               " ⥤          : RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
\\rightharpoonup                    <char-0x021C0>               " ⇀          : RIGHTWARDS HARPOON WITH BARB UPWARDS / RIGHT HARPOON WITH BARB UP
\\rightharpoonup<Tab>               <char-0x021C0>               " ⇀          : RIGHTWARDS HARPOON WITH BARB UPWARDS / RIGHT HARPOON WITH BARB UP
\\rightharpoonupd                   \\rightharpoonupd            "            : (Incomplete sequence)
\\rightharpoonupda                  \\rightharpoonupda           "            : (Incomplete sequence)
\\rightharpoonupdas                 \\rightharpoonupdas          "            : (Incomplete sequence)
\\rightharpoonupdash                <char-0x0296C>               " ⥬          : RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
\\rightleftarrows                   <char-0x021C4>               " ⇄          : RIGHTWARDS ARROW OVER LEFTWARDS ARROW / RIGHT ARROW OVER LEFT ARROW
\\rightleftharpoons                 <char-0x021CC>               " ⇌          : RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON / RIGHT HARPOON OVER LEFT HARPOON
\\rightleftharpoons<Tab>            <char-0x021CC>               " ⇌          : RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON / RIGHT HARPOON OVER LEFT HARPOON
\\rightleftharpoonsd                \\rightleftharpoonsd         "            : (Incomplete sequence)
\\rightleftharpoonsdo               \\rightleftharpoonsdo        "            : (Incomplete sequence)
\\rightleftharpoonsdow              \\rightleftharpoonsdow       "            : (Incomplete sequence)
\\rightleftharpoonsdown             <char-0x02969>               " ⥩          : RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
\\rightleftharpoonsu                \\rightleftharpoonsu         "            : (Incomplete sequence)
\\rightleftharpoonsup               <char-0x02968>               " ⥨          : RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
\\rightmoon                         <char-0x0263D>               " ☽          : FIRST QUARTER MOON
\\rightouterjoin                    <char-0x027D6>               " ⟖          : RIGHT OUTER JOIN
\\rightpentagon                     <char-0x02B54>               " ⭔          : WHITE RIGHT-POINTING PENTAGON
\\rightpentagon<Tab>                <char-0x02B54>               " ⭔          : WHITE RIGHT-POINTING PENTAGON
\\rightpentagonb                    \\rightpentagonb             "            : (Incomplete sequence)
\\rightpentagonbl                   \\rightpentagonbl            "            : (Incomplete sequence)
\\rightpentagonbla                  \\rightpentagonbla           "            : (Incomplete sequence)
\\rightpentagonblac                 \\rightpentagonblac          "            : (Incomplete sequence)
\\rightpentagonblack                <char-0x02B53>               " ⭓          : BLACK RIGHT-POINTING PENTAGON
\\rightrightarrows                  <char-0x021C9>               " ⇉          : RIGHTWARDS PAIRED ARROWS / RIGHT PAIRED ARROWS
\\rightsquigarrow                   <char-0x021DD>               " ⇝          : RIGHTWARDS SQUIGGLE ARROW / RIGHT SQUIGGLE ARROW
\\rightthreearrows                  <char-0x021F6>               " ⇶          : THREE RIGHTWARDS ARROWS
\\rightthreetimes                   <char-0x022CC>               " ⋌          : RIGHT SEMIDIRECT PRODUCT
\\rightwavearrow                    <char-0x0219D>               " ↝          : RIGHTWARDS WAVE ARROW / RIGHT WAVE ARROW
\\rightwhitearrow                   <char-0x021E8>               " ⇨          : RIGHTWARDS WHITE ARROW / WHITE RIGHT ARROW
\\ringplus                          <char-0x02A22>               " ⨢          : PLUS SIGN WITH SMALL CIRCLE ABOVE
\\risingdotseq                      <char-0x02253>               " ≓          : IMAGE OF OR APPROXIMATELY EQUAL TO
\\rl                                <char-0x0027C>               " ɼ          : LATIN SMALL LETTER R WITH LONG LEG
\\rmoustache                        <char-0x023B1>               " ⎱          : UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
\\rppolint                          <char-0x02A12>               " ⨒          : LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
\\rq                                <char-0x02019>               " ’          : RIGHT SINGLE QUOTATION MARK / SINGLE COMMA QUOTATION MARK
\\rrbracket                         <char-0x027E7>               " ⟧          : MATHEMATICAL RIGHT WHITE SQUARE BRACKET
\\rsolbar                           <char-0x029F7>               " ⧷          : REVERSE SOLIDUS WITH HORIZONTAL STROKE
\\rsqhook                           <char-0x02ACE>               " ⫎          : SQUARE RIGHT OPEN BOX OPERATOR
\\rtimes                            <char-0x022CA>               " ⋊          : RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
\\rtld                              <char-0x00256>               " ɖ          : LATIN SMALL LETTER D WITH TAIL / LATIN SMALL LETTER D RETROFLEX HOOK
\\rtll                              <char-0x0026D>               " ɭ          : LATIN SMALL LETTER L WITH RETROFLEX HOOK / LATIN SMALL LETTER L RETROFLEX HOOK
\\rtln                              <char-0x00273>               " ɳ          : LATIN SMALL LETTER N WITH RETROFLEX HOOK / LATIN SMALL LETTER N RETROFLEX HOOK
\\rtlr                              <char-0x0027D>               " ɽ          : LATIN SMALL LETTER R WITH TAIL / LATIN SMALL LETTER R HOOK
\\rtls                              <char-0x00282>               " ʂ          : LATIN SMALL LETTER S WITH HOOK / LATIN SMALL LETTER S HOOK
\\rtlt                              <char-0x00288>               " ʈ          : LATIN SMALL LETTER T WITH RETROFLEX HOOK / LATIN SMALL LETTER T RETROFLEX HOOK
\\rtlz                              <char-0x00290>               " ʐ          : LATIN SMALL LETTER Z WITH RETROFLEX HOOK / LATIN SMALL LETTER Z RETROFLEX HOOK
\\rttrnr                            <char-0x0027B>               " ɻ          : LATIN SMALL LETTER TURNED R WITH HOOK / LATIN SMALL LETTER TURNED R HOOK
\\rvboxline                         <char-0x023B9>               " ⎹          : RIGHT VERTICAL BOX LINE
\\rvbull                            <char-0x025D8>               " ◘          : INVERSE BULLET
\\sagittarius                       <char-0x02650>               " ♐          : SAGITTARIUS
\\sansA                             <char-0x1D5A0>               " 𝖠          : MATHEMATICAL SANS-SERIF CAPITAL A
\\sansB                             <char-0x1D5A1>               " 𝖡          : MATHEMATICAL SANS-SERIF CAPITAL B
\\sansC                             <char-0x1D5A2>               " 𝖢          : MATHEMATICAL SANS-SERIF CAPITAL C
\\sansD                             <char-0x1D5A3>               " 𝖣          : MATHEMATICAL SANS-SERIF CAPITAL D
\\sansE                             <char-0x1D5A4>               " 𝖤          : MATHEMATICAL SANS-SERIF CAPITAL E
\\sansF                             <char-0x1D5A5>               " 𝖥          : MATHEMATICAL SANS-SERIF CAPITAL F
\\sansG                             <char-0x1D5A6>               " 𝖦          : MATHEMATICAL SANS-SERIF CAPITAL G
\\sansH                             <char-0x1D5A7>               " 𝖧          : MATHEMATICAL SANS-SERIF CAPITAL H
\\sansI                             <char-0x1D5A8>               " 𝖨          : MATHEMATICAL SANS-SERIF CAPITAL I
\\sansJ                             <char-0x1D5A9>               " 𝖩          : MATHEMATICAL SANS-SERIF CAPITAL J
\\sansK                             <char-0x1D5AA>               " 𝖪          : MATHEMATICAL SANS-SERIF CAPITAL K
\\sansL                             <char-0x1D5AB>               " 𝖫          : MATHEMATICAL SANS-SERIF CAPITAL L
\\sansL<Tab>                        <char-0x1D5AB>               " 𝖫          : MATHEMATICAL SANS-SERIF CAPITAL L
\\sansLm                            \\sansLm                     "            : (Incomplete sequence)
\\sansLmi                           \\sansLmi                    "            : (Incomplete sequence)
\\sansLmir                          \\sansLmir                   "            : (Incomplete sequence)
\\sansLmirr                         \\sansLmirr                  "            : (Incomplete sequence)
\\sansLmirro                        \\sansLmirro                 "            : (Incomplete sequence)
\\sansLmirror                       \\sansLmirror                "            : (Incomplete sequence)
\\sansLmirrore                      \\sansLmirrore               "            : (Incomplete sequence)
\\sansLmirrored                     <char-0x02143>               " ⅃          : REVERSED SANS-SERIF CAPITAL L
\\sansLt                            \\sansLt                     "            : (Incomplete sequence)
\\sansLtu                           \\sansLtu                    "            : (Incomplete sequence)
\\sansLtur                          \\sansLtur                   "            : (Incomplete sequence)
\\sansLturn                         \\sansLturn                  "            : (Incomplete sequence)
\\sansLturne                        \\sansLturne                 "            : (Incomplete sequence)
\\sansLturned                       <char-0x02142>               " ⅂          : TURNED SANS-SERIF CAPITAL L
\\sansM                             <char-0x1D5AC>               " 𝖬          : MATHEMATICAL SANS-SERIF CAPITAL M
\\sansN                             <char-0x1D5AD>               " 𝖭          : MATHEMATICAL SANS-SERIF CAPITAL N
\\sansO                             <char-0x1D5AE>               " 𝖮          : MATHEMATICAL SANS-SERIF CAPITAL O
\\sansP                             <char-0x1D5AF>               " 𝖯          : MATHEMATICAL SANS-SERIF CAPITAL P
\\sansQ                             <char-0x1D5B0>               " 𝖰          : MATHEMATICAL SANS-SERIF CAPITAL Q
\\sansR                             <char-0x1D5B1>               " 𝖱          : MATHEMATICAL SANS-SERIF CAPITAL R
\\sansS                             <char-0x1D5B2>               " 𝖲          : MATHEMATICAL SANS-SERIF CAPITAL S
\\sansT                             <char-0x1D5B3>               " 𝖳          : MATHEMATICAL SANS-SERIF CAPITAL T
\\sansU                             <char-0x1D5B4>               " 𝖴          : MATHEMATICAL SANS-SERIF CAPITAL U
\\sansV                             <char-0x1D5B5>               " 𝖵          : MATHEMATICAL SANS-SERIF CAPITAL V
\\sansW                             <char-0x1D5B6>               " 𝖶          : MATHEMATICAL SANS-SERIF CAPITAL W
\\sansX                             <char-0x1D5B7>               " 𝖷          : MATHEMATICAL SANS-SERIF CAPITAL X
\\sansY                             <char-0x1D5B8>               " 𝖸          : MATHEMATICAL SANS-SERIF CAPITAL Y
\\sansZ                             <char-0x1D5B9>               " 𝖹          : MATHEMATICAL SANS-SERIF CAPITAL Z
\\sansa                             <char-0x1D5BA>               " 𝖺          : MATHEMATICAL SANS-SERIF SMALL A
\\sansb                             <char-0x1D5BB>               " 𝖻          : MATHEMATICAL SANS-SERIF SMALL B
\\sansc                             <char-0x1D5BC>               " 𝖼          : MATHEMATICAL SANS-SERIF SMALL C
\\sansd                             <char-0x1D5BD>               " 𝖽          : MATHEMATICAL SANS-SERIF SMALL D
\\sanse                             <char-0x1D5BE>               " 𝖾          : MATHEMATICAL SANS-SERIF SMALL E
\\sanse<Tab>                        <char-0x1D5BE>               " 𝖾          : MATHEMATICAL SANS-SERIF SMALL E
\\sansei                            \\sansei                     "            : (Incomplete sequence)
\\sanseig                           \\sanseig                    "            : (Incomplete sequence)
\\sanseigh                          \\sanseigh                   "            : (Incomplete sequence)
\\sanseight                         <char-0x1D7EA>               " 𝟪          : MATHEMATICAL SANS-SERIF DIGIT EIGHT
\\sansf                             <char-0x1D5BF>               " 𝖿          : MATHEMATICAL SANS-SERIF SMALL F
\\sansf<Tab>                        <char-0x1D5BF>               " 𝖿          : MATHEMATICAL SANS-SERIF SMALL F
\\sansfi                            \\sansfi                     "            : (Incomplete sequence)
\\sansfiv                           \\sansfiv                    "            : (Incomplete sequence)
\\sansfive                          <char-0x1D7E7>               " 𝟧          : MATHEMATICAL SANS-SERIF DIGIT FIVE
\\sansfo                            \\sansfo                     "            : (Incomplete sequence)
\\sansfou                           \\sansfou                    "            : (Incomplete sequence)
\\sansfour                          <char-0x1D7E6>               " 𝟦          : MATHEMATICAL SANS-SERIF DIGIT FOUR
\\sansg                             <char-0x1D5C0>               " 𝗀          : MATHEMATICAL SANS-SERIF SMALL G
\\sansh                             <char-0x1D5C1>               " 𝗁          : MATHEMATICAL SANS-SERIF SMALL H
\\sansi                             <char-0x1D5C2>               " 𝗂          : MATHEMATICAL SANS-SERIF SMALL I
\\sansj                             <char-0x1D5C3>               " 𝗃          : MATHEMATICAL SANS-SERIF SMALL J
\\sansk                             <char-0x1D5C4>               " 𝗄          : MATHEMATICAL SANS-SERIF SMALL K
\\sansl                             <char-0x1D5C5>               " 𝗅          : MATHEMATICAL SANS-SERIF SMALL L
\\sansm                             <char-0x1D5C6>               " 𝗆          : MATHEMATICAL SANS-SERIF SMALL M
\\sansn                             <char-0x1D5C7>               " 𝗇          : MATHEMATICAL SANS-SERIF SMALL N
\\sansn<Tab>                        <char-0x1D5C7>               " 𝗇          : MATHEMATICAL SANS-SERIF SMALL N
\\sansni                            \\sansni                     "            : (Incomplete sequence)
\\sansnin                           \\sansnin                    "            : (Incomplete sequence)
\\sansnine                          <char-0x1D7EB>               " 𝟫          : MATHEMATICAL SANS-SERIF DIGIT NINE
\\sanso                             <char-0x1D5C8>               " 𝗈          : MATHEMATICAL SANS-SERIF SMALL O
\\sanso<Tab>                        <char-0x1D5C8>               " 𝗈          : MATHEMATICAL SANS-SERIF SMALL O
\\sanson                            \\sanson                     "            : (Incomplete sequence)
\\sansone                           <char-0x1D7E3>               " 𝟣          : MATHEMATICAL SANS-SERIF DIGIT ONE
\\sansp                             <char-0x1D5C9>               " 𝗉          : MATHEMATICAL SANS-SERIF SMALL P
\\sansq                             <char-0x1D5CA>               " 𝗊          : MATHEMATICAL SANS-SERIF SMALL Q
\\sansr                             <char-0x1D5CB>               " 𝗋          : MATHEMATICAL SANS-SERIF SMALL R
\\sanss                             <char-0x1D5CC>               " 𝗌          : MATHEMATICAL SANS-SERIF SMALL S
\\sanss<Tab>                        <char-0x1D5CC>               " 𝗌          : MATHEMATICAL SANS-SERIF SMALL S
\\sansse                            \\sansse                     "            : (Incomplete sequence)
\\sanssev                           \\sanssev                    "            : (Incomplete sequence)
\\sansseve                          \\sansseve                   "            : (Incomplete sequence)
\\sansseven                         <char-0x1D7E9>               " 𝟩          : MATHEMATICAL SANS-SERIF DIGIT SEVEN
\\sanssi                            \\sanssi                     "            : (Incomplete sequence)
\\sanssix                           <char-0x1D7E8>               " 𝟨          : MATHEMATICAL SANS-SERIF DIGIT SIX
\\sanst                             <char-0x1D5CD>               " 𝗍          : MATHEMATICAL SANS-SERIF SMALL T
\\sanst<Tab>                        <char-0x1D5CD>               " 𝗍          : MATHEMATICAL SANS-SERIF SMALL T
\\sansth                            \\sansth                     "            : (Incomplete sequence)
\\sansthr                           \\sansthr                    "            : (Incomplete sequence)
\\sansthre                          \\sansthre                   "            : (Incomplete sequence)
\\sansthree                         <char-0x1D7E5>               " 𝟥          : MATHEMATICAL SANS-SERIF DIGIT THREE
\\sanstw                            \\sanstw                     "            : (Incomplete sequence)
\\sanstwo                           <char-0x1D7E4>               " 𝟤          : MATHEMATICAL SANS-SERIF DIGIT TWO
\\sansu                             <char-0x1D5CE>               " 𝗎          : MATHEMATICAL SANS-SERIF SMALL U
\\sansv                             <char-0x1D5CF>               " 𝗏          : MATHEMATICAL SANS-SERIF SMALL V
\\sansw                             <char-0x1D5D0>               " 𝗐          : MATHEMATICAL SANS-SERIF SMALL W
\\sansx                             <char-0x1D5D1>               " 𝗑          : MATHEMATICAL SANS-SERIF SMALL X
\\sansy                             <char-0x1D5D2>               " 𝗒          : MATHEMATICAL SANS-SERIF SMALL Y
\\sansz                             <char-0x1D5D3>               " 𝗓          : MATHEMATICAL SANS-SERIF SMALL Z
\\sansz<Tab>                        <char-0x1D5D3>               " 𝗓          : MATHEMATICAL SANS-SERIF SMALL Z
\\sansze                            \\sansze                     "            : (Incomplete sequence)
\\sanszer                           \\sanszer                    "            : (Incomplete sequence)
\\sanszero                          <char-0x1D7E2>               " 𝟢          : MATHEMATICAL SANS-SERIF DIGIT ZERO
\\saturn                            <char-0x02644>               " ♄          : SATURN
\\sbbrg                             <char-0x0032A>               " ◌̪         : COMBINING BRIDGE BELOW / NON-SPACING BRIDGE BELOW
\\sblhr                             <char-0x002D3>               " ˓          : MODIFIER LETTER CENTRED LEFT HALF RING / MODIFIER LETTER CENTERED LEFT HALF RING
\\sbrhr                             <char-0x002D2>               " ˒          : MODIFIER LETTER CENTRED RIGHT HALF RING / MODIFIER LETTER CENTERED RIGHT HALF RING
\\schwa                             <char-0x00259>               " ə          : LATIN SMALL LETTER SCHWA
\\scorpio                           <char-0x0264F>               " ♏          : SCORPIUS
\\scpolint                          <char-0x02A13>               " ⨓          : LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
\\scrA                              <char-0x1D49C>               " 𝒜          : MATHEMATICAL SCRIPT CAPITAL A
\\scrB                              <char-0x0212C>               " ℬ          : SCRIPT CAPITAL B / SCRIPT B
\\scrC                              <char-0x1D49E>               " 𝒞          : MATHEMATICAL SCRIPT CAPITAL C
\\scrD                              <char-0x1D49F>               " 𝒟          : MATHEMATICAL SCRIPT CAPITAL D
\\scrE                              <char-0x02130>               " ℰ          : SCRIPT CAPITAL E / SCRIPT E
\\scrF                              <char-0x02131>               " ℱ          : SCRIPT CAPITAL F / SCRIPT F
\\scrG                              <char-0x1D4A2>               " 𝒢          : MATHEMATICAL SCRIPT CAPITAL G
\\scrH                              <char-0x0210B>               " ℋ          : SCRIPT CAPITAL H / SCRIPT H
\\scrI                              <char-0x02110>               " ℐ          : SCRIPT CAPITAL I / SCRIPT I
\\scrJ                              <char-0x1D4A5>               " 𝒥          : MATHEMATICAL SCRIPT CAPITAL J
\\scrK                              <char-0x1D4A6>               " 𝒦          : MATHEMATICAL SCRIPT CAPITAL K
\\scrL                              <char-0x02112>               " ℒ          : SCRIPT CAPITAL L / SCRIPT L
\\scrM                              <char-0x02133>               " ℳ          : SCRIPT CAPITAL M / SCRIPT M
\\scrN                              <char-0x1D4A9>               " 𝒩          : MATHEMATICAL SCRIPT CAPITAL N
\\scrO                              <char-0x1D4AA>               " 𝒪          : MATHEMATICAL SCRIPT CAPITAL O
\\scrP                              <char-0x1D4AB>               " 𝒫          : MATHEMATICAL SCRIPT CAPITAL P
\\scrQ                              <char-0x1D4AC>               " 𝒬          : MATHEMATICAL SCRIPT CAPITAL Q
\\scrR                              <char-0x0211B>               " ℛ          : SCRIPT CAPITAL R / SCRIPT R
\\scrS                              <char-0x1D4AE>               " 𝒮          : MATHEMATICAL SCRIPT CAPITAL S
\\scrT                              <char-0x1D4AF>               " 𝒯          : MATHEMATICAL SCRIPT CAPITAL T
\\scrU                              <char-0x1D4B0>               " 𝒰          : MATHEMATICAL SCRIPT CAPITAL U
\\scrV                              <char-0x1D4B1>               " 𝒱          : MATHEMATICAL SCRIPT CAPITAL V
\\scrW                              <char-0x1D4B2>               " 𝒲          : MATHEMATICAL SCRIPT CAPITAL W
\\scrX                              <char-0x1D4B3>               " 𝒳          : MATHEMATICAL SCRIPT CAPITAL X
\\scrY                              <char-0x1D4B4>               " 𝒴          : MATHEMATICAL SCRIPT CAPITAL Y
\\scrZ                              <char-0x1D4B5>               " 𝒵          : MATHEMATICAL SCRIPT CAPITAL Z
\\scra                              <char-0x1D4B6>               " 𝒶          : MATHEMATICAL SCRIPT SMALL A
\\scrb                              <char-0x1D4B7>               " 𝒷          : MATHEMATICAL SCRIPT SMALL B
\\scrc                              <char-0x1D4B8>               " 𝒸          : MATHEMATICAL SCRIPT SMALL C
\\scrd                              <char-0x1D4B9>               " 𝒹          : MATHEMATICAL SCRIPT SMALL D
\\scre                              <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\scrf                              <char-0x1D4BB>               " 𝒻          : MATHEMATICAL SCRIPT SMALL F
\\scrg                              <char-0x0210A>               " ℊ          : SCRIPT SMALL G
\\scrh                              <char-0x1D4BD>               " 𝒽          : MATHEMATICAL SCRIPT SMALL H
\\scri                              <char-0x1D4BE>               " 𝒾          : MATHEMATICAL SCRIPT SMALL I
\\scrj                              <char-0x1D4BF>               " 𝒿          : MATHEMATICAL SCRIPT SMALL J
\\scrk                              <char-0x1D4C0>               " 𝓀          : MATHEMATICAL SCRIPT SMALL K
\\scrl                              <char-0x1D4C1>               " 𝓁          : MATHEMATICAL SCRIPT SMALL L
\\scrm                              <char-0x1D4C2>               " 𝓂          : MATHEMATICAL SCRIPT SMALL M
\\scrn                              <char-0x1D4C3>               " 𝓃          : MATHEMATICAL SCRIPT SMALL N
\\scro                              <char-0x02134>               " ℴ          : SCRIPT SMALL O
\\scrp                              <char-0x1D4C5>               " 𝓅          : MATHEMATICAL SCRIPT SMALL P
\\scrq                              <char-0x1D4C6>               " 𝓆          : MATHEMATICAL SCRIPT SMALL Q
\\scrr                              <char-0x1D4C7>               " 𝓇          : MATHEMATICAL SCRIPT SMALL R
\\scrs                              <char-0x1D4C8>               " 𝓈          : MATHEMATICAL SCRIPT SMALL S
\\scrt                              <char-0x1D4C9>               " 𝓉          : MATHEMATICAL SCRIPT SMALL T
\\scru                              <char-0x1D4CA>               " 𝓊          : MATHEMATICAL SCRIPT SMALL U
\\scrv                              <char-0x1D4CB>               " 𝓋          : MATHEMATICAL SCRIPT SMALL V
\\scrw                              <char-0x1D4CC>               " 𝓌          : MATHEMATICAL SCRIPT SMALL W
\\scrx                              <char-0x1D4CD>               " 𝓍          : MATHEMATICAL SCRIPT SMALL X
\\scry                              <char-0x1D4CE>               " 𝓎          : MATHEMATICAL SCRIPT SMALL Y
\\scrz                              <char-0x1D4CF>               " 𝓏          : MATHEMATICAL SCRIPT SMALL Z
\\scurel                            <char-0x022B1>               " ⊱          : SUCCEEDS UNDER RELATION
\\searrow                           <char-0x02198>               " ↘          : SOUTH EAST ARROW / LOWER RIGHT ARROW
\\seovnearrow                       <char-0x0292D>               " ⤭          : SOUTH EAST ARROW CROSSING NORTH EAST ARROW
\\setminus                          <char-0x02216>               " ∖          : SET MINUS
\\sharp                             <char-0x0266F>               " ♯          : MUSIC SHARP SIGN / SHARP
\\shuffle                           <char-0x029E2>               " ⧢          : SHUFFLE PRODUCT
\\sigma                             <char-0x003C3>               " σ          : GREEK SMALL LETTER SIGMA
\\sim                               <char-0x0223C>               " ∼          : TILDE OPERATOR
\\sim<Tab>                          <char-0x0223C>               " ∼          : TILDE OPERATOR
\\sime                              \\sime                       "            : (Incomplete sequence)
\\simeq                             <char-0x02243>               " ≃          : ASYMPTOTICALLY EQUAL TO
\\simg                              \\simg                       "            : (Incomplete sequence)
\\simgE                             <char-0x02AA0>               " ⪠          : SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
\\simgt                             \\simgt                      "            : (Incomplete sequence)
\\simgtr                            <char-0x02A9E>               " ⪞          : SIMILAR OR GREATER-THAN
\\simi                              \\simi                       "            : (Incomplete sequence)
\\simil                             \\simil                      "            : (Incomplete sequence)
\\simila                            \\simila                     "            : (Incomplete sequence)
\\similar                           \\similar                    "            : (Incomplete sequence)
\\similarl                          \\similarl                   "            : (Incomplete sequence)
\\similarle                         \\similarle                  "            : (Incomplete sequence)
\\similarlef                        \\similarlef                 "            : (Incomplete sequence)
\\similarleft                       \\similarleft                "            : (Incomplete sequence)
\\similarlefta                      \\similarlefta               "            : (Incomplete sequence)
\\similarleftar                     \\similarleftar              "            : (Incomplete sequence)
\\similarleftarr                    \\similarleftarr             "            : (Incomplete sequence)
\\similarleftarro                   \\similarleftarro            "            : (Incomplete sequence)
\\similarleftarrow                  <char-0x02B49>               " ⭉          : TILDE OPERATOR ABOVE LEFTWARDS ARROW
\\siml                              \\siml                       "            : (Incomplete sequence)
\\simlE                             <char-0x02A9F>               " ⪟          : SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
\\simle                             \\simle                      "            : (Incomplete sequence)
\\simles                            \\simles                     "            : (Incomplete sequence)
\\simless                           <char-0x02A9D>               " ⪝          : SIMILAR OR LESS-THAN
\\simm                              \\simm                       "            : (Incomplete sequence)
\\simmi                             \\simmi                      "            : (Incomplete sequence)
\\simmin                            \\simmin                     "            : (Incomplete sequence)
\\simminu                           \\simminu                    "            : (Incomplete sequence)
\\simminus                          \\simminus                   "            : (Incomplete sequence)
\\simminuss                         \\simminuss                  "            : (Incomplete sequence)
\\simminussi                        \\simminussi                 "            : (Incomplete sequence)
\\simminussim                       <char-0x02A6C>               " ⩬          : SIMILAR MINUS SIMILAR
\\simp                              \\simp                       "            : (Incomplete sequence)
\\simpl                             \\simpl                      "            : (Incomplete sequence)
\\simplu                            \\simplu                     "            : (Incomplete sequence)
\\simplus                           <char-0x02A24>               " ⨤          : PLUS SIGN WITH TILDE ABOVE
\\simr                              \\simr                       "            : (Incomplete sequence)
\\simrd                             \\simrd                      "            : (Incomplete sequence)
\\simrdo                            \\simrdo                     "            : (Incomplete sequence)
\\simrdot                           \\simrdot                    "            : (Incomplete sequence)
\\simrdots                          <char-0x02A6B>               " ⩫          : TILDE OPERATOR WITH RISING DOTS
\\sinewave                          <char-0x0223F>               " ∿          : SINE WAVE
\\smallblacktriangleleft            <char-0x025C2>               " ◂          : BLACK LEFT-POINTING SMALL TRIANGLE / BLACK LEFT POINTING SMALL TRIANGLE
\\smallblacktriangleright           <char-0x025B8>               " ▸          : BLACK RIGHT-POINTING SMALL TRIANGLE / BLACK RIGHT POINTING SMALL TRIANGLE
\\smallin                           <char-0x0220A>               " ∊          : SMALL ELEMENT OF
\\smallni                           <char-0x0220D>               " ∍          : SMALL CONTAINS AS MEMBER
\\smalltriangleleft                 <char-0x025C3>               " ◃          : WHITE LEFT-POINTING SMALL TRIANGLE / WHITE LEFT POINTING SMALL TRIANGLE
\\smalltriangleright                <char-0x025B9>               " ▹          : WHITE RIGHT-POINTING SMALL TRIANGLE / WHITE RIGHT POINTING SMALL TRIANGLE
\\smashtimes                        <char-0x02A33>               " ⨳          : SMASH PRODUCT
\\smblkdiamond                      <char-0x02B29>               " ⬩          : BLACK SMALL DIAMOND
\\smblklozenge                      <char-0x02B2A>               " ⬪          : BLACK SMALL LOZENGE
\\smblksquare                       <char-0x025AA>               " ▪          : BLACK SMALL SQUARE
\\smeparsl                          <char-0x029E4>               " ⧤          : EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
\\smile                             <char-0x02323>               " ⌣          : SMILE
\\smt                               <char-0x02AAA>               " ⪪          : SMALLER THAN
\\smt<Tab>                          <char-0x02AAA>               " ⪪          : SMALLER THAN
\\smte                              <char-0x02AAC>               " ⪬          : SMALLER THAN OR EQUAL TO
\\smwhitestar                       <char-0x02B52>               " ⭒          : WHITE SMALL STAR
\\smwhtcircle                       <char-0x025E6>               " ◦          : WHITE BULLET
\\smwhtlozenge                      <char-0x02B2B>               " ⬫          : WHITE SMALL LOZENGE
\\smwhtsquare                       <char-0x025AB>               " ▫          : WHITE SMALL SQUARE
\\sout                              <char-0x00336>               " ◌̶         : COMBINING LONG STROKE OVERLAY / NON-SPACING LONG BAR OVERLAY
\\spadesuit                         <char-0x02660>               " ♠          : BLACK SPADE SUIT
\\sphericalangle                    <char-0x02222>               " ∢          : SPHERICAL ANGLE
\\sphericalangle<Tab>               <char-0x02222>               " ∢          : SPHERICAL ANGLE
\\sphericalangleu                   \\sphericalangleu            "            : (Incomplete sequence)
\\sphericalangleup                  <char-0x029A1>               " ⦡          : SPHERICAL ANGLE OPENING UP
\\sqcap                             <char-0x02293>               " ⊓          : SQUARE CAP
\\sqcup                             <char-0x02294>               " ⊔          : SQUARE CUP
\\sqfl                              <char-0x025E7>               " ◧          : SQUARE WITH LEFT HALF BLACK
\\sqfnw                             <char-0x02519>               " ┙          : BOX DRAWINGS UP LIGHT AND LEFT HEAVY / FORMS UP LIGHT AND LEFT HEAVY
\\sqfr                              <char-0x025E8>               " ◨          : SQUARE WITH RIGHT HALF BLACK
\\sqfse                             <char-0x025EA>               " ◪          : SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK
\\sqlozenge                         <char-0x02311>               " ⌑          : SQUARE LOZENGE
\\sqrint                            <char-0x02A16>               " ⨖          : QUATERNION INTEGRAL OPERATOR
\\sqrt                              <char-0x0221A>               " √          : SQUARE ROOT
\\sqrt<Tab>                         <char-0x0221A>               " √          : SQUARE ROOT
\\sqrtb                             \\sqrtb                      "            : (Incomplete sequence)
\\sqrtbo                            \\sqrtbo                     "            : (Incomplete sequence)
\\sqrtbot                           \\sqrtbot                    "            : (Incomplete sequence)
\\sqrtbott                          \\sqrtbott                   "            : (Incomplete sequence)
\\sqrtbotto                         \\sqrtbotto                  "            : (Incomplete sequence)
\\sqrtbottom                        <char-0x023B7>               " ⎷          : RADICAL SYMBOL BOTTOM
\\sqspne                            <char-0x022E5>               " ⋥          : SQUARE ORIGINAL OF OR NOT EQUAL TO
\\sqsubset                          <char-0x0228F>               " ⊏          : SQUARE IMAGE OF
\\sqsubset<Tab>                     <char-0x0228F>               " ⊏          : SQUARE IMAGE OF
\\sqsubsete                         \\sqsubsete                  "            : (Incomplete sequence)
\\sqsubseteq                        <char-0x02291>               " ⊑          : SQUARE IMAGE OF OR EQUAL TO
\\sqsubsetn                         \\sqsubsetn                  "            : (Incomplete sequence)
\\sqsubsetne                        \\sqsubsetne                 "            : (Incomplete sequence)
\\sqsubsetneq                       <char-0x022E4>               " ⋤          : SQUARE IMAGE OF OR NOT EQUAL TO
\\sqsupset                          <char-0x02290>               " ⊐          : SQUARE ORIGINAL OF
\\sqsupset<Tab>                     <char-0x02290>               " ⊐          : SQUARE ORIGINAL OF
\\sqsupsete                         \\sqsupsete                  "            : (Incomplete sequence)
\\sqsupseteq                        <char-0x02292>               " ⊒          : SQUARE ORIGINAL OF OR EQUAL TO
\\square                            <char-0x025A1>               " □          : WHITE SQUARE
\\square<Tab>                       <char-0x025A1>               " □          : WHITE SQUARE
\\squareb                           \\squareb                    "            : (Incomplete sequence)
\\squarebo                          \\squarebo                   "            : (Incomplete sequence)
\\squarebot                         \\squarebot                  "            : (Incomplete sequence)
\\squarebotb                        \\squarebotb                 "            : (Incomplete sequence)
\\squarebotbl                       \\squarebotbl                "            : (Incomplete sequence)
\\squarebotbla                      \\squarebotbla               "            : (Incomplete sequence)
\\squarebotblac                     \\squarebotblac              "            : (Incomplete sequence)
\\squarebotblack                    <char-0x02B13>               " ⬓          : SQUARE WITH BOTTOM HALF BLACK
\\squarec                           \\squarec                    "            : (Incomplete sequence)
\\squarecr                          \\squarecr                   "            : (Incomplete sequence)
\\squarecro                         \\squarecro                  "            : (Incomplete sequence)
\\squarecros                        \\squarecros                 "            : (Incomplete sequence)
\\squarecross                       \\squarecross                "            : (Incomplete sequence)
\\squarecrossf                      \\squarecrossf               "            : (Incomplete sequence)
\\squarecrossfi                     \\squarecrossfi              "            : (Incomplete sequence)
\\squarecrossfil                    \\squarecrossfil             "            : (Incomplete sequence)
\\squarecrossfill                   <char-0x025A9>               " ▩          : SQUARE WITH DIAGONAL CROSSHATCH FILL
\\squareh                           \\squareh                    "            : (Incomplete sequence)
\\squarehf                          \\squarehf                   "            : (Incomplete sequence)
\\squarehfi                         \\squarehfi                  "            : (Incomplete sequence)
\\squarehfil                        \\squarehfil                 "            : (Incomplete sequence)
\\squarehfill                       <char-0x025A4>               " ▤          : SQUARE WITH HORIZONTAL FILL
\\squarehv                          \\squarehv                   "            : (Incomplete sequence)
\\squarehvf                         \\squarehvf                  "            : (Incomplete sequence)
\\squarehvfi                        \\squarehvfi                 "            : (Incomplete sequence)
\\squarehvfil                       \\squarehvfil                "            : (Incomplete sequence)
\\squarehvfill                      <char-0x025A6>               " ▦          : SQUARE WITH ORTHOGONAL CROSSHATCH FILL
\\squarel                           \\squarel                    "            : (Incomplete sequence)
\\squarell                          \\squarell                   "            : (Incomplete sequence)
\\squarellb                         \\squarellb                  "            : (Incomplete sequence)
\\squarellbl                        \\squarellbl                 "            : (Incomplete sequence)
\\squarellbla                       \\squarellbla                "            : (Incomplete sequence)
\\squarellblac                      \\squarellblac               "            : (Incomplete sequence)
\\squarellblack                     <char-0x02B15>               " ⬕          : SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK
\\squarellq                         \\squarellq                  "            : (Incomplete sequence)
\\squarellqu                        \\squarellqu                 "            : (Incomplete sequence)
\\squarellqua                       \\squarellqua                "            : (Incomplete sequence)
\\squarellquad                      <char-0x025F1>               " ◱          : WHITE SQUARE WITH LOWER LEFT QUADRANT
\\squarelr                          \\squarelr                   "            : (Incomplete sequence)
\\squarelrq                         \\squarelrq                  "            : (Incomplete sequence)
\\squarelrqu                        \\squarelrqu                 "            : (Incomplete sequence)
\\squarelrqua                       \\squarelrqua                "            : (Incomplete sequence)
\\squarelrquad                      <char-0x025F2>               " ◲          : WHITE SQUARE WITH LOWER RIGHT QUADRANT
\\squaren                           \\squaren                    "            : (Incomplete sequence)
\\squarene                          \\squarene                   "            : (Incomplete sequence)
\\squarenes                         \\squarenes                  "            : (Incomplete sequence)
\\squarenesw                        \\squarenesw                 "            : (Incomplete sequence)
\\squareneswf                       \\squareneswf                "            : (Incomplete sequence)
\\squareneswfi                      \\squareneswfi               "            : (Incomplete sequence)
\\squareneswfil                     \\squareneswfil              "            : (Incomplete sequence)
\\squareneswfill                    <char-0x025A8>               " ▨          : SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
\\squarenw                          \\squarenw                   "            : (Incomplete sequence)
\\squarenws                         \\squarenws                  "            : (Incomplete sequence)
\\squarenwse                        \\squarenwse                 "            : (Incomplete sequence)
\\squarenwsef                       \\squarenwsef                "            : (Incomplete sequence)
\\squarenwsefi                      \\squarenwsefi               "            : (Incomplete sequence)
\\squarenwsefil                     \\squarenwsefil              "            : (Incomplete sequence)
\\squarenwsefill                    <char-0x025A7>               " ▧          : SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
\\squaret                           \\squaret                    "            : (Incomplete sequence)
\\squareto                          \\squareto                   "            : (Incomplete sequence)
\\squaretop                         \\squaretop                  "            : (Incomplete sequence)
\\squaretopb                        \\squaretopb                 "            : (Incomplete sequence)
\\squaretopbl                       \\squaretopbl                "            : (Incomplete sequence)
\\squaretopbla                      \\squaretopbla               "            : (Incomplete sequence)
\\squaretopblac                     \\squaretopblac              "            : (Incomplete sequence)
\\squaretopblack                    <char-0x02B12>               " ⬒          : SQUARE WITH TOP HALF BLACK
\\squareu                           \\squareu                    "            : (Incomplete sequence)
\\squareul                          \\squareul                   "            : (Incomplete sequence)
\\squareulb                         \\squareulb                  "            : (Incomplete sequence)
\\squareulbl                        \\squareulbl                 "            : (Incomplete sequence)
\\squareulbla                       \\squareulbla                "            : (Incomplete sequence)
\\squareulblac                      \\squareulblac               "            : (Incomplete sequence)
\\squareulblack                     <char-0x025E9>               " ◩          : SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK
\\squareulq                         \\squareulq                  "            : (Incomplete sequence)
\\squareulqu                        \\squareulqu                 "            : (Incomplete sequence)
\\squareulqua                       \\squareulqua                "            : (Incomplete sequence)
\\squareulquad                      <char-0x025F0>               " ◰          : WHITE SQUARE WITH UPPER LEFT QUADRANT
\\squareur                          \\squareur                   "            : (Incomplete sequence)
\\squareurb                         \\squareurb                  "            : (Incomplete sequence)
\\squareurbl                        \\squareurbl                 "            : (Incomplete sequence)
\\squareurbla                       \\squareurbla                "            : (Incomplete sequence)
\\squareurblac                      \\squareurblac               "            : (Incomplete sequence)
\\squareurblack                     <char-0x02B14>               " ⬔          : SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK
\\squareurq                         \\squareurq                  "            : (Incomplete sequence)
\\squareurqu                        \\squareurqu                 "            : (Incomplete sequence)
\\squareurqua                       \\squareurqua                "            : (Incomplete sequence)
\\squareurquad                      <char-0x025F3>               " ◳          : WHITE SQUARE WITH UPPER RIGHT QUADRANT
\\squarev                           \\squarev                    "            : (Incomplete sequence)
\\squarevf                          \\squarevf                   "            : (Incomplete sequence)
\\squarevfi                         \\squarevfi                  "            : (Incomplete sequence)
\\squarevfil                        \\squarevfil                 "            : (Incomplete sequence)
\\squarevfill                       <char-0x025A5>               " ▥          : SQUARE WITH VERTICAL FILL
\\squoval                           <char-0x025A2>               " ▢          : WHITE SQUARE WITH ROUNDED CORNERS
\\ss                                <char-0x000DF>               " ß          : LATIN SMALL LETTER SHARP S
\\star                              <char-0x022C6>               " ⋆          : STAR OPERATOR
\\star<Tab>                         <char-0x022C6>               " ⋆          : STAR OPERATOR
\\stare                             \\stare                      "            : (Incomplete sequence)
\\stareq                            \\stareq                     "            : (Incomplete sequence)
\\starequ                           \\starequ                    "            : (Incomplete sequence)
\\starequa                          \\starequa                   "            : (Incomplete sequence)
\\starequal                         <char-0x0225B>               " ≛          : STAR EQUALS
\\sterling                          <char-0x000A3>               " £          : POUND SIGN
\\strike                            <char-0x00336>               " ◌̶         : COMBINING LONG STROKE OVERLAY / NON-SPACING LONG BAR OVERLAY
\\strns                             <char-0x023E4>               " ⏤          : STRAIGHTNESS
\\subedot                           <char-0x02AC3>               " ⫃          : SUBSET OF OR EQUAL TO WITH DOT ABOVE
\\submult                           <char-0x02AC1>               " ⫁          : SUBSET WITH MULTIPLICATION SIGN BELOW
\\subset                            <char-0x02282>               " ⊂          : SUBSET OF
\\subset<Tab>                       <char-0x02282>               " ⊂          : SUBSET OF
\\subseta                           \\subseta                    "            : (Incomplete sequence)
\\subsetap                          \\subsetap                   "            : (Incomplete sequence)
\\subsetapp                         \\subsetapp                  "            : (Incomplete sequence)
\\subsetappr                        \\subsetappr                 "            : (Incomplete sequence)
\\subsetappro                       \\subsetappro                "            : (Incomplete sequence)
\\subsetapprox                      <char-0x02AC9>               " ⫉          : SUBSET OF ABOVE ALMOST EQUAL TO
\\subsetd                           \\subsetd                    "            : (Incomplete sequence)
\\subsetdo                          \\subsetdo                   "            : (Incomplete sequence)
\\subsetdot                         <char-0x02ABD>               " ⪽          : SUBSET WITH DOT
\\subsete                           \\subsete                    "            : (Incomplete sequence)
\\subseteq                          <char-0x02286>               " ⊆          : SUBSET OF OR EQUAL TO
\\subseteq<Tab>                     <char-0x02286>               " ⊆          : SUBSET OF OR EQUAL TO
\\subseteqq                         <char-0x02AC5>               " ⫅          : SUBSET OF ABOVE EQUALS SIGN
\\subsetn                           \\subsetn                    "            : (Incomplete sequence)
\\subsetne                          \\subsetne                   "            : (Incomplete sequence)
\\subsetneq                         <char-0x0228A>               " ⊊          : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO
\\subsetneq<Tab>                    <char-0x0228A>               " ⊊          : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO
\\subsetneqq                        <char-0x02ACB>               " ⫋          : SUBSET OF ABOVE NOT EQUAL TO
\\subsetp                           \\subsetp                    "            : (Incomplete sequence)
\\subsetpl                          \\subsetpl                   "            : (Incomplete sequence)
\\subsetplu                         \\subsetplu                  "            : (Incomplete sequence)
\\subsetplus                        <char-0x02ABF>               " ⪿          : SUBSET WITH PLUS SIGN BELOW
\\subsim                            <char-0x02AC7>               " ⫇          : SUBSET OF ABOVE TILDE OPERATOR
\\subsub                            <char-0x02AD5>               " ⫕          : SUBSET ABOVE SUBSET
\\subsup                            <char-0x02AD3>               " ⫓          : SUBSET ABOVE SUPERSET
\\succ                              <char-0x0227B>               " ≻          : SUCCEEDS
\\succ<Tab>                         <char-0x0227B>               " ≻          : SUCCEEDS
\\succa                             \\succa                      "            : (Incomplete sequence)
\\succap                            \\succap                     "            : (Incomplete sequence)
\\succapp                           \\succapp                    "            : (Incomplete sequence)
\\succappr                          \\succappr                   "            : (Incomplete sequence)
\\succappro                         \\succappro                  "            : (Incomplete sequence)
\\succapprox                        <char-0x02AB8>               " ⪸          : SUCCEEDS ABOVE ALMOST EQUAL TO
\\succc                             \\succc                      "            : (Incomplete sequence)
\\succcu                            \\succcu                     "            : (Incomplete sequence)
\\succcur                           \\succcur                    "            : (Incomplete sequence)
\\succcurl                          \\succcurl                   "            : (Incomplete sequence)
\\succcurly                         \\succcurly                  "            : (Incomplete sequence)
\\succcurlye                        \\succcurlye                 "            : (Incomplete sequence)
\\succcurlyeq                       <char-0x0227D>               " ≽          : SUCCEEDS OR EQUAL TO
\\succe                             \\succe                      "            : (Incomplete sequence)
\\succeq                            <char-0x02AB0>               " ⪰          : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
\\succeq<Tab>                       <char-0x02AB0>               " ⪰          : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
\\succeqq                           <char-0x02AB4>               " ⪴          : SUCCEEDS ABOVE EQUALS SIGN
\\succn                             \\succn                      "            : (Incomplete sequence)
\\succna                            \\succna                     "            : (Incomplete sequence)
\\succnap                           \\succnap                    "            : (Incomplete sequence)
\\succnapp                          \\succnapp                   "            : (Incomplete sequence)
\\succnappr                         \\succnappr                  "            : (Incomplete sequence)
\\succnappro                        \\succnappro                 "            : (Incomplete sequence)
\\succnapprox                       <char-0x02ABA>               " ⪺          : SUCCEEDS ABOVE NOT ALMOST EQUAL TO
\\succne                            \\succne                     "            : (Incomplete sequence)
\\succneq                           <char-0x02AB2>               " ⪲          : SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
\\succneq<Tab>                      <char-0x02AB2>               " ⪲          : SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
\\succneqq                          <char-0x02AB6>               " ⪶          : SUCCEEDS ABOVE NOT EQUAL TO
\\succns                            \\succns                     "            : (Incomplete sequence)
\\succnsi                           \\succnsi                    "            : (Incomplete sequence)
\\succnsim                          <char-0x022E9>               " ⋩          : SUCCEEDS BUT NOT EQUIVALENT TO
\\succs                             \\succs                      "            : (Incomplete sequence)
\\succsi                            \\succsi                     "            : (Incomplete sequence)
\\succsim                           <char-0x0227F>               " ≿          : SUCCEEDS OR EQUIVALENT TO
\\sum                               <char-0x02211>               " ∑          : N-ARY SUMMATION
\\sum<Tab>                          <char-0x02211>               " ∑          : N-ARY SUMMATION
\\sumi                              \\sumi                       "            : (Incomplete sequence)
\\sumin                             \\sumin                      "            : (Incomplete sequence)
\\sumint                            <char-0x02A0B>               " ⨋          : SUMMATION WITH INTEGRAL
\\sun                               <char-0x0263C>               " ☼          : WHITE SUN WITH RAYS
\\supdsub                           <char-0x02AD8>               " ⫘          : SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
\\supedot                           <char-0x02AC4>               " ⫄          : SUPERSET OF OR EQUAL TO WITH DOT ABOVE
\\suphsol                           <char-0x027C9>               " ⟉          : SUPERSET PRECEDING SOLIDUS
\\suphsub                           <char-0x02AD7>               " ⫗          : SUPERSET BESIDE SUBSET
\\supmult                           <char-0x02AC2>               " ⫂          : SUPERSET WITH MULTIPLICATION SIGN BELOW
\\supset                            <char-0x02283>               " ⊃          : SUPERSET OF
\\supset<Tab>                       <char-0x02283>               " ⊃          : SUPERSET OF
\\supseta                           \\supseta                    "            : (Incomplete sequence)
\\supsetap                          \\supsetap                   "            : (Incomplete sequence)
\\supsetapp                         \\supsetapp                  "            : (Incomplete sequence)
\\supsetappr                        \\supsetappr                 "            : (Incomplete sequence)
\\supsetappro                       \\supsetappro                "            : (Incomplete sequence)
\\supsetapprox                      <char-0x02ACA>               " ⫊          : SUPERSET OF ABOVE ALMOST EQUAL TO
\\supsetd                           \\supsetd                    "            : (Incomplete sequence)
\\supsetdo                          \\supsetdo                   "            : (Incomplete sequence)
\\supsetdot                         <char-0x02ABE>               " ⪾          : SUPERSET WITH DOT
\\supsete                           \\supsete                    "            : (Incomplete sequence)
\\supseteq                          <char-0x02287>               " ⊇          : SUPERSET OF OR EQUAL TO
\\supseteq<Tab>                     <char-0x02287>               " ⊇          : SUPERSET OF OR EQUAL TO
\\supseteqq                         <char-0x02AC6>               " ⫆          : SUPERSET OF ABOVE EQUALS SIGN
\\supsetn                           \\supsetn                    "            : (Incomplete sequence)
\\supsetne                          \\supsetne                   "            : (Incomplete sequence)
\\supsetneq                         <char-0x0228B>               " ⊋          : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO
\\supsetneq<Tab>                    <char-0x0228B>               " ⊋          : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO
\\supsetneqq                        <char-0x02ACC>               " ⫌          : SUPERSET OF ABOVE NOT EQUAL TO
\\supsetp                           \\supsetp                    "            : (Incomplete sequence)
\\supsetpl                          \\supsetpl                   "            : (Incomplete sequence)
\\supsetplu                         \\supsetplu                  "            : (Incomplete sequence)
\\supsetplus                        <char-0x02AC0>               " ⫀          : SUPERSET WITH PLUS SIGN BELOW
\\supsim                            <char-0x02AC8>               " ⫈          : SUPERSET OF ABOVE TILDE OPERATOR
\\supsub                            <char-0x02AD4>               " ⫔          : SUPERSET ABOVE SUBSET
\\supsup                            <char-0x02AD6>               " ⫖          : SUPERSET ABOVE SUPERSET
\\surd                              <char-0x0221A>               " √          : SQUARE ROOT
\\swarrow                           <char-0x02199>               " ↙          : SOUTH WEST ARROW / LOWER LEFT ARROW
\\tau                               <char-0x003C4>               " τ          : GREEK SMALL LETTER TAU
\\tau<Tab>                          <char-0x003C4>               " τ          : GREEK SMALL LETTER TAU
\\taur                              \\taur                       "            : (Incomplete sequence)
\\tauru                             \\tauru                      "            : (Incomplete sequence)
\\taurus                            <char-0x02649>               " ♉          : TAURUS
\\tdcol                             <char-0x02AF6>               " ⫶          : TRIPLE COLON OPERATOR
\\tesh                              <char-0x002A7>               " ʧ          : LATIN SMALL LETTER TESH DIGRAPH / LATIN SMALL LETTER T ESH
\\th                                <char-0x000FE>               " þ          : LATIN SMALL LETTER THORN
\\th<Tab>                           <char-0x000FE>               " þ          : LATIN SMALL LETTER THORN
\\the                               \\the                        "            : (Incomplete sequence)
\\ther                              \\ther                       "            : (Incomplete sequence)
\\there                             \\there                      "            : (Incomplete sequence)
\\theref                            \\theref                     "            : (Incomplete sequence)
\\therefo                           \\therefo                    "            : (Incomplete sequence)
\\therefor                          \\therefor                   "            : (Incomplete sequence)
\\therefore                         <char-0x02234>               " ∴          : THEREFORE
\\thet                              \\thet                       "            : (Incomplete sequence)
\\theta                             <char-0x003B8>               " θ          : GREEK SMALL LETTER THETA
\\thi                               \\thi                        "            : (Incomplete sequence)
\\thic                              \\thic                       "            : (Incomplete sequence)
\\thick                             \\thick                      "            : (Incomplete sequence)
\\thicks                            \\thicks                     "            : (Incomplete sequence)
\\thicksp                           \\thicksp                    "            : (Incomplete sequence)
\\thickspa                          \\thickspa                   "            : (Incomplete sequence)
\\thickspac                         \\thickspac                  "            : (Incomplete sequence)
\\thickspace                        <char-0x02005>               "            : FOUR-PER-EM SPACE
\\thin                              \\thin                       "            : (Incomplete sequence)
\\thins                             \\thins                      "            : (Incomplete sequence)
\\thinsp                            \\thinsp                     "            : (Incomplete sequence)
\\thinspa                           \\thinspa                    "            : (Incomplete sequence)
\\thinspac                          \\thinspac                   "            : (Incomplete sequence)
\\thinspace                         <char-0x02009>               "            : THIN SPACE
\\thr                               \\thr                        "            : (Incomplete sequence)
\\thre                              \\thre                       "            : (Incomplete sequence)
\\three                             \\three                      "            : (Incomplete sequence)
\\threed                            \\threed                     "            : (Incomplete sequence)
\\threeda                           \\threeda                    "            : (Incomplete sequence)
\\threedan                          \\threedan                   "            : (Incomplete sequence)
\\threedang                         \\threedang                  "            : (Incomplete sequence)
\\threedangl                        \\threedangl                 "            : (Incomplete sequence)
\\threedangle                       <char-0x027C0>               " ⟀          : THREE DIMENSIONAL ANGLE
\\threeu                            \\threeu                     "            : (Incomplete sequence)
\\threeun                           \\threeun                    "            : (Incomplete sequence)
\\threeund                          \\threeund                   "            : (Incomplete sequence)
\\threeunde                         \\threeunde                  "            : (Incomplete sequence)
\\threeunder                        \\threeunder                 "            : (Incomplete sequence)
\\threeunderd                       \\threeunderd                "            : (Incomplete sequence)
\\threeunderdo                      \\threeunderdo               "            : (Incomplete sequence)
\\threeunderdot                     <char-0x020E8>               " ◌⃨         : COMBINING TRIPLE UNDERDOT
\\tieconcat                         <char-0x02040>               " ⁀          : CHARACTER TIE
\\tilde                             <char-0x00303>               " ◌̃         : COMBINING TILDE / NON-SPACING TILDE
\\tilde<Tab>                        <char-0x00303>               " ◌̃         : COMBINING TILDE / NON-SPACING TILDE
\\tildel                            \\tildel                     "            : (Incomplete sequence)
\\tildelo                           \\tildelo                    "            : (Incomplete sequence)
\\tildelow                          <char-0x002DC>               " ˜          : SMALL TILDE / SPACING TILDE
\\tildet                            \\tildet                     "            : (Incomplete sequence)
\\tildetr                           \\tildetr                    "            : (Incomplete sequence)
\\tildetrp                          \\tildetrp                   "            : (Incomplete sequence)
\\tildetrpl                         <char-0x0224B>               " ≋          : TRIPLE TILDE
\\times                             <char-0x000D7>               " ×          : MULTIPLICATION SIGN
\\times<Tab>                        <char-0x000D7>               " ×          : MULTIPLICATION SIGN
\\timesb                            \\timesb                     "            : (Incomplete sequence)
\\timesba                           \\timesba                    "            : (Incomplete sequence)
\\timesbar                          <char-0x02A31>               " ⨱          : MULTIPLICATION SIGN WITH UNDERBAR
\\to                                <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\to<Tab>                           <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\toe                               \\toe                        "            : (Incomplete sequence)
\\toea                              <char-0x02928>               " ⤨          : NORTH EAST ARROW AND SOUTH EAST ARROW
\\ton                               \\ton                        "            : (Incomplete sequence)
\\tona                              <char-0x02927>               " ⤧          : NORTH WEST ARROW AND NORTH EAST ARROW
\\top                               <char-0x022A4>               " ⊤          : DOWN TACK
\\top<Tab>                          <char-0x022A4>               " ⊤          : DOWN TACK
\\topb                              \\topb                       "            : (Incomplete sequence)
\\topbo                             \\topbo                      "            : (Incomplete sequence)
\\topbot                            <char-0x02336>               " ⌶          : APL FUNCTIONAL SYMBOL I-BEAM
\\tops                              \\tops                       "            : (Incomplete sequence)
\\topse                             \\topse                      "            : (Incomplete sequence)
\\topsem                            \\topsem                     "            : (Incomplete sequence)
\\topsemi                           \\topsemi                    "            : (Incomplete sequence)
\\topsemic                          \\topsemic                   "            : (Incomplete sequence)
\\topsemici                         \\topsemici                  "            : (Incomplete sequence)
\\topsemicir                        \\topsemicir                 "            : (Incomplete sequence)
\\topsemicirc                       \\topsemicirc                "            : (Incomplete sequence)
\\topsemicircl                      \\topsemicircl               "            : (Incomplete sequence)
\\topsemicircle                     <char-0x025E0>               " ◠          : UPPER HALF CIRCLE
\\tos                               \\tos                        "            : (Incomplete sequence)
\\tosa                              <char-0x02929>               " ⤩          : SOUTH EAST ARROW AND SOUTH WEST ARROW
\\tow                               \\tow                        "            : (Incomplete sequence)
\\towa                              <char-0x0292A>               " ⤪          : SOUTH WEST ARROW AND NORTH WEST ARROW
\\trademark                         <char-0x02122>               " ™          : TRADE MARK SIGN / TRADEMARK
\\trapezium                         <char-0x023E2>               " ⏢          : WHITE TRAPEZIUM
\\trianglecdot                      <char-0x025EC>               " ◬          : WHITE UP-POINTING TRIANGLE WITH DOT / WHITE UP POINTING TRIANGLE WITH DOT
\\triangledown                      <char-0x025BF>               " ▿          : WHITE DOWN-POINTING SMALL TRIANGLE / WHITE DOWN POINTING SMALL TRIANGLE
\\triangleleft                      <char-0x025C1>               " ◁          : WHITE LEFT-POINTING TRIANGLE / WHITE LEFT POINTING TRIANGLE
\\triangleleft<Tab>                 <char-0x025C1>               " ◁          : WHITE LEFT-POINTING TRIANGLE / WHITE LEFT POINTING TRIANGLE
\\triangleleftb                     \\triangleleftb              "            : (Incomplete sequence)
\\triangleleftbl                    \\triangleleftbl             "            : (Incomplete sequence)
\\triangleleftbla                   \\triangleleftbla            "            : (Incomplete sequence)
\\triangleleftblac                  \\triangleleftblac           "            : (Incomplete sequence)
\\triangleleftblack                 <char-0x025ED>               " ◭          : UP-POINTING TRIANGLE WITH LEFT HALF BLACK / UP POINTING TRIANGLE WITH LEFT HALF BLACK
\\trianglelefte                     \\trianglelefte              "            : (Incomplete sequence)
\\trianglelefteq                    <char-0x022B4>               " ⊴          : NORMAL SUBGROUP OF OR EQUAL TO
\\triangleminus                     <char-0x02A3A>               " ⨺          : MINUS SIGN IN TRIANGLE
\\triangleplus                      <char-0x02A39>               " ⨹          : PLUS SIGN IN TRIANGLE
\\triangleq                         <char-0x0225C>               " ≜          : DELTA EQUAL TO
\\triangleright                     <char-0x025B7>               " ▷          : WHITE RIGHT-POINTING TRIANGLE / WHITE RIGHT POINTING TRIANGLE
\\triangleright<Tab>                <char-0x025B7>               " ▷          : WHITE RIGHT-POINTING TRIANGLE / WHITE RIGHT POINTING TRIANGLE
\\trianglerightb                    \\trianglerightb             "            : (Incomplete sequence)
\\trianglerightbl                   \\trianglerightbl            "            : (Incomplete sequence)
\\trianglerightbla                  \\trianglerightbla           "            : (Incomplete sequence)
\\trianglerightblac                 \\trianglerightblac          "            : (Incomplete sequence)
\\trianglerightblack                <char-0x025EE>               " ◮          : UP-POINTING TRIANGLE WITH RIGHT HALF BLACK / UP POINTING TRIANGLE WITH RIGHT HALF BLACK
\\trianglerighte                    \\trianglerighte             "            : (Incomplete sequence)
\\trianglerighteq                   <char-0x022B5>               " ⊵          : CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
\\triangletimes                     <char-0x02A3B>               " ⨻          : MULTIPLICATION SIGN IN TRIANGLE
\\tricolon                          <char-0x0205D>               " ⁝          : TRICOLON
\\tripleplus                        <char-0x029FB>               " ⧻          : TRIPLE PLUS
\\trna                              <char-0x00250>               " ɐ          : LATIN SMALL LETTER TURNED A
\\trnh                              <char-0x00265>               " ɥ          : LATIN SMALL LETTER TURNED H
\\trnm                              <char-0x0026F>               " ɯ          : LATIN SMALL LETTER TURNED M
\\trnm<Tab>                         <char-0x0026F>               " ɯ          : LATIN SMALL LETTER TURNED M
\\trnml                             \\trnml                      "            : (Incomplete sequence)
\\trnmlr                            <char-0x00270>               " ɰ          : LATIN SMALL LETTER TURNED M WITH LONG LEG
\\trnr                              <char-0x00279>               " ɹ          : LATIN SMALL LETTER TURNED R
\\trnr<Tab>                         <char-0x00279>               " ɹ          : LATIN SMALL LETTER TURNED R
\\trnrl                             <char-0x0027A>               " ɺ          : LATIN SMALL LETTER TURNED R WITH LONG LEG
\\trnsa                             <char-0x00252>               " ɒ          : LATIN SMALL LETTER TURNED ALPHA / LATIN SMALL LETTER TURNED SCRIPT A
\\trnt                              <char-0x00287>               " ʇ          : LATIN SMALL LETTER TURNED T
\\trny                              <char-0x0028E>               " ʎ          : LATIN SMALL LETTER TURNED Y
\\ttA                               <char-0x1D670>               " 𝙰          : MATHEMATICAL MONOSPACE CAPITAL A
\\ttB                               <char-0x1D671>               " 𝙱          : MATHEMATICAL MONOSPACE CAPITAL B
\\ttC                               <char-0x1D672>               " 𝙲          : MATHEMATICAL MONOSPACE CAPITAL C
\\ttD                               <char-0x1D673>               " 𝙳          : MATHEMATICAL MONOSPACE CAPITAL D
\\ttE                               <char-0x1D674>               " 𝙴          : MATHEMATICAL MONOSPACE CAPITAL E
\\ttF                               <char-0x1D675>               " 𝙵          : MATHEMATICAL MONOSPACE CAPITAL F
\\ttG                               <char-0x1D676>               " 𝙶          : MATHEMATICAL MONOSPACE CAPITAL G
\\ttH                               <char-0x1D677>               " 𝙷          : MATHEMATICAL MONOSPACE CAPITAL H
\\ttI                               <char-0x1D678>               " 𝙸          : MATHEMATICAL MONOSPACE CAPITAL I
\\ttJ                               <char-0x1D679>               " 𝙹          : MATHEMATICAL MONOSPACE CAPITAL J
\\ttK                               <char-0x1D67A>               " 𝙺          : MATHEMATICAL MONOSPACE CAPITAL K
\\ttL                               <char-0x1D67B>               " 𝙻          : MATHEMATICAL MONOSPACE CAPITAL L
\\ttM                               <char-0x1D67C>               " 𝙼          : MATHEMATICAL MONOSPACE CAPITAL M
\\ttN                               <char-0x1D67D>               " 𝙽          : MATHEMATICAL MONOSPACE CAPITAL N
\\ttO                               <char-0x1D67E>               " 𝙾          : MATHEMATICAL MONOSPACE CAPITAL O
\\ttP                               <char-0x1D67F>               " 𝙿          : MATHEMATICAL MONOSPACE CAPITAL P
\\ttQ                               <char-0x1D680>               " 𝚀          : MATHEMATICAL MONOSPACE CAPITAL Q
\\ttR                               <char-0x1D681>               " 𝚁          : MATHEMATICAL MONOSPACE CAPITAL R
\\ttS                               <char-0x1D682>               " 𝚂          : MATHEMATICAL MONOSPACE CAPITAL S
\\ttT                               <char-0x1D683>               " 𝚃          : MATHEMATICAL MONOSPACE CAPITAL T
\\ttU                               <char-0x1D684>               " 𝚄          : MATHEMATICAL MONOSPACE CAPITAL U
\\ttV                               <char-0x1D685>               " 𝚅          : MATHEMATICAL MONOSPACE CAPITAL V
\\ttW                               <char-0x1D686>               " 𝚆          : MATHEMATICAL MONOSPACE CAPITAL W
\\ttX                               <char-0x1D687>               " 𝚇          : MATHEMATICAL MONOSPACE CAPITAL X
\\ttY                               <char-0x1D688>               " 𝚈          : MATHEMATICAL MONOSPACE CAPITAL Y
\\ttZ                               <char-0x1D689>               " 𝚉          : MATHEMATICAL MONOSPACE CAPITAL Z
\\tta                               <char-0x1D68A>               " 𝚊          : MATHEMATICAL MONOSPACE SMALL A
\\ttb                               <char-0x1D68B>               " 𝚋          : MATHEMATICAL MONOSPACE SMALL B
\\ttc                               <char-0x1D68C>               " 𝚌          : MATHEMATICAL MONOSPACE SMALL C
\\ttd                               <char-0x1D68D>               " 𝚍          : MATHEMATICAL MONOSPACE SMALL D
\\tte                               <char-0x1D68E>               " 𝚎          : MATHEMATICAL MONOSPACE SMALL E
\\tte<Tab>                          <char-0x1D68E>               " 𝚎          : MATHEMATICAL MONOSPACE SMALL E
\\ttei                              \\ttei                       "            : (Incomplete sequence)
\\tteig                             \\tteig                      "            : (Incomplete sequence)
\\tteigh                            \\tteigh                     "            : (Incomplete sequence)
\\tteight                           <char-0x1D7FE>               " 𝟾          : MATHEMATICAL MONOSPACE DIGIT EIGHT
\\ttf                               <char-0x1D68F>               " 𝚏          : MATHEMATICAL MONOSPACE SMALL F
\\ttf<Tab>                          <char-0x1D68F>               " 𝚏          : MATHEMATICAL MONOSPACE SMALL F
\\ttfi                              \\ttfi                       "            : (Incomplete sequence)
\\ttfiv                             \\ttfiv                      "            : (Incomplete sequence)
\\ttfive                            <char-0x1D7FB>               " 𝟻          : MATHEMATICAL MONOSPACE DIGIT FIVE
\\ttfo                              \\ttfo                       "            : (Incomplete sequence)
\\ttfou                             \\ttfou                      "            : (Incomplete sequence)
\\ttfour                            <char-0x1D7FA>               " 𝟺          : MATHEMATICAL MONOSPACE DIGIT FOUR
\\ttg                               <char-0x1D690>               " 𝚐          : MATHEMATICAL MONOSPACE SMALL G
\\tth                               <char-0x1D691>               " 𝚑          : MATHEMATICAL MONOSPACE SMALL H
\\tti                               <char-0x1D692>               " 𝚒          : MATHEMATICAL MONOSPACE SMALL I
\\ttj                               <char-0x1D693>               " 𝚓          : MATHEMATICAL MONOSPACE SMALL J
\\ttk                               <char-0x1D694>               " 𝚔          : MATHEMATICAL MONOSPACE SMALL K
\\ttl                               <char-0x1D695>               " 𝚕          : MATHEMATICAL MONOSPACE SMALL L
\\ttm                               <char-0x1D696>               " 𝚖          : MATHEMATICAL MONOSPACE SMALL M
\\ttn                               <char-0x1D697>               " 𝚗          : MATHEMATICAL MONOSPACE SMALL N
\\ttn<Tab>                          <char-0x1D697>               " 𝚗          : MATHEMATICAL MONOSPACE SMALL N
\\ttni                              \\ttni                       "            : (Incomplete sequence)
\\ttnin                             \\ttnin                      "            : (Incomplete sequence)
\\ttnine                            <char-0x1D7FF>               " 𝟿          : MATHEMATICAL MONOSPACE DIGIT NINE
\\tto                               <char-0x1D698>               " 𝚘          : MATHEMATICAL MONOSPACE SMALL O
\\tto<Tab>                          <char-0x1D698>               " 𝚘          : MATHEMATICAL MONOSPACE SMALL O
\\tton                              \\tton                       "            : (Incomplete sequence)
\\ttone                             <char-0x1D7F7>               " 𝟷          : MATHEMATICAL MONOSPACE DIGIT ONE
\\ttp                               <char-0x1D699>               " 𝚙          : MATHEMATICAL MONOSPACE SMALL P
\\ttq                               <char-0x1D69A>               " 𝚚          : MATHEMATICAL MONOSPACE SMALL Q
\\ttr                               <char-0x1D69B>               " 𝚛          : MATHEMATICAL MONOSPACE SMALL R
\\tts                               <char-0x1D69C>               " 𝚜          : MATHEMATICAL MONOSPACE SMALL S
\\tts<Tab>                          <char-0x1D69C>               " 𝚜          : MATHEMATICAL MONOSPACE SMALL S
\\ttse                              \\ttse                       "            : (Incomplete sequence)
\\ttsev                             \\ttsev                      "            : (Incomplete sequence)
\\ttseve                            \\ttseve                     "            : (Incomplete sequence)
\\ttseven                           <char-0x1D7FD>               " 𝟽          : MATHEMATICAL MONOSPACE DIGIT SEVEN
\\ttsi                              \\ttsi                       "            : (Incomplete sequence)
\\ttsix                             <char-0x1D7FC>               " 𝟼          : MATHEMATICAL MONOSPACE DIGIT SIX
\\ttt                               <char-0x1D69D>               " 𝚝          : MATHEMATICAL MONOSPACE SMALL T
\\ttt<Tab>                          <char-0x1D69D>               " 𝚝          : MATHEMATICAL MONOSPACE SMALL T
\\ttth                              \\ttth                       "            : (Incomplete sequence)
\\ttthr                             \\ttthr                      "            : (Incomplete sequence)
\\ttthre                            \\ttthre                     "            : (Incomplete sequence)
\\ttthree                           <char-0x1D7F9>               " 𝟹          : MATHEMATICAL MONOSPACE DIGIT THREE
\\tttw                              \\tttw                       "            : (Incomplete sequence)
\\tttwo                             <char-0x1D7F8>               " 𝟸          : MATHEMATICAL MONOSPACE DIGIT TWO
\\ttu                               <char-0x1D69E>               " 𝚞          : MATHEMATICAL MONOSPACE SMALL U
\\ttv                               <char-0x1D69F>               " 𝚟          : MATHEMATICAL MONOSPACE SMALL V
\\ttw                               <char-0x1D6A0>               " 𝚠          : MATHEMATICAL MONOSPACE SMALL W
\\ttx                               <char-0x1D6A1>               " 𝚡          : MATHEMATICAL MONOSPACE SMALL X
\\tty                               <char-0x1D6A2>               " 𝚢          : MATHEMATICAL MONOSPACE SMALL Y
\\ttz                               <char-0x1D6A3>               " 𝚣          : MATHEMATICAL MONOSPACE SMALL Z
\\ttz<Tab>                          <char-0x1D6A3>               " 𝚣          : MATHEMATICAL MONOSPACE SMALL Z
\\ttze                              \\ttze                       "            : (Incomplete sequence)
\\ttzer                             \\ttzer                      "            : (Incomplete sequence)
\\ttzero                            <char-0x1D7F6>               " 𝟶          : MATHEMATICAL MONOSPACE DIGIT ZERO
\\turnangle                         <char-0x029A2>               " ⦢          : TURNED ANGLE
\\turnediota                        <char-0x02129>               " ℩          : TURNED GREEK SMALL LETTER IOTA
\\turnednot                         <char-0x02319>               " ⌙          : TURNED NOT SIGN
\\turnk                             <char-0x0029E>               " ʞ          : LATIN SMALL LETTER TURNED K
\\twocaps                           <char-0x02A4B>               " ⩋          : INTERSECTION BESIDE AND JOINED WITH INTERSECTION
\\twocups                           <char-0x02A4A>               " ⩊          : UNION BESIDE AND JOINED WITH UNION
\\twoheaddownarrow                  <char-0x021A1>               " ↡          : DOWNWARDS TWO HEADED ARROW / DOWN TWO HEADED ARROW
\\twoheadleftarrow                  <char-0x0219E>               " ↞          : LEFTWARDS TWO HEADED ARROW / LEFT TWO HEADED ARROW
\\twoheadleftarrow<Tab>             <char-0x0219E>               " ↞          : LEFTWARDS TWO HEADED ARROW / LEFT TWO HEADED ARROW
\\twoheadleftarrowt                 \\twoheadleftarrowt          "            : (Incomplete sequence)
\\twoheadleftarrowta                \\twoheadleftarrowta         "            : (Incomplete sequence)
\\twoheadleftarrowtai               \\twoheadleftarrowtai        "            : (Incomplete sequence)
\\twoheadleftarrowtail              <char-0x02B3B>               " ⬻          : LEFTWARDS TWO-HEADED ARROW WITH TAIL
\\twoheadleftdbkarrow               <char-0x02B37>               " ⬷          : LEFTWARDS TWO-HEADED TRIPLE DASH ARROW
\\twoheadmapsfrom                   <char-0x02B36>               " ⬶          : LEFTWARDS TWO-HEADED ARROW FROM BAR
\\twoheadmapsto                     <char-0x02905>               " ⤅          : RIGHTWARDS TWO-HEADED ARROW FROM BAR
\\twoheadrightarrow                 <char-0x021A0>               " ↠          : RIGHTWARDS TWO HEADED ARROW / RIGHT TWO HEADED ARROW
\\twoheadrightarrow<Tab>            <char-0x021A0>               " ↠          : RIGHTWARDS TWO HEADED ARROW / RIGHT TWO HEADED ARROW
\\twoheadrightarrowt                \\twoheadrightarrowt         "            : (Incomplete sequence)
\\twoheadrightarrowta               \\twoheadrightarrowta        "            : (Incomplete sequence)
\\twoheadrightarrowtai              \\twoheadrightarrowtai       "            : (Incomplete sequence)
\\twoheadrightarrowtail             <char-0x02916>               " ⤖          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL
\\twoheaduparrow                    <char-0x0219F>               " ↟          : UPWARDS TWO HEADED ARROW / UP TWO HEADED ARROW
\\twoheaduparrow<Tab>               <char-0x0219F>               " ↟          : UPWARDS TWO HEADED ARROW / UP TWO HEADED ARROW
\\twoheaduparrowc                   \\twoheaduparrowc            "            : (Incomplete sequence)
\\twoheaduparrowci                  \\twoheaduparrowci           "            : (Incomplete sequence)
\\twoheaduparrowcir                 \\twoheaduparrowcir          "            : (Incomplete sequence)
\\twoheaduparrowcirc                \\twoheaduparrowcirc         "            : (Incomplete sequence)
\\twoheaduparrowcircl               \\twoheaduparrowcircl        "            : (Incomplete sequence)
\\twoheaduparrowcircle              <char-0x02949>               " ⥉          : UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
\\twonotes                          <char-0x0266B>               " ♫          : BEAMED EIGHTH NOTES / BARRED EIGHTH NOTES
\\u                                 <char-0x002D8>               " ˘          : BREVE / SPACING BREVE
\\u<Tab>                            <char-0x002D8>               " ˘          : BREVE / SPACING BREVE
\\ul                                \\ul                         "            : (Incomplete sequence)
\\ula                               \\ula                        "            : (Incomplete sequence)
\\ular                              \\ular                       "            : (Incomplete sequence)
\\ularc                             <char-0x025DC>               " ◜          : UPPER LEFT QUADRANT CIRCULAR ARC
\\ulb                               \\ulb                        "            : (Incomplete sequence)
\\ulbl                              \\ulbl                       "            : (Incomplete sequence)
\\ulbla                             \\ulbla                      "            : (Incomplete sequence)
\\ulblac                            \\ulblac                     "            : (Incomplete sequence)
\\ulblack                           \\ulblack                    "            : (Incomplete sequence)
\\ulblackt                          \\ulblackt                   "            : (Incomplete sequence)
\\ulblacktr                         \\ulblacktr                  "            : (Incomplete sequence)
\\ulblacktri                        \\ulblacktri                 "            : (Incomplete sequence)
\\ulblacktria                       \\ulblacktria                "            : (Incomplete sequence)
\\ulblacktrian                      \\ulblacktrian               "            : (Incomplete sequence)
\\ulblacktriang                     \\ulblacktriang              "            : (Incomplete sequence)
\\ulblacktriangl                    \\ulblacktriangl             "            : (Incomplete sequence)
\\ulblacktriangle                   <char-0x025E4>               " ◤          : BLACK UPPER LEFT TRIANGLE
\\ulc                               \\ulc                        "            : (Incomplete sequence)
\\ulco                              \\ulco                       "            : (Incomplete sequence)
\\ulcor                             \\ulcor                      "            : (Incomplete sequence)
\\ulcorn                            \\ulcorn                     "            : (Incomplete sequence)
\\ulcorne                           \\ulcorne                    "            : (Incomplete sequence)
\\ulcorner                          <char-0x0231C>               " ⌜          : TOP LEFT CORNER
\\ult                               \\ult                        "            : (Incomplete sequence)
\\ultr                              \\ultr                       "            : (Incomplete sequence)
\\ultri                             \\ultri                      "            : (Incomplete sequence)
\\ultria                            \\ultria                     "            : (Incomplete sequence)
\\ultrian                           \\ultrian                    "            : (Incomplete sequence)
\\ultriang                          \\ultriang                   "            : (Incomplete sequence)
\\ultriangl                         \\ultriangl                  "            : (Incomplete sequence)
\\ultriangle                        <char-0x025F8>               " ◸          : UPPER LEFT TRIANGLE
\\um                                \\um                         "            : (Incomplete sequence)
\\umi                               \\umi                        "            : (Incomplete sequence)
\\umin                              \\umin                       "            : (Incomplete sequence)
\\uminu                             \\uminu                      "            : (Incomplete sequence)
\\uminus                            <char-0x02A41>               " ⩁          : UNION WITH MINUS SIGN
\\un                                \\un                         "            : (Incomplete sequence)
\\und                               \\und                        "            : (Incomplete sequence)
\\unde                              \\unde                       "            : (Incomplete sequence)
\\under                             \\under                      "            : (Incomplete sequence)
\\underb                            \\underb                     "            : (Incomplete sequence)
\\underba                           \\underba                    "            : (Incomplete sequence)
\\underbar                          <char-0x00332>               " ◌̲         : COMBINING LOW LINE / NON-SPACING UNDERSCORE
\\underbr                           \\underbr                    "            : (Incomplete sequence)
\\underbra                          \\underbra                   "            : (Incomplete sequence)
\\underbrac                         \\underbrac                  "            : (Incomplete sequence)
\\underbrace                        <char-0x023DF>               " ⏟          : BOTTOM CURLY BRACKET
\\underbrack                        \\underbrack                 "            : (Incomplete sequence)
\\underbracke                       \\underbracke                "            : (Incomplete sequence)
\\underbracket                      <char-0x023B5>               " ⎵          : BOTTOM SQUARE BRACKET
\\underl                            \\underl                     "            : (Incomplete sequence)
\\underle                           \\underle                    "            : (Incomplete sequence)
\\underlef                          \\underlef                   "            : (Incomplete sequence)
\\underleft                         \\underleft                  "            : (Incomplete sequence)
\\underlefta                        \\underlefta                 "            : (Incomplete sequence)
\\underleftar                       \\underleftar                "            : (Incomplete sequence)
\\underleftarr                      \\underleftarr               "            : (Incomplete sequence)
\\underleftarro                     \\underleftarro              "            : (Incomplete sequence)
\\underleftarrow                    <char-0x020EE>               " ◌⃮         : COMBINING LEFT ARROW BELOW
\\underlefth                        \\underlefth                 "            : (Incomplete sequence)
\\underleftha                       \\underleftha                "            : (Incomplete sequence)
\\underlefthar                      \\underlefthar               "            : (Incomplete sequence)
\\underleftharp                     \\underleftharp              "            : (Incomplete sequence)
\\underleftharpo                    \\underleftharpo             "            : (Incomplete sequence)
\\underleftharpoo                   \\underleftharpoo            "            : (Incomplete sequence)
\\underleftharpoon                  \\underleftharpoon           "            : (Incomplete sequence)
\\underleftharpoond                 \\underleftharpoond          "            : (Incomplete sequence)
\\underleftharpoondo                \\underleftharpoondo         "            : (Incomplete sequence)
\\underleftharpoondow               \\underleftharpoondow        "            : (Incomplete sequence)
\\underleftharpoondown              <char-0x020ED>               " ◌⃭         : COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS
\\underleftr                        \\underleftr                 "            : (Incomplete sequence)
\\underleftri                       \\underleftri                "            : (Incomplete sequence)
\\underleftrig                      \\underleftrig               "            : (Incomplete sequence)
\\underleftrigh                     \\underleftrigh              "            : (Incomplete sequence)
\\underleftright                    \\underleftright             "            : (Incomplete sequence)
\\underleftrighta                   \\underleftrighta            "            : (Incomplete sequence)
\\underleftrightar                  \\underleftrightar           "            : (Incomplete sequence)
\\underleftrightarr                 \\underleftrightarr          "            : (Incomplete sequence)
\\underleftrightarro                \\underleftrightarro         "            : (Incomplete sequence)
\\underleftrightarrow               <char-0x0034D>               " ◌͍         : COMBINING LEFT RIGHT ARROW BELOW
\\underr                            \\underr                     "            : (Incomplete sequence)
\\underri                           \\underri                    "            : (Incomplete sequence)
\\underrig                          \\underrig                   "            : (Incomplete sequence)
\\underrigh                         \\underrigh                  "            : (Incomplete sequence)
\\underright                        \\underright                 "            : (Incomplete sequence)
\\underrighta                       \\underrighta                "            : (Incomplete sequence)
\\underrightar                      \\underrightar               "            : (Incomplete sequence)
\\underrightarr                     \\underrightarr              "            : (Incomplete sequence)
\\underrightarro                    \\underrightarro             "            : (Incomplete sequence)
\\underrightarrow                   <char-0x020EF>               " ◌⃯         : COMBINING RIGHT ARROW BELOW
\\underrighth                       \\underrighth                "            : (Incomplete sequence)
\\underrightha                      \\underrightha               "            : (Incomplete sequence)
\\underrighthar                     \\underrighthar              "            : (Incomplete sequence)
\\underrightharp                    \\underrightharp             "            : (Incomplete sequence)
\\underrightharpo                   \\underrightharpo            "            : (Incomplete sequence)
\\underrightharpoo                  \\underrightharpoo           "            : (Incomplete sequence)
\\underrightharpoon                 \\underrightharpoon          "            : (Incomplete sequence)
\\underrightharpoond                \\underrightharpoond         "            : (Incomplete sequence)
\\underrightharpoondo               \\underrightharpoondo        "            : (Incomplete sequence)
\\underrightharpoondow              \\underrightharpoondow       "            : (Incomplete sequence)
\\underrightharpoondown             <char-0x020EC>               " ◌⃬         : COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS
\\up                                \\up                         "            : (Incomplete sequence)
\\upM                               \\upM                        "            : (Incomplete sequence)
\\upMu                              <char-0x0039C>               " Μ          : GREEK CAPITAL LETTER MU
\\upN                               \\upN                        "            : (Incomplete sequence)
\\upNu                              <char-0x0039D>               " Ν          : GREEK CAPITAL LETTER NU
\\upO                               \\upO                        "            : (Incomplete sequence)
\\upOm                              \\upOm                       "            : (Incomplete sequence)
\\upOmi                             \\upOmi                      "            : (Incomplete sequence)
\\upOmic                            \\upOmic                     "            : (Incomplete sequence)
\\upOmicr                           \\upOmicr                    "            : (Incomplete sequence)
\\upOmicro                          \\upOmicro                   "            : (Incomplete sequence)
\\upOmicron                         <char-0x0039F>               " Ο          : GREEK CAPITAL LETTER OMICRON
\\upa                               \\upa                        "            : (Incomplete sequence)
\\upan                              \\upan                       "            : (Incomplete sequence)
\\upand                             <char-0x0214B>               " ⅋          : TURNED AMPERSAND
\\upar                              \\upar                       "            : (Incomplete sequence)
\\uparr                             \\uparr                      "            : (Incomplete sequence)
\\uparro                            \\uparro                     "            : (Incomplete sequence)
\\uparrow                           <char-0x02191>               " ↑          : UPWARDS ARROW / UP ARROW
\\uparrow<Tab>                      <char-0x02191>               " ↑          : UPWARDS ARROW / UP ARROW
\\uparrowb                          \\uparrowb                   "            : (Incomplete sequence)
\\uparrowba                         \\uparrowba                  "            : (Incomplete sequence)
\\uparrowbar                        \\uparrowbar                 "            : (Incomplete sequence)
\\uparrowbarr                       \\uparrowbarr                "            : (Incomplete sequence)
\\uparrowbarre                      \\uparrowbarre               "            : (Incomplete sequence)
\\uparrowbarred                     <char-0x02909>               " ⤉          : UPWARDS ARROW WITH HORIZONTAL STROKE
\\upd                               \\upd                        "            : (Incomplete sequence)
\\upda                              \\upda                       "            : (Incomplete sequence)
\\updas                             \\updas                      "            : (Incomplete sequence)
\\updash                            \\updash                     "            : (Incomplete sequence)
\\updasha                           \\updasha                    "            : (Incomplete sequence)
\\updashar                          \\updashar                   "            : (Incomplete sequence)
\\updasharr                         \\updasharr                  "            : (Incomplete sequence)
\\updasharro                        \\updasharro                 "            : (Incomplete sequence)
\\updasharrow                       <char-0x021E1>               " ⇡          : UPWARDS DASHED ARROW / UP DASHED ARROW
\\updo                              \\updo                       "            : (Incomplete sequence)
\\updow                             \\updow                      "            : (Incomplete sequence)
\\updown                            \\updown                     "            : (Incomplete sequence)
\\updowna                           \\updowna                    "            : (Incomplete sequence)
\\updownar                          \\updownar                   "            : (Incomplete sequence)
\\updownarr                         \\updownarr                  "            : (Incomplete sequence)
\\updownarro                        \\updownarro                 "            : (Incomplete sequence)
\\updownarrow                       <char-0x02195>               " ↕          : UP DOWN ARROW
\\updownarrow<Tab>                  <char-0x02195>               " ↕          : UP DOWN ARROW
\\updownarrowb                      \\updownarrowb               "            : (Incomplete sequence)
\\updownarrowba                     \\updownarrowba              "            : (Incomplete sequence)
\\updownarrowbar                    <char-0x021A8>               " ↨          : UP DOWN ARROW WITH BASE
\\updownh                           \\updownh                    "            : (Incomplete sequence)
\\updownha                          \\updownha                   "            : (Incomplete sequence)
\\updownhar                         \\updownhar                  "            : (Incomplete sequence)
\\updownharp                        \\updownharp                 "            : (Incomplete sequence)
\\updownharpo                       \\updownharpo                "            : (Incomplete sequence)
\\updownharpoo                      \\updownharpoo               "            : (Incomplete sequence)
\\updownharpoon                     \\updownharpoon              "            : (Incomplete sequence)
\\updownharpoonl                    \\updownharpoonl             "            : (Incomplete sequence)
\\updownharpoonle                   \\updownharpoonle            "            : (Incomplete sequence)
\\updownharpoonlef                  \\updownharpoonlef           "            : (Incomplete sequence)
\\updownharpoonleft                 \\updownharpoonleft          "            : (Incomplete sequence)
\\updownharpoonleftr                \\updownharpoonleftr         "            : (Incomplete sequence)
\\updownharpoonleftri               \\updownharpoonleftri        "            : (Incomplete sequence)
\\updownharpoonleftrig              \\updownharpoonleftrig       "            : (Incomplete sequence)
\\updownharpoonleftrigh             \\updownharpoonleftrigh      "            : (Incomplete sequence)
\\updownharpoonleftright            <char-0x0294D>               " ⥍          : UP BARB LEFT DOWN BARB RIGHT HARPOON
\\updownharpoonr                    \\updownharpoonr             "            : (Incomplete sequence)
\\updownharpoonri                   \\updownharpoonri            "            : (Incomplete sequence)
\\updownharpoonrig                  \\updownharpoonrig           "            : (Incomplete sequence)
\\updownharpoonrigh                 \\updownharpoonrigh          "            : (Incomplete sequence)
\\updownharpoonright                \\updownharpoonright         "            : (Incomplete sequence)
\\updownharpoonrightl               \\updownharpoonrightl        "            : (Incomplete sequence)
\\updownharpoonrightle              \\updownharpoonrightle       "            : (Incomplete sequence)
\\updownharpoonrightlef             \\updownharpoonrightlef      "            : (Incomplete sequence)
\\updownharpoonrightleft            <char-0x0294C>               " ⥌          : UP BARB RIGHT DOWN BARB LEFT HARPOON
\\upe                               \\upe                        "            : (Incomplete sequence)
\\upep                              \\upep                       "            : (Incomplete sequence)
\\upeps                             \\upeps                      "            : (Incomplete sequence)
\\upepsi                            \\upepsi                     "            : (Incomplete sequence)
\\upepsil                           \\upepsil                    "            : (Incomplete sequence)
\\upepsilo                          \\upepsilo                   "            : (Incomplete sequence)
\\upepsilon                         <char-0x003B5>               " ε          : GREEK SMALL LETTER EPSILON
\\uph                               \\uph                        "            : (Incomplete sequence)
\\upha                              \\upha                       "            : (Incomplete sequence)
\\uphar                             \\uphar                      "            : (Incomplete sequence)
\\upharp                            \\upharp                     "            : (Incomplete sequence)
\\upharpo                           \\upharpo                    "            : (Incomplete sequence)
\\upharpoo                          \\upharpoo                   "            : (Incomplete sequence)
\\upharpoon                         \\upharpoon                  "            : (Incomplete sequence)
\\upharpoonl                        \\upharpoonl                 "            : (Incomplete sequence)
\\upharpoonle                       \\upharpoonle                "            : (Incomplete sequence)
\\upharpoonlef                      \\upharpoonlef               "            : (Incomplete sequence)
\\upharpoonleft                     <char-0x021BE>               " ↾          : UPWARDS HARPOON WITH BARB RIGHTWARDS / UP HARPOON WITH BARB RIGHT
\\upharpoonr                        \\upharpoonr                 "            : (Incomplete sequence)
\\upharpoonri                       \\upharpoonri                "            : (Incomplete sequence)
\\upharpoonrig                      \\upharpoonrig               "            : (Incomplete sequence)
\\upharpoonrigh                     \\upharpoonrigh              "            : (Incomplete sequence)
\\upharpoonright                    <char-0x021BF>               " ↿          : UPWARDS HARPOON WITH BARB LEFTWARDS / UP HARPOON WITH BARB LEFT
\\upharpoons                        \\upharpoons                 "            : (Incomplete sequence)
\\upharpoonsl                       \\upharpoonsl                "            : (Incomplete sequence)
\\upharpoonsle                      \\upharpoonsle               "            : (Incomplete sequence)
\\upharpoonslef                     \\upharpoonslef              "            : (Incomplete sequence)
\\upharpoonsleft                    \\upharpoonsleft             "            : (Incomplete sequence)
\\upharpoonsleftr                   \\upharpoonsleftr            "            : (Incomplete sequence)
\\upharpoonsleftri                  \\upharpoonsleftri           "            : (Incomplete sequence)
\\upharpoonsleftrig                 \\upharpoonsleftrig          "            : (Incomplete sequence)
\\upharpoonsleftrigh                \\upharpoonsleftrigh         "            : (Incomplete sequence)
\\upharpoonsleftright               <char-0x02963>               " ⥣          : UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
\\upi                               \\upi                        "            : (Incomplete sequence)
\\upin                              <char-0x027D2>               " ⟒          : ELEMENT OF OPENING UPWARDS
\\upin<Tab>                         <char-0x027D2>               " ⟒          : ELEMENT OF OPENING UPWARDS
\\upint                             <char-0x02A1B>               " ⨛          : INTEGRAL WITH OVERBAR
\\upk                               \\upk                        "            : (Incomplete sequence)
\\upko                              \\upko                       "            : (Incomplete sequence)
\\upkop                             \\upkop                      "            : (Incomplete sequence)
\\upkopp                            \\upkopp                     "            : (Incomplete sequence)
\\upkoppa                           <char-0x003DF>               " ϟ          : GREEK SMALL LETTER KOPPA
\\upl                               \\upl                        "            : (Incomplete sequence)
\\uplu                              \\uplu                       "            : (Incomplete sequence)
\\uplus                             <char-0x0228E>               " ⊎          : MULTISET UNION
\\upo                               \\upo                        "            : (Incomplete sequence)
\\upol                              \\upol                       "            : (Incomplete sequence)
\\upold                             \\upold                      "            : (Incomplete sequence)
\\upoldK                            \\upoldK                     "            : (Incomplete sequence)
\\upoldKo                           \\upoldKo                    "            : (Incomplete sequence)
\\upoldKop                          \\upoldKop                   "            : (Incomplete sequence)
\\upoldKopp                         \\upoldKopp                  "            : (Incomplete sequence)
\\upoldKoppa                        <char-0x003D8>               " Ϙ          : GREEK LETTER ARCHAIC KOPPA
\\upoldk                            \\upoldk                     "            : (Incomplete sequence)
\\upoldko                           \\upoldko                    "            : (Incomplete sequence)
\\upoldkop                          \\upoldkop                   "            : (Incomplete sequence)
\\upoldkopp                         \\upoldkopp                  "            : (Incomplete sequence)
\\upoldkoppa                        <char-0x003D9>               " ϙ          : GREEK SMALL LETTER ARCHAIC KOPPA
\\upom                              \\upom                       "            : (Incomplete sequence)
\\upomi                             \\upomi                      "            : (Incomplete sequence)
\\upomic                            \\upomic                     "            : (Incomplete sequence)
\\upomicr                           \\upomicr                    "            : (Incomplete sequence)
\\upomicro                          \\upomicro                   "            : (Incomplete sequence)
\\upomicron                         <char-0x003BF>               " ο          : GREEK SMALL LETTER OMICRON
\\ups                               \\ups                        "            : (Incomplete sequence)
\\upsa                              \\upsa                       "            : (Incomplete sequence)
\\upsam                             \\upsam                      "            : (Incomplete sequence)
\\upsamp                            \\upsamp                     "            : (Incomplete sequence)
\\upsampi                           <char-0x003E1>               " ϡ          : GREEK SMALL LETTER SAMPI
\\upsi                              \\upsi                       "            : (Incomplete sequence)
\\upsil                             \\upsil                      "            : (Incomplete sequence)
\\upsilo                            \\upsilo                     "            : (Incomplete sequence)
\\upsilon                           <char-0x003C5>               " υ          : GREEK SMALL LETTER UPSILON
\\upst                              \\upst                       "            : (Incomplete sequence)
\\upsti                             \\upsti                      "            : (Incomplete sequence)
\\upstig                            \\upstig                     "            : (Incomplete sequence)
\\upstigm                           \\upstigm                    "            : (Incomplete sequence)
\\upstigma                          <char-0x003DB>               " ϛ          : GREEK SMALL LETTER STIGMA
\\upu                               \\upu                        "            : (Incomplete sequence)
\\upup                              \\upup                       "            : (Incomplete sequence)
\\upupa                             \\upupa                      "            : (Incomplete sequence)
\\upupar                            \\upupar                     "            : (Incomplete sequence)
\\upuparr                           \\upuparr                    "            : (Incomplete sequence)
\\upuparro                          \\upuparro                   "            : (Incomplete sequence)
\\upuparrow                         \\upuparrow                  "            : (Incomplete sequence)
\\upuparrows                        <char-0x021C8>               " ⇈          : UPWARDS PAIRED ARROWS / UP PAIRED ARROWS
\\upv                               \\upv                        "            : (Incomplete sequence)
\\upva                              \\upva                       "            : (Incomplete sequence)
\\upvar                             \\upvar                      "            : (Incomplete sequence)
\\upvarb                            \\upvarb                     "            : (Incomplete sequence)
\\upvarbe                           \\upvarbe                    "            : (Incomplete sequence)
\\upvarbet                          \\upvarbet                   "            : (Incomplete sequence)
\\upvarbeta                         <char-0x003D0>               " ϐ          : GREEK BETA SYMBOL / GREEK SMALL LETTER CURLED BETA
\\upw                               \\upw                        "            : (Incomplete sequence)
\\upwh                              \\upwh                       "            : (Incomplete sequence)
\\upwhi                             \\upwhi                      "            : (Incomplete sequence)
\\upwhit                            \\upwhit                     "            : (Incomplete sequence)
\\upwhite                           \\upwhite                    "            : (Incomplete sequence)
\\upwhitea                          \\upwhitea                   "            : (Incomplete sequence)
\\upwhitear                         \\upwhitear                  "            : (Incomplete sequence)
\\upwhitearr                        \\upwhitearr                 "            : (Incomplete sequence)
\\upwhitearro                       \\upwhitearro                "            : (Incomplete sequence)
\\upwhitearrow                      <char-0x021E7>               " ⇧          : UPWARDS WHITE ARROW / WHITE UP ARROW
\\ur                                \\ur                         "            : (Incomplete sequence)
\\ura                               \\ura                        "            : (Incomplete sequence)
\\uran                              \\uran                       "            : (Incomplete sequence)
\\uranu                             \\uranu                      "            : (Incomplete sequence)
\\uranus                            <char-0x02645>               " ♅          : URANUS
\\urar                              \\urar                       "            : (Incomplete sequence)
\\urarc                             <char-0x025DD>               " ◝          : UPPER RIGHT QUADRANT CIRCULAR ARC
\\urb                               \\urb                        "            : (Incomplete sequence)
\\urbl                              \\urbl                       "            : (Incomplete sequence)
\\urbla                             \\urbla                      "            : (Incomplete sequence)
\\urblac                            \\urblac                     "            : (Incomplete sequence)
\\urblack                           \\urblack                    "            : (Incomplete sequence)
\\urblackt                          \\urblackt                   "            : (Incomplete sequence)
\\urblacktr                         \\urblacktr                  "            : (Incomplete sequence)
\\urblacktri                        \\urblacktri                 "            : (Incomplete sequence)
\\urblacktria                       \\urblacktria                "            : (Incomplete sequence)
\\urblacktrian                      \\urblacktrian               "            : (Incomplete sequence)
\\urblacktriang                     \\urblacktriang              "            : (Incomplete sequence)
\\urblacktriangl                    \\urblacktriangl             "            : (Incomplete sequence)
\\urblacktriangle                   <char-0x025E5>               " ◥          : BLACK UPPER RIGHT TRIANGLE
\\urc                               \\urc                        "            : (Incomplete sequence)
\\urco                              \\urco                       "            : (Incomplete sequence)
\\urcor                             \\urcor                      "            : (Incomplete sequence)
\\urcorn                            \\urcorn                     "            : (Incomplete sequence)
\\urcorne                           \\urcorne                    "            : (Incomplete sequence)
\\urcorner                          <char-0x0231D>               " ⌝          : TOP RIGHT CORNER
\\urt                               \\urt                        "            : (Incomplete sequence)
\\urtr                              \\urtr                       "            : (Incomplete sequence)
\\urtri                             \\urtri                      "            : (Incomplete sequence)
\\urtria                            \\urtria                     "            : (Incomplete sequence)
\\urtrian                           \\urtrian                    "            : (Incomplete sequence)
\\urtriang                          \\urtriang                   "            : (Incomplete sequence)
\\urtriangl                         \\urtriangl                  "            : (Incomplete sequence)
\\urtriangle                        <char-0x025F9>               " ◹          : UPPER RIGHT TRIANGLE
\\vDash                             <char-0x022A8>               " ⊨          : TRUE
\\varTheta                          <char-0x003F4>               " ϴ          : GREEK CAPITAL THETA SYMBOL
\\varbarwedge                       <char-0x02305>               " ⌅          : PROJECTIVE
\\varcarriagereturn                 <char-0x023CE>               " ⏎          : RETURN SYMBOL
\\varclubsuit                       <char-0x02667>               " ♧          : WHITE CLUB SUIT
\\vardiamondsuit                    <char-0x02666>               " ♦          : BLACK DIAMOND SUIT
\\vardoublebarwedge                 <char-0x02306>               " ⌆          : PERSPECTIVE
\\varepsilon                        <char-0x003B5>               " ε          : GREEK SMALL LETTER EPSILON
\\varheartsuit                      <char-0x02665>               " ♥          : BLACK HEART SUIT
\\varhexagon                        <char-0x02B21>               " ⬡          : WHITE HEXAGON
\\varhexagon<Tab>                   <char-0x02B21>               " ⬡          : WHITE HEXAGON
\\varhexagonb                       \\varhexagonb                "            : (Incomplete sequence)
\\varhexagonbl                      \\varhexagonbl               "            : (Incomplete sequence)
\\varhexagonbla                     \\varhexagonbla              "            : (Incomplete sequence)
\\varhexagonblac                    \\varhexagonblac             "            : (Incomplete sequence)
\\varhexagonblack                   <char-0x02B22>               " ⬢          : BLACK HEXAGON
\\varhexagonl                       \\varhexagonl                "            : (Incomplete sequence)
\\varhexagonlr                      \\varhexagonlr               "            : (Incomplete sequence)
\\varhexagonlrb                     \\varhexagonlrb              "            : (Incomplete sequence)
\\varhexagonlrbo                    \\varhexagonlrbo             "            : (Incomplete sequence)
\\varhexagonlrbon                   \\varhexagonlrbon            "            : (Incomplete sequence)
\\varhexagonlrbond                  \\varhexagonlrbond           "            : (Incomplete sequence)
\\varhexagonlrbonds                 <char-0x0232C>               " ⌬          : BENZENE RING
\\varisinobar                       <char-0x022F6>               " ⋶          : ELEMENT OF WITH OVERBAR
\\varisins                          <char-0x022F3>               " ⋳          : ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\varkappa                          <char-0x003F0>               " ϰ          : GREEK KAPPA SYMBOL / GREEK SMALL LETTER SCRIPT KAPPA
\\varlrtriangle                     <char-0x022BF>               " ⊿          : RIGHT TRIANGLE
\\varniobar                         <char-0x022FD>               " ⋽          : CONTAINS WITH OVERBAR
\\varnis                            <char-0x022FB>               " ⋻          : CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\varnothing                        <char-0x02205>               " ∅          : EMPTY SET
\\varointclockwise                  <char-0x02232>               " ∲          : CLOCKWISE CONTOUR INTEGRAL
\\varphi                            <char-0x003C6>               " φ          : GREEK SMALL LETTER PHI
\\varpi                             <char-0x003D6>               " ϖ          : GREEK PI SYMBOL / GREEK SMALL LETTER OMEGA PI
\\varrho                            <char-0x003F1>               " ϱ          : GREEK RHO SYMBOL / GREEK SMALL LETTER TAILED RHO
\\varsigma                          <char-0x003C2>               " ς          : GREEK SMALL LETTER FINAL SIGMA
\\varspadesuit                      <char-0x02664>               " ♤          : WHITE SPADE SUIT
\\varstar                           <char-0x02736>               " ✶          : SIX POINTED BLACK STAR
\\varsubsetneqq                     <char-0x0228A><char-0x0FE00> " ⊊︀         : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO + VARIATION SELECTOR-1
\\varsupsetneq                      <char-0x0228B><char-0x0FE00> " ⊋︀         : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO + VARIATION SELECTOR-1
\\vartheta                          <char-0x003D1>               " ϑ          : GREEK THETA SYMBOL / GREEK SMALL LETTER SCRIPT THETA
\\vartriangle                       <char-0x025B5>               " ▵          : WHITE UP-POINTING SMALL TRIANGLE / WHITE UP POINTING SMALL TRIANGLE
\\vartriangle<Tab>                  <char-0x025B5>               " ▵          : WHITE UP-POINTING SMALL TRIANGLE / WHITE UP POINTING SMALL TRIANGLE
\\vartrianglel                      \\vartrianglel               "            : (Incomplete sequence)
\\vartrianglele                     \\vartrianglele              "            : (Incomplete sequence)
\\vartrianglelef                    \\vartrianglelef             "            : (Incomplete sequence)
\\vartriangleleft                   <char-0x022B2>               " ⊲          : NORMAL SUBGROUP OF
\\vartriangler                      \\vartriangler               "            : (Incomplete sequence)
\\vartriangleri                     \\vartriangleri              "            : (Incomplete sequence)
\\vartrianglerig                    \\vartrianglerig             "            : (Incomplete sequence)
\\vartrianglerigh                   \\vartrianglerigh            "            : (Incomplete sequence)
\\vartriangleright                  <char-0x022B3>               " ⊳          : CONTAINS AS NORMAL SUBGROUP
\\varveebar                         <char-0x02A61>               " ⩡          : SMALL VEE WITH UNDERBAR
\\vdash                             <char-0x022A2>               " ⊢          : RIGHT TACK
\\vdots                             <char-0x022EE>               " ⋮          : VERTICAL ELLIPSIS
\\vec                               <char-0x020D7>               " ◌⃗         : COMBINING RIGHT ARROW ABOVE / NON-SPACING RIGHT ARROW ABOVE
\\vee                               <char-0x02228>               " ∨          : LOGICAL OR
\\vee<Tab>                          <char-0x02228>               " ∨          : LOGICAL OR
\\veeb                              \\veeb                       "            : (Incomplete sequence)
\\veeba                             \\veeba                      "            : (Incomplete sequence)
\\veebar                            <char-0x022BB>               " ⊻          : XOR
\\veed                              \\veed                       "            : (Incomplete sequence)
\\veedo                             \\veedo                      "            : (Incomplete sequence)
\\veedou                            \\veedou                     "            : (Incomplete sequence)
\\veedoub                           \\veedoub                    "            : (Incomplete sequence)
\\veedoubl                          \\veedoubl                   "            : (Incomplete sequence)
\\veedouble                         \\veedouble                  "            : (Incomplete sequence)
\\veedoubleb                        \\veedoubleb                 "            : (Incomplete sequence)
\\veedoubleba                       \\veedoubleba                "            : (Incomplete sequence)
\\veedoublebar                      <char-0x02A63>               " ⩣          : LOGICAL OR WITH DOUBLE UNDERBAR
\\veee                              \\veee                       "            : (Incomplete sequence)
\\veeeq                             <char-0x0225A>               " ≚          : EQUIANGULAR TO
\\veem                              \\veem                       "            : (Incomplete sequence)
\\veemi                             \\veemi                      "            : (Incomplete sequence)
\\veemid                            \\veemid                     "            : (Incomplete sequence)
\\veemidv                           \\veemidv                    "            : (Incomplete sequence)
\\veemidve                          \\veemidve                   "            : (Incomplete sequence)
\\veemidver                         \\veemidver                  "            : (Incomplete sequence)
\\veemidvert                        <char-0x02A5B>               " ⩛          : LOGICAL OR WITH MIDDLE STEM
\\veeo                              \\veeo                       "            : (Incomplete sequence)
\\veeod                             \\veeod                      "            : (Incomplete sequence)
\\veeodo                            \\veeodo                     "            : (Incomplete sequence)
\\veeodot                           <char-0x02A52>               " ⩒          : LOGICAL OR WITH DOT ABOVE
\\venus                             <char-0x02640>               " ♀          : FEMALE SIGN
\\verti                             <char-0x002CC>               " ˌ          : MODIFIER LETTER LOW VERTICAL LINE
\\vertoverlay                       <char-0x020D2>               " ◌⃒         : COMBINING LONG VERTICAL LINE OVERLAY / NON-SPACING LONG VERTICAL BAR OVERLAY
\\verts                             <char-0x002C8>               " ˈ          : MODIFIER LETTER VERTICAL LINE
\\verymuchless                      <char-0x022D8>               " ⋘          : VERY MUCH LESS-THAN / VERY MUCH LESS THAN
\\viewdata                          <char-0x02317>               " ⌗          : VIEWDATA SQUARE
\\virgo                             <char-0x0264D>               " ♍          : VIRGO
\\visiblespace                      <char-0x02423>               " ␣          : OPEN BOX
\\vrectangleblack                   <char-0x025AE>               " ▮          : BLACK VERTICAL RECTANGLE
\\vrecto                            <char-0x025AF>               " ▯          : WHITE VERTICAL RECTANGLE
\\vysmblkcircle                     <char-0x02219>               " ∙          : BULLET OPERATOR
\\vysmblksquare                     <char-0x02B1D>               " ⬝          : BLACK VERY SMALL SQUARE
\\vysmwhtsquare                     <char-0x02B1E>               " ⬞          : WHITE VERY SMALL SQUARE
\\wedge                             <char-0x02227>               " ∧          : LOGICAL AND
\\wedge<Tab>                        <char-0x02227>               " ∧          : LOGICAL AND
\\wedged                            \\wedged                     "            : (Incomplete sequence)
\\wedgedo                           \\wedgedo                    "            : (Incomplete sequence)
\\wedgedot                          <char-0x027D1>               " ⟑          : AND WITH DOT
\\wedgedou                          \\wedgedou                   "            : (Incomplete sequence)
\\wedgedoub                         \\wedgedoub                  "            : (Incomplete sequence)
\\wedgedoubl                        \\wedgedoubl                 "            : (Incomplete sequence)
\\wedgedouble                       \\wedgedouble                "            : (Incomplete sequence)
\\wedgedoubleb                      \\wedgedoubleb               "            : (Incomplete sequence)
\\wedgedoubleba                     \\wedgedoubleba              "            : (Incomplete sequence)
\\wedgedoublebar                    <char-0x02A60>               " ⩠          : LOGICAL AND WITH DOUBLE UNDERBAR
\\wedgem                            \\wedgem                     "            : (Incomplete sequence)
\\wedgemi                           \\wedgemi                    "            : (Incomplete sequence)
\\wedgemid                          \\wedgemid                   "            : (Incomplete sequence)
\\wedgemidv                         \\wedgemidv                  "            : (Incomplete sequence)
\\wedgemidve                        \\wedgemidve                 "            : (Incomplete sequence)
\\wedgemidver                       \\wedgemidver                "            : (Incomplete sequence)
\\wedgemidvert                      <char-0x02A5A>               " ⩚          : LOGICAL AND WITH MIDDLE STEM
\\wedgeo                            \\wedgeo                     "            : (Incomplete sequence)
\\wedgeod                           \\wedgeod                    "            : (Incomplete sequence)
\\wedgeodo                          \\wedgeodo                   "            : (Incomplete sequence)
\\wedgeodot                         <char-0x02A51>               " ⩑          : LOGICAL AND WITH DOT ABOVE
\\wedgeon                           \\wedgeon                    "            : (Incomplete sequence)
\\wedgeonw                          \\wedgeonw                   "            : (Incomplete sequence)
\\wedgeonwe                         \\wedgeonwe                  "            : (Incomplete sequence)
\\wedgeonwed                        \\wedgeonwed                 "            : (Incomplete sequence)
\\wedgeonwedg                       \\wedgeonwedg                "            : (Incomplete sequence)
\\wedgeonwedge                      <char-0x02A55>               " ⩕          : TWO INTERSECTING LOGICAL AND
\\wedgeq                            <char-0x02259>               " ≙          : ESTIMATES
\\whitearrowupfrombar               <char-0x021EA>               " ⇪          : UPWARDS WHITE ARROW FROM BAR / WHITE UP ARROW FROM BAR
\\whiteinwhitetriangle              <char-0x027C1>               " ⟁          : WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE
\\whitepointerleft                  <char-0x025C5>               " ◅          : WHITE LEFT-POINTING POINTER / WHITE LEFT POINTING POINTER
\\whitepointerright                 <char-0x025BB>               " ▻          : WHITE RIGHT-POINTING POINTER / WHITE RIGHT POINTING POINTER
\\whthorzoval                       <char-0x02B2D>               " ⬭          : WHITE HORIZONTAL ELLIPSE
\\whtvertoval                       <char-0x02B2F>               " ⬯          : WHITE VERTICAL ELLIPSE
\\wideangledown                     <char-0x029A6>               " ⦦          : OBLIQUE ANGLE OPENING UP
\\wideangleup                       <char-0x029A7>               " ⦧          : OBLIQUE ANGLE OPENING DOWN
\\widebridgeabove                   <char-0x020E9>               " ◌⃩         : COMBINING WIDE BRIDGE ABOVE
\\wideutilde                        <char-0x00330>               " ◌̰         : COMBINING TILDE BELOW / NON-SPACING TILDE BELOW
\\wp                                <char-0x02118>               " ℘          : SCRIPT CAPITAL P / SCRIPT P
\\wr                                <char-0x02240>               " ≀          : WREATH PRODUCT
\\xi                                <char-0x003BE>               " ξ          : GREEK SMALL LETTER XI
\\xor                               <char-0x022BB>               " ⊻          : XOR
\\xrat                              <char-0x0211E>               " ℞          : PRESCRIPTION TAKE
\\yen                               <char-0x000A5>               " ¥          : YEN SIGN
\\yogh                              <char-0x00292>               " ʒ          : LATIN SMALL LETTER EZH / LATIN SMALL LETTER YOGH
\\zeta                              <char-0x003B6>               " ζ          : GREEK SMALL LETTER ZETA
" --------------------------------- ---------------------------- " ---------- : --------------------------------------------------------------------------------------------------------

" Below here is the script that was used to produce this file.

"> #!/bin/env julia
"> 
"> const filename = "latex2unicode_utf-8"
"> 
"> # We want to avoid situations in which the user types e.g. \delt and pauses,
"> # and the result is "∇t" because "\del" gets recognized and then there is some leftover "t".
"> # This allows us to get completions with <Tab> for example.
"> function fix_completions(completions::Dict{String,String})
">     allinputs = sort!(collect(keys(completions)))
">     new_completions = copy(completions)
"> 
">     for input in allinputs
">         chars = completions[input]
">         l = length(input)
">         longer = filter(x->startswith(x, input)&&length(x)>l, allinputs)
">         n = length(longer)
">         n == 0 && continue
">         new_completions[input * "<Tab>"] = chars
">         for other in longer
">             for j = (l+1):(length(other)-1)
">                 haskey(new_completions, other[1:j]) && continue
">                 new_completions[other[1:j]] = other[1:j]
">             end
">         end
">     end
">     return new_completions
"> end
"> 
"> function unicode_data()
">     file = normpath(Sys.BINDIR, "..", "..", "doc", "UnicodeData.txt")
">     names = Dict{UInt32, String}()
">     open(file) do unidata
">         for line in readlines(unidata)
">             id, name, desc = split(line, ";")[[1, 2, 11]]
">             codepoint = parse(UInt32, "0x$id")
">             names[codepoint] = (name == "" ? desc : desc == "" ? name : "$name / $desc")
">         end
">     end
">     return names
"> end
"> 
"> # Prepend a dotted circle ('◌' i.e. '\u25CC') to combining characters
"> function fix_combining_chars(char)
">     cat = Base.Unicode.category_code(char)
">     return string(cat == 6 || cat == 8 ? "◌" : "", char)
"> end
"> 
"> function table_entries(completions::Dict{String,String}, unicode_dict)
">     latex = String[]
">     code = String[]
">     unicode = String[]
">     desc = String[]
"> 
">     for (input, chars) in sort!(collect(completions))
">         code_points, unicode_names, characters = String[], String[], String[]
">         if startswith(chars, "\\")
">             push!(code_points, replace(chars, "\\" => "\\\\"))
">             push!(unicode_names, "(Incomplete sequence)")
">             push!(characters, "")
">         else
">             for char in chars
">                 push!(code_points, "<char-0x$(uppercase(string(UInt32(char), base = 16, pad = 5)))>")
">                 push!(unicode_names, get(unicode_dict, UInt32(char), "(No Unicode name)"))
">                 push!(characters, isempty(characters) ? fix_combining_chars(char) : "$char")
">             end
">         end
">         push!(latex, replace(input, "\\"=>"\\\\"))
">         push!(code, join(code_points))
">         push!(unicode, join(characters))
">         push!(desc, join(unicode_names, " + "))
">     end
">     return latex, code, unicode, desc
"> end
"> 
"> open("$filename.vim","w") do f
">     print(f, """
">         " This file is autogenerated from the script '$(basename(Base.source_path()))'
">         " The symbols are based on Julia version $VERSION
">         " The full generating script can be found in the comments at the bottom of this file,
">         " and it can be extracted with:
">         "
">         "     \$ grep '^\">' $filename.vim | cut -c4- > $(basename(Base.source_path()))'
">         "
">         " To produce this keymap file you need to have Julia compilied from source, and
">         " to run `make UnicodeData.txt` inside Julia's `doc` directory.
">         " Then you can run:
">         "
">         "     \$ julia $(basename(Base.source_path())).jl
">         "
"> 
">         scriptencoding utf-8
"> 
">         let b:keymap_name = "L2U"
">         loadkeymap
"> 
">         """)
"> 
">     col_headers = ["\" Tab completion sequence", "Code point", "Character", "Unicode name"]
"> 
">     latex, code, unicode, desc =
">         table_entries(
">             fix_completions(merge(
">                 REPL.REPLCompletions.latex_symbols,
">                 REPL.REPLCompletions.emoji_symbols
">                 )),
">             unicode_data()
">             )
"> 
">     lw = max(length(col_headers[3]), maximum(map(length, latex)))
">     cw = max(length(col_headers[1]), maximum(map(length, code)))
">     uw = max(length(col_headers[2]), maximum(map(length, unicode)))
">     dw = max(length(col_headers[4]), maximum(map(length, desc)))
"> 
">     print_padded(l, c, u, d) = println(f, rpad(l, lw), " ", rpad(c, cw), " \" ", rpad(u, uw), " : ", d)
"> 
">     print_padded(col_headers...)
">     print_padded("\" " * "-"^(lw-2), "-"^cw, "-"^uw, "-"^dw)
"> 
">     for (l, c, u, d) in zip(latex, code, unicode, desc)
">         print_padded(l, c, u, d)
">     end
">     print_padded("\" " * "-"^(lw-2), "-"^cw, "-"^uw, "-"^dw)
"> 
">     print(f, """
"> 
">         " Below here is the script that was used to produce this file.
"> 
">         """)
">     for l in readlines(Base.source_path())
">         println(f, "\"> ", l)
">     end
">     println(f)
"> end

