/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SCHEMATICFRAME_H
#define SCHEMATICFRAME_H

#include <Component.h>
#include <CircuitNode.h>
#include <CircuitLine.h>

#include <qframe.h>
#include <qlist.h>
#include <qpoint.h>
#include <qguardedptr.h> 
#include <qiconset.h>

class Schematic;
class QPopupMenu;
class SchematicWindow;
class EditAttributesWindow;

class QPrinter;
class QMouseEvent;
class ToolBar;

class SchematicFrame : public QFrame
{
  Q_OBJECT
public:
  SchematicFrame(QWidget* parent, const char * name=0, WFlags f=0, bool = TRUE );
  virtual ~SchematicFrame();

  static SchematicFrame* instance();

  void print();
  void reDraw();

  QString getActiveSchematicName();
  void setActiveSchematic( Schematic* schematic );
  void schematicSizeChanged( const QString& name );

  void toggleGrid();
  void rotateSelectedComponent();

  bool anythingSelected();  //checks if any lines or components were selected
  
protected:
  void placeComponent( const QString& name, const QPoint& point );
  void addComponentToList( Component* component );

  virtual void paintEvent( QPaintEvent* );
  virtual void mouseDoubleClickEvent ( QMouseEvent* );
  virtual void mousePressEvent( QMouseEvent* );
  virtual void mouseReleaseEvent( QMouseEvent* );
  virtual void mouseMoveEvent( QMouseEvent* );

private:
  void draw(QPainter* p);
  void drawGrid(QPainter* p);

  void createContextMenus();
  
  Component* findComponentAt( const QPoint& point );
  CircuitNode* findNodeAt( const QPoint& point );
  CircuitLine* findLineAt( const QPoint& point, bool orthoganalOnly = FALSE);
  
  void clearSelection();

  void placingEvent( QMouseEvent* e );
  void drawingEvent( QMouseEvent* e );

  void queryNet(CircuitLine* line);
  void queryNet(CircuitNode* node);

public slots:
  void deleteSelectedItemSlot();

private:
  static SchematicFrame* instance_;

  Schematic* activeSchematic_;

  QList<Component>   selectedComponents_;
  QList<CircuitLine> selectedLines_;
  QList<CircuitNode> selectedNodes_;

  bool dragging_;
  bool drawing_;
  bool selecting_;
  bool gridEnabled_;
  int  gridSpacing_;
  QPoint lastMousePos_;

  //Popup menu items
  QPopupMenu* menu_;

  int deleteMenuID_;
  int rotateMenuID_;

  //icons and text needed in hack - see mousePressEvent()
  QIconSet rotateIcon_;
  QIconSet deleteIcon_;
  QIconSet rotateDisabledIcon_;
  QIconSet deleteDisabledIcon_;
  
  QString deleteMenuName_;
  QString rotateMenuName_;
      
  //Printer object
  QPrinter* printer_;

  QGuardedPtr<EditAttributesWindow> editAttributeWindow_;
};

#endif
