/* -*- C++ -*-
   
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <TableFrame.h>

#include <GraphView.h>

#include <iostream.h>

//----------------------------------------------------------------------------
TableFrame::TableFrame(GraphView& parent, const char *name )
  : QTableView(&parent, name),
    view_(parent),
    contents_(0)
{
  curRow_ = curCol_ = 0;		// set currently selected cell
  setFocusPolicy( StrongFocus );	// we accept keyboard focus
  setBackgroundMode( PaletteBase );    	// set widgets background
  setCellWidth( 100 );			// set width of cell in pixels
  setCellHeight( 30 );			// set height of cell in pixels
  setTableFlags( Tbl_vScrollBar |      	// always vertical scroll bar
                 Tbl_hScrollBar |      	// ditto for horizontal
                 Tbl_clipCellPainting |	// avoid drawing outside cell
                 Tbl_smoothScrolling);	// easier to see the scrolling
}

//----------------------------------------------------------------------------
TableFrame::~TableFrame()
{
  if ( contents_ )
    {
      delete [] contents_;
      contents_ = 0;
    }
}

//----------------------------------------------------------------------------
void TableFrame::drawContents( QPainter* p )
{
  view_.draw( p );
}

//----------------------------------------------------------------------------
void TableFrame::reDraw()
{
  view_.draw( 0 );
}

//----------------------------------------------------------------------------
void TableFrame::setSize( int rows, int cols )
{
  QTableView::setNumCols( cols );
  QTableView::setNumRows( rows );
  if ( contents_ )
    {
      delete [] contents_;
    }
  contents_ = new QString[ cols * rows ];
}

//----------------------------------------------------------------------------
void TableFrame::setCell( int row, int col, const QString& text )
{
  ASSERT( contents_ != 0 );
  contents_[ indexOf(row, col) ] = text;
  updateCell( row, col );
}

//----------------------------------------------------------------------------
int TableFrame::indexOf( int row, int col ) const
  {
    return (row * numCols()) + col;
  }

//----------------------------------------------------------------------------
void TableFrame::paintCell( QPainter* p, int row, int col )
{
  int w = cellWidth( col );			// width of cell in pixels
  int h = cellHeight( row );			// height of cell in pixels

  //Set brush
  QColor brushColor;
  if ((col==0) || (row==0))
    brushColor.setRgb(200,200,200);
  else
    brushColor.setRgb(255,255,255);

  QColor penColor;
  penColor.setRgb(150,150,150);

  p->setPen(penColor);
  p->setBrush(brushColor);
  p->drawRect( 0, 0, w, h );

  penColor.setRgb(0,0,0);
  p->setPen(penColor);

  // Draw cell content (text)
  if ( contents_ )
    {
      if (row == 0)
	{
	  p->drawText( 0, 0, w, h, AlignCenter, contents_[indexOf(row,col)] );
	}
      else
	{
	  p->drawText( 0, 0, w, h, AlignRight | AlignVCenter, contents_[indexOf(row,col)] );
	}
    }
}
