/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef GRAPHDEFINITION_H
#define GRAPHDEFINITION_H

#include <ResultDefinition.h>

#include <qlist.h>
#include <qstring.h>
#include <qguardedptr.h>

class GraphView;
class DataPoint;
class QDomElement;
class ModifyOutputParameterWindow;

class GraphDefinition
{
public:
  enum GraphType { unknown, gridType, smithType, tableType };
  
  GraphDefinition( GraphType viewType ); 
  virtual ~GraphDefinition();

  GraphType graphType() const;

  const QString& getName() const;
  void setName( const QString& );

  void setTitle( const QString& );
  const QString& getTitle() const;

  virtual void updateGraph() = 0;

  //Access to graphical partner
  virtual GraphView* getView() = 0;

  void show();
  void fill();
  void reDraw();

  void addOutputDefinition( const ResultDefinition* definition );
  void removeOutputDefinition( const ResultDefinition* definition );

  void writeToStream( QTextStream& stream );
  bool readFromDOM( QDomElement& element );

  virtual void writeGraphSettingToStream( QTextStream& stream ) = 0;
  virtual bool readGraphSettingFromDOM( QDomElement& element ) = 0;
  
private:
  GraphDefinition( const GraphDefinition& );
  GraphDefinition& operator=( const GraphDefinition& );

  void addSeries( ResultDefinition& definition, QList<DataPoint>& data );
  
private:
  GraphType type_;
  QString name_;
  QString title_;
  QList<ResultDefinition> results_;
};

#endif
