/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Dimension;
import java.awt.Event;
import java.io.IOException;
import java.net.Socket;
import rdr.JavaInStream;
import rdr.JavaOutStream;
import rfb.CConnection;
import rfb.CSecurity;
import rfb.CSecurityNone;
import rfb.CSecurityVncAuth;
import rfb.Encodings;
import rfb.Hostname;
import rfb.LogWriter;
import rfb.PixelFormat;
import rfb.SecTypes;
import rfb.UnicodeToKeysym;
import rfb.UserPasswdGetter;
import vncviewer.AboutDialog;
import vncviewer.ClipboardDialog;
import vncviewer.DesktopWindow;
import vncviewer.F8Menu;
import vncviewer.InfoDialog;
import vncviewer.OptionsDialog;
import vncviewer.OptionsDialogCallback;
import vncviewer.PasswdDialog;
import vncviewer.ServerDialog;
import vncviewer.VNCViewer;
import vncviewer.ViewportFrame;

public class CConn
extends CConnection
implements UserPasswdGetter,
OptionsDialogCallback {
    static LogWriter vlog = new LogWriter("CConn");
    String serverHost;
    int serverPort;
    Socket sock;
    JavaInStream jis;
    JavaOutStream jos;
    VNCViewer viewer;
    DesktopWindow desktop;
    PixelFormat serverPF;
    ViewportFrame viewport;
    PixelFormat fullColourPF;
    boolean shuttingDown;
    int currentEncoding;
    int lastUsedEncoding;
    boolean fullColour;
    boolean autoSelect;
    boolean shared;
    boolean formatChange;
    boolean encodingChange;
    boolean sameMachine;
    F8Menu menu;
    OptionsDialog options;
    AboutDialog about;
    InfoDialog info;
    ClipboardDialog clipboardDialog;
    int buttonMask;
    int pressedModifiers;

    public boolean init(Socket socket, String string, boolean bl) throws IOException {
        this.sock = socket;
        if (this.sock != null) {
            String string2 = this.sock.getInetAddress().getHostAddress() + "::" + this.sock.getPort();
            vlog.info("Accepted connection from " + string2);
        } else {
            if (bl || string == null) {
                ServerDialog serverDialog = new ServerDialog(this.options, this.about, string);
                if (!serverDialog.showDialog() || serverDialog.server.getText().equals("")) {
                    return false;
                }
                string = serverDialog.server.getText();
            }
            this.serverHost = Hostname.getHost(string);
            this.serverPort = Hostname.getPort(string);
            this.sock = new Socket(this.serverHost, this.serverPort);
            vlog.info("connected to host " + this.serverHost + " port " + this.serverPort);
        }
        this.setServerName(this.sock.getInetAddress().getHostAddress() + "::" + this.sock.getPort());
        this.jis = new JavaInStream(this.sock.getInputStream());
        this.jos = new JavaOutStream(this.sock.getOutputStream());
        this.setStreams(this.jis, this.jos);
        this.initialiseProtocol();
        return true;
    }

    void removeWindow() {
        if (this.viewport != null) {
            this.viewport.dispose();
        }
        this.viewport = null;
    }

    public boolean getUserPasswd(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        String string = "VNC Authentication [" + this.getCurrentCSecurity().description() + "]";
        PasswdDialog passwdDialog = new PasswdDialog(string, stringBuffer == null);
        if (!passwdDialog.showDialog()) {
            return false;
        }
        if (stringBuffer != null) {
            stringBuffer.append(passwdDialog.userEntry.getText());
        }
        stringBuffer2.append(passwdDialog.passwdEntry.getText());
        return true;
    }

    public CSecurity getCSecurity(int n) {
        switch (n) {
            case 1: {
                return new CSecurityNone();
            }
            case 2: {
                return new CSecurityVncAuth(this);
            }
        }
        throw new rfb.Exception("Unsupported secType?");
    }

    public void serverInit() {
        super.serverInit();
        this.serverPF = this.cp.pf();
        this.desktop = new DesktopWindow(this.serverPF, this);
        this.desktop.add(this.menu);
        this.fullColourPF = this.desktop.getPF();
        if (!this.serverPF.trueColour) {
            this.fullColour = true;
        }
        this.recreateViewport();
        this.encodingChange = true;
        this.formatChange = true;
        this.requestNewUpdate();
    }

    public void setDesktopSize(int n, int n2) {
        super.setDesktopSize(n, n2);
        if (this.desktop != null) {
            this.desktop.resize();
            this.recreateViewport();
        }
    }

    public void framebufferUpdateStart() {
    }

    public void framebufferUpdateEnd() {
        if (this.autoSelect) {
            this.autoSelectFormatAndEncoding();
        }
        this.requestNewUpdate();
    }

    public void setColourMapEntries(int n, int n2, int[] nArray) {
        this.desktop.setColourMapEntries(n, n2, nArray);
    }

    public void bell() {
        this.desktop.getToolkit().beep();
    }

    public void serverCutText(String string) {
        if (this.viewer.acceptClipboard.getValue()) {
            this.clipboardDialog.serverCutText(string);
        }
    }

    public void beginRect(int n, int n2, int n3, int n4, int n5) {
        this.jis.startTiming();
        this.desktop.beginRect(n, n2, n3, n4, n5);
    }

    public void endRect(int n, int n2, int n3, int n4, int n5) {
        this.desktop.endRect(n, n2, n3, n4, n5);
        this.jis.stopTiming();
        if (n5 <= 255) {
            this.lastUsedEncoding = n5;
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5) {
        this.desktop.fillRect(n, n2, n3, n4, n5);
    }

    public void imageRect(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        this.desktop.imageRect(n, n2, n3, n4, byArray, n5);
    }

    public void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.desktop.copyRect(n, n2, n3, n4, n5, n6);
    }

    public void setCursor(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        this.desktop.setCursor(n, n2, n3, n4, byArray, byArray2);
    }

    void recreateViewport() {
        if (this.viewport != null) {
            this.viewport.dispose();
        }
        this.viewport = new ViewportFrame("VNC: " + this.cp.name, this);
        this.viewport.addChild(this.desktop);
        this.reconfigureViewport();
        this.viewport.show();
        this.desktop.initGraphics();
    }

    void reconfigureViewport() {
        int n = this.cp.width + 4;
        int n2 = this.cp.height + 4;
        Dimension dimension = this.viewport.getToolkit().getScreenSize();
        int n3 = 6;
        int n4 = 24;
        if (n + n3 >= dimension.width) {
            n = dimension.width - n3;
        }
        if (n2 + n4 >= dimension.height) {
            n2 = dimension.height - n4;
        }
        int n5 = (dimension.width - n - n3) / 2;
        int n6 = (dimension.height - n2 - n4) / 2;
        this.viewport.setGeometry(n5, n6, n, n2);
    }

    void autoSelectFormatAndEncoding() {
        long l = this.jis.kbitsPerSecond();
        int n = this.currentEncoding;
        if (l > 3000L) {
            n = 5;
        } else if (l < 1500L) {
            n = 16;
        }
        if (n != this.currentEncoding) {
            vlog.info("Throughput " + l + " kbit/s - changing to " + Encodings.name(n) + " encoding");
            this.currentEncoding = n;
            this.encodingChange = true;
        }
    }

    void requestNewUpdate() {
        Object object;
        if (this.formatChange) {
            if (this.fullColour) {
                // empty if block
            }
            object = this.desktop.getPF().print();
            vlog.info("Using pixel format " + (String)object);
            this.cp.setPF(this.desktop.getPF());
            CConn cConn = this;
            synchronized (cConn) {
                this.writer().writeSetPixelFormat(this.cp.pf());
            }
        }
        this.checkEncodings();
        object = this;
        synchronized (object) {
            this.writer().writeFramebufferUpdateRequest(0, 0, this.cp.width, this.cp.height, !this.formatChange);
        }
        this.formatChange = false;
    }

    public void close() {
        try {
            this.shuttingDown = true;
            this.sock.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showMenu(int n, int n2) {
        this.menu.show(this.desktop, n, n2);
    }

    public void showInfo() {
        String string = "Desktop Name:\t\t" + this.cp.name + "\n" + "Host:\t\t\t" + this.serverHost + " port: " + this.serverPort + "\n" + "Size:\t\t\t" + this.cp.width + " x " + this.cp.height + "\n" + "Pixel Format:\t\t" + this.cp.pf().print() + "\n" + "Server Default:\t\t" + this.serverPF.print() + ")\n" + "Requested Encoding:\t" + Encodings.name(this.currentEncoding) + "\n" + "Last Used Encoding:\t" + Encodings.name(this.lastUsedEncoding) + "\n" + "Line Speed Estimate:\t" + this.jis.kbitsPerSecond() + " kbit/s\n" + "Protocol Version:\t\t" + this.cp.majorVersion + "." + this.cp.minorVersion + "\n" + "Security Method:\t\t" + SecTypes.name(this.getCurrentCSecurity().getType()) + "\n" + "Encryption:\t\t" + this.getCurrentCSecurity().description();
        this.info.infoLabel.setText(string);
        this.info.showDialog();
    }

    public synchronized void refresh() {
        this.writer().writeFramebufferUpdateRequest(0, 0, this.cp.width, this.cp.height, false);
    }

    public void setOptions() {
        this.options.autoSelect.setState(this.autoSelect);
        this.options.fullColour.setState(false);
        this.options.veryLowColour.setState(false);
        this.options.lowColour.setState(false);
        this.options.mediumColour.setState(true);
        this.options.fullColour.setEnabled(false);
        this.options.veryLowColour.setEnabled(false);
        this.options.lowColour.setEnabled(false);
        this.options.zrle.setState(this.currentEncoding == 16);
        this.options.hextile.setState(this.currentEncoding == 5);
        this.options.raw.setState(this.currentEncoding == 0);
        this.options.viewOnly.setState(this.viewer.viewOnly.getValue());
        this.options.acceptClipboard.setState(this.viewer.acceptClipboard.getValue());
        this.options.sendClipboard.setState(this.viewer.sendClipboard.getValue());
        if (this.state() == 6) {
            this.options.shared.setEnabled(false);
        } else {
            this.options.shared.setState(this.shared);
        }
        this.options.useLocalCursor.setState(this.viewer.useLocalCursor.getValue());
        this.options.fastCopyRect.setState(this.viewer.fastCopyRect.getValue());
    }

    public void getOptions() {
        int n;
        this.autoSelect = this.options.autoSelect.getState();
        this.fullColour = this.options.fullColour.getState();
        int n2 = this.options.zrle.getState() ? 16 : (n = this.options.hextile.getState() ? 5 : 0);
        if (n != this.currentEncoding) {
            this.currentEncoding = n;
            this.encodingChange = true;
        }
        this.viewer.viewOnly.setParam(this.options.viewOnly.getState());
        this.viewer.acceptClipboard.setParam(this.options.acceptClipboard.getState());
        this.viewer.sendClipboard.setParam(this.options.sendClipboard.getState());
        this.clipboardDialog.setSendingEnabled(this.viewer.sendClipboard.getValue());
        this.shared = this.options.shared.getState();
        this.setShared(this.shared);
        this.viewer.useLocalCursor.setParam(this.options.useLocalCursor.getState());
        if (this.cp.supportsLocalCursor != this.viewer.useLocalCursor.getValue()) {
            this.cp.supportsLocalCursor = this.viewer.useLocalCursor.getValue();
            this.encodingChange = true;
            if (this.desktop != null) {
                this.desktop.resetLocalCursor();
            }
        }
        this.viewer.fastCopyRect.setParam(this.options.fastCopyRect.getState());
        this.checkEncodings();
    }

    public synchronized void writeClientCutText(String string) {
        if (this.state() != 6) {
            return;
        }
        this.writer().writeClientCutText(string);
    }

    public synchronized void writeKeyEvent(int n, boolean bl) {
        if (this.state() != 6) {
            return;
        }
        this.writer().writeKeyEvent(n, bl);
    }

    public synchronized void writeKeyEvent(Event event) {
        int n;
        if (event.id != 401 && event.id != 403) {
            return;
        }
        if (event.id == 401) {
            vlog.debug("key press " + event.key);
            if (event.key < 32) {
                if ((event.modifiers & 2) != 0) {
                    n = event.key + 96;
                    if (n == 127) {
                        n = 95;
                    }
                } else {
                    switch (event.key) {
                        case 8: {
                            n = 65288;
                            break;
                        }
                        case 9: {
                            n = 65289;
                            break;
                        }
                        case 10: {
                            n = 65293;
                            break;
                        }
                        case 27: {
                            n = 65307;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            } else if (event.key == 127) {
                n = 65535;
            } else {
                n = UnicodeToKeysym.translate(event.key);
                if (n == -1) {
                    return;
                }
            }
        } else {
            vlog.debug("key action " + event.key);
            switch (event.key) {
                case 1000: {
                    n = 65360;
                    break;
                }
                case 1001: {
                    n = 65367;
                    break;
                }
                case 1002: {
                    n = 65365;
                    break;
                }
                case 1003: {
                    n = 65366;
                    break;
                }
                case 1004: {
                    n = 65362;
                    break;
                }
                case 1005: {
                    n = 65364;
                    break;
                }
                case 1006: {
                    n = 65361;
                    break;
                }
                case 1007: {
                    n = 65363;
                    break;
                }
                case 1008: {
                    n = 65470;
                    break;
                }
                case 1009: {
                    n = 65471;
                    break;
                }
                case 1010: {
                    n = 65472;
                    break;
                }
                case 1011: {
                    n = 65473;
                    break;
                }
                case 1012: {
                    n = 65474;
                    break;
                }
                case 1013: {
                    n = 65475;
                    break;
                }
                case 1014: {
                    n = 65476;
                    break;
                }
                case 1015: {
                    n = 65477;
                    break;
                }
                case 1016: {
                    n = 65478;
                    break;
                }
                case 1017: {
                    n = 65479;
                    break;
                }
                case 1018: {
                    n = 65480;
                    break;
                }
                case 1019: {
                    n = 65481;
                    break;
                }
                case 1020: {
                    n = 65377;
                    break;
                }
                case 1024: {
                    n = 65299;
                    break;
                }
                case 1025: {
                    n = 65379;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.writeModifiers(event.modifiers);
        this.writeKeyEvent(n, true);
        this.writeKeyEvent(n, false);
        this.writeModifiers(0);
    }

    public synchronized void writePointerEvent(Event event) {
        if (this.state() != 6) {
            return;
        }
        switch (event.id) {
            case 501: {
                this.buttonMask = 1;
                if ((event.modifiers & 8) != 0) {
                    this.buttonMask = 2;
                }
                if ((event.modifiers & 4) == 0) break;
                this.buttonMask = 4;
                break;
            }
            case 502: {
                this.buttonMask = 0;
                break;
            }
        }
        this.writeModifiers(event.modifiers & 0xFFFFFFF7 & 0xFFFFFFFB);
        if (event.x < 0) {
            event.x = 0;
        }
        if (event.x > this.cp.width - 1) {
            event.x = this.cp.width - 1;
        }
        if (event.y < 0) {
            event.y = 0;
        }
        if (event.y > this.cp.height - 1) {
            event.y = this.cp.height - 1;
        }
        this.writer().writePointerEvent(event.x, event.y, this.buttonMask);
        if (this.buttonMask == 0) {
            this.writeModifiers(0);
        }
    }

    void writeModifiers(int n) {
        if ((n & 1) != (this.pressedModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 2) != (this.pressedModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 8) != (this.pressedModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        if ((n & 4) != (this.pressedModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        this.pressedModifiers = n;
    }

    private synchronized void checkEncodings() {
        if (this.encodingChange && this.state() == 6) {
            vlog.info("Using " + Encodings.name(this.currentEncoding) + " encoding");
            this.writer().writeSetEncodings(this.currentEncoding, true);
            this.encodingChange = false;
        }
    }

    public CConn(VNCViewer vNCViewer) {
        int n;
        this.viewer = vNCViewer;
        this.currentEncoding = 16;
        this.lastUsedEncoding = 255;
        this.fullColour = this.viewer.fullColour.getValue();
        this.autoSelect = this.viewer.autoSelect.getValue();
        this.shared = this.viewer.shared.getValue();
        this.options = new OptionsDialog(this);
        this.about = new AboutDialog();
        this.info = new InfoDialog();
        this.clipboardDialog = new ClipboardDialog(this);
        this.setShared(this.shared);
        this.addSecType(1);
        this.addSecType(2);
        String string = this.viewer.preferredEncoding.getValue();
        if (string != null && (n = Encodings.num(string)) != -1) {
            this.currentEncoding = n;
            this.autoSelect = false;
        }
        this.cp.supportsDesktopResize = true;
        this.cp.supportsLocalCursor = this.viewer.useLocalCursor.getValue();
        this.menu = new F8Menu(this);
    }
}

