dnl acendian.m4 

dnl Copyright (C) 2000,2001 Erik de Castro Lopo (erikd@zip.com.au)

dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.


AC_DEFUN(AC_C_FIND_ENDIAN_NESS,
[AC_MSG_CHECKING(for endian-ness of target processor)
AC_CACHE_VAL(ac_cv_cpu_endian_ness,
[AC_REQUIRE([AC_CANONICAL_SYSTEM])

ac_cv_cpu_endian_ness="unknown"

case "$target_cpu" in
	alpha* | i?86 )
		ac_cv_cpu_endian_ness="little"
		;;
		
	hppa* | m68* | mips* | powerpc* | hppa* | sparc*)
		ac_cv_cpu_endian_ness="big"
		;;
esac

])
AC_MSG_RESULT($ac_cv_cpu_endian_ness)
if test $ac_cv_cpu_endian_ness = "big"; then  
	AC_DEFINE(GUESS_BIG_ENDIAN,1)
	AC_DEFINE(GUESS_LITTLE_ENDIAN,0)
elif test $ac_cv_cpu_endian_ness = "little"; then
	AC_DEFINE(GUESS_BIG_ENDIAN,0)
	AC_DEFINE(GUESS_LITTLE_ENDIAN,1)
else
	AC_DEFINE(GUESS_BIG_ENDIAN,0)
	AC_DEFINE(GUESS_LITTLE_ENDIAN,0)
	AC_MSG_WARN([*********************************************************])
	AC_MSG_WARN([*** Not able to determine endian-ness of processor.      ])
	AC_MSG_WARN([*** You will need to edit src/config.h before compiling. ])
	AC_MSG_WARN([*********************************************************])
fi

AC_SUBST(GUESS_BIG_ENDIAN)
AC_SUBST(GUESS_LITTLE_ENDIAN)
])
