catch {load vtktcl}
if { [catch {set VTK_TCL $env(VTK_TCL)}] != 0} { set VTK_TCL "../../examplesTcl" }
if { [catch {set VTK_DATA $env(VTK_DATA)}] != 0} { set VTK_DATA "../../../vtkdata" }

# Source the interactor that we will use for the TkRenderWidget
source $VTK_TCL/../graphics/examplesTcl/TkInteractor.tcl

# user interface command widget
source $VTK_TCL/vtkInt.tcl


vtkSphereSource sphere
  sphere SetThetaResolution 6
  sphere SetPhiResolution 5
  sphere Update

# get rid of the normals (deci does not handle normals properly yet).
vtkPolyData noNorms
  noNorms ShallowCopy [sphere GetOutput]
  [noNorms GetPointData] SetNormals {}

vtkQuadricDecimation deci
  deci SetInput noNorms
# max cost set to large number to ensure that we reach the maximum number of
# collapsed edges we set
  deci SetMaximumCost 1000000
  deci SetMaximumCollapsedEdges 1
#  deci DebugOn


vtkExtractEdges edges
  edges SetInput [deci GetOutput]

vtkTubeFilter tuber1
  tuber1 SetInput [edges GetOutput]
  tuber1 SetNumberOfSides 8
  tuber1 SetRadius 0.005

vtkPolyDataMapper tubeMapper1
  tubeMapper1 ImmediateModeRenderingOn
  tubeMapper1 SetInput [tuber1 GetOutput]
  
vtkActor tubeActor1
  tubeActor1 SetMapper tubeMapper1
  [tubeActor1 GetProperty] SetColor 0 0 1



vtkTubeFilter tuber
  tuber SetInput [deci GetTestOutput]
  tuber SetNumberOfSides 8
  tuber SetRadius 0.01

vtkPolyDataMapper tubeMapper
  tubeMapper ImmediateModeRenderingOn
  tubeMapper SetInput [tuber GetOutput]
  
vtkActor tubeActor
  tubeActor SetMapper tubeMapper
  [tubeActor GetProperty] SetColor 1 0 0

# ------------------- Create the UI ---------------------

# UI Variables
set ThetaRes 6
set PhiRes 5
set MaxCollapsedEdges 1



# prevent the tk window from showing up then start the event loop
wm withdraw .

# Create the toplevel window
toplevel .top
wm title .top {Testing vtkQuadricDecimation}

# Create some frames
frame .top.f1 
frame .top.f2
pack .top.f1 .top.f2 -side top -expand 1 -fill both

vtkRenderWindow renWin
vtkTkRenderWidget .top.f1.rw -width 400 -height 400 -rw renWin
BindTkRenderWidget .top.f1.rw
pack .top.f1.rw -expand 1 -fill both

# create a rendering window and renderer
vtkRenderer ren1
    renWin AddRenderer ren1

scale .top.f2.s1 -label " Phi Resolution: " -orient horizontal \
	-length 200 -from 3 -to 50 -variable PhiRes 
scale .top.f2.s2 -label " ThetaResolution: " -orient horizontal \
	-length 200 -from 3 -to 50 -variable ThetaRes 
scale .top.f2.s3 -label " EdgeCollapsed: " -orient horizontal \
	-length 200 -from 0 -to 100 -variable MaxCollapsedEdges

pack .top.f2.s1 .top.f2.s2 .top.f2.s3 -side top -expand 1 -fill both

button .top.f2.b1 -text "Quit" -command {exit}
pack .top.f2.b1  -expand 1 -fill x

bind .top.f2.s1 <ButtonRelease> {
   sphere SetPhiResolution $PhiRes

   # get rid of the normals (deci does not handle normals properly yet).
   sphere Update
   noNorms ShallowCopy [sphere GetOutput]
   [noNorms GetPointData] SetNormals {}

   renWin Render

   set num [[deci GetInput] GetNumberOfCells]
   .top.f2.s3 configure -to $num
}

bind .top.f2.s2 <ButtonRelease> { 
   sphere SetThetaResolution $ThetaRes

   # get rid of the normals (deci does not handle normals properly yet).
   sphere Update
   noNorms ShallowCopy [sphere GetOutput]
   [noNorms GetPointData] SetNormals {}

   renWin Render
   set num [[deci GetInput] GetNumberOfCells]
   .top.f2.s3 configure -to $num
}

bind .top.f2.s3 <ButtonRelease> {
   deci SetMaximumCollapsedEdges $MaxCollapsedEdges
   renWin Render
}


vtkPolyDataMapper mapper
  mapper ImmediateModeRenderingOn
  mapper SetInput [deci GetOutput]
vtkActor actor
  actor SetMapper mapper


# Add the actors to the renderer, set the background and size
#
ren1 AddActor actor
ren1 AddActor tubeActor1
ren1 AddActor tubeActor

ren1 SetBackground 1 1 1
