/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.util.interpolator.ColorInterpolator;

public class ColorRampGenerator {
    private static final String LENGTH_MSG = "Ramp and height arrays not same length";
    private static final String HEIGHT_LENGTH_MSG = "Height array length is smaller than the given size";
    private static final String RAMP_LENGTH_MSG = "Ramp array length is smaller than the given size";
    private ColorInterpolator interpolator;
    private boolean hasAlpha;

    public ColorRampGenerator() {
        this.hasAlpha = false;
        this.interpolator = new ColorInterpolator(2);
        this.interpolator.addRGBKeyFrame(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.interpolator.addRGBKeyFrame(0.5f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public ColorRampGenerator(float[] fArray, Color3f[] color3fArray) {
        this.setColorRamp(fArray, color3fArray);
    }

    public ColorRampGenerator(float[] fArray, Color4f[] color4fArray) {
        this.setColorRamp(fArray, color4fArray);
    }

    public ColorRampGenerator(float[] fArray, float[][] fArray2) {
        this.setColorRamp(fArray, fArray2);
    }

    public ColorRampGenerator(float[] fArray, float[] fArray2, boolean bl) {
        this.setColorRamp(fArray, fArray2, bl);
    }

    public void setColorRamp(float[] fArray, Color3f[] color3fArray) {
        if (fArray.length != color3fArray.length) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.hasAlpha = false;
        this.interpolator = new ColorInterpolator(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.interpolator.addRGBKeyFrame(fArray[i], color3fArray[i].x, color3fArray[i].y, color3fArray[i].z, 0.0f);
        }
    }

    public void setColorRamp(float[] fArray, Color4f[] color4fArray) {
        if (fArray.length != color4fArray.length) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.hasAlpha = true;
        this.interpolator = new ColorInterpolator(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.interpolator.addRGBKeyFrame(fArray[i], color4fArray[i].x, color4fArray[i].y, color4fArray[i].z, color4fArray[i].w);
        }
    }

    public void setColorRamp(float[] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.setColorRamp(fArray, fArray2, fArray.length);
    }

    public void setColorRamp(float[] fArray, float[][] fArray2, int n) {
        if (fArray.length < n) {
            throw new IllegalArgumentException(HEIGHT_LENGTH_MSG);
        }
        if (fArray2.length < n) {
            throw new IllegalArgumentException(RAMP_LENGTH_MSG);
        }
        this.hasAlpha = fArray2[0].length != 3;
        this.interpolator = new ColorInterpolator(n);
        if (this.hasAlpha) {
            for (int i = 0; i < n; ++i) {
                this.interpolator.addRGBKeyFrame(fArray[i], fArray2[i][0], fArray2[i][1], fArray2[i][2], fArray2[i][3]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.interpolator.addRGBKeyFrame(fArray[i], fArray2[i][0], fArray2[i][1], fArray2[i][2], 0.0f);
            }
        }
    }

    public void setColorRamp(float[] fArray, float[] fArray2, boolean bl) {
        if (bl ? fArray.length != fArray2.length / 4 : fArray.length != fArray2.length / 3) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.setColorRamp(fArray, fArray2, fArray.length, bl);
    }

    public void setColorRamp(float[] fArray, float[] fArray2, int n, boolean bl) {
        if (fArray.length < n) {
            throw new IllegalArgumentException(HEIGHT_LENGTH_MSG);
        }
        if (bl && fArray2.length / 4 < n || !bl && fArray2.length / 3 < n) {
            throw new IllegalArgumentException(RAMP_LENGTH_MSG);
        }
        this.hasAlpha = bl;
        this.interpolator = new ColorInterpolator(fArray.length);
        int n2 = 0;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.interpolator.addRGBKeyFrame(fArray[i], fArray2[n2++], fArray2[n2++], fArray2[n2++], fArray2[n2++]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.interpolator.addRGBKeyFrame(fArray[i], fArray2[n2++], fArray2[n2++], fArray2[n2++], 0.0f);
            }
        }
    }

    public void generate(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.vertexCount == 0) {
            return;
        }
        int n = geometryData.vertexCount * 3;
        if (this.hasAlpha) {
            n += geometryData.vertexCount;
        }
        if (geometryData.colors != null && geometryData.colors.length < n) {
            throw new InvalidArraySizeException("Color array", geometryData.colors.length, n);
        }
        if (geometryData.colors == null) {
            geometryData.colors = new float[n];
        }
        float[] fArray = geometryData.coordinates;
        float[] fArray2 = geometryData.colors;
        if (this.hasAlpha) {
            int n2 = n - 1;
            for (int i = n * 3 / 4 - 2; i > 0; i -= 3) {
                float[] fArray3 = this.interpolator.floatRGBValue(fArray[i]);
                fArray2[n2--] = fArray3[3];
                fArray2[n2--] = fArray3[2];
                fArray2[n2--] = fArray3[1];
                fArray2[n2--] = fArray3[0];
            }
        } else {
            for (int i = n - 2; i > 0; i -= 3) {
                float[] fArray4 = this.interpolator.floatRGBValue(fArray[i]);
                fArray2[i + 1] = fArray4[2];
                fArray2[i] = fArray4[1];
                fArray2[i - 1] = fArray4[0];
            }
        }
    }
}

