/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.StringReader;
import java.util.HashMap;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.TokenMgrError;
import org.web3d.parser.x3d.X3DFieldParser;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.sav.Locator;

public class X3DFieldReader
implements VRMLFieldReader {
    private boolean useLowerBoolean = false;
    private X3DFieldParser fieldParser;
    private Object mutex;
    private StringBuffer sBuff;
    private static HashMap upperBooleanMap = new HashMap();
    private static HashMap lowerBooleanMap;
    private Locator locator;

    public X3DFieldReader() {
        StringReader stringReader = new StringReader("");
        this.fieldParser = new X3DFieldParser(stringReader);
        this.sBuff = new StringBuffer();
        this.mutex = new Object();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setCaseSensitive(boolean bl) {
        this.useLowerBoolean = !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseUnknownField(String string, boolean bl) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        Object object = null;
        try {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.fieldParser.ReInit(stringReader);
                object = this.fieldParser.parseUnknownField(bl);
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing unknown field type value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SFInt32(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int n = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                n = this.fieldParser.SFInt32();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFInt32 field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFInt32(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int[] nArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                nArray = this.fieldParser.MFInt32();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFInt32 field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFInt32(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = Integer.parseInt(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFInt32 field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFInt32 field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long SFLong(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        long l = 0L;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                l = this.fieldParser.SFLong();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFLong field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] MFLong(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        long[] lArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                lArray = this.fieldParser.MFLong();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFLong field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] MFLong(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        long[] lArray = new long[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    lArray[n2] = Long.parseLong(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFLong field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFLong field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float SFFloat(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float f = 0.0f;
        if ((string == null ? 0 : string.length()) == 0) {
            return f;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                f = this.fieldParser.SFFloat();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFFloat field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFFloat(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFFloat();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFFloat field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFFloat(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFFloat field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFFloat field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double SFDouble(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double d = 0.0;
        if ((string == null ? 0 : string.length()) == 0) {
            return d;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                d = this.fieldParser.SFDouble();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFDouble field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFDouble(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFDouble();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFDouble field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFDouble(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFDouble field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFDouble field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SFBool(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        if ((string == null ? 0 : string.length()) == 0) {
            return bl;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                bl = this.useLowerBoolean ? this.fieldParser.SFBoolLower() : this.fieldParser.SFBool();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFBool field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] MFBool(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        boolean[] blArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                blArray = this.useLowerBoolean ? this.fieldParser.MFBoolLower() : this.fieldParser.MFBool();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFBool field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return blArray;
    }

    public boolean[] MFBool(String[] stringArray) throws InvalidFieldFormatException {
        boolean[] blArray = new boolean[stringArray.length];
        HashMap hashMap = this.useLowerBoolean ? lowerBooleanMap : upperBooleanMap;
        for (int i = 0; i < stringArray.length; ++i) {
            Boolean bl = (Boolean)hashMap.get(stringArray[i]);
            if (bl == null) {
                throw new InvalidFieldFormatException("Invalid boolean in MFBool field: '" + stringArray[i] + "'");
            }
            blArray[i] = bl;
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String SFString(String string) throws InvalidFieldFormatException {
        String string2 = string;
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (string.charAt(0) != '\"') {
                    this.sBuff.setLength(0);
                    this.sBuff.append("\"");
                    this.sBuff.append(string);
                    this.sBuff.append("\"");
                    string = this.sBuff.toString();
                }
                StringReader stringReader = new StringReader(string);
                this.fieldParser.ReInit(stringReader);
                string2 = this.fieldParser.SFString();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFString field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] MFString(String string) throws InvalidFieldFormatException {
        String[] stringArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (string.length() == 0 || string.charAt(0) != '\"') {
                    this.sBuff.setLength(0);
                    this.sBuff.append("\"");
                    this.sBuff.append(string);
                    this.sBuff.append("\"");
                    string = this.sBuff.toString();
                }
                StringReader stringReader = new StringReader(string);
                this.fieldParser.ReInit(stringReader);
                stringArray = this.fieldParser.MFString();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFString field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return stringArray;
    }

    public String[] MFString(String[] stringArray) throws InvalidFieldFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return this.MFString(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec2f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFVec2f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec2f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec2f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[2];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec2f field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec2f field: " + stringArray[1]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec2f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFVec2f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec2f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec2f(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec2f field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec2f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec2d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return dArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.SFVec2d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec2d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec2d(String[] stringArray) throws InvalidFieldFormatException {
        double[] dArray = new double[2];
        Object object = this.mutex;
        synchronized (object) {
            try {
                dArray[0] = Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid doubleing point value in SFVec2d field: " + stringArray[0]);
            }
            try {
                dArray[1] = Double.parseDouble(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid doubleing point value in SFVec2d field: " + stringArray[1]);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec2d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFVec2d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec2d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec2d(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec2d field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec2d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFVec3f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec3f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec3f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[3];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec3f field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec3f field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec3f field: " + stringArray[2]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFVec3f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec3f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec3f(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec3f field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec3f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec3d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return dArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFVec3d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec3d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec3d(String[] stringArray) throws InvalidFieldFormatException {
        double[] dArray = new double[3];
        Object object = this.mutex;
        synchronized (object) {
            try {
                dArray[0] = Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid doubleing point value in SFVec3d field: " + stringArray[0]);
            }
            try {
                dArray[1] = Double.parseDouble(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid doubleing point value in SFVec3d field: " + stringArray[1]);
            }
            try {
                dArray[2] = Double.parseDouble(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid doubleing point value in SFVec3d field: " + stringArray[2]);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec3d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFVec3d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec3d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec3d(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec3d field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec3d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec4f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFRotation();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec4f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec4f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[4];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4f field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4f field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4f field: " + stringArray[2]);
            }
            try {
                fArray[3] = Float.parseFloat(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4f field: " + stringArray[3]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec4f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFVec4f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec4f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec4f(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec4f field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec4f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec4d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return dArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.SFVec4d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFVec4d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFVec4d(String[] stringArray) throws InvalidFieldFormatException {
        double[] dArray = new double[4];
        Object object = this.mutex;
        synchronized (object) {
            try {
                dArray[0] = Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4d field: " + stringArray[0]);
            }
            try {
                dArray[1] = Double.parseDouble(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4d field: " + stringArray[1]);
            }
            try {
                dArray[2] = Double.parseDouble(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4d field: " + stringArray[2]);
            }
            try {
                dArray[3] = Double.parseDouble(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFVec4d field: " + stringArray[3]);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec4d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFVec4d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec4d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFVec4d(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec4d field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFVec4d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFRotation(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFRotation();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFRotation field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFRotation(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[4];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[2]);
            }
            try {
                fArray[3] = Float.parseFloat(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[3]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFRotation(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFRotation();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFRotation field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFRotation(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFRotation field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFRotation field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double SFTime(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double d = 0.0;
        if ((string == null ? 0 : string.length()) == 0) {
            return d;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                d = this.fieldParser.SFTime();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFTime field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFTime(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFTime();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFTime field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFTime(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFTime field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFTime field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColor(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFColor();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFColor field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColor(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[3];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[2]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColor(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFColor();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFColor field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColor(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFColor field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFColor field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColorRGBA(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFColorRGBA();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFColorRGBA field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColorRGBA(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[4];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColorRGBA field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColorRGBA field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColorRGBA field: " + stringArray[2]);
            }
            try {
                fArray[3] = Float.parseFloat(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColorRGBA field: " + stringArray[3]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColorRGBA(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFColorRGBA();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFColorRGBA field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColorRGBA(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFColorRGBA field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFColorRGBA field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SFImage(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int[] nArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return nArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                nArray = this.fieldParser.SFImage();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFImage field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SFImage(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = Integer.parseInt(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in SFImage field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFImage field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFImage(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int[] nArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                nArray = this.fieldParser.MFImage();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFImage field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFImage(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = Integer.parseInt(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFImage field: " + stringArray[n2]);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFImage field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFMatrix3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFMatrix3f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFMatrix3f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFMatrix3f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[9];
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < 9; ++i) {
                try {
                    fArray[i] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidFieldFormatException("Invalid floating point value in SFMatrix3f field: " + stringArray[i]);
                }
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFMatrix3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFMatrix3f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFMatrix3f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFMatrix3f(String[] stringArray) throws InvalidFieldFormatException {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n % 9 != 0) {
            throw new InvalidFieldFormatException("MFMatrix3f must have a multiple of 9 values defined");
        }
        float[] fArray = new float[n];
        int n3 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n3 = 0; n3 < n; ++n3) {
                    fArray[n3] = Float.parseFloat(stringArray[n3]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFMatrix3f field: " + stringArray[n3]);
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFMatrix3d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return dArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.SFMatrix3d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFMatrix3d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFMatrix3d(String[] stringArray) throws InvalidFieldFormatException {
        double[] dArray = new double[9];
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < 9; ++i) {
                try {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidFieldFormatException("Invalid floating point value in SFMatrix3d field: " + stringArray[i]);
                }
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFMatrix3d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFMatrix3d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFMatrix3d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFMatrix3d(String[] stringArray) throws InvalidFieldFormatException {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n % 9 != 0) {
            throw new InvalidFieldFormatException("MFMatrix3d must have a multiple of 9 values defined");
        }
        double[] dArray = new double[n];
        int n3 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3] = Double.parseDouble(stringArray[n3]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFMatrix3d field: " + stringArray[n3]);
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFMatrix4f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return fArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFMatrix4f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFMatrix4f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFMatrix4f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[16];
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < 16; ++i) {
                try {
                    fArray[i] = Float.parseFloat(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidFieldFormatException("Invalid floating point value in SFMatrix4f field: " + stringArray[i]);
                }
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFMatrix4f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFMatrix4f();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFMatrix4f field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFMatrix4f(String[] stringArray) throws InvalidFieldFormatException {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n % 16 != 0) {
            throw new InvalidFieldFormatException("MFMatrix4f must have a multiple of 16 values defined");
        }
        float[] fArray = new float[n];
        int n3 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n3 = 0; n3 < n; ++n3) {
                    fArray[n3] = Float.parseFloat(stringArray[n3]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFMatrix4f field: " + stringArray[n3]);
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFMatrix4d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        if ((string == null ? 0 : string.length()) == 0) {
            return dArray;
        }
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.SFMatrix4d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing SFMatrix4d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] SFMatrix4d(String[] stringArray) throws InvalidFieldFormatException {
        double[] dArray = new double[16];
        Object object = this.mutex;
        synchronized (object) {
            for (int i = 0; i < 16; ++i) {
                try {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidFieldFormatException("Invalid floating point value in SFMatrix4d field: " + stringArray[i]);
                }
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFMatrix4d(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFMatrix4d();
            }
        }
        catch (ParseException parseException) {
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFieldFormatException("Invalid field value encountered when parsing MFMatrix4d field value", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFMatrix4d(String[] stringArray) throws InvalidFieldFormatException {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (n % 16 != 0) {
            throw new InvalidFieldFormatException("MFMatrix4d must have a multiple of 16 values defined");
        }
        double[] dArray = new double[n];
        int n3 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3] = Double.parseDouble(stringArray[n3]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFMatrix4d field: " + stringArray[n3]);
        }
        return dArray;
    }

    static {
        upperBooleanMap.put("TRUE", Boolean.TRUE);
        upperBooleanMap.put("FALSE", Boolean.FALSE);
        lowerBooleanMap = new HashMap();
        lowerBooleanMap.put("true", Boolean.TRUE);
        lowerBooleanMap.put("false", Boolean.FALSE);
    }
}

