#include "api.h"

#include <qregexp.h>

API::API()
{
	initCommand();
}

void API::initCommand()
{
	com="";
	paramList.clear();
	errorString="";
	noErr=true;
}

void API::parseCommand (const QString &s)
{
	initCommand();
	QRegExp re;
	int pos;

	// Get command
	re.setPattern ("(.*)\\s");
	re.setMinimal (true);
	pos=re.search (s);
	if (pos>=0)
		com=re.cap(1);

	// Get parameters
	paramList.clear();
	re.setPattern ("\\((.*)\\)");
	pos=re.search (s);
	if (pos>=0)
	{
		QString s=re.cap(1);
		QString a;
		bool inquote=false;
		pos=0;
		if (!s.isEmpty())
		{
			while (pos<s.length())
			{
				if (s.at(pos)=='\"') 
				{
					if (inquote)
						inquote=false;
					else	
						inquote=true;
				}

				if (s.at(pos)==',' && !inquote)
				{
					a=s.left(pos);
					paramList.append(a);
					s=s.right(s.length()-pos-1);
					pos=0;
				} else
					pos++;
				
			}
			paramList.append (s);
		}	
	}	
}

QString API::command()
{
	return com;
}

QStringList API::parameters()
{
	return paramList;
}

QString API::errorDesc()
{
	return errorString;
}

bool API::error()
{
	// invert noErr
	return (noErr) ?false:true;
}

void API::setError(const QString &e)
{
	noErr=false;
	errorString=e;
}

bool API::checkParamCount (const uint &expected)
{
	if (paramList.count()!=expected)
	{
		errorString=QString("expected %1 parameters, but got %2").arg(expected).arg(paramList.count());
		noErr=false;
	} else 
		noErr=true;
	return noErr;	
}

bool API::checkParamIsInt(const uint &index)
{
	bool ok;
	if (index > paramList.count())
	{
		errorString =QString("Parameter index %1 is outside of parameter list").arg(index);
		noErr=false;
	} else
	{
		paramList[index].toInt (&ok, 10);
		if (!ok)
		{
			errorString=QString("Parameter %1 is not an integer").arg(index);
			noErr=false;
		} else
			noErr=true;
	}	
	return noErr;
}

int API::parInt (bool &ok,const uint &index)
{
	if (checkParamIsInt (index))
	{
		return paramList[index].toInt (&ok, 10);
	}
	ok=false;
	return 0;
}

QString API::parString (bool &ok,const uint &index)
{
	// return the string at index, this could be also stored in
	// a variable later
	QString r;
	QRegExp re("\"(.*)\"");
	int pos=re.search (paramList[index]);
	if (pos>=0)
		r=re.cap (1);
	else	
		r="";
	ok=true;
	return r;
}
