#ifndef DEFAULT_SCHEDULING_MANAGER_H
#define DEFAULT_SCHEDULING_MANAGER_H

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include "warped.h"
#include "SchedulingManager.h"

class SimulationObject;
class TimeWarpSimulationManager;

/** The DefaultSchedulingManager */
class DefaultSchedulingManager :  public SchedulingManager {
public:
  DefaultSchedulingManager( TimeWarpSimulationManager *initSimulationManager );
  ~DefaultSchedulingManager();
  
  const Event *peekNextEvent();

  const VTime &getLastEventScheduledTime();

  void configure(SimulationConfiguration &){}

private:
  void setLastScheduledEventTime( const VTime &newTime );

  TimeWarpSimulationManager *mySimulationManager;
  const VTime *lastScheduledTime;
};

#endif
