// Displays all alt attributes
function webdeveloper_displayAltAttributes(element, applyStyle)
{
    var checked             = element.getAttribute("checked");
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var pageDocument        = null;
    var spanElement         = null;
    var spanElementList     = null;
    var spanElementsLength  = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];

        // If the element is checked
        if(checked)
        {
            imageElementList    = pageDocument.getElementsByTagName("img");
            imageElementsLength = imageElementList.length;

            // Loop through all the img tags
            for(var j = 0; j < imageElementsLength; j++)
            {
                imageElement = imageElementList[j];

                // If the alt attribute is set
                if(imageElement.hasAttribute("alt"))
                {
                    spanElement = pageDocument.createElement("span");

                    spanElement.setAttribute("class", "webdeveloper-alt-attribute");
                    spanElement.appendChild(pageDocument.createTextNode("Alt=" + imageElement.getAttribute("alt")));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }
            }
        }
        else
        {
            spanElementList    = pageDocument.getElementsByTagName("span");
            spanElementsLength = spanElementList.length;

            // Loop through all the span tags
            for(j = 0; j < spanElementsLength; j++)
            {
                spanElement = spanElementList[j];

                // If the span element is set and the class exists and is set to webdeveloper-alt-attribute
                if(spanElement && spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-alt-attribute")
                {
                    spanElement.parentNode.removeChild(spanElement);
                    j--;
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/tooltips.css", "webdeveloper-display-alt-attributes", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-alt-attributes-tooltips", "span.webdeveloper-alt-attribute");
}

// Displays all image dimensions
function webdeveloper_displayImageDimensions(element, applyStyle)
{
    var checked             = element.getAttribute("checked");
    var dimensions          = null;
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var height              = null;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var pageDocument        = null;
    var spanElement         = null;
    var spanElementList     = null;
    var spanElementsLength  = null;
    var stringBundle        = document.getElementById("webdeveloper-string-bundle");
    var heightText          = stringBundle.getString("webdeveloper_height");
    var width               = null;
    var widthText           = stringBundle.getString("webdeveloper_width");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If the element is checked
        if(checked)
        {
            imageElementList    = pageDocument.getElementsByTagName("img");
            imageElementsLength = imageElementList.length;

            // Loop through all the img tags
            for(var j = 0; j < imageElementsLength; j++)
            {
                dimensions   = null;
                imageElement = imageElementList[j];

                // If the image has a width attribute
                if(imageElement.hasAttribute("width"))
                {
                    width = imageElement.getAttribute("width");
                }
                else
                {
                    width = imageElement.naturalWidth;
                }

                // If the image has a height attribute
                if(imageElement.hasAttribute("height"))
                {
                    height = imageElement.getAttribute("height");
                }
                else
                {
                    height = imageElement.naturalHeight;
                }

                // If the width and height are set
                if(width && height)
                {
                    dimensions = width + "x" + height;
                }
                else if(width)
                {
                    dimensions = widthText + "=" + width;
                }
                else if(height)
                {
                    dimensions = heightText + "=" + height;
                }

                // If the dimensions are set
                if(dimensions)
                {
                    spanElement = pageDocument.createElement("span");

                    spanElement.setAttribute("class", "webdeveloper-image-dimensions");
                    spanElement.appendChild(pageDocument.createTextNode(dimensions));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }

                height = null;
                width  = null;
            }
        }
        else
        {
            spanElementList    = pageDocument.getElementsByTagName("span");
            spanElementsLength = spanElementList.length;

            // Loop through all the span tags
            for(j = 0; j < spanElementsLength; j++)
            {
                spanElement = spanElementList[j];

                // If the span element is set and the class exists and is set to webdeveloper-image-dimensions
                if(spanElement && spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-image-dimensions")
                {
                    spanElement.parentNode.removeChild(spanElement);
                    j--;
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/tooltips.css", "webdeveloper-display-image-dimensions", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-dimensions-tooltips", "span.webdeveloper-image-dimensions");
}

// Displays all image file sizes
function webdeveloper_displayImageFileSizes(element, applyStyle)
{
    var checked             = element.getAttribute("checked");
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var fileSize            = null;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var pageDocument        = null;
    var spanElement         = null;
    var spanElementList     = null;
    var spanElementsLength  = null;
    var stringBundle        = document.getElementById("webdeveloper-string-bundle");
    var fileSizeText        = stringBundle.getString("webdeveloper_fileSize");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If the element is checked
        if(checked)
        {
            imageElementList    = pageDocument.getElementsByTagName("img");
            imageElementsLength = imageElementList.length;

            // Loop through all the img tags
            for(var j = 0; j < imageElementsLength; j++)
            {
                imageElement = imageElementList[j];
                fileSize     = webdeveloper_getFileSize(imageElement.src);

                // If there is a file size
                if(fileSize)
                {
                    spanElement = pageDocument.createElement("span");

                    spanElement.setAttribute("class", "webdeveloper-image-file-size");
                    spanElement.appendChild(pageDocument.createTextNode(fileSizeText + "=" + webdeveloper_formatFileSize(fileSize)));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }
            }
        }
        else
        {
            spanElementList    = pageDocument.getElementsByTagName("span");
            spanElementsLength = spanElementList.length;

            // Loop through all the span tags
            for(j = 0; j < spanElementsLength; j++)
            {
                spanElement = spanElementList[j];

                // If the span element is set and the class exists and is set to webdeveloper-image-file-size
                if(spanElement && spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-image-file-size")
                {
                    spanElement.parentNode.removeChild(spanElement);
                    j--;
                }
            }
        }

    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/tooltips.css", "webdeveloper-display-image-file-sizes", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-file-sizes-tooltips", "span.webdeveloper-image-file-size");
}

// Displays all image paths
function webdeveloper_displayImagePaths(element, applyStyle)
{
    var checked             = element.getAttribute("checked");
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var pageDocument        = null;
    var spanElement         = null;
    var spanElementList     = null;
    var spanElementsLength  = null;
    var src                 = null;
    var stringBundle        = document.getElementById("webdeveloper-string-bundle");
    var srcText             = stringBundle.getString("webdeveloper_src");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If the element is checked
        if(checked)
        {
            imageElementList    = pageDocument.getElementsByTagName("img");
            imageElementsLength = imageElementList.length;

            // Loop through all the img tags
            for(var j = 0; j < imageElementsLength; j++)
            {
                imageElement = imageElementList[j];
                spanElement  = pageDocument.createElement("span");
                src          = imageElement.getAttribute("src");

                // If the src is set
                if(src)
                {
                    spanElement.setAttribute("class", "webdeveloper-image-path");
                    spanElement.appendChild(pageDocument.createTextNode(srcText + "=" + src));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }
            }
        }
        else
        {
            spanElementList    = pageDocument.getElementsByTagName("span");
            spanElementsLength = spanElementList.length;

            // Loop through all the span tags
            for(j = 0; j < spanElementsLength; j++)
            {
                spanElement = spanElementList[j];

                // If the span element is set and the class exists and is set to webdeveloper-image-path
                if(spanElement && spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-image-path")
                {
                    spanElement.parentNode.removeChild(spanElement);
                    j--;
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/tooltips.css", "webdeveloper-display-image-paths", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-paths-tooltips", "span.webdeveloper-image-path");
}

// Finds all the broken images on the page
function webdeveloper_findBrokenImages()
{
    var cacheDisabled     = !webdeveloper_getBooleanPreference("browser.cache.disk.enable", false) && !webdeveloper_getBooleanPreference("browser.cache.memory.enable", false);
    var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength    = documentList.length;
    var documentURL       = null;
    var image             = null;
    var imageLength       = null;
    var imageList         = null;
    var imageSrc          = null;
    var linkElement       = null;
    var listElement       = null;
    var listItemElement   = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var headerElement     = generatedDocument.createElement("h1");
    var pageDocument      = null;
    var pElement          = null;
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var title             = stringBundle.getFormattedString("webdeveloper_findBrokenImagesTitle", [oldURL]);

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    generatedDocument.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        headerElement = generatedDocument.createElement("h2");
        linkElement   = generatedDocument.createElement("a");
        listElement   = generatedDocument.createElement("ol");
        pageDocument  = documentList[i];
        documentURL   = pageDocument.documentURI;
        imageList     = webdeveloper_getImagesForDocument(pageDocument, !cacheDisabled, false);
        imageLength   = imageList.length;

        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedDocument.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        generatedDocument.body.appendChild(headerElement);

        // Loop through all the images
        for(var j = 0; j < imageLength; j++)
        {
            image    = imageList[j];
            imageSrc = image.src;

            // If the image is broken
            if(!image.naturalWidth && !image.naturalHeight)
            {
                listItemElement = generatedDocument.createElement("li");
                linkElement     = generatedDocument.createElement("a");

                linkElement.setAttribute("href", imageSrc);
                linkElement.appendChild(generatedDocument.createTextNode(imageSrc));
                listItemElement.appendChild(linkElement);
                listElement.appendChild(listItemElement);
            }
        }

        // If there are no broken images
        if(listElement.hasChildNodes())
        {
            generatedDocument.body.appendChild(listElement);
        }
        else
        {
            pElement = generatedDocument.createElement("p");

            pElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_noBrokenImages")));
            generatedDocument.body.appendChild(pElement);
        }
    }

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Hides/shows all background images
function webdeveloper_hideBackgroundImages(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/hide_background_images.css", "webdeveloper-hide-background-images", applyStyle);
}

// Hides/shows all the images
function webdeveloper_hideImages(element, id, applyStyle)
{
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var hide                = element.getAttribute("checked");
    var inputElement        = null;
    var inputElementList    = null;
    var inputElementsLength = null;
    var pageDocument        = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        inputElementsLength = inputElementList.length;

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement = inputElementList[j];

            // If hiding images and the element is an image
            if(hide && inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "image")
            {
                inputElement.className += " webdeveloper-image";

                inputElement.setAttribute("type", "submit");
            }
            else if(inputElement.className.indexOf("webdeveloper-image") != -1)
            {
                inputElement.className = webdeveloper_removeSubstring(inputElement.className, "webdeveloper-image");

                inputElement.setAttribute("type", "image");
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/hide_images.css", id, applyStyle);
}

// Makes all the images full size
function webdeveloper_makeImagesFullSize()
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var image          = null;
    var imageLength    = null;
    var imageList      = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        imageList    = pageDocument.getElementsByTagName("img");
        imageLength  = imageList.length;

        // Loop through all the images
        for(var j = 0; j < imageLength; j++)
        {
            image = imageList[j];

            // If the image width is set
            if(image.hasAttribute("width"))
            {
                image.removeAttribute("width");
            }

            // If the image height is set
            if(image.hasAttribute("height"))
            {
                image.removeAttribute("height");
            }
        }
    }
}

// Makes all the images invisible
function webdeveloper_makeImagesInvisible(element, id, applyStyle)
{
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var image               = null;
    var imageLength         = null;
    var imageList           = null;
    var inputElement        = null;
    var inputElementList    = null;
    var inputElementsLength = null;
    var invisible           = element.getAttribute("checked");
    var pageDocument        = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        imageList           = pageDocument.getElementsByTagName("img");
        imageLength         = imageList.length;
        inputElementList    = pageDocument.getElementsByTagName("input");
        inputElementsLength = inputElementList.length;

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement = inputElementList[j];

            // If making images invisible and the element is an image
            if(invisible && inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "image")
            {
                inputElement.className += " webdeveloper-image";

                inputElement.setAttribute("type", "submit");
            }
            else if(inputElement.className.indexOf("webdeveloper-image") != -1)
            {
                inputElement.className = webdeveloper_removeSubstring(inputElement.className, "webdeveloper-image");

                inputElement.setAttribute("type", "image");
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }

        // Loop through all the images
        for(j = 0; j < imageLength; j++)
        {
            image = imageList[j];

            // If making images invisible
            if(invisible)
            {
                // If the image width is not set and the image is not broken
                if(!image.hasAttribute("width") && image.naturalWidth)
                {
                    image.setAttribute("width", image.naturalWidth);
                }

                // If the image height is not set and the image is not broken
                if(!image.hasAttribute("height") && image.naturalHeight)
                {
                    image.setAttribute("height", image.naturalHeight);
                }

                image.setAttribute("src", "chrome://webdeveloper/content/images/spacer.gif?" + image.getAttribute("src"));
            }
            else
            {
                image.setAttribute("src", webdeveloper_removeSubstring(image.getAttribute("src"), "chrome://webdeveloper/content/images/spacer.gif?"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/make_images_invisible.css", id, applyStyle);
}

// Outlines all images
function webdeveloper_outlineAllImages(element, applyStyle)
{
    webdeveloper_outlineBackgroundImages(element, false, applyStyle);
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_all_images.css", "webdeveloper-outline-all-images", applyStyle);
}

// Outlines all background images
function webdeveloper_outlineBackgroundImages(element, toggleStyleSheet, applyStyle)
{
    var backgroundImage = null;
    var checked         = element.getAttribute("checked");
    var cssURI          = CSSPrimitiveValue.CSS_URI;
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var node            = null;
    var pageDocument    = null;
    var treeWalker      = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        treeWalker   = pageDocument.createTreeWalker(pageDocument.body, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((node = treeWalker.nextNode()) != null)
        {
            backgroundImage = node.ownerDocument.defaultView.getComputedStyle(node, null).getPropertyCSSValue("background-image");

            // If this element has a background image and it is a URL
            if(backgroundImage && backgroundImage.primitiveType == cssURI)
            {
                // If the element is checked
                if(checked)
                {
                    // If the style sheet should be toggled
                    if(toggleStyleSheet)
                    {
                        node.style.MozOutline = "1px solid #ff0000";
                    }
                    else
                    {
                        node.style.MozOutline = "1px solid #0000ff";
                    }
                }
                else
                {
                    webdeveloper_removeElementOutline(node);
                }
            }
        }
    }

    // If the style sheet should be toggled
    if(toggleStyleSheet)
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-outline-background-images", applyStyle);
    }
}

// Outlines all the images with adjusted dimensions
function webdeveloper_outlineImagesWithAdjustedDimensions(element, applyStyle)
{
    var checked             = element.getAttribute("checked");
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var naturalHeight       = null;
    var naturalWidth        = null;
    var pageDocument        = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        imageElementList    = pageDocument.getElementsByTagName("img");
        imageElementsLength = imageElementList.lenghth;

        // Loop through all the img tags
        for(var j = 0; j < imageElementsLength; j++)
        {
            imageElement  = imageElementList[j];
            naturalHeight = imageElement.naturalHeight;
            naturalWidth  = imageElement.naturalWidth;

            // If outlining
            if(checked)
            {
                // If the width or height has been adjusted
                if((naturalWidth && imageElement.hasAttribute("width") && imageElement.getAttribute("width") != naturalWidth)
                    || (naturalHeight && imageElement.hasAttribute("height") && imageElement.getAttribute("height") != naturalHeight))
                {
                    imageElement.className += " webdeveloper-adjusted-image";
                }
            }
            else if(imageElement.className.indexOf("webdeveloper-adjusted-image") != -1)
            {
                imageElement.className = webdeveloper_removeSubstring(imageElement.className, "webdeveloper-adjusted-image");
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_with_adjusted_dimensions.css", "webdeveloper-outline-images-with-adjusted-dimensions", applyStyle);
}

// Outlines all the images with empty alt attributes
function webdeveloper_outlineImagesWithEmptyAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_with_empty_alt_attributes.css", "webdeveloper-outline-images-with-empty-alt-attributes", applyStyle);
}

// Outlines all the images without alt attributes
function webdeveloper_outlineImagesWithoutAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_alt_attributes.css", "webdeveloper-outline-images-without-alt-attributes", applyStyle);
}

// Outlines all the images without dimensions
function webdeveloper_outlineImagesWithoutDimensions(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_dimensions.css", "webdeveloper-outline-images-without-dimensions", applyStyle);
}

// Outlines all the images without title attributes
function webdeveloper_outlineImagesWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_title_attributes.css", "webdeveloper-outline-images-without-title-attributes", applyStyle);
}

// Replaces all images with their alt attributes
function webdeveloper_replaceImagesWithAltAttributes(element, applyStyle)
{
    var altAttribute        = null;
    var checked             = element.getAttribute("checked");
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var imageElement        = null;
    var imageElementList    = null;
    var imageElementsLength = null;
    var pageDocument        = null;
    var previousElement     = null;
    var spanElement         = null;
    var spanElementList     = null;
    var spanElementsLength  = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];

        // If the element is checked
        if(checked)
        {
            imageElementList    = pageDocument.getElementsByTagName("img");
            imageElementsLength = imageElementList.length;

            // Loop through all the img tags
            for(var j = 0; j < imageElementsLength; j++)
            {
                imageElement = imageElementList[j];
                altAttribute = imageElement.getAttribute("alt");
                spanElement  = pageDocument.createElement("span");

                // If the alt attribute is set
                if(altAttribute)
                {
                    spanElement.setAttribute("class", "webdeveloper-alt-attribute");
                    spanElement.appendChild(pageDocument.createTextNode(altAttribute));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }
            }
        }
        else
        {
            spanElementList    = pageDocument.getElementsByTagName("span");
            spanElementsLength = spanElementList.length;

            // Loop through all the span tags
            for(j = 0; j < spanElementsLength; j++)
            {
                spanElement = spanElementList[j];

                // If the span element is set and has a class of webdeveloper-alt-attribute
                if(spanElement && spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-alt-attribute")
                {
                    spanElement.parentNode.removeChild(spanElement);
                    j--;
                }
            }
        }
    }

    webdeveloper_hideImages(element, "webdeveloper-replace-images-with-alt-attributes", applyStyle);
}

// Toggles external site images
function webdeveloper_toggleExternalSiteImages(element)
{
    var imageBehavior       = 1;
    var legacyImageBehavior = 0;

    // If disabling external images
    if(element.getAttribute("checked"))
    {
        imageBehavior       = 3;
        legacyImageBehavior = 1;
    }

    webdeveloper_setIntegerPreference("network.image.imageBehavior", legacyImageBehavior);
    webdeveloper_setIntegerPreference("permissions.default.image", imageBehavior);
    BrowserReloadSkipCache();
}

// Toggles image animations
function webdeveloper_toggleImageAnimations(element)
{
    var imageBehavior = "normal";

    // If disabling images
    if(element.getAttribute("checked"))
    {
        imageBehavior = "none";
    }

    webdeveloper_setStringPreference("image.animation_mode", imageBehavior);
    BrowserReloadSkipCache();
}

// Toggles images
function webdeveloper_toggleImages(element)
{
    var imageBehavior       = 1;
    var legacyImageBehavior = 0;

    // If disabling images
    if(element.getAttribute("checked"))
    {
        imageBehavior       = 2;
        legacyImageBehavior = 2;
    }

    webdeveloper_setIntegerPreference("network.image.imageBehavior", legacyImageBehavior);
    webdeveloper_setIntegerPreference("permissions.default.image", imageBehavior);
    BrowserReloadSkipCache();
}

// Updates the disable images menu
function webdeveloper_updateDisableImagesMenu(suffix)
{
    var checked                          = false;
    var disableExternalSiteImagesChecked = false;
    var disableExternalSiteImagesMenu    = document.getElementById("webdeveloper-disable-external-site-images-" + suffix);
    var disableImagesChecked             = false;
    var disableImagesPreferenceValue     = webdeveloper_getIntegerPreference("permissions.default.image", true);

    // If the image preference value is set to 2
    if(disableImagesPreferenceValue == 2)
    {
        disableImagesChecked = true;
    }
    else if(disableImagesPreferenceValue == 3)
    {
        disableExternalSiteImagesChecked = true;
    }

    // If the image animation preference is set to none
    if(webdeveloper_getStringPreference("image.animation_mode", false) == "none")
    {
        checked = true;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-all-images-" + suffix), "checked", disableImagesChecked);
    webdeveloper_configureElement(disableExternalSiteImagesMenu, "checked", disableExternalSiteImagesChecked);
    webdeveloper_configureElement(disableExternalSiteImagesMenu, "disabled", disableImagesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-image-animations-" + suffix), "checked", checked);
}

// Updates the images menu
function webdeveloper_updateImagesMenu(suffix)
{
    var disableImagesChecked         = false;
    var disableImagesPreferenceValue = webdeveloper_getIntegerPreference("permissions.default.image", true);

    // If the image preference value is set to 2
    if(disableImagesPreferenceValue == 2)
    {
        disableImagesChecked = true;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-find-broken-images-" + suffix), "disabled", disableImagesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-hide-background-images-" + suffix), "disabled", disableImagesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-make-images-full-size-" + suffix), "disabled", disableImagesChecked);
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-alt-attributes-" + suffix), "checked", "webdeveloper-display-alt-attributes");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-image-dimensions-" + suffix), "checked", "webdeveloper-display-image-dimensions");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-image-file-sizes-" + suffix), "checked", "webdeveloper-display-image-file-sizes");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-display-image-paths-" + suffix), "checked", "webdeveloper-display-image-paths");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-hide-background-images-" + suffix), "checked", "webdeveloper-hide-background-images");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-hide-images-" + suffix), "checked", "webdeveloper-hide-images");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-make-images-invisible-" + suffix), "checked", "webdeveloper-make-images-invisible");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-replace-images-with-alt-attributes-" + suffix), "checked", "webdeveloper-replace-images-with-alt-attributes");
}

// Updates the outline images menu
function webdeveloper_updateOutlineImagesMenu(suffix)
{
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-all-images-" + suffix), "checked", "webdeveloper-outline-all-images");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-background-images-" + suffix), "checked", "webdeveloper-outline-background-images");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-" + suffix), "checked", "webdeveloper-outline-images-with-adjusted-dimensions");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-" + suffix), "checked", "webdeveloper-outline-images-with-empty-alt-attributes");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-images-without-alt-attributes-" + suffix), "checked", "webdeveloper-outline-images-without-alt-attributes");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-images-without-dimensions-" + suffix), "checked", "webdeveloper-outline-images-without-dimensions");
    webdeveloper_configureElementByElement(document.getElementById("webdeveloper-outline-images-without-title-attributes-" + suffix), "checked", "webdeveloper-outline-images-without-title-attributes");
}

// Displays all the images for the page
function webdeveloper_viewImageInformation()
{
    var cellDataElement   = null;
    var cellHeaderElement = null;
    var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength    = documentList.length;
    var documentURL       = null;
    var fileSize          = null;
    var height            = 0;
    var image             = null;
    var imageElement      = null;
    var imageLength       = null;
    var imageList         = new Array();
    var imageSrc          = null;
    var linkElement       = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var headerElement     = generatedDocument.createElement("h1");
    var pageDocument      = null;
    var pElement          = null;
    var shade             = false;
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var title             = stringBundle.getFormattedString("webdeveloper_viewImageInformationTitle", [oldURL]);
    var tableElement      = null;
    var tableRowElement   = null;
    var width             = 0;

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    generatedDocument.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        headerElement = generatedDocument.createElement("h2");
        linkElement   = generatedDocument.createElement("a");
        pageDocument  = documentList[i];
        documentURL   = pageDocument.documentURI;
        imageList     = webdeveloper_getImagesForDocument(pageDocument, true, true);

        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedDocument.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        generatedDocument.body.appendChild(headerElement);

        // If the tidy information preference is set
        if(webdeveloper_getBooleanPreference("webdeveloper.information.tidy", true))
        {
            imageList = webdeveloper_tidyImages(imageList);
        }

        imageLength = imageList.length;

        // Loop through the images
        for(var j = 0; j < imageLength; j++)
        {
            image        = imageList[j];
            height       = image.naturalHeight;
            imageElement = generatedDocument.createElement("img");
            imageSrc     = image.src;
            fileSize     = webdeveloper_getFileSize(imageSrc);
            pElement     = generatedDocument.createElement("p");
            shade        = true;
            tableElement = generatedDocument.createElement("table");
            width        = image.naturalWidth;

            imageElement.setAttribute("src", imageSrc);
            pElement.appendChild(imageElement);
            generatedDocument.body.appendChild(pElement);

            // Src
            cellDataElement   = generatedDocument.createElement("td");
            cellHeaderElement = generatedDocument.createElement("th");
            linkElement       = generatedDocument.createElement("a");
            tableRowElement   = generatedDocument.createElement("tr");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_src")));
            tableRowElement.appendChild(cellHeaderElement);
            linkElement.setAttribute("href", imageSrc);
            linkElement.appendChild(generatedDocument.createTextNode(imageSrc));
            cellDataElement.appendChild(linkElement);
            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);

            // If there is a width
            if(width != 0)
            {
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_width")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(width));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            // If there is a height
            if(height != 0)
            {
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                shade             = !shade;
                tableRowElement   = generatedDocument.createElement("tr");

                // If this cell should be shaded
                if(shade)
                {
                    cellDataElement.setAttribute("class", "shaded");
                }

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_height")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(height));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            // If there is a file size
            if(fileSize)
            {
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                shade             = !shade;
                tableRowElement   = generatedDocument.createElement("tr");

                // If this cell should be shaded
                if(shade)
                {
                    cellDataElement.setAttribute("class", "shaded");
                }

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_fileSize")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(webdeveloper_formatFileSize(fileSize)));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            // If there is an alt attribute
            if(image.hasAttribute("alt"))
            {
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                shade             = !shade;
                tableRowElement   = generatedDocument.createElement("tr");

                // If this cell should be shaded
                if(shade)
                {
                    cellDataElement.setAttribute("class", "shaded");
                }

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_alt")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(image.getAttribute("alt")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            // If there is a title attribute
            if(image.hasAttribute("title"))
            {
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                shade             = !shade;
                tableRowElement   = generatedDocument.createElement("tr");

                // If this cell should be shaded
                if(shade)
                {
                    cellDataElement.setAttribute("class", "shaded");
                }

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_title")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(image.getAttribute("title")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            generatedDocument.body.appendChild(tableElement);
            generatedDocument.body.appendChild(generatedDocument.createElement("hr"));
        }
    }

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
