// Open a dialog to choose an application
function webdeveloper_chooseApplication()
{
    var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);

    filePicker.init(window, document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_chooseApplication"), filePicker.modeOpen);

    // If the user selected an application
    if(filePicker.show() == filePicker.returnOK)
    {
        var applicationPath = filePicker.file.path;
        var executable      = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);

        executable.initWithPath(applicationPath);

        // If the executable exists, is a file and is executable
        if(executable.exists() && executable.isFile() && executable.isExecutable())
        {
            document.getElementById("webdeveloper.tool.path").value = applicationPath;
        }
        else
        {
            webdeveloper_error(document.getElementById("webdeveloper-string-bundle").getFormattedString("webdeveloper_invalidApplication", [applicationPath]));
        }
    }
}

// Clears the tool
function webdeveloper_clearTool()
{
    window.opener.webdeveloper_toolDescription = null;
    window.opener.webdeveloper_toolKey         = null;
    window.opener.webdeveloper_toolPath        = null;
    window.opener.webdeveloper_toolURL         = null;
}

// Initializes the tool dialog box
function webdeveloper_initializeTool()
{
    var modifiers    = null;
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If running on a Mac
    if(webdeveloper_isMac())
    {
        modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiersMac");
    }
    else
    {
        modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiers");
    }

    document.getElementById("webdeveloper-keyboard-shortcut-modifiers").value = modifiers;

    // If the first argument equals add
    if(window.arguments[0] == "add")
    {
        document.title = stringBundle.getString("webdeveloper_addTool");
    }
    else
    {
        document.title = stringBundle.getString("webdeveloper_editTool");

        document.getElementById("webdeveloper.tool.description").value = window.arguments[1];
        document.getElementById("webdeveloper.tool.key").value         = window.arguments[2];

        // If the last argument equals the application tool type
        if(window.arguments[4] == stringBundle.getString("webdeveloper_application"))
        {
            document.getElementById("webdeveloper.tool.path").value = window.arguments[3];
        }
        else if(window.arguments[4] == stringBundle.getString("webdeveloper_bookmarklet"))
        {
            var bookmarkletRadio = document.getElementById("webdeveloper-bookmarklet-radio");

            document.getElementById("webdeveloper.tool.bookmarklet").value = window.arguments[3];
            bookmarkletRadio.radioGroup.selectedItem                       = bookmarkletRadio;

            document.getElementById("webdeveloper-application-options").setAttribute("hidden", true);
            document.getElementById("webdeveloper-bookmarklet-options").setAttribute("hidden", false);
        }
        else
        {
            var urlRadio = document.getElementById("webdeveloper-url-radio");

            document.getElementById("webdeveloper.tool.url").value = window.arguments[3];
            urlRadio.radioGroup.selectedItem                       = urlRadio;

            document.getElementById("webdeveloper-application-options").setAttribute("hidden", true);
            document.getElementById("webdeveloper-url-options").setAttribute("hidden", false);
        }
    }
}

// Saves the tool
function webdeveloper_saveTool()
{
    var bookmarklet  = document.getElementById("webdeveloper.tool.bookmarklet").value.trim();
    var description  = document.getElementById("webdeveloper.tool.description").value.trim();
    var errors       = "";
    var key          = document.getElementById("webdeveloper.tool.key").value.trim();
    var path         = document.getElementById("webdeveloper.tool.path").value.trim();
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var url          = document.getElementById("webdeveloper.tool.url").value.trim();

    // If the description is empty
    if(!description)
    {
        errors += stringBundle.getString("webdeveloper_emptyDescription") + "\n";
    }

    // If the application type is selected and the path is empty
    if(document.getElementById("webdeveloper-application-radio").selected && !path)
    {
        errors += stringBundle.getString("webdeveloper_applicationPath") + "\n";
    }
    /*else if(document.getElementById("webdeveloper-bookmarklet-radio").selected && !bookmarklet)
    {
        errors += stringBundle.getString("webdeveloper_emptyBookmarklet") + "\n";
    }*/
    else if(document.getElementById("webdeveloper-url-radio").selected && !url)
    {
        errors += stringBundle.getString("webdeveloper_emptyURL") + "\n";
    }

    // If there are errors
    if(errors)
    {
        webdeveloper_error(errors.trim());

        return false;
    }
    else
    {
        window.opener.webdeveloper_toolDescription = description;
        window.opener.webdeveloper_toolKey         = key;

        // If the application type is selected
        if(document.getElementById("webdeveloper-application-radio").selected)
        {
            window.opener.webdeveloper_toolBookmarklet = null;
            window.opener.webdeveloper_toolPath        = path;
            window.opener.webdeveloper_toolURL         = null;
        }
        /*else if(document.getElementById("webdeveloper-bookmarklet-radio").selected)
        {
            window.opener.webdeveloper_toolBookmarklet = bookmarklet;
            window.opener.webdeveloper_toolPath        = null;
            window.opener.webdeveloper_toolURL         = null;
        }*/
        else
        {
            window.opener.webdeveloper_toolBookmarklet = null;
            window.opener.webdeveloper_toolPath        = null;
            window.opener.webdeveloper_toolURL         = url;
        }

        return true;
    }
}

// Toggles the tool type
function webdeveloper_toggleToolType()
{
    document.getElementById("webdeveloper-application-options").setAttribute("hidden", !document.getElementById("webdeveloper-application-radio").selected);
    /*document.getElementById("webdeveloper-bookmarklet-options").setAttribute("hidden", !document.getElementById("webdeveloper-bookmarklet-radio").selected);*/
    document.getElementById("webdeveloper-url-options").setAttribute("hidden", !document.getElementById("webdeveloper-url-radio").selected);
}