/**************************************************************************
* Simple XML-based UI builder for Qt 4
* Copyright (C) 2007 Michał Męciński
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "client.h"

#include <QDomDocument>
#include <QFile>

using namespace XmlUi;

Client::Client() :
    m_builder( NULL )
{
}

Client::~Client()
{
}

void Client::setAction( const QString& id, QAction* action )
{
    m_actions.insert( id, action );
}

QAction* Client::action( const QString& id ) const
{
    return m_actions.value( id, NULL );
}

void Client::setTitle( const QString& id, const QString& title )
{
    m_titles.insert( id, title );
}

QString Client::title( const QString& id ) const
{
    return m_titles.value( id, QString() );
}

void Client::loadXmlFile( const QString& path )
{
    QDomDocument document;

    QFile file( path );
    if ( !file.open( QIODevice::ReadOnly ) )
        return;

    if ( !document.setContent( &file ) )
        return;

    m_rootNode = createNode( document.documentElement() );
}

Node Client::createNode( const QDomElement& element )
{
    Node node;

    node.setType( typeFromTag( element.tagName() ) );
    node.setId( element.attribute( "id", QString() ) );

    for ( QDomElement child = element.firstChildElement(); !child.isNull(); child = child.nextSiblingElement() )
        node.addChild( createNode( child ) );

    return node;
}

NodeType Client::typeFromTag( const QString& tag )
{
    if ( tag == "xmlui" )
        return Root;
    if ( tag == "menubar" )
        return MenuBar;
    if ( tag == "menu" )
        return Menu;
    if ( tag == "toolbar" )
        return ToolBar;
    if ( tag == "group" )
        return Group;
    if ( tag == "action" )
        return Action;
    if ( tag == "separator" )
        return Separator;
    if ( tag == "merge" )
        return Merge;
    return Unknown;
}

void Client::setBuilder( Builder* builder )
{
    m_builder = builder;
}
