/*
 * This file is part of the DOM implementation for KDE.
 *
 * (C) 1999-2003 Lars Knoll (knoll@kde.org)
 * (C) 2002-2003 Dirk Mueller (mueller@kde.org)
 * Copyright (C) 2002, 2006, 2007 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CSSRule_h
#define CSSRule_h

#include "StyleBase.h"

namespace WebCore {

class CSSStyleSheet;

typedef int ExceptionCode;

class CSSRule : public StyleBase {
public:
    enum CSSRuleType {
        UNKNOWN_RULE,
        STYLE_RULE,
        CHARSET_RULE,
        IMPORT_RULE,
        MEDIA_RULE,
        FONT_FACE_RULE,
        PAGE_RULE
    };

    CSSRule(StyleBase* parent)
        : StyleBase(parent)
    {
    }

    virtual bool isRule() { return true; }

    virtual unsigned short type() const = 0;

    CSSStyleSheet* parentStyleSheet() const;
    CSSRule* parentRule() const;

    virtual String cssText() const;
    void setCssText(const String&, ExceptionCode&);
};

} // namespace WebCore

#endif // CSSRule_h
