#!/usr/local/bin/perl
# restart_zone.cgi
# Apply changes to one zone only using the ndc command

require './bind8-lib.pl';
&ReadParse();
%access = &get_module_acl();
$access{'ro'} && &error($text{'restart_ecannot'});
$access{'apply'} || &error($text{'restart_ecannot'});
$conf = &get_config();
if ($in{'view'} ne '') {
	# Reload a zone in a view
	$view = $conf->[$in{'view'}];
	$zone = $view->{'members'}->[$in{'index'}];
	$dom = $zone->{'value'};
	&can_edit_zone(\%access, $zone, $view) || &error($text{'restart_ecannot'});
	$out = &try_cmd("reload '$dom' IN '$view->{'value'}'");
	}
else {
	# Just reload one top-level zone
	$zone = $conf->[$in{'index'}];
	$dom = $zone->{'value'};
	&can_edit_zone(\%access, $zone) || &error($text{'restart_ecannot'});
	$out = &try_cmd("reload '$dom' 2>&1 </dev/null");
	}
if ($out =~ /not found/i) {
	# Zone is not known to BIND yet - do a total reload
	$out = &try_cmd("reload", "reconfig");
	}
if ($? || $out =~ /failed|not found|error/i) {
	&error(&text('restart_endc', "<tt>$out</tt>"));
	}
&webmin_log("apply", $dom);

$zconf = $zone->{'members'};
$tv = &find("type", $zconf)->{'value'};
&redirect(($tv eq "master" ? "edit_master.cgi" :
	  $tv eq "forward" ? "edit_forward.cgi" : "edit_slave.cgi").
	  "?index=$in{'index'}&view=$in{'view'}");

# try_cmd(args, [rndc-args])
sub try_cmd
{
local $args = $_[0];
local $rndc_args = $_[1] || $_[0];
local $out;
if (&has_ndc() == 2) {
	# Try with rndc
	$out = &backquote_logged("$config{'rndc_cmd'} $rndc_args 2>&1 </dev/null");
	}
if (&has_ndc() != 2 || $out =~ /connect\s+failed/i) {
	if (&has_ndc(2)) {
		# Try with rndc if rndc is not install or failed
		$out = &backquote_logged("$config{'ndc_cmd'} $args 2>&1 </dev/null");
		}
	}
return $out;
}

