#!/usr/local/bin/perl
# save_relay.cgi
# Save relay domains list

require './sendmail-lib.pl';
&ReadParseMime();
$access{'relay'} || &error($text{'relay_ecannot'});
&error_setup($text{'relay_err'});
&lock_file($config{'sendmail_cf'});
$conf = &get_sendmailcf();
@dlist = split(/\s+/, $in{'dlist'});
foreach $d (@dlist) {
	$d =~ /^[A-z0-9\-\.]+$/ ||
		&error(&text('relay_edomain', $d));
	}
@dlist = &unique(@dlist);

# get old CR directives
@old = grep { $_->{'value'} =~ /^R/ } &find_type("C", $conf);

if ($in{'relayfile'}) {
	# If there is a relay file, write all domains to it and take any
	# out of sendmail.cf
	&lock_file($in{'relayfile'});
	open(RELAY, "> $in{'relayfile'}");
	foreach $d (@dlist) { print RELAY $d,"\n"; }
	close(RELAY);
	&unlock_file($in{'relayfile'});
	}
else {
	# Stick all domains in sendmail.cf
	foreach $d (@dlist) {
		push(@new, { 'type' => 'C',
			     'values' => [ "R$d" ] });
		}
	}
&save_directives($conf, \@old, \@new);
&flush_file_lines();
&unlock_file($config{'sendmail_cf'});
&restart_sendmail();
&webmin_log("relay");
&redirect("");

