#!/usr/local/bin/perl
# create-domain.pl
# Adds a new virtual host, based on command-line parameters

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/create-domain.pl";
require './virtual-server-lib.pl';
$< == 0 || die "create-domain.pl must be run as root";

$first_print = \&first_text_print;
$second_print = \&second_text_print;

# Parse command-line args
$name = 1;
$virt = 0;
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--domain") {
		$domain = lc(shift(@ARGV));
		}
	elsif ($a eq "--desc") {
		$owner = shift(@ARGV);
		}
	elsif ($a eq "--email") {
		$email = shift(@ARGV);
		}
	elsif ($a eq "--user") {
		$user = lc(shift(@ARGV));
		}
	elsif ($a eq "--pass") {
		$pass = shift(@ARGV);
		}
	elsif ($a eq "--quota") {
		$quota = shift(@ARGV);
		}
	elsif ($a eq "--uquota") {
		$uquota = shift(@ARGV);
		}
	elsif ($a =~ /^--(\S+)$/ &&
	       &indexof($1, @features) >= 0) {
		$config{$1} || die "The $a option cannot be used unless the feature is enabled in the module configuration";
		$feature{$1}++;
		}
	elsif ($a =~ /^--(\S+)$/ &&
	       &indexof($1, @feature_plugins) >= 0) {
		$plugin{$1}++;
		}
	elsif ($a eq "--ip") {
		!$config{'ip_ranges'} || $config{'all_namevirtual'} || die "The $a option cannot be used when automatic IP allocation is enabled - use --allocate-ip instead";
		$ip = shift(@ARGV);
		if (!$config{'all_namevirtual'}) {
			$feature{'virt'} = 1;	# for dependency checks
			$virt = 1;
			}
		$name = 0;
		}
	elsif ($a eq "--allocate-ip") {
		$config{'ip_ranges'} || die "The $a option cannot be used unless automatic IP allocation is enabled - use --ip instead";
		$ip = &free_ip_address();
		$ip || die "Failed to allocate IP address from ranges!";
		$virt = 1;
		$name = 0;
		}
	elsif ($a eq "--mailboxlimit") {
		$mailboxlimit = shift(@ARGV);
		}
	elsif ($a eq "--template") {
		$templatename = shift(@ARGV);
		foreach $t (&list_templates()) {
			if ($t->{'name'} eq $templatename) {
				$template = $t->{'id'};
				}
			}
		$template eq "" && die "Unknown template name";
		}
	elsif ($a eq "--bandwidth") {
		$bw = shift(@ARGV);
		}
	elsif ($a eq "--prefix") {
		$prefix = shift(@ARGV);
		}
	elsif ($a eq "--db") {
		$db = shift(@ARGV);
		$db =~ /^[a-z0-9\-\_]+$/i || die "Invalid database name";
		}
	elsif ($a eq "--fwdto") {
		$fwdto = shift(@ARGV);
		$fwdto =~ /^\S+\@\S+$/i || die "Invalid forwarding address";
		}
	elsif ($a eq "--parent") {
		$parentdomain = lc(shift(@ARGV));
		}
	elsif ($a eq "--alias") {
		$aliasdomain = $parentdomain = lc(shift(@ARGV));
		}
	else {
		&usage();
		}
	}
$template = 0 if ($template eq "");

# Make sure all needed args are set
$domain && ($parentdomain || $pass) || &usage();
if ($config{'home_quotas'} && !$parentdomain) {
	$quota && $uquota || &usage();
	}
if ($parentdomain) {
	$feature{'unix'} && die "--unix option makes no sense for sub-servers";
	}
if ($aliasdomain) {
	foreach $f (keys %feature) {
		&indexof($f, @opt_alias_features) >= 0 ||
			die "--$f option makes no sense for alias servers";
		}
	}

# Validate args and work out defaults for those unset
$domain =~ /^[A-Za-z0-9\.\-]+$/ || die($text{'setup_edomain'});
foreach $d (&list_domains()) {
        die($text{'setup_edomain2'}) if (lc($d->{'dom'}) eq lc($domain));
        }
if ($parentdomain) {
	$parent = &get_domain_by("dom", $parentdomain);
	$parent || die "Parent domain does not exist";
	$alias = $parent if ($aliasdomain);
	}
if (!$parent) {
	if (!$user) {
		($user, $try1, $try2) = &unixuser_name($domain);
		$user || die(&text('setup_eauto', $try1, $try2));
		}
	else {
		$user =~ /^[^\t :]+$/ || die($text{'setup_euser2'});
		defined(getpwnam($user)) && die($text{'setup_euser'});
		}
	}
$owner ||= $domain;
if (!$parent) {
	!defined($mailboxlimit) || $mailboxlimit =~ /^[1-9]\d*$/ ||
		die($text{'setup_emailboxlimit'});
	}

if (!$parent) {
	# Validate username
	if (defined(&useradmin::check_username_restrictions)) {
		$uerr = &useradmin::check_username_restrictions($user);
		if ($uerr) {
			die(&text('setup_eusername', $user, $uerr));
			}
		}
	$user =~ /^[a-zA-z]/ || die(&text('setup_eusername2', $user));
	}

# Validate quotas
if ($config{'home_quotas'} && !$parent) {
        $quota =~ /^\d+$/ || die($text{'setup_equota'});
        $uquota =~ /^\d+$/ || die($text{'setup_euquota'});
        }

$defip = &get_default_ip();
if (!$alias) {
	if ($config{'all_namevirtual'}) {
		# Make sure the IP *is* assigned
		&check_ipaddress($ip) || die($text{'setup_eip'});
		if (!&check_virt_clash($ip)) {
			die(&text('setup_evirtclash2'));
			}
		}
	elsif ($virt) {
		# Make sure the IP isn't assigned yet
		&check_ipaddress($ip) || die($text{'setup_eip'});
		if (&check_virt_clash($ip)) {
			die(&text('setup_evirtclash'));
			}
		}
	}
else {
	$ip = $alias->{'ip'};
	}

if ($parent) {
	# User and group IDs come from parent
	$gid = $parent->{'gid'};
	$ugid = $parent->{'ugid'};
	$user = $parent->{'user'};
	$group = $parent->{'group'};
	$uid = $parent->{'uid'};
	}
else {
	# Work out user and group IDs
	&build_group_taken(\%gtaken, \%ggtaken);
	$gid = &allocate_gid(\%gtaken);
	$ugid = $gid;
	&build_taken(\%taken, \%utaken);
	$uid = &allocate_uid(\%taken);
	}

# Work out prefix if needed
if (!$prefix) {
	if ($config{'longname'}) {
		$prefix = $domain;
		}
	else {
		$domain =~ /^([^\.]+)/;
		$prefix = $1;
		}
	}
$prefix =~ /^[a-z0-9\.\-]+$/i || die $text{'setup_eprefix'};
$pclash = &get_domain_by("prefix", $in{'prefix'});
$pclash && die $text{'setup_eprefix2'};

# Build up domain object
%dom = ( 'id', &domain_id(),
	 'dom', $domain,
         'user', $user,
         'group', $user,
         'ugroup', $user,
         'uid', $uid,
         'gid', $gid,
         'ugid', $gid,
         'owner', $owner,
         'email', $parent ? $parent->{'email'} : $email,
         'name', $name,
         'ip', $config{'all_namevirtual'} ? $ip :
	       $virt ? $ip : $defip,
	 'dns_ip', $virt || $config{'all_namevirtual'} ? undef :
		$config{'dns_ip'},
         'virt', $virt,
	 $parent ? ( 'pass', $parent->{'pass'} )
		 : ( 'pass', $pass,
         	     'quota', $quota,
		     'uquota', $uquota ),
	 'alias', $alias ? $alias->{'id'} : undef,
	 'source', 'create-domain.pl',
	 'template', $template,
	 'parent', $parent ? $parent->{'id'} : "",
	 $parent ? ( )
		 : ( 'mailboxlimit', $mailboxlimit,
		     'bw_limit', $bw ),
	 'prefix', $prefix,
        );
$dom{'db'} = $db || &database_name(\%dom);
foreach $f (@features) {
	$dom{$f} = $feature{$f} ? 1 : 0;
	$dom{"limit_$f"} = $f eq "webmin" ? 0 : $dom{$f};
	}
foreach $f (@feature_plugins) {
	$dom{$f} = $plugin{$f} ? 1 : 0;
	$dom{"limit_$f"} = $dom{$f};
	}

# Work out home directory
$dom{'home'} = &server_home_directory(\%dom, $parent);

# Check for various clashes
$derr = &virtual_server_depends(\%dom);
die $derr if ($derr);
$cerr = &virtual_server_clashes(\%dom);
die $cerr if ($cerr);

print "Beginning domain creation ..\n\n";

$err = &create_virtual_server(\%dom, $parent,
			      $parent ? $parent->{'user'} : undef);
if ($err) {
	print "$err\n";
	exit 1;
	}

if ($fwdto) {
	&$first_print(&text('setup_fwding', $in{'fwdto'}));
	$virt = { 'from' => "\@$domain",
		  'to' => [ $fwdto ] };
	&create_virtuser($virt);
	&$second_print($text{'setup_done'});
	}

print "All done!\n";

sub usage
{
print "Adds a new Virtualmin virtual server, with the settings and features\n";
print "specified on the command line.\n";
print "\n";
print "usage: create-domain.pl  --domain domain.name\n";
print "                         --pass password-for-unix-user\n";
print "			       [--parent domain.name | --alias domain.name]\n";
print "                        [--desc description-for-domain]\n";
print "                        [--email contact-email]\n";
print "                        [--user new-unix-user]\n";
foreach $f (@features) {
	print "                        [--$f]\n" if ($config{$f});
	}
foreach $f (@feature_plugins) {
	print "                        [--$f]\n";
	}
if ($config{'ip_ranges'}) {
	print "                        [--allocate-ip]\n";
	}
else {
	print "                        [--ip virtual.ip.address]\n";
	}
print "                        [--mailboxlimit boxes]\n";
if ($config{'home_quotas'}) {
	print "                         --quota quota-for-domain]\n";
	print "                         --uquota quota-for-unix-user]\n";
	}
print "                        [--template \"name\"]\n";
if ($config{'bw_active'}) {
	print "                        [--bandwidth bytes]\n";
	}
print "                        [--prefix username-prefix]\n";
print "                        [--db database-name]\n";
print "                        [--fwdto email-address]\n";
exit(1);
}


