#!/usr/local/bin/perl
# Display currently enabled plugin modules

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newplugin_ecannot'});
&ui_print_header(undef, $text{'newplugin_title'}, "");

print "<form action=save_newplugin.cgi method=post>\n";
print "$text{'newplugin_desc'}<p>\n";
print "<table>\n";

# Show active plugins
%plugins = map { $_, 1 } @plugins;
print "<tr> <td valign=top><b>$text{'newplugin_mods'}</b></td>\n";
print "<td><select name=mods size=10 multiple width=400>\n";
foreach $m (sort { $a->{'desc'} cmp $b->{'desc'} } &get_all_module_infos()) {
	$mdir = defined(&module_root_directory) ?
			&module_root_directory($m->{'dir'}) :
			"$root_directory/$m->{'dir'}";
	if (-r "$mdir/virtual_feature.pl") {
		&foreign_require($m->{'dir'}, "virtual_feature.pl");
		printf "<option value=%s %s>%s (%s)\n",
			$m->{'dir'}, $plugins{$m->{'dir'}} ? "selected" : "",
			&plugin_call($m->{'dir'}, "feature_name"),
			$m->{'desc'};
		push(@allplugins, $m->{'dir'});
		if (-r "$mdir/config.info") {
			push(@confplugins, $m);
			}
		}
	}
print "</select></td> </tr>\n";

print "</table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

# Show links to configure plugins
if (@confplugins) {
	print "<hr>\n";
	print "<form action=edit_plugconfig.cgi>\n";
	print "$text{'newplugin_configdesc'}<p>\n";
	print "<input type=submit value='$text{'newplugin_config'}'>\n";
	print "<select name=mod>\n";
	foreach $m (@confplugins) {
		printf "<option value=%s>%s (%s)\n",
			$m->{'dir'}, 
			&plugin_call($m->{'dir'}, "feature_name"),
			$m->{'desc'};
		}
	print "</select>\n";
	print "</form>\n";
	}

&ui_print_footer("", $text{'index_return'});
