#!/usr/local/bin/perl
# save_poll.cgi
# Update, create or delete a server to poll

require './fetchmail-lib.pl';
&ReadParse();
&error_setup($text{'poll_err'});
@conf = &parse_config_file($in{'file'});
if (!$in{'new'}) {
	$poll = $conf[$in{'idx'}];
	}

&lock_file($in{'file'});
if ($in{'adduser'}) {
	# Go back to the edit form
	&redirect("edit_poll.cgi?file=$in{'file'}&idx=$in{'idx'}&adduser=1&user=$in{'user'}");
	exit;
	}
elsif ($in{'check'}) {
	# Go to the mail checking CGI
	&redirect("check.cgi?file=$in{'file'}&idx=$in{'idx'}&adduser=1&user=$in{'user'}");
	exit;
	}
elsif ($in{'delete'}) {
	# Just delete the poll
	&delete_poll($poll, $in{'file'});
	}
else {
	# Validate poll inputs
	$in{'poll'} =~ /^\S+$/ || &error($text{'poll_epoll'});
	$in{'via_def'} || gethostbyname($in{'via'}) ||
		&error($text{'poll_evia'});
	!$in{'via_def'} || gethostbyname($in{'poll'}) ||
		&error($text{'poll_epoll'});
	$in{'port_def'} || $in{'port'} =~ /^\d+$/ ||
		&error($text{'poll_eport'});
	if (!$in{'interface_def'}) {
		$in{'interface'} =~ /^\S+$/ || &error($text{'poll_einterface'});
		&check_ipaddress($in{'interface_net'}) ||
			&error($text{'poll_enet'});
		&check_ipaddress($in{'interface_mask'}) ||
		    !$in{'interface_mask'} ||
			&error($text{'poll_emask'});
		}

	# Create the poll structure
	$poll->{'poll'} = $in{'poll'};
	$poll->{'skip'} = $in{'skip'};
	$poll->{'via'} = $in{'via_def'} ? undef : $in{'via'};
	$poll->{'proto'} = $in{'proto'};
	$poll->{'port'} = $in{'port_def'} ? undef : $in{'port'};
	if ($in{'interface_def'}) {
		delete($poll->{'interface'});
		}
	else {
		local @interface = ( $in{'interface'}, $in{'interface_net'} );
		push(@interface, $in{'interface_mask'})
			if ($in{'interface_mask'});
		$poll->{'interface'} = join("/", @interface);
		}

	# Validate user inputs
	for($i=0; defined($in{"user_$i"}); $i++) {
		$user = $poll->{'users'}->[$i];
		next if (!$in{"user_$i"});
		$in{"user_$i"} =~ /^\S*$/ || &error($text{'poll_euser'});
		$user->{'user'} = $in{"user_$i"};
		$user->{'pass'} = $in{"pass_$i"};
		local @is = split(/\s+/, $in{"is_$i"});
		$user->{'is'} = \@is;
		$user->{'keep'} = $in{"keep_$i"};
		$user->{'fetchall'} = $in{"fetchall_$i"};
		$user->{'preconnect'} = $in{"preconnect_$i"};
		$user->{'postconnect'} = $in{"postconnect_$i"};
		push(@users, $user);
		}
	$poll->{'users'} = \@users;

	if ($in{'new'}) {
		&create_poll($poll, $in{'file'});
		if ($in{'user'}) {
			local @uinfo = getpwnam($in{'user'});
			&system_logged("chown $uinfo[2]:$uinfo[3] $in{'file'}");
			}
		&system_logged("chmod 700 $in{'file'}");
		}
	else {
		&modify_poll($poll, $in{'file'});
		}
	}

&unlock_file($in{'file'});
&webmin_log($in{'new'} ? 'create' : $in{'delete'} ? 'delete' : 'modify',
	    'poll', $poll->{'poll'},
	    $config{'config_file'} ? { 'file' => $in{'file'} }
				   : { 'user' => $in{'user'} } );
&redirect("");

