#!/usr/local/bin/perl
# index.cgi
# List all services currently being monitored

require './status-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

@serv = &list_services();
$mid = int((@serv-1) / 2);
$oldstatus = &read_file("$module_config_directory/oldstatus", \%oldstatus);

if (@serv) {
	print "<table width=100%><tr>\n";
	print "<td width=50% valign=top>\n";
	&service_table(@serv[0 .. $mid]);
	print "</td> <td width=50% valign=top>\n";
	&service_table(@serv[$mid+1 .. $#serv]) if (@serv > 1);
	print "</td></tr></table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}

print "<table width=100%><tr>\n";
if ($access{'edit'}) {
	print "<form action=edit_mon.cgi>\n";
	print "<td><input type=submit value='$text{'index_add'}'> ",
	      "<select name=type>\n";
	foreach $h (&list_handlers()) {
		printf "<option value=%s>%s\n", $h, $text{"type_$h"};
		}
	print "</select></td></form>\n";
	}
else {
	print "<td></td>\n";
	}

if ($access{'sched'}) {
	print "<form action=edit_sched.cgi>\n";
	print "<td align=right><input type=submit ",
	      "value='$text{'index_sched'}'></td></form>\n";
	}
else {
	print "<td></td>\n";
	}
print "</tr></table>\n";

&remote_finished();
print "<hr>\n";
&footer("/", $text{'index'});

sub service_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_desc'}</b></td>\n";
print "<td><b>$text{'index_host'}</b></td>\n";
print $config{'index_status'} || $oldstatus ?
      "<td><b>$text{'index_up'}</b></td> </tr>\n" : "</tr>\n";
foreach $s (@_) {
	print "<tr $cb>\n";
	if ($access{'edit'}) {
		print "<td><a href='edit_mon.cgi?id=$s->{'id'}'>",
		      &html_escape($s->{'desc'}),"</a></td>\n";
		}
	else {
		print "<td>",&html_escape($s->{'desc'}),"</td>\n";
		}
	print "<td>",$s->{'remote'} ? &html_escape($s->{'remote'})
				    : $text{'index_local'},"</td>\n";
	if ($config{'index_status'}) {
		$stat = &service_status($s);
		print "<td><img src=images/",
		      $stat->{'up'} == 1 ? "up.gif" :
		      $stat->{'up'} == -1 ? "not.gif" : "down.gif","></td>\n";
		}
	elsif ($oldstatus) {
		$o = $oldstatus{$s->{'id'}};
		print "<td><img src=images/",
		      $o eq '' ? "quest.gif" :
		      $o == 1 ? "up.gif" :
		      $o == -1 ? "not.gif" : "down.gif","></td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
}

