/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_OUTMODULE_TEXT_H
#define _WF_OUTMODULE_TEXT_H

#include "wfoutmodule.h"
#include "dns.h"
#include "whois.h"

class wf_outmodule_text : public wf_outmodule {
 public:
  wf_outmodule_text();
  virtual ~wf_outmodule_text();
  // wf_outmodule_text(wf_outmodule_text&) {} MV@@5

  virtual string name() const { return "text"; }

  virtual bool print(const wf_logentry* entry, ostream& os);
  virtual bool print(const wf_logentries& logentries, ostream& os);

 private:
  void output_header(ostream& os) const;
  bool resolv_init(unsigned char verbose);

 private:
  wf_dns* dns;
  wf_whois* whois;
};

#endif
