/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_IPADDR_RANGE_H
#define _WF_IPADDR_RANGE_H

#include "wfhost_base.h"
#include "wfipaddr.h"

/**
 * ipaddr_range: IP address range (IP1 to IP2).
 */
class wf_ipaddr_range : public wf_host_base {
 public:
  wf_ipaddr_range(const wf_ipaddr& min_addr, const wf_ipaddr& max_addr);
  wf_ipaddr_range(const string& min_str, const string& max_str);
  virtual ~wf_ipaddr_range() {}
  // wf_ipaddr_range(const wf_ipaddr_range&) {} implicit copy constructor
  virtual wf_host_base* VClone() const;

  bool set(const wf_ipaddr& min_addr, const wf_ipaddr& max_addr);
  bool set(const string& min_str, const string& max_str);

  bool isdefined() const;
  string tostr() const;
  bool belong(const wf_ipaddr& addr) const;

  virtual enum metahost_elem_type gettype() const { return WF_METAHOST_IPADDR_RANGE; }
  virtual ostream& print(ostream& os) const;
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const;
  ostream& debugprint(ostream& os) const;

  friend ostream& operator<<(ostream& os, const wf_ipaddr_range& ipaddr_range);

  static bool check(const string& min_addr, const string& max_addr);
  
 private:
  wf_ipaddr _min_addr;
  wf_ipaddr _max_addr;
};


inline wf_host_base*
wf_ipaddr_range::VClone() const {
  return new wf_ipaddr_range(*this);
}

#endif
