#! /usr/bin/perl

while (<>)
{
   if (/^\s+(\w+) = \{/)
   {
      $name = $1;
   }
   if (/(.*Type = )([a-zA-Z]*)/)
   {
      $type = $2;
   }
   if (/(.*Info = )(\".*\")(.*)/)
   {
      $a = $1;
      $b = $2;
      $c = $3;
      if ($type =~ /Texture/)
      {
         print "/* Info: $name */\n";
         print "$a$b$c\n";
      }
      else
      {
         print "/* Info: $name */\n";
         print $a . "_(" . $b . ")" . $c . "\n";
      }
   }
   elsif (/(.*Title = )(\".*\")(.*)/)
   {
      print "/* Title: $name */\n";
      print "$1_($2)$3\n";
   }
   elsif (/(.*RangeInfo = \()(\".*\", )+(\".*\")(.*)\)/)
   {
      print "/* RangeInfo: $name */\n";
      $beg = $1;
      $end = $4;
      $str = $3;
      $_   = $2;
      s/\"(.*?)\", /_(\"\1\"), /g;
      print "$beg$_" . "_($str)$end";
   }
   else
   {
      print;
   }
}

