/*
 *  mkpreview.c:	Generate preview of image
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1999 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/04/02 17:27:54 $
 *  $Author: hafner $
 *  $Revision: 1.5 $
 *  $State: Exp $
 */

#include "config.h"

#if HAVE_STDLIB_H
#	include <stdlib.h>
#endif /* not HAVE_STDLIB_H */
#if HAVE_STRING_H
#	include <string.h>
#else /* not HAVE_STRING_H */
#	include <strings.h>
#endif /* not HAVE_STRING_H */
#include <stdio.h>
#include <wraster.h>

#include "misc.h"
#include "error.h"

int
main (int argc, char **argv)
{
   if (argc != 5)
   {
      fprintf (stderr, "usage: %s infile outfile width height\n", argv [0]);
      exit (1);
   }
   else
   {
      RContext		 *rc;
      RContextAttributes rattr;
      Display		 *dpy;
      RImage		 *image, *scaled;
      FILE		 *file;
      unsigned		 x, y;
      
      dpy = XOpenDisplay ("");
      if (!dpy)
      {
	 fprintf (stderr, "Can't open display.\n");
	 exit (1);
      }

      rattr.flags = 0;
      rc = RCreateContext(dpy, DefaultScreen (dpy), &rattr);

      image = RLoadImage (rc, argv [1], 0);
      if (!image)
      {
	 fprintf (stderr, "Can't open file `%s'.\n", argv [1]);
	 exit (1);
      }
      if (!image->width || !image->height)
      {
	 fprintf (stderr, "Can't scale an %dx%d image.\n",
		  image->width, image->height);
	 exit (1);
      }
      
      {
	 unsigned width  = strtol (argv [3], NULL, 10);
	 unsigned height = strtol (argv [4], NULL, 10);

	 if (image->width > width || image->height > height)
	 {
	    if (height * image->width > width * image->height)
	       height = width * image->height / image->width;
	    else
	       width  = height * image->width / image->height;
	    
	    scaled = RScaleImage (image, max (width, 22), max (height, 22));
	    RDestroyImage (image);
	 }
	 else
	    scaled = image;
      }
      
      file = fopen (argv [2], "w");
      if (!file)
      {
	 fprintf (stderr, "Can't open file `%s'.\n", argv [2]);
	 exit (1);
      }
      
#ifdef HAVE_WRASTER_0_20
      {
	 unsigned char *ptr = scaled->data;
	 
	 fprintf (file, "P6\n%d %d\n255\n", scaled->width, scaled->height);
	 for (y = 0; y < scaled->height; y++)
	    for (x = 0; x < scaled->width; x++)
	    {
	       if (scaled->format == RRGBFormat || *(ptr + 3))
	       {
		  fputc (*ptr++, file);
		  fputc (*ptr++, file);
		  fputc (*ptr++, file);
	       }
	       else
	       {
		  ptr++;
		  ptr++;
		  ptr++;
		  fputc (0xa8, file);
		  fputc (0xa8, file);
		  fputc (0xa8, file);
	       }
	       if (scaled->format == RRGBAFormat)
		  ptr++;
	    }
	 fclose (file);
	 RDestroyImage (scaled);
      }
#else  /* old wraster of wmaker < 0.62.0 */
      {
	 unsigned char *r, *g, *b, *a;
      
	 r = scaled->data [0];
	 g = scaled->data [1];
	 b = scaled->data [2];
	 a = scaled->data [3];
	 
	 fprintf (file, "P6\n%d %d\n255\n", scaled->width, scaled->height);	
	 for (y = 0; y < scaled->height; y++)
	    for (x = 0; x < scaled->width; x++)
	    {
	       if (!a || *a++)
	       {
		  fputc (*r++, file);
		  fputc (*g++, file);
		  fputc (*b++, file);
	       }
	       else
	       {
		  r++;
		  g++;
		  b++;
		  fputc (0xa8, file);
		  fputc (0xa8, file);
		  fputc (0xa8, file);
	       }
	    }
	 fclose (file);
	 RDestroyImage (scaled);
      }
#endif    
      return 0;
   }
}




