/* lowlevelfunc.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: lowlevelfunc.cc,v 1.14 2002/03/08 19:47:19 ralf Exp $ */

#include "lowlevelfunc.h"

#ifdef USE_MEM_SYSTEM
typedef struct _safemem {void *ptr;
                         size_t size;
                         struct _safemem *next;} SafeMem;
SafeMem *firstmemstr;
unsigned long maxmemusage,memusage;

#ifdef WANT_THREADS
#include "mutex.h"
MutEx memlock;
#endif

#endif

void *_allocsafe(size_t size)
{ /* gibt Speicher zurck oder beendet sofort das Programm */
  void *ptr;
#ifdef USE_MEM_SYSTEM
  SafeMem *tsmptr,*tsmptr2;
#endif

  ptr=(void*)malloc(size);
  if(ptr==NULL) {
    fprintf(stderr, "No Memory!!!!Aborting\n");
    exit(1);
  }
#ifdef USE_MEM_SYSTEM
#ifdef WANT_THREADS
  memlock.lock();
#endif
  tsmptr=(SafeMem*)malloc(sizeof(SafeMem));
  tsmptr->ptr=ptr;
  tsmptr->size=size;
  tsmptr->next=NULL;
  if(firstmemstr==NULL) {
    firstmemstr=tsmptr;
  } else {
    tsmptr2=firstmemstr;
    while(tsmptr2->next!=NULL) tsmptr2=tsmptr2->next;
    tsmptr2->next=tsmptr;
  }
  memusage+=size;
  if(memusage>maxmemusage) maxmemusage=memusage;
#ifdef WANT_THREADS
  memlock.unlock();
#endif
#endif
  return ptr;
}

void waittime(unsigned long msec)
{
#ifdef HAVE_NANOSLEEP
  struct timespec wt;
  wt.tv_nsec=msec*1000000;
  wt.tv_sec=0;
  nanosleep(&wt,NULL);
#else

#ifdef HAVE_USLEEP
  usleep( msec * 1000 );
#else

  /* configure doesn't allow continue without nanosleep and usleep
   * but worker could run without a working waittime (but not very nice)
   * just throw a warning
   */
#warning empty wait-function

#endif /* HAVE_USLEEP */

#endif /* HAVE_NANOSLEEP */
}

#ifdef USE_MEM_SYSTEM
void _freesafe(void *p)
{
  SafeMem *tsmptr,*found,*prefound;

#ifdef WANT_THREADS
  memlock.lock();
#endif
  tsmptr=firstmemstr;
  found=NULL;
  prefound=NULL;
  while(tsmptr!=NULL) {
    if(tsmptr->ptr==p) {
      found=tsmptr;
      break;
    }
    prefound=tsmptr;
    tsmptr=tsmptr->next;
  }
  if(found!=NULL) {
    memusage-=found->size;
    if(firstmemstr==found) {
      firstmemstr=found->next;
      free(found);
    } else {
      prefound->next=found->next;
      free(found);
    }
  } else {
    printf("Freigabe eines unauthorisierten Speichers!\n");
  }
#ifdef WANT_THREADS
  memlock.unlock();
#endif
  free(p);
}

void _memsystemcheck()
{
  SafeMem *tsmptr;
  int nr;

#ifdef WANT_THREADS
  memlock.lock();
#endif
  tsmptr=firstmemstr;
  nr=0;
  while(tsmptr!=NULL) {
    nr++;
/*    printf("lasse nr %d free:\n",nr);
    free(tsmptr->ptr);*/
    tsmptr=tsmptr->next;
  }
#ifdef DEBUG
  printf("Es gibt noch %d nicht freigelassene Speicherstcke!\n",nr);
  printf("Maximal benutzter Speicher:%ld Bytes\n",maxmemusage);
  printf("Noch benutzter Speicher:%ld Bytes\n",memusage);
#else
  if(nr>0) {
    printf("Es gibt noch %d nicht freigelassene Speicherstcke!\n",nr);
  }
#endif
#ifdef WANT_THREADS
  memlock.unlock();
#endif
}

void _memsysteminit()
{
  printf("Init Mem-System\n");
  firstmemstr=NULL;
  maxmemusage=0;
  memusage=0;
}
#endif

char *dupstring(const char *str)
{
  char *tstr;
  tstr=(char*)_allocsafe(strlen(str)+1);
  strcpy(tstr,str);
  return tstr;
}

int WriteLong2Str(char *buffer,loff_t size)
{
  int i=0,digit,j;
  loff_t x=size;
  do {
    digit=abs(x%10);
    x/=10;
    buffer[i++]='0'+digit;
  } while(x!=0);
  if(size<0) buffer[i++]='-';
  // now reverse the buffer for human readable
  for(j=0;j<(i/2);j++) {
    digit=buffer[i-1-j];
    buffer[i-1-j]=buffer[j];
    buffer[j]=digit;
  }
  return i;
}

int MakeLong2NiceStr(char *buffer,loff_t size)
{
  int s=LongSize(size);
  char ch;
  int l,i,pos;
  // first write the normal str into buf
  l=WriteLong2Str(buffer,size);
  // start at the right of needed room (the lowest number)
  pos=s-1;
  // for all chars in the normal str
  for(i=0;i<l;i++) {
    // save the char
    ch=buffer[l-1-i];
    // when overtaking the thousand/million/billion number write a "."
    // into the dest
    // this will NOT overwrite any important information because
    // 1.we saved the ch we will write
    // 2.at the end we will be at pos 0 (pos starts at s-1)
    //   and if we have all points written, we will overtake the ch
    if(((i==3)||(i==6)||(i==9))&&(isdigit(ch))) buffer[pos--]='.';
    buffer[pos--]=ch;
  }
  return s;
}

int LongSize(loff_t value)
{
  int size;
  loff_t x;
  x=value;
  size=1;
  
  if(value<0) {
    size++;
    if(x<-999) size++;
    if(x<-999999) size++;
    if(x<-999999999) size++;
    while(x<-9) {
      size++;
      x=x/10;
    }
  } else {
    if(x>999) size++;
    if(x>999999) size++;
    if(x>999999999) size++;
    while(x>9) {
      size++;
      x=x/10;
    }
  }
  return size;
}

char *catstring(const char *str1,const char *str2)
{
  char *tstr;
  tstr=(char*)_allocsafe(strlen(str1)+strlen(str2)+1);
  strcpy(tstr,str1);
  strcpy(tstr+strlen(str1),str2);
  return tstr;
}

char *shrinkstring(const char *str,int maxlen)
{
  int len=strlen(str),llen,rlen;
  char *newstr;
  if(len<=maxlen) return dupstring(str);
  if(maxlen>4) {
    newstr=(char*)_allocsafe(maxlen+1);
    llen=(maxlen-3)/2;
    rlen=maxlen-llen-3;
    strncpy( newstr, str, llen );
    strcpy( newstr + llen, "..." );
    strcpy( newstr + llen + 3, str + len - rlen );
  } else {
    newstr=dupstring(str);
    newstr[(maxlen>0)?maxlen:0]=0;
  }
  return newstr;
}
